<?php

defined('BASEPATH') or exit ('No direct script access allowed');

$this->ci->load->model('gdpr_model');
$this->ci->load->helper('staff_helper');
$this->ci->load->library('session');
$current_staff_role = get_current_staff_role($this->ci, get_staff_user_id());
$lockAfterConvert = get_option('lead_lock_after_convert_to_customer');
$has_permission_delete = has_permission('leads', '', 'delete');
$custom_fields = get_table_custom_fields('leads');
$consentLeads = get_option('gdpr_enable_consent_for_leads');
$statuses = $this->ci->leads_model->get_status();
$input_lender_data = $this->ci->input->post('lender');
$start_date = $this->ci->input->post('start_date');
$end_date = $this->ci->input->post('end_date');
$appinment_completed_by = $this->ci->input->post('appointment_completed_by');
$brokerage_filter = $this->ci->input->post('brokerage_filter');
$offer_in_out = $this->ci->input->post('offer_in_out');
$active_record = $this->ci->input->post('active_record');

// filter record using start and end date
$format_start_date = date('Y-m-d', strtotime($start_date));
$format_end_date = date('Y-m-d', strtotime($end_date));
$aColumns = [
    '1',
    db_prefix() . 'leads.id as id',
    'REVERSE(SUBSTRING_INDEX(REVERSE(TRIM(' . db_prefix() . 'leads.name)), " ", 1)) as sort_lastname',
    db_prefix() . 'leads.name as name',
];
if (is_gdpr() && $consentLeads == '1') {
    $aColumns[] = '1';
}
$aColumns = array_merge($aColumns, [
    db_prefix() . 'leads.email as email',
    db_prefix() . 'leads.phonenumber as phonenumber',
    db_prefix() . 'leads.status as status',
    'assign_group',
    db_prefix() . 'leads_status.name as status_name',
    'lastcontact',
    'dateadded',
    db_prefix() . 'leads.file_opened_completed_at as file_opened_completed_at',
    db_prefix() . 'leads.id_verification_completed_at as id_verification_completed_at',
    db_prefix() . 'leads.ins_received_completed_at as ins_received_completed_at',
    db_prefix() . 'leads.idv_pass as idv_pass',
    db_prefix() . 'leads.ins_in as ins_in',
    db_prefix() . 'leads.active_case as active_case',
]);

$sIndexColumn = 'id';
$sTable = db_prefix() . 'leads';
if ($this->ci->input->post('start_date') && $this->ci->input->post('end_date')) {
    // total number of file closed and file opened in a given time frame
    $total_file_closed_timeframe = file_closed_in_a_given_time_frame($this->ci, $format_start_date, $format_end_date);
    if (!empty ($total_file_closed_timeframe)) {
        $record = array('total_file_closed_timeframe' => $total_file_closed_timeframe);
    } else {
        $record = array('total_file_closed_timeframe' => 0);
    }
    $total_file_opened_timeframe = file_opened_in_a_given_time_frame($this->ci, $format_start_date, $format_end_date);
    if (!empty ($total_file_opened_timeframe)) {
        $record = array('total_file_opened_timeframe' => $total_file_opened_timeframe);
    } else {
        $record = array('total_file_opened_timeframe' => 0);
    }
    $this->ci->session->set_userdata($record);
}
if ($this->ci->input->post('start_date') && $this->ci->input->post('end_date') && !empty ($input_lender_data)) {
    // for lender to get record using specific time period
    $join = [
        'LEFT JOIN ' . db_prefix() . 'staff ON ' . db_prefix() . 'staff.staffid = ' . db_prefix() . 'leads.assigned',
        'LEFT JOIN ' . db_prefix() . 'leads_status ON ' . db_prefix() . 'leads_status.id = ' . db_prefix() . 'leads.status',
        'JOIN ' . db_prefix() . 'leads_sources ON ' . db_prefix() . 'leads_sources.id = ' . db_prefix() . 'leads.source',
        'JOIN ' . db_prefix() . 'instruction ON ' . db_prefix() . 'instruction.lead_id = ' . db_prefix() . 'leads.id AND ' . db_prefix() . 'instruction.bank_name="' . $input_lender_data . '" AND ' . db_prefix() . 'instruction.created_at BETWEEN \'' . $format_start_date . '\' AND \'' . $format_end_date . '\'',
        // 'WHERE ' . db_prefix() . 'instruction.bank_name=' . $input_lender_data,
    ];
    // Add the additional condition to the last element of $join array
    // $join[count($join) - 1] .= ' AND ' . db_prefix() . 'instruction.date_added BETWEEN \'' . $format_start_date . '\' AND \'' . $format_end_date . '\'';    

} elseif (!empty ($input_lender_data)) {
    $join = [
        'LEFT JOIN ' . db_prefix() . 'staff ON ' . db_prefix() . 'staff.staffid = ' . db_prefix() . 'leads.assigned',
        'LEFT JOIN ' . db_prefix() . 'leads_status ON ' . db_prefix() . 'leads_status.id = ' . db_prefix() . 'leads.status',
        'JOIN ' . db_prefix() . 'leads_sources ON ' . db_prefix() . 'leads_sources.id = ' . db_prefix() . 'leads.source',
        'JOIN ' . db_prefix() . 'instruction ON ' . db_prefix() . 'instruction.lead_id = ' . db_prefix() . 'leads.id AND ' . db_prefix() . 'instruction.bank_name="' . $input_lender_data . '"',
        // 'WHERE ' . db_prefix() . 'instruction.bank_name=' . $input_lender_data,
    ];
    // set the seesion and save record in session
    $lender_data = total_file_with_a_particular_lender($this->ci, $input_lender_data);
    if (!empty ($lender_data)) {
        $record = array('lender_data' => $lender_data);
    } else {
        $record = array('lender_data' => 0);
    }
    $this->ci->session->set_userdata($record);
} elseif ($this->ci->input->post('start_date') && $this->ci->input->post('end_date') && !empty ($appinment_completed_by)) {
    $join = [
        'LEFT JOIN ' . db_prefix() . 'staff ON ' . db_prefix() . 'staff.staffid = ' . db_prefix() . 'leads.assigned',
        'LEFT JOIN ' . db_prefix() . 'leads_status ON ' . db_prefix() . 'leads_status.id = ' . db_prefix() . 'leads.status',
        'JOIN ' . db_prefix() . 'leads_sources ON ' . db_prefix() . 'leads_sources.id = ' . db_prefix() . 'leads.source',
        'JOIN ' . db_prefix() . 'reminders ON ' . db_prefix() . 'reminders.rel_id = ' . db_prefix() . 'leads.id AND ' . db_prefix() . 'reminders.staff="' . $appinment_completed_by . '" AND ' . db_prefix() . 'reminders.date BETWEEN \'' . $format_start_date . '\' AND \'' . $format_end_date . '\'',
    ];
    // completed appointment by
    $total_completed_appintment = total_number_of_appointment_completed_by($this->ci, $appinment_completed_by);
    if (!empty ($total_completed_appintment)) {
        $record = array('total_completed_appintment' => $total_completed_appintment);
    } else {
        $record = array('total_completed_appintment' => 0);
    }
    $this->ci->session->set_userdata($record);
} elseif (!empty ($appinment_completed_by)) {
    $join = [
        'LEFT JOIN ' . db_prefix() . 'staff ON ' . db_prefix() . 'staff.staffid = ' . db_prefix() . 'leads.assigned',
        'LEFT JOIN ' . db_prefix() . 'leads_status ON ' . db_prefix() . 'leads_status.id = ' . db_prefix() . 'leads.status',
        'JOIN ' . db_prefix() . 'leads_sources ON ' . db_prefix() . 'leads_sources.id = ' . db_prefix() . 'leads.source',
        'JOIN ' . db_prefix() . 'reminders ON ' . db_prefix() . 'reminders.rel_id = ' . db_prefix() . 'leads.id AND ' . db_prefix() . 'reminders.staff="' . $appinment_completed_by . '"',
    ];
    // completed appointment by
    $total_completed_appintment = total_number_of_appointment_completed_by($this->ci, $appinment_completed_by);
    if (!empty ($total_completed_appintment)) {
        $record = array('total_completed_appintment' => $total_completed_appintment);
    } else {
        $record = array('total_completed_appintment' => 0);
    }
    $this->ci->session->set_userdata($record);
} else if ($this->ci->input->post('start_date') && $this->ci->input->post('end_date') && empty ($input_lender_data) && empty ($appinment_completed_by)) {
    $join = [
        'LEFT JOIN ' . db_prefix() . 'staff ON ' . db_prefix() . 'staff.staffid = ' . db_prefix() . 'leads.assigned',
        'LEFT JOIN ' . db_prefix() . 'leads_status ON ' . db_prefix() . 'leads_status.id = ' . db_prefix() . 'leads.status',
        // 'LEFT JOIN ' . db_prefix() . 'instruction ON ' . db_prefix() . 'instruction.lead_id = ' . db_prefix() . 'leads.id',
        'JOIN ' . db_prefix() . 'leads_sources ON ' . db_prefix() . 'leads_sources.id = ' . db_prefix() . 'leads.source',
        // 'WHERE ' . db_prefix() . 'leads.dateadded BETWEEN \'' . $format_start_date . '\' AND \'' . $format_end_date . '\''
    ];
} else {
    // this line of code is already exit before changing
    $join = [
        'LEFT JOIN ' . db_prefix() . 'staff ON ' . db_prefix() . 'staff.staffid = ' . db_prefix() . 'leads.assigned',
        'LEFT JOIN ' . db_prefix() . 'leads_status ON ' . db_prefix() . 'leads_status.id = ' . db_prefix() . 'leads.status',
        'JOIN ' . db_prefix() . 'leads_sources ON ' . db_prefix() . 'leads_sources.id = ' . db_prefix() . 'leads.source',
    ];
}
foreach ($custom_fields as $key => $field) {
    $selectAs = (is_cf_date($field) ? 'date_picker_cvalue_' . $key : 'cvalue_' . $key);
    array_push($customFieldsColumns, $selectAs);
    array_push($aColumns, 'ctable_' . $key . '.value as ' . $selectAs);
    array_push($join, 'LEFT JOIN ' . db_prefix() . 'customfieldsvalues as ctable_' . $key . ' ON ' . db_prefix() . 'leads.id = ctable_' . $key . '.relid AND ctable_' . $key . '.fieldto="' . $field['fieldto'] . '" AND ctable_' . $key . '.fieldid=' . $field['id']);
}

$where = [];
$filter = false;

if ($this->ci->input->post('custom_view')) {
    $filter = $this->ci->input->post('custom_view');
    if ($filter == 'lost') {
        array_push($where, 'AND lost = 1');
    } elseif ($filter == 'junk') {
        array_push($where, 'AND junk = 1');
    } elseif ($filter == 'not_assigned') {
        array_push($where, 'AND assigned = 0');
    } elseif ($filter == 'contacted_today') {
        array_push($where, 'AND lastcontact LIKE "' . date('Y-m-d') . '%"');
    } elseif ($filter == 'created_today') {
        array_push($where, 'AND dateadded LIKE "' . date('Y-m-d') . '%"');
    } elseif ($filter == 'public') {
        array_push($where, 'AND is_public = 1');
    } elseif (startsWith($filter, 'consent_')) {
        array_push($where, 'AND ' . db_prefix() . 'leads.id IN (SELECT lead_id FROM ' . db_prefix() . 'consents WHERE purpose_id=' . $this->ci->db->escape_str(strafter($filter, 'consent_')) . ' and action="opt-in" AND date IN (SELECT MAX(date) FROM ' . db_prefix() . 'consents WHERE purpose_id=' . $this->ci->db->escape_str(strafter($filter, 'consent_')) . ' AND lead_id=' . db_prefix() . 'leads.id))');
    }
}

if (!$filter || ($filter && $filter != 'lost' && $filter != 'junk')) {
    array_push($where, 'AND lost = 0 AND junk = 0');
}


if (has_permission('leads', '', 'view') && $this->ci->input->post('start_date') || $this->ci->input->post('end_date')) {
    // $where[] = "AND dateadded BETWEEN '" . $format_start_date . "' AND '" . $format_end_date . "'";
    // if only search by the start date 
    if($this->ci->input->post('start_date') && empty($this->ci->input->post('end_date'))){
        $where[] = "AND dateadded >= '" . $format_start_date . "'";
    }else{
        array_push($where, "AND dateadded BETWEEN '" . $format_start_date . "' AND '" . $format_end_date . "'");
    }
    // echo $this->ci->db->last_query();
    //     exit(print_r($where));
    if (has_permission('leads', '', 'view') && $this->ci->input->post('group_name')) {
        $group = '"' . $this->ci->input->post('group_name') . '"';
        // array_push($where, 'AND assign_group = ' . $group . " AND dateassigned BETWEEN '" . $format_start_date . "' AND '" . $format_end_date . "'");
        array_push($where, 'AND assign_group = ' . $group . "");
    }
    if (
        $this->ci->input->post('view_status_pipeline')
        && count($this->ci->input->post('view_status_pipeline')) > 0
        && ($filter != 'lost' && $filter != 'junk')
    ) {
        // array_push($where, 'AND status IN (' . implode(',', $this->ci->db->escape_str($this->ci->input->post('view_status_pipeline'))) . ') AND last_status_change BETWEEN \'' . $format_start_date . '\' AND \'' . $format_end_date . '\'');
        array_push($where, 'AND status IN (' . implode(',', $this->ci->db->escape_str($this->ci->input->post('view_status_pipeline'))) . ')');
    }
    if (
        $this->ci->input->post('broker_filter') &&
        is_array($this->ci->input->post('broker_filter')) &&
        count($this->ci->input->post('broker_filter')) > 0 &&
        ($filter != 'lost' && $filter != 'junk')
    ) {
        $brokerFilter = implode(',', array_map(array($this->ci->db, 'escape_str'), $this->ci->input->post('broker_filter')));
        array_push($where, 'AND addedfrom IN (' . $brokerFilter . ')');
    }
    if ($this->ci->input->post('ld_team')) {
        $ld_team = $this->ci->input->post('ld_team');
        if (is_array($ld_team) && count($ld_team) > 0) {
            $escaped_ld_team = array_map(function ($value) {
                return $this->ci->db->escape($value);
            }, $ld_team);
            $brokerFilter = implode(',', $escaped_ld_team);
            $where[] = 'AND assign_group IN (' . $brokerFilter . ')';
        }
    }
    if ($input_lender_data) {
        $lender = $this->ci->input->post('lender');
        if (is_array($lender) && count($lender) > 0) {
            $escaped_lender = array_map(function ($value) {
                return $this->ci->db->escape($value);
            }, $lender);
            $lenderFilter = implode(',', $escaped_lender);
            $where[] = 'AND client_id IN (' . $lenderFilter . ')';
        }
    }
    if ($this->ci->input->post('brokerage_filter')) {
        array_push($where, 'AND brokerage_id IN (' . implode(',', $this->ci->db->escape_str($this->ci->input->post('brokerage_filter'))) . ')');
    } 
    if ($offer_in_out  && ($filter != 'lost' && $filter != 'junk')) {
        foreach ($offer_in_out as $option) {
            if ($option == 'ids_not_completed') {
                array_push($where, 'AND file_opened_completed_at IS NULL');
            }
            if ($option == 'ids_completed') {
                array_push($where, 'AND file_opened_completed_at IS NOT NULL');
            }
            if ($option == 'idv_in') {
                array_push($where, "AND idv_pass = '1'");
            }
            if ($option == 'idv_not_in') {
                array_push($where, "AND idv_pass = '0'  AND id_verification_completed_at IS NULL");
            }
            if ($option == 'ins_in') {
                array_push($where, "AND ins_in = '1'");
            }
        }
    } 
} else {
    if (has_permission('leads', '', 'view') && $this->ci->input->post('assigned')) {
        $group = '"' . $this->ci->input->post('assigned') . '"';
        array_push($where, 'AND assign_group = ' . $group);
    }
    if (
        $this->ci->input->post('status')
        && count($this->ci->input->post('status')) > 0
        && ($filter != 'lost' && $filter != 'junk')
    ) {
        array_push($where, 'AND status IN (' . implode(',', $this->ci->db->escape_str($this->ci->input->post('status'))) . ')');
    }

    if ($this->ci->input->post('source')) {
        array_push($where, 'AND source =' . $this->ci->db->escape_str($this->ci->input->post('source')));
    }
    // with out starting and end date fileter 
    if (has_permission('leads', '', 'view') && $this->ci->input->post('group_name')) {
        $group = '"' . $this->ci->input->post('group_name') . '"';
        array_push($where, 'AND assign_group = ' . $group);
    } if (
        $this->ci->input->post('view_status_pipeline')
        && count($this->ci->input->post('view_status_pipeline')) > 0
        && ($filter != 'lost' && $filter != 'junk')
    ) {
        array_push($where, 'AND status IN (' . implode(',', $this->ci->db->escape_str($this->ci->input->post('view_status_pipeline'))) . ')');
    } if (
        $this->ci->input->post('broker_filter') &&
        is_array($this->ci->input->post('broker_filter')) &&
        count($this->ci->input->post('broker_filter')) > 0 &&
        ($filter != 'lost' && $filter != 'junk')
    ) {
        $brokerFilter = implode(',', array_map(array($this->ci->db, 'escape_str'), $this->ci->input->post('broker_filter')));
        array_push($where, 'AND addedfrom IN (' . $brokerFilter . ')');
    } if ($this->ci->input->post('ld_team')) {
        $ld_team = $this->ci->input->post('ld_team');
        if (is_array($ld_team) && count($ld_team) > 0) {
            $escaped_ld_team = array_map(function ($value) {
                return $this->ci->db->escape($value);
            }, $ld_team);
            $brokerFilter = implode(',', $escaped_ld_team);
            $where[] = 'AND assign_group IN (' . $brokerFilter . ')';
        }
    } if ($input_lender_data) {
        $lender = $this->ci->input->post('lender');
        if (is_array($lender) && count($lender) > 0) {
            $escaped_lender = array_map(function ($value) {
                return $this->ci->db->escape($value);
            }, $lender);
            $lenderFilter = implode(',', $escaped_lender);
            $where[] = 'AND client_id IN (' . $lenderFilter . ')';
        }
    }
    if ($this->ci->input->post('brokerage_filter')) {
        array_push($where, 'AND brokerage_id IN (' . implode(',', $this->ci->db->escape_str($this->ci->input->post('brokerage_filter'))) . ')');
    } 
    if ($offer_in_out  && ($filter != 'lost' && $filter != 'junk')) {
        foreach ($offer_in_out as $option) {
            if ($option == 'ids_not_completed') {
                array_push($where, 'AND file_opened_completed_at IS NULL AND status IN (1)');
                // array_push($where, 'AND leads.status = 1');
            }
            if ($option == 'ids_completed') {
                array_push($where, 'AND file_opened_completed_at IS NOT NULL AND status NOT IN (1)');
                // array_push($where, 'AND leads.status != 1');
            }
            if ($option == 'idv_in') {
                // array_push($where, "AND idv_pass = '1' AND id_verification_completed_at IS NOT NULL");
                array_push($where, "AND id_verification_completed_at IS NOT NULL AND status IN (2,3,4,5,6,7,9)");
            }
            if ($option == 'idv_not_in') {
                array_push($where, "AND idv_pass = '0' AND id_verification_completed_at IS NULL AND status IN (1, 8)");
            }
            if ($option == 'ins_in') {
                array_push($where, "AND ins_in = '1'");
            }
        }
    } 
    // Active and no Active case filter 
    if (!empty($active_record)  && ($filter != 'lost' && $filter != 'junk')) {
        if ($active_record == "active") {
            array_push($where, 'AND active_case = "Active"');
        }
        if ($active_record == "closed") {
        
            array_push($where, "AND active_case = 'Closed'");
        }
    }
}


if ($current_staff_role == 2) { // broker 
    // array_push($where, 'AND (addedfrom =' . get_broker_agent_staffid($this->ci, get_staff_user_id()) . ')');
    array_push($where, 'AND FIND_IN_SET(' . get_broker_agent_staffid($this->ci, get_staff_user_id()) . ', addedfrom) > 0');

}
if ($current_staff_role == 6) { // Admin broker 
    // array_push($where, 'AND (addedfrom =' . get_broker_agent_staffid($this->ci, get_staff_user_id()) . ')');
    array_push($where, 'AND FIND_IN_SET(' . get_current_staff_brokerage_id($this->ci, get_staff_user_id()) . ', brokerage_id) > 0');

}

$aColumns = hooks()->apply_filters('leads_table_sql_columns', $aColumns);

// Fix for big queries. Some hosting have max_join_limit
if (count($custom_fields) > 4) {
    @$this->ci->db->query('SET SQL_BIG_SELECTS=1');
}
if ($current_staff_role == 2) { 
    // $additionalColumns = hooks()->apply_filters('leads_table_additional_columns_sql', [
    //     'junk',
    //     'lost',
    //     'color',
    //     'status',
    //     'assigned',
    //     'multiple_cases',
    //     'lastname as assigned_lastname',
    //     db_prefix() . 'leads.addedfrom as addedfrom',
    //     '(SELECT count(leadid) FROM ' . db_prefix() . 'clients WHERE ' . db_prefix() . 'clients.leadid=' . db_prefix() . 'leads.id) as is_converted',
    //     'zip',
    //     '(CASE WHEN ' . db_prefix() . 'leads.addedfrom = ' . get_broker_agent_staffid($this->ci, get_staff_user_id()) . ' THEN 1 ELSE 0 END) as added_from_current_user',
    // ]);
    $additionalColumns = hooks()->apply_filters('leads_table_additional_columns_sql', [
        'junk',
        'lost',
        'color',
        'status',
        'assigned',
        'multiple_cases',
        'file_opened_completed_at as file_opened_completed_at',
        'id_verification_completed_at as id_verification_completed_at',
        'ins_received_completed_at as ins_received_completed_at',
        'idv_pass as idv_pass',
        'ins_in as ins_in',
        'active_case as active_case',
        'lastname as assigned_lastname',
        db_prefix() . 'leads.addedfrom as addedfrom',
        '(SELECT count(leadid) FROM ' . db_prefix() . 'clients WHERE ' . db_prefix() . 'clients.leadid=' . db_prefix() . 'leads.id) as is_converted',
        'zip',
        '(CASE WHEN FIND_IN_SET(' . get_staff_user_id() . ', ' . db_prefix() . 'leads.addedfrom) > 0 THEN 1 ELSE 0 END) as added_from_current_user',
    ]);
    
    
}else if(get_current_staff_role($this->ci, get_staff_user_id()) == 6){
    $additionalColumns = hooks()->apply_filters('leads_table_additional_columns_sql', [
        'junk',
        'lost',
        'color',
        'status',
        'assigned',
        'multiple_cases',
        'status',
        'file_opened_completed_at as file_opened_completed_at',
        'id_verification_completed_at as id_verification_completed_at',
        'ins_received_completed_at as ins_received_completed_at',
        'idv_pass as idv_pass',
        'ins_in as ins_in',
        'active_case as active_case',
        'lastname as assigned_lastname',
        db_prefix() . 'leads.addedfrom as addedfrom',
        '(SELECT count(leadid) FROM ' . db_prefix() . 'clients WHERE ' . db_prefix() . 'clients.leadid=' . db_prefix() . 'leads.id) as is_converted',
        'zip',
        '(CASE WHEN FIND_IN_SET(' . get_current_staff_brokerage_id($this->ci, get_staff_user_id()) . ', ' . db_prefix() . 'leads.brokerage_id) > 0 THEN 1 ELSE 0 END) as added_from_current_user',
    ]);
}else{
    $additionalColumns = hooks()->apply_filters('leads_table_additional_columns_sql', [
        'junk',
        'lost',
        'color',
        'status',
        'assigned',
        'multiple_cases',
        'status',
        'file_opened_completed_at as file_opened_completed_at',
        'id_verification_completed_at as id_verification_completed_at',
        'ins_received_completed_at as ins_received_completed_at',
        'idv_pass as idv_pass',
        'ins_in as ins_in',
        'active_case as active_case',
        'lastname as assigned_lastname',
        db_prefix() . 'leads.addedfrom as addedfrom',
        '(SELECT count(leadid) FROM ' . db_prefix() . 'clients WHERE ' . db_prefix() . 'clients.leadid=' . db_prefix() . 'leads.id) as is_converted',
        'zip',
    ]);
}
// echo $this->ci->db->last_query();
// exit(print_r($where));
// print_r($where);
$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, $additionalColumns);

$output = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];
    // group match check 
    // $staff_group_name = get_group_name_of_staff($this->ci, get_staff_user_id());
    // if (empty(is_admin())) {
    //     if ($staff_group_name == $aRow['assign_group']) {
    //         $samegroup = true;
    //     } else {
    //         $samegroup = false;
    //     }
    // } else {
    //     $samegroup = true;
    // }
    if (empty (is_admin())) {
        if (get_current_staff_role($this->ci, get_staff_user_id()) == 2 || get_current_staff_role($this->ci, get_staff_user_id()) == 6) {
            $samegroup = false;
        } else {
            if ($staff_group_name == $aRow['assign_group']) {
                $samegroup = true;
            } else {
                $samegroup = false;
            }
        }
    } else {
        $samegroup = true;
    }
    
    // $nameParts = explode(' ', $aRow['name']);
    // if (count($nameParts) >= 2) {
    //     $firstName = array_shift($nameParts);
    //     $lastName = implode(' ', $nameParts); 
    //     $formattedName = $lastName . ', ' . $firstName;
    // } else {
    //     $formattedName = $aRow['name']; 
    // }
    $primary_name = explode(' ', $aRow['name'], 3);
    $firstName = $primary_name[0] ?? '';
    $middlename = $primary_name[1] ?? '';
    $lastName = $primary_name[2] ?? '';
    if($primary_name[2] != null){
        $formattedName = $lastName . ', ' . $firstName . ' ' . $middlename;
    }else{
        $formattedName = $middlename . ', ' . $firstName;
    }
    $row[] = '<div class="checkbox"><input type="checkbox" id="bulk_checkbox" value="' . $aRow['id'] . '"><label></label></div>';

    $hrefAttr = 'href="' . admin_url('leads/index/' . $aRow['id']) . '" onclick="init_lead(' . $aRow['id'] . ');return false;"';
    $row[] = '<a ' . $hrefAttr . '>' . $aRow['id'] . '</a>';

    $nameRow = '<a ' . $hrefAttr . '>' . $formattedName . '</a>';

    $nameRow .= '<div class="row-options">';
    $nameRow .= '<a ' . $hrefAttr . '>' . _l('view') . '</a>';

    $locked = false;

    if ($aRow['is_converted'] > 0) {
        $locked = ((!is_admin() && $lockAfterConvert == 1) ? true : false);
    }
    if ($samegroup) {
        if (!$locked) {
            $nameRow .= ' | <a class="edit-lead-link" data-id="' . $aRow['id'] . '" href="' . admin_url('leads/index/' . $aRow['id'] . '?edit=true') . '" onclick="init_lead(' . $aRow['id'] . ', true);return false;">' . _l('edit') . '</a>';
        }

        if ($aRow['addedfrom'] == get_staff_user_id() || $has_permission_delete) {
            if ($aRow['multiple_cases'] != 0) {
                $nameRow .= ' | <a href="' . admin_url('leads/delete/' . $aRow['id']) . '" class="_delete text-danger">' . _l('delete') . '</a>';
            }
        }
    }
    $nameRow .= '</div>';


    $row[] = $nameRow;

    if (is_gdpr() && $consentLeads == '1') {
        $consentHTML = '<p class="bold"><a href="#" onclick="view_lead_consent(' . $aRow['id'] . '); return false;">' . _l('view_consent') . '</a></p>';
        $consents = $this->ci->gdpr_model->get_consent_purposes($aRow['id'], 'lead');

        foreach ($consents as $consent) {
            $consentHTML .= '<p style="margin-bottom:0px;">' . $consent['name'] . (!empty ($consent['consent_given']) ? '<i class="fa fa-check text-success pull-right"></i>' : '<i class="fa fa-remove text-danger pull-right"></i>') . '</p>';
        }
        $row[] = $consentHTML;
    }

    $row[] = ($aRow['email'] != '' ? '<a href="mailto:' . $aRow['email'] . '">' . $aRow['email'] . '</a>' : '');

    $row[] = ($aRow['phonenumber'] != '' ? '<a href="tel:' . formatted_number($aRow['phonenumber']) . '">' . formatted_number($aRow['phonenumber']) . '</a>' : '');

    $base_currency = get_base_currency();

    $assignedOutput = '';
    // if ($aRow['assigned'] != 0) {
    //     $full_name = $aRow['assigned_firstname'] . ' ' . $aRow['assigned_lastname'];

    //     $assignedOutput = '<a data-toggle="tooltip" data-title="' . $full_name . '" href="' . admin_url('profile/' . $aRow['assigned']) . '">' . staff_profile_image($aRow['assigned'], [
    //         'staff-profile-image-small',
    //         ]) . '</a>';

    //     // For exporting
    //     $assignedOutput .= '<span class="hide">' . $full_name . '</span>';
    // }
    // get group names
    if ($aRow['assign_group']) {
        $full_name = $aRow['assign_group'];
        $staff_names_by_group = get_all_staff_name_by_groups($this->ci, $full_name);
        $tooltip_content = htmlspecialchars(json_encode($staff_names_by_group), ENT_QUOTES, 'UTF-8');
        $assignedOutput = '<a data-toggle="tooltip" data-title="' . $tooltip_content . '" href="' . $aRow['assigned'] . '">' . $full_name . '</a>';
        // $assignedOutput .= '<span class="hide">' . $full_name . '</span>';
    }

    $row[] = $assignedOutput;
    if($aRow['active_case'] == 'Active'){
        $active_case = '<span class="label label-success">Active</span>';
    }else if($aRow['active_case'] == 'Closed'){
        $active_case = '<span class="label label-danger">Closed</span>';
    }else{
        $active_case = '<span class="label label-default">-</span>';
    }
    $row[] = $active_case;

    // if ($aRow['status']) {
    //     if ($aRow['status'] == 1 && $aRow['file_opened_completed_at'] != null) {
    //         $ids_status = 'ID Complete';
    //         $bg_color = '';
    //         $color = '';
    //     } elseif ($aRow['status'] == 1 && $aRow['file_opened_completed_at'] == null) {
    //         $ids_status = 'ID Incomplete';
    //         $bg_color = '';
    //         $color = '';
    //     } elseif ($aRow['status'] == 8 && $aRow['id_verification_completed_at'] == null) {
    //         $ids_status = 'IDV Incompleted';
    //         $bg_color = '';
    //         $color = '';
    //     } elseif ($aRow['status'] == 8 && $aRow['id_verification_completed_at'] != null) {
    //         $ids_status = 'IDV Completed';
    //         $bg_color = '';
    //         $color = '';
    //     } elseif ($aRow['status'] == 2 && $aRow['ins_received_completed_at'] != null) {
    //         $ids_status = 'Inc/Offer';
    //         $bg_color = '#000000';
    //         $color = '';
    //     }  else {
    //         $ids_status = '-';
    //         $bg_color = '';
    //         $color = '';
    //     }
    //     $row[] = '<a data-toggle="tooltip" data-title="' . $tooltip_content . '" href="' . $aRow['assigned'] . '">' . $ids_status . '</a>';
    // }
    // if ($aRow['status_name'] == null) {
    //     if ($aRow['lost'] == 1) {
    //         $outputStatus = '<span class="label label-danger">' . _l('lead_lost') . '</span>';
    //     } elseif ($aRow['junk'] == 1) {
    //         $outputStatus = '<span class="label label-warning">' . _l('lead_junk') . '</span>';
    //     }
    // } else {
    //     $outputStatus = '<span class="lead-status-' . $aRow['status'] . ' label' . (empty ($aRow['color']) ? ' label-default' : '') . '" style="color:' . $aRow['color'] . ';border:1px solid ' . adjust_hex_brightness($aRow['color'], 0.4) . ';background: ' . adjust_hex_brightness($aRow['color'], 0.04) . ';">' . $aRow['status_name'];

    //     if (!$locked) {
    //         if ($samegroup) {
    //             $outputStatus .= '<div class="dropdown inline-block mleft5 table-export-exclude">';
    //             $outputStatus .= '<a href="#" style="font-size:14px;vertical-align:middle;" class="dropdown-toggle text-dark" id="tableLeadsStatus-' . $aRow['id'] . '" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">';
    //             $outputStatus .= '<span data-toggle="tooltip" title="' . _l('ticket_single_change_status') . '"><i class="fa-solid fa-chevron-down tw-opacity-70"></i></span>';
    //             $outputStatus .= '</a>';

    //             $outputStatus .= '<ul class="dropdown-menu dropdown-menu-right" aria-labelledby="tableLeadsStatus-' . $aRow['id'] . '">';
    //             foreach ($statuses as $leadChangeStatus) {
    //                 if ($aRow['status'] != $leadChangeStatus['id']) {
    //                     $outputStatus .= '<li>
    //               <a href="#" onclick="lead_mark_as(' . $leadChangeStatus['id'] . ',' . $aRow['id'] . '); return false;">
    //                  ' . $leadChangeStatus['name'] . '
    //               </a>
    //            </li>';
    //                 }
    //             }
    //             $outputStatus .= '</ul>';
    //             $outputStatus .= '</div>';
    //         }
    //     }
    //     $outputStatus .= '</span>';
    // }
    if ($aRow['status_name'] == null) {
        if ($aRow['lost'] == 1) {
            $outputStatus = '<span class="label label-danger">' . _l('lead_lost') . '</span>';
        } elseif ($aRow['junk'] == 1) {
            $outputStatus = '<span class="label label-warning">' . _l('lead_junk') . '</span>';
        }
    } else {
        // $outputStatus .= '<p>' . $leadChangeStatus['name'] . '</p>';
        $outputStatus = '<span class="lead-status-' . $aRow['status'] . ' label' . (empty ($aRow['color']) ? ' label-default' : '') . '" style="color:' . $aRow['color'] . ';border:1px solid ' . adjust_hex_brightness($aRow['color'], 0.4) . ';background: ' . adjust_hex_brightness($aRow['color'], 0.04) . ';">' . $aRow['status_name'];
    }
    $row[] = $outputStatus;

    $row[] = ($aRow['lastcontact'] == '0000-00-00 00:00:00' || !is_date($aRow['lastcontact']) ? '' : '<span data-toggle="tooltip" data-title="' . time_ago($aRow['lastcontact']) . '" class="text-has-action is-date">' . _dt($aRow['lastcontact']) . '</span>');

    $row[] = '<span data-toggle="tooltip" data-title="' . time_ago($aRow['dateadded']) . '" class="text-has-action is-date">' . _dt($aRow['dateadded']) . '</span>';

    // Custom fields add values
    foreach ($customFieldsColumns as $customFieldColumn) {
        $row[] = (strpos($customFieldColumn, 'date_picker_') !== false ? _d($aRow[$customFieldColumn]) : $aRow[$customFieldColumn]);
    }

    $row['DT_RowId'] = 'lead_' . $aRow['id'];

    if ($aRow['assigned'] == get_staff_user_id()) {
        $row['DT_RowClass'] = 'info';
    }

    if (isset ($row['DT_RowClass'])) {
        $row['DT_RowClass'] .= ' has-row-options';
    } else {
        $row['DT_RowClass'] = 'has-row-options';
    }

    $row = hooks()->apply_filters('leads_table_row_data', $row, $aRow);

    $output['aaData'][] = $row;
}