<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s panel-table-full">
                    <div class="panel-body">
                        <div class="clearfix"></div>
                        <div class="col-md-6">
                            <?php if (empty($checkbox_data)) { ?>
                                <?php echo form_open((admin_url('cases/add_checkboxes')), ['id' => 'myForm']); ?>
                                    <div class='form-group' app-field-wrapper='doc_type'>
                                        <label for='outstanding list' class='control-label'>Enter checkboxes title</label>
                                        <input type="text" class="form-control" id="checkbox_title" name="checkbox_title">
                                        <b>
                                            <div class="invalid-feedback" id="checkbox_title_error" style="color:red;margin-top:4px;"></div>
                                        </b>
                                    </div>
                                    <div>
                                        <?php echo render_select('leads_status', $leads_status, ['id', ['name']], 'Select status', '', ['data-width' => '100%', 'required'], [], 'no-mbot');?>
                                        <b>
                                            <div class="invalid-feedback" id="leads_status_error" style="color:red;margin-top:4px;"></div>
                                        </b>
                                    </div>
                                    <div style="margin-top:15px;">
                                        <?php echo render_textarea('checkbox_description', 'Checkbox Description', '', array('placeholder' => 'Please enter the checkbox description')); ?>  
                                    </div>
                                    <div class="col-md-12">
                                        <input type="submit" class="btn btn-primary" id="submitButton" style="margin-top: 10px; float:right;">
                                    </div>
                                <?php echo form_close(); ?>
                            <?php
                            } else { ?>
                                <?php echo form_open((admin_url('cases/add_checkboxes')), ['id' => 'edit_myForm']); ?>
                                <input type="hidden" id="checkbox_id" name="checkbox_id" value="<?php echo $checkbox_data->id?>">
                                    <div class='form-group' app-field-wrapper='doc_type'>
                                        <label for='outstanding list' class='control-label'>Enter checkboxes title</label>
                                        <input type="text" class="form-control" id="checkbox_title" name="checkbox_title" value="<?php echo $checkbox_data->title?>">
                                        <b>
                                            <div class="invalid-feedback" id="checkbox_title_error" style="color:red;margin-top:4px;"></div>
                                        </b>
                                    </div>
                                    <div>
                                        <?php $selected = $checkbox_data->leads_status;?>
                                        <?php echo render_select('leads_status', $leads_status, ['id', ['name']], 'Select status', $selected, ['data-width' => '100%', 'required'], [], 'no-mbot');?>
                                        <b>
                                            <div class="invalid-feedback" id="leads_status_error" style="color:red;margin-top:4px;"></div>
                                        </b>
                                    </div>
                                    <div style="margin-top:15px;">
                                    <?php $description = $checkbox_data->description;?>
                                        <?php echo render_textarea('checkbox_description', 'Checkbox Description', $description, array('placeholder' => 'Please enter the checkbox description')); ?>  
                                    </div>
                                    <div class="col-md-12">
                                        <button type="submit" class="btn btn-primary" id="submitButton" style="margin-top: 10px; float:right;">Update</button>
                                    </div>
                                <?php echo form_close(); ?>
                            <?php } ?>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-leads customizable-table number-index-2 dataTable no-footer">
                                <thead>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Status</th>
                                    <th style="">Action</th>
                                </thead>
                                <tbody id="checkbox_lists">
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
    $(document).ready(function () {
        // Load states when the page loads
        loadStates();
        $('#myForm').submit(function (event) {
            event.preventDefault();
            $('.invalid-feedback').empty();
            var formData = $(this).serialize();
            $.ajax({
                type: 'POST',
                url: '<?php echo base_url('admin/cases/add_checkboxes'); ?>',
                data: formData,
                dataType: 'json',
                success: function (response) {
                    if (response.status === 'error') {
                        if (response.field === 'checkbox_title') {
                            $('#checkbox_title_error').text(response.message);
                        } else if (response.field === 'leads_status') {
                            $('#leads_status_error').text(response.message);
                        }
                    } else {
                        $('#myForm')[0].reset();
                        loadStates();
                        alert_float('success', 'Checkbox added successfully.');
                    }
                },
                error: function (xhr, status, error) {
                    console.log('Error fetching data');
                }
            });
        });

        // edit form valitdtion
        $('#edit_myForm').submit(function (event) {
            event.preventDefault();
            $('.invalid-feedback').empty();
            var formData = $(this).serialize();
            $.ajax({
                type: 'POST',
                url: '<?php echo base_url('admin/cases/add_checkboxes'); ?>',
                data: formData,
                dataType: 'json',
                success: function (response) {
                    if (response.status === 'error') {
                        $('.invalid-feedback').text(response.message);
                    } else {
                        loadStates();
                        alert_float('success', 'Checkboxes updated successfully.');
                    }
                },
                error: function (xhr, status, error) {
                    console.log('Error fetching data');
                }
            });
        });

        // Function to load states using AJAX
        function loadStates() {
            $.ajax({
                type: 'GET',
                url: '<?php echo base_url('admin/cases/show_all_checkboxes'); ?>',
                dataType: 'json',
                success: function (response) {
                    $('#checkbox_lists').empty();
                    $.each(response, function (index, state) {
                        var newRow = $('<tr>');
                        newRow.append('<td>' + state.title + '</td>');
                        newRow.append('<td>' + state.description + '</td>');
                        newRow.append('<td>' + state.status_name + '</td>');
                        var actionColumn = $('<td>');
                        actionColumn.append('<a href="<?php echo base_url('/admin/cases/checkboxes/') ?>' + state.id + '" class="btn btn-primary edit-record">Edit</a>');
                        actionColumn.append('<button data-id="' + state.id + '" class="btn btn-danger delete-btn" style="margin-left:5px;">Delete</button>');
                        newRow.append(actionColumn);
                        $('#checkbox_lists').append(newRow);
                    });
                },
                error: function (xhr, status, error) {
                    console.log('Error fetching data');
                }
            });

        }
    });
    // delete the state data
    $(document).on('click', '.delete-btn', function () {
        var stateId = $(this).data('id');
        var row = $(this).closest('tr');
        if (confirm("Are you sure you want to delete this record?")) {
            $.ajax({
                type: 'POST',
                url: '<?php echo base_url('admin/cases/delete_checkbox'); ?>',
                data: { id: stateId },
                dataType: 'json',
                success: function (response) {
                    if (response.status == 'success') {
                        row.fadeOut(400, function () {
                            $(this).remove();
                        });
                        alert_float('success', 'Record deleted successfully.');
                    } else {
                        alert_float('error', 'Failed to delete record!');
                    }
                },
                error: function (xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        }
    });


</script>
</body>

</html>