<?php if ($status['id'] != 7 && $status['id'] != 8) { ?>
<ul class="kan-ban-col" data-col-status-id="<?= $status['id']; ?>" data-total-pages="<?= $total_pages; ?>" data-total="<?= $total_leads; ?>">
    <li class="kan-ban-col-wrapper">
        <div class="border-right panel_s">
            <?php
            $status_color = !empty($status['color']) ? 'style="background:' . $status['color'] . ';border:1px solid ' . $status['color'] . '"' : '';
            ?>
            <div class="panel-heading tw-bg-neutral-700 tw-text-white"
                <?= $status['isdefault'] == 1 ? 'data-toggle="tooltip" data-title="' . _l('leads_converted_to_client') . ' - ' . _l('client') . '"' : '' ?>
                <?= $status_color; ?> data-status-id="<?= $status['id']; ?>">
                <i class="fa fa-reorder pointer"></i>
                <span class="heading pointer tw-ml-1" 
                    <?php if ($is_admin) { ?>
                        data-order="<?= $status['statusorder']; ?>" 
                        data-color="<?= $status['color']; ?>"
                        data-name="<?= $status['name']; ?>"
                        onclick="edit_status(this,<?= $status['id']; ?>); return false;"
                    <?php } ?>>
                    <?= $status['name']; ?>
                </span>
                <a href="#" onclick="return false;" class="pull-right color-white kanban-color-picker kanban-stage-color-picker<?= $status['isdefault'] == 1 ? ' kanban-stage-color-picker-last' : '' ?>" data-placement="bottom" data-toggle="popover" data-content="
                <div class='text-center'>
                    <button type='button' return false;' class='btn btn-primary btn-block mtop10 new-lead-from-status'>
                        <?= 'New Case'; ?>
                    </button>
                </div>
                <?php if (is_admin()) { ?>
                    <hr />
                    <div class='kan-ban-settings cpicker-wrapper'>
                        <?php
                            foreach (get_system_favourite_colors() as $color) {
                                $class = $color == $status['color'] ? 'cpicker-big' : 'cpicker-small';
                                echo "<div class='kanban-cpicker cpicker {$class}' data-color='{$color}' style='background:{$color};border:1px solid {$color}'></div>";
                            }
                        ?>
                    </div>
                <?php } ?>
                " data-html="true" data-trigger="focus">
                    <i class="fa fa-angle-down"></i>
                </a>
            </div>
            <div class="kan-ban-content-wrapper">
                <div class="kan-ban-content">
                    <ul class="status leads-status sortable" data-lead-status-id="<?= $status['id']; ?>">

                        <?php if ($status['id'] == 5) {
                            $this->load->view('admin/leads/Custom_Closed_daily_details__kanban_card', []);
                        } ?>

                        <?php foreach ($leads as $lead):
                            $lead_id = $lead['id'];
                            $lead_data = $leads_map[$lead_id] ?? null;
                            if (!$lead_data) continue;

                            $case_group_color = $groups_map[$lead_data['assign_group']] ?? '';
                            $brokerage = $brokerage_map[$lead_data['brokerage_id']] ?? [];

                            $first_transaction_id = explode(',', $bank_map[$lead_id]['transaction_id'] ?? '')[0] ?? null;
                            $transaction_name = $first_transaction_id ? ($transaction_map[$first_transaction_id] ?? '') : '';

                            $primary_name = explode(' ', $lead_data['name'], 3);
                            $firstname = $primary_name[0] ?? '';
                            $middlename = $primary_name[1] ?? '';
                            $lastname = $primary_name[2] ?? '';

                            $secondary_name = explode(' ', $lead_data['secondary_name'], 3);
                            $secondary_firstname = $secondary_name[0] ?? '';
                            $secondary_middlename = $secondary_name[1] ?? '';
                            $secondary_lastname = $secondary_name[2] ?? '';

                            $reminder_count = $reminder_map[$lead_id] ?? 0;
                            $notification_count = ($notification_map[$lead_id] ?? 0) + ($broker_notification_map[$lead_id] ?? 0);
                            
                            $task_count = $task_map[$lead_id] ?? 0;
                            $instructions_count = $instructions_map[$lead_id] ?? 0;

                            $this->load->view('admin/leads/_kan_ban_card', [
                                'lead' => $lead,
                                'name' => $lead_data['name'],
                                'active_case' => $lead_data['active_case'],
                                'firstname' => $firstname,
                                'middlename' => $middlename,
                                'lastname' => $lastname,
                                'secondary_firstname' => $secondary_firstname,
                                'secondary_middlename' => $secondary_middlename,
                                'secondary_lastname' => $secondary_lastname,
                                'status' => $lead_data['status'],
                                'base_currency' => $base_currency,
                                'leads_data' => $lead_data,
                                'case_group_color' => $case_group_color,
                                'brokerage_data' => $brokerage,
                                'transaction' => $transaction_name,
                                'reminder_count_check' => $reminder_count,
                                'staff_notification_count_check' => $notification_count,
                                'task_count' => $task_count,
                                'instructions_count' => $instructions_count,
                                'upload_doc' => $lead_data['upload_doc'],
                            ]);
                        endforeach; ?>

                        <?php if ($total_leads > 0) { ?>
                            <li class="text-center not-sortable kanban-load-more"
                                data-load-status="<?= $status['id']; ?>"
                                style="opacity: <?= ($total_pages <= 1 || $kanBan->getPage() === $total_pages) ? '0.3' : '1'; ?>">
                                <a href="#" class="btn btn-default btn-block<?= ($total_pages <= 1 || $kanBan->getPage() === $total_pages) ? ' disabled' : ''; ?>"
                                   data-page="<?= $kanBan->getPage(); ?>"
                                   onclick="kanban_load_more(<?= $status['id']; ?>, this, 'leads/leads_kanban_load_more', 315, 360); return false;">
                                    <?= _l('load_more'); ?>
                                </a>
                            </li>
                        <?php } ?>
                        <li class="text-center not-sortable mtop30 kanban-empty<?= ($total_leads > 0) ? ' hide' : ''; ?>">
                            <h4><i class="fa-solid fa-circle-notch" aria-hidden="true"></i><br><br>No Cases Found.</h4>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </li>
</ul>
<?php } ?>
