<?php
defined('BASEPATH') or exit('No direct script access allowed');
?>
<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta name="x-apple-disable-message-reformatting">
    <title></title>
    <!--[if mso]>
  <style>
    table {border-collapse:collapse;border-spacing:0;border:none;margin:0;}
    div, td {padding:0;}
    div {margin:0 !important;}
  </style>
  <noscript>
    <xml>
      <o:OfficeDocumentSettings>
        <o:PixelsPerInch>96</o:PixelsPerInch>
      </o:OfficeDocumentSettings>
    </xml>
  </noscript>
  <![endif]-->
    <style>
        table,
        td,
        div,
        h1,
        p {
            color: var(--Body, #333);
            font-family: Inter;
            font-size: 16px;
            font-style: normal;
            font-weight: 400;
            line-height: 30px;
        }

        .wrapper {
            background-color: #fff;
            max-width: 40em;
            margin: 0 auto;
            padding: 3em;

            /* General horizontal line styles */
            hr {
                margin-bottom: 2em;
            }
        }

        /* Basic horizontal line */
        .plain {
            background-color: rgba(0, 0, 0, 0.24);
            border: none;
            height: 3px;
            /* padding-top: 0px; */
            margin-top: 66px;
            width: 135px;
        }

        @media screen and (max-width: 530px) {
            .unsub {
                display: block;
                padding: 8px;
                margin-top: 14px;
                border-radius: 6px;
                background-color: #555555;
                text-decoration: none !important;
                font-weight: bold;
            }

            .col-lge {
                max-width: 100% !important;
            }
        }

        .client-details {
            margin-bottom: 20px;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        .client-title {
            font-weight: bold;
            margin-bottom: 5px;
        }

        .client-checklist {
            margin-left: 20px;
        }

        @media screen and (min-width: 531px) {
            .col-sml {
                max-width: 27% !important;
            }

            .col-lge {
                max-width: 73% !important;
            }
        }
    </style>
</head>

<body style="margin:0;padding:0;word-spacing:normal;background-color:#FAFCFD;">
    <div role="article" aria-roledescription="email" lang="en"
        style="text-size-adjust:100%;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#FAFCFD;">
        <table role="presentation" style="width:100%;border:none;border-spacing:0;">
            <tr>
                <td align="center" style="padding:0;">
                    <!--[if mso]>
          <table role="presentation" align="center" style="width:600px;">
          <tr>
          <td>
          <![endif]-->
                    <table role="presentation"
                        style="width:94%;max-width:600px;border:none;border-spacing:0;text-align:left;font-family:Arial,sans-serif;font-size:16px;line-height:22px;color:#363636;">
                        <tr>
                            <td style="padding: 85px 30px 30px 30px;text-align:center;font-size:24px;font-weight:bold;">
                                <a href="https://www.legaldirect.ca/" style="text-decoration:none;"><img
                                        src='<?php echo base_url('assets/Email_images/Ld_logo.png'); ?>' width="90"
                                        alt="Legal Direct"
                                        style="width:90px;max-width:80%;height:auto;border:none;text-decoration:none;color:#ffffff;"></a>
                                <h3 style="padding-bottom:20px;line-height:35.2px;"></h3>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding:30px 30px 0px 30px;background-color:#FFF;">
                                <!-- <p style="margin:0px;">Good <?= $_POST['get_afternoon_and_morning'] ?>,</p>
                                <p>Thank you for choosing Legal Direct for your transaction.</p>
                                <p> For your ease, convenience, and safety, where possible, we aim to provide advice on
                                    your
                                    transaction remotely and by video conference.</p>
                                <p>As per the 2024 Law Society of Ontario regulations, for all virtual appointments, we
                                    are
                                    now required to electronically AUTHENTICATE and also VERIFY your identification.</p>
                                <p>As per the 2024 Law Society of Ontario regulations, for all virtual appointments, we
                                    are
                                    now required to electronically AUTHENTICATE and also VERIFY your identification.</p>
                                <span style="font-weight:800;">PHOTO IDs:</span>
                                <ul style="list-style:unset;margin-left:28px;">
                                    <li>Please provide TWO Photo IDs from the Photo ID section.</li>
                                    <li>If you do not have two Photo IDs, please provide at least ONE Photo ID and ONE
                                        Secondary ID.</li>
                                    <li>All IDs MUST be in colour.</li>
                                    <li>Please ensure IDs show ALL edges, are CLEAR, have no flash spots, and are valid
                                        (NOT
                                        expired).</li>
                                </ul>
                                <span style="font-weight:800;">PAPER IDs:</span>
                                <ul style="list-style:unset;margin-left:28px;">
                                    <li>Please provide ONE FINANCIAL or UTILITY paper ID. These must each show your
                                        name,
                                        address and be issued within the last 90 days.</li>
                                </ul>
                                <p>We have received some IDs from your broker, and we are now only outstanding the
                                    following:</p>
                                <?php if (!empty($response_records)): ?>
                                    <?php foreach ($response_records as $client): ?>
                                        <div class="client-details">
                                            <div class="client-title" style="font-weight:800;"><?php echo $client['client']; ?>
                                            </div>
                                            <div class="client-checklist" style="margin-left:35px;">
                                                <?php echo $client['borrower_checklist_name']; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                <?php endif; ?> -->
                                <?php echo $_POST['file_opened_client_email_review_tincymac'];?>
                                <div class="col-md-12" style="margin-bottom:15px;">
                                    <img src="<?php echo base_url('assets/Email_images/file_opened.jpg'); ?>"
                                        style="width:50%;" />
                                    <p>Please watch the video below for a summary of the overall process:</p>
                                    <a href="https://www.youtube.com/embed/Ir7IV9yj4NA" target="_blank">
                                        <img src="<?php echo base_url('assets/Email_images/client_file_opened_thumbnail.png'); ?>" alt="Watch Video" style="width:50%; max-width:400px;"/>
                                    </a>
                                </div>
                                <p>Kind Regards,</p>
                                <p style="margin: 0;font-size: 15px;font-weight: 800;color: #2c89f1;">
                                    <!-- get the current staff signature -->
                                    <?php echo get_current_staff_signature($this, get_staff_user_id()); ?>
                                <h3 style="margin: 0;font-size: 22px;font-weight: bold;color: #2c89f1;">Legal Direct
                                </h3>
                                </p>
                                <p>30 Via Renzo Drive, Suite 200,<br>Richmond Hill, ON, L4S 0B8</p>
                                <p style="margin: 0;">(T) <a href="tel:905%20787%202296" style="color:#2c89f1;">905 787
                                        2296</a></p>
                                <p style="margin: 0;">(F) <a href="tel:905%20237%206325" style="color:#2c89f1;">905 237
                                        6325</a></p>
                                <?php
                                $ci = get_instance();
                                $staff_id = get_staff_user_id();
                                $data = get_staff_email_by_staffid($ci, $staff_id);
                                ?>
                                <p style="margin: 0;">
                                    (E)
                                    <?php if ($data && isset($data->email)): ?>
                                        <a href="mailto:<?php echo $data->email; ?>" style="color:#2c89f1;">
                                            <?php echo $data->email; ?>
                                        </a>
                                    <?php endif; ?>
                                </p>
                                <p><a href="http://www.legaldirect.ca/"
                                        style="color:#2c89f1;font-weight:800;font-size:20px;">www.legaldirect.ca</a></p>
                                <a href="http://www.legaldirect.ca/"><img
                                        src="<?php echo base_url('assets/Email_images/Legal_direct_logo.png'); ?>"
                                        style="height: 30px;margin-bottom: 20px;"></a>
                            </td>
                        </tr>
                        <tr>
                            <td
                                style="padding:30px;text-align:center;font-size:12px;background-color:transparent;color:#999999;">
                                <p style="margin:0 0 8px 0;">
                                    <a href="https://twitter.com/" style="text-decoration:none;">
                                        <img src="<?php echo base_url('assets/Email_images/twitter.png'); ?>" alt=""
                                            style="margin:8px;">
                                    </a>
                                    <a href="https://www.facebook.com/" style="text-decoration:none;">
                                        <img src="<?php echo base_url('assets/Email_images/facebook.png'); ?>" alt=""
                                            style="margin:8px;">
                                    </a>
                                    <a href="https://www.linkedin.com/home" style="text-decoration:none;">
                                        <img src="<?php echo base_url('assets/Email_images/linkdin.png'); ?>" alt=""
                                            style="margin:8px;">
                                    </a>
                                </p>
                                <a href="https://www.legaldirect.ca/" style="text-decoration:none;">
                                    <img src='<?php echo base_url('assets/Email_images/legaldirect.png'); ?>' width="90"
                                        alt="Logo"
                                        style="width:90px;max-width:80%;height:auto;border:none;text-decoration:none;color:#ffffff;">
                                </a>
                                <p style="margin:0;font-size:14px;line-height:20px;">Copyright © 2024</p>
                                <!-- <p
                                    style="color: var(--Text-Light, #999);text-align: center;font-family: Inter;font-size: 12px;font-style: normal;font-weight: 400;line-height: 16px;">
                                    Legal Direct Association</p>
                                <p
                                    style="color: var(--Text-Light, #999);text-align: center;font-family: Inter;font-size: 12px;font-style: normal;font-weight: 400;line-height: 16px;">
                                    Satisfied clients are our goal and measurement for success.</p> -->
                            </td>
                        </tr>
                    </table>
                    <!--[if mso]>
          </td>
          </tr>
          </table>
          <![endif]-->
                </td>
            </tr>
        </table>
    </div>
</body>

</html>