<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade modal-reminder reminder-modal-<?php echo $name . '-' . $id; ?>" tabindex="-1" role="dialog"
    aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <?php echo form_open('admin/misc/add_reminder/' . $id . '/' . $name, ['id' => 'form-reminder-' . $name]); ?>
            <div class="modal-header">
                <button type="button" class="close close-reminder-modal" data-rel-id="<?php echo $id; ?>"
                    data-rel-type="<?php echo $name; ?>" aria-label="Close"><span
                        aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel"><i class="fa-regular fa-circle-question" data-toggle="tooltip"
                        title="<?php echo _l('set_reminder_tooltip'); ?>" data-placement="bottom"></i>
                    <?php echo 'Set Case Appointment'; ?></h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <?php $this->load->view('admin/includes/reminder_fields'); ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default close-reminder-modal" data-rel-id="<?php echo $id; ?>"
                    data-rel-type="<?php echo $name; ?>"><?php echo _l('close'); ?></button>
                <button type="submit" id="lead_reminder_submit"
                    class="btn btn-primary"><?php echo _l('submit'); ?></button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>
<script>
    $(document).ready(function () {
        $('#form-reminder-lead').submit(function (event) {
            var startDate = $('#date').val();
            var endDate = $('#end_date').val();
            var state_id = $('#state_id').val();
            var description = $('#description').val();
            // Convert start and end dates to Date objects for comparison
            var startDateObj = new Date(startDate);
            var endDateObj = new Date(endDate);

            // Check if start date is greater than or equal to end date
            if (startDateObj >= endDateObj) {
                // Prevent form submission
                event.preventDefault();

                // Reset the form
                $(this)[0].reset();

                // Show alert
                alert('Start date Should be less than end date.');
            }
            if (state_id && startDate && endDate) {
                $('#client_appointment_email_review').show();
                $('#show_review_appointment_mails').show();
            }
        });
        function destroyTinyMCE() {
            tinymce.remove();
            if (tinymce.editors.length > 0) {
                tinymce.editors.forEach(function (editor) {
                    editor.remove();
                });
            }
        }

        var lead_id = <?php echo $id; ?>;

        $(document).off('click', '#lead_reminder_submit').on('click', '#lead_reminder_submit', function () {
            var startDate = $('#date').val();
            var endDate = $('#end_date').val();
            var state_id = $('#state_id').val();
            if (state_id && startDate && endDate) {
                setTimeout(function () {
                    $.ajax({
                        type: 'POST',
                        url: '<?php echo admin_url('leads/refresh_page_load'); ?>',
                        data: { lead_id: lead_id, leads_status_current_id: 7 },
                        success: function (response) {
                            destroyTinyMCE();
                            _lead_init_data(response, response.id);
                            $('a[href="' + response.leads_status + '"]').tab('show');
                            $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                            var anchor = document.querySelector('a[href="#lead_reminders"]');
                            if (response.leads_status === "#lead_reminders") {
                                anchor.click();
                            }
                        },
                        error: function (xhr, status, error) {
                            console.error('AJAX request error:', status, error);
                        }
                    });
                }, 5000);
            }
        });
    });
</script>