<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php $isRTL = (is_rtl() ? 'true' : 'false'); ?>

<!DOCTYPE html>
<html lang="<?php echo $locale; ?>" dir="<?php echo ($isRTL == 'true') ? 'rtl' : 'ltr' ?>">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <title><?php echo isset($title) ? $title : get_option('companyname'); ?></title>
    <!-- <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css"> -->
    <?php if (base_url() == 'http://localhost:80/perfex_crm/' || base_url() == 'http://localhost/perfex_crm/') {?>
        <link rel="stylesheet" href="<?php echo base_url('/assets/css/jquery-ui.min.css'); ?>" />
        <?php echo app_compile_css(); ?>
    <?php } else { ?>
    <!-- <link rel="shortcut icon" id="favicon" href="/uploads/company/favicon.png">
    <link rel="apple-touch-icon”" id="favicon-apple-touch-icon" href="/uploads/company/favicon.png">
    <link rel="stylesheet" type="text/css" id="reset-css" href="/assets/css/reset.min.css?v=3.0.6">
    <link rel="stylesheet" type="text/css" id="inter-font" href="/assets/plugins/inter/inter.css?v=3.0.6">
    <link rel="stylesheet" type="text/css" id="vendor-css" href="/assets/builds/vendor-admin.css?v=3.0.6">
    <link rel="stylesheet" type="text/css" id="fontawesome-css" href="/assets/plugins/font-awesome/css/fontawesome.min.css?v=3.0.6">
    <link rel="stylesheet" type="text/css" id="fontawesome-brands" href="/assets/plugins/font-awesome/css/brands.min.css?v=3.0.6">
    <link rel="stylesheet" type="text/css" id="fontawesome-solid" href="/assets/plugins/font-awesome/css/solid.min.css?v=3.0.6">
    <link rel="stylesheet" type="text/css" id="fontawesome-regular" href="/assets/plugins/font-awesome/css/regular.min.css?v=3.0.6">
    <link rel="stylesheet" type="text/css" id="tailwind-css" href="/assets/builds/tailwind.css?v=3.0.6">
    <link rel="stylesheet" type="text/css" id="app-css" href="/assets/css/style.min.css?v=3.0.6">
    <link rel="stylesheet" type="text/css" id="reset-css" href="/assets/css/jquery-ui.min.css">
    <link rel="preconnect" href="https://js.pusher.com">
    <link rel="preconnect" href="https://accounts.google.com">
    <link rel="preconnect" href="https://apis.google.com"> -->
    <!-- Favicon -->
    <link rel="icon" href="/uploads/company/favicon.png" type="image/png">
    <link rel="apple-touch-icon" href="/uploads/company/favicon.png">

    <!-- Preconnect for 3rd-party resources -->
    <link rel="preconnect" href="https://js.pusher.com" crossorigin>
    <link rel="preconnect" href="https://accounts.google.com" crossorigin>
    <link rel="preconnect" href="https://apis.google.com" crossorigin>

    <!-- Critical CSS: Inline or preload -->
    <!-- Consider inlining only critical CSS or preload one main CSS -->
    <link rel="preload" as="style" href="/assets/builds/vendor-admin.css?v=3.0.6" onload="this.onload=null;this.rel='stylesheet'">
    <noscript><link rel="stylesheet" href="/assets/builds/vendor-admin.css?v=3.0.6"></noscript>

    <!-- Non-critical CSS loaded normally (can also defer with JS if needed) -->
    <link rel="stylesheet" href="/assets/css/reset.min.css?v=3.0.6">
    <link rel="stylesheet" href="/assets/plugins/inter/inter.css?v=3.0.6">
    <link rel="stylesheet" href="/assets/plugins/font-awesome/css/fontawesome.min.css?v=3.0.6">
    <link rel="stylesheet" href="/assets/plugins/font-awesome/css/brands.min.css?v=3.0.6">
    <link rel="stylesheet" href="/assets/plugins/font-awesome/css/solid.min.css?v=3.0.6">
    <link rel="stylesheet" href="/assets/plugins/font-awesome/css/regular.min.css?v=3.0.6">
    <link rel="stylesheet" href="/assets/builds/tailwind.css?v=3.0.6">
    <link rel="stylesheet" href="/assets/css/style.min.css?v=3.0.6">
    <link rel="stylesheet" href="/assets/css/jquery-ui.min.css?v=3.0.6">

    <?php } ?>
    <?php render_admin_js_variables(); ?>

    <script>
    var totalUnreadNotifications = <?php echo $current_user->total_unread_notifications; ?>,
        proposalsTemplates = <?php echo json_encode(get_proposal_templates()); ?>,
        contractsTemplates = <?php echo json_encode(get_contract_templates()); ?>,
        billingAndShippingFields = ['billing_street', 'billing_city', 'billing_state', 'billing_zip', 'billing_country',
            'shipping_street', 'shipping_city', 'shipping_state', 'shipping_zip', 'shipping_country'
        ],
        isRTL = '<?php echo $isRTL; ?>',
        taskid, taskTrackingStatsData, taskAttachmentDropzone, taskCommentAttachmentDropzone, newsFeedDropzone,
        expensePreviewDropzone, taskTrackingChart, cfh_popover_templates = {},
        _table_api;
    </script>
    
    <?php app_admin_head(); ?>
</head>

<body <?php echo admin_body_class(isset($bodyclass) ? $bodyclass : ''); ?>>
    <?php hooks()->do_action('after_body_start'); ?>