<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\FlexApi\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Serialize;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class InsightsQuestionnairesQuestionList extends ListResource {
    /**
     * Construct the InsightsQuestionnairesQuestionList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(Version $version) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [];

        $this->uri = '/Insights/QM/Questions';
    }

    /**
     * Create the InsightsQuestionnairesQuestionInstance
     *
     * @param string $categoryId Category ID
     * @param string $question The question.
     * @param string $description The question description.
     * @param string $answerSetId The answer_set for question.
     * @param bool $allowNa Flag to enable NA for answer.
     * @param array|Options $options Optional Arguments
     * @return InsightsQuestionnairesQuestionInstance Created
     *                                                InsightsQuestionnairesQuestionInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(string $categoryId, string $question, string $description, string $answerSetId, bool $allowNa, array $options = []): InsightsQuestionnairesQuestionInstance {
        $options = new Values($options);

        $data = Values::of([
            'CategoryId' => $categoryId,
            'Question' => $question,
            'Description' => $description,
            'AnswerSetId' => $answerSetId,
            'AllowNa' => Serialize::booleanToString($allowNa),
        ]);
        $headers = Values::of(['Token' => $options['token'], ]);

        $payload = $this->version->create('POST', $this->uri, [], $data, $headers);

        return new InsightsQuestionnairesQuestionInstance($this->version, $payload);
    }

    /**
     * Constructs a InsightsQuestionnairesQuestionContext
     *
     * @param string $questionId Unique Question ID
     */
    public function getContext(string $questionId): InsightsQuestionnairesQuestionContext {
        return new InsightsQuestionnairesQuestionContext($this->version, $questionId);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.FlexApi.V1.InsightsQuestionnairesQuestionList]';
    }
}