<?php

use app\services\AbstractKanban;

defined('BASEPATH') or exit('No direct script access allowed');

class Leads_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper('leads_helper');
        // $this->load->library('sms/Sms_twilio');
    }

    /**
     * Get lead
     * @param  string $id Optional - leadid
     * @return mixed
     */
    public function get($id = '', $where = [])
    {
        $this->db->select('*,' . db_prefix() . 'leads.name, ' . db_prefix() . 'leads.id,' . db_prefix() . 'leads_status.name as status_name,' . db_prefix() . 'leads_sources.name as source_name');
        $this->db->join(db_prefix() . 'leads_status', db_prefix() . 'leads_status.id=' . db_prefix() . 'leads.status', 'left');
        $this->db->join(db_prefix() . 'leads_sources', db_prefix() . 'leads_sources.id=' . db_prefix() . 'leads.source', 'left');

        $this->db->where($where);
        if (is_numeric($id)) {
            $this->db->where(db_prefix() . 'leads.id', $id);
            $lead = $this->db->get(db_prefix() . 'leads')->row();
            if ($lead) {
                if ($lead->from_form_id != 0) {
                    $lead->form_data = $this->get_form([
                        'id' => $lead->from_form_id,
                    ]);
                }
                $lead->attachments = $this->get_lead_attachments($id);
                $lead->public_url = leads_public_url($id);
            }

            return $lead;
        }

        return $this->db->get(db_prefix() . 'leads')->result_array();
    }

    /**
     * Get lead by given email
     *
     * @since 2.8.0
     *
     * @param  string $email
     *
     * @return \strClass|null
     */
    public function get_lead_by_email($email)
    {
        $this->db->where('email', $email);
        $this->db->limit(1);

        return $this->db->get('leads')->row();
    }

    /**
     * Add new lead to database
     * @param mixed $data lead data
     * @return mixed false || leadid
     */
    public function get_lead_id($user_id)
    {
        $this->db->select('userid');
        $this->db->from(db_prefix() . 'contacts');
        $this->db->where('id', $user_id);
        $query = $this->db->get();
        $result = $query->row();
        $userid = $result->userid;
        $this->db->select('*');
        $this->db->from(db_prefix() . 'leads');
        $this->db->where('client_id', $userid);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            $result = $query->row();
            return $result;
        } else {
            return null;
        }

    }
    public function add($data)
    {
        $tags = '';
        if (isset($data['tags'])) {
            $tags = $data['tags'];
            unset($data['tags']);
        }
        // check new lender column exit or not
        if (!empty($data['new_transaction_name'])) {
            $data['transaction'] = $data['new_transaction_name'];
        }
        unset($data['new_transaction_name']);
        for ($i = 2; $i <= $data['total_fields']; $i++) {
            if (isset($data['borrow_firstname' . $i]) || isset($data['borrow_lastname' . $i]) || isset($data['borrow_address' . $i]) || isset($data['borrow_position' . $i])) {
                unset($data['borrow_firstname' . $i]);
                unset($data['borrow_lastname' . $i]);
                unset($data['borrow_address' . $i]);
                unset($data['borrow_position' . $i]);
                unset($data['borrow_middlename' . $i]);
                unset($data['borrow_city' . $i]);
                unset($data['borrow_province' . $i]);
                unset($data['borrow_zipcode' . $i]);
                unset($data['borrow_email' . $i]);
                unset($data['borrow_phone' . $i]);
                unset($data['borrow_preferred_method' . $i]);
                unset($data['borrow_martial_status' . $i]);
            }
        }
     
        if (isset($data['total_fields'])) {
            $total_fields = $data['total_fields'];
            unset($data['total_fields']);
        }
        // unset the lender details fields
        if (is_array($data['loan_total_post_req']) && isset($data['loan_total_post_req'][0])) {
            $data['loan_total_post_req'] = $data['loan_total_post_req'][0];
        }
        $lenderDetailsArray = json_decode($data['loan_total_post_req'], true);
        if (is_array($lenderDetailsArray)) {
            foreach ($lenderDetailsArray as $lender) {
                if (!isset($lender['lenderId'], $lender['index'])) {
                    continue;
                }
                $lenderId = (string) $lender['lenderId'];
                $index = (int) $lender['index'];
                $loanKey = "loan_amount_{$lenderId}_{$index}";
                $transactionKey = "transaction_{$lenderId}_{$index}";
                $newTransactionKey = "new_transaction_name_{$lenderId}_{$index}";
                if (isset($data[$loanKey])) {
                    unset($data[$loanKey]);
                }
                if (isset($data[$transactionKey])) {
                    unset($data[$transactionKey]);
                }
                if (isset($data[$newTransactionKey])) {
                    unset($data[$newTransactionKey]);
                }
            }
        }        
        if (isset($data['loan_total_post_req'])) {
            unset($data['loan_total_post_req']);
        }
        // $this->load->helper('leads_helper');
        // $this->load->library('sms/Sms_twilio');
        // Check record exist in leads table then only insert in multiple record in leads table
        $this->db->select('*');
        $this->db->from(db_prefix() . 'leads');
        $this->db->where('email', $data['email']);
        // $this->db->where('active_case', 'Active');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            // Fetch all rows and get last result 
            $results = $query->row();
            // $lastRow = end($results);
            $lastColumn_id = $results->id;
            $additional_email = $results->additional_email;
            $secondary_email_check = $results->secondary_email_check;
            // $lastColumn_client_id = $results->client_id;
            // insert/add leads data
            $data = add_leads($data);
            $data['multiple_cases'] = $lastColumn_id;
            $data['additional_email'] = $additional_email;
            $data['secondary_email_check'] = $secondary_email_check;
            $data['excepting_closing_date'] = to_sql_date($data['excepting_closing_date'], true);
            $data['file_opened_started_at'] = date('Y-m-d H:i:s');
            $data['case_creator_id'] = get_staff_user_id();
            $data['active_case'] = 'Active';
            // $data['client_id'] = $lastColumn_client_id;
            if (empty($data['addedfrom'])) {
                $data['addedfrom'] = get_staff_user_id();
            } else {
                $data['addedfrom'] = implode(',', $data['addedfrom']);
            }
            // set the lender ids
            if (!empty($data['lender_ids'])) {
                $data['lender_ids'] = implode(',', $data['lender_ids']);
            }
            $keysToRemove = array('firstname', 'middlename', 'lastname');
            // Remove the keys from the array
            foreach ($keysToRemove as $key) {
                unset($data[$key]);
            }
            $this->db->insert(db_prefix() . 'leads', $data);
            $insert_id = $this->db->insert_id();

        } else {
            // insert/add clients
            $data = add_leads($data);
            $clients = add_clients($data);
            $this->db->insert(db_prefix() . 'clients', $clients);
            $client_id = $this->db->insert_id();
            // insert/add leads
            $data['client_id'] = $client_id;
            if (empty($data['addedfrom'])) {
                $data['addedfrom'] = get_staff_user_id();
            }
            $additional_email = $data['additional_email'];
            // //tbl leads insert 
            $data['excepting_closing_date'] = to_sql_date($data['excepting_closing_date'], true);
            $lead_data_array = array(
                'is_public' => $data['is_public'],
                'secondary_email_check' => $data['secondary_email_check'],
                'description' => $data['description'],
                'prepaid_rate' => $data['prepaid_rate'],
                'lastcontact' => $data['lastcontact'],
                'address' => $data['address'],
                // 'addedfrom' => get_broker_agent_staffid($this, $data['addedfrom']),
                'case_creator_id' => get_staff_user_id(),
                'addedfrom' => (!empty($data['addedfrom']) && is_array($data['addedfrom'])) ? implode(',', $data['addedfrom']) : $data['addedfrom'],
                'brokerage_id' => $data['brokerage_id'],
                'assign_group' => $data['assign_group'],
                'status' => $data['status'],
                'email' => $data['email'],
                'additional_email' => $additional_email,
                'name' => $data['name'],
                'phonenumber' => $data['phonenumber'],
                'country' => $data['country'],
                'state' => $data['state'],
                'city' => $data['city'],
                'zip' => $data['zip'],
                'active_case' => 'Active',
                'martial_status' => $data['martial_status'],
                'transaction' => $data['transaction'],
                'secondary_name' => $data['secondary_name'],
                'client_id' => $data['client_id'],
                'multiple_cases' => $data['multiple_cases'],
                'dateadded' => $data['dateadded'],
                'dateassigned' => $data['dateassigned'],
                'last_status_change' => $data['last_status_change'],
                'excepting_closing_date' => $data['excepting_closing_date'],
                'preferred_contact_method' => $data['preferred_contact_method'],
                'loan_amount' => $data['loan_amount'],
                'lender_ids' => !empty($data['lender_ids']) ? implode(',', $data['lender_ids']) : null,
                'lead_borrow_position' => $data['lead_borrow_position'],
                'second_broker_firstname' => $data['second_broker_firstname'],
                'second_broker_lastname' => $data['second_broker_lastname'],
                'second_broker_email' => $data['second_broker_email'],
                'contacted_notes' => $data['contacted_notes'],
                'file_opened_started_at' => date('Y-m-d H:i:s'),
                'pin_check' => $data['pin_check'],
            );
            $this->db->insert(db_prefix() . 'leads', $lead_data_array);
            $insert_id = $this->db->insert_id();
            //  insert/add contact
            $contact = add_contacts($data);
            $contact['userid'] = $client_id;
            $contact['additional_email'] = $additional_email;
            $rand_password = generateRandomPassword($insert_id, $data['name']);
            $hashed_password = password_hash($rand_password, PASSWORD_BCRYPT);
            $contact['password'] = $hashed_password;
            $this->db->insert(db_prefix() . 'contacts', $contact);
        }

        if ($insert_id) {
            log_activity('New Case Added [ID: ' . $insert_id . ']');
            $this->log_lead_activity($insert_id, 'Case successfully created by ' . get_staff_full_name() . '.');
            handle_tags_save($tags, $insert_id, 'lead');

            if (isset($custom_fields)) {
                handle_custom_fields_post($insert_id, $custom_fields);
            }
            hooks()->do_action('lead_created', $insert_id);

            return array(
                'id' => $insert_id,
                'password' => $rand_password,
            );
        }

        return false;

    }
    // tblerror_logs add the logs of error 
    public function add_errors_logs($lead_id, $user_id, $user_name, $action_name, $error_message, $error_code, $type) {
        $error_message = is_array($error_message) ? json_encode($error_message) : $error_message;
        $insert_logs_array = array(
            'lead_id' => $lead_id ?? null,
            'user_id' => $user_id ?? null, 
            'user_name' => $user_name ?? null,
            'action_name' => $action_name ?? null, 
            'type' => $type ?? null,
            'error_message' => $error_message ?? null, 
            'error_code' => $error_code ?? null, 
            'created_at' => date('Y-m-d H:i:s') 
        );
        $this->db->insert(db_prefix() . 'error_logs', $insert_logs_array);
    }
    function upload_to_dropbox($access_token, $tmp_file, $file_name, $user_id, $dropbox_firstname, $dropbox_lastname)
    {
        if (base_url() == 'http://localhost:80/perfex_crm/' || base_url() == 'http://localhost/perfex_crm/') { return 1; }
        $refresh_token_change = $this->refresh_dropbox_token_get();
        if ($refresh_token_change) {
            $finfo = finfo_open(FILEINFO_MIME_TYPE);
            $file_type = finfo_file($finfo, $tmp_file);
            finfo_close($finfo);

            
            $timestamp = time();
            $file_extension = pathinfo($file_name, PATHINFO_EXTENSION);

            $filename_without_spaces = url_title(pathinfo($file_name, PATHINFO_FILENAME), '_');

            $unique_filename = $timestamp . '_' . $filename_without_spaces . '.' . $file_extension;

            $sanitized_firstname = str_replace(' ', '_', $dropbox_firstname);
            $sanitized_lastname = str_replace(' ', '_', $dropbox_lastname);

            $remote_path = '/uploads/' . $user_id . '_' . $sanitized_firstname . "_" . $sanitized_lastname . '/' . $unique_filename;
          
            $remote_path = str_replace(' ', '-', $remote_path);
           
            $remote_path = preg_replace('/\/+/', '/', $remote_path);

            $this->db->select('token');
            $get_token_data = $this->db->get(db_prefix() . 'token')->row();
            $new_access_token = $get_token_data->token;

        
            $upload_result = $this->uploadToDropbox($new_access_token, $tmp_file, $remote_path);
            if ($upload_result['status'] == 200) {
     
                $dropboxFolderPath = '/uploads/' . $user_id . '_' . $sanitized_firstname . "_" . $sanitized_lastname;
                $files = $this->listFiles($new_access_token, $dropboxFolderPath);

                $fileLinks = $this->getTemporaryLinks($new_access_token, $files);
                $latestFileLink = end($fileLinks);
            
                // $temporaryLink = $this->getPermanentLink($new_access_token, $remote_path);

                // if (isset($temporaryLink['link'])) {
              
                    $sharedLink = $this->createSharedLink($new_access_token, $remote_path);

                    if (isset($sharedLink['url'])) {
                        $sharedLink = trim($sharedLink['url']);

                        $directLink = str_replace('dl=0', 'raw=1', $sharedLink);
                        $file_url = str_replace('www.dropbox.com', 'dl.dropboxusercontent.com', $directLink);
                        $latestFileLink['file_url'] = $file_url;

                        $download_link = str_replace('dl=0', 'dl=1', $sharedLink);
              
                        $download_file_url = str_replace('www.dropbox.com', 'dl.dropboxusercontent.com', $download_link);
                        $latestFileLink['download_file_url'] = $download_file_url;

                        $latestFileLink['file_name'] = $unique_filename;
                        $latestFileLink['file_type'] = $file_type;
                        $latestFileLink['status'] = 200;

                        return $latestFileLink;
                    }
                // }
            } else {
                return $upload_result;
            }
        } else {
            // return $this->upload_to_dropbox($access_token, $tmp_file, $file_name, $user_id, $dropbox_firstname, $dropbox_lastname);
            return false;
        }
    }
    public function deleteFile($accessToken, $path)
    {
        $refresh_token_change = $this->refresh_dropbox_token_get();
        if ($refresh_token_change) {
            // get the latest access_token after refresh
            $this->db->select('token');
            $this->db->where('id', 1);
            $get_token_data = $this->db->get(db_prefix() . 'token')->row();
            $accessToken = $get_token_data->token;
            $ch = curl_init("https://api.dropboxapi.com/2/files/delete_v2");

            $requestData = json_encode([
                'path' => $path,
            ]);

            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_POSTFIELDS, $requestData);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Authorization: Bearer ' . $accessToken,
                'Content-Type: application/json',
            ]);

            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

         
            $response = curl_exec($ch);

           
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            curl_close($ch);

            // Check if the HTTP response code indicates success
            if ($httpCode === 200) {
                return true; 
            } else {
              //  $this->add_errors_logs('',  get_staff_user_id(), get_staff_full_name(), 'Image not delete properly.', json_encode($response), '400', 'staff');
                return false; 
            }
        } else {
            // $this->deleteFile($accessToken, $path);
            return false;
        }
    }
    public function refresh_dropbox_token_get()
    {
        // Get the refresh token from the database
        // $data = $this->Token_model->getToken();
        // $refreshToken = array_column($data, 'refresh_token');
        // $refreshToken = implode(',', $refreshToken);
        // get the time of refresh token 
        $this->db->select('created_at,refresh_token');
        $this->db->where('id', 1);
        $get_token_data = $this->db->get(db_prefix() . 'token')->row();
        $created_at_time = $get_token_data->created_at;
        $created_at_timestamp = strtotime($created_at_time);
        $modified_timestamp = $created_at_timestamp + 14400;
        $current_timestamp = time();
        if ($current_timestamp >= $modified_timestamp) {
            if (!empty($get_token_data->refresh_token)) {
                // Construct the URL for the token refresh
                $tokenRefreshURL = 'https://api.dropbox.com/oauth2/token';
                if (base_url() == 'https://dev.platform.legaldirect.ca/') {
                    $Dropbox_CLIENT_ID = unlayer_extract(getenv('DROPBOX_CLIENT_ID_DEV'), $_ENV['Dropbox_Lock_signature']);
                    $Dropbox_CLIENT_SECRET  = unlayer_extract(getenv('DROPBOX_CLIENT_SECRET_DEV'), $_ENV['Dropbox_Lock_signature']);
                }else{
                    $Dropbox_CLIENT_ID = unlayer_extract(getenv('DROPBOX_CLIENT_ID_PROD'), $_ENV['Dropbox_Lock_signature']);
                    $Dropbox_CLIENT_SECRET  = unlayer_extract(getenv('DROPBOX_CLIENT_SECRET_PROD'), $_ENV['Dropbox_Lock_signature']);
                }
                // Prepare the parameters for the refresh token request
                $params = array(
                    'grant_type' => 'refresh_token',
                    'refresh_token' => $get_token_data->refresh_token,
                    'client_id' => $Dropbox_CLIENT_ID,
                    'client_secret' => $Dropbox_CLIENT_SECRET,
                );
                $maxRetries = 10; // Maximum number of retry attempts
                $attempt = 0;

                while ($attempt < $maxRetries) {
                    $attempt++;
                    // Send a POST request to refresh the token
                    $response = $this->send_post_request($tokenRefreshURL, $params);
                    // Handle the response
                    // if ($response['access_token'] && str_starts_with($response['access_token'], 'sl.C')) {
                    if ($response['access_token']) {
                        // Update the database with the new access token
                        $data = array(
                            'token' => $response['access_token'],
                            'expire_time' => $response['expires_in'],
                            'created_at' => date('Y-m-d H:i:s'),
                        );

                        $this->db->where('id', 1);
                        $this->db->update(db_prefix() . 'token', $data);
                        return true;
                    } 
                    if($attempt == 10) {
                        // Check if the error is due to a malformed refresh token
                        if (isset($response['error']) && $response['error'] === 'invalid_grant') {
                            $this->add_errors_logs('', '', '', 'Refresh token is invalid or malformed. You may need to reauthorize the user.', json_encode($response), '', '');
                            echo 'Refresh token is invalid or malformed. You may need to reauthorize the user.';
                        } else {
                            $this->add_errors_logs('', '', '', 'access token is not  properly refresh', json_encode($response), '', '');
                            echo 'Failed to refresh the token. ' . json_encode($response);
                        }
                        return false;
                    }
                }
            } else {
                echo 'No refresh token available.';
                return false;
            }
        } else {
            return true;
        }

    }
//     public function refresh_dropbox_token_get()
// {
//     // Define Dropbox credentials based on environment
//     if (base_url() == 'https://dev.platform.legaldirect.ca/') {
//         $client_id = 'atcksepiq6w9wzo';
//         $client_secret = 'tye7w7g8khh68ri';
//     } else {
//         $client_id = 'deh0r98qh2zi04k';
//         $client_secret = 'ai3t7vc77cvt4vd';
//     }

//     // Fetch refresh token from database
//     $this->db->select('created_at, refresh_token');
//     $this->db->where('id', 1);
//     $get_token_data = $this->db->get(db_prefix() . 'token')->row();

//     if (!$get_token_data || empty($get_token_data->refresh_token)) {
//         echo 'No refresh token available.';
//         return false;
//     }

//     $refresh_token = $get_token_data->refresh_token;
//     $created_at_time = strtotime($get_token_data->created_at);
//     $current_timestamp = time();
    
//     // Check if the token is expired (4 hours = 14400 seconds)
//     if ($current_timestamp < ($created_at_time + 14400)) {
//         return true; // Token is still valid
//     }

//     // API URL for token refresh
//     $tokenRefreshURL = 'https://api.dropbox.com/oauth2/token';
    
//     // Prepare request parameters
//     $params = [
//         'grant_type'    => 'refresh_token',
//         'refresh_token' => $refresh_token,
//         'client_id'     => $client_id,
//         'client_secret' => $client_secret,
//     ];

//     $maxRetries = 3; // Reduce retries to 3
//     $attempt = 0;

//     while ($attempt < $maxRetries) {
//         $attempt++;
        
//         // Send a POST request to refresh the token
//         $response = $this->send_post_request($tokenRefreshURL, $params);
//         print_r($response);
//         // Check if the response contains a valid access token
//         if (isset($response['access_token']) && str_starts_with($response['access_token'], 'sl.C')) {
//             // Update token in the database
//             $data = [
//                 'token'       => $response['access_token'],
//                 'expire_time' => $response['expires_in'],
//                 'created_at'  => date('Y-m-d H:i:s'),
//             ];
//             $this->db->where('id', 1);
//             $this->db->update(db_prefix() . 'token', $data);

//             return true;
//         } 

//         // If last attempt fails, log the error
//         if ($attempt == $maxRetries) {
//             if (isset($response['error']) && $response['error'] === 'invalid_grant') {
//                 $this->add_errors_logs('', '', '', 'Refresh token is invalid or expired. Reauthorize the app.', json_encode($response), '', '');
//                 echo 'Refresh token is invalid or expired. Reauthorize the app.';
//             } else {
//                 $this->add_errors_logs('', '', '', 'Failed to refresh access token.', json_encode($response), '', '');
//                 echo 'Failed to refresh the token. ' . json_encode($response);
//             }
//             return false;
//         }
//     }
// }

    // private function send_post_request($url, $data)
    // {
    //     $ch = curl_init($url);
    //     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //     curl_setopt($ch, CURLOPT_POST, true);
    //     // curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    //     curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));

    //     $response = curl_exec($ch);

    //     // Check for cURL errors
    //     if (curl_errno($ch)) {
    //         echo 'cURL error: ' . curl_error($ch);
    //     }

    //     curl_close($ch);

    //     return json_decode($response, true);
    // }

    private function send_post_request($url, $data)
    {
        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        
        // Set headers for correct request format
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/x-www-form-urlencoded'
        ]);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // Get HTTP response code

        // Check for cURL errors
        if (curl_errno($ch)) {
            $error = curl_error($ch);
            curl_close($ch);
            return ['error' => 'cURL error: ' . $error];
        }

        curl_close($ch);

        // If request was unsuccessful, return HTTP error
        if ($httpCode !== 200) {
            return ['error' => 'HTTP Error: ' . $httpCode, 'response' => $response];
        }

        return json_decode($response, true);
    }

    // private function uploadToDropbox($access_token, $local_path, $remote_path)
    // {
    //     $url = 'https://content.dropboxapi.com/2/files/upload';

    //     // Correctly encode the Dropbox-API-Arg header as JSON
    //     $dropbox_api_arg = json_encode(array(
    //         "path" => $remote_path,
    //         "mode" => "add",  
    //         "autorename" => true,  
    //         "mute" => false  
    //     ));

    //     $headers = array(
    //         'Authorization: Bearer ' . $access_token,
    //         'Content-Type: application/octet-stream',
    //         'Dropbox-API-Arg: ' . $dropbox_api_arg,  
    //     );

    //     $ch = curl_init($url);

    //     curl_setopt($ch, CURLOPT_POST, 1);
    //     curl_setopt($ch, CURLOPT_POSTFIELDS, file_get_contents($local_path));
    //     curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    //     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    //     $response = curl_exec($ch);
    //     $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    //     curl_close($ch);

    //     // Decode the response from JSON
    //     $decoded_response = json_decode($response, true);

    //     // Return an associative array with the HTTP status code and the response body
    //     return array('status' => $http_code, 'body' => $decoded_response);
    // }
    private function uploadToDropbox($access_token, $local_path, $remote_path)
    {
        $url = 'https://content.dropboxapi.com/2/files/upload';

        if (!file_exists($local_path)) {
            return ['status' => 400, 'body' => 'Error: Local file not found!'];
        }

        // Set up the Dropbox API arguments as JSON
        $dropbox_api_arg = json_encode([
            "path" => $remote_path,
            "mode" => "add",  // Change to 'overwrite' if needed
            "autorename" => true,
            "mute" => false
        ]);

        // Headers for the request
        $headers = [
            'Authorization: Bearer ' . $access_token,
            'Content-Type: application/octet-stream',
            'Dropbox-API-Arg: ' . $dropbox_api_arg
        ];
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, file_get_contents($local_path));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        curl_close($ch);

        if ($error) {
            return ['status' => 500, 'body' => 'cURL Error: ' . $error];
        }

        return ['status' => $http_code, 'body' => json_decode($response, true)];
    }

    private function listFiles($accessToken, $folderPath)
    {
        $ch = curl_init("https://api.dropboxapi.com/2/files/list_folder");

        $requestData = json_encode([
            'path' => $folderPath,
        ]);

        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $requestData,
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $accessToken,
                'Content-Type: application/json',
            ],
        ]);
        $response = json_decode(curl_exec($ch), true);
        curl_close($ch);
        $files = [];
        if (!empty($response['entries'])) {
            foreach ($response['entries'] as $entry) {
                if (isset($entry['name']) && is_string($entry['name']) && $entry['.tag'] === 'file') {
                    $files[] = $entry['path_display'];
                }
            }
        }
        return $files;
    }
    private function getTemporaryLinks($accessToken, $files)
    {
        $fileLinks = [];
        foreach ($files as $filePath) {
            $ch = curl_init("https://api.dropboxapi.com/2/files/get_temporary_link");

            $requestData = json_encode([
                'path' => $filePath,
            ]);
            curl_setopt_array($ch, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $requestData,
                CURLOPT_HTTPHEADER => [
                    'Authorization: Bearer ' . $accessToken,
                    'Content-Type: application/json',
                ],
            ]);
            $response = json_decode(curl_exec($ch), true);
            curl_close($ch);
            if (isset($response['link'])) {
                $fileInfo = [
                    'file_name' => $response['metadata']['name'],
                    'file_size' => $response['metadata']['size'],
                    'flie_url' => $response['link'],
                ];
                $fileLinks[] = $fileInfo;
            }
        }
        return $fileLinks;
    }
    private function getPermanentLink($accessToken, $filePath)
    {
        $ch = curl_init("https://api.dropboxapi.com/2/files/get_temporary_link");

        $requestData = json_encode([
            'path' => $filePath,
        ]);

        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $requestData,
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $accessToken,
                'Content-Type: application/json',
            ],
        ]);

        $response = json_decode(curl_exec($ch), true);
        curl_close($ch);

        return $response;
    }
    private function createSharedLink($accessToken, $filePath)
    {
        $ch = curl_init("https://api.dropboxapi.com/2/sharing/create_shared_link");

        $requestData = json_encode([
            'path' => $filePath,
        ]);

        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $requestData,
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $accessToken,
                'Content-Type: application/json',
            ],
        ]);

        $response = json_decode(curl_exec($ch), true);
        curl_close($ch);

        return $response;
    }
    // private function createSharedLink($accessToken, $filePath)
    // {
    //     $ch = curl_init("https://api.dropboxapi.com/2/sharing/create_shared_link_with_settings");

    //     $requestData = json_encode([
    //         'path' => $filePath,
    //         'settings' => [
    //             'requested_visibility' => 'public', 
    //         ],
    //     ]);

    //     curl_setopt_array($ch, [
    //         CURLOPT_RETURNTRANSFER => true,
    //         CURLOPT_CUSTOMREQUEST => 'POST',
    //         CURLOPT_POSTFIELDS => $requestData,
    //         CURLOPT_HTTPHEADER => [
    //             'Authorization: Bearer ' . $accessToken,
    //             'Content-Type: application/json',
    //         ],
    //     ]);

    //     $response = curl_exec($ch);
    //     $httpStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    //     curl_close($ch);

    //     $data = json_decode($response, true);

    //     if ($httpStatus >= 400 || isset($data['error'])) {
    //         return [
    //             'success' => false,
    //             'error' => $data['error_summary'] ?? 'Unknown error',
    //         ];
    //     }

    //     return [
    //         'success' => true,
    //         'url' => $data['url'], 
    //     ];
    // }
    // upload the nuborrow link doc in the dropbox 
    public function upload_remote_file_to_dropbox($remote_url, $doc_title, $user_id, $first_name, $last_name)
    {
        // 1. Get file extension
        $path_info = pathinfo(parse_url($remote_url, PHP_URL_PATH));
        $extension = isset($path_info['extension']) ? $path_info['extension'] : 'tmp';

        // 2. Generate a unique temp file path
        $temp_file = tempnam(sys_get_temp_dir(), 'dropbox_') . '.' . $extension;

        // 3. Download the remote file
        $file_content = @file_get_contents($remote_url);
        if ($file_content === false) {
            return ['status' => 400, 'error' => 'Unable to download file from URL: ' . $remote_url];
        }

        file_put_contents($temp_file, $file_content);

        // 4. Set the file name
       $file_name = (!empty($doc_title) ? $doc_title : 'doc_' . rand(1000, 9999)) . '.' . $extension;

        // 5. Get access token (from your DB via refresh method)
        $this->refresh_dropbox_token_get(); // refresh if needed
        $token_data = $this->db->get_where(db_prefix() . 'token', ['id' => 1])->row();
        $access_token = $token_data->token;

        // 6. Call your existing upload method
        $response = $this->upload_to_dropbox($access_token, $temp_file, $file_name, $user_id, $first_name, $last_name);

        // 7. Clean up temp file
        @unlink($temp_file);

        return $response;
    }
    // send notification using firebase FCM token
    public function sendFCMNotification($deviceToken, $title, $body)
    {
        // Firebase v1 API URL
        $url = 'https://fcm.googleapis.com/v1/projects/' . 'legal-direct' . '/messages:send';
        $jsonKeyFilePath = base_url('/assets/legal-direct-firebase-adminsdk-llg4w-81b23777d7.json');
        $accessToken = $this->getOAuthToken($jsonKeyFilePath);
        $fields = [
            'message' => [
                'token' => $deviceToken,
                'notification' => [
                    'title' => $title,
                    'body' => $body,
                ]
            ]
        ];
        $headers = [
            'Authorization: Bearer ' . $accessToken,
            'Content-Type: application/json'
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

        $result = curl_exec($ch);
        if ($result === FALSE) {
            die('Curl failed: ' . curl_error($ch));
        }

        curl_close($ch);
        return $result;
    }
    // upload doc details enter in the tbltask
    public function client_related_doc_add_in_db($task_id, $lead_id, $rel_type, $data)
    {
        if (empty($task_id)) {
            $task_id = null;
        }
        $file_data = [
            'task_id'            => $task_id,
            'rel_id'             => $lead_id,
            'rel_type'           => $rel_type,
            'file_name'          => $data['file_name'] ?? '',
            'filetype'           => $data['file_type'] ?? '',
            'file_url'           => $data['file_url'] ?? '',
            'download_file_url'  => $data['download_file_url'] ?? '',
            'doc_status'         => 'Submitted',
            'dateadded'          => date('Y-m-d H:i:s'),
            'item_type_id'       => null,
        ];

        $this->db->insert(db_prefix() . 'files', $file_data);

        return $this->db->insert_id();
    }
    public function ldteam_related_doc_add_in_db($cases_checkbox_id, $lead_id, $rel_type, $data)
    {
        $file_data = [
            'cases_checkbox_id'   => $cases_checkbox_id,
            'rel_id'              => $lead_id,
            'rel_type'            => $rel_type,
            'file_name'           => $data['file_name'] ?? '',
            'filetype'            => $data['file_type'] ?? '',
            'file_url'            => $data['file_url'] ?? '',
            'download_file_url'   => $data['download_file_url'] ?? '',
            'doc_status'          => '', // Can be updated later if needed
            'dateadded'           => date('Y-m-d H:i:s'),
        ];

        $this->db->insert(db_prefix() . 'cases_checkbox_files', $file_data);
        return  $this->db->insert_id();

    }
    // add the nuborrow leadid in the case details table
    public function add_nuborrow_lead_id($lead_id, $nuborrow_lead_id)
    {
        $data = [
            'lead_id' => $lead_id,
            'nuborrow_lead_id' => $nuborrow_lead_id,
        ];
        $this->db->insert(db_prefix() . 'cases_details', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        }
    }
    public function update_nuborrow_lead_id($lead_id, $nuborrow_lead_id)
    {
        $this->db->where('id', $lead_id);
        $this->db->update(db_prefix() . 'cases_details', [
            'nuborrow_lead_id' => $nuborrow_lead_id,
        ]);
        if ($this->db->affected_rows() > 0) {
            return true;
        }
    }
    // GTC update key 
    public function update_GTC_key($lead_id, $gtc_key)
    {
        $this->db->where('lead_id', $lead_id);
        $this->db->update(db_prefix() . 'cases_details', [
            'gtc_check' => $gtc_key,
        ]);
        if ($this->db->affected_rows() > 0) {
            return true;
        }
    }
    private function getOAuthToken($jsonKeyFilePath)
    {
        $jwt = $this->generateJWT($jsonKeyFilePath);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://oauth2.googleapis.com/token');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/x-www-form-urlencoded']);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
            'assertion' => $jwt
        ]));

        $result = curl_exec($ch);
        $response = json_decode($result, true);
        curl_close($ch);

        return $response['access_token'];
    }

    private function generateJWT($jsonKeyFilePath)
    {
        $serviceAccount = json_decode(file_get_contents($jsonKeyFilePath), true);
        $header = ['alg' => 'RS256', 'typ' => 'JWT'];
        $now = time();
        $claim = [
            'iss' => $serviceAccount['client_email'],
            'scope' => 'https://www.googleapis.com/auth/firebase.messaging',
            'aud' => 'https://oauth2.googleapis.com/token',
            'iat' => $now,
            'exp' => $now + 3600,
        ];

        $jwtHeader = $this->base64UrlEncode(json_encode($header));
        $jwtClaim = $this->base64UrlEncode(json_encode($claim));
        $signatureInput = $jwtHeader . '.' . $jwtClaim;
        $signature = '';
        openssl_sign($signatureInput, $signature, $serviceAccount['private_key'], 'SHA256');

        return $signatureInput . '.' . $this->base64UrlEncode($signature);
    }

    private function base64UrlEncode($data)
    {
        return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
    }
    public function lead_assigned_member_notification($lead_id, $assigned, $integration = false)
    {
        if ((!empty($assigned) && $assigned != 0)) {
            if ($integration == false) {
                if ($assigned == get_staff_user_id()) {
                    return false;
                }
            }

            $name = $this->db->select('name')->from(db_prefix() . 'leads')->where('id', $lead_id)->get()->row()->name;

            $notification_data = [
                'description' => 'Case assigned to you',
                'touserid' => $assigned,
                // 'link' => '#leadid=' . $lead_id,
                'link' => 'cases/index/' . $lead_id,
                'additional_data' => ($integration == false ? serialize([
                    $name,
                ]) : serialize([])),
            ];

            if ($integration != false) {
                $notification_data['fromcompany'] = 1;
            }

            if (add_notification($notification_data)) {
                pusher_trigger_notification([$assigned]);
            }

            $this->db->select('email');
            $this->db->where('staffid', $assigned);
            $email = $this->db->get(db_prefix() . 'staff')->row()->email;

            // send_mail_template('lead_assigned', $lead_id, $email);

            $this->db->where('id', $lead_id);
            $this->db->update(db_prefix() . 'leads', [
                'dateassigned' => date('Y-m-d'),
            ]);

            $not_additional_data = [
                get_staff_full_name(),
                '<a href="' . admin_url('profile/' . $assigned) . '" target="_blank">' . get_staff_full_name($assigned) . '</a>',
            ];

            if ($integration == true) {
                unset($not_additional_data[0]);
                array_values(($not_additional_data));
            }

            $not_additional_data = serialize($not_additional_data);

            $not_desc = ($integration == false ? 'not_lead_activity_assigned_to' : 'not_lead_activity_assigned_from_form');
            $this->log_lead_activity($lead_id, $not_desc, $integration, $not_additional_data);
        }
    }
    // ical appointment line of code 
    function generateICal($subject, $start, $end, $location, $description, $organizer, $attendees)
    {
        $ical = "BEGIN:VCALENDAR\r\n";
        $ical .= "VERSION:2.0\r\n";
        $ical .= "PRODID:-//hacksw/handcal//NONSGML v1.0//EN\r\n";
        $ical .= "CALSCALE:GREGORIAN\r\n";
        $ical .= "BEGIN:VEVENT\r\n";
        $ical .= "DTSTART:" . date('Ymd\THis\Z', strtotime($start)) . "\r\n";
        $ical .= "DTEND:" . date('Ymd\THis\Z', strtotime($end)) . "\r\n";
        $ical .= "LOCATION:$location\r\n";
        $ical .= "SUMMARY:$subject\r\n";
        $ical .= "DESCRIPTION:$description\r\n";
        $ical .= "ORGANIZER:$organizer\r\n";
        foreach ($attendees as $attendee) {
            $ical .= "ATTENDEE;CN=$attendee:mailto:$attendee\r\n";
        }
        $ical .= "END:VEVENT\r\n";
        $ical .= "END:VCALENDAR\r\n";
        return $ical;
    }
    public function custom_lead_assigned_member_notification($user_type, $lead_id, $assigned, $fromuserid, $from_fullname, $description, $integration = false)
    {
        if (base_url() == 'http://localhost:80/perfex_crm/' || base_url() == 'http://localhost/perfex_crm/') {  return 1; }
        if ((!empty($assigned) && $assigned != 0)) {
            // if ($integration == false) {
            //     if ($assigned == get_staff_user_id()) {
            //         return false;
            //     }
            // }

            if ($user_type == 'client') {
                $name = $this->db->select('name')->from(db_prefix() . 'leads')->where('id', $lead_id)->get()->row()->name;
                $notification_data = [
                    'description' => $description,
                    'touserid' => $assigned,
                    // 'link' => '#leadid=' . $lead_id,
                    'lead_id' => $lead_id,
                    'link' => 'cases/index/' . $lead_id,
                    // 'additional_data' => ($integration == false ? serialize([
                    //     $name,
                    // ]) : serialize([])),
                    'fromuserid' => $fromuserid,
                    'from_fullname' => $name,
                    'date' => date('Y-m-d H:i:s'),
                    'additional_data' => 'user'
                ];
                $this->db->insert(db_prefix() . 'notifications', $notification_data);
                pusher_trigger_notification([$assigned]);
                if ($integration != false) {
                    $notification_data['fromcompany'] = 1;
                }
            } else {

                $get_data_staff = $this->db->select('firstname,lastname')->from(db_prefix() . 'staff')->where('staffid', $fromuserid)->get()->row();
                $name = $get_data_staff->firstname . ' ' . $get_data_staff->lastname;
                $role = get_current_staff_role($this, get_staff_user_id());
                if (($role == 2 || $role == 6)){
                    $user_type = 'broker';
                }
                $notification_data = [
                    'description' => $description,
                    'touserid' => $assigned,
                    'lead_id' => $lead_id,
                    // 'link' => '#leadid=' . $lead_id,
                    'link' => 'cases/index/' . $lead_id,
                    // 'additional_data' => ($integration == false ? serialize([
                    //     $name,
                    // ]) : serialize([])),
                    'fromuserid' => $fromuserid,
                    'from_fullname' => $name,
                    'date' => date('Y-m-d H:i:s'),
                    'additional_data' => $user_type
                ];
                $this->db->insert(db_prefix() . 'notifications', $notification_data);
                pusher_trigger_notification([$assigned]);
                pusher_trigger_notification([$fromuserid]);
                if ($integration != false) {
                    $notification_data['fromcompany'] = 1;
                }
            }

        }
    }
    /**
     * Update lead
     * @param  array $data lead data
     * @param  mixed $id   leadid
     * @return boolean
     */
    public function update($data, $id)
    {
        $current_staff_role = get_current_staff_role($this, get_staff_user_id());
        $this->db->select('*');
        $this->db->where('id', $id);
        $query = $this->db->get(db_prefix() . 'leads');
        if ($query->num_rows() > 0) {
            $lead_data = $query->row();
            $lead_id = $lead_data->id;
            $client_id = $lead_data->client_id;
            $assign_group = $lead_data->assign_group;
            $lead_name = $lead_data->name;
            $lead_email = $lead_data->email;
            $lead_status = $lead_data->status;
            $active_case = $lead_data->active_case;
        }
        $current_lead_data = $this->get($id);
        $current_status = $this->get_status($current_lead_data->status);
        if ($current_status) {
            $current_status_id = $current_status->id;
            $current_status = $current_status->name;
        } else {
            if ($current_lead_data->junk == 1) {
                $current_status = _l('lead_junk');
            } elseif ($current_lead_data->lost == 1) {
                $current_status = _l('lead_lost');
            } else {
                $current_status = '';
            }
            $current_status_id = 0;
        }

        $affectedRows = 0;
        if (isset($data['custom_fields'])) {
            $custom_fields = $data['custom_fields'];
            if (handle_custom_fields_post($id, $custom_fields)) {
                $affectedRows++;
            }
            unset($data['custom_fields']);
        }
        if (!defined('API')) {
            if (isset($data['is_public'])) {
                $data['is_public'] = 1;
            } else {
                $data['is_public'] = 0;
            }

            if (!isset($data['country']) || isset($data['country']) && $data['country'] == '') {
                $data['country'] = 0;
            }
            if (!isset($data['secondary_email_check'])) {
                $data['secondary_email_check'] = null;
            }

            if (isset($data['description'])) {
                $data['description'] = nl2br($data['description']);
            }
        }

        if (isset($data['lastcontact']) && $data['lastcontact'] == '' || isset($data['lastcontact']) && $data['lastcontact'] == null) {
            $data['lastcontact'] = null;
        } elseif (isset($data['lastcontact'])) {
            $data['lastcontact'] = to_sql_date($data['lastcontact'], true);
        }

        if (isset($data['tags'])) {
            if (handle_tags_save($data['tags'], $id, 'lead')) {
                $affectedRows++;
            }
            unset($data['tags']);
        }

        if (isset($data['remove_attachments'])) {
            foreach ($data['remove_attachments'] as $key => $val) {
                $attachment = $this->get_lead_attachments($id, $key);
                if ($attachment) {
                    $this->delete_lead_attachment($attachment->id);
                }
            }
            unset($data['remove_attachments']);
        }

        $data['address'] = trim($data['address']);
        $data['address'] = nl2br($data['address']);

        $data['email'] = trim($data['email']);
        $data['name'] = $data['firstname'] . ' ' . $data['middlename'] . ' ' . $data['lastname'];
        if ($assign_group != $data['assign_group']) {
            $data['dateassigned'] = date('Y-m-d');
        }
        if (!empty($data['assign_group'])) {
            if (!empty($active_case)) {
                $case_active = $active_case;
            } else {
                $case_active = 'Active';
            }
            $group_assigned = $data['assign_group'];
        } else {
            $group_assigned = $assign_group;
            if (!empty($active_case)) {
                $case_active = $active_case;
            } else {
                $case_active = '';
            }
        }
        // lead data array 
        if (empty($data['addedfrom'])) {
            $data['addedfrom'] = get_staff_user_id();
        }
        if (!empty($data['preferred_contact_method'])) {
            $comma_separated = implode(', ', $data['preferred_contact_method']);
            $data['preferred_contact_method'] = $comma_separated;
        }

        $data['excepting_closing_date'] = to_sql_date($data['excepting_closing_date'], true);
        // if select the other transaction
        if (!empty($data['new_transaction_name'])) {
            $data['transaction'] = $data['new_transaction_name'];
        }
        unset($data['new_transaction_name']);
        // if broker then set the previous staus
        if ($current_staff_role == 2 || $current_staff_role == 6) {
            $data['status'] = $lead_status;
        }

        $lead_data_array = array(
            'is_public' => $data['is_public'],
            'secondary_email_check' => $data['secondary_email_check'],
            'description' => $data['description'],
            'prepaid_rate' => $data['prepaid_rate'],
            'lastcontact' => $data['lastcontact'],
            'address' => $data['address'],
            // 'addedfrom' =>  get_broker_agent_staffid($this, $data['addedfrom']), // using this function to get the staffid if broker create a case otherwise is working fine
            'addedfrom' => (!empty($data['addedfrom']) && is_array($data['addedfrom'])) ? implode(',', $data['addedfrom']) : $data['addedfrom'],
            'brokerage_id' => $data['brokerage_id'],
            'assign_group' => $group_assigned,
            'status' => $data['status'],
            'email' => $data['email'],
            'additional_email' => $data['additional_email'],
            'name' => $data['name'],
            'phonenumber' => $data['phonenumber'],
            'dateassigned' => $data['dateassigned'],
            'country' => $data['country'],
            'state' => $data['state'],
            'city' => $data['city'],
            'zip' => $data['zip'],
            'martial_status' => $data['martial_status'],
            'transaction' => $data['transaction'],
            'secondary_name' => $data['secondary_name'],
            'active_case' => $case_active,
            'excepting_closing_date' => $data['excepting_closing_date'],
            'preferred_contact_method' => $data['preferred_contact_method'],
            'loan_amount' => $data['loan_amount'],
            'lender_ids' => !empty($data['lender_ids']) ? implode(',', $data['lender_ids']) : null,
            'lead_borrow_position' => $data['lead_borrow_position'],
            'second_broker_firstname' => $data['second_broker_firstname'],
            'second_broker_lastname' => $data['second_broker_lastname'],
            'second_broker_email' => $data['second_broker_email'],
            'contacted_notes' => $data['contacted_notes'],
            'pin_check' => $data['pin_check'],
        );
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'leads', $lead_data_array);
        if ($this->db->affected_rows() > 0) {
            // get client id 
            $this->db->select('*');
            $this->db->from(db_prefix() . 'leads');
            $this->db->where('id', $id);
            $query = $this->db->get();
            if ($query) {
                $result = $query->row();
                $client_id = $result->client_id;
                // Contact model data array
                $name = $data['name'];
                // Split the full name into first and last names
                $nameParts = explode(' ', $name, 3);

                $firstname = '';
                $middlename = '';
                $lastname = '';

                if (isset($nameParts[0])) {
                    $firstname = $nameParts[0];
                }
                if (isset($nameParts[1])) {
                    $middlename = $nameParts[1];
                }
                if (isset($nameParts[2])) {
                    $lastname = $nameParts[2];
                }
                $contact_model_data = array(
                    'firstname' => $firstname,
                    'middlename' => $middlename,
                    'lastname' => $lastname,
                    'email' => $data['email'],
                    'phonenumber' => $data['phonenumber'],
                    'additional_email' => $data['additional_email'],
                    'secondary_name' => $data['secondary_name']
                );
                // clients model data array
                $client_model_data = array(
                    'phonenumber' => $data['phonenumber'],
                    // 'company' => $data['company'],
                    'address' => $data['address'],
                    'city' => $data['city'],
                    'state' => $data['state'],
                    'country' => $data['country'],
                    'zip' => $data['zip'],
                );
                // update contact model record
                $this->db->where('userid', $client_id);
                $this->db->update(db_prefix() . 'contacts', $contact_model_data);
                // update client model record
                $this->db->where('userid', $client_id);
                $this->db->update(db_prefix() . 'clients', $client_model_data);
            }
            $affectedRows++;
            if (isset($data['status']) && $current_status_id != $data['status']) {
                $this->db->where('id', $id);
                $this->db->update(db_prefix() . 'leads', [
                    'last_status_change' => date('Y-m-d H:i:s'),
                ]);
                $new_status_name = $this->get_status($data['status'])->name;
                $this->log_lead_activity($id, 'not_lead_activity_status_updated', false, serialize([
                    get_staff_full_name(),
                    $current_status,
                    $new_status_name,
                ]));

                hooks()->do_action('lead_status_changed', [
                    'lead_id' => $id,
                    'old_status' => $current_status_id,
                    'new_status' => $data['status'],
                ]);
            }

            if (($current_lead_data->junk == 1 || $current_lead_data->lost == 1) && $data['status'] != 0) {
                $this->db->where('id', $id);
                $this->db->update(db_prefix() . 'leads', [
                    'junk' => 0,
                    'lost' => 0,
                ]);
            }

            // send notification and email when case group update
            if ($assign_group != $data['assign_group']) {
                $insert_task_activity = array(
                    'leadid' => $id,
                    'staffid' => get_staff_user_id(),
                    'full_name' => get_staff_full_name(),
                    'activity_type' => 'task-activity',
                    'description' => 'Case Group (' . $data['assign_group'] . ')  has been updated by ' . get_staff_full_name() . '.',
                    'date' => date('Y-m-d H:i:s'),
                );
                leads_activity_log($this, $insert_task_activity);
                $staff_data = get_staff_ids_by_group($this, $data['assign_group']);
                $contact_id = get_contact_id_using_client_id($this, $client_id);
                // get notification type
                $notification_type = get_notification_type(4);
                foreach ($staff_data as $data) {
                    // send_mail_template('lead_assigned', $current_lead_data->id, $data['email']);
                    // if broker is not exist then email shout
                    if ($data['role'] != 2) {
                        $_POST['case_assigned_name'] = $data['firstname'] . ' ' . $data['lastname'];
                        $_POST['case_name'] = $lead_name;
                        $_POST['case_email'] = $lead_email;
                        $_POST['case_url'] = admin_url('cases/index/' . $id);
                        $html_content_welcome_email_to_user = $this->load->view('admin/leads/Email_template/case_assigned', $_POST, TRUE);
                        $subject = 'New Case Assignment';
                        $replay_to_mail = get_staff_email_by_id($this, get_staff_user_id());
                        send_mailchimp_email($data['email'], $subject, $html_content_welcome_email_to_user, $replay_to_mail, '', '');
                    }
                    // notification push code 
                    $this->db->select('multiple_cases,client_id');
                    $this->db->where('id', $lead_id);
                    $lead_data_check = $this->db->get(db_prefix() . 'leads');
                    if ($lead_data_check->num_rows() > 0) {
                        $lead_data = $lead_data_check->row();
                        if ($lead_data->client_id == 0) {
                            // get the parnet id of lead
                            $partent_lead_id = $lead_data->multiple_cases;
                            $this->db->select('id,multiple_cases,client_id');
                            $this->db->where('id', $partent_lead_id);
                            $lead_parent_data_check = $this->db->get(db_prefix() . 'leads')->row();
                            $client_id = $lead_parent_data_check->client_id;
                        } else {
                            $client_id = $lead_data->client_id;
                        }
                        $contact_id = get_contact_id_using_client_id($this, $client_id);
                        $notification_type = get_notification_type(1);
                    }
                }
                // send notification to the all ld team member
                $this->db->select('assign_group,assigned,name,case_creator_id');
                $this->db->where('id', $id);
                $lead_data_for_get_assign_group = $this->db->get(db_prefix() . 'leads')->row();
                $current_staff_data = get_staff_ids_by_group($this, $lead_data_for_get_assign_group->assign_group);
                foreach ($current_staff_data as $staff_notifiy_data) {
                    if (get_staff_user_id() != $staff_notifiy_data['staffid'] && $staff_notifiy_data['staffid'] == $lead_data_for_get_assign_group->case_creator_id) {
                        $new_case_message = 'New Case (#' . $id . ', ' . $lead_data_for_get_assign_group->name . ') assigned You';
                        $this->leads_model->custom_lead_assigned_member_notification('staff', $id, $staff_notifiy_data['staffid'], get_staff_user_id(), '', $new_case_message);
                        // send slack notification
                        $this->slack->send_notification($staff_notifiy_data['email'], $new_case_message);
                    }
                }
            } else {
                $insert_task_activity = array(
                    'leadid' => $id,
                    'staffid' => get_staff_user_id(),
                    'full_name' => get_staff_full_name(),
                    'activity_type' => 'task-activity',
                    'description' => 'Case details has been updated by ' . get_staff_full_name() . '.',
                    'date' => date('Y-m-d H:i:s'),
                );
                leads_activity_log($this, $insert_task_activity);
            }
            if (isset($data['assigned'])) {
                if ($current_lead_data->assigned != $data['assigned'] && (!empty($data['assigned']) && $data['assigned'] != 0)) {
                    $this->lead_assigned_member_notification($id, $data['assigned']);
                }
            }
            log_activity('Case Updated [ID: ' . $id . ']');
            // update the additional email
            $additional_email_data = array(
                'additional_email' => $data['additional_email'],
            );
            // update record in leads
            $this->db->where('email', $data['email']);
            $rows = $this->db->get(db_prefix() . 'leads')->result_array();
            // update all record in leads 
            foreach ($rows as $row) {
                $this->db->where('id', $row['id']);
                $this->db->update(db_prefix() . 'leads', $additional_email_data);
            }
            // update record in tbl conatect for additional email
            $this->db->where('email', $data['email']);
            $this->db->update(db_prefix() . 'contacts', $additional_email_data);

            return true;
        }
        if ($affectedRows > 0) {
            return true;
        }

        return false;
    }
    // insert the borrow records
    public function add_leads_borrow_records($leads_borrow_data)
    {
        $this->db->insert(db_prefix() . 'leads_borrow', $leads_borrow_data);
        $insert_id = $this->db->insert_id();
        return $insert_id ?? null;
    }
    // update the borrow records
    public function update_leads_borrow_records($borrow_ids, $borrow_firstnames, $borrow_middlename, $borrow_lastnames, $borrow_addresses, $borrow_positions, $borrow_city, $borrow_province, $borrow_zipcode, $borrow_preferred_method, $borrow_email, $borrow_phone, $borrow_martial_status)
    {
        // Loop through each borrow_id and update the corresponding record
        foreach ($borrow_ids as $key => $borrow_id) {
            // Get the data for the current record
            $data = array(
                'borrow_firstname' => $borrow_firstnames[$key],
                'borrow_middlename' => $borrow_middlename[$key],
                'borrow_lastname' => $borrow_lastnames[$key],
                'borrow_address' => $borrow_addresses[$key],
                'borrow_position' => $borrow_positions[$key],
                'borrow_city' => $borrow_city[$key],
                'borrow_province' => $borrow_province[$key],
                'borrow_zipcode' => $borrow_zipcode[$key],
                'borrow_preferred_method' => $borrow_preferred_method[$key],
                'borrow_email' => $borrow_email[$key],
                'borrow_phone' => $borrow_phone[$key],
                'borrow_martial_status' => $borrow_martial_status[$key],
            );

            // Update the record in the database
            $this->db->where('id', $borrow_id);
            $this->db->update(db_prefix() . 'leads_borrow', $data);
        }

        // Return true if all records were successfully updated
        // return true;
    }
    // update the count of specific case and current user
    public function update_notification_count_for_specific_user($lead_id)
    {
        $updated = false;

        // 🔹 Step 1: Update notifications table
        $this->db->where('lead_id', $lead_id);
        $this->db->where('isread', 0);
        $this->db->where_in('additional_data', ['user', 'broker', 'client']);
        $this->db->update(db_prefix() . 'notifications', [
            'isread' => 1,
            'isread_inline' => 1,
        ]);

        if ($this->db->affected_rows() > 0) {
            $updated = true;
        }

        // 🔹 Step 2: Update read_comments table (broker to LD)
        $this->db->where('lead_id', $lead_id);
        $this->db->where('case_is_read', 0);
        $this->db->where('type', 'broker-to-ld');
        $this->db->update(db_prefix() . 'read_comments', ['case_is_read' => 1]);

        if ($this->db->affected_rows() > 0) {
            $updated = true;
        }

        // 🔹 Step 3: If any update occurred, log activity
        if ($updated) {
            $this->db->insert(db_prefix() . 'lead_activity_log', [
                'leadid'    => $lead_id,
                'staffid'   => get_staff_user_id(),
                'full_name' => get_staff_full_name(),
                'description' => 'Case has been opened by ' . get_staff_full_name() . '.',
                'date' => date('Y-m-d H:i:s'),
            ]);
            return true;
        }

        return false;
    }
    // update the Review upload tag
    public function update_review_upload_tag($lead_id, $review_upload_tag)
    {
        $updated_record = [
            'upload_doc' => $review_upload_tag
        ];

        $this->db->where('id', $lead_id);
        $this->db->update(db_prefix() . 'leads', $updated_record);

        return $this->db->affected_rows() > 0;
    }
    // add the shoot info details
    public function add_shoot_info($data)
    {
        if (!empty($data)) {
            $this->db->insert(db_prefix() . 'shootinfo', $data);
            return true;
        }
    }
    public function add_holdback_info($data)
    {
        if (!empty($data)) {
            $this->db->insert(db_prefix() . 'leads_holdback', $data);
            return true;
        }
    }
    // Broker fee N/A check
    public function update_broker_fee_na($task_id, $broker_fee_na)
    {
        $updated_record = [
            'broker_fee_na' => $broker_fee_na
        ];

        $this->db->where('id', $task_id);
        $this->db->update(db_prefix() . 'tasks', $updated_record);

        return $this->db->affected_rows() > 0;
    }

    // update the leads last contact
    public function update_leads_last_contact_date($lead_id)
    {
        $updated_record = array(
            'lastcontact' => date('Y-m-d H:i:s')
        );
        $this->db->where('id', $lead_id);
        $this->db->update(db_prefix() . 'leads', $updated_record);
        if ($this->db->affected_rows() > 0) {
            return true;
        }
        return false;
    }
    public function delete_record_by_api($id)
    {
        $Data = array(
            'delete_account' => '1',
        );
        // Update the 'contacts' table
        $this->db->where('id', $id);
        $check = $this->db->update(db_prefix() . 'contacts', $Data);
        // Check if the update was successful
        if ($check) {
            return true;
        } else {
            return false;
        }
    }
    // get the nuborrow uncategorized files count
    public function get_uncategorized_nuborrow_files($lead_id)
    {
        $this->db->where('rel_id', $lead_id);
        $this->db->where('rel_type', 'nuborrow-files');
        $file_count = $this->db->count_all_results(db_prefix() . 'files');
        if ($file_count > 0) {
            return $file_count;
        }
        return 0;
    }
    // insert the task to the leadid 
    public function insert_task_item($lead_id, $task_data)
    {
        // Check if the lead ID is valid
        if (empty($lead_id) || !is_numeric($lead_id)) {
            return false; // Invalid lead ID
        }

        // Insert the task into the database
        $this->db->insert(db_prefix() . 'tasks', $task_data);
        return $this->db->insert_id(); // Return the inserted task ID
    }
    // update teh task using leadid
    public function update_task_details($task_id, $task_data)
    {
        // Check if the task ID is valid
        if (empty($task_id) || !is_numeric($task_id)) {
            return false; // Invalid task ID
        }

        // Update the task in the database
        $this->db->where('id', $task_id);
        $this->db->update(db_prefix() . 'tasks', $task_data);
        return $this->db->affected_rows() > 0; 
    }
    /**
     * Update Nuborrow Task when selecting multiple "Other" items.
     * - Updates the first "Other" item with the given name.
     * - Adds additional "Other" items as Other1, Other2, Other3, etc.
     *
     * @param int   $lead_id  The Lead ID.
     * @param int   $task_id  The Task ID.
     * @param array $data     The data to update.
    */
    public function insert_nuborrow_task_for_multiple_other_items($lead_id, $data, $other_items_counter){
        // previous by default item name udpate other => Other1
        // $otherTypeTaskId  = get_task_id_by_task_name($this, 'Other', $lead_id);
        // if(!empty($otherTypeTaskId) && $other_items_counter > 1){
        //     // Update the first "Other" item with the given name
        //     $this->db->where('id', $otherTypeTaskId);
        //     $this->db->update(db_prefix() . 'tasks', [
        //         'name' => "Other1",
        //     ]);
        // }
        // insert the record
        $this->db->insert(db_prefix() . 'tasks', $data);

    }
    // insert the cases checkboxes file data
    public function insert_cases_checkboxes_files($data){
        $this->db->insert(db_prefix() . 'cases_checkbox_files', $data);
    }
    // get the file attachments using fileid
    public function get_file_attachment_by_id($fileid)
    {
        $this->db->select('id, rel_id, task_id, rel_type, file_name, filetype, file_url, download_file_url, dateadded');
        $this->db->where('id', $fileid);
        $query = $this->db->get(db_prefix() . 'files');

        if ($query->num_rows() > 0) {
            return $query->row();
        }

        return false; 
    }

    // update leads funds_requested_mail button action
    public function update_funds_requested_mail($lead_id){
        $updated_record = array(
            'funds_requested_mail' => 1
        );
        $this->db->where('id', $lead_id);
        $this->db->update(db_prefix() . 'leads', $updated_record);
    } 
    /**
     * Delete lead from database and all connections
     * @param  mixed $id leadid
     * @return boolean
     */
    public function delete($id)
    {
        $this->db->select('*');
        $this->db->from(db_prefix() . 'leads');
        $this->db->where('id', $id);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            $result = $query->row();
            $userid = $result->client_id;
            // Continue with the rest of your code using $userid
        }
        $affectedRows = 0;

        hooks()->do_action('before_lead_deleted', $id);

        $lead = $this->get($id);

        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'leads');
        // delete reocrd from conatact
        $this->db->where('userid', $userid);
        $this->db->delete(db_prefix() . 'contacts');
        // delete record from clients
        $this->db->where('userid', $userid);
        $this->db->delete(db_prefix() . 'clients');
        $affectedRows++;
        if ($affectedRows > 0) {
            log_activity('Lead Deleted [Deleted by: ' . get_staff_full_name() . ', ID: ' . $id . ']');

            $attachments = $this->get_lead_attachments($id);
            foreach ($attachments as $attachment) {
                $this->delete_lead_attachment($attachment['id']);
            }

            // Delete the custom field values
            $this->db->where('relid', $id);
            $this->db->where('fieldto', 'leads');
            $this->db->delete(db_prefix() . 'customfieldsvalues');

            $this->db->where('leadid', $id);
            $this->db->delete(db_prefix() . 'lead_activity_log');

            $this->db->where('leadid', $id);
            $this->db->delete(db_prefix() . 'lead_integration_emails');

            $this->db->where('rel_id', $id);
            $this->db->where('rel_type', 'lead');
            $this->db->delete(db_prefix() . 'notes');

            $this->db->where('rel_type', 'lead');
            $this->db->where('rel_id', $id);
            $this->db->delete(db_prefix() . 'reminders');

            $this->db->where('rel_type', 'lead');
            $this->db->where('rel_id', $id);
            $this->db->delete(db_prefix() . 'taggables');

            $this->load->model('proposals_model');
            $this->db->where('rel_id', $id);
            $this->db->where('rel_type', 'lead');
            $proposals = $this->db->get(db_prefix() . 'proposals')->result_array();

            foreach ($proposals as $proposal) {
                $this->proposals_model->delete($proposal['id']);
            }

            // Get related tasks
            $this->db->where('rel_type', 'lead');
            $this->db->where('rel_id', $id);
            $tasks = $this->db->get(db_prefix() . 'tasks')->result_array();
            foreach ($tasks as $task) {
                $this->tasks_model->delete_task($task['id']);
            }

            if (is_gdpr()) {
                $this->db->where('(description LIKE "%' . $lead->email . '%" OR description LIKE "%' . $lead->name . '%" OR description LIKE "%' . $lead->phonenumber . '%")');
                $this->db->delete(db_prefix() . 'activity_log');
            }

            $affectedRows++;
        }
        if ($affectedRows > 0) {
            hooks()->do_action('after_lead_deleted', $id);
            return true;
        }

        return false;
    }

    /**
     * Mark lead as lost
     * @param  mixed $id lead id
     * @return boolean
     */
    public function mark_as_lost($id)
    {
        $this->db->select('status');
        $this->db->from(db_prefix() . 'leads');
        $this->db->where('id', $id);
        $last_lead_status = $this->db->get()->row()->status;

        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'leads', [
            'lost' => 1,
            'status' => 0,
            'last_status_change' => date('Y-m-d H:i:s'),
            'last_lead_status' => $last_lead_status,
        ]);

        if ($this->db->affected_rows() > 0) {
            $this->log_lead_activity($id, 'not_lead_activity_marked_lost');

            log_activity('Lead Marked as Lost [ID: ' . $id . ']');

            hooks()->do_action('lead_marked_as_lost', $id);

            return true;
        }

        return false;
    }

    /**
     * Unmark lead as lost
     * @param  mixed $id leadid
     * @return boolean
     */
    public function unmark_as_lost($id)
    {
        $this->db->select('last_lead_status');
        $this->db->from(db_prefix() . 'leads');
        $this->db->where('id', $id);
        $last_lead_status = $this->db->get()->row()->last_lead_status;

        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'leads', [
            'lost' => 0,
            'status' => $last_lead_status,
        ]);
        if ($this->db->affected_rows() > 0) {
            $this->log_lead_activity($id, 'not_lead_activity_unmarked_lost');

            log_activity('Lead Unmarked as Lost [ID: ' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * Mark lead as junk
     * @param  mixed $id lead id
     * @return boolean
     */
    public function mark_as_junk($id)
    {
        $this->db->select('status');
        $this->db->from(db_prefix() . 'leads');
        $this->db->where('id', $id);
        $last_lead_status = $this->db->get()->row()->status;

        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'leads', [
            'junk' => 1,
            'status' => 0,
            'last_status_change' => date('Y-m-d H:i:s'),
            'last_lead_status' => $last_lead_status,
        ]);

        if ($this->db->affected_rows() > 0) {
            $this->log_lead_activity($id, 'not_lead_activity_marked_junk');

            log_activity('Lead Marked as Junk [ID: ' . $id . ']');

            hooks()->do_action('lead_marked_as_junk', $id);

            return true;
        }

        return false;
    }
    // delete borrower checklist details
    public function delete_borrower_checklist($lead_id, $leads_borrow_id)
    {
        $this->db->where('lead_borrow_id', $leads_borrow_id);
        $this->db->where('rel_id', $lead_id);
        $this->db->where('rel_type', 'user-task');
        $deleted = $this->db->delete(db_prefix() . 'tasks');
    }
    // delete record from the leadS_borrow
    public function delete_borrow_record($leads_borrow_id)
    {
        if ($leads_borrow_id) {
            $this->db->where('id', $leads_borrow_id);
            $deleted = $this->db->delete(db_prefix() . 'leads_borrow');
            return $deleted;
        } else {
            return false;
        }
    }
    /**
     * Unmark lead as junk
     * @param  mixed $id leadid
     * @return boolean
     */
    public function unmark_as_junk($id)
    {
        $this->db->select('last_lead_status');
        $this->db->from(db_prefix() . 'leads');
        $this->db->where('id', $id);
        $last_lead_status = $this->db->get()->row()->last_lead_status;

        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'leads', [
            'junk' => 0,
            'status' => $last_lead_status,
        ]);
        if ($this->db->affected_rows() > 0) {
            $this->log_lead_activity($id, 'not_lead_activity_unmarked_junk');
            log_activity('Lead Unmarked as Junk [ID: ' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * Get lead attachments
     * @since Version 1.0.4
     * @param  mixed $id lead id
     * @return array
     */
    public function get_lead_attachments($id = '', $attachment_id = '', $where = [])
    {
        $this->db->where($where);
        $idIsHash = !is_numeric($attachment_id) && strlen($attachment_id) == 32;
        if (is_numeric($attachment_id) || $idIsHash) {
            $this->db->where($idIsHash ? 'attachment_key' : 'id', $attachment_id);

            return $this->db->get(db_prefix() . 'files')->row();
        }
        $this->db->where('rel_id', $id);
        $this->db->where('rel_type', 'lead');
        $this->db->order_by('dateadded', 'DESC');

        return $this->db->get(db_prefix() . 'files')->result_array();
    }

    public function add_attachment_to_database($lead_id, $attachment, $external = false, $form_activity = false)
    {
        $this->misc_model->add_attachment_to_database($lead_id, 'lead', $attachment, $external);

        if ($form_activity == false) {
            $this->leads_model->log_lead_activity($lead_id, 'not_lead_activity_added_attachment');
        } else {
            $this->leads_model->log_lead_activity($lead_id, 'not_lead_activity_log_attachment', true, serialize([
                $form_activity,
            ]));
        }

        // No notification when attachment is imported from web to lead form
        if ($form_activity == false) {
            $lead = $this->get($lead_id);
            $not_user_ids = [];
            if ($lead->addedfrom != get_staff_user_id()) {
                array_push($not_user_ids, $lead->addedfrom);
            }
            if ($lead->assigned != get_staff_user_id() && $lead->assigned != 0) {
                array_push($not_user_ids, $lead->assigned);
            }
            $notifiedUsers = [];
            foreach ($not_user_ids as $uid) {
                $notified = add_notification([
                    'description' => 'not_lead_added_attachment',
                    'touserid' => $uid,
                    'link' => '#leadid=' . $lead_id,
                    'additional_data' => serialize([
                        $lead->name,
                    ]),
                ]);
                if ($notified) {
                    array_push($notifiedUsers, $uid);
                }
            }
            pusher_trigger_notification($notifiedUsers);
        }
    }

    /**
     * Delete lead attachment
     * @param  mixed $id attachment id
     * @return boolean
     */
    public function delete_lead_attachment($id)
    {
        $attachment = $this->get_lead_attachments('', $id);
        $deleted = false;

        if ($attachment) {
            if (empty($attachment->external)) {
                unlink(get_upload_path_by_type('lead') . $attachment->rel_id . '/' . $attachment->file_name);
            }
            $this->db->where('id', $attachment->id);
            $this->db->delete(db_prefix() . 'files');
            if ($this->db->affected_rows() > 0) {
                $deleted = true;
                log_activity('Lead Attachment Deleted [ID: ' . $attachment->rel_id . ']');
            }

            if (is_dir(get_upload_path_by_type('lead') . $attachment->rel_id)) {
                // Check if no attachments left, so we can delete the folder also
                $other_attachments = list_files(get_upload_path_by_type('lead') . $attachment->rel_id);
                if (count($other_attachments) == 0) {
                    // okey only index.html so we can delete the folder also
                    delete_dir(get_upload_path_by_type('lead') . $attachment->rel_id);
                }
            }
        }

        return $deleted;
    }

    // Sources

    /**
     * Get leads sources
     * @param  mixed $id Optional - Source ID
     * @return mixed object if id passed else array
     */
    public function get_source($id = false)
    {
        if (is_numeric($id)) {
            $this->db->where('id', $id);

            return $this->db->get(db_prefix() . 'leads_sources')->row();
        }

        $this->db->order_by('name', 'asc');

        return $this->db->get(db_prefix() . 'leads_sources')->result_array();
    }

    /**
     * Add new lead source
     * @param mixed $data source data
     */
    public function add_source($data)
    {
        $this->db->insert(db_prefix() . 'leads_sources', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('New Leads Source Added [SourceID: ' . $insert_id . ', Name: ' . $data['name'] . ']');
        }

        return $insert_id;
    }

    /**
     * Update lead source
     * @param  mixed $data source data
     * @param  mixed $id   source id
     * @return boolean
     */
    public function update_source($data, $id)
    {
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'leads_sources', $data);
        if ($this->db->affected_rows() > 0) {
            log_activity('Leads Source Updated [SourceID: ' . $id . ', Name: ' . $data['name'] . ']');

            return true;
        }

        return false;
    }

    /**
     * Delete lead source from database
     * @param  mixed $id source id
     * @return mixed
     */
    public function delete_source($id)
    {
        $current = $this->get_source($id);
        // Check if is already using in table
        if (is_reference_in_table('source', db_prefix() . 'leads', $id) || is_reference_in_table('lead_source', db_prefix() . 'leads_email_integration', $id)) {
            return [
                'referenced' => true,
            ];
        }
        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'leads_sources');
        if ($this->db->affected_rows() > 0) {
            if (get_option('leads_default_source') == $id) {
                update_option('leads_default_source', '');
            }
            log_activity('Leads Source Deleted [SourceID: ' . $id . ']');

            return true;
        }

        return false;
    }

    // Statuses

    /**
     * Get lead statuses
     * @param  mixed $id status id
     * @return mixed      object if id passed else array
     */
    public function get_status($id = '', $where = [])
    {
        $this->db->where($where);
        if (is_numeric($id)) {
            $this->db->where('id', $id);

            return $this->db->get(db_prefix() . 'leads_status')->row();
        }

        $statuses = $this->app_object_cache->get('leads-all-statuses');

        if (!$statuses) {
            $this->db->order_by('statusorder', 'asc');

            $statuses = $this->db->get(db_prefix() . 'leads_status')->result_array();
            $this->app_object_cache->add('leads-all-statuses', $statuses);
        }

        return $statuses;
    }
    public function get_leads_status_wrapper()
    {
        $this->db->order_by('statusorder', 'asc');
        $statuses = $this->db->get(db_prefix() . 'leads_status')->result_array();
        return $statuses ?? [];
    }

    /**
     * Add new lead status
     * @param array $data lead status data
     */
    public function add_status($data)
    {
        if (isset($data['color']) && $data['color'] == '') {
            $data['color'] = hooks()->apply_filters('default_lead_status_color', '#757575');
        }

        if (!isset($data['statusorder'])) {
            $data['statusorder'] = total_rows(db_prefix() . 'leads_status') + 1;
        }

        $this->db->insert(db_prefix() . 'leads_status', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('New Leads Status Added [StatusID: ' . $insert_id . ', Name: ' . $data['name'] . ']');

            return $insert_id;
        }

        return false;
    }

    public function update_status($data, $id)
    {
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'leads_status', $data);
        if ($this->db->affected_rows() > 0) {
            log_activity('Leads Status Updated [StatusID: ' . $id . ', Name: ' . $data['name'] . ']');

            return true;
        }

        return false;
    }
    // update the closed status
     public function update_closed_status($id)
    {
        $data = array(
            'status' => 5,
            'active_case' => 'Closed',
        );
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'leads', $data);
        if ($this->db->affected_rows() > 0) {
            // add the activity log of closed stage completed
            $insert_task_activity = array(
                'leadid' => $id,
                'staffid' => get_staff_user_id(),
                'full_name' => get_staff_full_name(),
                'description' => 'Case closed stage (#' . $id . ') has been completed by ' . get_staff_full_name() . '.',
                'date' => date('Y-m-d H:i:s'),
                'activity_type' => ''
            );
            leads_activity_log($this, $insert_task_activity);
            return true;
        }

        return false;
    }
    // update the secure payout expiry date
    public function update_checkbox_expire_date($lead_id, $checkbox_id, $expire_date) {
        $updated_data = [
            'payout_expire_date' => $expire_date
        ];

        $this->db->where('lead_id', $lead_id);
        $this->db->where('id', $checkbox_id);
        $this->db->update(db_prefix() . 'cases_checkboxes', $updated_data);

        return $this->db->affected_rows();
    }
    // update the secure received status
    public function update_secure_received_status($checkbox_id, $value) {
        $this->db->where('id', $checkbox_id);
        $this->db->update(db_prefix() . 'cases_checkboxes', ['secure_received_option' => $value]);

        return $this->db->affected_rows();
    }
    // check record exit again lead id for lender appt confirmation email
    public function check_lender_appt_confirmation_email($lead_id)
    {
        $this->db->select('lender_appt_confirmation_email');
        $this->db->from(db_prefix() . 'cases_details');
        $this->db->where('lead_id', $lead_id);
        $result = $this->db->get()->row();
        if ($result && $result->lender_appt_confirmation_email == 1) {
            return true;
        }
        return false;
    }
    // Insert the lender appt confirmation email status
    public function insert_lender_appt_confirmation_email_status($lead_id)
    {
        $data = array(
            'lead_id' => $lead_id,
            'lender_appt_confirmation_email' => 1,
        );
        $this->db->insert(db_prefix() . 'cases_details', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        }

        return false;
    }
    // update the lender appt confirmation email status 
    public function update_lender_appt_confirmation_email_status($lead_id)
    {
        $data = array(
            'lender_appt_confirmation_email' => 1,
        );
        $this->db->where('lead_id', $lead_id);
        $this->db->update(db_prefix() . 'cases_details', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        }

        return false;
    }
    public function save_appt_client_email_draft_model($lead_id, $to, $cc, $bcc, $content, $leads_status, $type, $editor_id)
    {
        $data = [
            'lead_id'        => $lead_id,
            'to_email'       => $to,
            'cc_email'       => $cc,
            'bcc_email'      => $bcc,
            'email_content'  => $content,
            'is_draft'       => 1,
            'leads_status'   => $leads_status,
            'editor_id'      => $editor_id,
            'type'           => $type,
            'addedfrom'      => get_staff_user_id(),
            'addedfrom_name' => get_staff_full_name(),
            'updated_at'     => date('Y-m-d H:i:s'),
        ];

        // Check if draft exists
        $this->db->where('lead_id', $lead_id);
        $this->db->where('leads_status', $leads_status);
        $this->db->where('type', $type);
        $existing = $this->db->get(db_prefix() . 'lead_email_drafts')->row();

        if ($existing) {
            $this->db->where('id', $existing->id);
            $this->db->update(db_prefix() . 'lead_email_drafts', $data);
        } else {
            $data['created_at'] = date('Y-m-d H:i:s');
            $this->db->insert(db_prefix() . 'lead_email_drafts', $data);
        }

        return true;
    }
    // update Dreaft Email
    public function update_email_draft($lead_id, $data)
    {
        if (empty($data['draft_id'])) {
            return false;
        }

        $updateData = [
            'to_email'      => $data['to'] ?? '',
            'cc_email'      => $data['cc'] ?? '',
            'bcc_email'     => $data['bcc'] ?? '',
            'email_content' => $data['content'] ?? '',
            'updated_at'    => date('Y-m-d H:i:s'),
        ];

        $this->db->where('id', $data['draft_id']);
        return $this->db->update(db_prefix() . 'lead_email_drafts', $updateData);
    }
    // Delete Draft Emails record
    public function delete_draft_record($draft_id){
        if(!empty($draft_id)){
            $this->db->where('id', $draft_id);
            $this->db->delete(db_prefix() . 'lead_email_drafts');
            if ($this->db->affected_rows() > 0) {
                return true;
            }
        }
        return false;
    }



    // update the task details when checklist template details update
    public function update_task_details_using_checklist_temp_id($task_id, $task_type, $data)
    {
        $this->db->where('checklist_temp_id', $task_id);
        $this->db->update(db_prefix() . 'tasks', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        }

        return false;
    }
    public function update_checkboxes_details($checkboxes_id, $task_type, $data)
    {
        $this->db->where('checklist_temp_id', $checkboxes_id);
        $this->db->update(db_prefix() . 'cases_checkboxes', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        }

        return false;
    }
    /**
     * Delete lead status from database
     * @param  mixed $id status id
     * @return boolean
     */
    public function delete_status($id)
    {
        $current = $this->get_status($id);
        // Check if is already using in table
        if (is_reference_in_table('status', db_prefix() . 'leads', $id) || is_reference_in_table('lead_status', db_prefix() . 'leads_email_integration', $id)) {
            return [
                'referenced' => true,
            ];
        }

        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'leads_status');
        if ($this->db->affected_rows() > 0) {
            if (get_option('leads_default_status') == $id) {
                update_option('leads_default_status', '');
            }
            log_activity('Leads Status Deleted [StatusID: ' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * Update canban lead status when drag and drop
     * @param  array $data lead data
     * @return boolean
     */
    public function update_lead_status($data)
    {
        $this->db->select('status');
        $this->db->where('id', $data['leadid']);
        $_old = $this->db->get(db_prefix() . 'leads')->row();

        $old_status = '';

        if ($_old) {
            $old_status = $this->get_status($_old->status);
            if ($old_status) {
                $old_status = $old_status->name;
            }
        }

        $affectedRows = 0;
        $current_status = $this->get_status($data['status'])->name;

        $this->db->where('id', $data['leadid']);
        $this->db->update(db_prefix() . 'leads', [
            'status' => $data['status'],
        ]);
        if ($data['status'] == 5) {
            $this->db->where('id', $data['leadid']);
            $this->db->update(db_prefix() . 'leads', [
                'active_case' => 'Closed',
            ]);
        } elseif ($data['status'] == 6) {
            $this->db->where('id', $data['leadid']);
            $this->db->update(db_prefix() . 'leads', [
                'active_case' => 'On Hold',
            ]);
        } else {
            $this->db->where('id', $data['leadid']);
            $this->db->update(db_prefix() . 'leads', [
                'active_case' => 'Active',
            ]);
        }
        $_log_message = '';

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
            if ($current_status != $old_status && $old_status != '') {
                $_log_message = 'not_lead_activity_status_updated';
                $additional_data = serialize([
                    get_staff_full_name(),
                    $old_status,
                    $current_status,
                ]);

                hooks()->do_action('lead_status_changed', [
                    'lead_id' => $data['leadid'],
                    'old_status' => $old_status,
                    'new_status' => $current_status,
                ]);
            }
            $this->db->where('id', $data['leadid']);
            $this->db->update(db_prefix() . 'leads', [
                'last_status_change' => date('Y-m-d H:i:s'),
            ]);
        }

        if (isset($data['order'])) {
            AbstractKanban::updateOrder($data['order'], 'leadorder', 'leads', $data['status']);
        }

        if ($affectedRows > 0) {
            if ($_log_message == '') {
                return true;
            }

            $this->log_lead_activity($data['leadid'], $_log_message, false, $additional_data);

            return true;
        }

        return false;
    }

    /* Ajax */

    /**
     * All lead activity by staff
     * @param  mixed $id lead id
     * @return array
     */
    public function get_lead_activity_log($id)
    {
        $sorting = hooks()->apply_filters('lead_activity_log_default_sort', 'DESC');
        $current_staff_role = get_current_staff_role($this, get_staff_user_id());
        if ($current_staff_role == 2 || $current_staff_role == 6) {
            $this->db->where('staffid', get_staff_user_id());
        } else {
            $this->db->where('leadid', $id);
        }
        $this->db->order_by('date', $sorting);

        return $this->db->get(db_prefix() . 'lead_activity_log')->result_array();
    }

    public function staff_can_access_lead($id, $staff_id = '')
    {
        $staff_id = $staff_id == '' ? get_staff_user_id() : $staff_id;

        if (has_permission('leads', $staff_id, 'view')) {
            return true;
        }

        $CI = &get_instance();

        if (total_rows(db_prefix() . 'leads', 'id="' . $CI->db->escape_str($id) . '" AND (assigned=' . $CI->db->escape_str($staff_id) . ' OR is_public=1 OR addedfrom=' . $CI->db->escape_str($staff_id) . ')') > 0) {
            return true;
        }

        return false;
    }

    /**
     * Add lead activity from staff
     * @param  mixed  $id          lead id
     * @param  string  $description activity description
     */
    public function log_lead_activity($id, $description, $integration = false, $additional_data = '')
    {
        $log = [
            'date' => date('Y-m-d H:i:s'),
            'description' => $description,
            'leadid' => $id,
            'staffid' => get_staff_user_id(),
            'additional_data' => $additional_data,
            'full_name' => get_staff_full_name(get_staff_user_id()),
        ];
        if ($integration == true) {
            $log['staffid'] = 0;
            $log['full_name'] = '[CRON]';
        }

        $this->db->insert(db_prefix() . 'lead_activity_log', $log);

        return $this->db->insert_id();
    }

    /**
     * Get email integration config
     * @return object
     */
    public function get_email_integration()
    {
        $this->db->where('id', 1);

        return $this->db->get(db_prefix() . 'leads_email_integration')->row();
    }

    /**
     * Get lead imported email activity
     * @param  mixed $id leadid
     * @return array
     */
    public function get_mail_activity($id)
    {
        $this->db->where('leadid', $id);
        $this->db->order_by('dateadded', 'asc');

        return $this->db->get(db_prefix() . 'lead_integration_emails')->result_array();
    }

    /**
     * Update email integration config
     * @param  mixed $data All $_POST data
     * @return boolean
     */
    public function update_email_integration($data)
    {
        $this->db->where('id', 1);
        $original_settings = $this->db->get(db_prefix() . 'leads_email_integration')->row();

        $data['create_task_if_customer'] = isset($data['create_task_if_customer']) ? 1 : 0;
        $data['active'] = isset($data['active']) ? 1 : 0;
        $data['delete_after_import'] = isset($data['delete_after_import']) ? 1 : 0;
        $data['notify_lead_imported'] = isset($data['notify_lead_imported']) ? 1 : 0;
        $data['only_loop_on_unseen_emails'] = isset($data['only_loop_on_unseen_emails']) ? 1 : 0;
        $data['notify_lead_contact_more_times'] = isset($data['notify_lead_contact_more_times']) ? 1 : 0;
        $data['mark_public'] = isset($data['mark_public']) ? 1 : 0;
        $data['responsible'] = !isset($data['responsible']) ? 0 : $data['responsible'];

        if ($data['notify_lead_contact_more_times'] != 0 || $data['notify_lead_imported'] != 0) {
            if (isset($data['notify_type']) && $data['notify_type'] == 'specific_staff') {
                if (isset($data['notify_ids_staff'])) {
                    $data['notify_ids'] = serialize($data['notify_ids_staff']);
                    unset($data['notify_ids_staff']);
                } else {
                    $data['notify_ids'] = serialize([]);
                    unset($data['notify_ids_staff']);
                }
                if (isset($data['notify_ids_roles'])) {
                    unset($data['notify_ids_roles']);
                }
            } else {
                if (isset($data['notify_ids_roles'])) {
                    $data['notify_ids'] = serialize($data['notify_ids_roles']);
                    unset($data['notify_ids_roles']);
                } else {
                    $data['notify_ids'] = serialize([]);
                    unset($data['notify_ids_roles']);
                }
                if (isset($data['notify_ids_staff'])) {
                    unset($data['notify_ids_staff']);
                }
            }
        } else {
            $data['notify_ids'] = serialize([]);
            $data['notify_type'] = null;
            if (isset($data['notify_ids_staff'])) {
                unset($data['notify_ids_staff']);
            }
            if (isset($data['notify_ids_roles'])) {
                unset($data['notify_ids_roles']);
            }
        }

        // Check if not empty $data['password']
        // Get original
        // Decrypt original
        // Compare with $data['password']
        // If equal unset
        // If not encrypt and save
        if (!empty($data['password'])) {
            $or_decrypted = $this->encryption->decrypt($original_settings->password);
            if ($or_decrypted == $data['password']) {
                unset($data['password']);
            } else {
                $data['password'] = $this->encryption->encrypt($data['password']);
            }
        }

        $this->db->where('id', 1);
        $this->db->update(db_prefix() . 'leads_email_integration', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        }

        return false;
    }

    public function change_status_color($data)
    {
        $this->db->where('id', $data['status_id']);
        $this->db->update(db_prefix() . 'leads_status', [
            'color' => $data['color'],
        ]);
    }

    public function update_status_order($data)
    {
        foreach ($data['order'] as $status) {
            $this->db->where('id', $status[0]);
            $this->db->update(db_prefix() . 'leads_status', [
                'statusorder' => $status[1],
            ]);
        }
    }

    public function update_status_by_task_id($task_id, $status)
    {
        $this->db->where('id', $task_id);
        $this->db->update(db_prefix() . 'tasks', [
            'status' => $status,
        ]);
    }

    public function get_form($where)
    {
        $this->db->where($where);

        return $this->db->get(db_prefix() . 'web_to_lead')->row();
    }

    public function add_form($data)
    {
        $data = $this->_do_lead_web_to_form_responsibles($data);
        $data['success_submit_msg'] = nl2br($data['success_submit_msg']);
        $data['form_key'] = app_generate_hash();

        $data['create_task_on_duplicate'] = (int) isset($data['create_task_on_duplicate']);
        $data['mark_public'] = (int) isset($data['mark_public']);

        if (isset($data['allow_duplicate'])) {
            $data['allow_duplicate'] = 1;
            $data['track_duplicate_field'] = '';
            $data['track_duplicate_field_and'] = '';
            $data['create_task_on_duplicate'] = 0;
        } else {
            $data['allow_duplicate'] = 0;
        }

        $data['dateadded'] = date('Y-m-d H:i:s');

        $this->db->insert(db_prefix() . 'web_to_lead', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('New Web to Lead Form Added [' . $data['name'] . ']');

            return $insert_id;
        }

        return false;
    }

    public function update_form($id, $data)
    {
        $data = $this->_do_lead_web_to_form_responsibles($data);
        $data['success_submit_msg'] = nl2br($data['success_submit_msg']);

        $data['create_task_on_duplicate'] = (int) isset($data['create_task_on_duplicate']);
        $data['mark_public'] = (int) isset($data['mark_public']);

        if (isset($data['allow_duplicate'])) {
            $data['allow_duplicate'] = 1;
            $data['track_duplicate_field'] = '';
            $data['track_duplicate_field_and'] = '';
            $data['create_task_on_duplicate'] = 0;
        } else {
            $data['allow_duplicate'] = 0;
        }

        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'web_to_lead', $data);

        return ($this->db->affected_rows() > 0 ? true : false);
    }

    public function delete_form($id)
    {
        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'web_to_lead');

        $this->db->where('from_form_id', $id);
        $this->db->update(db_prefix() . 'leads', [
            'from_form_id' => 0,
        ]);

        if ($this->db->affected_rows() > 0) {
            log_activity('Lead Form Deleted [' . $id . ']');

            return true;
        }

        return false;
    }

    private function _do_lead_web_to_form_responsibles($data)
    {
        if (isset($data['notify_lead_imported'])) {
            $data['notify_lead_imported'] = 1;
        } else {
            $data['notify_lead_imported'] = 0;
        }

        if ($data['responsible'] == '') {
            $data['responsible'] = 0;
        }
        if ($data['notify_lead_imported'] != 0) {
            if ($data['notify_type'] == 'specific_staff') {
                if (isset($data['notify_ids_staff'])) {
                    $data['notify_ids'] = serialize($data['notify_ids_staff']);
                    unset($data['notify_ids_staff']);
                } else {
                    $data['notify_ids'] = serialize([]);
                    unset($data['notify_ids_staff']);
                }
                if (isset($data['notify_ids_roles'])) {
                    unset($data['notify_ids_roles']);
                }
            } else {
                if (isset($data['notify_ids_roles'])) {
                    $data['notify_ids'] = serialize($data['notify_ids_roles']);
                    unset($data['notify_ids_roles']);
                } else {
                    $data['notify_ids'] = serialize([]);
                    unset($data['notify_ids_roles']);
                }
                if (isset($data['notify_ids_staff'])) {
                    unset($data['notify_ids_staff']);
                }
            }
        } else {
            $data['notify_ids'] = serialize([]);
            $data['notify_type'] = null;
            if (isset($data['notify_ids_staff'])) {
                unset($data['notify_ids_staff']);
            }
            if (isset($data['notify_ids_roles'])) {
                unset($data['notify_ids_roles']);
            }
        }

        return $data;
    }

    public function do_kanban_query($status, $search = '', $page = 1, $sort = [], $count = false)
    {
        _deprecated_function('Leads_model::do_kanban_query', '2.9.2', 'LeadsKanban class');

        $kanBan = (new LeadsKanban($status))
            ->search($search)
            ->page($page)
            ->sortBy($sort['sort'] ?? null, $sort['sort_by'] ?? null);

        if ($count) {
            return $kanBan->countAll();
        }

        return $kanBan->get();
    }
}
