<?php
class Comment_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    // public function getCommentsWithUserInfo($userid, $lead_id)
    // {
    //     $this->db->select('comments.comment_text,comments.role,comments.to_user_id,comments.from_user_id, comments.created_at, comments.send_to, contacts.id, contacts.firstname, contacts.lastname');
    //     $this->db->from(db_prefix() . 'comments');
    //     $this->db->join(db_prefix() . 'contacts', 'contacts.id = ' . $userid);
    //     $this->db->join(db_prefix() . 'leads', 'leads.id = comments.lead_id');

    //     // Add the where conditions
    //     // $this->db->where('comments.type', 'client-to-ld');
    //     $this->db->where('comments.type', 'broker-to-ld');
    //     $this->db->where('contacts.id', $userid);
    //     $this->db->where('leads.id', $lead_id);

    //     $this->db->group_by(db_prefix() . 'comments.comment_id');
    //     $this->db->order_by('comments.created_at', 'desc');


    //     return $this->db->get()->result();
    // }

    public function getCommentsWithUserInfo($userid, $lead_id)
    {
        $this->db->select('comments.comment_text,comments.role,comments.to_user_id,comments.from_user_id, comments.created_at, contacts.id, contacts.firstname, contacts.lastname');
        $this->db->from(db_prefix() . 'comments');
        $this->db->join(db_prefix() . 'contacts', 'contacts.id = ' . $userid);
        $this->db->join(db_prefix() . 'leads', 'leads.id = comments.lead_id');

        // Add the where conditions
        $this->db->where('comments.type', 'client-to-ld');
        $this->db->where('contacts.id', $userid);
        $this->db->where('leads.id', $lead_id);

        $this->db->group_by(db_prefix() . 'comments.comment_id');
        $this->db->order_by('comments.created_at', 'desc');


        return $this->db->get()->result();
    }

    public function add_comment($data)
    {
        $this->db->insert(db_prefix() . 'comments', $data);
        return $this->db->insert_id();
    }
    public function add_read_comment($data)
    {
        return $this->db->insert(db_prefix() . 'read_comments', $data);
    }
}
