<?php

defined('BASEPATH') or exit('No direct script access allowed');
function load_env()
{
    // Root path to .env
    $envPath = FCPATH . '.env'; // or adjust if deeper like '../../.env'

    if (!file_exists($envPath)) {
        echo "ENV file not found at: $envPath"; exit;
    }

    $lines = file($envPath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) continue;
        list($name, $value) = explode('=', $line, 2);
        $name = trim($name);
        $value = trim($value);
        putenv("$name=$value");
        $_ENV[$name] = $value;
    }
}
