<?php

defined('BASEPATH') or exit('No direct script access allowed');

use chriskacerguis\RestServer\RestController;
use Firebase\JWT\JWT; // Import JWT library

class Cases extends RestController
{
    public function __construct()
    {
        parent::__construct();

        $this->load->library('form_validation');
        $this->load->database();
        $this->load->model('Contacts_model');
        $this->load->model('Leads_model');
        $this->load->model('Token_model');
        $this->load->library('email');
        $this->load->library('AuthMiddleware');
        $this->load->helper('response_helper');
        $this->load->helper('admin_helper');
        $this->load->helper('staff_helper');
        $this->load->helper('notification_helper');
        $this->load->helper('userimage_url_helper');
        $this->load->helper('leads_helper');
        $this->load->helper('userid_get_helper');
        $this->load->library('session');
        $this->load->helper(array('form', 'url'));
        $this->load->database();
        $this->load->model('Notification_model');
        $this->load->model('Comment_model');
        $this->load->model('file_instruction_model');
        $this->load->library('pagination');
    }
    // Admin get all cases
    public function getallcase_post()
    {
        $getemail = $this->authmiddleware->verifyToken();
        if (empty($getemail)) {
        } else {
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                $response = array(
                    'status' => 400,
                    'message' => 'Invalid request method.',
                    'data' => null,
                );
                getresponse($this, $response);
            } else {
                $data = $this->Contacts_model->getEmail($getemail);
                if (!empty($data)) {
                    // get staff role
                    $get_role = array_column($data, 'role');
                    $role_string = implode(',', $get_role);
                    // get the group names
                    $filter_group = $this->input->post('team');
                    if (!empty($filter_group)) {
                        $filter_group_ids = explode(',', $filter_group);
                        // Fetch group names based on group IDs
                        $this->db->select('group_name');
                        $this->db->where_in('id', $filter_group_ids);
                        $group_data = $this->db->get(db_prefix() . 'group')->result();
                        $filter_group_array = [];
                        // Extract group names from the result set
                        foreach ($group_data as $value) {
                            $filter_group_array[] = $value->group_name;
                        }
                        // $filter_group_array = implode(',', $filter_group_array);
                    }
                    // get the staff group name
                    $get_staff_group = array_column($data, 'staff_group');
                    $staff_group_string = implode(',', $get_staff_group);
                    if (is_numeric($role_string) && $role_string > 0) {
                        $staff_role_name = if_role_is_id_then_get_staff_role_name($this, $role_string);
                        // $Response_Data['profile_url'] = get_staff_profile_url($string_staffid, $profile_image_string);
                    }
                    if ($role_string == 4 || $staff_role_name == 'Admin') {
                        // Configuring pagination
                        $config['base_url'] = site_url('api/admin/Cases/getallcase');
                        $config['total_rows'] = $this->db->count_all_results(db_prefix() . 'leads');
                        $config['per_page'] = $this->input->post('per_page'); // Adjust the number of records per page as needed
                        $config['uri_segment'] = 3;

                        $this->pagination->initialize($config);

                        $staff_name = '';
                        $case_record = array();
                        // Filtering by case stage
                        $case_stage = $this->input->post('case_stage');
                        $numeric_value = '';

                        switch ($case_stage) {
                            case 'file_opened':
                                $numeric_value = 1;
                                break;
                            case 'instructions_received':
                                $numeric_value = 2;
                                break;
                            case 'outstanding_items':
                                $numeric_value = 3;
                                break;
                            case 'request_for_funds':
                                $numeric_value = 4;
                                break;
                            case 'closed':
                                $numeric_value = 5;
                                break;
                            case 'on_hold':
                                $numeric_value = 6;
                                break;
                            case 'appointment_request':
                                $numeric_value = 7;
                                break;
                            case 'id_verification':
                                $numeric_value = 8;
                                break;
                            case 'archive':
                                $numeric_value = 9;
                                break;
                        default:
                                break;
                        }
                        // Get the page number from the mobile app
                        $page = $this->input->post('page') ? $this->input->post('page') : 0;
                        // Get the search term from the mobile app
                        $search_term = $this->input->post('search');
                        $this->db->select('*');
                        $this->db->group_start();
                        $this->db->like('name', $search_term);
                        $this->db->or_like('id', $search_term);
                        $this->db->or_like('assign_group', $search_term);
                        $this->db->group_end();
                        $this->db->limit($config['per_page'], $page * $config['per_page']); // Adjust the offset

                        // Sorting
                        // 1  ='recent' 2 =  'a_to_z' 3 = 'z_to_a' 4 = 'date_asc' 5 = 'date_desc'
                        $sort_order = $this->input->post('sort_by');
                        switch ($sort_order) {
                            case 2:
                                $this->db->order_by('name', 'asc');
                                break;
                            case 3:
                                $this->db->order_by('name', 'desc');
                                break;
                            case 4:
                                $this->db->order_by('dateadded', 'asc');
                                break;
                            case 5:
                                $this->db->order_by('dateadded', 'desc');
                                break;
                            case 1:
                            default:
                                $this->db->order_by('dateadded', 'desc');
                                break;
                        }

                        // Filtering by Broker
                        $broker_filter = $this->input->post('broker');
                        if ($broker_filter) {
                            $filter_broker_array = array_map('intval', explode(',', $broker_filter));
                            $this->db->where_in('addedfrom', $filter_broker_array);
                        }

                        // Filtering by group name
                        if ($filter_group) {
                            $this->db->where_in('assign_group', $filter_group_array);
                        }
                        // Filtering by case stage
                        if ($case_stage) {
                            $this->db->where_in('status', $numeric_value);
                        }
                        $lead_record = $this->db->get(db_prefix() . 'leads');


                        if ($lead_record->num_rows() > 0) {
                            $lead_data = $lead_record->result();

                            foreach ($lead_data as $value) {
                                // break the string of primary name
                                $primary_name = explode(' ', $value->name, 3);
                                $firstname = '';
                                $middlename = '';
                                $lastname = '';
                                
                                if (isset($primary_name[0])) {
                                    $firstname = $primary_name[0];
                                }
                                if (isset($primary_name[1])) {
                                    $middlename = $primary_name[1];
                                }
                                if (isset($primary_name[2])) {
                                    $lastname = $primary_name[2];
                                }
                                
                                // break the string of secondary name
                                $secondary_name = explode(' ', $value->secondary_name, 3);
                                $secondary_firstname = '';
                                $secondary_middlename = '';
                                $secondary_lastname = '';
                                
                                if (isset($secondary_name[0])) {
                                    $secondary_firstname = $secondary_name[0];
                                }
                                if (isset($secondary_name[1])) {
                                    $secondary_middlename = $secondary_name[1];
                                }
                                if (isset($secondary_name[2])) {
                                    $secondary_lastname = $secondary_name[2];
                                }
                                
                                $this->db->select('firstname,lastname');
                                $this->db->where('staffid', $value->addedfrom);
                                $staff_record = $this->db->get(db_prefix() . 'staff');

                                if ($staff_record->num_rows() > 0) {
                                    $staff_data = $staff_record->row();
                                    $staff_name = $staff_data->firstname . ' ' . $staff_data->lastname;
                                }
                                // get the status of cases
                                $this->db->select('name');
                                $this->db->where('id', $value->status);
                                $leads_status_record = $this->db->get(db_prefix() . 'leads_status');

                                if ($leads_status_record->num_rows() > 0) {
                                    $leads_status_data = $leads_status_record->row();
                                    $status_name = $leads_status_data->name;
                                }
                                // Get total tasks count
                                $this->db->select('COUNT(id) as total_tasks');
                                $this->db->where('rel_id', $value->id);
                                $this->db->where('rel_type', 'user-task');
                                $this->db->where('type','client');
                                $total_tasks_query = $this->db->get(db_prefix() . 'tasks');
                                $total_tasks_result = $total_tasks_query->row();
                                $total_tasks_count = $total_tasks_result->total_tasks;

                                // Get completed tasks count
                                $this->db->select('COUNT(id) as completed_tasks');
                                $this->db->where('rel_id', $value->id);
                                $this->db->where('rel_type', 'user-task');
                                $this->db->where('status', '4');
                                $this->db->where('type','client');
                                $completed_tasks_query = $this->db->get(db_prefix() . 'tasks');
                                $completed_tasks_result = $completed_tasks_query->row();
                                $completed_tasks_count = $completed_tasks_result->completed_tasks;
                                // get the group id 
                                $this->db->select('id');
                                $this->db->where('group_name', $value->assign_group);
                                $group_query = $this->db->get(db_prefix() . 'group');

                                if ($group_query->num_rows() > 0) {
                                    $group_id = $group_query->row()->id;
                                } else {
                                    $group_id = null;
                                }
                                // get the transaction details
                                $leads_transacation_data = leads_bank_details($this, $value->id);
                                $transaction_name = '';
                                if(!empty($leads_transacation_data)){
                                    $transaction_name = get_transaction_name_by_id($this,$leads_transacation_data[0]['transaction_id']);
                                }
                                // split the names and its show it according to the format of crm
                                $split_name = leads_splitFullName($value->name);
                                $CaseName = $split_name['lastname']. ', ' . $split_name['firstname'] . ' ' . $split_name['middlename'];
                                $case_record[] = array(
                                    'case_id' => $value->id,
                                    'name' => $CaseName,
                                    'address' => $value->address,
                                    'martial_status' => $value->martial_status,
                                    // 'transaction' => $value->transaction,
                                    'transaction' => $transaction_name,
                                    'started_at' => strtotime($value->dateadded),
                                    'broker_name' => $staff_name,
                                    'status' => $status_name,
                                    'case_active' => $value->active_case,
                                    'total_task' => $total_tasks_count,
                                    'completed_task' => $completed_tasks_count,
                                    'group' => array('id' => $group_id, 'name' => $value->assign_group),
                                );
                            }

                        }
                    } elseif (in_array($role_string, [1,7,8,9]) || $staff_role_name == 'Agent' || $staff_role_name == 'LD-Team') {
                        // Get the search term from the mobile app
                        $search_term = $this->input->post('search');

                        // Configuring pagination
                        $config['base_url'] = site_url('api/admin/Cases/getallcase');
                        $config['total_rows'] = $this->db->count_all_results(db_prefix() . 'leads');
                        $config['per_page'] = $this->input->post('per_page'); // Adjust the number of records per page as needed
                        $config['uri_segment'] = 3;

                        $this->pagination->initialize($config);

                        $staff_name = '';
                        $case_record = array();
                         // Filtering by case stage
                         $case_stage = $this->input->post('case_stage');
                         $numeric_value = '';
 
                         switch ($case_stage) {
                             case 'file_opened':
                                 $numeric_value = 1;
                                 break;
                             case 'instructions_received':
                                 $numeric_value = 2;
                                 break;
                             case 'outstanding_items':
                                 $numeric_value = 3;
                                 break;
                             case 'request_for_funds':
                                 $numeric_value = 4;
                                 break;
                             case 'closed':
                                 $numeric_value = 5;
                                 break;
                             case 'on_hold':
                                 $numeric_value = 6;
                                 break;
                             case 'appointment_request':
                                 $numeric_value = 7;
                                 break;
                            case 'id_verification':
                                $numeric_value = 8;
                                break;
                            case 'archive':
                                $numeric_value = 9;
                                break;
                             default:
                                 break;
                         }
                        // Get the page number from the mobile app
                        $page = $this->input->post('page') ? $this->input->post('page') : 0;

                        $this->db->select('*');
                        // $this->db->where('assign_group', $staff_group_string);
                        // $this->db->where('active_case', 'Active');

                        // Conditionally add the like clauses if search term is not empty
                        if (!empty($search_term)) {
                            $this->db->group_start();
                            $this->db->like('name', $search_term);
                            $this->db->or_like('id', $search_term);
                            $this->db->or_like('assign_group', $search_term);
                            $this->db->group_end();
                            $this->db->limit($config['per_page'], $page * $config['per_page']); // Adjust the offset
                        }

                        // Sorting
                        // 1  ='recent' 2 =  'a_to_z' 3 = 'z_to_a' 4 = 'date_asc' 5 = 'date_desc'
                        $sort_order = $this->input->post('sort_by');
                        if ($sort_order == 1) {
                            $this->db->order_by('dateadded', 'desc');
                        } elseif ($sort_order == 2) {
                            $this->db->order_by('name', 'asc');
                        } elseif ($sort_order == 3) {
                            $this->db->order_by('name', 'desc');
                        } elseif ($sort_order == 4) {
                            $this->db->order_by('dateadded', 'asc');
                        } elseif ($sort_order == 5) {
                            $this->db->order_by('dateadded', 'desc');
                        }

                        $this->db->limit($config['per_page'], $page * $config['per_page']);
                        // Filtering by group name
                        if ($filter_group) {
                            $this->db->where_in('assign_group', $filter_group_array);
                        }
                         // Filtering by case stage
                         if ($case_stage) {
                            $this->db->where_in('status', $numeric_value);
                        }
                        $lead_record = $this->db->get(db_prefix() . 'leads');

                        if ($lead_record->num_rows() > 0) {
                            $lead_data = $lead_record->result();

                            foreach ($lead_data as $value) {
                                // break the string of primary name
                                $primary_name = explode(' ', $value->name, 3);
                                $firstname = '';
                                $middlename = '';
                                $lastname = '';
                                
                                if (isset($primary_name[0])) {
                                    $firstname = $primary_name[0];
                                }
                                if (isset($primary_name[1])) {
                                    $middlename = $primary_name[1];
                                }
                                if (isset($primary_name[2])) {
                                    $lastname = $primary_name[2];
                                }
                                
                                // break the string of secondary name
                                $secondary_name = explode(' ', $value->secondary_name, 3);
                                $secondary_firstname = '';
                                $secondary_middlename = '';
                                $secondary_lastname = '';
                                
                                if (isset($secondary_name[0])) {
                                    $secondary_firstname = $secondary_name[0];
                                }
                                if (isset($secondary_name[1])) {
                                    $secondary_middlename = $secondary_name[1];
                                }
                                if (isset($secondary_name[2])) {
                                    $secondary_lastname = $secondary_name[2];
                                }

                                $this->db->select('firstname,lastname');
                                $this->db->where('staffid', $value->addedfrom);
                                $staff_record = $this->db->get(db_prefix() . 'staff');

                                if ($staff_record->num_rows() > 0) {
                                    $staff_data = $staff_record->row();
                                    $staff_name = $staff_data->firstname . ' ' . $staff_data->lastname;
                                }
                                // get the status of cases
                                $this->db->select('name');
                                $this->db->where('id', $value->status);
                                $leads_status_record = $this->db->get(db_prefix() . 'leads_status');

                                if ($leads_status_record->num_rows() > 0) {
                                    $leads_status_data = $leads_status_record->row();
                                    $status_name = $leads_status_data->name;
                                }
                                // Get total tasks count
                                $this->db->select('COUNT(id) as total_tasks');
                                $this->db->where('rel_id', $value->id);
                                $this->db->where('rel_type', 'user-task');
                                $this->db->where('type','client');
                                $total_tasks_query = $this->db->get(db_prefix() . 'tasks');
                                $total_tasks_result = $total_tasks_query->row();
                                $total_tasks_count = $total_tasks_result->total_tasks;

                                // Get completed tasks count
                                $this->db->select('COUNT(id) as completed_tasks');
                                $this->db->where('rel_id', $value->id);
                                $this->db->where('rel_type', 'user-task');
                                $this->db->where('status', '4');
                                $this->db->where('type','client');
                                $completed_tasks_query = $this->db->get(db_prefix() . 'tasks');
                                $completed_tasks_result = $completed_tasks_query->row();
                                $completed_tasks_count = $completed_tasks_result->completed_tasks;
                                // get the group id 
                                $this->db->select('id');
                                $this->db->where('group_name', $value->assign_group);
                                $group_query = $this->db->get(db_prefix() . 'group');

                                if ($group_query->num_rows() > 0) {
                                    $group_id = $group_query->row()->id;
                                } else {
                                    $group_id = null;
                                }
                                // get the transaction name
                                $leads_transacation_data = leads_bank_details($this, $value->id);
                                $transaction_name = '';
                                if(!empty($leads_transacation_data)){
                                    $transaction_name = get_transaction_name_by_id($this,$leads_transacation_data[0]['transaction_id']);
                                }
                                // split the names and its show it according to the format of crm
                                $split_name = leads_splitFullName($value->name);
                                $CaseName = $split_name['lastname']. ', ' . $split_name['firstname'] . ' ' . $split_name['middlename'];
                                $case_record[] = array(
                                    'case_id' => $value->id,
                                    'name' => $CaseName,
                                    'address' => $value->address,
                                    'martial_status' => $value->martial_status,
                                    // 'transaction' => $value->transaction,
                                    'transaction' => $transaction_name,
                                    'started_at' => strtotime($value->dateadded),
                                    'broker_name' => $staff_name,
                                    'status' => $status_name,
                                    'case_active' => $value->active_case,
                                    'total_task' => $total_tasks_count,
                                    'completed_task' => $completed_tasks_count,
                                    'group' => array('id' => $group_id, 'name' => $value->assign_group),
                                );
                            }
                        }
                    }
                    $response = array(
                        'status' => 200,
                        'message' => 'All cases data',
                        'data' => $case_record,
                    );

                    // Add pagination to response
                    // $response['pagination'] = $this->pagination->create_links();
                    getresponse($this, $response);
                }
            }
        }
    }
    // get the cases summary
    public function getcasesummary_post(){
        $getemail = $this->authmiddleware->verifyToken();
        if (empty ($getemail)) {
        } else {
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                $response = array(
                    'status' => 400,
                    'message' => 'Invalid request method.',
                    'data' => null,
                );
                getresponse($this, $response);
            } else {
                $data = '';
                $query_data = $this->Contacts_model->getEmail($getemail);
                $get_role = array_column($query_data, 'role');
                $role_string = implode(',', $get_role);
                $brokername = '';
                $case_id = $this->post('case_id');
                $type = $this->post('type');
                $this->db->select('*');
                $this->db->where('id', $case_id);
                $query = $this->db->get(db_prefix() . 'leads');
                if ($query->num_rows() > 0) {
                    $case_result = $query->row();
                    // get the leads/case status
                    $this->db->select('*');
                    $this->db->where('id', $case_result->status);
                    $status_query = $this->db->get(db_prefix() . 'leads_status');
                    $status_result = $status_query->row();
                    $get_staff_group = $case_result->assign_group;
                    // get broker name
                    $this->db->select('staffid,email,firstname,lastname,staff_group,phonenumber,password,datecreated,profile_image,admin,role,active,is_password_changed');
                    $this->db->where('staffid', $case_result->addedfrom);
                    $staff_record = $this->db->get(db_prefix() . 'staff');

                    if ($staff_record->num_rows() > 0) {
                        $staff_data = $staff_record->row();
                        $staff_name = $staff_data->firstname . ' ' . $staff_data->lastname;
                    }
                    // get staff id
                    $this->db->select('*');
                    $this->db->where('group_name', $get_staff_group);
                    $query = $this->db->get(db_prefix() . 'group');
                    if ($query->num_rows() > 0) {
                        $result = $query->row();
                        $group_id = $result->id;
                        $group_name = $result->group_name;
                        $group_details = array(
                            'id' => $group_id,
                            'name' => $group_name,
                            'members' => array()
                        );

                        // get all staff details
                        $this->db->select('staffid,email,firstname,lastname,staff_group,phonenumber,password,datecreated,profile_image,admin,role,active,is_password_changed');
                        $this->db->where('staff_group', $group_name);
                        $staff_query = $this->db->get(db_prefix() . 'staff');
                        if ($staff_query->num_rows() > 0) {
                            $staff_data_Array = array();
                            foreach ($staff_query->result() as $staff_data_fetch) {
                                $staff_data_Array[] = array(
                                    'id' => $staff_data_fetch->staffid,
                                    'name' => $staff_data_fetch->firstname . ' ' . $staff_data_fetch->lastname,
                                    'profile_url' => isset ($staff_data_fetch->profile_image) ? base_url('uploads/staff_profile_images/' . $staff_data_fetch->staffid . '/thumb_' . $staff_data_fetch->profile_image) : null,
                                );
                            }
                            $group_details['members'] = $staff_data_Array;
                        }
                    }
                    // Get total tasks count
                    $this->db->select('COUNT(id) as total_tasks');
                    $this->db->where('rel_id', $case_result->id);
                    $this->db->where('rel_type', 'user-task');
                    $this->db->where('type', 'client');
                    $total_tasks_query = $this->db->get(db_prefix() . 'tasks');
                    $total_tasks_result = $total_tasks_query->row();
                    $total_tasks_count = $total_tasks_result->total_tasks;

                    // Get completed tasks count
                    $this->db->select('COUNT(id) as completed_tasks');
                    $this->db->where('rel_id', $case_result->id);
                    $this->db->where('rel_type', 'user-task');
                    $this->db->where('status', '4');
                    $this->db->where('type', 'client');
                    $completed_tasks_query = $this->db->get(db_prefix() . 'tasks');
                    $completed_tasks_result = $completed_tasks_query->row();
                    $completed_tasks_count = $completed_tasks_result->completed_tasks;
                    // get the transaction details
                    $leads_transacation_data = leads_bank_details($this, $case_result->id);
                    $transaction_name = '';
                    if(!empty($leads_transacation_data)){
                        $transaction_name = get_transaction_name_by_id($this,$leads_transacation_data[0]['transaction_id']);
                    }
                    $funds_requested_mail = false;
                    if(!empty($case_result->funds_requested_mail) && $case_result->funds_requested_mail == 1){
                        $funds_requested_mail = true;
                    }
                    // split the names and its show it according to the format of crm
                    $split_name = leads_splitFullName($case_result->name);
                    $CaseName = $split_name['lastname']. ', ' . $split_name['firstname'] . ' ' . $split_name['middlename'];
                    $data = [
                        'case_id' => $case_result->id,
                        'name' => $CaseName,
                        'address' => $case_result->address,
                        'started_at' => strtotime($case_result->dateadded),
                        'status' => $status_result->name,
                        'case_active' => $case_result->active_case,
                        'martial_status' => $case_result->martial_status,
                        // 'transaction' => $case_result->transaction,
                        'transaction' => $transaction_name,
                        'broker_name' => $staff_name,
                        'total_task' => $total_tasks_count,
                        'completed_task' => $completed_tasks_count,
                        'funds_requested_mail' => $funds_requested_mail,
                        'group' => $group_details,
                        'file_opened' => [
                            'started_at' => $case_result->file_opened_started_at ? strtotime($case_result->file_opened_started_at) : null,
                            'completed_at' => $case_result->file_opened_completed_at ? strtotime($case_result->file_opened_completed_at) : null,
                            'completed' => $case_result->file_opened_completed,
                            'checklist_items' => []
                        ],
                        'idv' => [
                            'started_at' => $case_result->id_verification_started_at ? strtotime($case_result->id_verification_started_at) : null,
                            'completed_at' => $case_result->id_verification_completed_at ? strtotime($case_result->id_verification_completed_at) : null,
                            'completed' => $case_result->id_verification_completed,
                            'checklist_items' => []
                        ],
                        'instruction_received' => [
                            'started_at' => $case_result->ins_received_started_at ? strtotime($case_result->ins_received_started_at) : null,
                            'completed_at' => $case_result->ins_received_completed_at ? strtotime($case_result->ins_received_completed_at) : null,
                            'completed' => $case_result->ins_received_completed,
                            'checklist_items' => []
                        ],
                        'appointment_requested' => [
                            'started_at' => $case_result->app_request_started_at ? strtotime($case_result->app_request_started_at) : null,
                            'completed_at' => $case_result->app_request_completed_at ? strtotime($case_result->app_request_completed_at) : null,
                            'completed' => $case_result->app_request_completed,
                            'checklist_items' => []
                        ],
                        'outstanding_items' => [
                            'started_at' => $case_result->outstanding_item_started_at ? strtotime($case_result->outstanding_item_started_at) : null,
                            'completed_at' => $case_result->outstanding_item_completed_at ? strtotime($case_result->outstanding_item_completed_at) : null,
                            'completed' => $case_result->out_items_completed,
                            'checklist_items' => []
                        ],
                        'ledger' => [
                            'started_at' => $case_result->ledger_started_at ? strtotime($case_result->ledger_started_at) : null,
                            'completed_at' => $case_result->ledger_completed_at ? strtotime($case_result->ledger_completed_at) : null,
                            'completed' => $case_result->ledger_completed,
                            'checklist_items' => []
                        ],
                        'request_for_funds' => [
                            'started_at' => $case_result->req_for_funds_started_at ? strtotime($case_result->req_for_funds_started_at) : null,
                            'completed_at' => $case_result->req_for_funds_completed_at ? strtotime($case_result->req_for_funds_completed_at) : null,
                            'completed' => $case_result->req_for_funds_completed,
                            'checklist_items' => []
                        ],
                        'closed' => [
                            'started_at' => null,
                            'completed_at' => $case_result->closed_completed_at ? strtotime($case_result->closed_completed_at) : null,
                            'completed' => null,
                            'checklist_items' => []
                        ]

                    ];
                    // File opened checklist get
                    $this->db->select('id, name, description, dateadded, status, rel_id,lead_borrow_id, type');
                    $this->db->from(db_prefix() . 'tasks');
                    $this->db->where('rel_id', $case_result->id);
                    $this->db->where('rel_type', 'user-task');
                    if(!empty($type)){
                        $this->db->where('type', $type);
                    }
                    $this->db->where('leads_status', 1);
                    $query = $this->db->get();

                    $user_task_records = $query->result();
                    foreach ($user_task_records as $record_task) {
                        $status =  return_item_status_for_app_side($record_task->status);
                        $checklist_instruction = $this->file_instruction_model->get_instruction_by_taskid($record_task->id);
                        // $file_type_check = is_array($checklist_instruction) && array_key_exists('doc_type', $checklist_instruction) ? explode(',', $checklist_instruction['doc_type']) : [];
                        // if ($file_type_check === 'jpeg' || $file_type_check === 'jpg' || $file_type_check === 'png' || $file_type_check === 'avif') {
                        //     $file_type = 'image';
                        // } else if ($file_type_check == 'pdf') {
                        //     $file_type = 'pdf';
                        // } else {
                        //     $file_type = 'other';
                        // }
                        if($record_task->type == 'client' || $record_task->type == 'Client'){
                            $client_checklist_name = get_checklist_client_name($this, $record_task->rel_id, $record_task->lead_borrow_id);
                        }else{
                            $client_checklist_name = 'Broker';
                        }
                        // check doc is upload or not 
                        $countFiles = total_count_of_files_using_task_id($this, $record_task->id);

                        $data['file_opened']['checklist_items'][] = [
                            'id' => $record_task->id,
                            'title' => $record_task->name,
                            'client_checklist_name' => $client_checklist_name,
                            'description' => $record_task->description,
                            'status' => $status,
                            'instructions' => is_array($checklist_instruction) && array_key_exists('instruction', $checklist_instruction) ? explode(',', $checklist_instruction['instruction']) : [],
                            'doc_types' => is_array($checklist_instruction) && array_key_exists('doc_type', $checklist_instruction) ? explode(',', $checklist_instruction['doc_type']) : [],
                            'type' => $record_task->type,
                            'checklist_user_id' => $record_task->lead_borrow_id,
                            'uploadDoc' => (!empty($countFiles) && $countFiles > 0) ? true : false
                        ];
                    }

                    // Outstanding item add in response api
                    
                    $client_outstanding_checklist = [];
                    $additional_checklist = [];
                    
                    if (empty($type) || $type == 'client') {
                        $this->db->select('id, name, description, dateadded, status, rel_id, lead_borrow_id, type');
                        $this->db->from(db_prefix() . 'tasks');
                        $this->db->where('rel_id', $case_result->id);
                        $this->db->where('rel_type', 'user-task');
                        $this->db->where('type', 'client');
                        $this->db->where('leads_status', 3);
                        $query = $this->db->get();
                    
                        $user_task_records_outstanding = $query->result();
                        foreach ($user_task_records_outstanding as $record_task) {
                            $status =  return_item_status_for_app_side($record_task->status);
                    
                            $checklist_instruction = $this->file_instruction_model->get_instruction_by_taskid($record_task->id);
                    
                            if ($record_task->type == 'client' || $record_task->type == 'Client') {
                                $client_checklist_name = get_checklist_client_name($this, $record_task->rel_id, $record_task->lead_borrow_id);
                            } else {
                                $client_checklist_name = 'Broker';
                            }
                            // check doc is upload or not 
                            $countFiles = total_count_of_files_using_task_id($this, $record_task->id);

                            $client_outstanding_checklist[] = [
                                'id' => $record_task->id,
                                'title' => $record_task->name,
                                'client_checklist_name' => $client_checklist_name,
                                'description' => $record_task->description,
                                'status' => $status,
                                'instructions' => is_array($checklist_instruction) && array_key_exists('instruction', $checklist_instruction) ? explode(',', $checklist_instruction['instruction']) : [],
                                'doc_types' => is_array($checklist_instruction) && array_key_exists('doc_type', $checklist_instruction) ? explode(',', $checklist_instruction['doc_type']) : [],
                                'type' => $record_task->type,
                                'uploadDoc' => (!empty($countFiles) && $countFiles > 0) ? true : false
                            ];
                        }
                    }
                    
                    // if (empty($type) || $type == 'ld_team') {
                    //     $additional_checklist = get_ld_checklist_by_lead_id($this, $case_result->id, $case_result->status);
                    //     $request_for_funds_checklist = get_request_for_funds_checklist_by_lead_id($this, $case_result->id, $case_result->status);
                    //     $request_for_funds_closing_checklist = get_request_for_funds_checklist_by_lead_id($this, $case_result->id, 5);
                    // }
                    
                    // if (empty($type)) {
                    //     $data['outstanding_items']['checklist_items'] = array_merge($client_outstanding_checklist, $additional_checklist);
                    //     $data['request_for_funds']['checklist_items'] = $request_for_funds_checklist;
                    //     $data['closed']['checklist_items'] = $request_for_funds_closing_checklist;
                    // } elseif ($type == 'client') {
                    //     $data['outstanding_items']['checklist_items'] = $client_outstanding_checklist;
                    // } elseif ($type == 'ld_team') {
                    //     $data['outstanding_items']['checklist_items'] = $additional_checklist;
                    //     $data['request_for_funds']['checklist_items'] = $request_for_funds_checklist;
                    //     $data['closed']['checklist_items'] = $request_for_funds_closing_checklist;
                    // }     
                    // Initialize arrays to avoid undefined variable warnings
                    $client_outstanding_checklist = $client_outstanding_checklist ?? [];
                    $additional_checklist = [];
                    $request_for_funds_checklist = [];
                    $request_for_funds_closing_checklist = [];

                    // Only load LD team-related checklists if type is empty or 'ld_team'
                    if (empty($type) || $type === 'ld_team') {
                        $additional_checklist = get_ld_checklist_by_lead_id($this, $case_result->id, $case_result->status);
                        $request_for_funds_checklist = get_request_for_funds_checklist_by_lead_id($this, $case_result->id, $case_result->status);
                        $request_for_funds_closing_checklist = get_request_for_funds_checklist_by_lead_id($this, $case_result->id, 5);
                    }

                    // Now decide how to populate the output based on type
                    switch ($type) {
                        case 'client':
                            $data['outstanding_items']['checklist_items'] = $client_outstanding_checklist;
                            break;

                        case 'ld_team':
                            $data['outstanding_items']['checklist_items'] = $additional_checklist;
                            $data['request_for_funds']['checklist_items'] = $request_for_funds_checklist;
                            $data['closed']['checklist_items'] = $request_for_funds_closing_checklist;
                            break;

                        case null:
                        case '':
                            // Treat empty $type same as default (both checklists)
                            $data['outstanding_items']['checklist_items'] = array_merge($client_outstanding_checklist, $additional_checklist);
                            $data['request_for_funds']['checklist_items'] = $request_for_funds_checklist;
                            $data['closed']['checklist_items'] = $request_for_funds_closing_checklist;
                            break;
                    }
               
                    $response = array(
                        'status' => 200,
                        'message' => 'Record not found.',
                        'data' => $data,
                    );
                    getresponse($this, $response);
                }else{
                    $response = array(
                        'status' => 200,
                        'message' => 'Record not found.',
                        'data' => null,
                    );
                    getresponse($this, $response);
                }
            }
        }
    }

    public function filterdata_post()
    {
        // 1  ='recent' 2 =  'a_to_z' 3 = 'z_to_a' 4 = 'date_asc' 5 = 'date_desc'
        $sort_by = array(
            array(
                'id' => '1',
                'title' => 'Most Recent',
            ),
            array(
                'id' => '2',
                'title' => 'A to Z',
            ),
            array(
                'id' => '3',
                'title' => 'Z to A',
            ),
            array(
                'id' => '4',
                'title' => 'Date:Ascending',
            ),
            array(
                'id' => '5',
                'title' => 'Date:Descending',
            )
        );

        // get the broker data
        $broker = array();
        // get the role id
        $this->db->select('staffid,email,firstname,lastname,staff_group,phonenumber,password,datecreated,profile_image,admin,role,active,is_password_changed');
        $query = $this->db->get(db_prefix() . 'staff');
        $staff_data = array();

        if ($query->num_rows() > 0) {
            $record = $query->result_array();
            foreach ($record as $value) {
                $get_role = get_staff_role($this, $value['role']);
                if ($get_role == 'Broker') {
                    $staff_data[] =
                        array(
                            'id' => $value['staffid'],
                            'title' => $value['firstname'] . ' ' . $value['lastname'],
                        );
                }
            }
        }

        // get the group data 
        $this->db->select('id,group_name');
        $query = $this->db->get(db_prefix() . 'group');
        $staff_group = array();

        if ($query->num_rows() > 0) {
            $group_data = $query->result_array();
            foreach ($group_data as $value) {
                $staff_group[] = array(
                    'id' => $value['id'],
                    'title' => $value['group_name'],
                );
            }
        }

        $group = $staff_group;

        // merge all the arrays properly
        $response = array(
            'status' => 200,
            'message' => 'All filter data',
            'data' => array(
                'sort_by' => $sort_by,
                'broker' => $staff_data,
                'team' => $group
            )
        );
        getresponse($this, $response);
    }
    // Get unread comment api
    public function unreadcomment_post()
    {
        $getemail = $this->authmiddleware->verifyToken();
        if (empty($getemail)) {
        } else {
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                $response = array(
                    'status' => 400,
                    'message' => 'Invalid request method.',
                    'data' => null,
                );
                getresponse($this, $response);
            } else {
                $user_id = $this->post('user_id');
                $lead_id = $this->post('case_id');
                $data = $this->Contacts_model->getEmail($getemail);
                $get_role = array_column($data, 'role');
                $role_string = implode(',', $get_role);
                if (!empty($user_id) && !empty($lead_id)) {
                    if ($role_string != 'client') {
                                $this->db->from(db_prefix() . 'read_comments');
                                // $this->db->where_in('comment_id', $comment_ids);
                                $this->db->where('lead_id', $lead_id);
                                $this->db->where('to_user_id', $user_id);
                                $this->db->where('is_read', '0');

                                // Use count_all_results() to directly get the count of matching rows
                                $total_rows = $this->db->count_all_results();
                            // }
                            $response = [
                                'status' => 200,
                                'message' => 'Comment Count',
                                'data' => [
                                    'count' => $total_rows
                                ],
                            ];
                            getresponse($this, $response);
                        } else {
                            $response = [
                                'status' => 200,
                                'message' => 'No comments found',
                                'data' => null,
                            ];
                            getresponse($this, $response);
                        }
                    // }
                } else {
                    $response = [
                        'status' => 400,
                        'message' => 'Incorrect credentials',
                        'data' => null,
                    ];
                    getresponse($this, $response);
                }
            }
        }
    }
    //  get the read comment
    public function readcomment_post()
    {
        $getemail = $this->authmiddleware->verifyToken();
        if (empty($getemail)) {
        } else {
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                $response = array(
                    'status' => 400,
                    'message' => 'Invalid request method.',
                    'data' => null,
                );
                getresponse($this, $response);
            } else {
                $user_id = $this->post('user_id');
                $lead_id = $this->post('case_id');
                $update_data = array(
                    'is_read' => '1'
                );
                $data = $this->Contacts_model->getEmail($getemail);
                $get_role = array_column($data, 'role');
                $role_string = implode(',', $get_role);
                if (!empty($user_id) && !empty($lead_id)) {
                    if ($role_string != 'client') {
                        $this->db->select('comment_id');
                        $this->db->where('to_user_id', $user_id);
                        $this->db->where('lead_id', $lead_id);
                        $this->db->where('role', 'client');
                        $query = $this->db->get(db_prefix() . 'comments');
                        $comment_id_array = array();
                        if ($query->num_rows() > 0) {
                            $comment_id_array = $query->result_array();
                            $comment_ids = array_column($comment_id_array, 'comment_id');
                            $comment_ids = array_map('intval', $comment_ids);
                        }
                         // updated the counts
                         $update_record = array(
                            'is_read' => 1
                        );
                        $this->db->where('to_user_id', $user_id);
                        $this->db->where('lead_id', $lead_id);
                        $this->db->update(db_prefix() . 'read_comments', $update_record);
                        // Count the read comments
                        $this->db->select('COUNT(*) as count');
                        $this->db->from(db_prefix() . 'read_comments');
                        $this->db->where_in('comment_id', $comment_ids);
                        $this->db->where('to_user_id', $user_id);
                        $this->db->where('lead_id', $lead_id);
                        $this->db->where('is_read', '0');
                        $query_count = $this->db->get();
                        if ($query_count) {
                            $total_rows = $query_count->row_array();
                            $response = [
                                'status' => 200,
                                'message' => 'Comment Count',
                                'data' => $total_rows,
                            ];
                            getresponse($this, $response);
                        } else {
                            $response = [
                                'status' => 200,
                                'message' => 'Comment count not found.',
                                'data' => null
                            ];
                            getresponse($this, $response);
                        }
                    }
                } else {
                    $response = [
                        'status' => 400,
                        'message' => 'Incorrect credentials',
                        'data' => null,
                    ];
                    getresponse($this, $response);
                }
            }
        }
    }
    // count of all cases with different stages
    public function casescount_post()
    {
        $this->db->select('
        COUNT(CASE WHEN status = 1 THEN 1 ELSE NULL END) as count_status_1,
        COUNT(CASE WHEN status = 2 THEN 1 ELSE NULL END) as count_status_2,
        COUNT(CASE WHEN status = 3 THEN 1 ELSE NULL END) as count_status_3,
        COUNT(CASE WHEN status = 4 THEN 1 ELSE NULL END) as count_status_4,
        COUNT(CASE WHEN status = 5 THEN 1 ELSE NULL END) as count_status_5,
        COUNT(CASE WHEN status = 6 THEN 1 ELSE NULL END) as count_status_6, 
        COUNT(CASE WHEN status = 7 THEN 1 ELSE NULL END) as count_status_7, 
        COUNT(CASE WHEN status = 8 THEN 1 ELSE NULL END) as count_status_8, 
        COUNT(CASE WHEN status = 9 THEN 1 ELSE NULL END) as count_status_9, 
        COUNT(id) as total_leads
    ');
        $this->db->from(db_prefix() . 'leads');
        $result = $this->db->get()->row();

        $countStatus1 = $result->count_status_1;
        $countStatus2 = $result->count_status_2;
        $countStatus3 = $result->count_status_3;
        $countStatus4 = $result->count_status_4;
        $countStatus5 = $result->count_status_5;
        $countStatus6 = $result->count_status_6;
        $countStatus7 = $result->count_status_7;
        $countStatus8 = $result->count_status_8;
        $countStatus9 = $result->count_status_9;
        $totalLeads = $result->total_leads;
        $response = [
            'status' => 200,
            'message' => 'Cases Count',
            'data' => [
                'total' => $totalLeads,
                'file_opened' => $countStatus1,
                'instructions_received' => $countStatus2,
                'outstanding_items' => $countStatus3,
                'request_for_funds' => $countStatus4,
                'closed' => $countStatus5,
                'on_hold' => $countStatus6,
                'appointment_request' => $countStatus7,
                'id_verification' => $countStatus8,
                'archive' => $countStatus9,
            ],
        ];
        getresponse($this, $response);
    }
}