// // ✅ Safe global variables
// if (typeof statusPages === 'undefined') {
//     var statusPages = {};
// }

// if (typeof lastUpdate === 'undefined') {
//     var lastUpdate = null;
// }

// // ✅ Track "Load More" clicks to preserve page counts per status
// $(document).on('click', '.kanban-load-more', function () {
//     var statusId = $(this).data('status-id');

//     if (!statusPages[statusId]) {
//         statusPages[statusId] = 2; // Page 1 already loaded, +1 load more
//     } else {
//         statusPages[statusId]++;
//     }
// });

// if (localStorage.getItem('kanban_filter_open') === 'false') {
//     // ✅ Auto-refresh every 30 seconds
//     setInterval(function () {
//         $.ajax({
//             url: admin_url + "leads/check_kanban_leads_update",
//             type: "GET",
//             dataType: "json",
//             success: function (response) {
//                 if (response.last_update !== lastUpdate) {
//                     lastUpdate = response.last_update;

//                     // Reload first-page Kanban for all statuses
//                     leads_kanban();

//                     // After short delay, re-trigger load more pages
//                     setTimeout(function () {
//                         for (let statusId in statusPages) {
//                             let totalPages = statusPages[statusId];
//                             let $btn = $('.kanban-load-more[data-status-id="' + statusId + '"]');

//                             // Re-trigger "Load More" (pages 2 to N)
//                             for (let i = 1; i < totalPages; i++) {
//                                 if (!$btn.hasClass('disabled')) {
//                                     $btn.trigger('click');
//                                 }
//                             }
//                         }
//                     }, 1000); // 1s delay after base Kanban reload

//                     // Optional: update notifications
//                     if (typeof get_kanban_notification === 'function') {
//                         get_kanban_notification();
//                     }
//                 }
//             }
//         });
//     }, 30000); // Refresh every 30s
// }

// // ✅ Optional: Reset page counts if user reloads page manually
// $(window).on('beforeunload', function () {
//     statusPages = {};
// });


// ✅ Safe global variables
if (typeof statusPages === 'undefined') var statusPages = {};
if (typeof lastUpdate === 'undefined') var lastUpdate = null;
if (typeof columnScrollPositions === 'undefined') var columnScrollPositions = {};

// ✅ Store scrollTop for each kanban column
function storeColumnScrollPositions() {
    columnScrollPositions = {};
    $('.kan-ban-col').each(function () {
        const statusId = $(this).data('col-status-id');
        const scrollTop = $(this).find('.kan-ban-content-wrapper').scrollTop();
        columnScrollPositions[statusId] = scrollTop;
    });
}

// ✅ Restore scrollTop for each kanban column
function restoreColumnScrollPositions() {
    $.each(columnScrollPositions, function (statusId, scrollTop) {
        $('.kan-ban-col[data-col-status-id="' + statusId + '"]')
            .find('.kan-ban-content-wrapper')
            .scrollTop(scrollTop || 0);
    });
}

// ✅ Track "Load More" clicks and store scroll
$(document).on('click', '.kanban-load-more', function () {
    const $this = $(this);
    const statusId = $this.data('status-id');

    // ✅ Store scroll before loading more
    storeColumnScrollPositions();

    if (!statusPages[statusId]) {
        statusPages[statusId] = 2; // Initial + load more
    } else {
        statusPages[statusId]++;
    }

    // ✅ Restore scroll after delay
    setTimeout(function () {
        restoreColumnScrollPositions();
    }, 800); // small delay to wait for new cards
});

// ✅ Auto-refresh every 30 seconds
if (localStorage.getItem('kanban_filter_open') === 'false') {
    setInterval(function () {
        // ✅ Store current scrolls
        storeColumnScrollPositions();

        $.ajax({
            url: admin_url + "leads/check_kanban_leads_update",
            type: "GET",
            dataType: "json",
            success: function (response) {
                if (response.last_update !== lastUpdate) {
                    lastUpdate = response.last_update;

                    // ✅ Reload Kanban base
                    leads_kanban();

                    // ✅ Restore scrolls & load more pages
                    setTimeout(function () {
                        restoreColumnScrollPositions();

                        for (let statusId in statusPages) {
                            const totalPages = statusPages[statusId];
                            const $btn = $('.kanban-load-more[data-status-id="' + statusId + '"]');

                            for (let i = 1; i < totalPages; i++) {
                                if (!$btn.hasClass('disabled')) {
                                    $btn.trigger('click');
                                }
                            }
                        }

                        if (typeof get_kanban_notification === 'function') {
                            get_kanban_notification();
                        }
                    }, 1000); // Wait for Kanban DOM update
                }
            }
        });
    }, 30000);
}

// ✅ Reset on manual page reload
$(window).on('beforeunload', function () {
    statusPages = {};
    columnScrollPositions = {};
});
