<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
            aria-hidden="true">&times;</span></button>
    <h4 class="modal-title" style="display: flex;align-item:center;">
        <?php
        $current_staff_role = get_current_staff_role($this, get_staff_user_id());
        ?>
        <?php if (isset($lead)) {
            if (!empty($lead->name)) {
                $name = $lead->name;
                $secondary_name = $lead->secondary_name;
                // break the string of primary name
                $primary_name = explode(' ', $name, 3);
                $firstname = '';
                $middlename = '';
                $lastname = '';

                if (isset($primary_name[0])) {
                    $firstname = $primary_name[0];
                }
                if (isset($primary_name[1])) {
                    $middlename = $primary_name[1];
                }
                if (isset($primary_name[2])) {
                    $lastname = $primary_name[2];
                }

                // break the string of secondary name
                $secondary_name = explode(' ', $secondary_name, 3);
                $secondary_firstname = '';
                $secondary_middlename = '';
                $secondary_lastname = '';

                if (isset($secondary_name[0])) {
                    $secondary_firstname = $secondary_name[0];
                }
                if (isset($secondary_name[1])) {
                    $secondary_middlename = $secondary_name[1];
                }
                if (isset($secondary_name[2])) {
                    $secondary_lastname = $secondary_name[2];
                }
            } elseif (!empty($lead->company)) {
                $name = $lead->company;
            } else {
                $name = _l('lead');
            }
            $transaction_data = get_lead_transaction_details($lead->id);
           
            if (!empty($transaction_data)) {
                $transaction_names = array_filter(array_column($transaction_data, 'transaction_name')); // remove empty values
                if (!empty($transaction_names)) {
                    $transaction_names = implode(', ', $transaction_names);
                } else {
                    $transaction_names = ''; // set empty if nothing valid
                }
            }            
            switch ($lead->assign_group) {
                case 'Ninja':
                    $assignGroup_color = 'background-color:#9DD9EE;padding: 5px;color: black;width: 120px;font-weight: 500;border-radius: 6px;display:flex;justify-content:center;align-items:center;';
                    break;
            
                case 'Power':
                    $assignGroup_color = 'background-color:#B8ACF6;padding: 5px;color: black;width: 120px;font-weight: 500;border-radius: 6px;display:flex;justify-content:center;align-items:center;';
                    break;
            
                case 'Rocket':
                    $assignGroup_color = 'background-color:#57BC92;padding: 5px;color: black;width: 120px;font-weight: 500;border-radius: 6px;display:flex;justify-content:center;align-items:center;';
                    break;
            
                default:
                    $assignGroup_color = ''; 
                    break;
            }
            $all_staff_name_by_group = '';
            if(!empty($get_staff_name_by_group)){
                $all_staff_name_by_group = implode(', ', $get_staff_name_by_group);
            }   
            $ld_notes_head = '';
            if($current_staff_role != 2 && $current_staff_role != 6){
                // && date('Y-m-d', strtotime($latest_notes->dateadded)) === date('Y-m-d')
              $ld_notes_tag =  (!empty($latest_notes)?  ' | <a href="#" id="top_file_note_show_tab"> <p class="tw-text-sm tw-mb-0" style="margin-left: 15px;margin-right: 15px;display: flex;align-items: center;background-color: #99d183;padding: 2px 10px;border-radius: 5px;color: black;"><span style="font-weight:800;">Notes:</span> ' . $latest_notes->description . '</p></a>' : '');    
            }
            echo '#' . $lead->id . ' - ' . $lastname . ', ' . $firstname . ' ' . $middlename 
            . ' | <p class="tw-text-sm tw-mb-0" style="margin-left: 15px; margin-right: 15px;' . $assignGroup_color . '" data-toggle="tooltip" data-title="' . $all_staff_name_by_group . '">' . $lead->assign_group . '</p>' 
            . ' | <p style="background-color:' . $selected_brokerage_color . ';margin-left: 15px; margin-right: 15px;margin-bottom:0px;color: black;padding: 5px;width: 120px;border-radius: 6px;display:flex;justify-content:center;align-items:center;font-size:small;"  data-toggle="tooltip" data-title="' . $broker_name_profile_show .'">' . $selected_brokerage_name . '</p> | ' 
            . $transaction_names
            . $ld_notes_tag;
        } else {
            echo "Add new case";
        }

        if (isset($lead)) {
            echo '<div class="tw-ml-4 -tw-mt-2 tw-inline-block">';
            if ($lead->lost == 1) {
                echo '<span class="label label-danger">' . _l('lead_lost') . '</span>';
            } elseif ($lead->junk == 1) {
                echo '<span class="label label-warning">' . _l('lead_junk') . '</span>';
            } else {
                if (
                    total_rows(db_prefix() . 'clients', [
                        'leadid' => $lead->id,
                    ])
                ) {
                    echo '<span class="label label-success">' . _l('lead_is_client') . '</span>';
                }
            }
            echo '</div>';
        }
        ?>
    </h4>
    <?php if ($samegroup != 2 && $samegroup != 6 && !empty($lead->id)) { ?>
        <!-- <button class="btn btn-primary" id="move_to_archive" style="margin-top:30px;">Move to Archive</button> -->
    <?php }?>
</div>
<div class="modal-body">
    <div class="row">
        <div class="col-md-12">
            <?php if (isset($lead)) {
                echo form_hidden('leadid', $lead->id);
            } ?>
            <div class="top-lead-menu">
                <?php if (isset($lead)) { ?>
                    <div class="horizontal-scrollable-tabs preview-tabs-top panel-full-width-tabs mbot20">
                        <div class="scroller arrow-left"><i class="fa fa-angle-left"></i></div>
                        <div class="scroller arrow-right"><i class="fa fa-angle-right"></i></div>
                        <div class="horizontal-tabs">
                        <?php if($current_staff_role == 2 || $current_staff_role == 6){?>
                                <ul class="nav-tabs-horizontal nav nav-tabs  <?php echo !isset($lead) ? 'lead-new' : ''; ?> nav-tabs-custom" role="tablist">
                        <?php }else{?>
                                <ul class="nav-tabs-horizontal nav nav-tabs  <?php echo !isset($lead) ? 'lead-new' : ''; ?>" role="tablist">
                        <?php } ?>
                                <li role="presentation" id="" class="tab_active_remove active">
                                    <a href="#tab_lead_profile" aria-controls="tab_lead_profile" role="tab"
                                        data-toggle="tab"
                                        class="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'btn btn-primary broker_li_tabs' : ''; ?>"
                                        style="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'border:2px solid;border-radius:8%;' : ''; ?>">
                                        <?php echo 'Client Profile'; ?>
                                    </a>
                                </li>
                                <?php if ($current_staff_role == 2 || $current_staff_role == 6) { ?>
                                    <li role="presentation" class="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'broker_li_tabs' : ''; ?>">
                                        <a href="#file_opened" aria-controls="file_opened" role="tab" data-toggle="tab"
                                            class="btn btn-primary"
                                            style="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'border:2px solid;border-radius:8%;font-size: xx-small;padding: 18px;' : ''; ?>">
                                            File Opening Documents & ID
                                        </a>
                                    </li>
                                    <li role="presentation" class="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'broker_li_tabs' : ''; ?>">
                                        <a href="#co_borrow" aria-controls="co_borrow" role="tab" data-toggle="tab"
                                            class="btn btn-primary"
                                            style="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'border:2px solid;border-radius:8%;' : ''; ?>">
                                            <?php echo 'Client contact details'; ?>
                                        </a>
                                    </li>
                                    <li role="presentation" class="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'broker_li_tabs' : ''; ?>">
                                        <a href="#summary" aria-controls="summary" role="tab" data-toggle="tab"
                                            class="btn btn-primary"
                                            style="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'border:2px solid;border-radius:8%;' : ''; ?>">
                                            Uploads
                                        </a>
                                    </li>
                                    <?php if ($samegroup || $samegroup === 2) { ?>
                                        <li role="presentation" class="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'broker_li_tabs' : ''; ?>" style="">
                                            <a href="#ld_comments" aria-controls="ld_comments" role="tab" data-toggle="tab"
                                                class="btn btn-primary"
                                                style="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'border:2px solid;border-radius:8%;' : ''; ?>">
                                                LD Chat
                                            </a>
                                        </li>
                                    <?php } ?>

                                    <!-- Unified comments -->
                                    <?php if ($samegroup || $samegroup === 2) {  ?>
                                        <li role="presentation" id="" class="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'broker_li_tabs' : ''; ?>" style="display: none">
                                            <a href="#unified-comments" aria-controls="comment" role="tab" data-toggle="tab" class="btn btn-primary"
                                                style="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'border:2px solid;border-radius:8%;' : ''; ?>">
                                                <?php echo 'LD Chat'; ?>
                                            </a>
                                        </li>
                                    <?php } ?>

                                    <li role="presentation" class="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'broker_li_tabs' : ''; ?>">
                                        <a href="#case_notification" aria-controls="case_notification" role="tab"
                                            data-toggle="tab" class="btn btn-primary"
                                            style="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'border:2px solid;border-radius:8%;' : ''; ?>">
                                            <?php echo 'Case Notifications'; ?>
                                        </a>
                                    </li>
                                <?php } else { ?>
                                    <li role="presentation" id="" class="tab_active_remove">
                                        <a href="#co_borrow" aria-controls="co_borrow" role="tab" data-toggle="tab">
                                            <?php echo 'Client-contact details';
                                            ?>
                                        </a>
                                    </li>
                                    <?php if (isset($lead)) { ?>
                                        <?php if (count($mail_activity) > 0 || isset($show_email_activity) && $show_email_activity) { ?>
                                            <li role="presentation" id="" class="tab_active_remove">
                                                <a href="#tab_email_activity" aria-controls="tab_email_activity" role="tab"
                                                    data-toggle="tab">
                                                    <?php echo hooks()->apply_filters('lead_email_activity_subject', _l('lead_email_activity')); ?>
                                                </a>
                                            </li>
                                        <?php } ?>
                                        <li role="presentation" id="" class="tab_active_remove" style="display:none;">
                                            <a href="#attachments" aria-controls="attachments" role="tab" data-toggle="tab">
                                                <?php echo _l('lead_attachments');
                                                if ($total_attachments > 0) {
                                                    echo ' <span class="badge">' . $total_attachments . '</span>';
                                                }
                                                ?>
                                            </a>
                                        </li>
                                        <?php if ($samegroup) { ?>
                                            <li role="presentation" class="tab_active_remove" style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                                                <a href="#lead_notes" id="lead_notes_tab" aria-controls="lead_notes" role="tab" data-toggle="tab">
                                                    <?php echo 'File Notes';
                                                    ?>
                                                </a>
                                            </li>
                                        <?php } ?>

                                        <!-- Unified comments -->
                                        <?php if ($samegroup) { ?>
                                            <li role="presentation" id="" class="tab_active_remove" style="<?php echo ($samegroup === 2) ? 'display:none;' : 'display:none'; ?>">
                                                <a href="#unified-comments" id="lead_notes_tab" aria-controls="lead_notes" role="tab" data-toggle="tab">
                                                    <?php echo 'Comments';                                                          
                                                        $total_comment = $client_comments_count + $broker_comments_count;
                                                        if ($total_comment > 0 || !empty($total_comment)) {
                                                            echo '<span class="badge unified_badge_' . $lead->id . '" style="background-color:#ff0000ba;color:white;" id="client_badge">' 
                                                         . $total_comment . 
                                                         '</span>';
                                                        }
                                                    ?>
                                                </a>
                                            </li>
                                        <?php } ?>

                                        <li role="presentation" id="" class="tab_active_remove" style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                                            <a href="#comments" aria-controls="comments" role="tab" data-toggle="tab" id="client_comment" class="client_comment_<?php echo $lead->id;?>">
                                                <?php echo 'Client Comments'; 
                                                   if ($client_comments_count > 0) {
                                                    echo '<span class="badge client_badge_' . $lead->id . '" style="background-color:#ff0000ba;color:white;" id="client_badge">' 
                                                         . $client_comments_count . 
                                                         '</span>';
                                                }
                                                ?>
                                            </a>
                                        </li>
                                        <!-- <li role="presentation" id="" class="tab_active_remove" style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                                            <a href="#admin_ld_comments" aria-controls="admin_ld_comments" role="tab" data-toggle="tab" id="admin_ld_comments_id" class="admin_ld_comments_<?php echo $lead->id;?>">
                                                <?php /* if(is_admin()) { echo 'LD Comments'; } else { echo 'Admin Comment'; }
                                                   if ($client_comments_count > 0) {
                                                    echo '<span class="badge admin_ld_badge' . $lead->id . '" style="background-color:#ff0000ba;color:white;" id="client_badge">' 
                                                         . $client_comments_count . 
                                                         '</span>';
                                                } */
                                                ?>
                                            </a>
                                        </li> -->
                                        <?php if ($samegroup || $samegroup === 2) { ?>
                                            <li role="presentation" style="<?php echo ($samegroup === 2) ? 'display:none' : ''; ?>" class="tab_active_remove">
                                                <a href="#ld_comments" aria-controls="ld_comments" role="tab" data-toggle="tab" id="broker_comment" class="broker_comment_<?php echo $lead->id;?>">
                                                    <?php echo ($samegroup === 2) ? 'LD-Comments' : 'Broker-Comments';
                                                    if ($broker_comments_count > 0) {
                                                        echo '<span class="badge broker_badge_' . $lead->id . '" style="background-color:#ff0000ba;color:white;" id="broker_badge">' 
                                                             . $broker_comments_count . 
                                                             '</span>';
                                                    }                                                    
                                                    ?>
                                                </a>
                                            </li>
                                        <?php } ?>
                                        <li role="presentation" id="" class="tab_active_remove">
                                            <a href="#summary" aria-controls="summary" role="tab" data-toggle="tab">
                                                <?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'File Status' : 'File Summary'; ?>
                                            </a>
                                        </li>
                                        <li role="presentation" id="" class="tab_active_remove" style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                                            <a href="#lead_activity" aria-controls="lead_activity" role="tab" data-toggle="tab">
                                                <?php echo 'Activity Logs'; ?>
                                            </a>
                                        </li>
                                        <li role="presentation" id="" class="tab_active_remove" style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                                            <a href="#outbox" aria-controls="outbox" role="tab" data-toggle="tab">
                                                <?php echo 'Outbox'; ?>
                                            </a>
                                        </li>
                                    <?php } ?>
                                    <?php if (is_gdpr() && (get_option('gdpr_enable_lead_public_form') == '1' || get_option('gdpr_enable_consent_for_leads') == '1')) { ?>
                                        <li role="presentation" id="" class="tab_active_remove">
                                            <a href="#gdpr" aria-controls="gdpr" role="tab" data-toggle="tab">
                                                <?php echo _l('gdpr_short'); ?>
                                            </a>
                                        </li>
                                    <?php } ?>
                                <?php } ?>
                                <?php hooks()->do_action('after_lead_lead_tabs', $lead ?? null); ?>
                            </ul>
                        </div>
                    </div>
                <?php } ?>
            </div>


            <!---status bar--->
            <?php if (!empty($lead)) { ?>
            <?php if($current_staff_role == 2 || $current_staff_role == 6){?>
                <div class="col" style="font-weight:800;margin-bottom:15px;text-align: center;font-size: larger;">Timeline</div>
            <?php }?>
            <div class="pb-5 mb-sm-4">
                <div class="stepper-wrapper">
                    <?php
                    $add_ledger = array(
                        'id' => 9,
                        'statusorder' => 6,
                        'name' => 'Send Ledger'
                    );
                    array_push($statuses, $add_ledger);
                    foreach ($timeline_status as $index => $status) {
                        // Determine if the step is completed based on your logic
                        $completed = getStatusClass($lead->status, $index + 1, $status['statusorder']);
                        $status_order_primary_id = getStatusOrderPrimaryId($lead->status);
                        if (get_current_staff_role($this, get_staff_user_id()) != 2 || get_current_staff_role($this, get_staff_user_id()) != 6) {
                            $tabInfo = getTabInfo($index + 1);
                        } else {
                            $tabInfo = array('');
                        }
                        ?>
                    <?php if($current_staff_role == 2 || $current_staff_role == 6){?>
                        <div class="stepper-item <?php echo $completed; ?>" data-id="<?php echo $index; ?>">
                            <?php if ($status['statusorder'] == $status_order_primary_id) { ?>
                            <div class="step-counter-broker"
                                style="
                                    <?php  if(!empty($closed_completed_at && ($lead->status == 5 || $lead->status == 9))){
                                        echo 'background-color: #189546;color: white;';
                                    }elseif($instruction_count > 0 && ($status['statusorder'] == 3 && $lead->status == 8)){
                                        echo 'background-color:rgb(199, 236, 34);color: white;';  
                                    }else{
                                        echo 'background-color: #2222ec;color: white;';  
                                    } ?>">
                                <?php echo $status['statusorder']; ?>
                            </div>
                            <?php } else { ?>
                            <div
                                class="step-counter-broker"
                                style="font-size: x-small;margin-top:8px;">
                                <?php echo $status['statusorder']; ?>
                            </div>
                            <?php } ?>
                            <div class="step-name"
                                style="font-size: smaller;text-align:center;">
                                <?php echo ($status['name'] == 'Send Ledger')? 'Ledger Stage' :  $status['name']; ?>
                                <?php
                                if ($total_reminders > 0) {
                                    echo ' <span class="badge">' . $total_reminders . '</span>';
                                }
                                ?>
                            </div>
                        </div>
                    <?php }else{?>
                    <div class="stepper-item <?php echo $completed; ?>" data-id="<?php echo $index; ?>">
                        <a href="<?php echo $tabInfo['tab_ids']; ?>"
                            aria-controls="<?php echo $tabInfo['tab_aria_control']; ?>" role="tab" data-toggle="tab"
                            <?php if ($tabInfo['tab_ids'] == '#lead_reminders') { ?>
                            onclick="initDataTable('.table-reminders-leads', admin_url + 'misc/get_reminders/' +
                            <?php echo $lead->id; ?> + '/' + 'lead', undefined, undefined,undefined,[1, 'asc']);"
                            <?php } ?>
                            style="color: inherit;padding: 0px 15px;margin-left:20px;">

                            <?php if ($status['statusorder'] == $status_order_primary_id) { ?>
                            <div class="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'step-counter-broker' : 'step-counter'; ?>"
                                style="
                                    <?php  if(!empty($closed_completed_at && ($lead->status == 5 || $lead->status == 9))){
                                            echo 'background-color: #189546;color: white;';
                                        }elseif($instruction_count > 0 && ($status['statusorder'] == 3 && $lead->status == 8)){
                                            echo 'background-color:rgb(199, 236, 34);color: white;';  
                                        }else if($ledger_completed == 0 && $lead->status == 4){
                                            if($status['statusorder'] == 6){
                                                echo 'background-color: #2222ec;color: white;';  
                                            }else if($status['statusorder'] >= 7){
                                                echo 'background-color:#de0c0cab;color: white;';
                                            }
                                        }else if($ledger_completed == 1 && $lead->status == 4){
                                            if($status['statusorder'] == 7){
                                                echo 'background-color: #2222ec;color: white;';
                                            }  
                                        }else{
                                            echo 'background-color: #2222ec;color: white;';
                                        }?>">
                                <?php echo $status['statusorder']; ?>
                            </div>
                            <?php } else { ?>
                            <div
                                class="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'step-counter-broker' : 'step-counter'; ?>"
                                style="
                                    <?php if($instruction_count > 0 && ($status['statusorder'] == 3 && ($lead->status == 8 || $lead->status == 1))){
                                            echo 'background-color:rgb(199, 236, 34);color: white;';  
                                        }else if($ledger_completed == 0 && $lead->status == 4){
                                            if($status['statusorder'] == 6){
                                                echo 'background-color: #2222ec;color: white;';  
                                            }else if($status['statusorder'] >= 7){
                                                echo 'background-color:#de0c0cab;color: white;';
                                            }
                                        }else if($ledger_completed == 1 && $lead->status == 4){
                                            if($status['statusorder'] == 7){
                                                echo 'background-color: #2222ec;color: white;';
                                            }  
                                        }?>">
                                <?php echo $status['statusorder'];?>
                            </div>
                            <?php } ?>
                            <div class="step-name" data-toggle="tooltip" data-title="<?php echo $status['name']; ?>"
                                style="<?php echo ($current_staff_role == 2 || $current_staff_role == 6) ? 'font-size: smaller;' : ''; ?>">
                                <?php if ($status['statusorder'] == 2) { ?>
                                <?php echo (strlen('IDV') >= 8 ? substr('IDV', 0, 15) . '..' : 'IDV'); ?>
                                <?php } else { ?>
                                <?php echo (strlen($status['name']) >= 8 ? substr($status['name'], 0, 15) . '..' : $status['name']); ?>
                                <?php } ?>
                                <?php
                                if ($total_reminders > 0) {
                                    echo ' <span class="badge">' . $total_reminders . '</span>';
                                }
                                ?>
                            </div>
                        </a>
                    </div>
                    <?php }?>
                    <?php } ?>
                </div>
            </div>
            <?php } ?>
            <hr>
            <!-- Tab panes -->
            <div class="tab-content">
                <!-- from leads modal -->
                <div role="tabpanel" class="tab-pane active" id="tab_lead_profile">
                    <?php $this->load->view('admin/leads/profile'); ?>
                </div>
                <?php if (isset($lead)) { ?>
                    <?php if (count($mail_activity) > 0 || isset($show_email_activity) && $show_email_activity) { ?>
                        <div role="tabpanel" class="tab-pane" id="tab_email_activity">
                            <?php hooks()->do_action('before_lead_email_activity', ['lead' => $lead, 'email_activity' => $mail_activity]); ?>
                            <?php foreach ($mail_activity as $_mail_activity) { ?>
                                <div class="lead-email-activity">
                                    <div class="media-left">
                                        <i class="fa-regular fa-envelope"></i>
                                    </div>
                                    <div class="media-body">
                                        <h4 class="bold no-margin lead-mail-activity-subject">
                                            <?php echo $_mail_activity['subject']; ?>
                                            <br />
                                            <small class="text-muted display-block mtop5 font-medium-xs">
                                                <?php echo _dt($_mail_activity['dateadded']); ?>
                                            </small>
                                        </h4>
                                        <div class="lead-mail-activity-body">
                                            <hr />
                                            <?php echo $_mail_activity['body']; ?>
                                        </div>
                                        <hr />
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                            <?php } ?>
                            <?php hooks()->do_action('after_lead_email_activity', ['lead_id' => $lead->id, 'emails' => $mail_activity]); ?>
                        </div>
                    <?php } ?>
                    <?php if (is_gdpr() && (get_option('gdpr_enable_lead_public_form') == '1' || get_option('gdpr_enable_consent_for_leads') == '1' || (get_option('gdpr_data_portability_leads') == '1') && is_admin())) { ?>
                        <div role="tabpanel" class="tab-pane" id="gdpr">
                            <?php if (get_option('gdpr_enable_lead_public_form') == '1') { ?>
                                <a href="<?php echo $lead->public_url; ?>" target="_blank" class="mtop5">
                                    <?php echo _l('view_public_form'); ?>
                                </a>
                            <?php } ?>
                            <?php if (get_option('gdpr_data_portability_leads') == '1' && is_admin()) { ?>
                                <?php
                                if (get_option('gdpr_enable_lead_public_form') == '1') {
                                    echo ' | ';
                                }
                                ?>
                                <a href="<?php echo admin_url('leads/export/' . $lead->id); ?>">
                                    <?php echo _l('dt_button_export'); ?>
                                </a>
                            <?php } ?>
                            <?php if (get_option('gdpr_enable_lead_public_form') == '1' || (get_option('gdpr_data_portability_leads') == '1' && is_admin())) { ?>
                                <hr class="-tw-mx-3.5" />
                            <?php } ?>
                            <?php if (get_option('gdpr_enable_consent_for_leads') == '1') { ?>
                                <h4 class="no-mbot">
                                    <?php echo _l('gdpr_consent'); ?>
                                </h4>
                                <?php $this->load->view('admin/gdpr/lead_consent'); ?>
                                <hr />
                            <?php } ?>
                        </div>
                    <?php } ?>
                    <!--  style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>" -->
                    <div role="tabpanel" class="tab-pane" id="summary">
                        <!--start file opened summery -->
                        <div class="col-md-12">
                            <button class="btn btn-secondary" style="float: right;" id="summery_refresh_page"><i
                                    class="fa fa-refresh" aria-hidden="true"></i></button>
                        </div>
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <?php if ($current_staff_role != 2 && $current_staff_role != 6): ?>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">Latest Activity
                                    Time:
                                </p>
                                <div id="last_activity_logs"></div>
                            </div>
                        <?php endif ?>
                        <div class="row"
                            style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                            <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b;width: 218px;">Case
                                Created At:</p>
                            <div class="col-md-12" style="display: flex;align-items: center;padding: 0px 13px;">
                                <span class="alert alert-info" data-toggle="tooltip"
                                    data-title="<?php echo $lead->dateadded; ?>" data-original-title title style="display:flex;width:180px;justify-content: space-around;">
                                    <bold style="font-weight: 800;"> </bold>
                                    <?php echo '<b style="font-weight:800;">Started at: </b>' . get_day($lead->dateadded); ?>
                                </span>
                                <div id="case_completed_time" style="display:flex;margin-left:35px;"></div>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <?php if ($current_staff_role != 2 && $current_staff_role != 6): ?>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">File Opened:</p>
                                <div class="" id="file_opened_started_at_time"></div>
                                <div class="" style="" id="file_opened_summery_time"></div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">ID Verified:
                                </p>
                                <div class="" id="id_verification_started_time"></div>
                                <div class="" style="" id="id_verification_summery_time"></div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">Offer In:
                                </p>
                                <div id="offer_in_date"></div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">Instruction
                                    Received:</p>
                                <div class="" id="ins_received_started_time"></div>
                                <div class="" style="" id="ins_received_completed_summery_time"></div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">Appointment
                                    schedule completed:</p>
                                <div class="" style="display:flex;margin-left:17px;" id="set_appointment_time"></div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">Appointment Stage
                                    Completed:</p>
                                <div class="" id="appointment_req_started_time"></div>
                                <div class="" style="" id="app_request_completed_summery_time"></div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">Outstanding Item:
                                </p>
                                <div class="" id="outstanding_item_started_at"></div>
                                <div class="" style="" id="outstanding_item_completed_summery_time"></div>
                            </div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" style="width:100%;margin-left:2px;" />
                            <table class="table table-leads customizable-table number-index-2 dataTable no-footer">
                                <div class='bulk-action-bar' style='
                                    margin-bottom: 10px;
                                    padding: 10px;
                                    border: 1px solid #ddd;
                                    background: #f9f9f9;
                                    border-radius: 5px;
                                    display: flex;
                                    justify-content: space-between;
                                    align-items: center;
                                '>
                                    <div style="display: flex; align-items: center;">
                                        <input type='checkbox' class='select-all-checkbox' style='margin-right: 10px; transform: scale(1.3);'>
                                        <span style="font-weight: bold;">Select All</span>
                                    </div>
                                    <div style="display: flex; align-items: center; gap: 10px;">
                                        <select class='form-control bulk-status-select' style='width: 200px;'>
                                            <option value=''>Select Status</option>
                                            <option value='1'>Pending Review</option>
                                            <option value='2'>Outstanding</option>
                                            <option value='3'>Rejected</option>
                                            <option value='4'>Approved</option>
                                            <option value='5'>Uploaded</option>
                                        </select>
                                        <button class='btn btn-danger bulk-delete-btn' style=''>
                                            <i class='fa fa-trash'></i>
                                        </button>
                                    </div>
                                </div>
                                <thead>
                                    <th></th>
                                    <th>Type of Security</th>
                                    <th>Notes</th>
                                    <th>Received-Yes/No</th>
                                    <th>Documents</th>
                                    <!-- <th>Lender</th> -->
                                    <th>Expiry Date</th>
                                    <th style="">Action</th>
                                </thead>
                                <tbody id="checkbox_lists_outstanding_ld_team_payouts_file_summery">
                                </tbody>
                            </table>
                            <div class="row" style="border-bottom: 1px solid #0000ff3b;">
                                <div class="col-md-12" style="border-right:5px solid #0000ff3b;">
                                </div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">Ledgers:
                                </p>
                                <div id="ledger_started_time"></div>
                                <div class="" style="" id="ledger_completed_summery_time"></div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">Request for funds:
                                </p>
                                <div class="" style="" id="req_for_funds_completed_summery_time"></div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">Case Closed:
                                </p>
                                <div class="" id="closed_completed_summery_time"></div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">On Hold:
                                </p>
                                <div class="" id="on_hold_completed_summery_time"></div>
                                <div class="" id="on_hold_reason"></div>
                            </div>
                        <?php elseif ($current_staff_role == 2 || $current_staff_role == 6): ?>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">File Opened:</p>
                                <div class="" id="file_opened_started_at_time"></div>
                                <div class="" style="" id="file_opened_summery_time"></div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">ID Verified:
                                </p>
                                <div class="" id="id_verification_started_time"></div>
                                <div class="" style="" id="id_verification_summery_time"></div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">Instruction
                                    Received:</p>
                                <div class="" id="ins_received_started_time"></div>
                                <div class="" style="" id="ins_received_completed_summery_time"></div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">Appointment
                                    schedule completed:</p>
                                <div class="" style="display:flex;margin-left:17px;" id="set_appointment_time"></div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">Appointment Stage
                                    Completed:</p>
                                <div class="" id="appointment_req_started_time"></div>
                                <div class="" style="" id="app_request_completed_summery_time"></div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">Outstanding Item:
                                </p>
                                <div class="" id="outstanding_item_started_at"></div>
                                <div class="" style="" id="outstanding_item_completed_summery_time"></div>
                            </div>
                            <div class="row" style="border-bottom: 1px solid #0000ff3b;">
                                <div class="col-md-12" style="border-right:5px solid #0000ff3b;">
                                    <div class="clearfix"></div>
                                    <div class="alert alert-info" style="margin-top:40px;">
                                        <span class="no-margin font-medium-xs bold"
                                            style="display: flex;justify-content: center;">
                                            CLIENT OUTSTANDING ITEMS
                                        </span>
                                    </div>
                                    <!-- Table show in broker side file status tab -->
                                    <div id="data-container3"></div>
                                </div>
                                <div class="col-md-12">
                                    <div class="clearfix"></div>
                                    <div class="alert alert-info" style="margin-top:40px;">
                                        <span class="no-margin font-medium-xs bold"
                                            style="display: flex;justify-content: center;font-weight:800;">
                                            Secure Payouts Items:
                                        </span>
                                    </div>
                                    <hr class="-tw-mx-4 tw-border-neutral-200" style="width:100%;margin-left:2px;" />
                                    <table class="table table-leads customizable-table number-index-2 dataTable no-footer">
                                        <div class='bulk-action-bar' style='
                                            margin-bottom: 10px;
                                            padding: 10px;
                                            border: 1px solid #ddd;
                                            background: #f9f9f9;
                                            border-radius: 5px;
                                            display: flex;
                                            justify-content: space-between;
                                            align-items: center;
                                        '>
                                            <div style="display: flex; align-items: center;">
                                                <input type='checkbox' class='select-all-checkbox' style='margin-right: 10px; transform: scale(1.3);'>
                                                <span style="font-weight: bold;">Select All</span>
                                            </div>
                                            <div style="display: flex; align-items: center; gap: 10px;">
                                                <select class='form-control bulk-status-select' style='width: 200px;'>
                                                    <option value=''>Select Status</option>
                                                    <option value='1'>Pending Review</option>
                                                    <option value='2'>Outstanding</option>
                                                    <option value='3'>Rejected</option>
                                                    <option value='4'>Approved</option>
                                                    <option value='5'>Uploaded</option>
                                                </select>
                                                <button class='btn btn-danger bulk-delete-btn' style=''>
                                                    <i class='fa fa-trash'></i>
                                                </button>
                                            </div>
                                        </div>
                                        <thead>
                                            <th></th>
                                            <th>Type of Security</th>
                                            <th>Notes</th>
                                            <th>Received-Yes/No</th>
                                            <th>Documents</th>
                                            <!-- <th>Lender</th> -->
                                            <th>Expiry Date</th>
                                            <th style="">Action</th>
                                        </thead>
                                        <tbody id="checkbox_lists_outstanding_ld_team_payouts_file_summery">
                                        </tbody>
                                    </table>
                                </div>
                                <div class="col-md-12" style="border-left:1px solid #0000ff3b;">
                                    <div class="clearfix"></div>
                                    <div class="alert alert-info" style="margin-top:40px;">
                                        <span class="no-margin font-medium-xs bold"
                                            style="display: flex;justify-content: center;font-weight:800;">
                                            LD Outstanding Items:
                                        </span>
                                    </div>
                                    <!-- <div id="outstanding_item_team_checkboxes"></div> -->
                                    <!-- ld outstanding table show in broker side for  -->
                                    <div class="col-md-12">
                                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                                        <table class="table table-leads customizable-table number-index-2 dataTable no-footer">
                                            <div class='bulk-action-bar' style='
                                                margin-bottom: 10px;
                                                padding: 10px;
                                                border: 1px solid #ddd;
                                                background: #f9f9f9;
                                                border-radius: 5px;
                                                display: flex;
                                                justify-content: space-between;
                                                align-items: center;
                                            '>
                                                <div style="display: flex; align-items: center;">
                                                    <input type='checkbox' class='select-all-checkbox' style='margin-right: 10px; transform: scale(1.3);'>
                                                    <span style="font-weight: bold;">Select All</span>
                                                </div>
                                                <div style="display: flex; align-items: center; gap: 10px;">
                                                    <select class='form-control bulk-status-select' style='width: 200px;'>
                                                        <option value=''>Select Status</option>
                                                        <option value='1'>Pending Review</option>
                                                        <option value='2'>Outstanding</option>
                                                        <option value='3'>Rejected</option>
                                                        <option value='4'>Approved</option>
                                                        <option value='5'>Uploaded</option>
                                                    </select>
                                                    <button class='btn btn-danger bulk-delete-btn' style=''>
                                                        <i class='fa fa-trash'></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <thead>
                                                <th></th>
                                                <th>Title</th>
                                                <th>Notes</th>
                                                <th>Received-Yes/No</th>
                                                <!-- <th>Created At</th> -->
                                                <th>Documents</th>
                                                <th style="">Action</th>
                                            </thead>
                                            <tbody id="checkbox_lists_outstanding_ld_team">
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <!-- broker deatils show in outstanding item stage -->
                                <!-- <div class="clearfix"></div>
                                <hr class="-tw-mx-4 tw-border-neutral-200" style="width:100%;margin-left:2px;" />
                                <div class="alert alert-info" style="margin-top:40px;">
                                    <span class="no-margin font-medium-xs bold"
                                        style="display: flex;justify-content: center;font-weight:800;">
                                        Broker Uploaded Documents
                                    </span>
                                </div>
                                <div class="row" style="padding: 10px 34px;">
                                    <div class="col-md-12">
                                        <div id="data-container_broker_outstanding1"></div>
                                    </div>
                                </div> -->
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">Ledger Summary:</p>
                                <div id="ledger_started_at_time"></div>
                                <div id="ledger_completed_summery_time"></div>
                            </div>
                            <div class="row" style="border-bottom: 1px solid #0000ff3b;">
                                <div class="col-md-12">
                                    <table id="ledger_all_files_table" class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th style="text-align: center;">Documents</th>
                                                <th style="text-align: center;">Status</th>
                                                <th style="text-align: center;">Reason</th>
                                                <th style="text-align: center;">Created At</th>
                                                <th style="text-align: center;">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Rows will be appended here by jQuery -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">Request for funds:
                                </p>
                                <!-- <div class="" id="req_for_funds_started_time"></div> -->
                                <!-- <div id="req_for_funds_started_time"></div> -->
                                <div class="" style="" id="req_for_funds_completed_summery_time"></div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">Case Closed:
                                </p>
                                <div class="" id="closed_completed_summery_time"></div>
                            </div>
                            <!-- show the form of case closed doc upload -->
                            <div class="clearfix"></div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <div class="row">
                                <div class="col-md-12" style="margin-bottom:15px;">
                                    <button class="btn btn-primary" id="btn_show_form_case_closed_doc_upload">Post Closing
                                        Uploads</button>
                                </div>
                                <div class="col-md-12" id="show_form_case_closed_doc_upload"
                                    style="display: none;margin-bottom:15px;">
                                    <?php echo form_open('admin/leads/upload_doc_for_case_closed/' . $lead->id, ['class' => 'mtop15 mbot15', 'id' => 'upload_doc_for_case_closed']); ?>
                                    <p id="show_text_to_broker" style="font-weight:800;"></p>
                                    <?php echo render_textarea('case_closed_notes', 'Notes', '', array('placeholder' => 'Please enter the any notes.')); ?>
                                    <div class="form-group">
                                        <label for="case_closed_userfile" id="case_closed_title" class="control-label">Select
                                            Files (PDF, JPEG, JPG, PNG, DOC, DOCX, XLS, XLSX)</label>
                                        <input type="file" class="form-control" name="case_closed_userfile[]"
                                            id="case_closed_userfile" multiple
                                            accept=".pdf, .jpeg, .jpg, .png, .doc, .docx, .xls, .xlsx" style="height:53px;">
                                        <div id="case_closed_error" class="error-message" style="color:red;"></div>
                                    </div>
                                    <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                                    <div style="display: flex;justify-content: end;align-items: center;margin-bottom: 20px;"
                                        class="col-md-12">
                                        <div style="margin-right: 10px;margin-top:-5px;" id="case_closed_doc_loader"></div>
                                        <input type="submit" class="btn btn-primary" id="case_closed_doc_submit_button"
                                            style="float:right;margin-bottom: 10px;">
                                    </div>
                                    <?php echo form_close(); ?>
                                </div>
                                <!-- fetch the all record and check live -->
                                <div class="col-md-12">
                                    <table id="caseClosedDataTable" class="table table-striped table-bordered"
                                        style="width:100%;">
                                        <thead>
                                            <tr>
                                                <th>File</th>
                                                <th>Reason</th>
                                                <th>Date Added</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row"
                                style="display: flex;align-items: center;padding: 20px 35px;border-bottom: 1px solid #0000ff3b;">
                                <p class="col-md-2" style="font-weight:800;border-right:3px solid #0000ff3b">On Hold:
                                </p>
                                <div class="" id="on_hold_completed_summery_time"></div>
                                <div class="" id="on_hold_reason"></div>
                            </div>
                        <?php endif ?>
                        <!-- End Request For Funds summery -->
                    </div>
                    <div role="tabpanel" class="tab-pane" id="lead_activity"
                        style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                        <div>
                            <div class="row">
                                <div class="col-md-12">
                                    <button class="btn btn-secondary" style="float: right;" id="refresh_activity"><i
                                            class="fa fa-refresh" aria-hidden="true"></i></button>
                                </div>
                            </div>
                            <div class="activity-feed">
                                <?php foreach ($activity_log as $log) { ?>
                                    <div class="feed-item" style="height:auto;">
                                        <div class="date">
                                            <span class="text-has-action" data-toggle="tooltip"
                                                data-title="<?php echo _dt($log['date']); ?>">
                                                <?php /* echo time_ago($log['date']); */
                                                    echo _dt($log['date']);
                                                ?>
                                            </span>
                                        </div>
                                        <div class="text">
                                            <?php if ($log['staffid'] != 0) { ?>
                                                <a href="<?php echo admin_url('profile/' . $log['staffid']); ?>">
                                                    <?php echo staff_profile_image($log['staffid'], ['staff-profile-xs-image pull-left mright5']);
                                                    ?>
                                                </a>
                                                <?php
                                            } else {
                                                ?>
                                                <img loading="lazy" class="staff-profile-xs-image pull-left mright5"
                                                    src="<?php echo $profile_url; ?>" />
                                                <?php
                                            }
                                            $additional_data = '';
                                            $description = strip_tags($log['description']);
                                            if (strlen($description) > 100) {
                                                $description = mb_substr($description, 0, 120) . '...';
                                            }                                            
                                            if (!empty($log['additional_data'])) {
                                                if ($log['additional_data'] == 'Rejected') {
                                                    $additional_data = unserialize($log['additional_data']);
                                                    echo ($log['staffid'] == 0) ? _l($log['reason'], $additional_data) . ' - rejected by ' . $log['full_name'] : $log['full_name'] . ' - ' . _l($log['reason'], $additional_data) . ' - rejected by ' . $log['full_name'];
                                                } else {
                                                    $additional_data = unserialize($log['additional_data']);
                                                    echo ($log['staffid'] == 0) ? _l($description, $additional_data) : $log['full_name'] . ' - ' . _l($description, $additional_data);
                                                }

                                            } else {
                                                echo $log['full_name'] . ' - ';

                                                if ($log['custom_activity'] == 0) {
                                                    echo _l($description);
                                                } else {
                                                    echo _l($description, '', false);
                                                }
                                            }
                                            ?>
                                        </div>
                                        <div class="row" style="padding-right:15px;">
                                            <button id="activity_log_show" data-id="<?php echo $log['id']; ?>"
                                            class="btn btn-primary activity_log_show" style="float:right;margin-right:10px;">view</button>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                            <?php if ($samegroup) { ?>
                                <div class="col-md-12" style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                                    <?php echo render_textarea('lead_activity_textarea', '', '', ['placeholder' => _l('enter_activity')], [], 'mtop15'); ?>
                                    <div class="text-right">
                                        <button id="lead_enter_activity" class="btn btn-primary">
                                            <?php echo _l('submit'); ?>
                                        </button>
                                    </div>
                                </div>
                            <?php } ?>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                    <!-- Outbox section -->
                   <div role="tabpanel" class="tab-pane" id="outbox"
                        style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">

                        <div class="row">
                            <div class="col-md-12 text-right mb-2">
                                <button class="btn btn-secondary" id="outbox_refresh">
                                    <i class="fa fa-refresh" aria-hidden="true"></i>
                                </button>
                            </div>

                            <div class="col-md-12">
                                <div class="outbox-container">
                                    <div class="outbox-header">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="outbox-search-wrapper">
                                                    <input type="search" id="" class="outbox-search-box"
                                                    placeholder="Search ....." autocomplete="off">
                                                    <i class="fa fa-search outbox-search-icon"></i>
                                                </div>
                                            </div>

                                            <div class="col-md-12 mb-2" style="display:flex; align-items:center;">
                                                <div class="col-md-2" style="margin-top:10px;width:300px;">
                                                    <label for="outbox_stages_filter">Select Stage</label>
                                                    <select class="form-control selectpicker" multiple data-live-search="true" name="outbox_stages_filter" id="outbox_stages_filter">
                                                        <?php foreach ($statuses as $status): ?>
                                                            <option value="<?= $status['id'] ?>"><?= $status['name'] ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>

                                                <div class="col-md-2" style="margin-top:10px;width:300px;">
                                                    <label for="outbox_delivery_filter">Delivery Status</label>
                                                    <select class="form-control selectpicker" name="outbox_delivery_filter" id="outbox_delivery_filter">
                                                        <option>All</option>
                                                        <option value="success">Delivery Success</option>
                                                        <option value="fail">Delivery Failure</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-8 outbox-pagination text-right">
                                                    <button class="outbox-page-button" id="outbox-prev-page">‹</button>
                                                    <span class="outbox-page-info" id="outbox-page-info">Page 1 of 10</span>
                                                    <button class="outbox-page-button" id="outbox-next-page">›</button>
                                                </div>
                                            </div>
                                            <!-- outbox multiple checkbox logic  -->
                                            <div class="col-md-12 mb-2">
                                                <div class="outbox-bulk-actions bulk-action-section" style="display: flex; align-items: center; justify-content: space-between;">
                                                    <div style="display: flex; align-items: center; gap: 10px;">
                                                        <input type="checkbox" id="outbox-select-all" />
                                                        <label for="outbox-select-all" style="margin: 0;">Select All</label>
                                                    </div>

                                                    <button id="outbox-bulk-delete-btn" class="btn btn-danger btn-sm" disabled>
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="outbox-mail-list mt-2" id="outbox-list-container">
                                        <?php $this->load->view('admin/outbox/_outbox_items', ['outbox_records' => $outbox_records]); ?>
                                    </div>
                                </div>

                                <!-- Email Detail View -->
                                <div class="outbox-detail-view" style="display: none;">
                                    <div class="outbox-detail-header" style="display: flex; justify-content: space-between; align-items: center; padding: 10px; flex-wrap: wrap; gap: 10px;">
                                        <!-- Left section: back button, subject, status tag -->
                                        <div style="display: flex; align-items: center; gap: 10px;">
                                            <button class="outbox-back-button" style="background: none; border: none; cursor: pointer;">
                                                <i class="fa fa-arrow-left" style="font-size: 18px;"></i>
                                            </button>
                                            <h3 class="outbox-detail-title" id="outbox_load_email_subject" style="margin: 0; font-size: 18px;"></h3>
                                            <span class="outbox-tag" id="outbox-load-email-status-tag" style="padding: 5px 10px; border-radius: 5px; color: #fff; font-size: 14px;"></span>
                                        </div>

                                        <!-- Right section: test email -->
                                        <p id="outbox-load-test-email" style="margin: 0; font-size: 14px; color: #666;"></p>
                                    </div>
                                    <!-- profile images view -->
                                    <div class="outbox-header-container" style="display: flex; justify-content: space-between; align-items: flex-start;">
                                        <div class="outbox-header-left" style="display: flex; align-items: flex-start;">
                                            <!-- Sender image -->
                                            <img src="" class="outbox-profile-img" id="outbox-profile-img" style="width: 40px; height: 40px; border-radius: 50%; margin-right: 10px;">

                                            <!-- Sender Info -->
                                            <div class="outbox-sender-info" style="display: flex; flex-direction: column;">
                                                <div class="outbox-sender-name" id="outbox_sender_name" style="font-weight: bold;"></div>
                                                <div class="outbox-sender-email" style="display: flex; align-items: center; position: relative;">
                                                    <p id="outbox_sender_email" style="margin: 0; margin-right: 5px;"></p>

                                                    <!-- Toggle Button + Dropdown -->
                                                    <div class="outbox-recipient-wrapper" style="position: relative; display: inline-block;">
                                                        <button type="button" class="outbox-recipients-toggle" style="background: transparent; border: none; cursor: pointer;color: #8c8c8c;">
                                                            <i class="fa fa-chevron-circle-down"></i>
                                                        </button>

                                                        <div class="outbox-options-menu" style="
                                                            display: none;
                                                            position: absolute;
                                                            top: 100%;
                                                            left: 0;
                                                            background: #fff;
                                                            border: 1px solid #ddd;
                                                            padding: 10px;
                                                            z-index: 1000;
                                                            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
                                                            white-space: nowrap;
                                                            min-width: fit-content;
                                                            ">
                                                            <div><strong>To:</strong> <span id="outbox-email-to">to@example.com</span></div>
                                                            <div><strong>CC:</strong> <span id="outbox-email-cc">cc@example.com</span></div>
                                                            <div><strong>BCC:</strong> <span id="outbox-email-bcc">bcc@example.com</span></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Right-side options -->
                                        <div class="outbox-header-right" style="position: relative;">
                                            <i class="fa fa-ellipsis-v" id="outbox-options-toggle" style="cursor: pointer;"></i>
                                            <div id="outbox-options-menu" class="outbox-options-menu" style="
                                                display: none;
                                                position: absolute;
                                                right: 0;
                                                top: 100%;
                                                background: #fff;
                                                border: 1px solid #ddd;
                                                box-shadow: 0 2px 6px rgba(0,0,0,0.1);
                                                padding: 5px;
                                                z-index: 1000;
                                                min-width: fit-content;
                                            ">
                                                <div class="dropdown-item outbox-toggle-btn-resend" data-id=""><i class="fa fa-undo"></i> Resend</div>
                                                <div class="dropdown-item outbox-toggle-btn-forward" data-id=""><i class="fa fa-share"></i> Forward</div>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="outbox-detail-body">
                                        <iframe id="email-preview-frame" style="width: 100%; height: 600px; border: none;"></iframe>
                                    </div>
                                    <div class="outbox-detail-footer">
                                    </div>
                                    <div class="col-md-12" style="margin-top:15px;">
                                        <?php echo form_open('admin/Outbox/forward_outbox_email' . $lead->id, ['class' => 'mtop15 mbot15', 'id' => 'outbox_forward_email', 'style' => 'display:none;border:1px solid;padding:20px;']); ?>
                                        <input type="hidden" class="outbox_forward_id" >    
                                        <div class="">
                                                <?php echo render_input('subject_outbox_forward_email', 'Subject', '', '', ['required' => 'required']); ?>
                                                <?php echo render_input('to_outbox_forward_email', 'To', '', '', ['required' => 'required']); ?>
                                                <?php echo render_input('cc_outbox_forward_email', 'CC', '', ''); ?>
                                                <?php echo render_input('bcc_outbox_forward_email', 'BCC', '', ''); ?>
                                            </div>
                                            <textarea name="send_tinymace_outbox_forward_email"
                                                id="send_tinymace_outbox_forward_email" rows="10" cols="80"
                                                style="height: 400px;"></textarea>
                                            <div style="display:flex;align-items:center;">
                                                <button type="submit" class="btn btn-primary" id="forward_outbox_submit_btn"
                                                    style="margin:30px 10px;">Sent Email</button>
                                            </div>
                                        <?php echo form_close(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Case notification -->
                    <div role="tabpanel" class="tab-pane" id="case_notification" style="">
                        <ul class="notifications-list" id="notificationsList"></ul>
                    </div>
                    <div role="tabpanel" class="tab-pane" id="file_opened">
                        <?php
                        if ($leads_status_id[0]['id'] == 1 && $leads_status_id[0]['name'] == 'File Opened') {
                            $file_opened_checklist_id = $leads_status_id[0]['id'];
                        }
                        ?>
                        <div class="col-md-12">
                            <!-- review email file opened  -->
                            <div class="col-md-12">
                                <button class="btn btn-secondary" style="float: right;" id="refresh_page"><i
                                        class="fa fa-refresh" aria-hidden="true"></i></button>
                                <div style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                                    <?php if ($samegroup) { ?>
                                        <button class="btn btn-primary" id="btn_file_opened_email_review"
                                            style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">Review Broker
                                            Email</button>
                                        <button class="btn btn-primary" id="btn_file_opened_email_review_by_client"
                                            style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">Review Client
                                            Email</button>
                                        <?php
                                            $style = ($samegroup === 2) ? 'display:none;' : '';
                                            $disabled = ($change_password_flag == true) ? 'disabled' : '';
                                        ?>
                                        <button class="btn btn-primary" id="btn_send_login_email"
                                                style="<?php echo $style; ?>">
                                            SEND APP LOGINS
                                        </button>
                                        <button class="btn btn-primary" id="btn_file_opened_outstanding_ids_client_email"
                                            style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">Review Outstanding
                                            ID's</button>
                                        <button class="btn btn-primary" id="case_report_modal_trigger_btn" style="margin-right:5px;">Create Opening Pack</button>
                                        <?php if ($leads_status_current_id == 1) { ?>
                                            <button class="btn btn-primary" style="float: right;margin-right: 10px;"
                                                id="complete_stage<?php echo $file_opened_checklist_id; ?>" <?php echo ($leads_status_current_id == 1 && $count_of_file_open_checklist['count_file_open'] > 0 && $count_of_file_open_checklist['count_file_open'] == $count_of_file_open_checklist['total_count_file_open']) ? '' : ''; ?>>
                                                Complete stage
                                            </button>
                                        <?php } else { ?>
                                            <button class="btn btn-primary" style="float: right;margin-right: 10px;"
                                                id="complete_stage<?php echo $file_opened_checklist_id; ?>" <?php echo ($leads_status_current_id == 1) ? '' : 'disabled'; ?>>
                                                Complete stage
                                            </button>
                                        <?php } ?>
                                    <?php } ?>
                                </div>
                            </div>
                            <!-- email content review code  by broker-->
                            <div class="row" id="file_opened_email_review" style="margin-bottom:15px;display:none;">
                                <div class="col-md-12" id="" style="border: 1px solid;margin-top: 20px;">
                                    <ul id="file_opened_broker_all_checklist_review" style="display:none;"></ul>
                                    <?php echo form_open('admin/leads/file_opened_review_email_send/' . $lead->id, ['class' => 'mtop15 mbot15', 'id' => 'FileOpenReviewMail']); ?>
                                    <div class="">
                                        <?php echo render_input('to_fileopenreviewmail', 'To', $to_broker_emails, '', ['required' => 'required']); ?>
                                        <?php echo render_input('cc_fileopenreviewmail', 'CC', $cc_group_memebers, ''); ?>
                                        <?php echo render_input('bcc_fileopenreviewmail', 'BCC', '', ''); ?>
                                    </div>
                                    <textarea name="file_opened_broker_email_review_tincymac"
                                        id="file_opened_broker_email_review_tincymac" rows="10" cols="80"
                                        style="height: 400px;"></textarea>
                                    <div style="display: flex;justify-content: end;align-items: center;margin-bottom: 20px;"
                                        class="col-md-12">
                                        <div style="margin-right: 10px;margin-top:-5px;" id="fileopen_broker_loader"></div>
                                        <button type="submit" class="btn btn-primary" id="fileopen_broker_submit_btn"
                                            style="margin:30px 10px;">Send
                                            Email to broker</button>
                                    </div>
                                    <?php echo form_close(); ?>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <!-- send mail to the clien review by client in file opened stage -->
                            <div class="row" id="file_opened_client_email_review"
                                style="margin-bottom:15px;border:1px solid; padding:15px;display:none;">
                                <!-- Client File opened Email Review -->
                                <div id="file_opened_client_review_all" style="display:none;"></div>
                                <div class="col-md-12">
                                    <?php echo form_open('admin/leads/file_opened_client_review_email_send/' . $lead->id, ['class' => 'mtop15 mbot15', 'id' => 'FileOpenClientReviewMail']); ?>
                                    <div class="">
                                        <?php echo render_input('to_fileopen_client_reviewmail', 'To', $to_all_case_clients_email, 'text', ['required' => 'required']); ?>
                                        <?php echo render_input('cc_fileopen_client_reviewmail', 'CC', $cc_group_memebers, 'text'); ?>
                                        <?php echo render_input('bcc_fileopen_client_reviewmail', 'BCC', '', 'text'); ?>
                                    </div>
                                    <textarea name="file_opened_client_email_review_tincymac"
                                        id="file_opened_client_email_review_tincymac" rows="10" cols="80"
                                        style="height: 400px;"></textarea>
                                    <div style="display: flex;justify-content: end;align-items: center;margin-bottom: 20px;"
                                        class="col-md-12">
                                        <div style="margin-right: 10px;margin-top:-5px;" id="fileopen_client_loader"></div>
                                        <button type="submit" class="btn btn-primary" id="fileopen_client_submit_btn"
                                            style="margin:30px 10px;">Send email
                                            to client</button>
                                    </div>
                                    <?php echo form_close(); ?>
                                </div>
                            </div>
                            <!-- send mail to the clien review by outstanding items ids -->
                            <div class="row" id="file_opened_client_email_review_outstanding"
                                style="margin-bottom:15px;border:1px solid; padding:15px;display:none;">
                                <!-- Client File opened Email Review -->
                                <!-- <div id="file_opened_client_review_all" style="display:none;"></div> -->
                                <div class="col-md-12">
                                    <?php echo form_open('admin/leads/file_opened_outstanding_ids_client_review_email_send/' . $lead->id, ['class' => 'mtop15 mbot15', 'id' => 'FileOpen_Outstanding_ClientReview_Mail']); ?>
                                    <div class="">
                                        <?php echo render_input('to_fileopen_outstanding_ids_client_reviewmail', 'To', $to_all_case_clients_email, 'text', ['required' => 'required']); ?>
                                        <?php echo render_input('cc_fileopen_outstanding_ids_client_reviewmail', 'CC', $cc_group_memebers, 'text'); ?>
                                        <?php echo render_input('bcc_fileopen_outstanding_ids_client_reviewmail', 'BCC', '', 'text'); ?>
                                    </div>
                                    <textarea name="file_opened_client_email_review_outstanding_tincymac"
                                        id="file_opened_client_email_review_outstanding_tincymac" rows="10" cols="80"
                                        style="height: 400px;"></textarea>
                                    <div style="display: flex;justify-content: end;align-items: center;margin-bottom: 20px;"
                                        class="col-md-12">
                                        <div style="margin-right: 10px;margin-top:-5px;"
                                            id="fileopen_client_outstanding_loader"></div>
                                        <button type="submit" class="btn btn-primary"
                                            id="fileopen_client_outstanding_submit_btn" style="margin:30px 10px;">Send email
                                            to client</button>
                                    </div>
                                    <?php echo form_close(); ?>
                                </div>
                            </div>
                            <!-- DL Check table details show -->
                            <?php if ($current_staff_role != 2 && $current_staff_role != 6) { ?>
                                <!-- if unauthorized nuborrow files exit then show otherwise not -->
                                <?php if($uncategorized_nuborrow_files > 0){?>
                                    <div class="col-md-12">
                                        <div class="clearfix"></div>
                                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                                        <div class="alert alert-info" style="margin-top:40px;">
                                            <span class="no-margin font-medium-xs bold" style="display: flex;justify-content: center;">
                                                <bold style="font-weight:800;">Uncategorized Documents</bold>
                                            </span>
                                        </div>
                                        <table class="table dt-table table-ticket-reports dt-inline dataTable no-footer" id="uncategorized-documents-table">
                                            <thead>
                                                <tr>
                                                    <th>File Name</th>
                                                    <th>Select Item</th>
                                                    <th>Created At</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                        <div style="margin-bottom:10px;float: inline-end;">
                                            <button id="assign-selected-docs" class="btn btn-primary">Assign Selected Documents</button>
                                        </div>    
                                    </div>
                                <?php } ?>
                                <div class="clearfix"></div>
                                <hr class="-tw-mx-4 tw-border-neutral-200" />
                                <div class="alert alert-info" style="margin-top:40px;">
                                    <span class="no-margin font-medium-xs bold" style="display: flex;justify-content: center;">
                                        <bold style="font-weight:800;">DL Check</bold>
                                    </span>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                                        <div id="DL-check-container"></div>
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <?php } ?>
                            <!-- first client checklist details show  -->
                            <div class="alert alert-info" style="margin-top:40px;">
                                <span class="no-margin font-medium-xs bold" style="display: flex;justify-content: center;">
                                    <bold style="font-weight:800;"><?php echo 'First Client' . ' (' . $lead->name . ') '; ?>
                                        Uploaded ID Documents</bold>
                                </span>
                            </div>
                        </div>
                        <!-- client checklist is not show to the broker  -->
                        <div class='form-group' style="padding: 17px;display:none;" app-field-wrapper='order_no'>
                            <label for='order_no' class='control-label'>Select Checklist Template</label>
                            <select name="order_no1" id="order_no<?php echo $file_opened_checklist_id; ?>"
                                class="form-control" <?php echo ($leads_status_current_id == 1 || $leads_status_current_id >= $file_opened_checklist_id) ? '' : 'disabled'; ?> data-id='1'>
                                <option value=''>Select Custom Checklist</option>
                                <?php
                                $uniqueIds = array();
                                foreach ($get_checklist_template_status_fileopen_id as $item) {
                                    if (!in_array($item['addedfrom'], $uniqueIds)) {
                                        $uniqueIds[] = $item['addedfrom'];
                                        echo '<option value="' . $item['addedfrom'] . '">' . get_staff_name_by_id($this, $item['addedfrom']) . '</option>';
                                    }
                                }
                                ?>
                            </select>
                        </div>
                        <!-- 
                         File opened first client pending documents list
                        <div class="col-md-12" id="first_client_images"></div> 
                        
                        -->
                        <!-- 
                        file opened first client checkboxes
                        <div id="file_opened_checklist_item"></div> 
                        -->
                        <?php if ($samegroup): ?>
                            <div class="col-md-12" style="margin-bottom:15px;">
                                <div class="clearfix"></div>
                                <button class="btn btn-primary" id="file_opened_form_show_button" style="margin-top:15px;">Add
                                    ID Item</button>
                                <div class="clearfix"></div>
                                <hr class="-tw-mx-4 tw-border-neutral-200" />
                            </div>
                        <?php endif; ?>
                        <div id="file_opened_form_show" style="display:none;">
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <div id="hide_checklsit_form<?php echo $file_opened_checklist_id; ?>">

                                <?php
                                $this->load->view('admin/leads/Checklist_all_stages', ['samegroup' => $samegroup, 'checklist_id' => $file_opened_checklist_id, 'lead_status_current_id' => $leads_status_current_id, 'checklist_item_type_data' => $checklist_item_type_data]);
                                ?>
                            </div>
                        </div>
                        <script>
                            $(document).ready(function () {
                                $('#file_opened_form_show_button').click(function () {
                                    $('#file_opened_form_show').slideToggle();
                                });
                            });
                        </script>
                        <div id="checklist_template_form<?php echo $file_opened_checklist_id; ?>">
                        </div>
                        <!-- view of all checklist -->
                        <div role="tabpanel" class="tab-pane" id="">
                            <!-- client file opened table -->
                            <div class="row">
                                <div class="col-md-12">
                                    <hr class="-tw-mx-4 tw-border-neutral-200" />
                                    <div id="data-container<?php echo $file_opened_checklist_id; ?>"></div>
                                </div>
                            </div>
                        </div>
                        <!-- Second borrower checkboxes show -->
                        <div id="file_opened_checklist_item_for_borrower"></div>
                        <div id="data-container-borrower"></div>
                        <!--  Broker file opened details -->
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <div class="alert alert-info" style="margin-top:40px;">
                            <span class="no-margin font-medium-xs bold" style="display: flex;justify-content: center;">
                                <bold style="font-weight:800;">Broker Uploaded Documents</bold>
                            </span>
                        </div>
                        <!-- 
                        File opened borker pending images show
                        <div id="file_opened_broker_images_show"></div>
                         -->
                        <?php if ($current_staff_role !== 2 && $current_staff_role !== 6) { ?>
                            <div class='form-group' style=" padding: 17px;display:none;" app-field-wrapper='order_no_broker'>
                                <label for='order_no' class='control-label'>Select Checklist Template</label>
                                <select name="order_no_broker1" id="order_no_broker<?php echo $file_opened_checklist_id; ?>"
                                    class="form-control" <?php echo ($leads_status_current_id == 1 || $leads_status_current_id >= $file_opened_checklist_id) ? '' : 'disabled'; ?> data-id='1'>
                                    <option value=''>Select Custom Checklist</option>
                                    <?php
                                    $uniqueIds = array();
                                    foreach ($get_checklist_template_status_fileopen_id as $item) {
                                        if (!in_array($item['addedfrom'], $uniqueIds)) {
                                            $uniqueIds[] = $item['addedfrom'];
                                            echo '<option value="' . $item['addedfrom'] . '">' . get_staff_name_by_id($this, $item['addedfrom']) . '</option>';
                                        }
                                    }
                                    ?>
                                </select>
                            </div>
                        <?php } ?>
                        <!-- file opened checkboxes for broker -->
                        <!-- 
                        Broker file opened checkboxes
                        <div id="file_opened_checklist_item_broker"></div> 
                        -->
                        <?php if ($samegroup): ?>
                            <div class="col-md-12" style="margin-bottom:15px;">
                                <button class="btn btn-primary" id="file_opened_form_show_button_broker"
                                    style="margin-top:15px;">Add Item</button>
                            </div>
                        <?php endif; ?>
                        <div id="file_opened_form_show_broker" style="display:none;">
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <div id="hide_checklsit_form_broker<?php echo $file_opened_checklist_id; ?>">
                                <?php
                                $this->load->view('admin/leads/broker_checklist_all_stages', ['samegroup' => $samegroup, 'checklist_id' => $file_opened_checklist_id, 'lead_status_current_id' => $leads_status_current_id, 'checklist_item_type_data' => $checklist_item_type_data]);
                                ?>
                            </div>
                        </div>
                        <!-- show broker template data -->
                        <div id="checklist_template_form_broker<?php echo $file_opened_checklist_id; ?>"></div>
                        <!--checklist table for broker -->
                        <div class="row">
                            <div class="col-md-12">
                                <hr class="-tw-mx-4 tw-border-neutral-200" />
                                <div id="data-container_broker<?php echo $file_opened_checklist_id; ?>"></div>
                            </div>
                        </div>
                    </div>
                    <script>
                        $(document).ready(function () {
                            $('#file_opened_form_show_button_broker').click(function () {
                                $('#file_opened_form_show_broker').slideToggle();
                            });
                        });
                    </script>
                    <!-- ID verification tab  -->
                    <div role="tabpanel" class="tab-pane" id="id_verification"
                        style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                        <?php
                        if ($leads_status_id[7]['id'] == 8 && $leads_status_id[7]['name'] == 'ID Verification') {
                            $id_verification_checklist_id = $leads_status_id[7]['id'];
                        }
                        ?>
                        <?php if ($samegroup) { ?>
                            <button class="btn btn-primary" style="float: right;"
                                id="complete_stage<?php echo $id_verification_checklist_id; ?>" <?php echo ($leads_status_current_id == 8) ? '' : 'disabled'; ?>>
                                Complete stage</button>
                            <button class="btn btn-primary" style="float: right;margin-right:5px;"
                                id="undo_stage<?php echo $id_verification_checklist_id; ?>" <?php echo ($leads_status_current_id == 8) ? '' : 'disabled'; ?>>
                                Undo (
                                <?php echo ($leads_status_current_id == 1) ? 'File Opened' : 'ID Completed '; ?>) stage
                            </button>
                            <button class="btn btn-secondary" style="float: right;margin-right: 8px;" id="refresh_page"><i
                                    class="fa fa-refresh" aria-hidden="true"></i></button>
                            <div class="clearfix"></div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <?php } ?>
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <h3 style="color:red;display:none;" id="idv_not_pass_msg">Please answer the IDV section below before completing this stage.</h3>
                        <div class="alert alert-info" style="margin-top:40px;">
                            <span class="no-margin font-medium-xs bold" style="display: flex;justify-content: center;">
                                <?php echo $lead->name; ?> ID Verification Documents
                            </span>
                        </div>
                        <div id='id_verification_details_record'>
                        </div>
                        <div id="instructions-container"></div>
                        <!-- id verification document upload form -->
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <div class="alert alert-info" style="margin-top:40px;">
                            <span class="no-margin font-medium-xs bold"
                                style="display: flex;justify-content: center;color:red;font-weight:800;">
                                    IDV WARNING/IDV EMAIL SENT
                            </span>
                        </div>
                        <div style="padding: 0px 30px;">
                            <?php echo form_open('admin/leads/id_verification_attachment', ['class' => 'mtop15 mbot15', 'id' => 'id_verification_attachment_begin']); ?>
                            <?php
                            $imp_html = "<div class='form-group'><label for='select_user' class='control-label'><span style='color:red;'>*</span> Select Client</label>";
                            $imp_html .= "<select name='select_user' id='select_user_idv_begin' class='form-control selectpicker' data-width='100%' data-none-selected-text='Nothing selected' data-live-search='true' tabindex='-98' required>";
                            // $imp_html .= "<option value=''>Not assigned yet</option>";
                            $imp_html .= "<option value=\"{$lead->id}\">{$lead->name}</option>";
                            foreach ($leads_borrow as $borrow) {
                                $imp_html .= "<option value=\"{$borrow['id']}\">{$borrow['borrow_firstname']} {$borrow['borrow_middlename']} {$borrow['borrow_lastname']}</option>";
                            }

                            $imp_html .= "</select></div>";
                            echo $imp_html; ?>
                            <!-- id verification received or not -->
                            <?php
                            $imp_html = "<div class='form-group'><label for='idv_done_by' class='control-label'><span style='color:red;'>*</span> IDV WARNING/IDV EMAIL SENT</label>";
                            $imp_html .= "<select name='idv_done_by' id='idv_done_by' class='form-control selectpicker' data-width='100%' data-none-selected-text='Nothing selected' data-live-search='true' tabindex='-98'>";
                            $imp_html .= "<option value=''>Select an item</option>";
                            $imp_html .= "<option value='DOCUSIGN'>DOCUSIGN</option>";
                            $imp_html .= "<option value='FCT'>FCT/Bluink</option>";
                            // $imp_html .= "<option value='Hosper'>FCT/Bluink, E.G. Hosper Files</option>";
                            $imp_html .= "<option value='Other'>Other</option>";
                            $imp_html .= "</select><span class='idv_question_error' style='color:red;'></span></div>";
                            echo $imp_html; ?>
                            <div style="border:1px solid;padding:20px;">
                                <div class="" id="cc_bcc_inputs_fields" style="display:none;">
                                    <?php echo render_input('to_idv_done_through', 'To', $lead->email, 'text', ['required' => 'required']); ?>
                                    <?php echo render_input('cc_idv_done_through', 'CC', '', 'text'); ?>
                                    <?php echo render_input('bcc_idv_done_through', 'BCC', '', 'text'); ?>
                                </div>
                                <div id="idv_done_through_select_docsign" style="display:none;">
                                    <textarea name="idv_done_through_ot_docsign_tincymac"
                                        id="idv_done_through_ot_docsign_tincymac" rows="10" cols="80"
                                        style="height: 400px;"></textarea>
                                </div>
                                <div id="idv_done_through_select_fct" style="display:none;">
                                    <textarea name="idv_done_through_ot_fct_tincymac" id="idv_done_through_ot_fct_tincymac"
                                        rows="10" cols="80" style="height: 400px;"></textarea>
                                </div>
                                <div id="idv_done_through_select_hosper" style="display:none;">
                                    <textarea name="idv_done_through_ot_hosper_tincymac" id="idv_done_through_ot_hosper_tincymac" 
                                        rows="10" cols="80" style="height: 400px;"></textarea>
                                </div>
                                <div id="idv_done_through_select_other" style="display:none;">
                                    <textarea name="idv_done_through_other_tincymac" id="idv_done_through_other_tincymac"
                                        rows="10" cols="80" style="height: 400px;"></textarea>
                                </div>
                            </div>
                            <?php /*
                            $imp_html = "<div class='form-group' id='' style=''><label for='dl_check_completed_begin_through' class='control-label'>DL Check Completed?</label>";
                            $imp_html .= "<select name='dl_check_completed' id='dl_check_completed_begin_through' class='form-control selectpicker' data-width='100%' data-none-selected-text='Nothing selected' data-live-search='true' tabindex='-98'>";
                            $imp_html .= "<option value='no' selected>No</option>";
                            $imp_html .= "<option value='yes'>Yes</option>";
                            $imp_html .= "</select></div>";
                            echo $imp_html; */?>
                            <!-- <div id="dl_check_completed_at_div_begin_through" style="display:none;">
                                <?php echo render_date_input('dl_check_completed_at', 'DL Check Completed At:', ''); ?>
                            </div> -->
                            <!-- idv description input field -->
                            <?php echo render_textarea('idv_description', 'Notes', ''); ?>
                            <div id="id_verification_description_error" class="error-message"
                                style="color:red;margin-top: -8px;"></div>
                            <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                            <?php if ($samegroup) { ?>
                                <div style="display: flex;justify-content:center;align-items:center;float:right;">
                                    <div style="margin-right: 10px;" id="loader_begin"></div>
                                    <input type="submit" id="id_verification_submit_button_begin" class="btn btn-primary"
                                        style="float:right;" <?php echo ($leads_status_current_id == 8 || $current_status_order_id >= 2) ? '' : 'disabled'; ?>>
                                </div>
                            <?php } ?>
                            <?php echo form_close(); ?>
                        </div>
                        <!-- idv Received -->
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <div class="alert alert-info" style="margin-top:40px;">
                            <span class="no-margin font-medium-xs bold"
                                style="display: flex;justify-content: center;color:red;font-weight:800;">
                                    IDV Received
                            </span>
                        </div>
                        <div style="padding: 0px 30px;">
                            <?php echo form_open('admin/leads/id_verification_attachment', ['class' => 'mtop15 mbot15', 'id' => 'id_verification_attachment_received']); ?>
                            <?php
                            $imp_html = "<div class='form-group'><label for='select_user' class='control-label'><span style='color:red;'>*</span> Select Client</label>";
                            $imp_html .= "<select name='select_user' id='select_user_idv_receive' class='form-control selectpicker' data-width='100%' data-none-selected-text='Nothing selected' data-live-search='true' tabindex='-98' required>";
                            // $imp_html .= "<option value=''>Not assigned yet</option>";
                            $imp_html .= "<option value=\"{$lead->id}\">{$lead->name}</option>";
                            foreach ($leads_borrow as $borrow) {
                                $imp_html .= "<option value=\"{$borrow['id']}\">{$borrow['borrow_firstname']} {$borrow['borrow_middlename']} {$borrow['borrow_lastname']}</option>";
                            }

                            $imp_html .= "</select></div>";
                            echo $imp_html; ?>
                            <!-- id verification received or not -->
                            <?php
                            $imp_html = "<div class='form-group' style='margin-top:20px;'><label for='idv_received' class='control-label'><span style='color:red;'>*</span> IDV Received?</label>";
                            $imp_html .= "<select name='idv_received' id='idv_received' class='form-control selectpicker' data-width='100%' data-none-selected-text='Nothing selected' data-live-search='true' tabindex='-98'>";
                            $imp_html .= "<option value='' selected>Select an item</option>";
                            $imp_html .= "<option value='yes'>Yes</option>";
                            $imp_html .= "<option value='no'>No/CHASING CLIENT TO DO IDV</option>";
                            $imp_html .= "<option value='N/A'>N/A (Not Applicable)</option>";
                            $imp_html .= "</select><span class='idv_question_error' style='color:red;'></span></div>";
                            echo $imp_html; ?>
                            <?php
                            $imp_html = "<div class='form-group' id='idv_pass_check' style='display:none;'><label for='idv_received_pass' class='control-label'>IDV Pass?</label>";
                            $imp_html .= "<select name='idv_received_pass' id='idv_received_pass' class='form-control selectpicker' data-width='100%' data-none-selected-text='Nothing selected' data-live-search='true' tabindex='-98'>";
                            $imp_html .= "<option value=''>Not assigned yet</option>";
                            $imp_html .= "<option value='yes'>Yes</option>";
                            $imp_html .= "<option value='no'>No</option>";
                            $imp_html .= "</select></div>";
                            echo $imp_html; ?>
                            <div style="border:1px solid;padding:20px;">
                                <div id="idv_pass_cc_fields" style="display:none;">
                                    <?php echo render_input('to_idv_received', 'To', $lead->email, 'text', ['required' => 'required']); ?>
                                    <?php echo render_input('cc_idv_received', 'CC', '', 'text'); ?>
                                    <?php echo render_input('bcc_idv_received', 'BCC', '', 'text'); ?>
                                </div>
                                <div id="idv_received_no_div_tinymce" style="margin-top:20px;display:none;">
                                    <textarea name="idv_received_no_tinymce" id="idv_received_no_tinymce" rows="10"
                                        cols="80" style="height: 400px;"></textarea>
                                </div>
                                <div id="idv_received_yes_pass_yes_div_tinymce" style="margin-top:20px;display:none;">
                                    <textarea name="idv_received_yes_pass_yes_tinymce"
                                        id="idv_received_yes_pass_yes_tinymce" rows="10" cols="80"
                                        style="height: 400px;"></textarea>
                                </div>
                                <div id="idv_received_yes_pass_no_div_tinymce" style="margin-top:20px;display:none;">
                                    <textarea name="idv_received_yes_pass_no_tinymce" id="idv_received_yes_pass_no_tinymce"
                                        rows="10" cols="80" style="height: 400px;"></textarea>
                                </div>
                            </div>
                            <?php
                            // $imp_html = "<div class='form-group' id='' style=''><label for='dl_check_completed_received' class='control-label'>DL Check Completed?</label>";
                            // $imp_html .= "<select name='dl_check_completed' id='dl_check_completed_received' class='form-control selectpicker' data-width='100%' data-none-selected-text='Nothing selected' data-live-search='true' tabindex='-98'>";
                            // $imp_html .= "<option value='no' selected>No</option>";
                            // $imp_html .= "<option value='yes'>Yes</option>";
                            // $imp_html .= "</select></div>";
                            // echo $imp_html;
                            ?>
                            <!-- <div id="dl_check_completed_at_div_received" style="display:none;"> -->
                                <?php /* echo render_date_input('dl_check_completed_at', 'DL Check Completed At:', ''); */?>
                            <!-- </div> -->
                            <!-- idv description input field -->
                            <?php echo render_textarea('idv_description', 'Notes', ''); ?>
                            <div id="id_verification_description_error" class="error-message"
                                style="color:red;margin-top: -8px;"></div>
                            <!-- <div class="form-group" id="id_verification_file_div" style="display:none;">
                                <label for="id_verification_file" class="control-label"><span style="color:red;">*</span> <b
                                        style="font-weight: 800;">Select Files (PDF, JPEG, JPG, PNG, DOC, DOCX, XLS,
                                        XLSX)</b></label>
                                <input type="file" class="form-control" name="id_verification_file[]"
                                    id="id_verification_file" multiple
                                    accept=".pdf, .jpeg, .jpg, .png, .doc, .docx, .xls, .xlsx" style="height:53px;">
                                <div id="id_verification_file_error" class="error-message" style="color:red;"></div>
                            </div> -->
                            <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                            <?php if ($samegroup) { ?>
                                <div style="display: flex;justify-content:center;align-items:center;float:right;">
                                    <div style="margin-right: 10px;" id="loader_received"></div>
                                    <input type="submit" id="id_verification_submit_button_received" class="btn btn-primary"
                                        style="float:right;" <?php echo ($leads_status_current_id == 8 || $current_status_order_id >= 2) ? '' : 'disabled'; ?>>
                                </div>
                            <?php } ?>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                    <div role="tabpanel" class="tab-pane" id="instructions_received"
                        style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                        <?php
                        if ($leads_status_id[1]['id'] == 2 && $leads_status_id[1]['name'] == 'Instructions Stage') {
                            $Instruction_checklist_id = $leads_status_id[1]['id'];
                        }
                        ?>
                        <?php if ($samegroup) { ?>
                            <button class="btn btn-primary" style="float: right;"
                                id="complete_stage<?php echo $Instruction_checklist_id; ?>" <?php echo ($leads_status_current_id == 2) ? '' : 'disabled'; ?>>
                                Complete stage</button>
                            <button class="btn btn-primary" style="float: right;margin-right:5px;"
                                id="undo_stage<?php echo $Instruction_checklist_id; ?>" <?php echo ($leads_status_current_id == 2) ? '' : 'disabled'; ?>>
                                Undo (ID verification) stage</button>
                            <button class="btn btn-secondary" style="float: right;margin-right: 8px;" id="refresh_page"><i
                                    class="fa fa-refresh" aria-hidden="true"></i></button>
                            <button class="btn btn-primary" style="margin-right:5px;" id="ins_received_initial_email_btn" >
                                Initial response to lawyer/lender
                            </button>   
                            <button class="btn btn-primary" style="margin-right:5px;" id="ins_received_email_btn" >
                                Email to lawyer/lender
                            </button> 
                            <button class="btn btn-primary" style="margin-right:5px;" id="preliminary_ins_received_btn" >
                                preliminary email to client
                            </button> 
                            <div class="clearfix"></div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                                <!-- email content Initial response to lawyer/lender -->
                            <div class="col-md-12" style="border:1px solid black;display:none;" id="ins_received_initial_email_content">
                                <?php echo form_open('admin/leads/ins_received_initial_email_to_laywer', ['class' => 'mtop15 mbot15', 'id' => 'ins_received_initial_email_to_laywer_fromid']); ?>
                                    <?php echo render_input('to_ins_received_initial_laywer_emails', 'To', '', '', ['required' => 'required']); ?>
                                    <?php echo render_input('cc_ins_received_initial_laywer_emails', 'CC', $cc_group_memebers, ''); ?>
                                    <?php echo render_input('bcc_ins_received_initial_laywer_emails', 'BCC', '', ''); ?>
                                    <textarea name="ins_received_initial_email_to_laywer_editorid" id="ins_received_initial_email_to_laywer_editorid" rows="10"
                                            cols="80" style="height: 400px;"></textarea>
                                    <div style="display: flex;justify-content: end;align-items: center;margin-bottom: 20px;"
                                        class="col-md-12">
                                        <div style="margin-right: 10px;margin-top:-5px;" id="ins_received_initial_email_loader"></div>
                                        <button type="submit" class="btn btn-primary" id="ins_received_initial_email_submitbtn"
                                            style="margin:30px 10px;">Send email to Laywer/Lender</button>
                                    </div>
                                <?php echo form_close(); ?>
                            </div>
                            <!-- Email content Email to laywer/lender -->
                            <div class="col-md-12" style="border:1px solid black;display:none;" id="ins_received_email_content">
                                <?php echo form_open('admin/leads/ins_received_email_to_laywer', ['class' => 'mtop15 mbot15', 'id' => 'ins_received_email_to_laywer_fromid']); ?>
                                    <?php echo render_input('to_ins_received_laywer_emails', 'To', '', '', ['required' => 'required']); ?>
                                    <?php echo render_input('cc_ins_received_laywer_emails', 'CC', $group_members_or_broker_emails, ''); ?>
                                    <?php echo render_input('bcc_ins_received_laywer_emails', 'BCC', '', ''); ?>
                                    <textarea name="ins_received_email_to_laywer_editorid" id="ins_received_email_to_laywer_editorid" rows="10" cols="80" style="height: 400px;"></textarea>
                                    <div style="display: flex;justify-content: end;align-items: center;margin-bottom: 20px;" class="col-md-12">
                                        <div style="margin-right: 10px;margin-top:-5px;" id="ins_received_email_loader"></div>
                                        <button type="submit" class="btn btn-primary" id="ins_received_email_submitbtn" style="margin:30px 10px;">Send email to Laywer/Lender</button>
                                    </div>
                                <?php echo form_close(); ?>
                            </div>
                            <!-- premilinary instrction received email -->
                            <div class="col-md-12" style="border:1px solid black;display:none;" id="preliminary_ins_received_email_content">
                                <?php echo form_open('admin/leads/preliminary_email_to_client', ['class' => 'mtop15 mbot15', 'id' => 'preliminary_instruction_rece_formid']); ?>
                                    <?php echo render_input('to_preliminary_instruction_received', 'To', $to_all_case_clients_email, '', ['required' => 'required']); ?>
                                    <?php echo render_input('cc_preliminary_instruction_received', 'CC', $group_members_or_broker_emails, ''); ?>
                                    <?php echo render_input('bcc_preliminary_instruction_received', 'BCC', '', ''); ?>
                                    <textarea name="preliminary_instruction_received_editorid" id="preliminary_instruction_received_editorid" rows="10" cols="80" style="height: 400px;"></textarea>
                                    <div style="display: flex;justify-content: end;align-items: center;margin-bottom: 20px;" class="col-md-12">
                                        <div style="margin-right: 10px;margin-top:-5px;" id="preliminary_instruction_received_loader"></div>
                                        <button type="submit" class="btn btn-primary" id="preliminary_instruction_received_submitbtn" style="margin:30px 10px;">Send email to client</button>
                                    </div>
                                <?php echo form_close(); ?>
                            </div>
                        <?php } ?>
                        <?php
                        $lender_ids_array = !empty($lead->lender_ids) ? explode(',', $lead->lender_ids) : [];
                        if (!empty($lender_ids_array)) { ?>
                            <div class="clearfix"></div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <div class="alert alert-info" style="margin-top:40px;">
                                <span class="no-margin font-medium-xs bold" style="display: flex;justify-content: center;">
                                    Instruction Details
                                </span>
                            </div>
                            <!-- instruction table -->
                            <!-- instruction in table form -->
                            <div id="instructionDetailsContainer"></div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" />

                            <div class="clearfix"></div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <div class="alert alert-info" style="margin-top:40px;">
                                <span class="no-margin font-medium-xs bold"
                                    style="display: flex;justify-content: center;font-weight:900;">
                                    Add Lender Details
                                </span>
                            </div>
                            <?php echo form_open('admin/leads/instruction_attachment', ['class' => 'mtop15 mbot15 instruction_received_attachment']); ?>
                            <?php
                                $selected = [];
                                $agent_data = [];
                                foreach ($back_data as $key => $bankData) {
                                    if (!empty($bankData['id'])) {
                                        $agent_data[] = [
                                            'id' => $bankData['id'],
                                            'bank_name' => $bankData['bank_name'],
                                        ];
                                    }
                                }
                                // $agent_data[] = ['id' => '1000', 'bank_name' => 'Others'];
                            ?>
                            <?php echo render_select('bank_id', $agent_data, ['id', 'bank_name'], '<span style="color:red;">*</span> <b style="font-weight: 800;">Lender’s name</b>', ''); ?>
                            <div class="" id="lender_address"></div>
                            <div id="bank_id_error" class="error-message" style="color:red;margin-top: -10px;width:100%;"></div>
                            <?php echo render_select('laywer_firm_id', $laywer_firm_data, ['id', 'name'], '<b style="font-weight: 800;">Law Firm Name</b>', ); ?>
                            <div class="form-group">
                                <label for="lawyer_id_option" style="font-weight: 800;">Select Lawyer</label>
                                <select id="lawyer_id_option" name="lawyer_id[]"
                                    class="form-control selectpicker lawyer_id_option" data-live-search="true" multiple>
                                    <option value="" disabled>Select Lawyer</option>
                                </select>
                            </div>
                            <?php echo render_textarea('description', ' <b style="font-weight: 800;">Comments</b>', ''); ?>
                            <div id="bank_description_error" class="error-message" style="color:red;margin-top: -8px;"></div>
                            <div class="form-group">
                                <label for="bank_file" class="control-label"><span style="color:red;">*</span> <b
                                        style="font-weight: 800;">Select Files (PDF, JPEG, JPG, PNG, DOC, DOCX, XLS,
                                        XLSX)</b></label>
                                <input type="file" class="form-control" name="bank_file[]"
                                    id="bank_file_<?php echo $lender_id; ?>" multiple
                                    accept=".pdf, .jpeg, .jpg, .png, .doc, .docx, .xls, .xlsx" style="height:53px;">
                                <div id="bank_file_error" class="error-message" style="color:red;"></div>
                            </div>
                            <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                            <?php if ($samegroup) { ?>
                                <div style="display: flex;justify-content:center;align-items:center;float:right;">
                                    <div style="margin-right: 10px;" class="instruction_received_loader"></div>
                                    <input type="submit" class="btn btn-primary instruction_received_submit_button"
                                        style="float:right;" <?php echo ($leads_status_current_id == 2 || $current_status_order_id >= 3) ? '' : ''; ?>>
                                </div>
                            <?php } ?>
                            <?php echo form_close(); ?>
                            
                            <?php
                        } else {
                            ?>
                            <span style="font-weight: 900;color: red;font-size: larger;">Go to the client profile, edit the
                                case, select the lenders, and save the lender information.</span>
                            <?php
                        }
                        ?>
                    </div>
                    <div role="tabpanel" class="tab-pane" id="outstanding_items"
                        style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                        <?php
                        if ($leads_status_id[2]['id'] == 3 && $leads_status_id[2]['name'] == 'Outstanding Items') {
                            $Outstanding_checklist_id = $leads_status_id[2]['id'];
                        }
                        ?>
                        <?php if ($samegroup != false): ?>
                            <h3 style="color:red;display:none;" id="secure_payout_msg">Please enter the all Secure payout expire date.</h3>
                            <div class="col-md-12">
                                <button class="btn btn-secondary" style="float: right;margin-left:10px;" id="refresh_page">
                                    <i class="fa fa-refresh" aria-hidden="true"></i>
                                </button>
                                <?php if ($samegroup) { ?>
                                    <button class="btn btn-primary" style="float: right;"
                                        id="complete_stage<?php echo $Outstanding_checklist_id; ?>" <?php echo ($leads_status_current_id == 3 || $leads_status_current_id == 7) ? '' : 'disabled'; ?>>
                                        Complete stage</button>
                                    <button class="btn btn-primary" style="float: right;margin-right:5px;"
                                        id="undo_stage<?php echo $Outstanding_checklist_id; ?>" <?php echo ($leads_status_current_id == 3 || $leads_status_current_id == 7) ? '' : 'disabled'; ?>>
                                        Undo (Appointment) stage</button>
                                <?php } ?>
                                <div class="clearfix"></div>
                                <hr class="-tw-mx-4 tw-border-neutral-200" />
                            </div>
                            <div class="col-md-12" style="">
                                <!-- 
                            outstanding item checkboxes hide
                            <div id="outstanding_item_checklist_item"></div> 
                            -->
                            </div>
                            <h3 style="color:red;text-align:center;font-weight:800;display:none;" id="oustanding_complete_stg_msg" class="oustanding_complete_stg_msg">Please upload broker fee or mark N/A to proceed. Also ensure title insurance is accounted for when compiling ledger.</h3>
                            <!-- laywer details show -->
                            <div class="col-md-12">
                                <div class="col-md-12">
                                    <div class="alert alert-info">
                                        <span class="no-margin font-medium-xs bold" style="display: flex;justify-content: center;">
                                            <bold style="font-weight:800;">Lawyer appointment notes</bold>
                                        </span>
                                    </div>
                                </div>
                                <!-- show the details in table -->
                                <div class="clearfix"></div>
                                <hr class="-tw-mx-4 tw-border-neutral-200" />
                                <table id="appointmentDetailsTable"
                                    class="table dt-table table-ticket-reports dt-inline dataTable no-footer">
                                    <thead>
                                        <tr>
                                            <th style="">Appointment Purpose Funds</th>
                                            <th style="">Appointment ID Seen</th>
                                            <th style="">Notes/Employer Name, City/Town, Job Title</th>
                                            <th style="">V/C Confirmation</th>
                                            <th style="">Action by</th>
                                            <th style="">Created At</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                                <div class="clearfix"></div>
                                <hr class="-tw-mx-4 tw-border-neutral-200" />
                            </div>
                            <?php if ($samegroup != false): ?>
                                <div class="col-md-12" style="margin-bottom:10px;">
                                    <button class="btn btn-primary" id="btn_outstanding_email_review">Review broker email</button>
                                    <button class="btn btn-primary" id="btn_outstanding_client_email_review">Review client
                                        email</button>
                                    <button class="btn btn-primary" id="btn_outstanding_client_sms_review">Custom sms
                                        chaser</button>
                                </div>
                            <?php endif; ?>
                            <!-- broker email review content -->
                            <div id="outstanding_item_email_review" style="display:none;">
                                <div class="col-md-12" style="border:1px solid;">
                                    <?php echo form_open('admin/leads/broker_outstanding_email_review/' . $lead->id, ['class' => 'mtop15 mbot15', 'id' => 'broker_outstanding_emaii_review']); ?>
                                    <div class="">
                                        <?php echo render_input('to_outstanding_broker_reviewmail', 'To', $to_broker_emails, '', ['required' => 'required']); ?>
                                        <?php echo render_input('cc_outstanding_broker_reviewmail', 'CC', $cc_group_memebers, ''); ?>
                                        <?php echo render_input('bcc_outstanding_broker_reviewmail', 'BCC', '', ''); ?>
                                    </div>
                                    <textarea name="broker_outstanding_review_email_tincymac"
                                        id="broker_outstanding_review_email_tincymac" rows="10" cols="80"
                                        style="height: 400px;"></textarea>
                                    <div style="display:flex;align-items:center;">
                                        <div style="margin-right: 10px;margin-top:-5px;" id="outstanding_broker_loader"></div>
                                        <button type="submit" class="btn btn-primary" id="outstanding_broker_submit_button"
                                            style="margin:30px 10px;">Send
                                            email to broker</button>
                                    </div>
                                    <?php echo form_close(); ?>
                                </div>
                            </div>
                            <!-- Client Email review content -->
                            <div id="outstanding_item_client_email_review" style="display:none;">
                                <div class="col-md-12" style="border: 1px solid;">
                                    <?php echo form_open('admin/leads/client_outstanding_email_review/' . $lead->id, ['class' => 'mtop15 mbot15', 'id' => 'client_outstanding_emaii_review']); ?>
                                    <div class="">
                                        <?php echo render_input('to_outstanding_client_reviewmail', 'To', $to_all_case_clients_email, '', ['required' => 'required']); ?>
                                        <?php echo render_input('cc_outstanding_client_reviewmail', 'CC', $cc_group_memebers, ''); ?>
                                        <?php echo render_input('bcc_outstanding_client_reviewmail', 'BCC', '', ''); ?>
                                    </div>
                                    <textarea name="client_outstanding_review_email_tincymac"
                                        id="client_outstanding_review_email_tincymac" rows="10" cols="80"
                                        style="height: 400px;"></textarea>
                                    <div style="display:flex;align-items:center;">
                                        <div style="margin-right: 10px;margin-top:-5px;" id="outstanding_client_loader"></div>
                                        <button type="submit" class="btn btn-primary" id="outstanding_client_submit_btn"
                                            style="margin:30px 10px;">Send
                                            email to client</button>
                                    </div>
                                    <?php echo form_close(); ?>
                                </div>
                            </div>
                            <!-- Client review sms -->
                            <div id="outstanding_item_client_sms_review" style="display:none;">
                                <div class="col-md-12">
                                    <?php echo form_open('admin/leads/client_outstanding_sms_review/' . $lead->id, ['class' => 'mtop15 mbot15', 'id' => 'client_outstanding_sms_review']); ?>
                                    <div class="textarea-container" style="width:100%;">
                                        <textarea class="limited-textarea form-control" name="outstanding_client_sms"
                                            id="outstanding_client_sms" data-word-limit="160" rows="10" cols="30"
                                            placeholder="Write something..."
                                            style="width:100%;">Hi <?php echo $get_all_lead_borrower_first_name; ?> . This is Legal Direct. To progress your transaction, please return via email or the app </textarea>
                                        <div class="word-counter">0/160 words</div>
                                    </div>
                                    <button type="submit" class="btn btn-primary" style="margin:30px 10px;">Send
                                        sms to client</button>
                                    <?php echo form_close(); ?>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <div class="col-md-12" style="margin-bottom:15px;">
                                <button class="btn btn-primary" id="outstanding_item_ld_team_form_show_button"
                                    style="margin-top:15px;">Add Item</button>
                                <!-- <button id="private_store_secure_items" class="btn btn-primary"
                                    style="margin-top:15px;margin-left:5px;">Secured private charge</button> -->
                            </div>
                            <div id="outstanding_ld_team_form" style="display:none;">
                                <div class="col-md-12">
                                    <?php echo form_open('admin/cases/add_checkboxes_for_appointment', ['style' => 'display:block;', 'class' => 'mtop15 mbot15', 'id' => 'add_custom_checkbox']); ?>
                                    <?php
                                        $imp_html = "<div class='form-group'><label for='select_type_ld_outstanding_item' class='control-label'>Select Type</label>";
                                        $imp_html .= "<select name='select_type_ld_outstanding_item' id='select_type_ld_outstanding_item' class='form-control selectpicker' data-width='100%' data-none-selected-text='Nothing selected' data-live-search='true' tabindex='-98'>";
                                        // $imp_html .= "<option value=''>Not assigned yet</option>";
                                        $imp_html .= "<option value='secure_charge'>SECURED CHARGES</option>";
                                        $imp_html .= "<option value='secure_private_charge_1'>SECURED PRIVATE CHARGE</option>";
                                        $imp_html .= "<option value='postponements'>POSTPONEMENTS</option>";
                                        $imp_html .= "<option value='app_general'>General</option>";
                                        $imp_html .= "<option value='other_items'>Other Items</option>";
                                        $imp_html .= "</select></div>";
                                        echo $imp_html;
                                    ?>
                                    <div class="form-group" app-field-wrapper="checkbox_title">
                                        <input type="hidden" name="leads_status_current_id" value="3">
                                        <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                                        <label for="checkbox_title" class="control-label"><span style="color:red;">*</span>
                                            Item title</label>
                                        <input type="text" id="checkbox_title" name="checkbox_title" class="form-control"
                                            placeholder="Please enter checkbox title">
                                        <b>
                                            <div class="invalid-feedback" id="checkbox_title_error"
                                                style="color:red;margin-top:4px;"></div>
                                        </b>
                                    </div>
                                    <div style="margin-bottom:15px;display:none;">
                                        <?php $selected = '3'; ?>
                                        <?php echo render_select('leads_status', $leads_status, ['id', ['name']], 'Select status', $selected, ['style' => 'pointer-events: none;', 'data-width' => '100%', 'required'], ['style' => 'pointer-events: none;'], 'no-mbot'); ?>
                                        <b>
                                            <div class="invalid-feedback" id="leads_status_error"
                                                style="color:red;margin-top:4px;"></div>
                                        </b>
                                    </div>
                                    <?php echo render_textarea('checkbox_description' . $checklist_id, 'Item Notes', '', array('placeholder' => 'Please enter the checkbox description')); ?>
                                    <b>
                                        <div class="invalid-feedback" id="checkbox_description_error"
                                            style="color:red;margin-top:0px;"></div>
                                    </b>
                                    <?php if ($samegroup) { ?>
                                        <div class="col-md-12"
                                            style="padding:10px;display:flex;justify-content:end;align-items:center;">
                                            <div style="margin-right: 10px;margin-top: 5px;" id="outstanding_secure_loader">
                                            </div>
                                            <button type="submit" id="outstanding_secure_btn" class="btn btn-primary"
                                                style="float:right;" <?php echo ($leads_status_current_id == 3 || $leads_status_current_id >= 3) ? '' : 'disabledd'; ?>>Save</button>
                                        </div>
                                    <?php } ?>
                                    <?php echo form_close(); ?>
                                </div>
                                <div id="checklist_template_form_ld_team_outstanding<?php echo $Outstanding_checklist_id; ?>">
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" style="width:100%;margin-left:2px;" />
                        <div class="alert alert-info" style="margin-top:40px;">
                            <span class="no-margin font-medium-xs bold"
                                style="display: flex;justify-content: center;font-weight:800;color:red;">
                                SECURED INSTRUMENTS
                            </span>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <hr class="-tw-mx-4 tw-border-neutral-200" style="width:100%;margin-left:2px;" />
                                <table class="table table-leads customizable-table number-index-2 dataTable no-footer">
                                    <div class='bulk-action-bar' style='
                                        margin-bottom: 10px;
                                        padding: 10px;
                                        border: 1px solid #ddd;
                                        background: #f9f9f9;
                                        border-radius: 5px;
                                        display: flex;
                                        justify-content: space-between;
                                        align-items: center;
                                    '>
                                        <div style="display: flex; align-items: center;">
                                            <input type='checkbox' class='select-all-checkbox' style='margin-right: 10px; transform: scale(1.3);'>
                                            <span style="font-weight: bold;">Select All</span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 10px;">
                                            <select class='form-control bulk-status-select' style='width: 200px;'>
                                                <option value=''>Select Status</option>
                                                <option value='N/A'>N/A</option>
                                                <option value='No'>No</option>
                                                <option value='Yes'>Yes</option>
                                            </select>
                                            <button class='btn btn-danger bulk-delete-btn' style=''>
                                                <i class='fa fa-trash'></i>
                                            </button>
                                        </div>
                                    </div>
                                    <thead>
                                        <th></th>
                                        <th>Type of Security</th>
                                        <th>Notes</th>
                                        <th>Received-Yes/No</th>
                                        <!-- <th>Created At</th> -->
                                        <th>Documents</th>
                                        <!-- <th>Lenders</th> -->
                                        <th>Expiry Date</th>
                                        <th style="">Action</th>
                                    </thead>
                                    <tbody id="checkbox_lists_outstanding_ld_team_payouts">
                                    </tbody>
                                </table>
                            </div>
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <div class="alert alert-info" style="margin-top:40px;">
                            <span class="no-margin font-medium-xs bold" style="display: flex;justify-content: center;font-weight:800;color:red;">
                                Client Outstanding Items
                            </span>
                        </div>
                        <div class='form-group' style="padding: 17px;display:none;" app-field-wrapper='order_no'>
                            <label for='order_no' class='control-label'>Select Checklist Template</label>
                            <!-- <select name="order_no<?php echo $Outstanding_checklist_id; ?>" -->
                            <select name="order_no3" id="order_no<?php echo $Outstanding_checklist_id; ?>"
                                class="form-control" <?php echo ($leads_status_current_id >= 3 || $leads_status_current_id == 7) ? '' : 'disabled'; ?> data-id="3">
                                <option value=''>Select Custom Checklist</option>
                                <?php
                                $uniqueIds = array();
                                foreach ($get_checklist_template_status_outstanding_id as $item) {
                                    if (!in_array($item['addedfrom'], $uniqueIds)) {
                                        $uniqueIds[] = $item['addedfrom'];
                                        echo '<option value="' . $item['addedfrom'] . '">' . get_staff_name_by_id($this, $item['addedfrom']) . '</option>';
                                    }
                                }
                                ?>
                            </select>
                        </div>
                        <?php if ($samegroup !== 2): ?>
                            <div class="col-md-12" style="margin-bottom:15px;">
                                <button class="btn btn-primary" id="outstanding_item_form_show_button"
                                    style="margin-top:15px;">Add Item</button>
                                <div class="clearfix"></div>
                                <hr class="-tw-mx-4 tw-border-neutral-200" />
                            </div>
                        <?php endif; ?>
                        <div id="outstanding_item_form_show" style="display:none;">
                            <div id="hide_checklsit_form<?php echo $Outstanding_checklist_id; ?>">
                                <?php
                                $this->load->view('admin/leads/Checklist_all_stages', ['samegroup' => $samegroup, 'checklist_id' => $Outstanding_checklist_id, 'lead_status_current_id' => $leads_status_current_id, 'checklist_item_type_data' => $checklist_item_type_data]);
                                ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <hr class="-tw-mx-4 tw-border-neutral-200" />
                                <!-- client outstanding list table -->
                                <div id="data-container<?php echo $Outstanding_checklist_id; ?>"></div>
                            </div>
                        </div>
                        <!-- Ld team checkbox and item form -->
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <div class="alert alert-info" style="margin-top:40px;">
                            <span class="no-margin font-medium-xs bold"
                                style="display: flex;justify-content: center;color:red;font-weight:800;">
                                    LD TEAM OUTSTANDING ITEMS
                            </span>
                        </div>
                        <div class="col-md-12" style="display:none;">
                            <label for='order_no_ld_team' class='control-label'>Select Checklist Template</label>
                            <select name="order_no_ld_team<?php echo $Outstanding_checklist_id; ?>"
                                id="order_no_ld_team<?php echo $Outstanding_checklist_id; ?>" class="form-control" <?php echo ($leads_status_current_id >= 3 || $leads_status_current_id == 7) ? '' : 'disabled'; ?>
                                data-id="3">
                                <option value=''>Select Custom Checklist</option>
                                <?php
                                $uniqueIds = array();
                                foreach ($get_checklist_template_status_outstanding_for_ld_team as $item) {
                                    if (!in_array($item['addedfrom'], $uniqueIds)) {
                                        $uniqueIds[] = $item['addedfrom'];
                                        echo '<option value="' . $item['addedfrom'] . '">' . get_staff_name_by_id($this, $item['addedfrom']) . '</option>';
                                    }
                                } ?>
                            </select>
                        </div>
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <!-- 
                            Outstanding ld checkboxes hide
                            <div class="col-md-12" id="outstanding_ld_team_checkboxes"></div> 
                            -->
                            <div class="clearfix"></div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" style="width:100%;margin-left:2px;" />
                            <div class="alert alert-info" style="margin-top:40px;">
                                <span class="no-margin font-medium-xs bold"
                                    style="display: flex;justify-content: center;font-weight:800;color:red;">
                                    Other Items
                                </span>
                            </div>
                            <div class="col-md-12">
                                <hr class="-tw-mx-4 tw-border-neutral-200" />
                                <table class="table table-leads customizable-table number-index-2 dataTable no-footer">
                                    <div class='bulk-action-bar' style='
                                        margin-bottom: 10px;
                                        padding: 10px;
                                        border: 1px solid #ddd;
                                        background: #f9f9f9;
                                        border-radius: 5px;
                                        display: flex;
                                        justify-content: space-between;
                                        align-items: center;
                                    '>
                                        <div style="display: flex; align-items: center;">
                                            <input type='checkbox' class='select-all-checkbox' style='margin-right: 10px; transform: scale(1.3);'>
                                            <span style="font-weight: bold;">Select All</span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 10px;">
                                            <select class='form-control bulk-status-select' style='width: 200px;'>
                                                <option value=''>Select Status</option>
                                                <option value='N/A'>N/A</option>
                                                <option value='No'>No</option>
                                                <option value='Yes'>Yes</option>
                                            </select>
                                            <button class='btn btn-danger bulk-delete-btn' style=''>
                                                <i class='fa fa-trash'></i>
                                            </button>
                                        </div>
                                    </div>
                                    <thead>
                                        <th></th>
                                        <th>Title</th>
                                        <th>Notes</th>
                                        <th>Received-Yes/No</th>
                                        <!-- <th>Created At</th> -->
                                        <th>Documents</th>
                                        <th style="">Action</th>
                                    </thead>
                                    <tbody id="checkbox_lists_outstanding_ld_team">
                                    </tbody>
                                </table>
                            </div>
                            <!-- broker deatils show in outstanding item stage -->
                            <div class="clearfix"></div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" style="width:100%;margin-left:2px;" />
                            <div class="alert alert-info" style="margin-top:40px;">
                                <span class="no-margin font-medium-xs bold"
                                    style="display: flex;justify-content: center;font-weight:800;color:red;">
                                    Broker Uploaded Documents
                                </span>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div id="data-container_broker_outstanding<?php echo $file_opened_checklist_id; ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <div role="tabpanel" class="tab-pane" id="request_for_funds"
                    style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                    <?php
                    if ($leads_status_id[3]['id'] == 4 && $leads_status_id[3]['name'] == 'Request for Funds') {
                        $Request_checklist_id = $leads_status_id[3]['id'];
                    }
                    ?>
                    <div class="col-md-12">
                        <?php if ($samegroup) { ?>
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <button class="btn btn-primary" style="float: right;"
                                id="complete_stage<?php echo $Request_checklist_id; ?>" <?php echo ($leads_status_current_id == 4 && (!empty($lead->ledger_completed) && $lead->ledger_completed == 1)) ? '' : 'disabled'; ?>>
                                Complete stage
                            </button>
                            <button class="btn btn-primary" style="float: right;margin-right:5px;"
                                id="undo_stage<?php echo $Request_checklist_id; ?>" <?php echo ($leads_status_current_id == 4 && (!empty($lead->ledger_completed) && $lead->ledger_completed == 1)) ? '' : 'disabled'; ?>>
                                Undo (Ledger stage)
                            </button>

                        <?php } ?>
                        <button class="btn btn-secondary" style="float: right;margin-right:10px;" id="refresh_page"><i
                                class="fa fa-refresh" aria-hidden="true"></i></button>
                    </div>
                    <div class='form-group' style="padding: 17px;display:none;" app-field-wrapper='order_no'>
                        <label for='order_no' class='control-label'>Select Checklist Template</label>
                        <select name="order_no<?php echo $Request_checklist_id; ?>"
                            id="order_no<?php echo $Request_checklist_id; ?>" class="form-control" <?php echo ($leads_status_current_id == 4) ? '' : 'disabled'; ?>>
                            <option value=''>Select Custom Checklist</option>
                            <?php
                            $uniqueIds = array();
                            foreach ($get_checklist_template_status_request_for_fund_id as $item) {
                                if (!in_array($item['addedfrom'], $uniqueIds)) {
                                    $uniqueIds[] = $item['addedfrom'];
                                    echo '<option value="' . $item['addedfrom'] . '">' . get_staff_name_by_id($this, $item['addedfrom']) . '</option>';
                                }
                            }
                            ?>
                        </select>
                    </div>
                    <?php if (($leads_status_current_id == 4 || $leads_status_current_id >= 4)) { ?>
                        <!-- <div id="request_for_funds_checkboxes" style="margin-left:21px;"></div> -->
                        <?php if ($samegroup != false): ?>
                            <div class="col-md-12" style="padding: 15px 0px;">
                                <button class="btn btn-primary" id="add_item_button_for_request_for_funds">Add Item</button>
                            </div>
                        <?php endif; ?>
                        <div id="checklist_template_form<?php echo $Request_checklist_id; ?>"></div>
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <?php echo form_open('admin/cases/add_checkboxes_for_appointment', ['style' => 'display:none;', 'class' => 'mtop15 mbot15', 'id' => 'add_custom_checkbox_for_request_for_funds']); ?>
                        <div class="form-group" app-field-wrapper="checkbox_title">
                            <input type="hidden" name="leads_status_current_id" value="<?php echo $leads_status_current_id; ?>">
                            <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                            <label for="checkbox_title" class="control-label"><span style="color:red;">*</span> Item
                                title</label>
                            <input type="text" id="checkbox_title" name="checkbox_title" class="form-control"
                                placeholder="Please enter checkbox title">
                            <b>
                                <div class="invalid-feedback" id="checkbox_title_error" style="color:red;margin-top:4px;">
                                </div>
                            </b>
                        </div>
                        <div style="margin-bottom:15px;display:none;">
                            <?php $selected = '4'; ?>
                            <?php echo render_select('leads_status', $leads_status, ['id', ['name']], 'Select status', $selected, ['style' => 'pointer-events: none;', 'data-width' => '100%', 'required'], ['style' => 'pointer-events: none;'], 'no-mbot'); ?>
                            <b>
                                <div class="invalid-feedback" id="leads_status_error" style="color:red;margin-top:4px;">
                                </div>
                            </b>
                        </div>
                        <?php echo render_textarea('checkbox_description' . $checklist_id, 'Item Description', '', array('placeholder' => 'Please enter the checkbox description')); ?>
                        <b>
                            <div class="invalid-feedback" id="checkbox_description_error" style="color:red;margin-top:0px;">
                            </div>
                        </b>
                        <?php if ($samegroup) { ?>
                            <div class="col-md-12" style="padding:10px;"><button type="submit" class="btn btn-primary"
                                    style="float:right;" <?php echo ($leads_status_current_id == 4 || $leads_status_current_id >= 4) ? '' : 'disabled'; ?>>Save</button></div>
                        <?php } ?>
                        <?php echo form_close(); ?>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                    <?php } ?>

                    <!-- <hr class="-tw-mx-4 tw-border-neutral-200" /> -->
                    <div id="hide_checklsit_form<?php echo $Request_checklist_id; ?>">
                        <?php
                        /* $this->load->view('admin/leads/Checklist_all_stages', ['checklist_id' => $Request_checklist_id, 'lead_status_current_id' => $leads_status_current_id]); */
                        ?>
                    </div>

                    <!-- view of all checklist -->
                    <div role="tabpanel" class="tab-pane" id="">
                        <?php if (($leads_status_current_id == 4 || $leads_status_current_id >= 4)) { ?>
                            <div class="row">
                                <div class="col-md-12">
                                    <hr class="-tw-mx-4 tw-border-neutral-200" />
                                    <table class="table table-leads customizable-table number-index-2 dataTable no-footer">
                                        <div class='bulk-action-bar' style='
                                            margin-bottom: 10px;
                                            padding: 10px;
                                            border: 1px solid #ddd;
                                            background: #f9f9f9;
                                            border-radius: 5px;
                                            display: flex;
                                            justify-content: space-between;
                                            align-items: center;
                                        '>
                                            <div style="display: flex; align-items: center;">
                                                <input type='checkbox' class='select-all-checkbox' style='margin-right: 10px; transform: scale(1.3);'>
                                                <span style="font-weight: bold;">Select All</span>
                                            </div>
                                            <div style="display: flex; align-items: center; gap: 10px;">
                                                <button class='btn btn-danger bulk-delete-btn' style=''>
                                                    <i class='fa fa-trash'></i>
                                                </button>
                                            </div>
                                        </div>
                                        <thead>
                                            <th></th>
                                            <th>Title</th>
                                            <th>Upload button</th>
                                            <th>Action date</th>
                                            <th>Comments</th>
                                            <th>Documents</th>
                                            <th style="">Action</th>
                                        </thead>
                                        <tbody id="checkbox_lists_request_funds">
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <!-- request for funds emails activity logs details -->
                            <div class="col-md-12">
                                <div class="alert alert-info" style="margin-top:40px;">
                                    <span class="no-margin font-medium-xs bold"
                                        style="display: flex;justify-content: center;font-weight:800;">
                                        Activity Of Funds Emails
                                    </span>
                                </div>
                                <table class="table table-bordered" id="fundsActivityTable">
                                    <thead>
                                        <tr>
                                            <th>Sent By</th>
                                            <th style="overflow-y: scroll; max-height: 250px; width:400px;">Description</th>
                                            <th>Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        <?php } ?>
                        <!-- attachemnt are shown -->
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                    </div>
                </div>
                <!-- ledgers tab content -->
                <div role="tabpanel" class="tab-pane" id="ledger"
                    style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                    <div class="col-md-12">
                        <?php if ($samegroup) { ?>
                            <button class="btn btn-primary" style="float: right;" id="complete_stage_ledger" <?php echo ($ledger_completed_stage == 1) ? 'disabled' : ''; ?>>
                                Complete stage
                            </button>
                            <button class="btn btn-primary" style="float: right;margin-right:5px;" id="undo_stage_ledger" <?php echo ($ledger_completed_stage == 1) ? 'disabled' : ''; ?>>
                                Undo (Outstanding Item) stage
                            </button>

                        <?php } ?>
                    </div>
                    <div class="clearfix"></div>
                    <hr class="-tw-mx-4 tw-border-neutral-200" />
                    <h3 style="color:red;text-align:center;font-weight:800;display:none;" id="oustanding_complete_stg_msg_in_ledger" class="oustanding_complete_stg_msg_in_ledger">Please upload broker fee or mark N/A to proceed. Also ensure title insurance is accounted for when compiling ledger.</h3>
                    <div class="clearfix"></div>
                    <div class="col-md-12" id="">
                        <p style="font-weight:800; text-align:center; color:red;">
                            If client needed to sign off ledgers please ensure that was done before proceeding.
                        </p>
                    </div>
                    <hr class="-tw-mx-4 tw-border-neutral-200" />
                    <?php if ($samegroup != false): ?>
                        <div class="col-md-12">
                            <button class="btn btn-primary" id="add_ledgers" style=" margin-bottom:15px;">
                                <!-- style of button background-color: #007bff;margin-bottom:15px; color: white; border: none; padding: 5px 10px; cursor: pointer; -->
                                Send ledgers to BB for approval
                            </button>
                            <button class="btn btn-primary" id="send_ledger_number_ledgers_to_broker"
                                style="margin-bottom:15px;">
                                Send Approved ledgers and attachment to broker.
                            </button>
                        </div>
                        <!-- ledger drag and drop section  -->
                        <div class="col-md-12" style="display: flex; justify-content: center; align-items: center; min-height: 300px;">
                            <?php echo form_open('admin/leads/upload_doc_for_ledger', [
                                'class' => 'mtop15 mbot15',
                                'id' => 'ledger_upload_form_dragdrop',
                                'enctype' => 'multipart/form-data',
                                'style' => 'width: 100%; max-width: 600px; display: flex; flex-direction: column; align-items: center;'
                            ]); ?>

                            <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">

                            <div style="width: 100%;">
                                <?php echo render_textarea('ledger_comment', 'File Comment', '', [
                                    'placeholder' => 'Please enter any comment.',
                                    'style' => 'width: 100%;'
                                ]); ?>
                            </div>

                            <div class="drop-area" id="dropAreaLedger" data-task-id="123"
                                style="margin-top: 10px; padding: 20px; border: 2px dashed #ccc; width: 100%; text-align: center; cursor: pointer;">
                                Drag & Drop or Click to Upload
                            </div>

                            <div id="ledger_file_preview" style="margin-top: 10px; width: 100%;"></div>

                            <input type="file" id="ledger_dropzone" name="ledger_userfile[]" multiple style="display: none;" accept="image/*">

                            <button type="submit" class="btn btn-primary" style="margin-top: 15px;">Submit</button>

                            <?php echo form_close(); ?>
                        </div>

                    <?php endif; ?>
                    <div style="padding-bottom:300px;">
                        <table style="width: 100%; border-collapse: collapse;">
                            <thead>
                                <tr style="background-color: #f2f2f2;">
                                    <th style="padding: 10px; border: 1px solid #ddd;">Files</th>
                                    <th style="padding: 10px; border: 1px solid #ddd;">Status</th>
                                    <th style="padding: 10px; border: 1px solid #ddd;">Comments</th>
                                    <!-- <th style="padding: 10px; border: 1px solid #ddd;">Notes</th> -->
                                    <?php if (is_admin()): ?>
                                        <th style="padding: 10px; border: 1px solid #ddd;">Change Status</th>
                                    <?php endif; ?>
                                    <!-- <?php if (!is_admin()): ?>
                                        <?php endif; ?> -->
                                </tr>
                            </thead>
                            <tbody id="ledger_table_body">
                                <!-- Rows will be appended here by JavaScript -->
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- closed stage -->
                    <?php if ($leads_status_id[4]['id'] == 5 && $leads_status_id[4]['name'] == 'Closing') {
                        $closed_checklist_id = $leads_status_id[4]['id'];
                    } ?>
                    <div role="tabpanel" class="tab-pane" id="Closed"
                        style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                        <div class="col-md-12">
                            <button class="btn btn-primary closed_complete_stage" style="float: right; margin-left:10px;" <?php echo ($leads_status_current_id == 5 && $active_case == 'Active') ? '' : 'disabled'; ?>>
                                Complete stage
                            </button>
                            <button class="btn btn-primary" style="float: right; margin-left:10px;<?php echo ($samegroup === false) ? 'display:none;' : ''; ?>"
                                id="undo_stage<?php echo $closed_checklist_id; ?>" <?php echo ($leads_status_current_id == 5) ? '' : 'disabled'; ?>
                            > Undo (Request for funds) stage</button>
                        </div>
                        <!-- close stage message -->
                        <div class="col-md-12" id="close_stage_msg" style="<?php echo ($final_close_count > 0) ? 'display:none;' : ''; ?>">
                            <span style="display:flex;justify-content:center;align-items:center;color:red;font-weight:800;">
                                Don’t forget to send final report and lender and set LRO docket to inactive
                            </span>
                        </div>

                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <!-- request for funds emails activity logs details -->
                        <div class="alert alert-info" style="margin-top:40px;">
                            <span class="no-margin font-medium-xs bold"
                                style="display: flex;justify-content: center;font-weight:800;">
                                Activity Of Closed Emails
                            </span>
                        </div>
                        <table class="table table-bordered" id="closedActivityTable">
                            <thead>
                                <tr>
                                    <th>Sent By</th>
                                    <th style="overflow-y: scroll; max-height: 250px; width:400px;">Description</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                        <!-- show the request for funds last two items -->
                        <div class="clearfix"></div>
                        <div class="alert alert-info" style="margin-top:40px;">
                            <span class="no-margin font-medium-xs bold"
                                style="display: flex;justify-content: center;font-weight:800;">
                                REPORTS
                            </span>
                        </div>
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <table id="rff_last_two_items" class="table table-striped table-bordered" style="width:100%;">
                            <div class='bulk-action-bar' style='
                                margin-bottom: 10px;
                                padding: 10px;
                                border: 1px solid #ddd;
                                background: #f9f9f9;
                                border-radius: 5px;
                                display: flex;
                                justify-content: space-between;
                                align-items: center;
                            '>
                                <div style="display: flex; align-items: center;">
                                    <input type='checkbox' class='select-all-checkbox' style='margin-right: 10px; transform: scale(1.3);'>
                                    <span style="font-weight: bold;">Select All</span>
                                </div>
                                <div style="display: flex; align-items: center; gap: 10px;">
                                    <button class='btn btn-danger bulk-delete-btn' style=''>
                                        <i class='fa fa-trash'></i>
                                    </button>
                                </div>
                            </div>
                            <thead>
                                <tr>
                                    <th></th>
                                    <th style="">Title</th>
                                    <th style="">Upload button</th>
                                    <th style="">Action date</th>
                                    <th style="">Comment</th>
                                    <th style="">Documents</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Data will be populated here via AJAX -->
                            </tbody>
                        </table>
                        <!-- upload doc for case closed -->
                        <?php if ($samegroup !== 2 && $samegroup) { ?>
                            <div class="clearfix"></div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <div class="alert alert-info" style="margin-top:40px;">
                                <span class="no-margin font-medium-xs bold"
                                    style="display: flex;justify-content: center;font-weight:800;">
                                    Final Closing Ledgers
                                </span>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-12">
                                <button class="btn btn-primary" id="bb_approve_closing_day_ledger">BB to approve closing 
                                    day ledgers</button>
                                <?php if(is_admin()){?>
                                    <button class="btn btn-primary" id="bb_response_to_closing_day_ledger">BB Response to closing day ledgers</button>
                                <?php }?>
                            </div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <div class="col-md-12">
                                <button class="btn btn-primary" id="send_final_close_ledger">Send final ledgers/attachments/wire
                                    confirmation to BB</button>
                                <button class="btn btn-primary" id="bb_response_final_close_ledger">BB response to final
                                    ledgers</button>
                                <button class="btn btn-primary" id="final_closeing_ledger">confirm final closing internally/
                                    Archive</button>
                                <button class="btn btn-primary" id="move_to_archive">Move to Archive</button>
                            </div>
                            <!-- final ledgers table  -->
                            <div class="clearfix"></div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <div class="col-md-12" style="margin-top:15px;">
                                <table style="width: 100%; border-collapse: collapse;">
                                    <thead>
                                        <tr style="background-color: #f2f2f2;">
                                            <th style="padding: 10px; border: 1px solid #ddd;">Files</th>
                                            <th style="padding: 10px; border: 1px solid #ddd;">Status</th>
                                            <th style="padding: 10px; border: 1px solid #ddd;">Comments</th>
                                            <!-- <th style="padding: 10px; border: 1px solid #ddd;">Notes</th> -->
                                        </tr>
                                    </thead>
                                    <tbody id="final_ledger_table_body">
                                        <!-- Rows will be appended here by JavaScript -->
                                    </tbody>
                                </table>
                            </div>
                            <div class="clearfix"></div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <div class="alert alert-info" style="margin-top:40px;">
                                <span class="no-margin font-medium-xs bold"
                                    style="display: flex;justify-content: center;font-weight:800;">
                                    Broker Post Closing Uploads Details
                                </span>
                            </div>
                            <div class="col-md-12">
                                <?php echo form_open('admin/leads/upload_doc_for_case_closed/' . $lead->id, ['class' => 'mtop15 mbot15', 'id' => 'upload_doc_for_case_closed']); ?>
                                <p id="show_text_to_broker" style="font-weight:800;"></p>
                                <?php echo render_textarea('case_closed_notes', 'Post completion/ Holdback notes', '', array('placeholder' => 'Please enter the any notes.')); ?>
                                <div class="form-group">
                                    <label for="case_closed_userfile" id="case_closed_title" class="control-label">Select
                                        Files (PDF, JPEG, JPG, PNG, DOC, DOCX, XLS, XLSX)</label>
                                    <input type="file" class="form-control" name="case_closed_userfile[]" id="case_closed_userfile"
                                        multiple accept=".pdf, .jpeg, .jpg, .png, .doc, .docx, .xls, .xlsx" style="height:53px;">
                                    <div id="case_closed_error" class="error-message" style="color:red;"></div>
                                </div>
                                <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                                <div style="display: flex;justify-content: end;align-items: center;margin-bottom: 20px;"
                                    class="col-md-12">
                                    <div style="margin-right: 10px;margin-top:-5px;" id="case_closed_doc_loader"></div>
                                    <input type="submit" class="btn btn-primary" id="case_closed_doc_submit_button"
                                        style="float:right;margin-bottom: 10px;">
                                </div>
                                <?php echo form_close(); ?>
                            </div>
                            <!-- fetch the all record and check live -->
                            <div class="clearfix"></div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <table id="caseClosedDataTable" class="table table-striped table-bordered" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>File</th>
                                        <th>Reason</th>
                                        <th>Date Added</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        <?php } ?>
                        <!-- show the shoot info holdback details -->
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <div class="alert alert-info" style="margin-top:40px;">
                            <span class="no-margin font-medium-xs bold"
                                style="display: flex;justify-content: center;font-weight:800;">
                                Holdback Details
                            </span>
                        </div>
                        <div class="col-md-12">
                            <button class="btn btn-primary" id="holdback_details_form_show"
                                style="display:none;margin-bottom:15px;">Resolve Holdback</button>
                        </div>
                        <div class="col-md-12" id="add_holdback_details_form" style="display:none;margin-bottom:15px;">
                            <?php echo form_open('admin/leads/add_holdback_details', ['class' => 'mtop15 mbot15', 'id' => 'add_holdback_details']); ?>
                            <?php echo render_textarea('hold_back_details_comments', ' <b style="font-weight: 800;">Comments</b>', ''); ?>
                            <div class="form-group">
                                <label for="hold_back_details_file" class="control-label"><span style="color:red;">*</span> <b
                                        style="font-weight: 800;">Select Files (PDF, JPEG, JPG, PNG, DOC, DOCX, XLS,
                                        XLSX)</b></label>
                                <input type="file" class="form-control" name="hold_back_details_file[]"
                                    id="hold_back_details_file" multiple
                                    accept=".pdf, .jpeg, .jpg, .png, .doc, .docx, .xls, .xlsx" style="height:53px;">
                                <div id="hold_back_details_file_error" class="error-message" style="color:red;"></div>
                            </div>
                            <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                            <?php if ($samegroup) { ?>
                                <div style="display: flex;justify-content:center;align-items:center;float:right;">
                                    <div style="margin-right: 10px;" class="hold_back_details_loader"></div>
                                    <input type="submit" class="btn btn-primary" id="hold_back_details_submit_btn"
                                        style="float:right;">
                                </div>
                            <?php } ?>
                            <?php echo form_close(); ?>
                        </div>
                        <table id="holdback_table_details" class="table table-striped table-bordered" style="width:100%;">
                            <thead>
                                <tr>
                                    <th style="">Name</th>
                                    <th style="">Email Content</th>
                                    <th style="">Files</th>
                                    <th style="">Created at</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Data will be populated here via AJAX -->
                            </tbody>
                        </table>
                    </div>
                <!-- on hold stage -->
                <?php if ($samegroup) { ?>
                    <?php if ($leads_status_id[5]['id'] == 6 && $leads_status_id[5]['name'] == 'On Hold') {
                        $on_hold_checklist_id = $leads_status_id[5]['id'];
                    } ?>
                    <div role="tabpanel" class="tab-pane" id="on_hold"
                        style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                        <div class="col-md-12">
                            <button class="btn btn-primary" style="float: right;"
                                id="undo_stage<?php echo $on_hold_checklist_id; ?>" <?php echo ($leads_status_current_id == 6) ? '' : 'disabled'; ?>>
                                Undo Hold
                            </button>
                        </div>
                        <form id="hold-case-form">
                            <div class="form-group">
                                <label for="holdReason" class="control-label">Please Enter Hold Case Reason:</label>
                                <textarea class="form-control" id="holdReason" name="holdReason"
                                    placeholder="Please enter the reason for moving the case on hold" rows="4"></textarea>
                                <span id="error-message" style="color: red; display: none;"></span>
                            </div>
                            <button type="submit" class="btn btn-primary" style="float:right;">Submit</button>
                        </form>
                    </div>
                <?php } ?>

                <div role="tabpanel" class="tab-pane" id="tab_proposals_leads">
                    <?php if (has_permission('proposals', '', 'create')) { ?>
                        <a href="<?php echo admin_url('proposals/proposal?rel_type=lead&rel_id=' . $lead->id); ?>"
                            class="btn btn-primary mbot25">
                            <?php echo _l('new_proposal'); ?>
                        </a>
                    <?php } ?>
                    <?php if (total_rows(db_prefix() . 'proposals', ['rel_type' => 'lead', 'rel_id' => $lead->id]) > 0 && (has_permission('proposals', '', 'create') || has_permission('proposals', '', 'edit'))) { ?>
                        <a href="#" class="btn btn-primary mbot25" data-toggle="modal" data-target="#sync_data_proposal_data">
                            <?php echo _l('sync_data'); ?>
                        </a>
                        <?php $this->load->view('admin/proposals/sync_data', ['related' => $lead, 'rel_id' => $lead->id, 'rel_type' => 'lead']); ?>
                    <?php } ?>
                    <?php
                    $table_data = [
                        _l('proposal') . ' #',
                        _l('proposal_subject'),
                        _l('proposal_total'),
                        _l('proposal_date'),
                        _l('proposal_open_till'),
                        _l('tags'),
                        _l('proposal_date_created'),
                        _l('proposal_status'),
                    ];
                    $custom_fields = get_custom_fields('proposal', ['show_on_table' => 1]);
                    foreach ($custom_fields as $field) {
                        array_push($table_data, [
                            'name' => $field['name'],
                            'th_attrs' => ['data-type' => $field['type'], 'data-custom-field' => 1],
                        ]);
                    }
                    $table_data = hooks()->apply_filters('proposals_relation_table_columns', $table_data);
                    render_datatable($table_data, 'proposals-lead', [], [
                        'data-last-order-identifier' => 'proposals-relation',
                        'data-default-order' => get_table_last_order('proposals-relation'),
                    ]);
                    ?>
                </div>
                <div role="tabpanel" class="tab-pane" id="tab_tasks_leads">
                    <?php init_relation_tasks_table(['data-new-rel-id' => $lead->id, 'data-new-rel-type' => 'lead']); ?>
                </div>

                <div role="tabpanel" class="tab-pane" id="lead_reminders">
                    <?php
                    if ($leads_status_id[6]['id'] == 7 && $leads_status_id[6]['name'] == 'Appointment Stage') {
                        $appointment_request = $leads_status_id[6]['id'];
                    }
                    ?>
                    <?php if ($samegroup) { ?>
                        <?php
                        $style = ($leads_status_current_id == 7 || $current_status_order_id >= 4) ? 'margin-bottom:15px;' : 'pointer-events: none;margin-bottom:15px;';
                        ?>
                        <div class="col-md-12" style="display:flex;justify-content:end;align-items:center;">
                            <div class="" style="display:flex;justify-content:space-between;align-items:center;">
                                <button class="btn btn-secondary" style="margin-right:10px;" id="refresh_page"><i
                                        class="fa fa-refresh" aria-hidden="true"></i></button>
                                <button class="btn btn-primary" style="float: right; margin-right:10px;"
                                    id="complete_stage<?php echo $appointment_request; ?>" <?php echo ($leads_status_current_id == 7) ? '' : 'disabled'; ?>>
                                    Complete stage
                                </button>
                                <button class="btn btn-primary" style="float: right;margin-right:5px;"
                                    id="undo_stage<?php echo $appointment_request; ?>" <?php echo ($leads_status_current_id == 7) ? '' : 'disabled'; ?>>
                                    Undo (Instruction Received) Stage
                                </button>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <?php if ($lender_appt_confirmation_email_status === false): ?>
                            <div class="col-md-12" id="confirm_lender_apt_email_reminder">
                                <p style="font-weight:800; text-align:center; color:red;">
                                    Lender lawyer updated by email on appointment request
                                </p>
                            </div>
                        <?php endif; ?>
                    <?php } ?>
                    <!-- madentory checklist iem for appointment and outstanding item review mail appened code -->
                    <ul id="appointment_outstanding_item_checklist_for_email_review" style="display:none;"></ul>
                    <?php if (($leads_status_current_id == 7 || $current_status_order_id >= 4)) { ?>
                        <div class="col-md-12">
                            <div style="margin-top:10px;">
                                <?php render_datatable(['Special notes for meeting', 'Appointment request sent on', 'Appointment set by', 'Location'], 'reminders-leads'); ?>
                            </div>
                            <div class="clearfix"></div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <div class="row">
                                <?php if ($samegroup != false): ?>
                                    <a href="#" data-toggle="modal" class="btn btn-default"
                                        data-target=".reminder-modal-lead-<?php echo $lead->id; ?>" style="<?php echo $style; ?>"><i
                                            class="fa-regular fa-bell"></i>
                                        <?php echo 'Set Case Appointment'; ?>
                                    </a>
                                    <button class="btn btn-primary" id="confirmation_appointment_to_broker"
                                        style="margin-bottom:15px;">Confirmation of appointment to broker</button>
                                    <button class="btn btn-primary" id="confirmation_appointment_to_lender"
                                        style="margin-bottom:15px;">Confirm app set to new lender’s lawyer</button>
                                    <button class="btn btn-primary" style="margin-bottom: 15px;"
                                        id="show_appointment_details" <?php echo ($leads_status_current_id == 7) ? '' : 'disabled'; ?>>
                                        Complete post appointment stage/ Lawyer notes
                                    </button>
                                    <button class="btn btn-primary" id="btn_appointment_email_review" style="margin-bottom:15px;">Post appointment email to
                                        broker</button>
                                    <button class="btn btn-primary" style="margin-top:10px;margin-right:5px;" id="btn_client_appointment_email_review">Post appointment email
                                        to client</button>
                                    <button class="btn btn-primary" style="margin-right:5px;margin-top:10px;" id="ds_doc_approved">
                                        DS Good
                                    </button>
                                <?php endif; ?>
                            </div>
                            <!-- start -->
                            <?php if ($samegroup != false): ?>
                                <div class="col-md-12">
                                    <!-- reconfirm appointment email send to the broker -->
                                    <?php echo form_open('admin/leads/broker_appointment_review_email_send/' . $lead->id, ['class' => 'mtop15 mbot15', 'id' => 'broker_appointment_emailForm', 'style' => 'display:none;border:1px solid;padding:20px;']); ?>
                                        <div class="">
                                            <?php echo render_input('to_broker_appointment_reviewmail', 'To', $to_broker_emails, '', ['required' => 'required']); ?>
                                            <?php echo render_input('cc_broker_appointment_reviewmail', 'CC', $cc_group_memebers, ''); ?>
                                            <?php
                                            if(!empty($hosper_lender_count)){
                                                if(base_url() == 'https://platform.legaldirect.ca/'){
                                                    $bcc_emails = 'instructing@hospermortgage.com';
                                                }else{
                                                    $bcc_emails = 'ra.faheem7@gmail.com';
                                                }
                                            }
                                            ?>
                                            <?php echo render_input('bcc_broker_appointment_reviewmail', 'BCC', $bcc_emails, ''); ?>
                                        </div>
                                        <textarea name="appointment_confirm_broker_emailContent"
                                            id="appointment_confirm_broker_emailContent" rows="10" cols="80"
                                            style="height: 400px;"></textarea>
                                        <div style="display:flex;align-items:center;">
                                            <div style="margin-right: 10px;margin-top:-5px;" id="appt_broker_loader"></div>
                                            <button type="submit" class="btn btn-primary" id="appt_broker_submit_button"
                                                style="margin:30px 10px;">Send email to
                                                broker</button>
                                        </div>
                                    <?php echo form_close(); ?>
                                    <?php echo form_open('admin/leads/lender_appointment_review_email_send/' . $lead->id, ['class' => 'mtop15 mbot15', 'id' => 'lender_appointment_emailForm', 'style' => 'display:none;border:1px solid;padding:20px;']); ?>
                                        <div class="">
                                            <?php echo render_input('to_lender_appointment_reviewmail', 'To', $to_broker_emails, '', ['required' => 'required']); ?>
                                            <?php echo render_input('cc_lender_appointment_reviewmail', 'CC', $cc_group_memebers, ''); ?>
                                            <?php
                                            if(!empty($hosper_lender_count)){
                                                if(base_url() == 'https://platform.legaldirect.ca/'){
                                                    $bcc_emails = 'deals@hospermortgage.com';
                                                }else{
                                                    $bcc_emails = 'ra.faheem7@gmail.com';
                                                }
                                            }
                                            ?>
                                            <?php echo render_input('bcc_lender_appointment_reviewmail', 'BCC', $bcc_emails, ''); ?>
                                        </div>
                                        <textarea name="appointment_confirm_lender_emailContent"
                                            id="appointment_confirm_lender_emailContent" rows="10" cols="80"
                                            style="height: 400px;"></textarea>
                                        <div style="display:flex;align-items:center;">
                                            <div style="margin-right: 10px;margin-top:-5px;" id="appt_lender_loader"></div>
                                            <button type="submit" class="btn btn-primary" id="appt_lender_submit_button"
                                                style="margin:30px 10px;">Send email to
                                                broker</button>
                                        </div>
                                    <?php echo form_close(); ?>
                                     <!-- before appointment work -->
                                    <div id="appointment_email_review" style="margin-top:15px;display:none;border:1px solid;" class="col-md-12">
                                        <!-- Tincymce appointment stage content -->
                                        <div class="col-md-12" style="border:1px solid;padding:20px;">
                                            <?php echo form_open('admin/leads/appointment_review_broker_email/' . $lead->id, ['class' => 'mtop15 mbot15', 'id' => 'AppointmentBrokereviewMail']); ?>
                                            <div class="">
                                                <?php echo render_input('to_appointment_broker_reviewmail', 'To', $to_broker_emails, '', ['required' => 'required']); ?>
                                                <?php echo render_input('cc_appointment_broker_reviewmail', 'CC', $cc_group_memebers, ''); ?>
                                                <?php echo render_input('bcc_appointment_broker_reviewmail', 'BCC', '', ''); ?>
                                            </div>
                                            <textarea name="appointment_broker_email_review_tincymac"
                                                id="appointment_broker_email_review_tincymac" rows="10" cols="80"
                                                style="height: 400px;"></textarea>
                                            <div style="display:flex;align-items:center;">
                                                <div style="margin-right: 10px;margin-top:-5px;" id="post_appt_broker_loader"></div>
                                                <button type="submit" class="btn btn-primary" id="post_appt_broker_submit_button"
                                                    style="margin:30px 10px;">Send email to
                                                    broker</button>
                                            </div>
                                            <?php echo form_close(); ?>
                                        </div>
                                    </div>
                                    <div id="after_appointment_email_div" style="margin-top:15px;display:none;border:1px solid;padding:20px;" class="col-md-12">
                                        <?php echo form_open('admin/leads/after_appointment_email_send_to_client/' . $lead->id, ['class' => 'mtop15 mbot15', 'id' => 'after_appointment_email_send_to_client']); ?>
                                            <div class="">
                                                <?php echo render_input('to_after_appointment_reviewmail', 'To', $to_all_case_clients_email, '', ['required' => 'required']); ?>
                                                <?php echo render_input('cc_after_appointment_reviewmail', 'CC', $cc_group_memebers, ''); ?>
                                                <?php echo render_input('bcc_after_appointment_reviewmail', 'BCC', '', ''); ?>
                                            </div>
                                            <textarea name="after_appointment_emailContent"
                                                id="after_appointment_emailContent" rows="10" cols="80"
                                                style="height: 400px;"></textarea>
                                            <div style="display:flex;align-items:center;">
                                                <div style="margin-right: 10px;margin-top:-5px;" id="after_appointment_email_loader"></div>
                                                <button type="submit" class="btn btn-primary" id="after_appointment_email_submit_btn"
                                                    style="margin:30px 10px;">Send email to
                                                    client</button>
                                            </div>
                                        <?php echo form_close(); ?>
                                    </div>
                                </div>
                                <!-- after appointment email to client -->
                                <div class="col-md-12" id="client_appointment_email_review"
                                    style="border:1px solid;margin-top: 15px; <?php echo ($reminder_count_check > 0 && $lead->app_email_requested == 0) ? '' : 'display:none;border:1px solid;padding:20px;'; ?>">
                                    <div class="clearfix"></div>
                                    <hr class="-tw-mx-4 tw-border-neutral-200" />
                                    <?php echo form_open('admin/leads/client_appointment_review_email_send/' . $lead->id, ['class' => 'mtop15 mbot15', 'id' => 'emailForm']); ?>
                                    <div class="">
                                        <?php echo render_input('to_client_appointment_reviewmail', 'To', $to_all_case_clients_email, '', ['required' => 'required']); ?>
                                        <?php echo render_input('cc_client_appointment_reviewmail', 'CC', $cc_group_memebers, ''); ?>
                                        <?php echo render_input('bcc_client_appointment_reviewmail', 'BCC', '', ''); ?>
                                    </div>
                                    <textarea name="appointment_client_emailContent" id="appointment_client_emailContent" rows="10"
                                        cols="80" style="height: 400px;"></textarea>
                                    <div style="display:flex;align-items:center;">
                                        <div style="margin-right: 10px;margin-top:-5px;" id="appt_client_loader"></div>
                                        <button type="submit" class="btn btn-success" id="appt_client_submit_button"
                                            style="margin:30px 10px;"><i class="fa fa-paper-plane me-1"></i> Send email to
                                            client</button>
                                        <button type="button" class="btn btn-primary" id="appt_client_draft_email_btn" style="margin:30px 10px;">
                                            Save as Draft
                                        </button>
                                    </div>
                                    <?php echo form_close(); ?>
                                </div>

                                <div class="clearfix"></div>
                                <hr class="-tw-mx-4 tw-border-neutral-200" />
                                <div class="col-md-12" style="margin-bottom:15px;">
                                    <button class="btn btn-primary" id="outstanding_item_form_show_button_for_appointment"
                                        style="margin-top:15px;">Add Item</button>
                                </div>
                            <?php endif; ?>
                            <div id="hide_checklsit_form_for_appointment3" style="display:none;">
                                <?php
                                $this->load->view('admin/leads/checklist_for_outstanding_list_in_appointment', ['checklist_id' => 3, 'lead_status_current_id' => 3, 'checklist_item_type_data' => '']);
                                ?>
                            </div>
                            <div class="clearfix"></div>
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <!-- appened the outstanding table data -->
                            <div id="appointment-data-container"></div>
                        </div>
                        <!-- Add the items details  -->
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />

                        <div class="col-md-12" id="show_post_appointment_checkboxes" style="display: none;"></div>
                        <div class="clearfix"></div>
                        <div class="col-md-12" style="padding: 27px 0px">
                            <button class="btn btn-primary" id="add_item_button_post_appointment" style="display: none;">Add
                                Item</button>
                        </div>
                       
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <?php echo form_open('admin/leads/add_checkboxes_for_appointment', ['style' => 'display: none;', 'class' => 'mtop15 mbot15', 'id' => 'add_custom_checkbox_for_appointment']); ?>
                        <div class="form-group" app-field-wrapper="checkbox_title">
                            <input type="hidden" name="leads_status_current_id" value="<?php echo $leads_status_current_id; ?>">
                            <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                            <label for="checkbox_title" class="control-label"><span style="color:red;">*</span>
                                Post-appointment title</label>
                            <input type="text" id="checkbox_title" name="checkbox_title" class="form-control"
                                placeholder="Please enter post-appointment title">
                            <b>
                                <div class="invalid-feedback" id="checkbox_title_error" style="color:red;margin-top:0px;">
                                </div>
                            </b>
                        </div>
                        <?php echo render_textarea('checkbox_description' . $checklist_id, 'Post-appointment Description', '', array('placeholder' => 'Please enter the post-appointment description')); ?>
                        <b>
                            <div class="invalid-feedback" id="checkbox_description_error" style="color:red;margin-top:4px;">
                            </div>
                        </b>
                        <div class="col-md-12" style="padding:10px;display:flex;justify-content:end;align-items:center;">
                            <div style="margin-right: 10px;margin-top:5px;" id="outstanding_secure_loader"></div>
                            <button type="submit" class="btn btn-primary" style="float:right;">Save</button>
                        </div>
                        <?php echo form_close(); ?>
                    <?php } ?>
                    <!-- <div id="checkbox_data" style="display: none;">
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <div class="col-md-12">
                            <table class="table table-leads customizable-table number-index-2 dataTable no-footer">
                                <thead>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th style="">Action</th>
                                </thead>
                                <tbody id="checkbox_lists_for_appointment">
                                </tbody>
                            </table>
                        </div>
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                    </div> -->
                    <hr />
                    <!-- add the appointment tables details -->
                    <div class="clearfix"></div>
                    <hr class="-tw-mx-4 tw-border-neutral-200" />
                    <div class="col-md-12">
                        <div class="alert alert-info">
                            <span class="no-margin font-medium-xs bold" style="display: flex;justify-content: center;">
                                <bold style="font-weight:800;">Lawyer appointment notes</bold>
                            </span>
                        </div>
                    </div>
                    <div class="col-md-12" id="appointment_form_show" style="display:none;">
                        <?php echo form_open('admin/leads/add_appointment_details/' . $lead->id, ['class' => 'mtop15 mbot15', 'id' => 'add_appointment_details']); ?>
                        <?php echo render_textarea('appointment_purpose_funds', 'Purpose of funds', '', array('placeholder' => 'Please enter the Purpose of funds.', 'required' => 'required')); ?>
                        <?php echo render_textarea('appointment_id_seen', 'ID’s seen', '', array('placeholder' => 'Please enter the ID’s seen.', 'required' => 'required')); ?>
                        <?php echo render_textarea('appointment_notes', 'Notes/Employer Name, City/Town, Job Title', '', array('placeholder' => 'Please enter the any other notes.', 'required' => 'required')); ?>
                        <?php echo render_textarea('vc_confirmation', 'V/C Confirmation', '', array('placeholder' => 'V/C(s) confirmed with lender ABC with account number ending 123.', 'required' => 'required')); ?>
                        <div class="col-md-12" style="display:flex;justify-content:end;align-items:center;">
                            <div style="margin-right: 10px;margin-top:-5px;" id="appointment_details_loader"></div>
                            <button type="submit" class="btn btn-primary" style="margin:30px 10px;float:inline-end;"
                                id="appointment_details_btn">Submit</button>
                        </div>
                        <?php echo form_close(); ?>
                    </div>
                    <!-- show the details in table -->
                    <div class="clearfix"></div>
                    <hr class="-tw-mx-4 tw-border-neutral-200" />
                    <table id="appointmentDetailsTable"
                        class="table dt-table table-ticket-reports dt-inline dataTable no-footer">
                        <thead>
                            <tr>
                                <th style="">Appointment Purpose Funds</th>
                                <th style="">Appointment ID Seen</th>
                                <th style="">Notes/Employer Name, City/Town, Job Title</th>
                                <th style="">V/C Confirmation</th>
                                <th style="">Action by</th>
                                <th style="">Created At</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
                <div role="tabpanel" class="tab-pane" id="attachments" style="display:none;">
                    <?php echo form_open('admin/leads/add_lead_attachment', ['class' => 'dropzone mtop15 mbot15', 'id' => 'lead-attachment-upload']); ?>
                    <?php echo form_close(); ?>
                    <?php if (get_option('dropbox_app_key') != '') { ?>
                        <hr />
                        <div class=" pull-left">
                            <?php if (count($lead->attachments) > 0) { ?>
                                <a href="<?php echo admin_url('leads/download_files/' . $lead->id); ?>" class="bold">
                                    <?php echo _l('download_all'); ?> (.zip)
                                </a>
                            <?php } ?>
                        </div>
                        <div class="tw-flex tw-justify-end tw-items-center tw-space-x-2">
                            <button class="gpicker">
                                <i class="fa-brands fa-google" aria-hidden="true"></i>
                                <?php echo _l('choose_from_google_drive'); ?>
                            </button>
                            <div id="dropbox-chooser-lead"></div>
                        </div>
                        <div class=" clearfix"></div>
                    <?php } ?>
                    <?php if (count($lead->attachments) > 0) { ?>
                        <div class="mtop20" id="lead_attachments">
                            <?php $this->load->view('admin/leads/leads_attachments_template', ['attachments' => $lead->attachments]); ?>
                        </div>
                    <?php } ?>
                </div>

                <!-- Co-borrow tab data -->
                <div role="tabpanel" class="tab-pane col-md-12" id="co_borrow">
                    <table class="table dt-table" id="co_borrow_table">
                        <thead>
                            <tr>
                                <th>First Name</th>
                                <th>Middle Name</th>
                                <th>Last Name</th>
                                <th>Email</th>
                                <th>Phone No</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><?= isset($firstname) ? htmlspecialchars($firstname) : '-'; ?></td>
                                <td><?= isset($middlename) ? htmlspecialchars($middlename) : '-'; ?></td>
                                <td><?= isset($lastname) ? htmlspecialchars($lastname) : '-'; ?></td>
                                <td><?= isset($lead->email) ? htmlspecialchars($lead->email) : '-'; ?></td>
                                <td><?= isset($lead->phonenumber) ? htmlspecialchars($lead->phonenumber) : '-'; ?></td>
                                <td><button class="btn btn-primary btn-sm co_borrow_edit_btn"
                                data-id="<?php echo htmlspecialchars($lead->id); ?>">Edit</button></td>
                            </tr>
                            <?php if (!empty($leads_borrow)): ?>
                                <?php foreach ($leads_borrow as $borrow): ?>
                                    <tr id="borrow_<?php echo htmlspecialchars($borrow['id']); ?>">
                                        <td><?php echo htmlspecialchars($borrow['borrow_firstname'] ?: '-'); ?></td>
                                        <td><?php echo htmlspecialchars($borrow['borrow_middlename'] ?: '-'); ?></td>
                                        <td><?php echo htmlspecialchars($borrow['borrow_lastname'] ?: '-'); ?></td>
                                        <td><?php echo htmlspecialchars($borrow['borrow_email'] ?: '-'); ?></td>
                                        <td><?php echo htmlspecialchars($borrow['borrow_phone'] ?: '-'); ?></td>
                                        <td>
                                            <button class="btn btn-primary btn-sm co_borrow_edit_btn"
                                                data-id="<?php echo htmlspecialchars($borrow['id']); ?>">Edit</button>
                                            <button class="btn btn-danger btn-sm co_borrow_delete_btn"
                                                data-id="<?php echo htmlspecialchars($borrow['id']); ?>">Delete</button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="5">No records found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php if ($samegroup) { ?>
                    <!-- style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>" -->
                    <div role="tabpanel" class="tab-pane" id="lead_notes"
                        style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                        <?php echo form_open(admin_url('leads/add_note/' . $lead->id), ['id' => 'lead-notes']); ?>
                        <div class="form-group">
                            <textarea id="lead_note_description" name="lead_note_description" class="form-control" rows="4"
                                required></textarea>
                        </div>
                        <div class="lead-select-date-contacted show">
                            <?php echo render_datetime_input('custom_contact_date', 'lead_add_edit_datecontacted', '', ['data-date-end-date' => date('Y-m-d')]); ?>
                        </div>
                        <div class="radio radio-primary" style="display:none;">
                            <input type="radio" name="contacted_indicator" id="contacted_indicator_yes" value="yes" checked>
                            <label for="contacted_indicator_yes">
                                <?php echo 'Got in touch'; ?>
                            </label>
                        </div>
                        <div class="radio radio-primary" style="display:none;">
                            <input type="radio" name="contacted_indicator" id="contacted_indicator_no" value="no">
                            <label for="contacted_indicator_no">
                                <?php echo 'I have not contacted'; ?>
                            </label>
                        </div>
                        <button type="submit" class="btn btn-primary pull-right" id="add_file_note">
                            <?php echo _l('lead_add_edit_add_note'); ?>
                        </button>
                        <?php echo form_close(); ?>
                        <div class="clearfix"></div>
                        <hr />
                        <?php
                        $len = count($notes);
                        $i = 0;
                        foreach ($notes as $note) { ?>
                            <div class="media lead-note">
                                <a href="<?php echo admin_url('profile/' . $note['addedfrom']); ?>" target="_blank">
                                    <?php echo staff_profile_image($note['addedfrom'], ['staff-profile-image-small', 'pull-left mright10']); ?>
                                </a>
                                <div class="media-body">
                                    <?php
                                    /* if ($note['addedfrom'] == get_staff_user_id() || is_admin()) { */
                                    if (is_admin()) {
                                        ?>
                                        <a href="#" class="pull-right text-danger"
                                            onclick="delete_lead_note(this,<?php echo $note['id']; ?>, <?php echo $lead->id; ?>);return false;">

                                            <i class="fa fa fa-times"></i></a>
                                        <a href="#" class="pull-right mright5"
                                            onclick="toggle_edit_note(<?php echo $note['id']; ?>);return false;">
                                            <i class="fa-regular fa-pen-to-square"></i>
                                        <?php } ?>

                                        <a href="<?php echo admin_url('profile/' . $note['addedfrom']); ?>" target="_blank">
                                            <h5 class="media-heading tw-font-semibold tw-mb-0">
                                                <?php if (!empty($note['date_contacted'])) { ?>
                                                    <span data-toggle="tooltip"
                                                        data-title="<?php echo _dt($note['date_contacted']); ?>">
                                                        <i class="fa fa-phone-square text-success" aria-hidden="true"></i>
                                                    </span>
                                                <?php } ?>
                                                <?php echo get_staff_full_name($note['addedfrom']); ?>
                                            </h5>
                                            <span class="tw-text-sm tw-text-neutral-500">
                                                <?php echo _l('lead_note_date_added', _dt($note['dateadded'])); ?>
                                            </span>
                                        </a>

                                        <div data-note-description="<?php echo $note['id']; ?>" class="text-muted mtop10">
                                            <?php echo check_for_links(app_happy_text($note['description'])); ?>
                                        </div>
                                        <div data-note-edit-textarea="<?php echo $note['id']; ?>" class="hide mtop15">
                                            <?php echo render_textarea('note', '', $note['description']); ?>
                                            <div class="text-right">
                                                <button type="button" class="btn btn-default"
                                                    onclick="toggle_edit_note(<?php echo $note['id']; ?>);return false;">
                                                    <?php echo _l('cancel'); ?>
                                                </button>
                                                <button type="button" class="btn btn-primary"
                                                    onclick="edit_note(<?php echo $note['id']; ?>);">
                                                    <?php echo _l('update_note'); ?>
                                                </button>
                                            </div>
                                        </div>
                                </div>
                                <?php if ($i >= 0 && $i != $len - 1) {
                                    echo '<hr />';
                                }
                                ?>
                            </div>
                            <?php $i++;
                        } ?>
                    </div>
                <?php } ?>
            <?php } ?>
            <!-- Ld-commments -->
            <?php if ($samegroup || $samegroup === 2) { ?>
                <div role="tabpanel" class="tab-pane" id="ld_comments" style="<?php echo ($samegroup === 2) ? '' : ''; ?>">
                    <div class="col-md-12">
                        <button class="btn btn-secondary" style="float: right;" id="ld_refresh_comments"><i
                                class="fa fa-refresh" aria-hidden="true"></i></button>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="ld-comments-container" style="position: relative;">
                                <!-- Comment form -->
                                <?php hooks()->do_action('after_lead_tabs_content', $lead ?? null); ?>
                            </div>
                            <div class="col-md-12"
                                style="position: absolute;bottom: 27px;display: flex;justify-content: center;align-items: center;">
                                <button onclick="ld_scroll_down()" class="btn btn-secondary"
                                    id="ld_down_comments_container"><i class="fa fa-angle-down"
                                        aria-hidden="true"></i></button>
                            </div>
                        </div>
                    </div>
                    <?php if ($samegroup) { ?>
                        <?php echo form_open((admin_url('leads/ld_comments_add/' . $lead->id)), ['id' => 'ld_comment_form']); ?>
                        <div class="col-md-12">
                            <input type="hidden" id="lead_id" value='<?php echo $lead->id ?>'>
                            <?php echo render_textarea('ld_comments', 'Enter comment', '', array('placeholder' => 'Write a comment here...')); ?>
                        </div>
                        <div class="col-md-12"
                            style="margin-bottom:10px;display: flex;justify-content: end;align-items: center;">
                            <div style="margin-right: 10px;margin-top:5px;" id="ld_comment_loader"></div>
                            <button type="submit" class="btn btn-primary pull-right ld_comments-save-btn"
                                id="ld-comments-form-submit">
                                <?php echo _l('submit'); ?>
                            </button>
                        </div>
                        <?php echo form_close(); ?>
                    <?php } ?>
                </div>
            <?php } ?>
            <!-- client comments -->
            <div role="tabpanel" class="tab-pane" id="comments"
                style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                <div class="col-md-12">
                    <button class="btn btn-secondary" style="float: right;" id="refresh_comments"><i
                            class="fa fa-refresh" aria-hidden="true"></i></button>
                </div>
                <div class="col-md-12">
                    <div class="comments-container" style="position: relative;">
                        <!-- Comment form -->
                        <?php hooks()->do_action('after_lead_tabs_content', $lead ?? null); ?>
                    </div>
                    <div class="col-md-12"
                        style="position: absolute;bottom: 27px;display: flex;justify-content: center;align-items: center;">
                        <button onclick="scroll_down()" class="btn btn-secondary" id="down_comments_container"><i
                                class="fa fa-angle-down" aria-hidden="true"></i></button>
                    </div>
                </div>
                <?php if ($samegroup) { ?>
                    <?php echo form_open((admin_url('leads/comments_add/' . $lead->id)), ['id' => 'comment_form']); ?>
                    <div class="col-md-12">
                        <input type="hidden" id="lead_id" value='<?php echo $lead->id ?>'>
                        <?php echo render_textarea('comments', 'Enter comment', '', array('placeholder' => 'Write a comment here...')); ?>
                    </div>
                    <div class="col-md-12"
                        style="margin-bottom:10px;display: flex;justify-content: end;align-items: center;">
                        <div style="margin-right: 10px;margin-top:5px;" id="comment_loader"></div>
                        <button type="submit" class="btn btn-primary pull-right comments-save-btn"
                            id="comments-form-submit">
                            <?php echo _l('submit'); ?>
                        </button>
                    </div>
                    <?php echo form_close(); ?>
                <?php } ?>
            </div>
            <!-- admin LD Comments -->
            <div role="tabpanel" class="tab-pane" id="admin_ld_comments"
                style="<?php echo ($samegroup === 2) ? 'display:none;' : ''; ?>">
                <div class="col-md-12">
                    <button class="btn btn-secondary" style="float: right;" id="admin_ld_refresh_comments"><i
                            class="fa fa-refresh" aria-hidden="true"></i></button>
                </div>
                <div class="col-md-12">
                    <div class="admin_ld_comments_container" style="position: relative;">
                        <!-- Comment form -->
                        <?php hooks()->do_action('after_lead_tabs_content', $lead ?? null); ?>
                    </div>
                    <div class="col-md-12"
                        style="position: absolute;bottom: 27px;display: flex;justify-content: center;align-items: center;">
                        <button onclick="admin_ld_scroll_down()" class="btn btn-secondary" id="admin_ld_down_comments_container"><i
                                class="fa fa-angle-down" aria-hidden="true"></i></button>
                    </div>
                </div>
                <?php if ($samegroup) { ?>
                    <?php echo form_open((admin_url('leads/admin_ld_comments_add/' . $lead->id)), ['id' => 'admin_ld_comments_form']); ?>
                    <div class="col-md-12">
                        <input type="hidden" id="lead_id" value='<?php echo $lead->id ?>'>
                        <?php echo render_textarea('comments', 'Enter comment', '', array('placeholder' => 'Write a comment here...')); ?>
                    </div>
                    <div class="col-md-12"
                        style="margin-bottom:10px;display: flex;justify-content: end;align-items: center;">
                        <div style="margin-right: 10px;margin-top:5px;" id="admin_ld_comments_loader"></div>
                        <button type="submit" class="btn btn-primary pull-right comments-save-btn"
                            id="admin_ld_comments_form_submit">
                            <?php echo _l('submit'); ?>
                        </button>
                    </div>
                    <?php echo form_close(); ?>
                <?php } ?>
            </div>

            <!-- Unified Comments -->
            <div role="tabpanel" class="tab-pane" id="unified-comments" style="<?php echo ($samegroup === 2) ? '' : ''; ?>">
                <?php $this->load->view('admin/comment_tab/_unified_comment_tab'); ?>
            </div>

        </div>
    </div>
    <!-- reason modal -->
    <!-- Modal -->
    <!-- Modal -->
    <div class="modal fade" id="statusChangeModal" tabindex="-1" role="dialog" aria-labelledby="statusChangeModalLabel"
        aria-hidden="true" style="width: auto;background-color: #3831317a;overflow:hidden;">
        <div class="modal-dialog" role="document"
            style="display:flex;justify-content:center;align-items:center;height:100%">
            <div class="modal-content">
                <div class="modal-header">
                    <div style="display: flex; justify-content:space-between;align-items:center;">
                        <h4 id="">Please add the reason Rejection.</h4>
                        <a type="button" class="close" id="rejection_reason_close_button" data-dismiss=""
                            aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </a>
                    </div>
                </div>
                <div class="modal-body">
                    <form id="statusChangeForm">
                        <div class="form-group">
                            <label for="rejectionReason">Reason for Rejection:</label>
                            <textarea class="form-control" id="rejectionReason" name="reason" rows="4"
                                required></textarea>
                            <div class="invalid-feedback" style="display:none; color:red;">Please provide a reason
                                for rejection.</div>
                        </div>
                        <div style="margin-right: 10px;margin-top:-5px;" id="rejection_reason_loader"></div>
                        <button type="button" class="btn btn-primary" id="submitStatusChange">Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- ledger rejection modal -->
    <div class="modal fade" id="ledger_statusChangeModal" tabindex="-1" role="dialog"
        aria-labelledby="ledger_statusChangeModalLabel" aria-hidden="true"
        style="width: auto;background-color: #3831317a;overflow:hidden;">
        <div class="modal-dialog" role="document"
            style="display:flex;justify-content:center;align-items:center;height:100%">
            <div class="modal-content">
                <div class="modal-header">
                    <div style="display: flex; justify-content:space-between;align-items:center;">
                        <h4 id="ledger_modal_header">Please add the reason for rejection.</h4>
                        <a type="button" class="close" id="ledger_rejection_reason_close_button" data-dismiss=""
                            aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </a>
                    </div>
                </div>
                <div class="modal-body">
                    <form id="ledger_statusChangeForm">
                        <div class="form-group">
                            <label for="ledger_rejectionReason">Reason:</label>
                            <textarea class="form-control" id="ledger_rejectionReason" name="reason" rows="4"
                                required></textarea>
                            <div class="invalid-feedback" style="display:none; color:red;">Please provide a reason
                                for rejection.</div>
                        </div>
                        <div style="margin-right: 10px;margin-top:-5px;" id="ledger_rejection_reason_loader"></div>
                        <button type="button" class="btn btn-primary" id="ledger_submitStatusChange">Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- file opened modal -->
    <div class="modal fade" id="file_opened_modal_upload_doc" tabindex="-1" role="dialog"
        aria-labelledby="statusChangeModalLabel" style="width: auto;background-color: #3831317a;overflow:hidden;">
        <div class="modal-dialog" role="document"
            style="display:flex;justify-content:center;align-items:center;height:100%;">
            <div class="modal-content" style="height: auto;">
                <div class="modal-header">
                    <div style="display: flex; justify-content:space-between;align-items:center;">
                        <h4>Please upload the <span id="get_checkbox_title_file_opened"></span> Documents.</h4>
                        <button type="button" class="close" id="file_opened_modal_close_button" data-dismiss=""
                            aria-label="Close">
                            <span>&times;</span>
                        </button>
                    </div>
                </div>
                <div class="modal-body">
                    <!-- <form id="file_opened_modal_upload_doc_form"> -->
                    <?php echo form_open_multipart('admin/leads/upload_doc_for_fileopened', ['class' => 'mtop15 mbot15', 'id' => 'file_opened_modal_upload_doc_form']); ?>
                    <div id="ld_notes_toggle" style="display:none;">
                        <?php echo render_textarea('ld_notes', 'LD Notes', $data['ld_notes'], array('placeholder' => 'Please enter the item notes.')); ?>
                    </div>
                    <div class="form-group">
                        <label for="userfile" class="control-label">Select Files (PDF, JPEG, JPG, PNG, DOC, DOCX,
                            XLS, XLSX)</label>
                        <input type="file" class="form-control" name="userfile[]" id="userfile" multiple
                            accept=".pdf, .jpeg, .jpg, .png, .doc, .docx, .xls, .xlsx" style="height:53px;">
                        <div id="userfile_error" class="error-message" style="color:red;"></div>
                    </div>
                    <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                    <?php if ($samegroup) { ?>
                        <div style="display: flex;justify-content: end;align-items: center;margin-bottom: 20px;"
                            class="col-md-12">
                            <div style="margin-right: 10px;margin-top:-5px;" id="file_opened_loader"></div>
                            <input type="submit" class="btn btn-primary" id="file_opened_submit_button"
                                style="float:right;margin-bottom: 10px;" <?php echo ($leads_status_current_id == 1 || $leads_status_current_id >= $file_opened_checklist_id) ? '' : 'disabled'; ?>>
                        </div>
                    <?php } ?>
                    <!-- </form> -->
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
    <!-- Outstanding item modal -->
    <div class="modal fade" id="outstanding_item_modal_upload_doc" tabindex="-1" role="dialog"
        aria-labelledby="statusChangeModalLabel" aria-hidden="true"
        style="width: auto;background-color: #3831317a;overflow:hidden;">
        <div class="modal-dialog" role="document"
            style="display:flex;justify-content:center;align-items:center;height:100%">
            <div class="modal-content" style="height: auto;">
                <div class="modal-header">
                    <div style="display: flex; justify-content:space-between;align-items:center;">
                        <h4>Please upload the <span id="get_checkbox_title_outstanding"></span> Documents.</h4>
                        <a type="button" class="close" id="outstanding_item_modal_close_button" data-dismiss=""
                            aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </a>
                    </div>
                </div>
                <div class="modal-body">
                    <!-- <form id="outstanding_item_modal_upload_doc_form"> -->
                    <?php echo form_open('admin/leads/upload_doc_for_outstanding_item', ['class' => 'mtop15 mbot15', 'id' => 'outstanding_item_modal_upload_doc_form']); ?>
                    <div class="form-group">
                        <label for="outstanding_item_userfile" class="control-label">Select Files (PDF, JPEG, JPG,
                            PNG, DOC, DOCX, XLS, XLSX)</label>
                        <input type="file" class="form-control" name="outstanding_item_userfile[]"
                            id="outstanding_item_userfile" multiple
                            accept=".pdf, .jpeg, .jpg, .png, .doc, .docx, .xls, .xlsx" style="height:53px;">
                        <div id="outstanding_item_userfile_error" class="error-message" style="color:red;"></div>
                    </div>
                    <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                    <?php if ($samegroup) { ?>
                        <div style="display: flex;justify-content: end;align-items: center;margin-bottom: 20px;"
                            class="col-md-12">
                            <div style="margin-right:10px;" id="outstanding_loader"></div>
                            <input type="submit" class="btn btn-primary" id="outstanding_item_submit_button"
                                style="float:right;margin-bottom: 25px;" <?php echo ($leads_status_current_id >= 3 || $leads_status_current_id == 7) ? '' : 'disabled'; ?>>
                        </div>

                    <?php } ?>
                    <!-- </form> -->
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
    <!-- ledger upload doc modal code -->
    <div class="modal fade" id="ledger_modal_upload_doc" tabindex="-1" role="dialog"
        aria-labelledby="statusChangeModalLabel" aria-hidden="true"
        style="width: auto;background-color: #3831317a;overflow:scroll;">
        <div class="modal-dialog" role="document"
            style="display:flex;justify-content:center;align-items:center;height:100%">
            <div class="modal-content" style="height: auto;">
                <div class="modal-header">
                    <div style="display: flex; justify-content:space-between;align-items:center;">
                        <h4 id="ledger_modal_title">Please upload the <span id=""></span> Documents.</h4>
                        <a type="button" class="close" id="ledger_modal_close_button" data-dismiss=""
                            aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </a>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="col-md-12">
                        <?php echo form_open('admin/leads/upload_doc_for_ledger', ['class' => 'mtop15 mbot15', 'id' => 'upload_doc_for_ledger']); ?>
                        <p id="show_text_to_broker" style="font-weight:800;"></p>
                        <div id="review_ledgers_broker_email" style="margin_bottom:15px;">
                            <?php echo render_input('to_broker_ledgers_reviewmail', 'To', $to_broker_emails, '', ['required' => 'required']); ?>
                            <?php echo render_input('cc_broker_ledgers_reviewmail', 'CC', $group_members_or_broker_emails, ''); ?>
                            <?php echo render_input('bcc_broker_ledgers_reviewmail', 'BCC', '', ''); ?>
                            <textarea name="send_approved_ledger_to_broker_tinymce"
                                id="send_approved_ledger_to_broker_tinymce" rows="10" cols="80"
                                style="height: 140px;"></textarea>
                        </div>
                        <?php echo render_textarea('ledger_comment', 'File Comment', '', array('placeholder' => 'Please enter the any comment.')); ?>
                        <div style="display:none;">
                            <?php echo render_textarea('ledger_notes', 'Notes', '', array('placeholder' => 'Please enter the any notes.')); ?>
                        </div>
                        <div class="form-group">
                            <label for="ledger_userfile" id="ledger_userfile_title" class="control-label">Select
                                Files (PDF, JPEG, JPG, PNG, DOC, DOCX, XLS, XLSX)</label>
                            <input type="file" class="form-control" name="ledger_userfile[]" id="ledger_userfile"
                                multiple accept=".pdf, .jpeg, .jpg, .png, .doc, .docx, .xls, .xlsx"
                                style="height:53px;">
                            <div id="ledger_userfile_error" class="error-message" style="color:red;"></div>
                        </div>
                        <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                        <div style="display: flex;justify-content: end;align-items: center;margin-bottom: 20px;"
                            class="col-md-12">
                            <div style="margin-right: 10px;margin-top:-5px;" id="ledger_loader"></div>
                            <input type="submit" class="btn btn-primary" id="ledger_doc_submit_button"
                                style="float:right;margin-bottom: 10px;">
                        </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- LD Outstanding item upload docs modal -->
    <div class="modal fade" id="ld_outstanding_item_modal_upload_doc" tabindex="-1" role="dialog"
        aria-labelledby="statusChangeModalLabel" aria-hidden="true"
        style="width: auto;background-color: #3831317a;overflow:hidden;">
        <div class="modal-dialog" role="document"
            style="display:flex;justify-content:center;align-items:center;height:100%">
            <div class="modal-content" style="height: auto;">
                <div class="modal-header">
                    <div style="display: flex; justify-content:space-between;align-items:center;">
                        <h4>Please upload the <span id=""></span> Documents.</h4>
                        <a type="button" class="close" id="ld_outstanding_item_modal_close_button" data-dismiss=""
                            aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </a>
                    </div>
                </div>
                <div class="modal-body">
                    <!-- <form id="outstanding_item_modal_upload_doc_form"> -->
                    <?php echo form_open('admin/leads/ld_outstanding_item_modal_upload_doc_form', ['class' => 'mtop15 mbot15', 'id' => 'ld_outstanding_item_modal_upload_doc_form']); ?>
                    <!--just for payouts statement add the lender name and expire data -->
                    <div class="ld_payouts_data" id="ld_payouts_data" style="display:none;">
                      <div id="ld_outstanding_secure_lender_name" style="display:none;">
                          <?php /* echo render_select('lender_name', $agent_data, ['id', 'bank_name'], '<b style="font-weight: 800;">Lender’s name</b>', $selected); */?>
                      </div>
                      <?php echo render_datetime_input('payout_expire_date', '<span style="color:red;" id="label_star_payout_expire_date">*</span> Expiry Date', ''); ?>
                    </div>
                    <?php echo render_textarea('ld_payout_other_notes', 'Notes', $data['ld_notes'], array('placeholder' => 'Please enter the item notes.')); ?>
                    <div class="form-group">
                        <label for="ld_outstanding_item_userfile" class="control-label">Select Files (PDF, JPEG,
                            JPG, PNG, DOC, DOCX, XLS, XLSX)</label>
                        <input type="file" class="form-control" name="ld_outstanding_item_userfile[]"
                            id="ld_outstanding_item_userfile" multiple
                            accept=".pdf, .jpeg, .jpg, .png, .doc, .docx, .xls, .xlsx" style="height:53px;">
                        <div id="ld_outstanding_item_userfile_error" class="error-message" style="color:red;"></div>
                    </div>
                    <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                    <?php if ($samegroup) { ?>
                        <div style="display: flex;justify-content: end;align-items: center;margin-bottom: 20px;"
                            class="col-md-12">
                            <div style="margin-right:10px;" id="ld_outstanding_item_loader"></div>
                            <input type="submit" class="btn btn-primary" id="ld_outstanding_item_submit_button"
                                style="float:right;margin-bottom: 25px;">
                        </div>

                    <?php } ?>
                    <!-- </form> -->
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
    <!-- LD request for funds docs upload document modal -->
    <div class="modal fade" id="request_for_funds_modal_upload_doc" tabindex="-1" role="dialog"
        aria-labelledby="statusChangeModalLabel" aria-hidden="true" style="width: auto;background-color: #3831317a;">
        <div class="modal-dialog" role="document"
            style="display:flex;justify-content:center;align-items:center;height:100%">
            <div class="modal-content" style="height: auto;">
                <div class="modal-header">
                    <div style="display: flex; justify-content:space-between;align-items:center;">
                        <h4>Please upload the <span id=""></span> Documents.</h4>
                        <a type="button" class="close" id="request_for_funds_modal_close_button" data-dismiss=""
                            aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </a>
                    </div>
                </div>
                <div class="modal-body">
                    <!-- <form id="outstanding_item_modal_upload_doc_form"> -->
                    <?php echo form_open('admin/leads/upload_doc_for_request_for_funds', ['class' => 'mtop15 mbot15', 'id' => 'request_for_funds_modal_upload_doc_form']); ?>
                    <?php
                    $imp_html = "<div class='form-group' id='send_report_content_toggle' style='display:none;'><label for='req_complete_stage_question' class='control-label'><span style='color:red;'>*</span> Is there a holdback to be mentioned in the closing email?</label>";
                    $imp_html .= "<select name='req_complete_stage_question' id='req_complete_stage_question' class='form-control' required>";
                    // $imp_html .= "<option value=''>Not assigned yet</option>";
                    $imp_html .= "<option value='no'>No</option>";
                    $imp_html .= "<option value='yes'>Yes</option>";
                    $imp_html .= "</select></div>";
                    echo $imp_html; ?>
                    <!-- appened the case closed mail -->
                    <div class="" id="send_report_cc_bcc">
                        <?php echo render_input('to_client_req_for_funds_send_report_reviewmail', 'To Client', $to_all_case_clients_email, '', ['required' => 'required']); ?>
                        <?php echo render_input('cc_req_for_funds_send_report_reviewmail', 'CC', $cc_group_memebers, ''); ?>
                        <?php echo render_input('bcc_req_for_funds_send_report_reviewmail', 'BCC', $bcc_closing_emails, ''); ?>
                    </div>
                    <div class="col-md-12" id="closed_mail_review" style="">
                        <textarea name="request_for_funds_review_email_tincymac"
                            id="request_for_funds_review_email_tincymac" rows="10" cols="80"
                            style="height: 400px;"></textarea>
                    </div>
                    <div class="appened_req_action_date"></div>
                    <div class="appened_req_comments"></div>
                    <div class="form-group">
                        <label for="request_for_funds_userfile" class="control-label"><span style="color:red;display:none;" id="req_funds_asterisk">*</span>
                            Select Files (PDF, JPEG, JPG,
                            PNG, DOC, DOCX, XLS, XLSX)</label>
                        <input type="file" class="form-control" name="request_for_funds_userfile[]"
                            id="request_for_funds_userfile" multiple
                            accept=".pdf, .jpeg, .jpg, .png, .doc, .docx, .xls, .xlsx" style="height:53px;">
                        <div id="request_for_funds_userfile_error" class="error-message" style="color:red;"></div>
                    </div>
                    <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                    <?php if ($samegroup) { ?>
                        <div style="display: flex;justify-content: end;align-items: center;margin-bottom: 20px;"
                            class="col-md-12">
                            <div style="margin-right:10px;" id="request_for_funds_loader"></div>
                            <input type="submit" class="btn btn-primary" id="request_for_funds_submit_button"
                                style="float:right;margin-bottom: 25px;">
                        </div>

                    <?php } ?>
                    <!-- </form> -->
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
    <!-- ledgers comments add when bb status change -->
    <!-- <div class="modal fade" id="request_for_funds_modal_upload_doc" tabindex="-1" role="dialog" -->
    <div class="modal fade" id="ledgers_status_comment_modal" tabindex="-1" role="dialog"
        aria-labelledby="statusChangeModalLabel" aria-hidden="true"
        style="width: auto;background-color: #3831317a;overflow:hidden;">
        <div class="modal-dialog" role="document"
            style="display:flex;justify-content:center;align-items:center;height:100%">
            <div class="modal-content" style="height: auto;">
                <div class="modal-header">
                    <div style="display: flex; justify-content:space-between;align-items:center;float:right;">
                        <!-- <a type="button" class="close" id="request_for_funds_modal_close_button" data-dismiss="" -->
                        <a type="button" class="close" id="ledger_status_comment_close_btn" data-dismiss=""
                            aria-label="Close" style="float:right;">
                            <span aria-hidden="true">&times;</span>
                        </a>
                    </div>
                </div>
                <div class="modal-body">
                    <!-- <form id="outstanding_item_modal_upload_doc_form"> -->
                    <?php echo form_open('admin/leads/ledger_status_change_by_bb/' . $lead->id, ['class' => 'mtop15 mbot15', 'id' => 'ledgers_comments_by_bb']); ?>
                    <?php echo render_textarea('bb_comment', 'Enter Comments', '', ['style' => 'height: 100px; width: 400px;', 'required' => 'required']); ?>
                    <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                    <?php if ($samegroup) { ?>
                        <div style="display: flex; justify-content: end; align-items: center; margin-bottom: 20px;"
                            class="col-md-12">
                            <div style="margin-right: 10px;" id="ledgers_bb_comment_loader"></div>
                            <input type="submit" class="btn btn-primary" id="ledger_status_change_btn"
                                style="float: right; margin-bottom: 25px;" value="Submit">
                        </div>
                    <?php } ?>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
    <!-- show the log content -->
    <div class="modal fade" id="show_logs_modal" tabindex="-1" role="dialog" aria-labelledby="statusChangeModalLabel"
        aria-hidden="true" style="width: auto;background-color: #3831317a;overflow:hidden;">
        <div class="modal-dialog" role="document"
            style="display:flex;justify-content:center;align-items:center;height:100%">
            <div class="modal-content" style="height: auto;">
                <div class="modal-header" style="display: flex; justify-content:space-between;align-items:center;">
                    <h4 class="col-md-6">Case Activity log</h4>
                    <div class="col-md-6">
                        <!-- <a type="button" class="close" id="request_for_funds_modal_close_button" data-dismiss="" -->
                        <a type="button" class="close" id="show_logs_modal_close_btn" data-dismiss="" aria-label="Close"
                            style="float:right;">
                            <span aria-hidden="true">&times;</span>
                        </a>
                    </div>
                </div>
                <div class="modal-body">
                    <p id="activity_log_content"></p>
                </div>
            </div>
        </div>
    </div>
    <!-- show the modal for update the checklsit details -->
    <div class="modal fade" id="checklist_update_modal" tabindex="-1" role="dialog"
        aria-labelledby="statusChangeModalLabel" aria-hidden="true"
        style="width: auto;background-color: #3831317a;overflow:hidden;">
        <div class="modal-dialog" role="document"
            style="display:flex;justify-content:center;align-items:center;height:100%">
            <div class="modal-content" style="height: auto;">
                <div class="modal-header" style="display: flex; justify-content:space-between;align-items:center;">
                    <h4 class="col-md-6">Update Item Details</h4>
                    <div class="col-md-6" style="">
                        <!-- <a type="button" class="close" id="request_for_funds_modal_close_button" data-dismiss="" -->
                        <a type="button" class="close" id="checklist_update_modal_close_btn" data-dismiss=""
                            aria-label="Close" style="float:right;">
                            <span aria-hidden="true">&times;</span>
                        </a>
                    </div>
                </div>
                <div class="modal-body">
                    <?php echo form_open((admin_url('leads/updatechecklist/')), ['id' => 'update_checklist_form']); ?>
                    <div class="form-group" app-field-wrapper="name">
                        <label for="update_item_name" class="control-label">Item Title & Description</label>
                        <input type="text" id="update_item_name" name="update_item_name" class="form-control"
                            placeholder="Please Enter title ( ID back, Driving License )" style="width:500px;" value="">
                    </div>
                    <div id="client_notes_textarea_toggle">
                        <?php echo render_textarea('update_item_notes', 'Notes', '', array('placeholder' => 'Please enter the item notes.')); ?>
                    </div>
                    <div style="margin-bottom:10px;display: flex;justify-content: end;align-items: center;">
                        <div style="margin-right: 10px;margin-top:-5px;" id="update_checklist_form_loader"></div>
                        <button type="submit" class="btn btn-primary pull-right" id="update_checklist_item_btn">
                            <?php echo _l('Update'); ?>
                        </button>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
    <!-- show the modal and update the ld checklist items  -->
    <div class="modal fade" id="ld_checklist_update_modal" tabindex="-1" role="dialog"
        aria-labelledby="statusChangeModalLabel" aria-hidden="true"
        style="width: auto;background-color: #3831317a;overflow:hidden;">
        <div class="modal-dialog" role="document"
            style="display:flex;justify-content:center;align-items:center;height:100%">
            <div class="modal-content" style="height: auto;">
                <div class="modal-header" style="display: flex; justify-content:space-between;align-items:center;">
                    <h4 class="col-md-6">Update Item Details</h4>
                    <div class="col-md-6" style="">
                        <!-- <a type="button" class="close" id="request_for_funds_modal_close_button" data-dismiss="" -->
                        <a type="button" class="close" id="ld_checklist_update_modal_close_btn" data-dismiss=""
                            aria-label="Close" style="float:right;">
                            <span aria-hidden="true">&times;</span>
                        </a>
                    </div>
                </div>
                <div class="modal-body">
                    <?php echo form_open((admin_url('leads/ld_updatechecklist/')), ['id' => 'ld_update_checklist_form']); ?>
                    <div class="form-group" app-field-wrapper="name">
                        <label for="update_ld_item_name" class="control-label" id="ld_outstanding_title_update_modal">Item Title & Description</label>
                        <input type="text" id="update_ld_item_name" name="update_ld_item_name" class="form-control"
                            placeholder="Please Enter title ( ID back, Driving License )" style="width:560px;" value="">
                    </div>
                    <!-- <div class="form-group" app-field-wrapper="name">
                        <label for="update_ld_req_comments" class="control-label">Item Title & Description</label>
                        <textarea type="text" id="update_ld_req_comments" name="update_ld_req_comments" class="form-control"
                            placeholder="Please Enter any comments..."  value=""></textarea>
                    </div> -->
                    <div id="ld_notes_textarea_toggle">
                        <?php echo render_textarea('update_item_ld_notes', 'Notes', '', array('placeholder' => 'Please enter the item notes.')); ?>
                    </div>
                    <!-- creating dynamically fields for secure payout statments and for lender and expires date -->
                    <div class="col-md-12" id="edit_details_for_lender_expire_dates"></div>
                    <div class="col-md-12"
                        style="margin-bottom:10px;display: flex;justify-content: end;align-items: center;">
                        <div style="margin-right: 10px;margin-top:-5px;" id="ld_update_checklist_form_loader"></div>
                        <button type="submit" class="btn btn-primary pull-right" id="ld_update_checklist_item_btn">
                            <?php echo _l('Update'); ?>
                        </button>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
    <!-- Case stage report modal -->
    <div id="case_report_modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="CaseReportModalLabel"
        aria-hidden="true" style="width: auto;background-color: #3831317a;overflow-y: scroll;overflow-x: hidden;scrollbar-width: thin;scrollbar-color: #888 #f1f1f1;">
        <div class="modal-dialog" role="document" id="case_report_dialog_id" style="width: 100%;">
            <div class="modal-content" style="">
                <div class="modal-header" style="display:flex;align-items:center;">
                    <h5 class="modal-title col-md-6" id="CaseReportModalLabel"></h5>
                    <div class="col-md-6" style="float:right;">
                        <button type="button" class="close" id="case_report_modal_closing_btn" aria-label="Close"
                            style="float:end;">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>
                <div class="modal-body">
                <?php $this->load->view('admin/leads/Case_report_template_design', ['data' => $merging_doc_data]); ?>
                </div>
                <div class="modal-footer">
                    <!-- <button type="button" class="btn btn-secondary" id="generic_modal_closing_btn">Close</button>
                        <button type="button" class="btn btn-primary">Save changes</button> -->
                </div>
            </div>
        </div>
    </div>
    <!-- borrower update details modal -->
    <div id="editBorrowerModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="CaseReportModalLabel"
        aria-hidden="true" style="width: auto;background-color: #3831317a;">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Co-Borrower</h5>
                    <button type="button" class="close" id="client_contact_modal_close_btn" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" style="padding-bottom: 50px;">
                    <?php echo form_open(( admin_url('leads/update_borrower_details_by_id/' . $lead->id)), ['id' => 'editBorrowerForm']); ?>
                  
                        <input type="hidden" id="client_contact_borrower_id" name="client_contact_borrower_id">
                        
                        <div class="form-group">
                            <label for="borrow_firstname">First Name</label>
                            <input type="text" class="form-control" id="borrow_firstname" name="borrow_firstname">
                        </div>

                        <div class="form-group">
                            <label for="borrow_middlename">Middle Name</label>
                            <input type="text" class="form-control" id="borrow_middlename" name="borrow_middlename">
                        </div>

                        <div class="form-group">
                            <label for="borrow_lastname">Last Name</label>
                            <input type="text" class="form-control" id="borrow_lastname" name="borrow_lastname">
                        </div>

                        <div class="form-group">
                            <label for="borrow_email">Email</label>
                            <input type="email" class="form-control" id="borrow_email" name="borrow_email">
                        </div>

                        <!-- <div class="form-group">
                            <label for="borrow_address">Address</label>
                            <input type="text" class="form-control" id="borrow_address" name="borrow_address">
                        </div> -->

                        <div class="form-group">
                            <label for="borrow_phone">Phone No</label>
                            <input type="text" class="form-control" id="borrow_phone" name="borrow_phone">
                        </div>
                        <div class="col-md-12" style="display:flex; justify-content:center; align-items:center;">
                            <button type="submit" class="btn btn-primary" id="client_contact_update_button">Save Changes</button>
                            <div style="margin-right: 10px;margin-top:-5px;" id="client_contact_update_loader"></div>
                        </div>
                       
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Generic modal  -->
    <!-- Modal HTML -->
    <div id="generic_modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="genericModalLabel"
        aria-hidden="true" style="width: auto;background-color: #3831317a;">
        <div class="modal-dialog" role="document" id="generic_modal_dialog_id">
            <div class="modal-content">
                <div class="modal-header" style="display:flex;align-items:center;">
                    <h5 class="modal-title col-md-6" id="genericModalLabel"></h5>
                    <div class="col-md-6" style="float:right;">
                        <button type="button" class="close" id="generic_modal_closing_btn" aria-label="Close"
                            style="float:end;">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>
                <div class="modal-body">
                    <!-- Modal body content -->
                    <div id="dynamic_form_container">
                    </div>
                </div>
                <div class="modal-footer">
                    <!-- <button type="button" class="btn btn-secondary" id="generic_modal_closing_btn">Close</button>
                        <button type="button" class="btn btn-primary">Save changes</button> -->
                </div>
            </div>
        </div>
    </div>
    <!-- Full-page loader -->
    <div class="full-page-loader" id="full_page_loader">
        <div class="loader"></div>
    </div>
    <style>
        ul li::before  {
            color: black !important;
        }
        /* Rotate animation */
        #refresh_page {
            transition: transform 0.5s ease-in-out;
            /* Smooth transition for rotation */
        }

        @keyframes rotate360 {
            from {
                transform: rotate(0deg);
            }

            to {
                transform: rotate(360deg);
            }
        }

        /* Apply the rotation animation when the corresponding class is added */
        .rotate-animation {
            animation: rotate360 2s linear infinite;
        }

        .stepper-wrapper {
            margin-top: auto;
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }

        .step-active {
            background-color: #7786a896 !important;
            color: #FFF;
            font-weight: 800;
        }

        .stepper-item {
            position: relative;
            display: flex;
            flex-direction: column;
            align-items: center;
            flex: 1;

            @media (max-width: 768px) {
                font-size: 12px;
            }
        }

        .stepper-item::before {
            position: absolute;
            content: "";
            border-bottom: 2px solid #ccc;
            width: 100%;
            top: 20px;
            left: -50%;
            z-index: 2;
        }

        .stepper-item::after {
            position: absolute;
            content: "";
            border-bottom: 2px solid #ccc;
            width: 100%;
            top: 20px;
            left: 50%;
            z-index: 2;
        }

        .stepper-item .step-counter {
            position: relative;
            z-index: 5;
            display: flex;
            justify-content: center;
            align-items: center;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #de0c0cab;
            color: white;
            margin-bottom: 6px;
        }

        .stepper-item .step-counter-broker {
            position: relative;
            z-index: 5;
            display: flex;
            justify-content: center;
            align-items: center;
            width: 25px;
            height: 25px;
            border-radius: 50%;
            background: #de0c0cab;
            color: white;
            margin-bottom: 6px;
        }

        .stepper-item.active {
            font-weight: bold;
        }

        .stepper-item.completed .step-counter {
            background-color: #189546;
            color: white;
        }

        .stepper-item.completed .step-counter-broker {
            background-color: #189546;
            color: white;
        }

        .stepper-item.completed::after {
            position: absolute;
            content: "";
            border-bottom: 2px solid #4bb543;
            width: 100%;
            top: 20px;
            left: 50%;
            z-index: 3;
        }

        .stepper-item:first-child::before {
            content: none;
        }

        .stepper-item:last-child::after {
            content: none;
        }

        /* end of step progress */
        .ribbon {
            height: 0px !important;
        }

        .steps {
            border: 1px solid #FFFF
        }

        .steps-header {
            padding: .375rem;
            border-bottom: 1px solid #FFFF
        }

        .steps-header .progress {
            height: .25rem
        }

        .steps-body {
            display: table;
            table-layout: fixed;
            width: 100%;
            background-color: #FFFF;
        }

        .step {
            display: table-cell;
            position: relative;
            padding: 1.1rem 0.1rem;
            -webkit-transition: all 0.25s ease-in-out;
            transition: all 0.25s ease-in-out;
            color: rgba(0, 0, 0, 0.65);
            font-weight: 600;
            text-align: center;
            text-decoration: none;


        }

        .step:last-child {
            border: none;
        }

        .step-indicator {
            display: block;
            position: absolute;
            top: .75rem;
            left: .75rem;
            width: 1.5rem;
            height: 1.5rem;
            border: 1px solid #e7e7e7;
            border-radius: 50%;
            background-color: #fff;
            font-size: .875rem;
            line-height: 1.375rem
        }

        .has-indicator {
            padding-right: 1.5rem;
            padding-left: 2.375rem
        }

        .has-indicator .step-indicator {
            top: 50%;
            margin-top: -.75rem
        }

        .step-icon {
            display: block;
            width: 1.5rem;
            height: 1.5rem;
            margin: 0 auto;
            margin-bottom: .75rem;
            -webkit-transition: all 0.25s ease-in-out;
            transition: all 0.25s ease-in-out;
            color: #888
        }

        .step:hover {
            color: rgba(0, 0, 0, 0.9);
            text-decoration: none
        }

        .step:hover .step-indicator {
            -webkit-transition: all 0.25s ease-in-out;
            transition: all 0.25s ease-in-out;
            border-color: transparent;
            background-color: #f4f4f4
        }

        .step:hover .step-icon {
            color: rgba(0, 0, 0, 0.9)
        }

        .step-active,
        .step-active:hover {
            color: #FFFF;
            pointer-events: none;
            cursor: default;
            background-color: #2978D2;
            border-radius: 8px;
        }

        .step-active .step-indicator,
        .step-active:hover .step-indicator {
            border-color: transparent;
            background-color: #5c77fc;
            color: #fff
        }

        .step-active .step-icon,
        .step-active:hover .step-icon {
            color: #5c77fc
        }

        .step-completed .step-indicator,
        .step-completed:hover .step-indicator {
            border-color: transparent;
            background-color: rgba(51, 203, 129, 0.12);
            color: #33cb81;
            line-height: 1.25rem
        }

        .step-completed .step-indicator .feather,
        .step-completed:hover .step-indicator .feather {
            width: .875rem;
            height: .875rem
        }

        /* Style the comment container */
        .comments-container {
            max-width: 100%;
            margin: 20px auto;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            overflow-y: scroll;
            max-height: 300px;
        }

        /* for broker and ld comments section */
        .ld-comments-container {
            max-width: 100%;
            margin: 20px auto;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            overflow-y: scroll;
            max-height: 300px;
        }
        .admin_ld_comments_container {
            max-width: 100%;
            margin: 20px auto;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            overflow-y: scroll;
            max-height: 300px;
        }

        /* Style individual comments */
        .comment {
            margin-bottom: 15px;
            padding: 10px;
            border: 1px solid #eee;
            border-radius: 5px;
        }

        /* Style comment author and date */
        .comment .author {
            font-weight: bold;
            color: #333;
        }

        .comment .date {
            color: #888;
            font-size: 0.8em;
        }

        /* instruction images style */
        .card {
            box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2);
            transition: 0.3s;
            border-radius: 5px;
        }

        .card:hover {
            box-shadow: 0 8px 16px 0 rgba(0, 0, 0, 0.2);
        }

        .container_instruction {
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 11px 16px;
        }

        /* Broker button appearance for tabs */
        .broker_li_tabs {
            width: 170px;
        }
        .broker_ul_tabs{
            padding: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .nav-tabs-custom {
            padding: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .nav-tabs .btn {
            margin-right: 5px;
            border-radius: 5px;
            background-color: #4358eb;
            color: #FFFFFF;
            padding: 8px 15px;
            text-align: center;
            border: 1px solid #4358eb;
            border-radius: 5%;
        }
        .nav-tabs .btn.active-tab {
            background-color: #f8f9fa;
            color: #333;
            border: 1px solid #4358eb;
            border-radius: 5%;
        }
        .nav-tabs .btn:hover {
            background-color: #e2e6ea;
            color: #000;
            border: 1px solid #4358eb;
            border-radius: 5%;
        }

        /* input type file stykle */
        [type="file"] {
            /* Style the color of the message that says 'No file chosen' */
            color: #2958da;
        }

        [type="file"]::-webkit-file-upload-button {
            background: #eff6ff;
            border: 2px solid #eff6ff;
            border-radius: 4px;
            color: #2958da;
            cursor: pointer;
            font-size: 12px;
            outline: none;
            padding: 10px 25px;
            text-transform: uppercase;
            transition: all 1s ease;
        }

        [type="file"]::-webkit-file-upload-button:hover {
            background: #eff6ff;
            border: 2px solid #2958da;
            color: #bbbb;
        }

        /* loader css code */
        .loader {
            border: 7px solid #f3f3f3;
            border-radius: 50%;
            border-top: 7px solid #3498db;
            width: 50px;
            height: 50px;
            -webkit-animation: spin 2s linear infinite;
            /* Safari */
            animation: spin 2s linear infinite;
        }

        .notifications-list {
            list-style: none;
            padding: 0;
        }

        .notification-item {
            border-bottom: 1px solid #ddd;
            padding: 10px;
            display: flex;
            align-items: center;
        }

        .notification-item img {
            margin-right: 10px;
        }

        /* full page loader show */
        .full-page-loader {
            display: none;
            position: fixed;
            z-index: 9999;
            width: 1200px;
            height: 100%;
            top: 0;
            left: 0;
            background: rgba(255, 255, 255, 0.8);
            text-align: center;
        }

        .full-page-loader .loader {
            position: absolute;
            top: 50%;
            left: 42%;
            transform: translate(-50%, -50%);
            border: 16px solid #f3f3f3;
            border-radius: 50%;
            border-top: 16px solid #3498db;
            width: 120px;
            height: 120px;
            animation: spin 2s linear infinite;
        }

        /* text area sms  css*/
        .word-counter {
            margin-top: 10px;
            font-size: 14px;
            color: #555;
        }

        .textarea-container {
            width: 300px;
            margin-bottom: 20px;
        }
        /* drag and drop code */
        .drop-area {
            width: 75%;
            height: 60px;
            border: 2px dashed #ccc;
            text-align: center;
            line-height: 26px;
            cursor: pointer;
            margin-bottom: 10px;
            margin-left: 10px;
            display:flex;
            justify-content:center;
            align-items:center;
        }

        .drop-area.highlight {
            background-color: #f0f8ff;
        }

        .image-preview {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
        }

        .image-preview div {
            position: relative;
            display: inline-block;
        }

        .image-preview img {
            width: 80px;
            height: 80px;
            object-fit: cover;
            border: 1px solid #ddd;
        }

        .remove-btn {
            position: absolute;
            top: 2px;
            right: 2px;
            background: red;
            color: white;
            border: none;
            cursor: pointer;
            font-size: 12px;
            width: 18px;
            height: 18px;
            line-height: 18px;
            border-radius: 50%;
            text-align: center;
        }
        .email-form-section .form-label {
            color: #495057;
        }
        .tox.tox-tinymce {
            border-radius: 0.5rem !important;
        }
        .sortable-placeholder {
            background-color: #f1f1f1;
            border: 2px dashed #ccc;
            height: 100%; /* Match your row height */
            width: 100%;
            display: table-row;
            visibility: visible !important;
        }
        .flex-helper-row {
            display: flex;
            background-color: #f9f9f9;
            border: 1px solid #ddd;
            padding: 8px;
            width: 100%;
            box-sizing: border-box;
            align-items: center;
            z-index: 9999;
            }

        .flex-helper-cell {
            padding: 6px 12px;
            border-right: 1px solid #eee;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        .flex-helper-cell button {
            white-space: nowrap;
            margin-left: 5px;
        }


        /* Safari */
        @-webkit-keyframes spin {
            0% {
                -webkit-transform: rotate(0deg);
            }

            100% {
                -webkit-transform: rotate(360deg);
            }

        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }


        /* @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        } */
    </style>
    <?php hooks()->do_action('lead_modal_profile_bottom', (isset($lead) ? $lead->id : '')); ?>
    <script>
        var tinymce_draft_emails = {};
        <?php if (!empty($appt_client_email_draft)) : ?>
            <?php foreach ($appt_client_email_draft as $draft) : ?>
                tinymce_draft_emails['<?= $draft['editor_id'] ?>'] = <?= json_encode($draft['email_content']) ?>;
            <?php endforeach; ?>
        <?php endif; ?>
        $(document).ready(function () {
            // tincymac set and destroy
            // Function to destroy TinyMCE editors
            function destroyTinyMCE() {
                tinymce.remove();
                if (tinymce.editors.length > 0) {
                    tinymce.editors.forEach(function (editor) {
                        editor.remove();
                    });
                }
            }
            // Array of objects with form IDs, textarea IDs, and their corresponding initial content
            // reminder staff name and reminder date
            var lead_name = "<?php echo $lead->name; ?>";
            var all_borrower_first_name = "<?php echo $get_all_lead_borrower_first_name; ?>";
            var lead_loan_amount = "<?php echo $lead->loan_amount; ?>";
            var target_closing_date = "<?php echo $lead->excepting_closing_date; ?>";
            var formattedDate = '';
            if (target_closing_date) {
                var datePart = target_closing_date.split(' ')[0]; 
                var dateObj = new Date(datePart);
                var options = { day: 'numeric', month: 'long', year: 'numeric' };
                formattedDate = new Intl.DateTimeFormat('en-US', options).format(dateObj);
            }
            var get_latest_ledger_data = '';
            var confimation_broker_appt_latest_lenders = '';
            var void_check_content_show = '';
            var property_tax_statemnet_content = '';
            $.ajax({
                url: "<?php echo admin_url('leads/get_latest_lender_details/' . $lead->id); ?>",
                method: 'GET',
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        if (response.check_Insurance_Binder == 1) {
                            get_latest_ledger_data = response.ledger_data;
                            var lenderCount = response.ledger_data.length;
                            var lenderList = '<li>';
                            lenderList += '<span style="font-weight: 800;">Property Insurance</span>';
                            lenderList += '<p>Property Insurance document showing the new lender. Please call your current insurance provider. They should be able to make this amendment to your insurance policy over the phone and send an insurance binder by email or fax directly.</p>';
                            lenderList += '<ul>';
                            $.each(get_latest_ledger_data, function (index, lender) {
                                if (lender.bank_name || lender.lender_address) {
                                    lenderList += '<li>The new 2nd lender: ' + 
                                        (lender.bank_name ? lender.bank_name : '') + 
                                        (lender.lender_address ? ', ' + lender.lender_address : '') + 
                                        '.</li>';
                                }
                                lenderList +=  'Shows/confirms  “Guaranteed Replacement Cost”';
                                lenderList +=  'Shows/confirms  “Standard Mortgage Clause” ';
                                // if (lender.loan_amount) {
                                //     lenderList += '<li>Shows Guaranteed Replacement Cost Or Minimum coverage of ' + lender.loan_amount + '.</li>';
                                // }

                                if (lender.effective_date) {
                                    lenderList += '<li>Effective from: ' + formattedDate + '.</li>';
                                }
                                if (lenderCount > 1 && index < lenderCount - 1) {
                                    lenderList += '<hr style="border: 1px solid #000; margin: 20px 0;">';
                                }
                            });
                            lenderList += '</ul>';
                            // lenderList += '<p>If your property is a condominium, let us know immediately.</p>';
                            // lenderList += '<p>If you are adding/removing a party on title, please ensure they are added/removed on your policy.</p>';
                            lenderList += '<p>If you or your insurance provider needs any assistance with this please:</p>';
                                lenderList += '<ul>';
                                    lenderList += '<li>Call your insurance provider/broker and authorize them to speak with us.</li>';
                                    lenderList += '<li>Provide their contact name</li>';
                                    lenderList += '<li>Provide their contact number</li>';
                                    lenderList += '<li>Provide their contact email</li>';
                                    lenderList += '<li>Provide your policy number</li>';
                                    lenderList += '<li>Provide a copy of your existing policy</li>';
                                lenderList += '</ul>';
                            lenderList += '</li>';
                            lenderList += '<li>';
                            get_latest_ledger_data = lenderList;
                        }
                        // void check content show
                        if (response.check_Void_cheque == 1) {
                            void_check_content_show += '</li>';
                            void_check_content_show += '<li>';
                            void_check_content_show += '<span style="font-weight:800;">Void cheque</span>' + ' for the bank account from which mortgage payments will be made.';
                            void_check_content_show += '</li>';
                            void_check_content_show += '<li>';
                            void_check_content_show += '<span style="font-weight:800;">Void cheque</span>' + ' for the joint bank account or two separate accounts to which any surplus funds will be sent. This cannot be an online bank account such as Tangerine. We have received the void cheque for X. Kindly confirm if this is a joint account. If not, please provide one for Y.';
                            void_check_content_show += '<p>We have your cheque from X bank from your previous file. Kindly confirm if this account is still active.</p>';
                            void_check_content_show += '</li>';
                        }
                        // show the property tax statements
                        if (response.Property_tax_statement == 1) {
                            property_tax_statemnet_content += '<li>';
                            property_tax_statemnet_content += '<span style="font-weight:800;">A property tax statement/bill</span>' + ' showing the amount outstanding/paid for 2024. We have received your property tax bill. Kindly confirm if the X instalment has been paid. If so, please provide proof of payment.';
                            property_tax_statemnet_content += '</li>';
                        }
                        // confirmation appointment from broker 
                        var confirmation_lenderList = '<ul>';
                        var lenderCount = response.ledger_data.length;
                        $.each(response.ledger_data, function (index, lender) {
                            confirmation_lenderList += '<li>The new lender: ' + (lender.bank_name ? lender.bank_name : '') +
                                (lender.lender_address ? ', ' + lender.lender_address : '') + '</li>';
                            confirmation_lenderList += '<li>Shows Guaranteed Replacement Cost Or Minimum coverage of ' + lender.loan_amount + '.</li>';
                            confirmation_lenderList += '<li>Effective from: ' + (formattedDate || '') + '.</li>';
                            if (response.ledger_data.length > 1 && index < response.ledger_data.length - 1) {
                                confirmation_lenderList += '<hr style="border: 1px solid #000; margin: 20px 0;">';
                            }
                        });
                        confirmation_lenderList += '</ul>';
                        confimation_broker_appt_latest_lenders = confirmation_lenderList;
                        // $('#lender-details-container').append(lenderList); 
                    } else {
                        console.error('No lender data found.');
                    }
                },
                error: function (error) {
                    console.error('Error fetching lender details:', error);
                }
            });
            var reminder_staff_name = "<?php echo $reminder_staff_name; ?>";
            var reminder_date = "<?php echo $reminder_latest_date; ?>";
            var appt_location = "<?php echo $reminder_state_name;?>";
            var appt_location_address = "<?php echo $reminder_state_address;?>";
          

            var jsDate = new Date(reminder_date);
            // Example of using Moment.js for formatting
            var momentDate = moment(reminder_date);
            var formattedMomentDate = momentDate.format('dddd, MMMM D, [at] h:mma');
            // file_opened_broker_review_email data get
            // Function to retrieve checklist items HTML
            // ********************************
            // ********************************
            // ********* File opened review mail content  ************
            // ********************************
            // ********************************
            // ********************************
            function getChecklistItems() {
                var checklistItemsHTML = '';
                $('#file_opened_broker_all_checklist_review').find('li').each(function () {
                    checklistItemsHTML += '<li style="color:black;"><span style="color:red;">' + $(this).html() + '</span></li>';
                });
                return checklistItemsHTML;
            }

            // Call getChecklistItems after 5 seconds (5000 milliseconds)
            var file_opened_broker_review_checklist_data = '';
            setTimeout(function () {
                var checklistItems = getChecklistItems();
                file_opened_broker_review_checklist_data = checklistItems;
                $('#file_opened_email_selectedLabels_broker').html(checklistItems);

            }, 3000);
            // get the checklist for file opened review client email and appened all clients details
            function fetchChecklistItems_file_opened() {
                $.ajax({
                    url: "<?php echo admin_url('leads/get_file_opened_borrower_checklist_items/' . $lead->id); ?>",
                    method: 'GET',
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            var checklistItemsHTML = '';

                            // Group items by lead_borrow_id
                            var borrowerGroups = response.borrower_data.reduce(function (groups, item) {
                                var lead_borrow_id = item.lead_borrow_id || 'first';
                                if (!groups[lead_borrow_id]) {
                                    groups[lead_borrow_id] = [];
                                }
                                groups[lead_borrow_id].push(item);
                                return groups;
                            }, {});

                            // Sort the keys (lead_borrow_id) to ensure correct order
                            var sortedKeys = Object.keys(borrowerGroups).sort(function (a, b) {
                                // 'first' should be the first key, then others in ascending order
                                if (a === 'first') return -1;
                                if (b === 'first') return 1;
                                return parseInt(a) - parseInt(b);
                            });

                            // Generate HTML for each group in the sorted order
                            sortedKeys.forEach(function (lead_borrow_id, index) {
                                var group = borrowerGroups[lead_borrow_id];
                                checklistItemsHTML += '<div class="client-section">';
                                checklistItemsHTML += '<p style="color:red;"><strong>Client ' + (group[0].client_name ? group[0].client_name : 'First Borrower') + '</strong></p>';
                                checklistItemsHTML += '<ul style="color:black">';
                                group.forEach(function (item) {
                                    const rejectedReason = item.rejection_reason ? ` - ${item.rejection_reason}` : '';
                                    checklistItemsHTML += `<li style="color:black;"><span style="color:red;">${item.name}${rejectedReason}</span></li>`;
                                });
                                checklistItemsHTML += '</ul>';
                                checklistItemsHTML += '</div>';
                            });
                            // Append the generated HTML to the target container
                            $('#file_opened_client_review_all').html(checklistItemsHTML);
                        } else {
                            console.error('No checklist items found');
                        }
                    },
                    error: function (error) {
                        console.error('Error fetching checklist items:', error);
                    }
                });
            }
            // Fetch checklist items and populate the div
            fetchChecklistItems_file_opened();
            // Function to retrieve HTML content of all <ul> elements inside #file_opened_client_review_all
            function getAllHTMLContent(containerSelector) {
                var allHTMLContent = '';
                $(containerSelector).children().each(function () {
                    // Check if the element is a <ul> or <p> or other element
                    if ($(this).is('ul')) {
                        // If <ul>, iterate through <li> items
                        allHTMLContent += '<ul>';
                        $(this).find('li').each(function () {
                            allHTMLContent += '<li style="color:black;"><span style="color:red;">' + $(this).html() + '</span></li>';
                        });
                        allHTMLContent += '</ul>';
                    } else if ($(this).is('p')) {
                        // If <p>, append its HTML
                        allHTMLContent += '<p>' + $(this).html() + '</p>';
                    } else {
                        // For other elements (div, etc.), append their HTML
                        allHTMLContent += $(this).prop('outerHTML');
                    }
                });
                return allHTMLContent;
            }

            // Example usage:
            var containerSelector = '#file_opened_client_review_all';
            var allContent = '';
            setTimeout(function () {
                allContent = getAllHTMLContent(containerSelector);
                $('#file_opened_email_selectedLabels_client').html(allContent);
            }, 10000);
            // ********************************
            // ********************************
            // ********* File opened review mail content  end ************
            // ********************************
            // ********************************
            // ********************************
            // ********************************

            // ********************************
            // ********* Outstanding item and appointment review list review mail content  ************
            // ********************************
            // ********************************
            // ********************************
            function fetchChecklistItems_outstanding_item_appointment() {
                $.ajax({
                    url: "<?php echo admin_url('leads/outstanding_item_checklist_review_mail/' . $lead->id); ?>",
                    method: 'GET',
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            var checklistItemsHTML = '';
                            var rejected_reason = '';
                            response.borrower_data.forEach(function (item) {
                                const rejectedReason = item.rejection_reason ? ` - ${item.rejection_reason}` : '';
                                checklistItemsHTML += `<li>${item.name}${rejectedReason}</li>`;
                            });
                            // Populate the checklist items in the specified div
                            $('#appointment_outstanding_item_checklist_for_email_review').html(checklistItemsHTML);
                        } else {
                            console.error('No checklist items found');
                        }
                    },
                    error: function (error) {
                        console.error('Error fetching checklist items:', error);
                    }
                });
            }
            // call the function
            fetchChecklistItems_outstanding_item_appointment();
            // Fetch checklist items and populate the div
            var outstanding_appointment_review_email_content = '';
            function getChecklistItems_for_outstanding_appointment_email_review() {
                var outstanding_appointment_email_review_checklistItemsHTML = '';
                $('#appointment_outstanding_item_checklist_for_email_review').find('li').each(function () {
                    outstanding_appointment_email_review_checklistItemsHTML += '<li style="color:black;"><span style="color:red;">' + $(this).html() + '</span></li>';
                    outstanding_appointment_review_email_content = outstanding_appointment_email_review_checklistItemsHTML;
                });
                return outstanding_appointment_email_review_checklistItemsHTML;
            }

            // Call getChecklistItems after 5 seconds (5000 milliseconds)
            setTimeout(function () {
                var outstanding_item_data = getChecklistItems_for_outstanding_appointment_email_review();
                outstanding_appointment_review_email_content = outstanding_item_data;
                $('#outstanding_appointment_checklist_appened').html(outstanding_item_data);

            }, 9000);
            // ld team outstanding list
            var ld_team_outstanding_lists = '';
            $.ajax({
                url: "<?php echo admin_url('leads/get_ld_team_outstanding_checklist_email_review/' . $lead->id); ?>",
                method: 'GET',
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        ld_team_outstanding_lists = response.task_data;
                    } else {
                        console.warn('success false in this get_ld_team_outstanding_checklist_email_review');
                    }
                },
                error: function (error) {
                    console.error('Error fetching checklist items:', error);
                }
            });
            // ********************************
            // ********* Request for funds stage complete then hide and show the review mail and add the content
            // ********************************
            // ********************************
            // ********************************
            var add_extra_details_in_closed_mail_review = '';
            $('#req_complete_stage_question').off('change').on('change', function () {
                var selectedValue = $(this).val();
                if (selectedValue === 'yes') {
                    add_extra_details_in_closed_mail_review = '<p>Please note some funds have been held back. Once XXXXXXX has been completed/provided and the new lender confirms, any remaining held back funds will be sent to you.</p>';
                    // $('#closed_mail_review').slideDown();

                    // Append content to TinyMCE editor
                    var editor = tinymce.get('request_for_funds_review_email_tincymac');
                    var currentContent = editor.getContent();
                    var newContent = currentContent + add_extra_details_in_closed_mail_review;
                    editor.setContent(newContent, { format: 'raw' });
                } else {
                    // $('#closed_mail_review').slideUp();

                    // Remove the appended content from TinyMCE editor
                    var editor = tinymce.get('request_for_funds_review_email_tincymac');
                    var currentContent = editor.getContent();
                    var newContent = currentContent.replace(add_extra_details_in_closed_mail_review, '');
                    editor.setContent(newContent);
                }
            });
            // idv change content by different scanario
            var check_second_email_count = '<?php echo $all_clients_email_count['borrower_count'];?>';
            var idv_received_yes_or_yes = '';
            if(check_second_email_count > 0){
                idv_received_yes_or_yes = 'Once all parties have completed this process and';
            }else{
                idv_received_yes_or_yes = 'Once';
            }
            // Get the morning/Evening time message
            var current_canadian_time_msg = '<?php echo get_afternoon_and_morning();?>';
            // get checklist details for client file opened review
            setTimeout(function () {
                var tinymce_forms = [
                    {
                        formId: 'file_opened_broker_review_email',
                        editorId: 'file_opened_broker_email_review_tincymac',
                        content: '<h4>Dear Colleague</h4>' +
                            '<p>We hope this message finds you well.</p>' +
                            '<p>We are delighted to inform you that our team at Legal Direct has successfully received your new instruction, have opened a file and made initial contact with our mutual Client.</p>' +
                            '<p>We have reviewed your documents, and note that we require the following from your office:</p>' +
                            '<ul id="file_opened_email_selectedLabels_broker" class="selected-labels" style="list-style: disc;padding-left: 25px;color:black;">' +
                            file_opened_broker_review_checklist_data +
                            '<div id="file_opened_email_selectedLabels_client" class="selected-labels" style=" list-style: disc; padding-left: 25px;">' +
                            allContent +
                            '</div>' +
                            outstanding_appointment_review_email_content +
                            '<li>Condominium Status Certificate</li>' +
                            '<li>Condominium Insurance Certificate</li>' +
                            '</ul>' +
                            '<p>We have pulled the PIN and note there are no liens.</p>' +
                            '<p>We will pull the PIN and if there is a lien noted, we shall deal with this as per the order listed below:' +
                            '</p>' +
                            '<ol>' +
                            '<li>Due to a recent change in the law, we will check if we can apply to have this removed at the Land Registry on closing.</li>' +
                            '<li>Request for a postponement.</li>' +
                            '<li>Request a payout.</li>' +
                            '</ol>'
                    },
                    {
                        formId: 'FileOpenClientReviewMail',
                        editorId: 'file_opened_client_email_review_tincymac',
                        content: '<p>Dear ' + all_borrower_first_name + '</p>' +
                            '<p>Thank you for choosing Legal Direct for your transaction.</p>' +
                            '<p>For your ease, convenience, and safety, where possible, we aim to provide advice on your transaction remotely and by video conference.</p>' +
                            '<p>As per the 2024 Law Society of Ontario regulations, for all virtual appointments, we are now required to electronically AUTHENTICATE and also VERIFY your identification.</p>' +
                            '<span style="font-weight:800px;">PHOTO IDs:</span>' +
                            '<ul>' +
                            '<li>Please provide TWO Photo IDs from the Photo ID section.</li>' +
                            '<li>If you do not have two Photo IDs, please provide at least ONE Photo ID and ONE Secondary ID.</li>' +
                            '<li>All IDs MUST be in colour.</li>' +
                            '<li>Please ensure IDs show ALL edges, are CLEAR, have no flash spots, and are valid (NOT expired).</li>' +
                            '</ul>' +
                            '<span style="font-weight:800px;">PAPER IDs:</span>' +
                            '<ul><li>Please provide ONE FINANCIAL or UTILITY paper ID such as bank/credit card/mortgage statement or hydro/enbridge/tax bill. These must each show your name, address and be issued within the last 180 days.</li></ul>' +
                            '<p>We have received some IDs from your broker, and we are now only outstanding the following:</p>' +
                            '<div id="file_opened_email_selectedLabels_client" class="selected-labels" style="color: red; list-style: auto; padding-left: 25px;">' +
                            allContent +
                            '</div>' +
                            '<p>Once we have your ID, we will then send you an ID link to electronically VERIFY your identification.</p>' +
                            '<p>If you wish to progress your case even more swiftly, please see the next email being sent to you and download our app “LEGAL DIRECTLY”. This will allow you to track your case in real time and upload IDs etc using a secure application.</p>'
                    },
                    {
                        formId: 'FileOpen_Outstanding_ClientReview_Mail',
                        editorId: 'file_opened_client_email_review_outstanding_tincymac',
                        content: '<p>Dear ' + all_borrower_first_name + '</p>' +
                            '<p>Please provide the following ID’s to progress your file:</p>' +
                            '<div id="file_opened_email_selectedLabels_client" class="selected-labels" style="color: red; list-style: auto; padding-left: 25px;">' +
                            allContent +
                            '</div>'
                    },
                    {
                        formId: 'id_verification_attachment_received',
                        editorId: 'idv_done_through_ot_docsign_tincymac',
                        content: 'Dear <span class="idv_client_name_begin">' + lead_name + '</span>,<br><br>' +
                            '<p>Thank you for sending the requisite ID’s.</p>' +
                            '<p>As per the 2024 Law Society of Ontario regulations, for all virtual appointments, we are now required to electronically VERIFY your ID.</p>' +
                            '<p>To electronically verify your ID, please follow the instructions in the email or text that you will receive shortly from “DocuSign”.</p>' +
                            '<p>Please ONLY use the PHOTO ID you provided to us previously.</p>' +
                            '<p>Once you have completed this ID verification, we receive the clear results and your mortgage instructions, we will then contact you to book an appointment to go through your real estate legal documents.</p>' +
                            '<p>Please let us know if you require any assistance.</p>'
                    },
                    {
                        formId: 'id_verification_attachment_received',
                        editorId: 'idv_done_through_ot_fct_tincymac',
                        content: 'Dear <span class="idv_client_name_begin">' + lead_name + '</span>,<br><br>' +
                            '<p>Thank you for sending the requisite ID’s.</p>' +
                            '<p>As per the 2024 Law Society of Ontario regulations, for all virtual appointments, we are now required to electronically VERIFY your ID.</p>' +
                            '<p>To electronically verify your ID, please follow the instructions you will receive in the email that you will receive shortly from “FCT/Bluink”.</p>' +
                            '<p>Please ONLY use the PHOTO ID you provided to us previously. FCT/Bluink may ask you to use 2 pieces of photo ID but you may use just the one you provided to us.</p>' +
                            '<p>The lender or their lawyer may later on in the process send you a further email from FCT/Bluink and you may have already passed through that process successfully. If so, when you receive the second email for their verification purposes, you should also receive an alert pop-up on your phone stating that firm wants to reverify your ID. Please then open the app, click OK, and then you should have completed the process for them too.</p>' +
                            '<p>Once you have completed this ID verification, we receive the clear results and your mortgage instructions, we will then contact you to book an appointment to go through your real estate legal documents.</p>' +
                            '<p>Please let us know if you require any assistance.</p>'
                    },
                    {
                        formId: 'id_verification_attachment_received',
                        editorId: 'idv_done_through_ot_hosper_tincymac',
                        content: 'Dear <span class="idv_client_name_begin">' + lead_name + '</span>,<br><br>' +
                            '<p>Thank you for sending the requisite ID’s.</p>' +
                            '<p>As per the 2024 Law Society of Ontario regulations, for all virtual appointments, we are now required to electronically VERIFY your ID.</p>' +
                            '<p>To electronically verify your ID, please follow the instructions in the email or text that you will receive shortly from “DocuSign”.</p>' +
                            '<p>Please ONLY use the PHOTO ID you provided to us previously.</p>' +
                            '<p>The lender or their lawyer may later on in the process send you a further email from FCT/Bluink which is their provider for ID Verification. If so please follow the instructions you will receive in that email. FCT/Bluink may ask you to use 2 pieces of photo ID but you may use just the one you provided to us.</p>' +
                            '<p>Once you have completed this ID verification, we receive the clear results and your mortgage instructions, we will then contact you to book an appointment to go through your real estate legal documents.</p>' +
                            '<p>Please let us know if you require any assistance.</p>'
                    },
                    {
                        formId: 'id_verification_attachment_received',
                        editorId: 'idv_done_through_other_tincymac',
                        content: 'Dear <span class="idv_client_name_begin">' + lead_name + '</span>,<br><br>' +
                            '<p>Thank you for sending the requisite ID’s.</p>' +
                            '<p>As per the 2024 Law Society of Ontario regulations, for all virtual appointments, we are now required to electronically VERIFY your ID.</p>' +
                            '<p>To electronically verify your ID, please follow the instructions in the email or text that you will receive shortly from the <span style="color:red;">xxxxx</span>.</p>' +
                            '<p>Please ONLY use the PHOTO ID you provided to us previously.</p>' +
                            '<p>Once you have completed this ID verification, we receive the clear results and your mortgage instructions, we will then contact you to book an appointment to go through your real estate legal documents.</p>' +
                            '<p>Please let us know if you require any assistance.</p>'
                    },
                    {
                        formId: 'id_verification_attachment_received',
                        editorId: 'idv_received_no_tinymce',
                        content: 'Dear <span class="idv_client_name_receive">' + lead_name + '</span>,<br><br>' +
                            '<p>This is Legal Direct. As per our previous message, please complete the ID Verification process to enable your file to move forward.</p>'
                    },
                    {
                        formId: 'id_verification_attachment_received',
                        editorId: 'idv_received_yes_pass_yes_tinymce',
                        content: 'Dear <span class="idv_client_name_receive">' + lead_name + '</span>,<br><br>' +
                            '<p>This is Legal Direct. Congratulations your case has progressed through another milestone. Your ID has been verified. ' + idv_received_yes_or_yes + ' we have the mortgage documents from your new lender we shall set an appointment with you.</p>'
                    },
                    {
                        formId: 'id_verification_attachment_received',
                        editorId: 'idv_received_yes_pass_no_tinymce',
                        content: 'Dear <span class="idv_client_name_receive">' + lead_name + '</span>,<br><br>' +
                            '<p>This is Legal Direct. We have received the results of your ID Verification process. Please contact our office on 9057872296 to discuss next steps.</p>'
                    },
                    {
                        formId: 'ins_received_initial_email_to_laywer_fromid',
                        editorId: 'ins_received_initial_email_to_laywer_editorid',
                        content: '<p>Thank you for the mortgage instructions, we shall review and revert  with any questions.</p>' +
                                '<p>For IDV purposes, please note the clients email addresses are as follows:</p>' +
                                '<p>Xxxxxxxxx, ffffg@dsffffsf.com</p>' +
                                '<p>Yyyyyyyy, ggg@ddjdjddj.com</p>'

                    },
                    {
                        formId: 'ins_received_email_to_laywer_fromid',
                        editorId: 'ins_received_email_to_laywer_editorid',
                        content: ''
                    },
                    {
                        formId: 'preliminary_instruction_rece_formid',
                        editorId: 'preliminary_instruction_received_editorid',
                        content: 'Dear <span class="idv_client_name_begin">' + lead_name + '</span>,<br><br>' +
                            '<p>We expect the package of mortgage documents for your new product in due course.</p>' +
                            '<p>I appreciate you may have already provided some documentation to us or your mortgage broker however the mortgage lender will require a number of items from you before closing.</p>' +
                            '<p>You may want to begin gathering these documents together:</p>' +
                            '<p>1)  Your current <span style="font-weight:800;">property Insurance</span> document showing the name of the insurance company, the policy number and the contact details of any insurance broker. </p>' +
                            '<strong style="font-weight:800;">Please note, the new lender’s details are required to be added to your current home insurance policy once we receive formal mortgage instructions. </strong>' +
                            '<p>2) <span style="font-weight:800;">A property tax statement/bill</span> showing the amount outstanding/paid for 2025. We have received your property tax bill. Kindly confirm if the balance showing has been paid. If so, please provide proof of payment.' +
                            '<p>3) <span style="font-weight:800;">A void cheque</span> for the bank account from which mortgage payments will be made.</p>' +
                            '<p>4) <span style="font-weight:800;">Additionally, a void cheque</span> for the joint bank account or two separate accounts to which any surplus funds will be sent.</p>' +
                            '<p style="color:red;">we have received the void cheque for X. Kindly confirm if this is a joint account and provide another void cheque/bank statement with the other name to show this is a joint account. If not, please provide one for Y.</p>' +
                            '<p style="color:red;">we have your cheque from X bank from your previous file. Kindly confirm if this account is still active.</p>' +
                            '<p>5) <span style="font-weight:800;">Condominium Status Certificate</span> confirming you are up-to-date will all charges due to the condo corporation. <span style="color:red;">If you do not have this, please ensure you order this from the condo corporation as soon as possible if you have not done so already.</span></p>' +
                            '<p>6) <span style="font-weight:800;">Condominium Insurance Certificate</span> confirming the entire building is insured.</p>' 
                    },
                    {
                        formId: 'AppointmentBrokereviewMail',
                        editorId: 'appointment_broker_email_review_tincymac',
                        content: '<p>Dear Colleague</p>' +
                            '<p>We are delighted to inform you that the file has successfully moved through another milestone, the appointment with the Client has been completed.</p>' +
                            '<p>Today’s meeting went well.</p>' +
                            '<p>The items we still require from the client are:</p>' +
                            '<ul class="outstanding_appointment_checklist_appened" style="color:black;">' +
                            outstanding_appointment_review_email_content +
                            '</ul>' +
                            '<p>We require no further items from the clients.</p>' +
                            '<p>Items that we are following up on from third parties are:</p>' +
                            '<ul style="color:black;">' +
                            ld_team_outstanding_lists +
                            '</ul>' +
                            '<p>We require no further items from third parties.</p>' +
                            '<p>In view of the above we anticipate the file should be ready to move towards closing in approximately 3-5 days.</p>'
                    },
                    {
                        formId: 'emailForm',
                        editorId: 'appointment_client_emailContent',
                        // content: reminder_staff_name + '; Meeting Invitation with Legal Direct<br><br>' +
                        content: 'Meeting Invitation with Legal Direct<br><br>' +
                            // 'Dear ' + lead_name + ',<br><br>' + 
                            'Dear ' + all_borrower_first_name + ',<br><br>' +
                            'We are pleased to confirm we have now received your mortgage offer package.<br><br>' +
                            '<p>Would you BOTH be available to meet our lawyer, at our ' + appt_location + ' office, ' + appt_location_address + ' on <span style="font-weight: bold;">' + formattedMomentDate + '</span> to go through the documentation?</p>' +
                            '<p>Once you have confirmed the meeting to us, just before the meeting we will send you a link for Zoom and DocuSign. Please ensure you have the Zoom app downloaded on your smartphone/computer from the app/google play store prior to your meeting.</p>' +
                            '<ul>' +
                            '<li>The DocuSign app will ask you to use either a pre-loaded font or to use your mouse/finger to sign and initial. Using your own handwritten signature and initials are preferable.</li>' +
                            '<li>Please ensure you have the original IDs that you’ve sent to us previously to show on camera at the meeting.</li>' +
                            '<li>The new lender performs additional random ID checks, you may therefore receive an email or text to complete this process. Please follow the steps in that message and have your photo ID ready to complete the process. The email may be from “FCT” for their app “e-IDme”. Or from “Chicago Title” for their product “VerifID”. Or from “Stewart Title” for their app “TitlePLUS”.</li>' +
                            '</ul>' +
                            '<p>For the mortgage offer conditions please send us as many of the items from the list below before the meeting:</p>' +
                            '<ol>' +
                            get_latest_ledger_data +
                            '<li>' +
                            '<span style="font-weight: 800;">Improvements and Betterments Insurance Certificate</span>' +
                            '<p>For the property not covered by the condo insurance mentioning the new lender. Please call your current insurance provider. They should be able to send you a copy by email.</p>' +
                            '<ul>' +
                            '<li>The new 1st or 2nd lender: Hosper Mortgage, in trust, 200 - 21 St. Clair Avenue East, Toronto, ON M4T 1L9</li>' +
                            '<li>Effective from: April 2023.</li>' +
                            '</ul>' +
                            '</li>' +
                            '<li>' +
                            '<span style="font-weight:800;">Condominium Status Certificate</span>' + ' confirming you are up-to-date will all charges due to the condo corporation. Please ensure you order this from the condo corporation as soon as possible if you do not have this already.' +
                            '</li>' +
                            '<li>' +
                            '<span style="font-weight:800;">Condominium Insurance Certificate</span>' + ' confirming the entire building is insured.' +
                            void_check_content_show +
                            '<li>' +
                            '<span style="font-weight:800;">Twelve monthly cheques</span>' + ' made payable to NEW LENDER for $ commencing APRIL 1st, 2023 and ending March 1st, 2024. Please have these written out before the meeting. These must be personal cheques not company cheques. We recommend you also send us two blank but signed cheques, in the event there is a typographical error. We may shred/return these if not used. Please send us an image of the cheques prior to sending them to us so we may verify the details on the cheques.' +
                            '<p>Kindly confirm if you have a printer, so we may send you a courier slip to return the cheques to us</p>' +
                            '</li>' +
                            property_tax_statemnet_content +
                            '<li>' +
                            '<span style="font-weight:800;">Please note, in your new transaction, the new lender has stated that only the below credit card/loans are to be paid by us on closing. For each one, please provide the most recent statement or online printout with the account number and an address where to send the payment:</span>' +
                            '<ul>' +
                            '<li>approximate balance $ (received)</li>' +
                            '<li>approximate balance $</li>' +
                            '<li>approximate balance $</li>' +
                            '<li>approximate balance $</li>' +
                            '<li>approximate balance $</li>' +
                            '</ul>' +
                            '<span>If there are debts on NAC but none of them conditioned, keep the below (4) in the meeting email.</span>' +
                            '</li>' +
                            '<li>' +
                            '<span> Your new lender has not asked us to pay any credit card/loans, it’ll be your responsibility to make the payments to any credit cards/loans you wish to pay after closing using any net proceeds.</span>' +
                            '</li>' +
                            '<li>' +
                            '<p>Please also confirm by return email if you are married. If so, include your spouse’s full name as they may have to also sign some documents.</p>' +
                            '</li>' +
                            '<li>' +
                            '<p>Please also confirm by return email that you are married to one another.</p>' +
                            '</li>' +
                            '<li>' +
                            '<p>Please also confirm by return email that at the time of your separation this property was not the family home. Or if there is a separation agreement in place.On the other hand, if it was the family home or there is no separation agreement then I will need your spouse’s full name as they may have to also sign some documents.</p>' +
                            '</li>' +
                            '<li>' +
                            '<span style="font-weight:800;">Death certificate of </span>' + 'X. Please let us know if you have a copy to courier to us so we may review this. We may return this to you if you would like. Also, inform us if you have a printer so we may send you a courier slip.' +
                            '</li>' +
                            '<li>' +
                            '<span style="font-weight:800;">Your modular/mobile home details:</span>' +
                            '<ul>' +
                            '<li>Manufacturer</li>' +
                            '<li>Model Number</li>' +
                            '<li>Serial Number</li>' +
                            '<li>Model Year</li>' +
                            '</ul>' +
                            '</li>' +
                            '<li>' +
                            '<p>Please note we will be removing James, Gregory, and Stephanie from title. As the transferors in this transaction, they will need to obtain independent legal advice from another lawyer. Kindly let us know if they have their own lawyers, if not, we can arrange for a local lawyer to meet with them</p>' +
                            '</li>' +
                            '</ol>'
                    },
                    {
                        formId: 'broker_appointment_emailForm',
                        editorId: 'appointment_confirm_broker_emailContent',
                        content: '<p>Hello,</p>' +
                            '<p>We have received the new mortgage offer and are liaising with the client over a suitable appointment date.</p>' +
                            '<p>We have also asked the borrower to add the below new lender to their current home insurance policy by calling their current insurance provider/broker.</p>' +
                            '<p>The insurance company/broker should be able to make this amendment over the phone and send a confirmation binder by email or fax directly to us or the borrower:</p>' +
                            confimation_broker_appt_latest_lenders +
                            '<p>We have reviewed your documents, and note that we require the following from your office:</p>' +
                            '<ul id="file_opened_email_selectedLabels_broker" class="selected-labels" style="list-style: disc;padding-left: 25px;color:black;">' +
                            file_opened_broker_review_checklist_data +
                            '</ul>'
                    },
                    {
                        formId: 'after_appointment_email_send_to_client',
                        editorId: 'after_appointment_emailContent',
                        content: '<p>Thank you for meeting with us today.</p>' +
                                '<p>As discussed, please provide the following items to progress your transaction:</p>' +
                                '<ul class="outstanding_appointment_checklist_appened" style="color:black;">' +
                                    outstanding_appointment_review_email_content +
                                '</ul>'
                    },
                    {
                        formId: 'lender_appointment_emailForm',
                        editorId: 'appointment_confirm_lender_emailContent',
                        content: '<p>Dear Colleague</p>' +
                                '<p>Please note the appointment with or client to sign the mortgage documents is tentatively set for ' + formattedDate + '.'
                    },
                    {
                        formId: 'broker_outstanding_emaii_review',
                        editorId: 'broker_outstanding_review_email_tincymac',
                        content: '<p>Dear Colleague</p>' +
                            '<p>We are currently chasing items the following items from the Client to progress the file:</p>' +
                            '<ul class="outstanding_appointment_checklist_appened" style="color:black;">' +
                            outstanding_appointment_review_email_content +
                            '</ul>' +
                            '<p>If you have any of these, kindly share them with us,</p>' +
                            '<p>We are also chasing the client directly.</p>'
                    },
                    {
                        formId: 'client_outstanding_emaii_review',
                        editorId: 'client_outstanding_review_email_tincymac',
                        content: '<p>Dear ' + all_borrower_first_name + '</p>' +
                            '<p>We currently still require the following items to progress your file, please email them to us at your earliest convenience:</p>' +
                            '<ul class="outstanding_appointment_checklist_appened" style="color:black;">' +
                            outstanding_appointment_review_email_content +
                            '</ul>'
                    },
                    {
                        formId: 'complete_stage_request_for_funds',
                        editorId: 'request_for_funds_review_email_tincymac',
                        content: '<p>Good ' + current_canadian_time_msg + ',</p>' +
                            '<p>We are pleased to confirm the transaction has closed.</p>' +
                            '<p>For any funds due to you, we aim to deposit these over the counter at your bank within 1 business day of closing. The net funds are issued using a certified Trust lawyer’s cheque, these funds leave our account instantly. You can contact your bank if a hold is placed on your funds, we have no control over that. For net funds for accounts with Credit Unions, Presidents Choice and Manulife, we are required to wire funds, this may take a few days to show in your account.</p>' +
                            '<p>For any credit card payments, where aim to pay them at a bank within 1 business day of closing. Please allow up to 14 days for the recipient company to process them and to update your account. Again, we have no control over that</p>' +
                            '<p>In the interests of the environment and efficiency, we attach a copy of the documents you signed together with our report, the distribution of all funds is at the end of the attachment.</p>' +
                            '<div style="color:red;">' +
                            add_extra_details_in_closed_mail_review +
                            '</div>'
                    },
                    {
                        formId: 'upload_doc_for_ledger',
                        editorId: 'send_approved_ledger_to_broker_tinymce',
                        content: '<p>Dear Colleague,</p>' +
                            '<p>Please see the attached ledgers for review. We are now moving to closing, kindly update your records.</p>'
                    },
                    {
                        formId: 'confirm_final_closing_internally',
                        editorId: 'send_tinymace_final_ledger_cofirm_final_close_email',
                        content: '<p>Dear Colleague,</p>' +
                            '<p>Discharge in/Closing now being confirmed/Please proceed with banking.</p>'
                    },
                    {
                        formId: 'outbox_forward_email',
                        editorId: 'send_tinymace_outbox_forward_email',
                        content: ''
                    },
                ];
                // tinymce_forms.forEach(function (formData) {
                //     // styleselect fontselect
                //     tinymce.init({
                //         selector: '#' + formData.editorId,
                //         plugins: 'code lists textcolor',
                //         toolbar: 'undo redo | bold italic | forecolor backcolor | styleselect | fontsizeselect | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | code',
                //         setup: function (editor) {
                //             editor.on('init', function () {
                //                 editor.setContent(formData.content);
                //             });
                //         },
                //         font_family_formats: 'Arial=arial,helvetica,sans-serif;Times New Roman=times new roman,times;Courier New=courier new,courier;Georgia=georgia,palatino;Verdana=verdana,geneva',
                //         fontsize_formats: '8pt 10pt 12pt 14pt 18pt 24pt 36pt',
                //         menubar: false,
                //         content_style: "@import url('https://fonts.googleapis.com/css2?family=Oswald&display=swap');",
                //     });
                // });
                tinymce_forms.forEach(function (formData) {
                    const editorId = formData.editorId;

                    // Draft override logic
                    let contentToUse = formData.content;
                    if (typeof tinymce_draft_emails !== 'undefined' && tinymce_draft_emails[editorId]) {
                        const draftContent = tinymce_draft_emails[editorId];
                        if (typeof draftContent === 'string' && draftContent.trim() !== '') {
                            contentToUse = draftContent;
                        }
                    }

                    tinymce.init({
                        selector: '#' + editorId,
                        plugins: 'code lists textcolor',
                        toolbar: 'undo redo | bold italic | forecolor backcolor | styleselect | fontsizeselect | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | code',
                        setup: function (editor) {
                            editor.on('init', function () {
                                editor.setContent(contentToUse);
                            });
                        },
                        font_family_formats: 'Arial=arial,helvetica,sans-serif;Times New Roman=times new roman,times;Courier New=courier new,courier;Georgia=georgia,palatino;Verdana=verdana,geneva',
                        fontsize_formats: '8pt 10pt 12pt 14pt 18pt 24pt 36pt',
                        menubar: false,
                        content_style: "@import url('https://fonts.googleapis.com/css2?family=Oswald&display=swap');",
                    });
                });
            }, 18000);
            $(document).off('click', 'button.close').on('click', 'button.close', function () {
                var ancestorWithId = $(this).closest('[id]');
                if (ancestorWithId.attr('id') == "lead-modal") {
                    localStorage.setItem('timeline_flag', '0');
                    destroyTinyMCE();
                }
            });
            // timeline code
            
            var current_staff_role = '<?php echo $current_staff_role;?>';
            if(current_staff_role != 2 || current_staff_role != 6){
                $('.stepper-item').off('click').on('click', function () {
                    $('.stepper-item').removeClass('step-active');
                    $(this).addClass('step-active');
                    $('.tab_active_remove').removeClass('active');
                });
                $('li[role="presentation"] a').off('click').on('click', function () {
                    $('.stepper-item').removeClass('step-active');
                });
            }
            if(current_staff_role == 2 || current_staff_role == 6){
                document.addEventListener('click', function () {
                    const tabsUl = document.querySelector('.nav-tabs-horizontal');
                    if (tabsUl) {
                        tabsUl.style.padding = '15px';
                        tabsUl.style.display = 'flex';
                        tabsUl.style.justifyContent = 'space-between';
                        tabsUl.style.alignItems = 'center';
                    }
                });
            }
            // timeline code
            var lead_status_index = '<?php echo autoMoveToStage($current_lead_status);?>';
            var timeline_flag = localStorage.getItem('timeline_flag');
            if (timeline_flag == '' || timeline_flag == 0) {
                
                localStorage.setItem('timeline_flag', '1');
                $('.stepper-item').each(function () {
                    if ($(this).data('id') == lead_status_index) {
                        $(this).find('a')[0].click(); 
                    }
                });

                $('.stepper-item').off('click').on('click', function () {
                    if (!$(this).hasClass('step-active')) { 
                        $('.stepper-item').removeClass('step-active');
                        $(this).addClass('step-active');
                        $('.tab_active_remove').removeClass('active');
                        $(this).find('a')[0].click();
                    }
                });

                $('li[role="presentation"] a').off('click').on('click', function () {
                    $('.stepper-item').removeClass('step-active');
                });
            }
            // file note tab active when click on upper file note tab
            $('#top_file_note_show_tab').off('click').on('click', function (e) {
                e.preventDefault();
                $('#lead_notes_tab').click();
            });

        });

    </script>
    <script>
        // outstanding items stage client sms code 
        document.querySelectorAll('.limited-textarea').forEach(textarea => {
            const wordLimit = parseInt(textarea.getAttribute('data-word-limit'));
            const counter = textarea.nextElementSibling;

            textarea.addEventListener('input', function () {
                let words = textarea.value.trim().split(/\s+/).filter(function (word) {
                    return word.length > 0;
                });
                let wordCount = words.length;

                if (wordCount > wordLimit) {
                    words = words.slice(0, wordLimit);
                    textarea.value = words.join(' ');
                    wordCount = wordLimit;
                }

                counter.textContent = `${wordCount}/${wordLimit} words`;
            });

            textarea.addEventListener('keydown', function (event) {
                let words = textarea.value.trim().split(/\s+/).filter(function (word) {
                    return word.length > 0;
                });
                if (words.length >= wordLimit && event.key !== "Backspace" && event.key !== "Delete" && !event.ctrlKey && !event.metaKey) {
                    event.preventDefault();
                }
            });
        });
        function destroyTinyMCE() {
            tinymce.remove();
            if (tinymce.editors.length > 0) {
                tinymce.editors.forEach(function (editor) {
                    editor.remove();
                });
            }
        }
        function appendInputAndRemovePrevious_for_fileopened(name, value) {
            $('#file_opened_modal_upload_doc_form').find('input[name="' + name + '"]').remove();
            $('#file_opened_modal_upload_doc_form').append('<input type="hidden" name="' + name + '" value="' + value + '">');
        }
        function appendInputAndRemovePrevious_for_oustanding_item(name, value) {
            $('#outstanding_item_modal_upload_doc_form').find('input[name="' + name + '"]').remove();
            $('#outstanding_item_modal_upload_doc_form').append('<input type="hidden" name="' + name + '" value="' + value + '">');
        }
        function appendInputAndRemovePrevious_for_ld_outstanding_item(name, value) {
            $('#ld_outstanding_item_modal_upload_doc_form').find('input[name="' + name + '"]').remove();
            $('#ld_outstanding_item_modal_upload_doc_form').append('<input type="hidden" name="' + name + '" value="' + value + '">');
        }
        function appendInputAndRemovePrevious_for_request_for_funds(name, value) {
            $('#request_for_funds_modal_upload_doc_form').find('input[name="' + name + '"]').remove();
            $('#request_for_funds_modal_upload_doc_form').append('<input type="hidden" name="' + name + '" value="' + value + '">');
        }
        function appendInputAndRemove_ledger_fields(ledger_status_field_name, ledger_status_value, ledger_id_field_name, ledger_id_value, ledger_number_field, ledger_number_value) {
            $('#ledgers_comments_by_bb').find('input[name="' + ledger_id_field_name + '"]').remove();
            $('#ledgers_comments_by_bb').append('<input type="hidden" name="' + ledger_id_field_name + '" value="' + ledger_id_value + '">');
            $('#ledgers_comments_by_bb').find('input[name="' + ledger_status_field_name + '"]').remove();
            $('#ledgers_comments_by_bb').append('<input type="hidden" name="' + ledger_status_field_name + '" value="' + ledger_status_value + '">');
            $('#ledgers_comments_by_bb').find('input[name="' + ledger_number_field + '"]').remove();
            $('#ledgers_comments_by_bb').append('<input type="hidden" name="' + ledger_number_field + '" value="' + ledger_number_value + '">');
        }
        function appendInputField_ledger_for_broker() {
            var inputField = '<input type="hidden" id="ledger_type" name="type" value="broker" class="type-input" />';
            $('#upload_doc_for_ledger').append(inputField);
        }

        // Function to remove the input field
        function removeInputField_ledger_for_broker() {
            $('#upload_doc_for_ledger .type-input').remove();
        }
        function capitalizeFirstLetter(string) {
            return string.charAt(0).toUpperCase() + string.slice(1);
        }
        function appened_input_of_checklist_id(form_id, field_name, value) {
            $(form_id).append('<input type="hidden" name="' + field_name + '" value="' + value + '">');
        }
        function remove_input_of_checklist_id(form_id, field_name, value) {
            $(form_id).find('input[name="' + field_name + '"]').remove();
        }
        $(document).ready(function () {
            $('#rejection_reason_close_button').click(function () {
                var taskId = $('#statusChangeModal').data('id');
                // Iterate over each select element with the specified data-task-id
                $('.status-select').each(function () {
                    var $select = $(this);
                    var taskId = $select.data('task-id');
                    var initiallySelectedOption = $select.find('option[selected]');
                    var initialValue = initiallySelectedOption.text();
                    $select.find('option').each(function () {
                        if ($(this).text() === initialValue) {
                            $(this).prop('selected', true);
                        } else {
                            $(this).prop('selected', false);
                        }
                    });
                });
                // Remove the data-id attribute
                // Hide the modal
                $('#statusChangeModal').modal('hide');
            });
            var latestActivityHtml = $('#lead_activity .feed-item:first-child .text').html();
            // Insert the content into the another-section container
            $('#lead-latest-activity').html(latestActivityHtml);
        }); // lead notes validation

        appValidateForm($('#lead-notes'), {
            lead_note_description: 'required',
        });
        // complete stage button disabled to able
        $.ajax({
            url: "<?php echo admin_url('leads/stage_complete_button_visibility/' . $lead->id); ?>",
            type: 'GET',
            success: function (response) {
                if (response.success == 1) {
                    if (response.file_opened_complete_stage_button) {
                        $('#complete_stage1').removeAttr('disabled');
                    }
                }
            },
            error: function (error) {
            }
        });
        // change DL status
        $(document).off('change', '#dl-status-select').on('change', '#dl-status-select', function () {
            var newStatus = $(this).val();
            var task_id = $(this).data('task-id');
            var lead_id = $('#lead_id').val();
            $('.full-page-loader').show();
            $.ajax({
                url: "<?php echo admin_url('leads/dl_checklist_updateStatus'); ?>",
                type: 'POST',
                data: {
                    task_id: task_id,
                    newStatus: newStatus,
                    lead_id: lead_id,
                },
                success: function (response) {
                     $('.full-page-loader').hide();
                    alert_float('success', 'DL-Check status updated successfully.');
                },
                error: function (error) {
                     $('.full-page-loader').hide();
                    alert_float('danger', 'DL-Check status cannot remain pending. Please update the status to proceed.');
                }
            });
        });
        // Broker fee agremmetn N/A check 
        // $(document).off('change', '#broker_fee_agreement_na_checkbox').on('change', '#broker_fee_agreement_na_checkbox', function () {
        //     let taskId = $(this).data('task-id');
        //     let isChecked = $(this).is(':checked') ? 1 : 0;

        //     $.ajax({
        //         url: "<?php echo admin_url('leads/broker_fee_na_check/' . $lead->id); ?>",
        //         method: 'POST',
        //         data: {
        //             task_id: taskId,
        //             broker_fee_na: isChecked,
        //             // _token: $('meta[name="csrf-token"]').attr('content')
        //         },
        //         success: function (response) {
        //             if (response.success) {
        //                 alert_float('success', 'Broker fee agreement N/A status updated successfully.');
        //             } else {
        //                 alert_float('success', 'Broker fee agreement N/A status updated successfully.');
        //             }
        //             if(isChecked == 1){
        //                 $('#status_select_' + taskId).attr('disabled', true);
        //             }else{
        //                 $('#status_select_' + taskId).removeAttr('disabled');
        //             }
        //         },
        //         error: function (xhr) {
        //             console.error('Error:', xhr.responseText);
        //         }
        //     });
        // });
        // Change the status of checklist
        $(document).off('change', '.status-select').on('change', '.status-select', function () {
            var sameGroup = '<?php echo $samegroup; ?>';
            var task_id = $(this).data('task-id');
            var newStatus = $(this).val();
            var lead_id = $('#lead_id').val();

            if (newStatus === '3') {
                // Open the modal
                $('#statusChangeModal').modal('show');
                $('#statusChangeModal').attr('data-id', task_id);
                // Scroll the modal into view
                setTimeout(function () {
                    $('#statusChangeModal').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                }, 200);
                $('#submitStatusChange').off('click').on('click', function () {
                    var rejectionReason = $('#rejectionReason').val();
                    if (rejectionReason.trim() === '') {
                        $('#rejectionReason').addClass('is-invalid').next('.invalid-feedback').show();
                    } else {
                        $('#rejectionReason').removeClass('is-invalid').next('.invalid-feedback').hide();
                        $('#rejection_reason_loader').addClass('loader');
                        $('#submitStatusChange').prop('disabled', true);
                        $.ajax({
                            url: "<?php echo admin_url('leads/checklist_updateStatus'); ?>",
                            type: 'POST',
                            data: {
                                task_id: task_id,
                                lead_id: lead_id,
                                newStatus: newStatus,
                                rejectionReason: rejectionReason
                            },
                            success: function (response) {
                                if (response.success == 1) {
                                    $('#rejection_reason_loader').removeClass('loader');
                                    $('#submitStatusChange').prop('disabled', false);
                                    $('#rejection_reason_close_button').trigger('click');
                                    var anchor = document.querySelector('#rejection_reason_close_button');
                                    anchor.click();
                                    setTimeout(function () {
                                        destroyTinyMCE();
                                        _lead_init_data(response, response.id);
                                        $('a[href="' + response.leads_status + '"]').tab('show');
                                        if (sameGroup != 2) {
                                            $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                        }
                                        $('#rejection_reason_close_button').trigger('click');
                                        var anchor = document.querySelector('.close');
                                        anchor.click();
                                        $('#rejectionReason').val('');
                                        alert_float('success', 'Checklist status updated successfully.');
                                    }, 500);
                                } else {
                                    $('#submitStatusChange').prop('disabled', false);
                                    $('#rejection_reason_close_button').trigger('click');
                                    alert_float('danger', 'Checklist status cannot be updated,please upload document first.');
                                }
                            },
                            error: function (error) {
                                $('#submitStatusChange').prop('disabled', false);
                                $('#rejection_reason_close_button').trigger('click');
                                alert_float('danger', 'Checklist status cannot be updated.');
                            }
                        });
                    }
                });
                // Remove error message on input change
                $('#rejectionReason').on('input', function () {
                    $(this).removeClass('is-invalid').next('.invalid-feedback').hide();
                });
            } else {

                var initiallySelectedOption = $(this).find('option[selected]');
                var initialValue = initiallySelectedOption.text();
                var task_id = $(this).data('task-id');
                var newStatus = $(this).val();
                var lead_id = $('#lead_id').val();
                var selectedOption = $('select option[selected]');
                $('.full-page-loader').show();
                // if (confirm('Are you sure you want to change the status?')) {
                    $.ajax({
                        url: "<?php echo admin_url('leads/checklist_updateStatus'); ?>",
                        type: 'POST',
                        data: {
                            task_id: task_id,
                            lead_id: lead_id,
                            newStatus: newStatus
                        },
                        success: function (response) {
                            if (response.success == 1) {
                                $('.full-page-loader').hide();
                                $('#statusChangeModal').modal('hide');
                                destroyTinyMCE();
                                _lead_init_data(response, response.id);
                                $('a[href="' + response.leads_status + '"]').tab('show');
                                if (sameGroup != 2) {
                                    $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                }
                                alert_float('success', 'Checklist status updated successfully.');
                                if (response.all_statuses_equal_to_4) {
                                    $('#complete_stage' + response.complete_stage_buttonid).removeAttr('disabled');
                                }
                            } else if (response.success === false && (response.complete_stage_buttonid === 1 || response.complete_stage_buttonid === 3)) {
                                destroyTinyMCE();
                                $('.full-page-loader').hide();
                                _lead_init_data(response, response.id);
                                $('a[href="' + response.leads_status + '"]').tab('show');
                                if (sameGroup != 2) {
                                    $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                }
                                if (response.complete_stage_buttonid == 1) {
                                    var labelElement = $('.file_open_checkbox').closest('.form-group').find('label[for="' + task_id + '"]');
                                    var titleText = labelElement.text().trim();
                                    $('#get_checkbox_title_file_opened').text(titleText);
                                    appendInputAndRemovePrevious_for_fileopened('task_id', task_id);
                                    $('#file_opened_modal_upload_doc').modal('show');
                                    // Scroll the modal into view
                                    setTimeout(function () {
                                        $('#file_opened_modal_upload_doc').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                                    }, 200);
                                } else if (response.complete_stage_buttonid == 3) {
                                    $('#get_checkbox_title_outstanding').text(titleText);
                                    $('#outstanding_item_modal_upload_doc').modal('show');
                                    // Scroll the modal into view
                                    setTimeout(function () {
                                        $('#outstanding_item_modal_upload_doc').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                                    }, 200);
                                    appendInputAndRemovePrevious_for_oustanding_item('task_id', task_id);
                                    checkbox.prop('checked', true);
                                }
                                alert_float('danger', 'Checklist status cannot be set to approved without completing the necessary steps. Please ensure all checkboxes are checked and the required documents are uploaded before proceeding.');
                                setTimeout(function () {
                                    document.getElementById("alert_float_1").style.display = "none";
                                }, 60000);

                            } else {
                                destroyTinyMCE();
                                $('.full-page-loader').hide();
                                _lead_init_data(response, response.id);
                                $('a[href="' + response.leads_status + '"]').tab('show');
                                if (sameGroup != 2) {
                                    $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                }
                                alert_float('danger', 'Checklist status cannot remain pending. Please update the status to proceed.');
                            }
                        },
                        error: function (error) {
                            alert_float('danger', 'Checklist status cannot remain pending. Please update the status to proceed.');
                        }
                    });
                // } else {
                //     $('.full-page-loader').hide();
                //     $(this).find('option').each(function () {
                //         if ($(this).text() === initialValue) {
                //             $(this).prop('selected', true);
                //         }
                //     });
                // }
            }
        });
    </script>
    <script>
    $(document).ready(function () {
        // Initialize Drop Area Click Handler
        function initDropAreaClickHandler() {
            $(document).off('click', '.drop-area');

            $(document).on('click', '.drop-area', function (e) {
                e.stopImmediatePropagation();
                e.preventDefault();

                let taskId = $(this).attr('data-task-id');
                let fileInput = $('.dropzone-input[data-task-id="' + taskId + '"]');

                if (fileInput.length) {
                    fileInput[0].click();
                }
            });

            console.log('Drop area click handler initialized');
        }
        initDropAreaClickHandler();

        // Handle File Input Change (When File Selected via Click)
        $(document).off('change', '.dropzone-input').on('change', '.dropzone-input', function (e) {
            let taskId = $(this).attr('data-task-id');
            let files = e.target.files;

            if (files.length > 0) {
                dropzone_upload_files(files, taskId);
            }
        });

        // DRAG & DROP HANDLERS
        $(document).off('dragover dragleave drop', '.drop-area');

        $(document).on('dragover', '.drop-area', function (e) {
            e.preventDefault();
            $(this).addClass('highlight');
        });

        $(document).on('dragleave', '.drop-area', function () {
            $(this).removeClass('highlight');
        });

        $(document).on('drop', '.drop-area', function (e) {
            e.preventDefault();
            $(this).removeClass('highlight');

            let taskId = $(this).attr('data-task-id');
            let files = e.originalEvent.dataTransfer.files;

            if (files.length > 0) {
                dropzone_upload_files(files, taskId);
            }
        });

        function dropzone_upload_files(files, taskId) {
            let csrfTokenName = '<?php echo $this->security->get_csrf_token_name(); ?>';
            let csrfTokenValue = $('#file_opened_modal_upload_doc_form input[name="' + csrfTokenName + '"]').val();

            let formData = new FormData();
            $.each(files, function (index, file) {
                formData.append('userfile[]', file);  
            });
            formData.append('task_id', taskId);
            formData.append(csrfTokenName, csrfTokenValue);

            showLoaderForTask(taskId);
            
    
            // FUNCTION TO APPEND IMAGE PREVIEW
            function addImagePreview(fileUrl, filetype, fileName, taskId) {
                let imagePreview = $('.image-preview[data-task-id="' + taskId + '"]');

                let imgWrapper = $('<div class="image-wrapper">').css({
                    width: '100px',
                    textAlign: 'center',
                    marginBottom: '10px'
                });

                let previewSrc = '<?php echo base_url('assets/images/general.webp'); ?>'; 

                if (['jpeg', 'jpg', 'png', 'heic', 'HEIC'].includes(filetype.toLowerCase())) {
                    previewSrc = fileUrl; 
                } else if (filetype === 'pdf') {
                    previewSrc = '<?php echo base_url('assets/images/pdf.webp'); ?>';
                } else if (filetype === 'msword' || filetype === 'vnd.openxmlformats-officedocument.wordprocessingml.document') {
                    previewSrc = '<?php echo base_url('assets/images/msword_new.webp'); ?>';
                } else {
                    previewSrc = '<?php echo base_url('assets/images/general.webp'); ?>'; 
                }

                let img = $('<img>').attr('src', previewSrc).css({
                    width: '50px',
                    height: '50px',
                    objectFit: 'cover',
                    display: 'block',
                    margin: '0 auto'
                });

                imgWrapper.append(img);
                imagePreview.append(imgWrapper);
            }
            // upload dropzone images of item code
            $.ajax({
                url: '<?php echo admin_url('leads/upload_doc_for_fileopened/' . $lead->id); ?>',
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function (response) {
                    if (response.success) {
                        hideLoaderForTask(taskId);
                        if(response.task_type == 'broker'){
                            $('.status-select').each(function () {
                                if ($(this).data('task-id') == taskId) {
                                    // $(this).val('5');
                                    $(this).val('5').css({
                                        'background-color': '#e2b203',
                                        'color': 'black'
                                    });
                                }
                            });
                        }else{
                            $('.status-select').each(function () {
                                if ($(this).data('task-id') == taskId) {
                                    $(this).val('1');
                                      $(this).val('1').css({
                                        'background-color': '',
                                        'color': 'black'
                                    });
                                }
                            });
                        }
                        if (response.files && Array.isArray(response.files)) {
                            response.files.forEach(function (fileData) {
                                addImagePreview(fileData.file_url, fileData.filetype, fileData.file_name, taskId);
                            });
                        }

                        // Update CSRF token if returned by the server
                        // if (response.csrf_token) {
                        //     $('#file_opened_modal_upload_doc_form input[name="' + csrfTokenName + '"]').val(response.csrf_token);
                        // }
                    }
                },
                error: function (xhr) {
                    hideLoaderForTask(taskId);
                    console.error('Upload failed:', xhr.responseText);
                },
                complete: function () {
                    hideLoaderForTask(taskId);
                }
            });
        }
    });

    // drag and drop for ledger upload images but using button
    var ledgerDroppedFiles = [];

    // Trigger file input on clicking the drop area
    $(document).off('click', '#dropAreaLedger').on('click', '#dropAreaLedger', function () {
        $('#ledger_dropzone').click();
    });

    // When files are manually selected
    $(document).off('change', '#ledger_dropzone').on('change', '#ledger_dropzone', function (e) {
        ledgerDroppedFiles = Array.from(e.target.files);
        renderLedgerPreview(ledgerDroppedFiles);
    });

    // Drag-over effect
    $(document).off('dragover').on('dragover', '#dropAreaLedger', function (e) {
        e.preventDefault();
        e.stopPropagation();
        $(this).addClass('highlight');
    });

    // Remove highlight on drag leave
    $(document).off('dragleave').on('dragleave', '#dropAreaLedger', function (e) {
        e.preventDefault();
        e.stopPropagation();
        $(this).removeClass('highlight');
    });

    // When files are dropped
    $(document).off('drop').on('drop', '#dropAreaLedger', function (e) {
        e.preventDefault();
        e.stopPropagation();
        $(this).removeClass('highlight');

        if (e.originalEvent.dataTransfer && e.originalEvent.dataTransfer.files.length > 0) {
            ledgerDroppedFiles = Array.from(e.originalEvent.dataTransfer.files);
            renderLedgerPreview(ledgerDroppedFiles);
        }
    });

    // Render image/file preview
    function renderLedgerPreview(files) {
        let previewContainer = $('#ledger_file_preview');
        previewContainer.empty(); // Clear previous previews

        files.forEach(file => {
            const fileName = file.name;
            const fileExtension = fileName.split('.').pop().toLowerCase();
            let imageUrl = '';

            if (['jpeg', 'jpg', 'png', 'avif'].includes(fileExtension)) {
                imageUrl = '<?= base_url("assets/images/general.webp"); ?>';
            } else if (['doc', 'docx'].includes(fileExtension)) {
                imageUrl = '<?= base_url("assets/images/msword_new.webp"); ?>';
            } else if (fileExtension === 'pdf') {
                imageUrl = '<?= base_url("assets/images/pdf.webp"); ?>';
            } else {
                imageUrl = '<?= base_url("assets/images/general.webp"); ?>';
            }

            const html = `
                <div style="display:inline-block;margin:5px;">
                    <img src="${imageUrl}" style="width:100px;height:100px;object-fit:contain;border:1px solid #ccc;padding:2px;">
                    <div style="text-align:center;font-size:12px;max-width:100px;word-break:break-word;">${file.name}</div>
                </div>
            `;
            previewContainer.append(html);
        });
    }

    // Submit handler
    $('#ledger_upload_form_dragdrop').off('submit').on('submit', function (e) {
        e.preventDefault();

        let form = this;
        let ledger_comment = $(form).find('[name="ledger_comment"]').val();
        let lead_id = '<?= $lead->id ?>';

        if (ledgerDroppedFiles.length === 0) {
            alert_float('danger', 'Please select at least one file to upload.');
            return;
        }

        let formData = new FormData();
        formData.append('ledger_comment', ledger_comment);
        formData.append('lead_id', lead_id);

        let csrfTokenName = "<?= $this->security->get_csrf_token_name(); ?>";
        let csrfTokenValue = $("input[name='<?= $this->security->get_csrf_token_name(); ?>']").val();
        formData.append(csrfTokenName, csrfTokenValue);

        ledgerDroppedFiles.forEach(file => {
            formData.append('ledger_userfile[]', file);
        });
        
        $('.full-page-loader').show();

        $.ajax({
            url: "<?php echo admin_url('leads/upload_doc_for_ledger') ?>",
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function (response) {
                alert_float('success','Ledger uploaded successfully');
                destroyTinyMCE();
                _lead_init_data(response, response.id);
                form.reset();
                ledgerDroppedFiles = [];
                $('#ledger_file_preview').empty();
                
                setTimeout(function () {
                    $('.full-page-loader').hide();
                    $('a[href="#ledger"]').closest('div').addClass('step-active');
                    var anchor = document.querySelector('a[href="#ledger"]');
                    anchor.click();
                }, 3000);

            },
            error: function (xhr) {
                console.error('Upload failed:', xhr.responseText);
                alert('Upload failed');
            }
        });
    });




    // Show loader only inside the drop-area of the related task form
    function showLoaderForTask(taskId) {
        let dropArea = $('.drop-area[data-task-id="' + taskId + '"]');
        if (dropArea.length) {
            // Add loader inside the drop area
            dropArea.css('position', 'relative'); // Make sure it's positioned for absolute overlay
            dropArea.append(`
                <div class="dropzone-loader" style="
                    position: absolute;
                    top: 0;
                    left: 0;
                    width: 100%;
                    height: 100%;
                    background: rgba(255, 255, 255, 0.8);
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    font-weight: bold;
                    color: #555;
                    z-index: 100;
                ">Uploading...</div>
            `);
        }
    }

    function hideLoaderForTask(taskId) {
        let dropArea = $('.drop-area[data-task-id="' + taskId + '"]');
        let loader = dropArea.find('.dropzone-loader');
        if (loader.length) {
            loader.remove();
        }
    }





        function destroyTinyMCE() {
            tinymce.remove();
            if (tinymce.editors.length > 0) {
                tinymce.editors.forEach(function (editor) {
                    editor.remove();
                });
            }
        }
        function format_notes_and_description(reason) {
            if (!reason) {
                return '-';
            }

            // Split the reason by newlines and remove any extra spaces
            var lines = reason.split('\n').map(function (line) {
                return line.trim();
            }).filter(function (line) {
                return line.length > 0;
            });

            // Format as bullet points
            var formatted = lines.map(function (line) {
                return '<li>' + line + '</li>';
            }).join('');

            return '<ul style="list-style: auto; padding-left: 25px;">' + formatted + '</ul>';
        }
        // Table drag and drop up/down
        // $(function () {
        //     $("#data-container_broker1,#data-container_broker_outstanding,#data-container1,#data-container2,#data-container3,#data-container4").sortable({
        //         items: "tr",
        //         cursor: "move",
        //         axis: "y",
        //         placeholder: "sortable-placeholder",
        //         update: function (event, ui) {
        //             let order = [];
        //             $(this).find("tr").each(function () {
        //                 order.push($(this).data("id"));
        //             });

        //             console.log("New order for", this.id + ":", order);
        //         }
        //     }).disableSelection();
        // });

       $(function () {
            const sortableSelectors = [
                "#data-container_broker1",
                "#data-container_broker_outstanding",
                "#data-container1",
                "#data-container2",
                "#data-container3",
                "#data-container4",
                "#checklist_table2",
                "#checklist_table3",
                "#checklist_table4",
                "#checklist_table5",
                "#file_opened_checklist_item_for_borrower",
                "#checkbox_lists_outstanding_ld_team",
                "#checkbox_lists_outstanding_ld_team_payouts",
                "#rff_last_two_items",
                "#checkbox_lists_request_funds"
            ].join(", ");

            $(sortableSelectors).sortable({
                items: "tr",
                cursor: "move",
                axis: "y",
                placeholder: "sortable-placeholder",

                helper: function (e, tr) {
                const $originalCells = tr.children();
                const $helper = $('<div class="flex-helper-row">');

                $originalCells.each(function () {
                    const $orig = $(this);
                    const $cell = $('<div class="flex-helper-cell">').html($orig.html());

                    $cell.css({
                    width: $orig.outerWidth(),
                    padding: $orig.css('padding'),
                    'text-align': $orig.css('text-align'),
                    'white-space': 'nowrap'
                    });

                    $helper.append($cell);
                });

                return $helper;
                },

                start: function (e, ui) {
                ui.placeholder.height(ui.helper.outerHeight());
                },

                stop: function (e, ui) {
                ui.item.removeClass('dragging-row');
                },

                update: function (event, ui) {
                    let orderData = [];
                    // $(this).find("tr").each(function () {
                    //     order.push($(this).data("id"));
                    // });
                    $(this).find("tr").each(function (index) {
                        orderData.push({
                            id: $(this).data("id"),
                            orderid: $(this).data("orderid"),
                            type: $(this).data("type"), // ensure this is present in <tr>
                            order: index + 1
                        });
                    });
                    console.log("New order for", orderData);
                    $.ajax({
                        url: "<?php echo admin_url('leads/update_task_order/' . $lead->id); ?>",
                        method: 'POST',
                        data: {
                            task_order: orderData
                        },
                        success: function (response) {
                            console.log('Order saved:', response);
                        },
                        error: function (xhr, status, error) {
                            console.error('Failed to save order:', error);
                        }
                    });
                }
            }).disableSelection();
        });

        // DL check and other item show content
        $.ajax({
            url: "<?php echo admin_url('leads/dl_check_other_item_checklist_details/' . $lead->id); ?>",
            type: "GET",
            dataType: "json",
            success: function (response) {
                // Display the data in the #data-container div
                var sameGroup = '<?php echo $samegroup; ?>';
                var flag = 0;
                var i = 1;
                var j = 1;
                if (response.length > 0) {
                    var html = "<table class='table dt-table table-ticket-reports dt-inline dataTable no-footer'>";
                    html += "<thead><tr><th>Title</th><th>Status</th><th>Notes</th>";
                    // if (i != 1) {
                    //     html += "<th>Doc Type</th>";
                    // }
                    // html += "<th>Description</th>";
                    // if (i == 1) {
                    //     // html += "<th>ID Type</th>";
                    // }
                    // if (i == 3) {
                    //     html += "<th>Notes</th>";
                    // }
                    // html += "<th>Rejection Reason</th><th>Status</th><th>Documents</th>";

                    html += "<th>Documents</th><th>Action</th>";

                    html += "</tr></thead>";
                    html += "<tbody id='dl_check_checklist_table" + i + "'>";
                    $.each(response, function (index, item) {
                            flag = j;
                            var status;
                            switch (item.status) {
                                case '0':
                                    status = 'N/A';
                                break;
                                case '1':
                                    status = 'Yes';
                                    break;
                                case '2':
                                    status = 'No';
                                    break;
                            }
                            var upload_doc_button = '';
                        
                            upload_doc_button = "<button class='btn btn-primary btn-sm' data-id='" + item.id + "' id='file_open_checkbox_upload_doc_button_" + item.id + "' name='file_open_checkbox_upload_doc_button' style='margin-left: 10px; margin-top: 4px;'><i class='fa-solid fa-upload'></i></button>";
                        
                            html += "<tr id='delete_checklist" + item.id + "' style='background-color:#fbfbfb'>";
                            // html += "<td><a href='<?php echo admin_url('cases/checklistrecord/' . $lead->id . '/') ?>" + item.id + "'>" + item.name + "</a></td>";
                            html += "<td style='display:flex;justify-content:space-between;align-items:center;'>" + "<span class='item-name'>" + capitalizeFirstLetter(item.name) + "</span>" + upload_doc_button + "</td>";
                           
                            // html += "<td>" + (item.rejected_reason || '-') + "</td>";
                            
                            // Check if $samegroup is true (1) or false (0)
                            if (sameGroup != 2 && sameGroup != false) {
                                // var regex = /\b(photo id\s*\d*|paper id\s*\d*)\b/i;
                                // if (regex.test(item.name)) {
                                html += "<td><select style='width: 170px;' id='dl-status-select' class='dl-status-select form-control' data-task-id='" + item.id + "'>" +
                                    "<option value='0' " + (item.status === '0' ? 'selected' : '') + ">N/A</option>" +
                                    "<option value='2' " + (item.status === '2' ? 'selected' : '') + ">No</option>" +
                                    "<option value='1' " + (item.status === '1' ? 'selected' : '') + ">Yes</option>" +
                                    "</select></td>";
                            } else {
                                html += "<td>" +
                                    (item.status === '0' ? 'N/A' : '') +
                                    (item.status === '1' ? 'Yes' : '') +
                                    (item.status === '2' ? 'No' : '') +
                                    "</td>";
                            }
                            
                            html += "<td class='item-notes' data-id='" + item.id + "'>" + format_notes_and_description(item.ld_notes) + "</td>";
                         
                            // check if broker then show the only approved and rejected doc
                            if (sameGroup != 2) {
                                // Check if file_data is present
                                html += "<td>";
                                html += '<form class="file-opened-upload-form" data-task-id="' + item.id + '" enctype="multipart/form-data" style="width:100%;display:flex;justify-content:center;">';
                                html += '<div class="drop-area" data-task-id="' + item.id + '">Drag & Drop or Click to Upload</div>';
                                html += '<input type="file" class="dropzone-input" data-task-id="' + item.id + '" multiple style="display: none;" accept="image/*">';
                                html += '</form>';
                                html += '<div class="image-preview" data-task-id="' + item.id + '"></div>';
                                if (item.file_data.length > 0) {
                                    // if (item.status == 3 || item.status == 4) {
                                    var columnClass = (item.file_data.length == 1) ? 'col-md-12' : 'col-md-6';
                                    html += "<div style='overflow-y: scroll; max-height: 150px; width:330px;'><div style='max-height: 150px;'>";
                                    $.each(item.file_data, function (fileIndex, fileItem) {
                                        var view_url = fileItem.file_url ? fileItem.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com") : '';
                                        if (fileItem.check_filetype == 'jpeg' || fileItem.check_filetype == 'png' || fileItem.check_filetype == 'jpg' || fileItem.check_filetype == 'HEIC' || fileItem.check_filetype == 'heic') {
                                            html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                            html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height:50px; margin: 7px;' src='<?php echo base_url('assets/images/allimage.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                        } else if (fileItem.check_filetype == 'pdf') {
                                            html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                            html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/pdf.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";

                                        } else if (fileItem.check_filetype === 'msword' || fileItem.check_filetype === 'vnd.openxmlformats-officedocument') {
                                            html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                            html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/msword_new.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                        } else {
                                            html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div><a href='" + fileItem.dl_file_url + "'>";
                                            html += "<img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/general.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                        }
                                    });
                                    html += "</div></div>";
                                }
                                //  else {
                                //     html += "<td><div style='color: #31708f;'><span class='no-margin font-medium-xs bold' style='color: #1f7efabb;'>No Document Available</div></div></td>";
                                // }
                                html += "</td>";
                            } else {
                                html += "<td>";
                                html += '<form class="file-opened-upload-form" data-task-id="' + item.id + '" enctype="multipart/form-data" style="width:100%;display:flex;justify-content:center;">';
                                html += '<div class="drop-area" data-task-id="' + item.id + '">Drag & Drop or Click to Upload</div>';
                                html += '<input type="file" class="dropzone-input" data-task-id="' + item.id + '" multiple style="display: none;" accept="image/*">';
                                html += '</form>';
                                html += '<div class="image-preview" data-task-id="' + item.id + '"></div>';
                                // Check if file_data is present
                                if (item.file_data.length > 0) {
                                    // if (item.status == 3 || item.status == 4) {
                                    var columnClass = (item.file_data.length == 1) ? 'col-md-12' : 'col-md-6';
                                    var WidthStyle = (item.file_data.length == 1) ? '' : 'width:330px;';
                                    html += "<div style='overflow-y: scroll; max-height: 150px;" + WidthStyle + "'>";
                                    html += "<div style='max-height: 150px;'>";
                                    $.each(item.file_data, function (fileIndex, fileItem) {
                                        var view_url = fileItem.file_url ? fileItem.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com") : '';
                                        if (fileItem.check_filetype == 'jpeg' || fileItem.check_filetype == 'png' || fileItem.check_filetype == 'jpg' || fileItem.check_filetype == 'HEIC' || fileItem.check_filetype == 'heic') {
                                            html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                            html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height:50px; margin: 7px;' src='<?php echo base_url('assets/images/allimage.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                        } else if (fileItem.check_filetype == 'pdf') {
                                            html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                            html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/pdf.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";

                                        } else if (fileItem.check_filetype === 'msword' || fileItem.check_filetype === 'vnd.openxmlformats-officedocument') {
                                            html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                            html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/msword_new.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                        } else {
                                            html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div><a href='" + fileItem.dl_file_url + "'>";
                                            html += "<img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/general.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                        }
                                    });
                                    html += "</div></div>";
                                } 
                                // else {
                                //     html += "<td><div style='color: #31708f;'><span class='no-margin font-medium-xs bold' style='color: #1f7efabb;'>No Documents Available</div></div></td>";
                                // }
                                html += "</td>";
                            }
                            if(sameGroup == true || sameGroup == 2){
                                html += "<td style='display:flex;align-items:center;'><button  href='#' class='btn btn-danger btn-sm delete-checklist-link' data-id='" + item.id + "'><i class='fa fa-trash' style='color:white;'></i></button>";
                                html += "<button class='btn btn-primary btn-sm' style='margin-left:8px;' id='update_checklist' href='#'  data-id='" + item.id + "'><i class='fas fa-edit'></i></button></td>";
                            }else{
                                html += "<td style='display:flex;align-items:center;'>-</td>";
                            }
                            html += "</tr>";
                            flag++;
                    });
                    j++;
                    // i am using the flag variable this variable is help me to check if checklist exist then append the checklist in table otherwise 
                    // it append the no checklist record table 
                    if (flag > 0) {
                        html += "</tbody></table>";
                        $("#DL-check-container").html(html);
                        flag = 0;
                    } else {
                        var html = "<table class='table dt-table table-ticket-reports dt-inline dataTable no-footer'>";
                        html += "<thead><tr><th>Title</th><th>Status</th><th>Notes</th><th>Document</th><th>Documents</th><th>Action</th></tr></thead>";
                        html += "<tbody id='checklist_table" + i + "'>";
                        html += "</tbody>";
                        html += "</table>";
                        html += "<div id='no_checklist_record_found" + i + "' class='alert alert-info' style='margin-top:10px;'><span class='no-margin font-medium-xs bold' style='display: flex;justify-content: center;'>No Checklist available</span></div></div>";
                        $("#DL-check-container").html(html);
                    }
                    // appened the outstanding table in appointment request stage
                    // if (i == 3) {
                    //     $("#appointment-data-container").html(html);
                    // }
                } else {
                    var html = "<table class='table dt-table table-ticket-reports dt-inline dataTable no-footer'>";
                    html += "<thead><tr><th>Title</th><th>Status</th><th>Notes</th><th>Document</th><th>Documents</th><th>Action</th></tr></thead>";
                    html += "<tbody id='checklist_table" + i + "'>";
                    html += "</tbody>";
                    html += "</table>";
                    html += "<div id='no_checklist_record_found" + i + "' class='alert alert-info' style='margin-top:10px;'><span class='no-margin font-medium-xs bold' style='display: flex;justify-content: center;'>No Checklist available</span></div></div>";
                    $("#DL-check-container").html(html);
                    // if (i == 3) {
                    //     $("#appointment-data-container").html(html);
                    // }
                }
            },
            error: function (error) {
                console.log('Error:', error);
            }
        });
    </script>
     <!-- checkboxes code -->
     <script>
        $(document).ready(function () {
            $(function () {
                const sortableSelectors = [
                    "#data-container_broker1",
                    "#data-container_broker_outstanding",
                    "#data-container1",
                    "#data-container2",
                    "#data-container3",
                    "#data-container4",
                    "#checklist_table2",
                    "#checklist_table3",
                    "#checklist_table4",
                    "#checklist_table5",
                    "#file_opened_checklist_item_for_borrower",
                    "#checkbox_lists_outstanding_ld_team",
                    "#checkbox_lists_outstanding_ld_team_payouts",
                    "#rff_last_two_items",
                    "#checkbox_lists_request_funds"
                ].join(", ");

                $(sortableSelectors).sortable({
                    items: "tr",
                    cursor: "move",
                    axis: "y",
                    placeholder: "sortable-placeholder",

                    helper: function (e, tr) {
                    const $originalCells = tr.children();
                    const $helper = $('<div class="flex-helper-row">');

                    $originalCells.each(function () {
                        const $orig = $(this);
                        const $cell = $('<div class="flex-helper-cell">').html($orig.html());

                        $cell.css({
                        width: $orig.outerWidth(),
                        padding: $orig.css('padding'),
                        'text-align': $orig.css('text-align'),
                        'white-space': 'nowrap'
                        });

                        $helper.append($cell);
                    });

                    return $helper;
                    },

                    start: function (e, ui) {
                    ui.placeholder.height(ui.helper.outerHeight());
                    },

                    stop: function (e, ui) {
                    ui.item.removeClass('dragging-row');
                    },

                    update: function (event, ui) {
                        let orderData = [];
                        // $(this).find("tr").each(function () {
                        //     order.push($(this).data("id"));
                        // });
                        $(this).find("tr").each(function (index) {
                            orderData.push({
                                id: $(this).data("id"),
                                orderid: $(this).data("orderid"),
                                type: $(this).data("type"), // ensure this is present in <tr>
                                order: index + 1
                            });
                        });
                        console.log("New order for", orderData);
                        $.ajax({
                            url: "<?php echo admin_url('leads/update_task_order/' . $lead->id); ?>",
                            method: 'POST',
                            data: {
                                task_order: orderData
                            },
                            success: function (response) {
                                console.log('Order saved:', response);
                            },
                            error: function (xhr, status, error) {
                                console.error('Failed to save order:', error);
                            }
                        });
                    }
                }).disableSelection();
            });
            var leadid = "<?php echo $lead->id ?>";
            function destroyTinyMCE() {
                tinymce.remove();
                if (tinymce.editors.length > 0) {
                    tinymce.editors.forEach(function (editor) {
                        editor.remove();
                    });
                }
            }
            // Checklist show for broker
            function loadChecklistForBroker(){
                $.ajax({
                    url: "<?php echo admin_url('leads/checklist_details_broker/' . $lead->id); ?>",
                    type: "GET",
                    dataType: "json",
                    success: function (response) {
                        // Display the data in the #data-container div
                        var sameGroup = '<?php echo $samegroup; ?>';
                        var flag = 0;
                        var j = 1;
                        for (var i = 1; i < 5; i++) {
                            if (response.length > 0) {
                                var html = "<table class='table dt-table table-ticket-reports dt-inline dataTable no-footer'>";
                                html += `
                                    <div class='bulk-action-bar' style='
                                        margin-bottom: 10px;
                                        padding: 10px;
                                        border: 1px solid #ddd;
                                        background: #f9f9f9;
                                        border-radius: 5px;
                                        display: flex;
                                        justify-content: space-between;
                                        align-items: center;
                                    '>
                                        <div style="display: flex; align-items: center;">
                                            <input type='checkbox' class='select-all-checkbox' style='margin-right: 10px; transform: scale(1.3);'>
                                            <span style="font-weight: bold;">Select All</span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 10px;">
                                            <select class='form-control bulk-status-select' style='width: 200px;'>
                                                <option value=''>Select Status</option>
                                                <option value='2'>Outstanding</option>
                                                <option value='5'>Uploaded</option>
                                            </select>
                                            <button class='btn btn-danger bulk-delete-btn' style=''>
                                                <i class='fa fa-trash'></i>
                                            </button>
                                        </div>
                                    </div>
                                `;
                                html += "<thead><tr><th></th><th>Title</th>";
                                // if (i == 1) {
                                //     html += "<th>Doc Type</th>";
                                // }
                                // html += "<th>Description</th>";
                                if (i != 1) {
                                    // html += "<th>ID Type</th>";
                                }
                                html += "<th>Status</th><th>Notes</th><th>Documents</th>";

                                // if (sameGroup != 2 && sameGroup != false) {
                                html += "<th>Action</th>";
                                // }

                                html += "</tr></thead>";
                                html += "<tbody id='checklist_table" + i + "' class='broker_checklist_table'>";

                                $.each(response, function (index, item) {
                                    if (item.checklist_lead_status == j) {
                                        flag = j;
                                        var status;
                                        switch (item.status) {
                                            case '1':
                                                status = 'Pending Review';
                                                break;
                                            case '2':
                                                // status = 'Pending';
                                                status = 'Outstanding';
                                                break;
                                            case '3':
                                                status = 'Rejected';
                                                break;
                                            case '4':
                                                status = 'Approved';
                                                break;
                                                // case '5':
                                                //     status = 'Pending Review';
                                                break;
                                        }
                                        html += "<tr id='delete_checklist" + item.id + "' data-id='"+ item.id + "' data-orderid='"+ item.order_no + "' data-type='broker' style='background-color:#fbfbfb'>";
                                        // html += "<td><a href='<?php echo admin_url('cases/checklistrecord/' . $lead->id . '/') ?>" + item.id + "'>" + item.name + "</a></td>";
                                        html += "<td><input type='checkbox' class='checklist-bulk-checkbox' data-id='" + item.id + "' data-type='broker'></td>";
                                        html += "<td style='display:flex;justify-content:space-between;align-items:center;'>";
                                        html += "<span class='item-name'>" + item.name + "</span>";
                                        if (sameGroup != false) {
                                            html += "<button class='btn btn-primary btn-sm' data-id='" + item.id + "' id='file_open_checkbox_upload_doc_button_" + item.id + "' name='file_open_checkbox_upload_doc_button' style='margin-left: 10px; margin-top: 4px;'><i class='fa-solid fa-upload'></i></button>";
                                            // html += '<div class="drop-area" data-task-id="' + item.id + '">Drag & Drop or Click to Upload</div>';
                                            // html += '<div class="image-preview" data-task-id="' + item.id + '"></div>';
                                            // html += '<input type="file" class="dropzone-input" data-task-id="' + item.id + '" multiple style="display: none;" accept="image/*">';
                                        }
                                        html += "</td>";
                                        // if (i == 1) {
                                        //     html += "<td> " + item.doc_type + "</td>";
                                        // }
                                        // html += "<td> " + (item.description ?? '-') + "</td>";
                                        if (i != 1) {
                                            html += "<td> " + (item.show_item_names ?? '-') + "</td>";
                                        }
                                        // html += "<td class='tw-text-neutral-900 tw-mt-1' style='width:100px;'><span data-toggle='tooltip' data-title='" + item.dt_new_dateadded + "' class='text-has-action' > " + item.new_dateadded + "</span></td>";
                                        // Check if $samegroup is true (1) or false (0)
                                        if (sameGroup != 2 && sameGroup != false) {
                                            // var regex = /\b(photo id\s*\d*|paper id\s*\d*)\b/i;
                                            // if (regex.test(item.name)) {
                                            var status_dropdown_clr = '';
                                            if (item.status === '2' || item.status === '3') {
                                                status_dropdown_clr = 'background-color: #ff0000b3; color: white;';
                                            }
                                            if (item.status === '4') {
                                                status_dropdown_clr = 'background-color: #008000bf; color: white;';
                                            }
                                            if (item.status === '5') {
                                                status_dropdown_clr = 'background-color: #e2b203; color: black;';
                                            }
                                            if (item.status === '6') {
                                                status_dropdown_clr = 'background-color: #008000bf; color: white;';
                                            }
                                            if (item.type != 'broker') {
                                                html += "<td><select style='width: 170px;" + status_dropdown_clr + "' class='status-select form-control' data-task-id='" + item.id + "' id='status_select_''" + item.id + "'>" +
                                                    "<option value='1' " + (item.status === '1' ? 'selected' : '') + ">Pending Review</option>" +
                                                    "<option value='2' " + (item.status === '2' ? 'selected' : '') + ">Outstanding</option>" +
                                                    "<option value='3' " + (item.status === '3' ? 'selected' : '') + ">Rejected</option>" +
                                                    "<option value='4' " + (item.status === '4' ? 'selected' : '') + ">Approved</option>" +
                                                    "<option value='5' " + (item.status === '5' ? 'selected' : '') + ">Uploaded</option>" +
                                                    // "<option value='5' " + (item.status === '5' ? 'selected' : '') + ">Pending Review</option>" +
                                                    "</select>";
                                                html += "</td>";
                                            } else {
                                                const BrokerFeeisDisabled  = item.broker_fee_na == 1 ? 'disabled' : '';
                                                const BrokerFeeisChecked = item.broker_fee_na == 1 ? 'checked' : '';
                                                // html += "<td><select style='width: 170px;" + status_dropdown_clr + "' class='status-select form-control' data-task-id='" + item.id + "' id='status_select_''" + item.id + "' " + BrokerFeeisDisabled + ">" +
                                                //     "<option value='2' " + (item.status === '2' ? 'selected' : '') + ">Outstanding</option>" +
                                                //     "<option value='5' " + (item.status === '5' ? 'selected' : '') + ">Uploaded</option>" +
                                                //     // "<option value='5' " + (item.status === '5' ? 'selected' : '') + ">Pending Review</option>" +
                                                //     "</select>";
                                                html += "<td><select style='width: 170px;" + status_dropdown_clr + "' class='status-select form-control' data-task-id='" + item.id + "' id='status_select_" + item.id + "'>";
                                                html += "<option value='2' " + (item.status === '2' ? 'selected' : '') + ">Outstanding</option>";
                                                html += "<option value='5' " + (item.status === '5' ? 'selected' : '') + ">Uploaded</option>";
                                                if (item.name === "Broker fee agreement") {
                                                    html += "<option value='6' " + (item.status === '6' ? 'selected' : '') + ">N/A</option>";
                                                }
                                                html += "</select></td>";

                                                // if (item.name === "Broker fee agreement") {
                                                //     html += "<div class='' style='margin-top:12px;display:flex;align-item:center;border:3px solid #da1313;padding: 3px;'>";
                                                //     html += "<input type='checkbox' data-task-id='" + item.id + "' class='form-check-input me-1' id='broker_fee_agreement_na_checkbox' name='broker_fee_agreement_na_checkbox' " + BrokerFeeisChecked + ">";
                                                //     html += "<label class='form-check-label' for='broker_fee_agreement_na_checkbox' style='margin-top:6px;margin-left:10px;font-weight:800;'>N/A</label>";
                                                //     html += "</div>";
                                                // }
                                                // html += "</td>";
                                            }
                                        } else {
                                            html += "<td>" +
                                                (item.status === '1' ? 'Pending Review' : '') +
                                                (item.status === '2' ? 'Outstanding' : '') +
                                                (item.status === '3' ? 'Rejected' : '') +
                                                (item.status === '4' ? 'Approved' : '') +
                                                (item.status === '5' ? 'Uploaded' : '') +
                                                // (item.status === '5' ? 'Pending Review' : '') +
                                                "</td>";
                                        }
                                        // show ld notes
                                        html += "<td class='item-notes' data-id='" + item.id + "'>" + format_notes_and_description(item.ld_notes) + "</td>";
                                        // Check if file_data is present
                                        html += "<td>";
                                        html += '<form class="file-opened-upload-form" data-task-id="' + item.id + '" enctype="multipart/form-data" style="width:100%;display:flex;justify-content:center;">';
                                            html += '    <div class="drop-area" data-task-id="' + item.id + '">Drag & Drop or Click to Upload</div>';
                                            html += '    <input type="file" class="dropzone-input" data-task-id="' + item.id + '" multiple style="display: none;" accept="image/*">';
                                            html += '</form>';
                                            html += '<div class="image-preview" data-task-id="' + item.id + '"></div>';
                                        if (item.file_data.length > 0) {
                                            // if (item.status == 3 || item.status == 4) {
                                            var columnClass = (item.file_data.length == 1) ? 'col-md-12' : 'col-md-6';
                                            html += "<div style='overflow-y: scroll; max-height: 150px; '><div style='max-height: 150px;'>";
                                            $.each(item.file_data, function (fileIndex, fileItem) {
                                                var view_url = fileItem.file_url ? fileItem.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com") : '';
                                                if (fileItem.check_filetype == 'jpeg' || fileItem.check_filetype == 'png' || fileItem.check_filetype == 'jpg' || fileItem.check_filetype == 'HEIC' || fileItem.check_filetype == 'heic') {
                                                    html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                                    html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height:50px;' src='<?php echo base_url('assets/images/allimage.webp') ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                                } else if (fileItem.check_filetype == 'pdf') {
                                                    html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                                    html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/pdf.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";

                                                } else if (fileItem.check_filetype === 'msword' || fileItem.check_filetype === 'vnd.openxmlformats-officedocument') {
                                                    html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                                    html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height: 50px; margin: 5px; ' src='<?php echo base_url('assets/images/msword_new.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                                } else {
                                                    html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div><a href='" + fileItem.dl_file_url + "'>";
                                                    html += "<img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/general.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                                }
                                            });
                                            html += "</div></div>";
                                        } 
                                        // else {
                                        //     html += "<div style='color: #31708f;'><span class='no-margin font-medium-xs bold' style='color: #1f7efabb;'>No Document Available</div></div>";
                                        // }
                                        html += "</td>";
                                        if(sameGroup == 2 || sameGroup == true){
                                            html += "<td style='display:flex;align-items:center;'><button  class='btn btn-danger btn-sm delete-checklist-link' data-id='" + item.id + "'><i class='fa fa-trash' style='color:white;'></i></button>";
                                            html += "<button class='btn btn-primary btn-sm' style='margin-left:8px;' id='update_checklist' href='#'  data-id='" + item.id + "'><i class='fas fa-edit'></i></button></td>";
                                        }else{
                                            html += "<td style='display:flex;align-items:center;'>-</td>";
                                        }
                                        html += "</tr>";
                                    }
                                });
                                j++;
                                // i am using the flag variable this variable is help me to check if checklist exist then append the checklist in table otherwise 
                                // it append the no checklist record table 
                                if (flag > 0) {
                                    html += "</tbody></table>";
                                    $("#data-container_broker" + i).html(html);
                                    $("#data-container_broker_outstanding" + i).html(html);
                                    flag = 0;
                                } else {
                                    var html = "<table class='table dt-table table-ticket-reports dt-inline dataTable no-footer'>";
                                    html += "<thead><tr><th>Title</th><th>Status</th><th>Documents</th><th>Action</th></tr></thead>";
                                    html += "<tbody id='checklist_table" + i + "'>";
                                    html += "</tbody>";
                                    html += "</table>";
                                    html += "<div id='no_checklist_record_found" + i + "' class='alert alert-info' style='margin-top:10px;'><span class='no-margin font-medium-xs bold' style='display: flex;justify-content: center;'>No Checklist available</span></div></div>";
                                    $("#data-container_broker" + i).html(html);
                                    $("#data-container_broker_outstanding" + i).html(html);
                                }
                            }
                            else {
                                var html = "<table class='table dt-table table-ticket-reports dt-inline dataTable no-footer'>";
                                html += "<thead><tr><th>Title</th><th>Status</th><th>Documents</th><th>Action</th></tr></thead>";
                                html += "<tbody id='checklist_table" + i + "'>";
                                html += "</tbody>";
                                html += "</table>";
                                html += "<div id='no_checklist_record_found" + i + "' class='alert alert-info' style='margin-top:10px;'><span class='no-margin font-medium-xs bold' style='display: flex;justify-content: center;'>No Checklist available</span></div></div>";
                                $("#data-container_broker" + i).html(html);
                                $("#data-container_broker_outstanding" + i).html(html);
                            }
                        }
                        // Tincy mac data appened 
                        var checklistItems = '';
                        $.each(response, function (index, item) {
                            if (item.status === '2') {
                                const rejectedReason = item.rejected_reason ? `${item.rejected_reason}` : '';
                                checklistItems += `<li style="color:black;"><span style="color:red;">${item.name}</span></li>`;
                            }
                        });
                        $('#file_opened_broker_all_checklist_review').append(checklistItems);

                    },
                    error: function (error) {
                        console.log('Error:', error);
                    }
                });
            }
            // get the checklist for client
            function loadChecklistDataForClient(){
                $.ajax({
                    url: "<?php echo admin_url('leads/checklist_details/' . $lead->id); ?>",
                    type: "GET",
                    dataType: "json",
                    success: function (response) {
                        // Display the data in the #data-container div
                        var sameGroup = '<?php echo $samegroup; ?>';
                        var flag = 0;
                        var j = 1;
                        for (var i = 1; i < 5; i++) {
                            if (response.length > 0) {
                                var html = "<table class='table dt-table table-ticket-reports dt-inline dataTable no-footer'>";
                                html += `
                                    <div class='bulk-action-bar' style='
                                        margin-bottom: 10px;
                                        padding: 10px;
                                        border: 1px solid #ddd;
                                        background: #f9f9f9;
                                        border-radius: 5px;
                                        display: flex;
                                        justify-content: space-between;
                                        align-items: center;
                                    '>
                                        <div style="display: flex; align-items: center;">
                                            <input type='checkbox' class='select-all-checkbox' style='margin-right: 10px; transform: scale(1.3);'>
                                            <span style="font-weight: bold;">Select All</span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 10px;">
                                            <select class='form-control bulk-status-select' style='width: 200px;'>
                                                <option value=''>Select Status</option>
                                                <option value='1'>Pending Review</option>
                                                <option value='2'>Outstanding</option>
                                                <option value='3'>Rejected</option>
                                                <option value='4'>Approved</option>
                                                <option value='5'>Uploaded</option>
                                            </select>
                                            <button class='btn btn-danger bulk-delete-btn' style=''>
                                                <i class='fa fa-trash'></i>
                                            </button>
                                        </div>
                                    </div>
                                `;



                                html += "<thead><tr><th></th><th>Title</th><th>Status</th>";
                                // if (i != 1) {
                                //     html += "<th>Doc Type</th>";
                                // }
                                // html += "<th>Description</th>";
                                if (i == 1) {
                                    // html += "<th>ID Type</th>";
                                }
                                if (i == 3) {
                                    html += "<th>Notes</th>";
                                }
                                html += "<th>Rejection Reason</th><th>Documents</th>";

                                html += "<th>Action</th>";

                                html += "</tr></thead>";
                                html += "<tbody id='checklist_table" + i + "'>";
                                $.each(response, function (index, item) {
                                    if (item.checklist_lead_status == j) {
                                        flag = j;
                                        var status;
                                        switch (item.status) {
                                            case '1':
                                                status = 'Pending Review';
                                                break;
                                            case '2':
                                                // status = 'Pending';
                                                status = 'Outstanding';
                                                break;
                                            case '3':
                                                status = 'Rejected';
                                                break;
                                            case '4':
                                                status = 'Approved';
                                                break;
                                            // case '5':
                                            //     status = 'Pending Review';
                                            // break;
                                        }
                                        var upload_doc_button = '';
                                        if (sameGroup != 2 && sameGroup != false && i == 3) {
                                            upload_doc_button = "<button class='btn btn-primary btn-sm' data-id='" + item.id + "' id='file_open_checkbox_upload_doc_button_" + item.id + "' name='file_open_checkbox_upload_doc_button' style='margin-left: 10px; margin-top: 4px;'><i class='fa-solid fa-upload'></i></button>";
                                        }
                                        if (sameGroup != false && i == 1) {
                                            upload_doc_button = "<button class='btn btn-primary btn-sm' data-id='" + item.id + "' id='file_open_checkbox_upload_doc_button_" + item.id + "' name='file_open_checkbox_upload_doc_button' style='margin-left: 10px; margin-top: 4px;'><i class='fa-solid fa-upload'></i></button>";
                                        }
                                        html += "<tr id='delete_checklist" + item.id + "' data-id='" + item.id + "' data-orderid='" + item.order_no + "' data-type='client' style='background-color:#fbfbfb'>";
                                        // html += "<td><a href='<?php echo admin_url('cases/checklistrecord/' . $lead->id . '/') ?>" + item.id + "'>" + item.name + "</a></td>";
                                        html += "<td><input type='checkbox' class='checklist-bulk-checkbox' data-id='" + item.id + "' data-type='client'></td>";
                                        html += "<td style='display:flex;justify-content:space-between;align-items:center;'>" + "<span class='item-name'>" + capitalizeFirstLetter(item.name) + "</span>" + upload_doc_button + "</td>";
                        
                                        // Check if $samegroup is true (1) or false (0)
                                        if (sameGroup != 2 && sameGroup != false) {
                                            // var regex = /\b(photo id\s*\d*|paper id\s*\d*)\b/i;
                                            // if (regex.test(item.name)) {
                                            var status_dropdown_clr = '';
                                            if (item.status === '2' || item.status === '3') {
                                                status_dropdown_clr = 'background-color: #ff0000b3; color: white;';
                                            }
                                            if (item.status === '4') {
                                                status_dropdown_clr = 'background-color: #008000bf; color: white;';
                                            }
                                            if (item.status === '5') {
                                                status_dropdown_clr = 'background-color: #e2b203; color: black;';
                                            }
                                            html += "<td><select style='width: 170px;" + status_dropdown_clr + "' class='status-select form-control' data-task-id='" + item.id + "'>" +
                                                "<option value='1' " + (item.status === '1' ? 'selected' : '') + ">Pending Review</option>" +
                                                "<option value='2' " + (item.status === '2' ? 'selected' : '') + ">Outstanding</option>" +
                                                "<option value='3' " + (item.status === '3' ? 'selected' : '') + ">Rejected</option>" +
                                                "<option value='4' " + (item.status === '4' ? 'selected' : '') + ">Approved</option>" +
                                                "<option value='5' " + (item.status === '5' ? 'selected' : '') + ">Uploaded</option>" +
                                                // "<option value='5' " + (item.status === '5' ? 'selected' : '') + ">Pending Review</option>" +
                                                "</select></td>";
                                        } else {
                                            html += "<td>" +
                                                (item.status === '1' ? 'Pending Review' : '') +
                                                (item.status === '2' ? 'Outstanding' : '') +
                                                (item.status === '3' ? 'Rejected' : '') +
                                                (item.status === '4' ? 'Approved' : '') +
                                                (item.status === '5' ? 'Uploaded' : '') +
                                                // (item.status === '5' ? 'Pending Review' : '') +
                                                "</td>";
                                        }

                                        if (i == 3) {
                                            html += "<td class='item-notes' data-id='" + item.id + "'>" + format_notes_and_description(item.ld_notes) + "</td>";
                                        }
                                        html += "<td>" + (item.rejected_reason || '-') + "</td>";
                                        // check if broker then show the only approved and rejected doc
                                        if (sameGroup != 2) {
                                            // Check if file_data is present
                                            html += "<td>";
                                            html += '<form class="file-opened-upload-form" data-task-id="' + item.id + '" enctype="multipart/form-data" style="width:100%;display:flex;justify-content:center;">';
                                            html += '<div class="drop-area" data-task-id="' + item.id + '">Drag & Drop or Click to Upload</div>';
                                            html += '<input type="file" class="dropzone-input" data-task-id="' + item.id + '" multiple style="display: none;" accept="image/*">';
                                            html += '</form>';
                                            html += '<div class="image-preview" data-task-id="' + item.id + '"></div>';
                                            if (item.file_data.length > 0) {
                                                // if (item.status == 3 || item.status == 4) {
                                                var columnClass = (item.file_data.length == 1) ? 'col-md-12' : 'col-md-6';
                                                html += "<div style='overflow-y: scroll; max-height: 150px; width:330px;'><div style='max-height: 150px;'>";
                                                $.each(item.file_data, function (fileIndex, fileItem) {
                                                    var view_url = fileItem.file_url ? fileItem.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com") : '';
                                                    if (fileItem.check_filetype == 'jpeg' || fileItem.check_filetype == 'png' || fileItem.check_filetype == 'jpg' || fileItem.check_filetype == 'HEIC' || fileItem.check_filetype == 'heic') {
                                                        html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                                        html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height:50px; margin: 7px;' src='<?php echo base_url('assets/images/allimage.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                                    } else if (fileItem.check_filetype == 'pdf') {
                                                        html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                                        html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/pdf.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";

                                                    } else if (fileItem.check_filetype === 'msword' || fileItem.check_filetype === 'vnd.openxmlformats-officedocument') {
                                                        html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                                        html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/msword_new.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                                    } else {
                                                        html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div><a href='" + fileItem.dl_file_url + "'>";
                                                        html += "<img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/general.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                                    }
                                                });
                                                html += "</div></div>";
                                            }
                                            //  else {
                                            //     html += "<td><div style='color: #31708f;'><span class='no-margin font-medium-xs bold' style='color: #1f7efabb;'>No Document Available</div></div></td>";
                                            // }
                                            html += "</td>";
                                        } else {
                                            html += "<td>";
                                            html += '<form class="file-opened-upload-form" data-task-id="' + item.id + '" enctype="multipart/form-data" style="width:100%;display:flex;justify-content:center;">';
                                            html += '<div class="drop-area" data-task-id="' + item.id + '">Drag & Drop or Click to Upload</div>';
                                            html += '<input type="file" class="dropzone-input" data-task-id="' + item.id + '" multiple style="display: none;" accept="image/*">';
                                            html += '</form>';
                                            html += '<div class="image-preview" data-task-id="' + item.id + '"></div>';
                                            // Check if file_data is present
                                            if (item.file_data.length > 0) {
                                                // if (item.status == 3 || item.status == 4) {
                                                var columnClass = (item.file_data.length == 1) ? 'col-md-12' : 'col-md-6';
                                                html += "<div style='overflow-y: scroll; max-height: 150px; width:330px;'><div style='max-height: 150px;'>";
                                                $.each(item.file_data, function (fileIndex, fileItem) {
                                                    var view_url = fileItem.file_url ? fileItem.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com") : '';
                                                    if (fileItem.check_filetype == 'jpeg' || fileItem.check_filetype == 'png' || fileItem.check_filetype == 'jpg' || fileItem.check_filetype == 'HEIC' || fileItem.check_filetype == 'heic') {
                                                        html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                                        html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height:50px; margin: 7px;' src='<?php echo base_url('assets/images/allimage.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                                    } else if (fileItem.check_filetype == 'pdf') {
                                                        html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                                        html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/pdf.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";

                                                    } else if (fileItem.check_filetype === 'msword' || fileItem.check_filetype === 'vnd.openxmlformats-officedocument') {
                                                        html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                                        html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/msword_new.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                                    } else {
                                                        html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div><a href='" + fileItem.dl_file_url + "'>";
                                                        html += "<img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/general.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                                    }
                                                });
                                                html += "</div></div>";
                                            } 
                                            // else {
                                            //     html += "<td><div style='color: #31708f;'><span class='no-margin font-medium-xs bold' style='color: #1f7efabb;'>No Documents Available</div></div></td>";
                                            // }
                                            html += "</td>";
                                        }
                                        if(sameGroup == true || sameGroup == 2){
                                            html += "<td style='display:flex;align-items:center;'><button  href='#' class='btn btn-danger btn-sm delete-checklist-link' data-id='" + item.id + "'><i class='fa fa-trash' style='color:white;'></i></button>";
                                            html += "<button class='btn btn-primary btn-sm' style='margin-left:8px;' id='update_checklist' href='#'  data-id='" + item.id + "'><i class='fas fa-edit'></i></button></td>";
                                        }else{
                                            html += "<td style='display:flex;align-items:center;'>-</td>";
                                        }
                                        html += "</tr>";
                                    }
                                });
                                j++;
                                // i am using the flag variable this variable is help me to check if checklist exist then append the checklist in table otherwise 
                                // it append the no checklist record table 
                                if (flag > 0) {
                                    html += "</tbody></table>";
                                    $("#data-container" + i).html(html);
                                    flag = 0;
                                } else {
                                    var html = "<table class='table dt-table table-ticket-reports dt-inline dataTable no-footer'>";
                                    html += "<thead><tr><th>Name</th><th>Description</th><th>Created at</th><th>Status</th><th>Documents</th><th>Action</th></tr></thead>";
                                    html += "<tbody id='checklist_table" + i + "'>";
                                    html += "</tbody>";
                                    html += "</table>";
                                    html += "<div id='no_checklist_record_found" + i + "' class='alert alert-info' style='margin-top:10px;'><span class='no-margin font-medium-xs bold' style='display: flex;justify-content: center;'>No Checklist available</span></div></div>";
                                    $("#data-container" + i).html(html);
                                }
                                // appened the outstanding table in appointment request stage
                                if (i == 3) {
                                    $("#appointment-data-container").html(html);
                                }
                            }
                            else {
                                var html = "<table class='table dt-table table-ticket-reports dt-inline dataTable no-footer'>";
                                html += "<thead><tr><th>Name</th><th>Description</th><th>Created at</th><th>Status</th><th>Documents</th><th>Action</th></tr></thead>";
                                html += "<tbody id='checklist_table" + i + "'>";
                                html += "</tbody>";
                                html += "</table>";
                                html += "<div id='no_checklist_record_found" + i + "' class='alert alert-info' style='margin-top:10px;'><span class='no-margin font-medium-xs bold' style='display: flex;justify-content: center;'>No Checklist available</span></div></div>";
                                $("#data-container" + i).html(html);
                                if (i == 3) {
                                    $("#appointment-data-container").html(html);
                                }
                            }
                        }
                    },
                    error: function (error) {
                        console.log('Error:', error);
                    }
                });
            }
            loadChecklistForBroker();
            loadChecklistDataForClient();
            loadStates_for_appointment();
            loadStates_request_for_funds();
            loadStates_outstanding_ld_team();
            loadStates_outstanding_ld_team_payouts();
            $("#post_appointment").click(function () {
                $("#checkbox_data,#show_post_appointment_checkboxes,#complete_post_appointment,#add_item_button_post_appointment").slideToggle();
                $('#add_custom_checkbox_for_appointment').hide();
            });
            $("#add_item_button_post_appointment").click(function () {
                $("#add_custom_checkbox_for_appointment").slideToggle();
            });
            $("#add_item_button_for_request_for_funds").click(function () {
                $("#add_custom_checkbox_for_request_for_funds").slideToggle();
            });
            $('#add_custom_checkbox, #add_custom_checkbox_for_appointment, #add_custom_checkbox_for_request_for_funds').submit(function (event) {
                event.preventDefault();
                $('.invalid-feedback').empty();
                var formData = $(this).serialize();
                var sameGroup = '<?php echo $samegroup; ?>';
                $('#outstanding_secure_btn').prop('disabled', true);
                $('#outstanding_secure_loader').addClass('loader');
                $.ajax({
                    type: 'POST',
                    url: '<?php echo base_url('admin/leads/add_checkboxes_for_appointment'); ?>',
                    data: formData,
                    dataType: 'json',
                    success: function (response) {
                        if (response.status === 'error') {
                            if (response.field === 'checkbox_title') {
                                $('#outstanding_secure_btn').prop('disabled', false);
                                $('#outstanding_secure_loader').removeClass('loader');
                                $('#checkbox_title_error').text(response.message);
                            } else if (response.field === 'checkbox_description') {
                                $('#checkbox_description_error').text(response.message);
                            }
                        } else {
                            $('#outstanding_secure_btn').prop('disabled', false);
                            $('#outstanding_secure_loader').removeClass('loader');
                            var anchor = document.querySelector('a[href="#lead_reminders"]');
                            destroyTinyMCE();
                            _lead_init_data(response, response.id);
                            $('a[href="' + response.leads_status + '"]').tab('show');
                            if (sameGroup != 2) {
                                $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                            }
                            $('#add_custom_checkbox')[0].reset();
                            // loadStates_for_appointment();
                            loadStates_request_for_funds();
                            alert_float('success', 'Checkbox added successfully.');
                            $('#lead_reminders').trigger('click');
                            if (response.leads_status == "#lead_reminders") {
                                anchor.click();
                                $('#show_post_appointment_checkboxes').toggle();
                                $('#checkbox_data').toggle();
                                $('#add_item_button_post_appointment').toggle();
                            }
                        }
                    },
                    error: function (xhr, status, error) {
                        $('#outstanding_secure_btn').prop('disabled', false);
                        $('#outstanding_secure_loader').removeClass('loader');
                        console.log('Error fetching data');
                    }
                });
            });
            // outstanding private secure charge store 
            // $("#private_store_secure_items").on("click", function () {
            //     $('#outstanding_secure_btn').prop('disabled', true);
            //     $('.full-page-loader').show();
            //     $.ajax({
            //         url: admin/leads/add_private_store_secure_items,
            //         type: "POST",
            //         data: {
            //             select_type_ld_outstanding_item: 7,
            //             leads_status_current_id: 3,
            //             lead_id: leadid,
            //         },
            //         success: function (response) {
            //             $('#outstanding_secure_btn').prop('disabled', false);
            //             $('.full-page-loader').hide();
            //             alert_float('success', 'Checkbox added successfully.');
            //             // destroyTinyMCE();
            //             // _lead_init_data(response, response.id);
            //             loadStates_outstanding_ld_team_payouts();
            //             $('a[href="#outstanding_items"]').tab('show');
            //             $('a[href="#outstanding_items"]').closest('div').addClass('step-active');
            //         },
            //         error: function (xhr, status, error) {
            //             $('#outstanding_secure_btn').prop('disabled', false);
            //             $('.full-page-loader').hide();
            //         }
            //     });
            // });
            // update the ld outstanding liset
            
            // update ajax of ld checklist ids
            $('#ld_update_checklist_form').submit(function (e) {
                var leadid = "<?php echo $lead->id ?>";
                $('#ld_update_checklist_form_loader').addClass('loader');
                $('#ld_update_checklist_item_btn').prop('disabled', true);
                e.preventDefault();
                $.ajax({
                    url: "<?php echo admin_url('leads/update_ld_checklist_item_by_id/' . $lead->id); ?>",
                    type: 'POST',
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: function (response) {
                        // Assuming the server responds with JSON
                        if (response.success) {
                            loadStates_outstanding_ld_team_payouts();
                            loadStates_request_for_funds();
                            loadStates_outstanding_ld_team();
                            $('#ld_update_checklist_form')[0].reset();
                            $('#ld_update_checklist_form_loader').removeClass('loader');
                            $('#ld_update_checklist_item_btn').prop('disabled', false);
                            var anchor = document.querySelector('.close');
                            anchor.click();
                            var anchor = document.querySelector('#ld_checklist_update_modal_close_btn');
                            anchor.click();
                            $('#ld_checklist_update_modal_close_btn').trigger('click');
                            // update the records
                            // var id = response.ld_checklist_id;
                            // var row = $('#ld_outstanding_item_tr_' + id);
                            // var description = response.update_item_ld_notes;
                            // var itemName = response.update_ld_item_name;
                            // var itemComments = response.update_ld_req_comments;
                            // if (row.length > 0) {
                            
                            //     alert_float('success', 'Item details updated successfully.');
                            // }
                            // setTimeout(function () {
                            //     destroyTinyMCE();
                            //     if (sameGroup != 2) {
                            //         _lead_init_data(response, response.id);
                            //     }
                            //     alert_float('success', 'Item details updated successfully.');
                            //     $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                            //     $('a[href="' + response.leads_status + '"]').tab('show');
                            // }, 500);
                            // $('#checklist_form')[0].reset();

                        } else {
                            $('#ld_update_checklist_form_loader').removeClass('loader');
                            $('#ld_update_checklist_item_btn').prop('disabled', false);
                            alert_float('danger', 'Item details not updated,Please refresh page and update again!');
                            // Display validation errors
                            if (response.errors) {
                            } else {
                            }
                        }
                    }
                });
            });
            // outstanding ld-team checkboxes for payouts 
            function loadStates_outstanding_ld_team_payouts() {
                var leadid = "<?php echo $lead->id ?>";
                var sameGroup = '<?php echo $samegroup; ?>';

                $.ajax({
                    type: 'GET',
                    url: '<?php echo base_url('admin/cases/show_all_checkboxes_for_outstanding_ld_team_payouts/'); ?>' + leadid,
                    dataType: 'json',
                    success: function (response) {
                        // Define both containers
                        const containers = [
                            $('#checkbox_lists_outstanding_ld_team_payouts'),
                            $('#checkbox_lists_outstanding_ld_team_payouts_file_summery')
                        ];

                        // Clear both containers
                        containers.forEach(container => container.empty());

                        const groupedData = {};
                        response.forEach(item => {
                            if (!groupedData[item.type]) groupedData[item.type] = [];
                            groupedData[item.type].push(item);
                        });

                        $.each(groupedData, function (type, items) {
                            let groupLabel = '';
                            if (type === 'secure_charge') groupLabel = 'Secure Charge';
                            else if (type === 'secure_private_charge_1') groupLabel = 'Secured Private Charge';
                            else if (type === 'postponements') groupLabel = 'Postponements';
                            else if (type === 'other_items') groupLabel = 'Other Items';
                            else if (type === 'app_general') groupLabel = 'General';
                            else groupLabel = type.replace(/_/g, ' ').replace(/\b\w/g, c => c.toUpperCase());

                            const headerRow = $('<tr class="type-heading-row">').css({
                                'background': '#ddd',
                                'font-weight': 'bold',
                            }).append(
                                $('<td colspan="7" style="text-align:center;font-size: larger;font-weight:900;">').text(groupLabel)
                            );

                            containers.forEach(container => container.append(headerRow.clone()));

                            if (type === 'secure_private_charge_1') {
                                const groupedByUniqueNumber = {};
                                items.forEach(item => {
                                    const uniqueNumber = item.unique_number || 'no-unique';
                                    if (!groupedByUniqueNumber[uniqueNumber]) {
                                        groupedByUniqueNumber[uniqueNumber] = [];
                                    }
                                    groupedByUniqueNumber[uniqueNumber].push(item);
                                });

                                Object.keys(groupedByUniqueNumber).forEach((uniqueKey, groupIndex) => {
                                    const groupItems = groupedByUniqueNumber[uniqueKey];

                                    groupItems.forEach((state, indexInGroup) => {
                                        const isParent = indexInGroup === 0;
                                        const description = state.description || '';
                                        const files = Array.isArray(state.get_cases_checkboxes_data) ? state.get_cases_checkboxes_data : [];

                                        containers.forEach(container => {
                                            const row = createStateRow(state, groupLabel, indexInGroup, sameGroup, description, files, container, isParent);
                                            container.append(row);
                                        });
                                    });
                                });
                            } else {
                                items.forEach((state, index) => {
                                    containers.forEach(container => {
                                        const row = createStateRow(state, groupLabel, index, sameGroup, state.description, state.get_cases_checkboxes_data || [], container, true);
                                        container.append(row);
                                    });
                                });
                            }
                        });
                    },
                    error: function (xhr, status, error) {
                        console.error('Error fetching data:', error);
                    }
                });
            }

            function createStateRow(state, labelType, index, sameGroup, description, files, container, isParentRow = true) {
                // const row = $('<tr>');
                const row = $('<tr>', {
                    'data-id': state.id,
                    'data-orderid': state.order_no,
                    'data-type': state.type
                });
                if (!isParentRow) {
                    row.css({
                        'background-color': '#f9f9f9',
                        'margin-left': '30px',
                        'margin-right': '30px',
                        'box-shadow': 'inset 5px 0px 5px -5px rgba(0,0,0,0.1)',
                        'border-left': '3px solid #ccc'
                    });
                }
                // ✅ Bulk Checkbox Cell
                const checkboxCell = $('<td>').append(
                    $('<input>', {
                        type: 'checkbox',
                        class: 'checklist-bulk-checkbox',
                        'data-id': state.id,
                        'data-type': state.type
                    })
                );

                const title = state.title?.trim() || '-';
                const uploadButton = $('<button>', {
                    class: 'btn btn-secondary',
                    id: 'ld_outstanding_item_modal_upload_doc_button_form',
                    'data-id': state.id,
                    'data-title': title,
                    'data-type': state.type,
                    html: '<i class="fa fa-upload" aria-hidden="true"></i>',
                    style: 'margin-left: 10px;'
                }).on('click', function () {
                    upload_doc_for_outstanding_ld_team(state.id, state.type, title);
                });

                const typeLabel = labelType === 'Secured Private Charge' ? ' / Payout Statement' : '';

                const typeCell = $('<td style="padding:10px;">').append(
                    $('<div>', {
                        style: 'display: flex; justify-content: space-between; align-items: center; width: 100%;'
                    }).append(
                        $('<div>').html(
                            isParentRow
                                ? `<strong>${labelType}</strong> / ${title} ${typeLabel}`
                                : `<span style="color:#555; padding-left: 20px;">${title}</span>`
                        ),
                        $('<div>').append(uploadButton)
                    )
                );

                var ldNotesLines = (description || '').split("\n").map(line => $.trim(line)).filter(line => line !== '');
                var ldNotesHtml = '<ul style="list-style-type: disc; padding-left: 18px;">';
                ldNotesLines.forEach(line => {
                    ldNotesHtml += `<li>${line}</li>`;
                });
                ldNotesHtml += '</ul>';
                const noteCell = $('<td class="item-notes">').html(ldNotesHtml || '-');

                const receivedCell = $('<td>');
                const selectedOption = state.secure_received_option || '';
                if (sameGroup !== "2" && sameGroup !== "false") {
                    const dropdown = $('<select>', {
                        class: 'form-control secure-received-select-status',
                        'data-id': state.id,
                        style: 'width: 125px;'
                    });
                    const options = ['Select option', 'N/A', 'No', 'Yes'];
                    options.forEach(opt => {
                        const val = opt === 'Select option' ? '' : opt;
                        dropdown.append($('<option>', {
                            value: val,
                            text: opt,
                            selected: selectedOption === opt
                        }));
                    });

                    if (selectedOption === 'Yes' || selectedOption === 'N/A') {
                        dropdown.css({ 'background-color': '#008000ba', color: '#fff' });
                    } else if (selectedOption === 'No') {
                        dropdown.css({ 'background-color': '#ff0000bf', color: '#fff' });
                    }

                    receivedCell.append(dropdown);
                } else {
                    receivedCell.text(selectedOption || '-');
                }

                const docCell = $('<td>');
                if (files.length > 0) {
                    files.forEach(file => {
                        const dlUrl = file.file_url?.replace(/raw=1$/, 'dl=1') || '';
                        const viewUrl = file.file_url?.replace('dl.dropboxusercontent.com', 'www.dropbox.com') || '';
                        const ext = (file.filetype || '').split('/')[1] || '';
                        let imageUrl = '<?php echo base_url("assets/images/general.webp"); ?>';

                        if (['jpeg', 'jpg', 'png', 'avif'].includes(ext)) {
                            imageUrl = '<?php echo base_url("assets/images/general.webp"); ?>';
                        } else if (['msword', 'vnd.openxmlformats-officedocument'].includes(ext)) {
                            imageUrl = '<?php echo base_url("assets/images/msword_new.webp"); ?>';
                        } else if (ext === 'pdf') {
                            imageUrl = '<?php echo base_url("assets/images/pdf.webp"); ?>';
                        }

                    const fileBlock = `
                        <div style="margin-bottom: 8px; text-align: center;">
                            <div style="display: flex; justify-content: center; gap: 10px; margin-bottom: 5px;">
                                <a href="${dlUrl}" download title="Download"><i class="fa fa-download"></i></a>
                                <a href="${viewUrl}" target="_blank" title="View"><i class="fa fa-eye"></i></a>
                                ${sameGroup !== "2" && sameGroup !== "false" ? `
                                    <a href="#" class="delete-file-btn" id="outstanding_ld_team_doc_delete" data-file-id="${file.id}" title="Delete">
                                        <i class="fa fa-trash" style="color: red;"></i>
                                    </a>` : ''
                                }
                            </div>
                            <a href="${dlUrl}" target="_blank">
                                <img loading="lazy" src="${imageUrl}" style="width: 50px; height: 50px; object-fit: cover;">
                            </a>
                        </div>`;
                    docCell.append(fileBlock);
                    });
                } else {
                    docCell.text('No Document Available');
                }

                const expCell = $('<td>');
                const expDate = state.payout_expire_date || '-';
                if (isParentRow) {
                    expCell.append(`<p class="payout_expire_date_show_${state.id}">Expiry Date: ${expDate}</p>`);
                    if (sameGroup !== "2" && sameGroup !== "false") {
                        const input = $('<input>', {
                            type: 'date',
                            class: 'form-control secure-expire-date-update',
                            'data-id': state.id
                        });
                        expCell.append(input);
                    }
                } else {
                    expCell.text('-');
                }

                const actionCell = $('<td style="display:flex;">');
                if (sameGroup !== "2" && sameGroup !== "false") {
                    actionCell.append(`<button data-id="${state.id}" class="btn btn-danger delete-btn"><i class="fa fa-trash"></i></button>`);
                    actionCell.append(`<button data-id="${state.id}" data-type="payout" class="btn btn-primary" id="edit_ld_checklist_item" style="margin-left: 5px;"><i class="fa fa-edit"></i></button>`);
                } else {
                    actionCell.text('-');
                }

                // row.append(typeCell, noteCell, receivedCell, docCell, expCell, actionCell);
                row.append(checkboxCell, typeCell, noteCell, receivedCell, docCell, expCell, actionCell);
                container.append(row);
            }



            // outstanding checkboxes
            function loadStates_outstanding_ld_team() {
                var leadid = "<?php echo $lead->id ?>";
                var sameGroup = '<?php echo $samegroup; ?>';
                $.ajax({
                    type: 'GET',
                    url: '<?php echo base_url('admin/cases/show_all_checkboxes_for_outstanding_ld_team/'); ?>' + leadid,
                    dataType: 'json',
                    success: function (response) {
                        $('#checkbox_lists_outstanding_ld_team').empty();
                        $('#outstanding_ld_team_checkboxes').empty();

                        $.each(response, function (index, state) {
                            // Create the checkbox input
                            var checkbox = $('<input>', {
                                type: 'checkbox',
                                id: 'checkbox_' + state.id,
                                class: 'checkbox-input',
                                checked: state.status == 1,
                                change: function () {
                                    var checkboxId = $(this).attr('id').replace('checkbox_', '');
                                    var isChecked = $(this).prop('checked');
                                    var label = $(this).closest('button').find('label');

                                    // Toggle del tag based on checkbox state
                                    if (isChecked) {
                                        label.wrapInner('<del style="display:flex;justify-content: center;align-items: center;">');
                                    } else {
                                        label.find('del').contents().unwrap();
                                    }
                                }
                            });

                            // Create the label container
                            var labelContainer = $('<label>', {
                                style: 'display: flex; justify-content: center; align-items: center; margin-top: 10px; padding-left: 10px;'
                            }).html('<b style="font-weight: 800;">' + state.title + ':</b> ' + state.description);
                            // Wrap the label in <del> if state is active
                            if (state.status == 1) {
                                labelContainer.wrapInner('<del style="display:flex;justify-content: center;align-items: center;">');
                            }

                            // Create the checkbox button and append input and label inside it
                            var checkboxButton = $('<button>', {
                                style: 'margin-right: 15px; margin-top: 10px; background-color: #9ebeff80; border-radius: 7px; border: 0; padding: 9px 20px; display: flex; justify-content: center; align-items: center;',
                                'data-id': state.id,
                                class: 'checkbox-button',
                                click: function () {
                                    var checkboxId = $(this).attr('data-id');
                                    var checkbox = $('#checkbox_' + checkboxId);
                                    var isChecked = checkbox.prop('checked');
                                    checkbox.prop('checked', !isChecked).change();
                                }
                            });

                            // Append checkbox and label to button
                            checkboxButton.append(checkbox);
                            checkboxButton.append(labelContainer);

                            // Create a div to hold the button and optionally the additional buttons
                            var colDiv = $('<div>', {
                                class: 'col-md-12',
                                style: 'display: flex; align-items: center;'
                            });
                            colDiv.append(checkboxButton);
                            // Titles to exclude
                            var excludeTitles = [
                                'PURPOSE OF FUNDS',
                                'Post app VC check: bank name ABC, last 3 digits 486 for net funds - if cheque not available, call cl'
                            ];

                            // Check if the state.title matches any of the excluded titles (case-insensitive)
                            var shouldExclude = excludeTitles.some(function (excludeTitle) {
                                return state.title.trim().toLowerCase() === excludeTitle.toLowerCase();
                            });

                            if (!shouldExclude) {
                                // Add Upload button
                                var uploadButton = $('<button>', {
                                    class: 'btn btn-secondary',
                                    id: 'ld_outstanding_item_modal_upload_doc_button_form',
                                    'data-id': state.id,
                                    'data-title': state.title,
                                    'data-type': state.type,
                                    html: '<i class="fa fa-upload" aria-hidden="true"></i>',
                                    style: 'float: right;'
                                });
                                // Attach click event handler to the upload button
                                uploadButton.click(function () {
                                    var stateId = $(this).attr('data-id');
                                    var statetitle = $(this).attr('data-title');
                                    var statetype = $(this).attr('data-type');
                                    upload_doc_for_outstanding_ld_team(stateId, statetype, statetitle);
                                });
                                colDiv.append(uploadButton);
                            }
                            // Append the colDiv to the outstanding_ld_team_checkboxes div
                            $('#outstanding_ld_team_checkboxes').append(colDiv);

                            // var newRow = $('<tr>');
                            var newRow = $('<tr>', {
                                id: 'ld_outstanding_item_tr_' + state.id,
                                'data-id': state.id,
                                'data-orderid': state.order_no,
                                'data-type': state.type,
                            });

                            // Create a new table row for the state
                            var bulkCheckboxCell = $('<td>').append(
                                $('<input>', {
                                    type: 'checkbox',
                                    class: 'checklist-bulk-checkbox',
                                    'data-id': state.id,
                                    'data-type': state.type
                                })
                            );
                            newRow.append(bulkCheckboxCell);

                            var cell = $('<td style="display:flex;justify-content:space-between;align-items:center;"><span class="item-name">' + state.title + '</span></td>');
                            if (sameGroup != 2 && sameGroup) {
                                cell.append(uploadButton);
                            }
                            newRow.append(cell);
                            // show the notes for other ld outstanding table
                            var descriptionCell;

                            if (sameGroup != 2 && sameGroup != false) {
                                var outstanding_ld_others_description = state.description.split("\n");
                                var ld_notes_Html = "<td class='item-notes'><ul style='list-style-type: disc;'>";

                                $.each(outstanding_ld_others_description, function (index, line) {
                                    var ld_notes_Line = $.trim(line);
                                    if (ld_notes_Line !== "") {
                                        ld_notes_Html += "<li>" + ld_notes_Line + "</li>";
                                    }
                                });

                                ld_notes_Html += "</ul></td>";
                                descriptionCell = $(ld_notes_Html);
                            } else {
                                descriptionCell = $("<td class='item-notes'>-</td>");
                            }

                            newRow.append(descriptionCell);

                            // other items received or not 
                            var secure_received_section = $('<td>');
                            var selectedOption = state.secure_received_option || '';
                              if (sameGroup != 2 && sameGroup != false) {
                                // Apply color class
                                var background_color = '';
                                if (selectedOption === 'Yes' || selectedOption === 'N/A') {
                                    background_color = 'color: #ffffff; background-color:#008000ba';
                                } else if (selectedOption === 'No') {
                                    background_color = 'color: #ffffff; background-color:#ff0000bf';
                                }
                                var selectDropdown = $('<select>', {
                                    class: 'form-control secure-received-select-status',
                                    style: 'width: 125px;' + background_color,
                                    'data-id': state.id
                                });

                                selectDropdown.append(
                                    $('<option>', { value: '', text: 'Select option', selected: selectedOption === '' }),
                                    $('<option>', { value: 'N/A', text: 'N/A', selected: selectedOption === 'N/A' }),
                                    $('<option>', { value: 'No', text: 'No', selected: selectedOption === 'No' }),
                                    $('<option>', { value: 'Yes', text: 'Yes', selected: selectedOption === 'Yes' })
                                );
                                secure_received_section.append(selectDropdown);
                            }else {
                                secure_received_section.text(selectedOption || '-');
                            }
                            newRow.append(secure_received_section);
                            // newRow.append('<td>' + state.created_at + '</td>');

                            // Create a cell for the files
                            var filesColumn = $('<td>');
                            // Create a scrollable container for files with inline styles
                            var filesColumnContainer = $('<div></div>').css({
                                'height': '300px',
                                'overflow-y': 'auto',
                                'border': '1px solid #ddd',
                                'padding': '10px'
                            });

                            // Add files associated with the checkbox
                            if (state.get_cases_checkboxes_data && state.get_cases_checkboxes_data.length > 0) {
                                var imageCount = 0;
                                $.each(state.get_cases_checkboxes_data, function (i, item) {
                                    // var modifiedFileUrl = item.file_url.replace(/raw=1$/, 'dl=1');
                                    var modifiedFileUrl = item.file_url ? item.file_url.replace(/raw=1$/, 'dl=1') : '';
                                    var view_url = item.file_url ? item.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com") : '';
                                    var filetypeParts = item.filetype ? item.filetype.split('/') : '';
                                    var extension = filetypeParts[1];
                                    var imageUrl;

                                    if (extension === 'jpeg' || extension === 'jpg' || extension === 'png' || extension === 'avif') {
                                        imageUrl = '<?php echo base_url("assets/images/general.webp"); ?>';
                                    } else if (extension === 'msword' || extension === 'vnd.openxmlformats-officedocument') {
                                        imageUrl = '<?php echo base_url("assets/images/msword_new.webp"); ?>';
                                    } else if (extension === 'pdf') {
                                        imageUrl = '<?php echo base_url("assets/images/pdf.webp"); ?>';
                                    } else {
                                        imageUrl = '<?php echo base_url("assets/images/general.webp"); ?>';
                                    }
                                    var payoutsdate = new Date(item.payout_expire_date);
                                    var payouts_formattedDate = payoutsdate.toLocaleDateString();
                                    var regex = /payout\s*statement(s?|\(s\))|info\s*statement(s?|\(s\))|info\s*statement|infostatement(s?)|Info\s*Statement|InfoStatement(s?)/i;
                                    if (regex.test(state.title.trim())) {
                                        var lenderNameHtml = item.lender_name ? `<p style="margin-top: 15px;">Lender's Name: ${item.lender_name}</p>` : '';
                                        var payoutExpireDateHtml = item.payout_expire_date ? `<p>Expiry Date: ${payouts_formattedDate}</p>` : '';
                                    } else {
                                        var lenderNameHtml = '';
                                        var payoutExpireDateHtml = '';
                                    }
                                    var fileContainer = `
                                            <div style="border-bottom: 1px solid #ddd; padding: 10px; margin-bottom: 10px;">
                                                <div style="align-items: center; margin: 6px 13px; justify-content: center;">
                                                    <a href="${modifiedFileUrl}" download><i class="fa fa-download" aria-hidden="true"></i></a>
                                                    <a href="${view_url}" target="_blank"><i style="margin-left: 5px;" class="fa fa-eye" aria-hidden="true"></i></a>
                                                    ${sameGroup != 2 && sameGroup ? `<a href="#" class="delete-file-btn" id="outstanding_ld_team_doc_delete" data-file-id="${item.id}" style="margin-left: 5px;"><i class="fa fa-trash" style="color: red;"></i></a>` : ''}
                                                </div>
                                                <a href="${modifiedFileUrl}" target="_blank">
                                                    <img loading="lazy" src="${imageUrl}" style="width: 50px; height: 50px; object-fit: cover; margin-top: 10px;">
                                                </a>
                                                ${lenderNameHtml}
                                                ${payoutExpireDateHtml}
                                            </div>`;
                                    // Append the file container to the filesColumnContainer
                                    filesColumnContainer.append(fileContainer);
                                    imageCount++;
                                });
                                if (imageCount === 1) {
                                    filesColumnContainer.css('height', '150px');
                                }
                                // Append the scrollable container to filesColumn
                                filesColumn.append(filesColumnContainer);
                            } else {
                                filesColumn.html('<p>No Document Available</p>');
                            }
                            newRow.append(filesColumn);
                            if (sameGroup != 2 && sameGroup != false) {
                                // Create the action column with a delete button
                                var actionColumn = $('<td style="display:flex;justify-content:center;align-items:center;">');
                                actionColumn.append('<button data-id="' + state.id + '" class="btn btn-danger delete-btn" id="delete-btn" style="margin-left: 5px;"><i class="fa fa-trash"></i></button>');
                                actionColumn.append('<button data-id="' + state.id + '" data-type="payout" class="btn btn-primary " id="edit_ld_checklist_item" style="margin-left: 5px;"><i class="fa fa-edit"></i></button>');
                                newRow.append(actionColumn);
                            } else {
                                var actionColumn = $('<td>');
                                actionColumn.append('-');
                                newRow.append(actionColumn);
                            }

                            // Append the new row to the checkbox lists table
                            $('#checkbox_lists_outstanding_ld_team').append(newRow);
                        });
                    },
                    error: function (xhr, status, error) {
                        console.error('Error fetching data:', error);
                    }
                });
            }

            function loadStates_request_for_funds() {
                var leadid = "<?php echo $lead->id ?>";
                var sameGroup = '<?php echo $samegroup; ?>';
                $.ajax({
                    type: 'GET',
                    url: '<?php echo base_url('admin/cases/show_all_checkboxes_for_requrest_funds/'); ?>' + leadid,
                    dataType: 'json',
                    success: function (response) {
                        $('#checkbox_lists_request_funds').empty();
                        // $('#request_for_funds_checkboxes').empty();

                        $.each(response, function (index, state) {
                            // Create the checkbox input
                            var checkbox = $('<input>', {
                                type: 'checkbox',
                                id: 'checkbox_' + state.id,
                                class: 'checkbox-input',
                                checked: state.status == 1,
                                change: function () {
                                    var checkboxId = $(this).attr('id').replace('checkbox_', '');
                                    var isChecked = $(this).prop('checked');
                                    var label = $(this).closest('button').find('label');

                                    // Toggle del tag based on checkbox state
                                    if (isChecked) {
                                        label.wrapInner('<del style="display:flex;justify-content: center;align-items: center;">');
                                    } else {
                                        label.find('del').contents().unwrap();
                                    }
                                }
                            });

                            // Create the label container
                            var labelContainer = $('<label>', {
                                style: 'display: flex; justify-content: center; align-items: center; margin-top: 10px; padding-left: 10px;'
                            }).html('<b style="font-weight: 800;">' + state.title + ':</b> ' + state.description);

                            // Wrap the label in <del> if state is active
                            if (state.status == 1) {
                                labelContainer.wrapInner('<del style="display:flex;justify-content: center;align-items: center;">');
                            }

                            // Create the checkbox button and append input and label inside it
                            var checkboxButton = $('<button>', {
                                style: 'margin-right: 15px; margin-top: 10px; background-color: #9ebeff80; border-radius: 7px; border: 0; padding: 9px 20px; display: flex; justify-content: center; align-items: center;',
                                'data-id': state.id,
                                class: 'checkbox-button',
                                click: function () {
                                    var checkboxId = $(this).attr('data-id');
                                    var checkbox = $('#checkbox_' + checkboxId);
                                    var isChecked = checkbox.prop('checked');
                                    checkbox.prop('checked', !isChecked).change(); 
                                }
                            });

                            // Append checkbox and label to button
                            checkboxButton.append(checkbox);
                            checkboxButton.append(labelContainer);

                            // Create a div to hold the button and optionally the additional buttons
                            var colDiv = $('<div>', {
                                class: 'col-md-12',
                                style: 'display: flex; align-items: center;'
                            });
                            colDiv.append(checkboxButton);
                            if (sameGroup != 2 && sameGroup != false) {
                                // closing email button work
                                // if (state.title === 'Send Report to Client/copy to broker/ holdback information' || state.title === 'Send Final Report to Client, cc broker') {
                                //     const $target = $('.closed_complete_stage');

                                //     if ($target.length > 0) {
                                //         $target.attr({
                                //             'data-id': state.id,
                                //             'data-title': state.title,
                                //             'id': 'upload_doc_request_for_funds'
                                //         });
                                //     }
                                // }

                                // Add Upload button
                                var uploadButton = $('<button>', {
                                    class: 'btn btn-secondary',
                                    id: 'upload_doc_request_for_funds',
                                    'data-id': state.id,
                                    'data-title': state.title,
                                    html: '<i class="fa fa-upload" aria-hidden="true"></i>',
                                    style: 'float: right;'
                                });
                                // Attach click event handler to the upload button
                                uploadButton.click(function () {
                                    var stateId = $(this).attr('data-id');
                                    var statetitle = $(this).attr('data-title');

                                    var regex = /Send\s*Report\s*To\s*Client|Send\s*report\s*to\s*client|Send\s*Report\s*to\s*client|Send\s*Report\s*to\s*Client|Send\s*Final\s*Report\s*to\s*Client,\s*cc\s*broker/i;

                                    if (regex.test(statetitle.trim())) {
                                        $('#send_report_content_toggle').show();
                                        $('#closed_mail_review').show();
                                        $('#send_report_cc_bcc').show();
                                        upload_doc_for_request_for_funds(stateId, 'send-report');
                                    } else {
                                        $('#send_report_content_toggle').hide();
                                        $('#send_report_cc_bcc').hide();
                                        $('#closed_mail_review').hide();
                                        upload_doc_for_request_for_funds(stateId, '');
                                    }
                                });
                                colDiv.append(uploadButton);
                                if (index === 2) {
                                    var extraRow = $('<tr>');
                                    extraRow.append('<td>RFF, update client/broker</td>');

                                    var brokerMailButton = $('<button>', {
                                        class: 'btn btn-primary',
                                        id: 'broker_mail_funds_requested',
                                        text: 'Update client/broker re RFF',
                                        style: 'margin-left: 5px; margin-right: 15px;'
                                    });

                                    var brokerMailButtonCell = $('<td></td>');
                                    brokerMailButtonCell.append(brokerMailButton);
                                    extraRow.append(brokerMailButtonCell);

                                    extraRow.append('<td></td>'); // Empty cell
                                    extraRow.append('<td></td>'); // Empty cell

                                    $('#checkbox_lists_request_funds').append(extraRow);
                                }
                            }
                            // Create a new table row for the state
                            // var newRow = $('<tr>');
                            var newRow = $('<tr>', {
                                id: 'request_for_funds_tr_' + state.id,
                                'data-id': state.id,
                                'data-orderid': state.order_no,
                                'data-type': state.type
                            });
                            
                            // ✅ Master Checkbox Column
                            var bulkCheckboxCell = $('<td>').append(
                                $('<input>', {
                                    type: 'checkbox',
                                    class: 'checklist-bulk-checkbox',
                                    'data-id': state.id,
                                    'data-type': state.type
                                })
                            );
                            newRow.append(bulkCheckboxCell);

                            // newRow.append('<td>' + state.title + '</td>');
                            newRow.append('<td>' + state.title + '</td>');
                            var uploadButton_row = $('<td></td>');
                            uploadButton_row.append(uploadButton);
                            newRow.append(uploadButton_row);
                            var actionDate = '-';

                            if (state.req_for_funds_action_at) {
                                var dateObj = new Date(state.req_for_funds_action_at);
                                var day = String(dateObj.getDate()).padStart(2, '0');
                                var month = String(dateObj.getMonth() + 1).padStart(2, '0');
                                var year = dateObj.getFullYear();
                                actionDate = `${day}-${month}-${year}`;
                            }

                            newRow.append('<td>' + actionDate + '</td>');
                            newRow.append('<td>' + (state.req_comments ? state.req_comments : '-') + '</td>');
                            // Create a cell for the files
                            var filesColumn = $('<td>');

                            // Add files associated with the checkbox
                            if (state.get_cases_checkboxes_data && state.get_cases_checkboxes_data.length > 0) {
                                $.each(state.get_cases_checkboxes_data, function (i, item) {
                                    // var modifiedFileUrl = item.file_url.replace(/raw=1$/, 'dl=1');
                                    var modifiedFileUrl = item.file_url ? item.file_url.replace(/raw=1$/, 'dl=1') : '';
                                    var view_url = item.file_url ? item.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com") : '';
                                    var filetypeParts = item.filetype ? item.filetype.split('/') : '';
                                    var extension = filetypeParts[1];
                                    var imageUrl;

                                    if (extension === 'jpeg' || extension === 'jpg' || extension === 'png' || extension === 'avif') {
                                        // imageUrl = item.file_url;
                                        imageUrl = '<?php echo base_url("assets/images/allimage.webp"); ?>';
                                    } else if (extension === 'msword' || extension === 'vnd.openxmlformats-officedocument') {
                                        imageUrl = '<?php echo base_url("assets/images/msword_new.webp"); ?>';
                                    } else if (extension === 'pdf') {
                                        imageUrl = '<?php echo base_url("assets/images/pdf.webp"); ?>';
                                    } else {
                                        imageUrl = '<?php echo base_url("assets/images/general.webp"); ?>';
                                    }

                                    var fileContainer = '<div class="file-container">' +
                                        '<div class="col-md-12">' +
                                        '<div class="col-md-12" style="display: flex; align-items: center;margin:6px 0px;">' +
                                        '<a href="' + modifiedFileUrl + '"><i class="fa fa-download" aria-hidden="true"></i></a>' +
                                        '<a href="' + view_url + '" target="_blank"><i style="margin-left:5px;" class="fa fa-eye" aria-hidden="true"></i></a>' +
                                        '<a href="#" class="delete-file-btn" id="request_for_funds_doc_delete" data-file-id="' + item.id + '" style="margin-left: 5px;"><i class="fa fa-trash" style="color:red;"></i></a>' +
                                        '</div>' +
                                        '<a href="' + modifiedFileUrl + '" target="_blank">' +
                                        '<img loading="lazy" src="' + imageUrl + '" style="width: 50px; height: 50px; object-fit: cover;">' +
                                        '</a>' +
                                        '</div>' +
                                        '</div>';

                                    filesColumn.append(fileContainer);
                                });

                                // Wrap the filesColumn in a scrollable div
                                var scrollableDiv = '<div style="max-height: 300px; overflow-y: auto; overflow-x: hidden;">' + filesColumn.html() + '</div>';
                                filesColumn.html(scrollableDiv);
                            }
                            newRow.append(filesColumn);
                            if (sameGroup != 2 && sameGroup != false) {
                                // Create the action column with a delete button
                                var actionColumn = $('<td style="display:flex;justify-content:center;align-items:center;">');
                                actionColumn.append('<button data-id="' + state.id + '" class="btn btn-danger delete-btn" id="delete-btn" style="margin-left: 5px;"><i class="fa fa-trash"></i></button>');
                                actionColumn.append('<button data-id="' + state.id + '" class="btn btn-primary" id="edit_ld_checklist_item" style="margin-left: 5px;"><i class="fa fa-edit"></i></button>');
                                newRow.append(actionColumn);
                            }
                            if (
                                state.title.includes('Send Report to Client/copy to broker/ holdback information') ||
                                state.title.includes('Final Report to Client/Lender (set LRO docket to Inactive)') ||
                                state.title.includes('Send Final Report to Client, cc broker') ||
                                state.title.includes('Final Report to Lender, set LRO docket to Inactive') 
                            ) {
                                $('#rff_last_two_items').append(newRow);
                            } else {
                                // Append the new row to the checkbox lists table
                                $('#checkbox_lists_request_funds').append(newRow);
                            }
                        });
                    },
                    error: function (xhr, status, error) {
                        console.error('Error fetching data:', error);
                    }
                });
            }

            function loadStates_for_appointment() {
                var leadid = "<?php echo $lead->id ?>";
                $.ajax({
                    type: 'GET',
                    url: '<?php echo base_url('admin/cases/show_all_checkboxes_for_appointment/'); ?>' + leadid,
                    dataType: 'json',
                    success: function (response) {
                        $('#checkbox_lists_for_appointment').empty();
                        $('#show_post_appointment_checkboxes').empty();
                        $.each(response, function (index, state) {
                            var checkboxButton = $('<button style="margin-right:15px;margin-top: 10px;background-color: #9ebeff80;border-radius: 7px;border: 0;padding: 9px 20px;">')
                                .attr('data-id', state.id)
                                .addClass('checkbox-button')
                                .on('click', function () {
                                    var checkboxId = $(this).attr('data-id');
                                    var checkbox = $('#checkbox_' + checkboxId);
                                    var isChecked = checkbox.prop('checked');
                                    checkbox.prop('checked', !isChecked);
                                    // updateCheckboxStatus(checkboxId, !isChecked);
                                });

                            var colDiv = $('<div class="col-md-12" style="display:flex;justify-content: center;align-items: center;"></div>');

                            var checkbox = $('<input>')
                                .attr('type', 'checkbox')
                                .attr('id', 'checkbox_' + state.id)
                                .addClass('checkbox-input')
                                .prop('checked', state.status == 1)
                                .on('change', function () {
                                    var checkboxId = $(this).attr('id').replace('checkbox_', '');
                                    var isChecked = $(this).prop('checked');
                                    var label = $(this).closest('div').find('label');

                                    // Toggle del tag based on checkbox state
                                    if (isChecked) {
                                        label.wrapInner('<del style="display:flex;justify-content: center;align-items: center;">');
                                    } else {
                                        label.find('del').contents().unwrap();
                                    }
                                });

                            colDiv.append(checkbox);

                            var labelContainer = $('<label style="display: flex;justify-content: center;align-items: center;margin-top:10px;padding-left:10px;"></label>');
                            labelContainer.append('<bold style="font-weight: 800;">' + state.title + ':</bold>' + state.description + '</p>');
                            if (state.status == 1) {
                                labelContainer.wrapInner('<del style="display:flex;justify-content: center;align-items: center;">');
                            }
                            colDiv.append(labelContainer);
                            checkboxButton.append(colDiv);
                            $('#show_post_appointment_checkboxes').append(checkboxButton);

                            var newRow = $('<tr>');
                            newRow.append('<td>' + state.title + '</td>');
                            newRow.append('<td>' + state.description + '</td>');
                            var actionColumn = $('<td>');
                            // Delete button
                            actionColumn.append('<button data-id="' + state.id + '" class="btn btn-danger delete-btn" id="delete-btn" style="margin-left:5px;">Delete</button>');
                            newRow.append(actionColumn);
                            $('#checkbox_lists_for_appointment').append(newRow);
                        });
                    },
                    error: function (xhr, status, error) {
                        // console.error('Error fetching data:', error);
                    }
                });
            }
            // secure payout expire dates updates
            $(document).off('change', '.secure-expire-date-update').on('change', '.secure-expire-date-update', function () {
                let expireDate = $(this).val();
                var dataId = $(this).data('id');
                $('.full-page-loader').show();
                $.ajax({
                    url: '<?php echo base_url('admin/cases/update_secure_payout_expire_date/' . $lead->id); ?>',
                    type: 'POST',
                    data: {
                        expire_date: expireDate,
                        id: dataId
                    },
                    success: function (response) {
                        $('.full-page-loader').hide();
                        if (response.success) {
                        //    var formattedExpireDate = new Date(expireDate).toLocaleDateString();
                            $('.payout_expire_date_show_' + dataId).text('Expiry Date: ' + expireDate);
                            alert_float('success', 'Secure payout expire date updated successfully!');
                        } else {
                            alert_float('danger', 'Secure payout expire date not updated!');
                        }
                    },
                    error: function (xhr, status, error) {
                        $('.full-page-loader').hide();
                         alert_float('danger', 'something wrong secure payout expire date not updated properly!');
                        console.error('Update failed:', error);
                    }
                });
            });
            // update the secure received item yes/no
           $(document).off('change', '.secure-received-select-status').on('change', '.secure-received-select-status', function () {
                var dropdown = $(this);
                var dataId = dropdown.data('id');
                var selectedValue = dropdown.val();

                if (!dataId || selectedValue === '') {
                    alert_float('danger', 'Invalid selection. Please try again.');
                    return;
                }
                // set the color of dropdown porpelry
                 if (selectedValue === 'Yes' || selectedValue === 'N/A') {
                    $(this).css({
                        'background-color': '#008000bf',
                        'color': '#ffffff'
                    });
                } else if (selectedValue === 'No') {
                    $(this).css({
                        'background-color': '#ff0000b3',
                        'color': '#ffffff'
                    });
                } else {
                    $(this).css({
                        'background-color': '',
                        'color': ''
                    });
                }

                $('.full-page-loader').show();

                $.ajax({
                    url: '<?= base_url('admin/cases/update_secure_received/' . $lead->id); ?>',
                    type: 'POST',
                    data: {
                        id: dataId,
                        secure_received_option: selectedValue
                    },
                    dataType: 'json',
                    success: function (response) {
                        $('.full-page-loader').hide();
                        if (response.success) {
                            alert_float('success', response.message || 'Secure Received updated successfully!');
                        } else {
                            alert_float('danger', response.message || 'Secure Received not updated properly!');
                        }
                    },
                    error: function (xhr, status, error) {
                        $('.full-page-loader').hide();
                        alert_float('danger', 'AJAX Error: ' + error);
                    }
                });
            });
            // Detelete button code 
            // var confirmationShown = false;
            $(document).off('click', '.delete-btn').on('click', '.delete-btn', function () {
                // if (!confirmationShown) {
                var stateId = $(this).data('id');
                var row = $(this).closest('tr');

                // if (confirm("Are you sure you want to delete this record?")) {
                    // confirmationShown = true;
                    $('.full-page-loader').show();
                    setTimeout(function () {
                        $('#full_page_loader').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                    }, 200);
                    $.ajax({
                        type: 'POST',
                        url: '<?php echo base_url('admin/cases/delete_checkbox_for_appointment/' . $lead->id); ?>',
                        data: { id: stateId },
                        dataType: 'json',
                        success: function (response) {
                            if (response.status == 'success') {
                                $('.full-page-loader').hide();
                                row.fadeOut(400, function () {
                                    $(this).remove();
                                });
                                $('.checkbox-button[data-id="' + stateId + '"]').fadeOut(400, function () {
                                    $(this).remove();
                                });
                                alert_float('success', 'Record deleted successfully.');
                            } else {
                                alert_float('error', 'Failed to delete record!');
                            }
                        },
                        error: function (xhr, status, error) {
                            // console.error(xhr.responseText);
                        }
                    });
                    // }
                // }
            });

        
            $(document).off('click', '.checkbox-button').on('click', '.checkbox-button', function () {
                var checkboxId = $(this).data('id');
                var checkbox = $('#checkbox_' + checkboxId);
                var isChecked = checkbox.prop('checked');
                var label = checkbox.closest('div').find('label');

                $.ajax({
                    type: 'POST',
                    url: '<?php echo base_url('admin/cases/update_checkbox_status'); ?>',
                    data: { id: checkboxId },
                    dataType: 'json',
                    success: function (response) {
                        if (response.status === 'success') {
                            checkbox.prop('checked', response.checked);
                            if (response.checked) {
                                label.wrapInner('<del style="display:flex;justify-content: center;align-items: center;">');
                            } else {
                                label.find('del').contents().unwrap();
                            }
                            alert_float('success', 'Checklist Item Status updated.');
                        } else {
                            alert_float('error', response.message);
                        }
                    },
                    error: function (xhr, status, error) {
                        // console.error(xhr.responseText);
                    }
                });
            });
            $(document).on('change', '.checkbox-input', function () {
            });
      


            // file opened item list
            function destroyTinyMCE() {
                tinymce.remove();
                if (tinymce.editors.length > 0) {
                    tinymce.editors.forEach(function (editor) {
                        editor.remove();
                    });
                }
            }
            file_opened_checkboxes();
            file_opened_checkboxes_broker();
            file_opened_get_checklist_images_for_all_borrower('client', '');
            // drag and drop table row working
            $(function () {
                const sortableSelectors = [
                    "#data-container_broker1",
                    "#data-container_broker_outstanding",
                    "#data-container1",
                    "#data-container2",
                    "#data-container3",
                    "#data-container4",
                    "#checklist_table2",
                    "#checklist_table3",
                    "#checklist_table4",
                    "#checklist_table5",
                    "#file_opened_checklist_item_for_borrower",
                    "#checkbox_lists_outstanding_ld_team",
                    "#checkbox_lists_outstanding_ld_team_payouts",
                    "#rff_last_two_items",
                    "#checkbox_lists_request_funds"
                ].join(", ");

                $(sortableSelectors).sortable({
                    items: "tr",
                    cursor: "move",
                    axis: "y",
                    placeholder: "sortable-placeholder",

                    helper: function (e, tr) {
                    const $originalCells = tr.children();
                    const $helper = $('<div class="flex-helper-row">');

                    $originalCells.each(function () {
                        const $orig = $(this);
                        const $cell = $('<div class="flex-helper-cell">').html($orig.html());

                        $cell.css({
                        width: $orig.outerWidth(),
                        padding: $orig.css('padding'),
                        'text-align': $orig.css('text-align'),
                        'white-space': 'nowrap'
                        });

                        $helper.append($cell);
                    });

                    return $helper;
                    },

                    start: function (e, ui) {
                    ui.placeholder.height(ui.helper.outerHeight());
                    },

                    stop: function (e, ui) {
                    ui.item.removeClass('dragging-row');
                    },

                    update: function (event, ui) {
                        let orderData = [];
                        // $(this).find("tr").each(function () {
                        //     order.push($(this).data("id"));
                        // });
                        $(this).find("tr").each(function (index) {
                            orderData.push({
                                id: $(this).data("id"),
                                orderid: $(this).data("orderid"),
                                type: $(this).data("type"), // ensure this is present in <tr>
                                order: index + 1
                            });
                        });
                        console.log("New order for", orderData);
                        $.ajax({
                            url: "<?php echo admin_url('leads/update_task_order/' . $lead->id); ?>",
                            method: 'POST',
                            data: {
                                task_order: orderData
                            },
                            success: function (response) {
                                console.log('Order saved:', response);
                            },
                            error: function (xhr, status, error) {
                                console.error('Failed to save order:', error);
                            }
                        });
                    }
                }).disableSelection();
            });

            function file_opened_get_checklist_images_for_all_borrower(type, borrower_id = '') {
                $.ajax({
                    url: "<?php echo admin_url('leads/get_all_borrower_client_doc/' . $lead->id . '/1/'); ?>" + type + '/' + borrower_id,
                    type: "GET",
                    dataType: "json",
                    success: function (response) {
                        var targetElement;
                        if (type == 'client') {
                            if (borrower_id) {
                                targetElement = $("#checklist_images_borrower_" + borrower_id);
                            } else {
                                targetElement = $("#first_client_images");
                            }
                        } else if (type = 'broker') {
                            targetElement = $("#file_opened_broker_images_show");
                        }

                        targetElement.empty();

                        var groupedTasks = {};

                        // Group files by task_name
                        response.forEach(function (fileItem) {
                            if (!groupedTasks[fileItem.task_name]) {
                                groupedTasks[fileItem.task_name] = [];
                            }
                            groupedTasks[fileItem.task_name].push(fileItem);
                        });

                        var cardDiv = $("<div class='row card' style='padding:20px;margin-bottom:30px;'></div>");

                        // Iterate through grouped tasks and append HTML
                        $.each(groupedTasks, function (taskName, files) {
                            var taskTitle = $("<div class='col-md-12'><h3 class='alert alert-info' style='font-size:unset;font-weight:800;'>" + taskName + "</h3></div>");
                            cardDiv.append(taskTitle);

                            files.forEach(function (fileItem) {
                                var columnClass = "col-md-3";
                                var view_url = fileItem.file_url ? fileItem.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com") : '';
                                var html = "";

                                var filetypeParts = fileItem.filetype ? fileItem.filetype.split('/') : '';
                                var extension = filetypeParts[1];
                                if (extension === 'jpeg' || extension === 'png' || extension === 'jpg' || extension === 'HEIC' || extension === 'heic') {
                                    html += "<div class='" + columnClass + "'>";
                                    html += "<div style='display: flex; justify-content: left; align-items: center; margin-left:35px;'>";
                                    html += "<a href='" + fileItem.file_url + "' target='_blank'><i class='fa fa-download' aria-hidden='true'></i></a>";
                                    html += "<a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a>";
                                    html += "<a href='#' class='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a>";
                                    html += "</div>";
                                    // html += "<a href='" + view_url + "' target='_blank'><img style='width:125px; margin: 5px; height: 135px;' src='" + fileItem.file_url + "'></a>";
                                    html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height:50px; margin: 5px;' src='<?php echo base_url('assets/images/allimage.webp'); ?>'></a>";
                                    html += "</div>";
                                } else if (extension === 'pdf') {
                                    html += "<div class='" + columnClass + "'>";
                                    html += "<div style='display: flex; justify-content: left; align-items: center; margin-left:35px;'>";
                                    html += "<a href='" + fileItem.file_url + "' target='_blank'><i class='fa fa-download' aria-hidden='true'></i></a>";
                                    html += "<a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a>";
                                    html += "<a href='#' class='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a>";
                                    html += "</div>";
                                    html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/pdf.webp'); ?>'></a>";
                                    html += "</div>";
                                } else if (extension === 'msword' || extension === 'vnd.openxmlformats-officedocument.wordprocessingml.document') {
                                    html += "<div class='" + columnClass + "'>";
                                    html += "<div style='display: flex; justify-content: left; align-items: center; margin-left:35px;'>";
                                    html += "<a href='" + fileItem.file_url + "' target='_blank'><i class='fa fa-download' aria-hidden='true'></i></a>";
                                    html += "<a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a>";
                                    html += "<a href='#' class='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a>";
                                    html += "</div>";
                                    html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/msword_new.webp'); ?>'></a>";
                                    html += "</div>";
                                } else {
                                    html += "<div class='" + columnClass + "'>";
                                    html += "<div style='display: flex; justify-content: left; align-items: center; margin-left:35px;'>";
                                    html += "<a href='" + fileItem.file_url + "' target='_blank'><i class='fa fa-download' aria-hidden='true'></i></a>";
                                    html += "<a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a>";
                                    html += "<a href='#' class='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a>";
                                    html += "</div>";
                                    html += "<a href='" + fileItem.file_url + "' target='_blank'>";
                                    html += "<img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/general.webp'); ?>'></a>";
                                    html += "</div>";
                                }
                                cardDiv.append(html);
                            });
                        });

                        targetElement.append(cardDiv);
                    },
                    error: function (xhr, status, error) {
                        console.error("Error fetching checklist details:", error);
                    }
                });
            }
            function toggleCheckbox(element) {
                var $checkbox = $(element).find('input[type="checkbox"]');
                $checkbox.prop('checked', !$checkbox.prop('checked')).trigger('change');
            }
            function toggleCheckbox_file_opened(element) {
                var $checkbox = $(element).find('input[type="checkbox"]');
                $checkbox.prop('checked', !$checkbox.prop('checked')).trigger('change');
            }

            function updateClientDisplay() {
                var clientNames = [];
                $('input[name="email_review_file_opened_client_checkboxes[]"]:checked').each(function () {
                    var clientName = $(this).next('label').text();
                    clientNames.push(clientName);
                });
                $('#client_display_span').text(clientNames.join(', '));
            }
            function file_opened_checkboxes() {
                $.ajax({
                    url: "<?php echo admin_url('leads/checklist_details/' . $lead->id . '/1'); ?>",
                    type: "GET",
                    dataType: "json",
                    success: function (response) {
                        $.each(response, function (index, item) {
                            var isChecked = item.checkbox_status == 1;
                            // review the client/borrower file opened checked boxes
                            var file_opened_client_review_content = '<div class="col-md-6"><div class="form-group" style="background-color: #9ebeff80;display:flex;border-radius: 7px;padding: 9px 20px;" onclick="toggleCheckbox(this)">';
                            file_opened_client_review_content += '<input type="checkbox" name="email_review_file_opened_client_checkboxes[]" id="email_review_file_opened_client_checkboxes_' + item.id + '" data-id="' + item.id + '">';
                            file_opened_client_review_content += '<label for="email_review_file_opened_client_checkboxes_' + item.id + '" style="padding-left:5px;padding-top:8px;">' + item.name + '</label>';
                            file_opened_client_review_content += '</div></div>';
                            $('#file_opened_client_review_email_checkboxes').append(file_opened_client_review_content);
                            // select the checkboxes and appened the record accordingly
                            $(document).off('change', 'input[name="email_review_file_opened_client_checkboxes[]"]').on('change', 'input[name="email_review_file_opened_client_checkboxes[]"]', function () {
                                // Gather selected checkbox values
                                var checkedIds = [];
                                $('input[name="email_review_file_opened_client_checkboxes[]"]:checked').each(function () {
                                    checkedIds.push($(this).attr('data-id'));
                                });
                                if (!empty(checkedIds)) {
                                    $('#file_opened_review_mail_to_client').prop('disabled', false);
                                } else {
                                    $('#file_opened_review_mail_to_client').prop('disabled', true);
                                }
                                // AJAX request
                                $.ajax({
                                    url: "<?php echo admin_url('leads/file_opened_review_email_send_to_client/' . $lead->id); ?>",
                                    type: 'POST',
                                    data: {
                                        task_id: checkedIds,
                                        type: 'view'
                                    },
                                    dataType: 'json',
                                    success: function (response) {
                                        // Clear existing content before appending new data
                                        $('#clientDetailsContainer').empty();
                                        if (!empty(checkedIds)) {
                                            // Iterate through each client record in response_records
                                            response.response_records.forEach(function (client) {
                                                // Create HTML content for each client
                                                var clientHtml = '<div class="client-details">';
                                                clientHtml += '<div class="client-title" style="font-weight:800;">' + client.client + ':' + '</div>';
                                                clientHtml += '<div class="client-checklist" style="margin-left:35px;">' + client.borrower_checklist_name + '</div>';
                                                clientHtml += '</div>';
                                                // Append HTML content to the container
                                                $('#clientDetailsContainer').append(clientHtml);
                                            });
                                        }
                                    },
                                    error: function (xhr, status, error) {
                                        // Handle the AJAX error
                                        console.error('AJAX error:', error);
                                    }
                                });
                            });
                        });
                    },
                    error: function (xhr, status, error) {
                    }
                });
            }
            // borrower file opened checkboxes
            // Define the function to create the borrower checklist table
            function createBorrowerChecklistTable(borrowerData, i, j, sameGroup) {
                // Function to capitalize the first letter of a string
                function capitalizeFirstLetter(string) {
                    return string.charAt(0).toUpperCase() + string.slice(1);
                }

                // Create table for the borrower
                var html = "<table class='table dt-table table-ticket-reports dt-inline dataTable no-footer'>";
                html += `
                        <div class='bulk-action-bar' style='
                            margin-bottom: 10px;
                            padding: 10px;
                            border: 1px solid #ddd;
                            background: #f9f9f9;
                            border-radius: 5px;
                            display: flex;
                            justify-content: space-between;
                            align-items: center;
                        '>
                            <div style="display: flex; align-items: center;">
                                <input type='checkbox' class='select-all-checkbox' style='margin-right: 10px; transform: scale(1.3);'>
                                <span style="font-weight: bold;">Select All</span>
                            </div>
                            <div style="display: flex; align-items: center; gap: 10px;">
                                <select class='form-control bulk-status-select' style='width: 200px;'>
                                    <option value=''>Select Status</option>
                                    <option value='1'>Pending Review</option>
                                    <option value='2'>Outstanding</option>
                                    <option value='3'>Rejected</option>
                                    <option value='4'>Approved</option>
                                    <option value='5'>Uploaded</option>
                                </select>
                                <button class='btn btn-danger bulk-delete-btn' style=''>
                                    <i class='fa fa-trash'></i>
                                </button>
                            </div>
                        </div>
                    `;
                html += "<thead><tr><th></th><th>Title</th>";
                if (i == 1) {
                    // html += "<th>ID Type</th>";
                }
                html += "<th>Status</th><th>Rejected Reason</th><th>Documents</th>";

                // if (sameGroup != 2 && sameGroup != false) {
                html += "<th>Action</th>";
                // }

                html += "</tr></thead>";
                html += "<tbody id='checklist_table" + i + "' >";

                var flag = 0;
                $.each(borrowerData.items, function (index, item) {
                    if (item.checklist_lead_status == j) {
                        flag = j;
                        var status;
                        switch (item.status) {
                            case '1':
                                status = 'Pending Review';
                                break;
                            case '2':
                                status = 'Outstanding';
                                break;
                            case '3':
                                status = 'Rejected';
                                break;
                            case '4':
                                status = 'Approved';
                                break;
                            case '5':
                                status = 'Uploaded';
                                break;
                        }
                        html += "<tr id='delete_checklist" + item.id + "' data-id='" + item.id + "' data-orderid='" + item.order_no + "' data-type='client-borrower' style='background-color:#fbfbfb'>";
                        html += "<td><input type='checkbox' class='checklist-bulk-checkbox' data-id='" + item.id + "' data-type='client'></td>";
                        html += "<td style='display:flex;justify-content:space-between;align-items:center;'><span class='item-name'>" + capitalizeFirstLetter(item.name) + "</span>";
                        if (sameGroup != false) {
                            html += "<button class='btn btn-primary btn-sm' data-id='" + item.id + "' id='file_open_checkbox_upload_doc_button_" + item.id + "' name='file_open_checkbox_upload_doc_button' style='margin-left: 10px; margin-top: 4px;'><i class='fa-solid fa-upload'></i></button>";
                        }
                        html += "</td>";

                        if (i == 1) {
                            // html += "<td> " + (item.show_item_names ?? '-') + "</td>";
                        }
                        // html += "<td class='tw-text-neutral-900 tw-mt-1' style='width:100px;'><span data-toggle='tooltip' data-title='" + item.dt_new_dateadded + "' class='text-has-action'> " + item.new_dateadded + "</span></td>";
                        if (sameGroup != 2 && sameGroup != false) {
                            // var regex = /\b(photo id\s*\d*|paper id\s*\d*)\b/i;
                            // if (regex.test(item.name)) {
                            var status_dropdown_clr = '';
                            if (item.status === '2' || item.status === '3') {
                                status_dropdown_clr = 'background-color: #ff0000b3; color: white;';
                            }
                            if (item.status === '4') {
                                status_dropdown_clr = 'background-color: #008000bf; color: white;';
                            }
                            if (item.status === '5') {
                                status_dropdown_clr = 'background-color: #e2b203; color: black;';
                            }
                            html += "<td><select style='width: 170px;" + status_dropdown_clr + "' class='status-select form-control' data-task-id='" + item.id + "'>" +
                                "<option value='1' " + (item.status === '1' ? 'selected' : '') + ">Pending Review</option>" +
                                "<option value='2' " + (item.status === '2' ? 'selected' : '') + ">Outstanding</option>" +
                                "<option value='3' " + (item.status === '3' ? 'selected' : '') + ">Rejected</option>" +
                                "<option value='4' " + (item.status === '4' ? 'selected' : '') + ">Approved</option>" +
                                "<option value='5' " + (item.status === '5' ? 'selected' : '') + ">Uploaded</option>" +
                                "</select></td>";
                            // } else {
                            //     html += "<td><select style='width: 170px;' class='status-select form-control' data-task-id='" + item.id + "'>" +
                            //         "<option value='2' " + (item.status === '2' ? 'selected' : '') + ">Outstanding</option>" +
                            //         "<option value='5' " + (item.status === '5' ? 'selected' : '') + ">Uploaded</option>" +
                            //         "</select></td>";
                            // }
                        } else {
                            html += "<td>" +
                                (item.status === '1' ? 'Pending Review' : '') +
                                (item.status === '2' ? 'Outstanding' : '') +
                                (item.status === '3' ? 'Rejected' : '') +
                                (item.status === '4' ? 'Approved' : '') +
                                (item.status === '5' ? 'Uploaded' : '') +
                                "</td>";
                        }
                        
                        html += "<td>" + (item.rejected_reason || '-') + "</td>";

                        if (sameGroup != 2) {
                            html += "<td>";
                            html += '<form class="file-opened-upload-form" data-task-id="' + item.id + '" enctype="multipart/form-data" style="width:100%;display:flex;justify-content:center;">';
                            html += '<div class="drop-area" data-task-id="' + item.id + '">Drag & Drop or Click to Upload</div>';
                            html += '<input type="file" class="dropzone-input" data-task-id="' + item.id + '" multiple style="display: none;" accept="image/*">';
                            html += '</form>';
                            html += '<div class="image-preview" data-task-id="' + item.id + '"></div>';
                            if (item.file_data.length > 0) {
                                // if (item.status == 3 || item.status == 4) {
                                var columnClass = (item.file_data.length == 1) ? 'col-md-12' : 'col-md-6';
                                html += "<div style='overflow-y: scroll; max-height: 150px; '><div style='max-height: 150px;'>";
                                $.each(item.file_data, function (fileIndex, fileItem) {
                                    var view_url = fileItem.file_url ? fileItem.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com") : '';
                                    if (['jpeg', 'png', 'jpg', 'HEIC', 'heic'].includes(fileItem.check_filetype)) {
                                        // html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                        // html += "<a href='" + view_url + "' target='_blank'><img style='width:100%; margin: 7px;' src='" + fileItem.file_url + "'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                        html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                        html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height:50px; margin: 7px;' src='<?php echo base_url('assets/images/allimage.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                    } else if (fileItem.check_filetype == 'pdf') {
                                        html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                        html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/pdf.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                    } else if (['msword', 'vnd.openxmlformats-officedocument'].includes(fileItem.check_filetype)) {
                                        html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                        html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/msword_new.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                    } else {
                                        html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div><a href='" + fileItem.dl_file_url + "'>";
                                        html += "<img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/general.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                    }
                                });
                                html += "</div></div>";
                                // } else {
                                //     html += "<td><div style='color: #31708f;'><span class='no-margin font-medium-xs bold' style='color: #1f7fb6 !important;'>Pending For Approval</span></div></td>";
                                // }
                            } 
                            // else {
                            //     html += "<td><div style='color: #31708f;'><span class='no-margin font-medium-xs bold' style='color: #1f7fb6 !important;'>No Document Available</span></div></td>";
                            // }
                            html += "</td>";
                        } else {
                            html += "<td>";
                            html += '<form class="file-opened-upload-form" data-task-id="' + item.id + '" enctype="multipart/form-data" style="width:100%;display:flex;justify-content:center;">';
                            html += '<div class="drop-area" data-task-id="' + item.id + '">Drag & Drop or Click to Upload</div>';
                            html += '<input type="file" class="dropzone-input" data-task-id="' + item.id + '" multiple style="display: none;" accept="image/*">';
                            html += '</form>';
                            html += '<div class="image-preview" data-task-id="' + item.id + '"></div>';
                            if (item.file_data.length > 0) {
                                // if (item.status == 3 || item.status == 4) {
                                var columnClass = (item.file_data.length == 1) ? 'col-md-12' : 'col-md-6';
                                html += "<div style='overflow-y: scroll; max-height: 150px; width:422px;'><div style='max-height: 150px;'>";
                                $.each(item.file_data, function (fileIndex, fileItem) {
                                    var view_url = fileItem.file_url ? fileItem.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com") : '';
                                    if (['jpeg', 'png', 'jpg', 'HEIC', 'heic'].includes(fileItem.check_filetype)) {
                                        html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                        html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height:50px; margin: 7px;' src='<?php echo base_url('assets/images/allimage.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                    } else if (fileItem.check_filetype == 'pdf') {
                                        html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                        html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/pdf.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                    } else if (['msword', 'vnd.openxmlformats-officedocument'].includes(fileItem.check_filetype)) {
                                        html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='" + view_url + "' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div>";
                                        html += "<a href='" + view_url + "' target='_blank'><img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/msword_new.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                    } else {
                                        html += "<div class='" + columnClass + "'><div style='display: flex;justify-content: center;align-items: center;'><a href='" + fileItem.dl_file_url + "'><i class='fa fa-download' aria-hidden='true'></i></a><a href='#' class='delete_checklist_item_image' id='delete_checklist_item_image' data-id='" + fileItem.id + "'><i style='margin-left:5px;color:red;' class='fa fa-trash' aria-hidden='true'></i></a></div><a href='" + fileItem.dl_file_url + "'>";
                                        html += "<img loading='lazy' style='width:50px; height: 50px; margin: 5px;' src='<?php echo base_url('assets/images/general.webp'); ?>'></a><p>Uploaded at: " + fileItem.dateadded + "</p></div>";
                                    }
                                });
                                html += "</div></div>";
                                // } else {
                                //     html += "<td><div style='color: #31708f;'><span class='no-margin font-medium-xs bold' style='color: #1f7fb6 !important;'>Pending For Approval</span></div></td>";
                                // }
                                html += "</td>";
                            }
                            //  else {
                            //     html += "<td><div style='color: #31708f;'><span class='no-margin font-medium-xs bold' style='color: #1f7fb6 !important;'>No Documents Available</span></div></td>";
                            // }
                        }
                        if (sameGroup == 2 || sameGroup == true) {
                            html += "<td style='display:flex;align-items:center;'><button  href='#' class='btn btn-danger btn-sm delete-checklist-link' data-id='" + item.id + "'><i class='fa fa-trash' style='color:white;'></i></button>";
                            // html += "<a style='margin-left:8px;' href='<?php echo admin_url('cases/checklistrecord/' . $lead->id . '/') ?>" + item.id + "' target='_blank'><i class='fas fa-edit'></i></a></td>";
                            html += "<button class='btn btn-primary btn-sm' style='margin-left:8px;' id='update_checklist' href='#'  data-id='" + item.id + "'><i class='fas fa-edit'></i></button></td>";
                        } else {
                            html += "<td>-</td>";
                        }
                        html += "</tr>";
                    }
                });

                html += "</tbody></table>";
                $("#file_opened_checklist_item_for_borrower").append(html);

                // if (flag === 0) {
                //     var noRecordHtml = "<table class='table dt-table table-ticket-reports dt-inline dataTable no-footer'>";
                //     noRecordHtml += "<thead><tr><th>Title</th><th>Status</th><th>Rejection Reason</th><th>Documents</th><th>Action</th></tr></thead>";
                //     noRecordHtml += "<tbody id='checklist_table" + i + "'></tbody></table>";
                //     noRecordHtml += "<div id='no_checklist_record_found" + i + "' class='alert alert-info' style='margin-top:10px;'><span class='no-margin font-medium-xs bold' style='display: flex;justify-content: center;'>No Checklist available</span></div></div>";
                //     $("#file_opened_checklist_item_for_borrower").append(noRecordHtml);
                // }
            }

            // Define the function to handle checkboxes for borrower
            function file_opened_checkboxes_for_borrower() {
                var sameGroup = '<?php echo $samegroup; ?>';
                $.ajax({
                    url: "<?php echo admin_url('leads/checklist_details_for_borrower/' . $lead->id . '/1'); ?>",
                    type: "GET",
                    dataType: "json",
                    success: function (response) {
                        // Group checklist items by borrower
                        var borrowerChecklist = {};
                        $.each(response, function (index, item) {
                            if (!borrowerChecklist[item.borrower_id]) {
                                borrowerChecklist[item.borrower_id] = {
                                    borrower_id: item.borrower_id,
                                    items: []
                                };
                            }
                            borrowerChecklist[item.borrower_id].items.push(item);
                        });

                        // Clear the container first
                        $('#file_opened_checklist_item_for_borrower').empty();
                        $('#data-container-borrower').empty();
                        var check_borrwer_id = null;
                        var i = 2;
                        $.each(borrowerChecklist, function (borrower_id, borrowerData) {
                            if (borrower_id !== check_borrwer_id) {
                                check_borrwer_id = borrower_id;
                            }

                            // Determine the borrower's position name
                            var borrower_position_name = '';
                            switch (i) {
                                case 2:
                                    borrower_position_name = 'Second';
                                    break;
                                case 3:
                                    borrower_position_name = 'Third';
                                    break;
                                case 4:
                                    borrower_position_name = 'Fourth';
                                    break;
                                default:
                                    borrower_position_name = ' ';
                                    break;
                            }
                            i++;
                            if (borrower_id && !isNaN(borrower_id) && Number(borrower_id) > 0) {
                                $.ajax({
                                    url: "<?php echo admin_url('leads/get_borrower_name/'); ?>" + borrower_id,
                                    type: "GET",
                                    dataType: "json",
                                    success: function (borrower_name) {
                                        // Heading for each borrower
                                        var heading = '<div class="alert alert-info"><span class="no-margin font-medium-xs bold" style="display: flex;justify-content: center;"><b>' + borrower_position_name + ' Client (' + borrower_name + ') Uploaded ID Documents</b></span></div>';
                                        
                                        $('#file_opened_checklist_item_for_borrower_review').append(heading);

                                        // Checklist items (if any)
                                        var file_opened_client_review_content = '<div class="col-md-12">';
                                        $.each(borrowerData.items, function (index, item) {
                                            if (item.id !== null) {
                                                file_opened_client_review_content += '<div class="col-md-6"><div class="form-group" style="background-color: #9ebeff80;display:flex;border-radius: 7px;padding: 9px 20px;" onclick="toggleCheckbox(this)">';
                                                file_opened_client_review_content += '<input type="checkbox" name="email_review_file_opened_client_checkboxes[]" id="email_review_file_opened_client_checkboxes_' + item.id + '" data-id="' + item.id + '">';
                                                file_opened_client_review_content += '<label for="email_review_file_opened_client_checkboxes_' + item.id + '" style="padding-left:5px;padding-top:8px;">' + item.name + '</label>';
                                                file_opened_client_review_content += '</div></div>';
                                            }
                                        });
                                        file_opened_client_review_content += '</div>';
                                        $('#file_opened_checklist_item_for_borrower_review').append(file_opened_client_review_content);

                                        // Borrower section and Add ID Item button (always append)
                                        var borrwerdoc = '<div id="checklist_images_borrower_' + borrower_id + '"></div>';
                                        var borrowerHtml = heading + borrwerdoc;
                                        $('#file_opened_checklist_item_for_borrower').append(borrowerHtml);

                                        var additionalHtml = `
                                            <div class="col-md-12" style="margin-bottom:15px;">
                                                <div class="clearfix"></div>
                                                <button class="btn btn-primary" id="file_opened_form_show_button_${borrower_id}" style="margin-top:15px;">Add ID Item</button>
                                                <div class="clearfix"></div>
                                                <hr class="-tw-mx-4 tw-border-neutral-200" />
                                            </div>
                                            <div id="file_opened_form_show_${borrower_id}" style="display:none;">
                                                <hr class="-tw-mx-4 tw-border-neutral-200" />
                                                <div id="hide_checklist_form_${borrower_id}"></div>
                                            </div>
                                        `;
                                        $('#file_opened_checklist_item_for_borrower').append(additionalHtml);

                                        // Bind click handler (use event delegation to ensure it works even if loaded dynamically)
                                        $(document).off('click', '#file_opened_form_show_button_' + borrower_id).on('click', '#file_opened_form_show_button_' + borrower_id, function () {
                                            $('#file_opened_form_show_' + borrower_id).slideToggle();

                                            $.ajax({
                                                url: "<?php echo admin_url('leads/get_checklist_view/') . $lead->id . '/'; ?>" + borrower_id,
                                                type: "GET",
                                                success: function (response) {
                                                    $('#hide_checklist_form_' + borrower_id).html(response);
                                                },
                                                error: function (xhr, status, error) {
                                                    console.error("Error loading checklist view:", error);
                                                }
                                            });
                                        });
                                        
                                        var j = 1;
                                        createBorrowerChecklistTable(borrowerData, i, j, sameGroup);
                                    },
                                    error: function (xhr, status, error) {
                                        console.error("Error fetching borrower name:", error);
                                    }
                                });
                            }
                        });

                    },
                    error: function (xhr, status, error) {
                        console.error("Error fetching checklist details:", error);
                    }
                });
            }

            // Call the function to initialize the borrower checkboxes and tables
            file_opened_checkboxes_for_borrower();

            function file_opened_checkboxes_broker() {
                $.ajax({
                    url: "<?php echo admin_url('leads/checklist_details_broker/' . $lead->id . '/1'); ?>",
                    type: "GET",
                    dataType: "json",
                    success: function (response) {
                        $.each(response, function (index, item) {
                            var isChecked = item.checkbox_status == 1;
                            file_opened_get_checklist_images_for_all_borrower('broker', '');
                            // Your original code to create checkboxes
                            var file_opened_review_content = '<div class="col-md-6"><div class="form-group" style="background-color: #9ebeff80;display:flex;border-radius: 7px;padding: 9px 20px;" onclick="toggleCheckbox(this)">';
                            file_opened_review_content += '<input type="checkbox" name="email_review_file_opened_checkboxes[]" id="email_review_file_opened_checkboxes_' + item.id + '" data-id="' + item.id + '">';
                            file_opened_review_content += '<label for="email_review_file_opened_checkboxes_' + item.id + '" style="padding-left:5px;padding-top:8px;">' + item.name + '</label>';
                            file_opened_review_content += '</div></div>';
                            $('#file_opened_review_email_checkboxes').append(file_opened_review_content);

                            // JavaScript function to toggle the checkbox
                            function toggleCheckbox(div) {
                                var checkbox = $(div).find('input[type="checkbox"]');
                                checkbox.prop('checked', !checkbox.prop('checked'));
                            }
                        });
                    },
                    error: function (xhr, status, error) {
                    }
                });
            }
            $(document).off('change', 'input[name="file_open_checkbox"]').on('change', 'input[name="file_open_checkbox"]', function () {
                var checkbox = $(this);
                var checkboxId = checkbox.data('id');
                var sameGroup = '<?php echo $samegroup; ?>';
                var titleText = checkbox.closest('.form-group').find('label[for="' + checkboxId + '"]').text().trim();
                $.ajax({
                    url: '<?php echo admin_url('leads/file_opened_checkbox_status/' . $lead->id); ?>',
                    type: 'POST',
                    data: { id: checkboxId },
                    dataType: 'json',
                    success: function (response) {
                        if (response.checked === true) {
                            if (response.checked_status == 1) {
                                destroyTinyMCE();
                                _lead_init_data(response, response.id);
                                $('a[href="' + response.leads_status + '"]').tab('show');
                                if (sameGroup != 2) {
                                    $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                }
                                checkbox.next('label').wrapInner('<del>');
                                checkbox.prop('checked', true);
                            } else if (response.checked_status == 3) {
                                destroyTinyMCE();
                                // if broker click on checked box and this check box have already image then just refresh and show error
                                _lead_init_data(response, response.id);
                                $('a[href="' + response.leads_status + '"]').tab('show');
                                if (sameGroup != 2) {
                                    $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                }
                            } else {
                                destroyTinyMCE();
                                _lead_init_data(response, response.id);
                                $('a[href="' + response.leads_status + '"]').tab('show');
                                if (sameGroup != 2) {
                                    $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                }
                                checkbox.next('label').find('del').contents().unwrap();
                                checkbox.prop('checked', false);
                            }
                            (response.checked_status == 3) ? alert_float('danger', 'Sorry, You are not able to change the status.') : alert_float('success', 'Checklist Item Status updated.');
                        } else {
                            $('#get_checkbox_title_file_opened').text(titleText);
                            $('#file_opened_modal_upload_doc').modal('show');
                            // Scroll the modal into view
                            setTimeout(function () {
                                $('#file_opened_modal_upload_doc').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                            }, 200);
                            appendInputAndRemovePrevious_for_fileopened('task_id', response.task_id);
                            checkbox.prop('checked', false);
                            alert_float('danger', 'Please upload (' + titleText + ') document first.');
                        }
                    },
                    error: function (xhr, status, error) {
                        // console.error('Error:', error);
                    }
                });
            });

            // Nuborrow files show 
            function loadUncategorizedDocs() {
                $.ajax({
                    url: '<?php echo admin_url('cases/get_uncategorized_documents/' . $lead->id); ?>',
                    type: 'GET',
                    dataType: 'json',
                    success: function (response) {
                        let rows = '';

                        $.each(response.files, function (i, fileItem) {
                            let taskOptions = '<optgroup label="Clients/Broker">';
                            $.each(response.tasks, function (j, task) {
                                taskOptions += `<option value="task-${task.id}">${task.display_name}</option>`;
                            });
                            taskOptions += '</optgroup>';

                            let caseOptions = '<optgroup label="LD-Team">';
                            $.each(response.cases, function (k, caseItem) {
                                caseOptions += `<option value="case-${caseItem.id}">${caseItem.title}</option>`;
                            });
                            caseOptions += '</optgroup>';

                            let view_url = fileItem.file_url ? fileItem.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com") : '';
                            let filePreview = '';
                            let iconHTML = '';

                            if (['jpeg', 'png', 'jpg', 'HEIC', 'heic'].includes(fileItem.check_filetype)) {
                                iconHTML = "<?php echo base_url('assets/images/allimage.webp'); ?>";
                            } else if (fileItem.check_filetype == 'pdf') {
                                iconHTML = "<?php echo base_url('assets/images/pdf.webp'); ?>";
                            } else if (['msword', 'vnd.openxmlformats-officedocument'].includes(fileItem.check_filetype)) {
                                iconHTML = "<?php echo base_url('assets/images/msword_new.webp'); ?>";
                            } else {
                                iconHTML = "<?php echo base_url('assets/images/general.webp'); ?>";
                            }

                            filePreview = `
                                <div style="display: flex; align-items: center; gap: 5px;">
                                    <a href="${fileItem.dl_file_url}" target="_blank"><i class="fa fa-download"></i></a>
                                    ${view_url ? `<a href="${view_url}" target="_blank"><i class="fa fa-eye" style="margin-left:5px;"></i></a>` : ''}
                                    <a href="#" class="delete_checklist_item_image" id="delete_checklist_item_image" data-id="${fileItem.id}"><i style="margin-left:5px; color:red;" class="fa fa-trash"></i></a>
                                </div>
                                <a href="${view_url}" target="_blank">
                                    <img loading="lazy" style="width:50px; height:50px; margin-top:5px;" src="${iconHTML}">
                                </a>
                            `;

                            rows += `
                                <tr>
                                    <td>${fileItem.file_name}</td>
                                    <td>
                                        <select class="form-control nuborrow-assign-type" data-id="${fileItem.id}">
                                            <option value="">Select Item</option>
                                            ${taskOptions}
                                            ${caseOptions}
                                        </select>
                                    </td>
                                    <td>${fileItem.dateadded}</td>
                                    <td>${filePreview}</td>
                                </tr>
                            `;
                        });

                        $('#uncategorized-documents-table tbody').html(rows);
                    }
                });
            }

            loadUncategorizedDocs();

            // On Change Assign Type with ID
           
            $(document).off('click', '#assign-selected-docs').on('click', '#assign-selected-docs', function () {
                var assignments = [];
                $('.nuborrow-assign-type').each(function () {
                    var selectedVal = $(this).val();
                    var fileId = $(this).data('id');
                    if (selectedVal) {
                        var parts = selectedVal.split('-');
                        assignments.push({
                            file_id: fileId,
                            rel_type: parts[0],
                            itemid: parts[1]
                        });
                    }
                });

                if (assignments.length === 0) {
                    alert_float('danger','Please select at least one item.');
                    return;
                }

                var lead_id = "<?php echo $lead->id; ?>";

                $.post(admin_url + 'cases/nuborrow_bulk_assign_document_type/' + lead_id, { assignments: assignments }, function (res) {
                    loadUncategorizedDocs();
                    loadChecklistForBroker();
                    loadChecklistDataForClient();
                    file_opened_checkboxes_for_borrower();
                    loadStates_outstanding_ld_team();
                    loadStates_request_for_funds();
                    loadStates_for_appointment();
                    loadStates_outstanding_ld_team_payouts();
                }, 'json');
            });

            // Bulk Delete Handler
            $(document).off('change', '.select-all-checkbox').on('change', '.select-all-checkbox', function () {
                var table = $(this).closest('.bulk-action-bar').next('table');
                table.find('.checklist-bulk-checkbox').prop('checked', this.checked);
            });

            $(document).off('click', '.bulk-delete-btn').on('click', '.bulk-delete-btn', function () {
                var selectedItems = [];
                $(this).closest('.bulk-action-bar').next('table').find('.checklist-bulk-checkbox:checked').each(function () {
                    selectedItems.push({
                        id: $(this).data('id'),
                        type: $(this).data('type')
                    });
                });

                if (selectedItems.length === 0) {
                    alert_float('danger','Please select at least one item to delete.');
                    return;
                }

                if (!confirm('Are you sure you want to delete the selected items?')) {
                    return;
                }
                
                $('.full-page-loader').show();
                
                $.ajax({
                    url: "<?php echo admin_url('leads/delete_bulk_checklist/' . $lead->id); ?>",
                    type: "POST",
                    data: { items: selectedItems },
                    success: function (res) {
                        alert_float('success','Selected items deleted successfully!');
                        loadUncategorizedDocs();
                        // Refresh all unique types from selected items
                        refreshAfterBulkAction(selectedItems);
                        $('.full-page-loader').hide();
                    },
                    error: function (err) {
                        console.log(err);
                        alert_float('danger','Error deleting selected items.');
                    }
                });
            });
            // Bulk Status Change Handler
            $(document).off('change', '.bulk-status-select').on('change', '.bulk-status-select', function () {
                var selectedStatus = $(this).val();
                if (!selectedStatus) {
                    return;
                }

                var selectedItems = [];
                $(this).closest('.bulk-action-bar').next('table').find('.checklist-bulk-checkbox:checked').each(function () {
                    selectedItems.push({
                        id: $(this).data('id'),
                        type: $(this).data('type')
                    });
                });

                if (selectedItems.length === 0) {
                    alert_float('danger','Please select at least one item to update.');
                    return;
                }

                if (!confirm('Are you sure you want to update the status for selected items?')) {
                    return;
                }

                $('.full-page-loader').show();

                $.ajax({
                    url: "<?php echo admin_url('leads/update_bulk_checklist_status/' . $lead->id); ?>",
                    type: "POST",
                    data: { items: selectedItems, status: selectedStatus },
                    success: function (res) {
                        alert_float('success','Selected items updated successfully!');
                        // Refresh all unique types from selected items
                        refreshAfterBulkAction(selectedItems);

                        $('.full-page-loader').hide();
                    },
                    error: function (err) {
                        console.log(err);
                        alert_float('danger','Error updating status.');
                    }
                });
            });

            function refreshAfterBulkAction(selectedItems) {
                var uniqueTypes = [...new Set(selectedItems.map(item => item.type))];

                if (uniqueTypes.includes('client')) {
                    loadChecklistDataForClient();
                    file_opened_checkboxes_for_borrower();
                }

                if (uniqueTypes.includes('broker')) {
                    loadChecklistForBroker();
                }

                if (uniqueTypes.some(type => type !== 'client' && type !== 'broker')) {
                    loadStates_outstanding_ld_team();
                    loadStates_request_for_funds();
                    loadStates_for_appointment();
                    loadStates_outstanding_ld_team_payouts();
                }
            }

        });

        // upload file openeed files
        $(document).ready(function () {
            $('#file_opened_modal_close_button').click(function () {
                $('#file_opened_modal_upload_doc').modal('hide');
            });
            // $('#file_opened_modal_upload_doc_form').submit(function (event) {
            $(document).off('submit', '#file_opened_modal_upload_doc_form').on('submit', '#file_opened_modal_upload_doc_form', function (event) {
                event.preventDefault();
                $('#userfile_error').text('');
                var sameGroup = '<?php echo $samegroup; ?>';
                var formData = new FormData($(this)[0]);
                var removeValidation = formData.get('remove_validation');
                if (removeValidation === '0') {
                    var fileInput = document.getElementById('userfile');
                    if (fileInput.files.length === 0) {
                        var errorMessage = 'Please select at least one document.';
                        $('#userfile_error').text(errorMessage);
                        return;
                    }
                }
                // loader apply when form submit
                $('#file_opened_submit_button').prop('disabled', true);
                $('#file_opened_loader').addClass('loader');
                $.ajax({
                    url: '<?php echo admin_url('leads/upload_doc_for_fileopened/' . $lead->id); ?>',
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function (response) {
                        if (response.success) {
                            destroyTinyMCE();
                            var anchor = document.querySelector('#file_opened_modal_close_button');
                            if (anchor) anchor.click();
                            alert_float('success', 'Documents uploaded successfully.');
                            $('#file_opened_submit_button').prop('disabled', false);
                            $('#file_opened_loader').removeClass('loader');
                            // Reset the form
                            $('#file_opened_modal_upload_doc_form')[0].reset();
                            setTimeout(function () {
                                if (anchor) {
                                    _lead_init_data(response, response.id, response.task_id);
                                }
                                $('a[href="' + response.leads_status + '"]').tab('show');
                                if (sameGroup != 2) {
                                    $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                }
                            }, 500);
                            setTimeout(function () {
                                $('#delete_checklist' + response.task_id).css('background', '#ddddddba');
                                $('#delete_checklist' + response.task_id).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                            }, 8000);
                        } else {
                            destroyTinyMCE();
                            var anchor = document.querySelector('#file_opened_modal_close_button');
                            anchor.click();
                            alert_float('danger', 'Documents not uploaded,Please try again.');
                            $('#file_opened_submit_button').prop('disabled', false);
                            $('#file_opened_loader').removeClass('loader');
                            // Reset the form
                            $('#file_opened_modal_upload_doc_form')[0].reset();
                            setTimeout(function () {
                                if (anchor) {
                                    console.log('anchor hit and modal close else file_opened_modal_upload_doc_form');
                                    _lead_init_data(response, response.id);
                                }
                                $('a[href="' + response.leads_status + '"]').tab('show');
                                if (sameGroup != 2) {
                                    $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                }
                            }, 500);
                        }
                    },
                    error: function (response) {
                        $('#file_opened_modal_close_button').trigger('click');
                        var anchor = document.querySelector('#file_opened_modal_close_button');
                        anchor.click();
                        var anchor = document.querySelector('.close');
                        anchor.click();
                        alert_float('danger', 'Documents not uploaded,Please try again.');
                        $('#file_opened_submit_button').prop('disabled', false);
                        $('#file_opened_loader').removeClass('loader');
                        // Reset the form
                        $('#file_opened_modal_upload_doc_form')[0].reset();
                        setTimeout(function () {
                            destroyTinyMCE();
                            _lead_init_data(response, response.id);
                            $('a[href="' + response.leads_status + '"]').tab('show');
                            if (sameGroup != 2) {
                                $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                            }
                        }, 500);
                    }
                });
            });
        });
    </script>
    <!-- outstanding item list -->
    <script>
        function destroyTinyMCE() {
            tinymce.remove();
            if (tinymce.editors.length > 0) {
                tinymce.editors.forEach(function (editor) {
                    editor.remove();
                });
            }
        }
        $(document).ready(function () {
            $('#outstanding_item_form_show_button').click(function () {
                $('#outstanding_item_form_show').fadeToggle('slow');
            });
            $('#outstanding_item_form_show_button_for_appointment').click(function () {
                $('#hide_checklsit_form_for_appointment3').fadeToggle('slow');
            });
            outstanding_item_checkboxes();
            function outstanding_item_checkboxes() {
                $.ajax({
                    url: "<?php echo admin_url('leads/checklist_details/' . $lead->id . '/3'); ?>",
                    type: "GET",
                    dataType: "json",
                    success: function (response) {
                        $.each(response, function (index, item) {
                            var isChecked = item.checkbox_status == 1;
                            var checkboxId = 'email_review_outstanding_item_checkboxes_' + item.id;
                            function toggleCheckbox(div) {
                                var checkbox = $(div).find('input[type="checkbox"]');
                                checkbox.prop('checked', !checkbox.prop('checked')).trigger('change');
                            }
                        });
                    },
                    error: function (xhr, status, error) {
                    }
                });
            }
            $(document).off('change', 'input[name="outstanding_item_checkbox"]').on('change', 'input[name="outstanding_item_checkbox"]', function () {
                var checkbox = $(this);
                var checkboxId = checkbox.data('id');
                var sameGroup = '<?php echo $samegroup; ?>';
                var titleText = checkbox.closest('.form-group').find('label[for="' + checkboxId + '"]').text().trim();
                $.ajax({
                    url: '<?php echo admin_url('leads/outstanding_item_checkbox_status/' . $lead->id); ?>',
                    type: 'POST',
                    data: { id: checkboxId },
                    dataType: 'json',
                    success: function (response) {
                        if (response.checked === true) {
                            if (response.checked_status == 1) {
                                destroyTinyMCE();
                                _lead_init_data(response, response.id);
                                $('a[href="' + response.leads_status + '"]').tab('show');
                                if (sameGroup != 2) {
                                    $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                }
                                checkbox.next('label').wrapInner('<del>');
                                checkbox.prop('checked', true);
                            } else {
                                checkbox.next('label').find('del').contents().unwrap();
                                checkbox.prop('checked', false);
                            }

                            alert_float('success', 'Checklist Item Status updated.');
                        } else {
                            $('#get_checkbox_title_outstanding').text(titleText);
                            $('#outstanding_item_modal_upload_doc').modal('show');
                            setTimeout(function () {
                                $('#outstanding_item_modal_upload_doc').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                            }, 200);
                            appendInputAndRemovePrevious_for_oustanding_item('task_id', response.task_id);
                            checkbox.prop('checked', true);
                            alert_float('danger', 'Please upload (' + titleText + ') document first.');
                            checkbox.prop('checked', false);
                        }
                    },
                    error: function (xhr, status, error) {
                    }
                });
            });

        });

        // upload file openeed files  
        $(document).ready(function () {
            $('#outstanding_item_modal_close_button').click(function () {
                $('#outstanding_item_modal_upload_doc').modal('hide');
            });
            $('#ld_outstanding_item_modal_close_button').click(function () {
                $('#ld_outstanding_item_modal_upload_doc').modal('hide');
            });
            $('#request_for_funds_modal_close_button').click(function () {
                $('#request_for_funds_modal_upload_doc').modal('hide');
            });
            $('#ledger_status_comment_close_btn').click(function () {
                $('#ledgers_status_comment_modal').modal('hide');
            });
            $('#show_logs_modal_close_btn').click(function () {
                $('#show_logs_modal').modal('hide');
            });
            $('#checklist_update_modal_close_btn').click(function () {
                $('#update_checklist_form')[0].reset();
                $('#checklist_update_modal').modal('hide');
            });
            $('#ld_checklist_update_modal_close_btn').click(function () {
                $('#ld_update_checklist_form')[0].reset();
                $('#ld_checklist_update_modal').modal('hide');
            });
            $('#generic_modal_closing_btn').click(function () {
                $(this).closest('.modal').modal('hide');
                $('#generic_modal').modal('hide');
            });
            $('#case_report_modal_closing_btn').click(function () {
                $(this).closest('.modal').modal('hide');
                $('#case_report_modal').modal('hide');
            });
            function reinitializeEditor(formId, editorId, content) {
                var existingEditor = tinymce.get(editorId);
                if (existingEditor) {
                    existingEditor.remove();
                }
                var editorElement = document.getElementById(editorId);
                if (!editorElement) {
                    console.error('Editor element not found: ' + editorId);
                    return;
                }
                tinymce.init({
                    selector: `#${editorId}`,
                    height: 300,
                    menubar: false,
                    plugins: 'code lists textcolor',
                    toolbar: 'undo redo | bold italic | forecolor backcolor | styleselect | fontsizeselect | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | code',
                    font_family_formats: 'Arial=arial,helvetica,sans-serif;Times New Roman=times new roman,times;Courier New=courier new,courier;Georgia=georgia,palatino;Verdana=verdana,geneva',
                    fontsize_formats: '8pt 10pt 12pt 14pt 18pt 24pt 36pt',
                    content_style: "@import url('https://fonts.googleapis.com/css2?family=Oswald&display=swap');",
                    setup: function (editor) {
                        editor.on('init', function () {
                            if (content) {
                                editor.setContent(content);
                            }
                        });
                    }
                });
                setTimeout(function () {
                    var reinitializedEditor = tinymce.get(editorId);
                }, 1000);
            }
            // Case report temaple modal open 
            $('#case_report_modal_trigger_btn').on('click', function () {
                $('#CaseReportModalLabel').text('Review the template of Case Report.');
                $('#case_report_modal').modal('show');
            });
            // General reports modal code 
            function loadAndAppendFormGeneric(formHtml, modal_empty_check) {
                $('#dynamic_form_container').empty();
                $('#dynamic_form_container').append(formHtml);
                $('#generic_modal').modal('show');
            }
            // BB to approve closing dat ledgers
            var bb_to_approve_closing_day_ledger = `
                    <?php echo form_open((admin_url('leads/bb_to_approve_closing_day_ledger/')), ['id' => 'bb_to_approve_closing_day_ledger']); ?>
                        <?php echo render_textarea('bb_to_approve_closing_day_ledger_notes', 'Notes', '', array('placeholder' => 'Please enter the item notes.')); ?>
                        <div class="form-group">
                            <label for="bb_to_approve_closing_day_ledger_userfile" id="final_closing_ledger_userfile_title" class="control-label">Select
                                Files (PDF, JPEG, JPG, PNG, DOC, DOCX, XLS, XLSX)</label>
                            <input type="file" class="form-control" name="bb_to_approve_closing_day_ledger_userfile[]" id="bb_to_approve_closing_day_ledger_userfile"
                                multiple accept=".pdf, .jpeg, .jpg, .png, .doc, .docx, .xls, .xlsx"
                                style="height:53px;">
                            <div id="bb_to_approve_closing_day_ledger_userfile_error" class="error-message" style="color:red;"></div>
                        </div>
                        <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                        <div class="col-md-12" style="margin-bottom:10px;display: flex;justify-content: end;align-items: center;">
                            <div style="margin-right: 10px;margin-top:-5px;" id="bb_to_approve_closing_day_ledger_loader"></div>
                            <button type="submit" class="btn btn-primary pull-right" id="bb_to_approve_closing_day_ledger_btn">
                                <?php echo _l('Submit'); ?>
                            </button>
                        </div>
                    <?php echo form_close(); ?>
                `;
            // BB response to closing day ledgers
            var bb_response_to_closing_day_ledger = `
                    <?php echo form_open((admin_url('leads/bb_response_to_closing_day_ledger/')), ['id' => 'bb_response_to_closing_day_ledger']); ?>
                        <?php echo render_textarea('bb_response_to_closing_day_ledger_notes', 'Notes', '', array('placeholder' => 'Please enter the item notes.')); ?>
                        <div class="form-group">
                            <label for="bb_response_to_closing_day_ledger_userfile" id="final_closing_ledger_userfile_title" class="control-label">Select
                                Files (PDF, JPEG, JPG, PNG, DOC, DOCX, XLS, XLSX)</label>
                            <input type="file" class="form-control" name="bb_response_to_closing_day_ledger_userfile[]" id="bb_response_to_closing_day_ledger_userfile"
                                multiple accept=".pdf, .jpeg, .jpg, .png, .doc, .docx, .xls, .xlsx"
                                style="height:53px;">
                            <div id="bb_response_to_closing_day_ledger_userfile_error" class="error-message" style="color:red;"></div>
                        </div>
                        <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                        <div class="col-md-12" style="margin-bottom:10px;display: flex;justify-content: end;align-items: center;">
                            <div style="margin-right: 10px;margin-top:-5px;" id="bb_response_to_closing_day_ledger_loader"></div>
                            <button type="submit" class="btn btn-primary pull-right" id="bb_response_to_closing_day_ledger_btn">
                                <?php echo _l('Submit'); ?>
                            </button>
                        </div>
                    <?php echo form_close(); ?>
                `;
            // final closing ledgers form modal 
            var final_closing_ledger_send_to_bb = `
                    <?php echo form_open((admin_url('leads/final_closing_ledger_send_to_bb/')), ['id' => 'final_closing_ledger_send_to_bb']); ?>
                        <?php echo render_textarea('final_closing_ledger_send_to_bb_notes', 'Notes', '', array('placeholder' => 'Please enter the item notes.')); ?>
                        <div class="form-group">
                            <label for="final_closing_ledger_userfile" id="final_closing_ledger_userfile_title" class="control-label">Select
                                Files (PDF, JPEG, JPG, PNG, DOC, DOCX, XLS, XLSX)</label>
                            <input type="file" class="form-control" name="final_closing_ledger_userfile[]" id="final_closing_ledger_userfile"
                                multiple accept=".pdf, .jpeg, .jpg, .png, .doc, .docx, .xls, .xlsx"
                                style="height:53px;">
                            <div id="final_closing_ledger_userfile_error" class="error-message" style="color:red;"></div>
                        </div>
                        <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                        <div class="col-md-12" style="margin-bottom:10px;display: flex;justify-content: end;align-items: center;">
                            <div style="margin-right: 10px;margin-top:-5px;" id="final_closing_ledger_send_to_bb_loader"></div>
                            <button type="submit" class="btn btn-primary pull-right" id="final_closing_ledger_send_to_bb_btn">
                                <?php echo _l('Submit'); ?>
                            </button>
                        </div>
                    <?php echo form_close(); ?>
                `;
            // form for closing button (BB response to final ledgers)
            var final_closing_bb_response_final_ledger = `
                    <?php echo form_open((admin_url('leads/final_closing_bb_response_final_ledger/')), ['id' => 'final_closing_bb_response_final_ledger']); ?>
                        <?php echo render_textarea('final_closing_ledger_send_to_bb_notes', 'Notes', '', array('placeholder' => 'Please enter the item notes.')); ?>
                        <div class="form-group">
                            <label for="confirm_closing" class="control-label">Select Option</label>
                            <select name="confirm_closing" id="confirm_closing" class="form-control" 
                                    data-width="100%" data-none-selected-text="Nothing selected" data-live-search="true" tabindex="-98">
                                <option value="Funds in">Funds in</option>
                                <option value="Private Discharge Process">Private Discharge Process</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="final_closing_ledger_userfile" id="final_closing_ledger_userfile_title" class="control-label">
                                Select Files (PDF, JPEG, JPG, PNG, DOC, DOCX, XLS, XLSX)
                            </label>
                            <input type="file" class="form-control" name="final_closing_ledger_userfile[]" 
                                id="final_closing_ledger_userfile" multiple accept=".pdf, .jpeg, .jpg, .png, .doc, .docx, .xls, .xlsx"
                                style="height:53px;">
                            <div id="final_bb_response_closing_ledger_userfile_error" class="error-message" style="color:red;"></div>
                        </div>
                        <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                        <div class="col-md-12" style="margin-bottom:10px;display: flex;justify-content: end;align-items: center;">
                            <div style="margin-right: 10px;margin-top:-5px;" id="final_closing_ledger_bb_response_loader"></div>
                            <button type="submit" class="btn btn-primary pull-right" id="final_closing_ledger_bb_response_btn">
                                <?php echo _l('Submit'); ?>
                            </button>
                        </div>
                    <?php echo form_close(); ?>
                `;
            // thrid closed button Confirm final Closing internally form
            var Confirm_final_Closing_internally = `
                    <?php echo form_open((admin_url('leads/confirm_final_closing_internally/')), ['id' => 'confirm_final_closing_internally']); ?>
                            <?php echo render_input('to_confirm_closing_ledgers', 'To', 'bb@legaldirect.ca', '', ['required' => 'required']); ?>
                            <?php echo render_input('cc_confirm_closing_ledgers', 'CC', $cc_group_memebers, ''); ?>
                            <?php echo render_input('bcc_confirm_closing_ledgers', 'BCC', 'en@legaldirect.ca,nb@legaldirect.ca', ''); ?>
                            <div class="col-md-12" style="margin-bottom:15px;">
                                <textarea name="send_tinymace_final_ledger_cofirm_final_close_email"
                                id="send_tinymace_final_ledger_cofirm_final_close_email" rows="10" cols="80"
                                style="height: 140px;"></textarea>
                            </div>
                            <input type="hidden" name="lead_id" value="<?php echo $lead->id; ?>">
                            <div class="checkbox-inline checkbox checkbox-primary" style="margin-top:10px;">   
                                <input type="checkbox" name="archive_check" id="archive_check" >
                                <label>Move to archive</label>
                            </div>
                            <div class="col-md-12" style="margin-bottom:10px;display: flex;justify-content: end;align-items: center;">
                                <div style="margin-right: 10px;margin-top:-5px;" id="final_closing_ledger_bb_response_loader"></div>
                                <button type="submit" class="btn btn-primary pull-right" id="final_closing_ledger_bb_response_btn">
                                    <?php echo _l('Submit'); ?>
                                </button>
                            </div>
                    <?php echo form_close(); ?>
                `;
            // appened and call the generic modal using different button action
            // final closing ledger send to the bob
            $('#bb_approve_closing_day_ledger').on('click', function () {
                $('#genericModalLabel').text('BB to approve closing day ledgers.');
                loadAndAppendFormGeneric(bb_to_approve_closing_day_ledger, 'true');
            });
            // BB response to closing day ledgers
            $('#bb_response_to_closing_day_ledger').on('click', function () {
                $('#genericModalLabel').text('BB response to closing day ledgers.');
                loadAndAppendFormGeneric(bb_response_to_closing_day_ledger, 'true');
            });
            $('#send_final_close_ledger').on('click', function () {
                $('#genericModalLabel').text('Send final ledgers/attachments/wire confirmation to BB.');
                loadAndAppendFormGeneric(final_closing_ledger_send_to_bb, 'true');
            });
            // in final stage button BB response to final ledgers 
            $('#bb_response_final_close_ledger').on('click', function () {
                $('#genericModalLabel').text('BB response to final ledgers.');
                loadAndAppendFormGeneric(final_closing_bb_response_final_ledger, 'true');
            });
            var only_first_time_show_form = false;
            $('#final_closeing_ledger').on('click', function () {
                $('#genericModalLabel').text('Confirm final Closing internally.');
                loadAndAppendFormGeneric(Confirm_final_Closing_internally, 'true');
                var content = '<p>Dear Colleague,</p>' + '<p>Discharge in/Closing now being confirmed. Please proceed with banking.</p>';
                reinitializeEditor('confirm_final_closing_internally', 'send_tinymace_final_ledger_cofirm_final_close_email', content);
            });
            // move to the archive 
            $('#move_to_archive').off('click').on('click', function () {
                $('.full-page-loader').show();
                // if (confirm('Are you sure you want to move this case to the archive?')) {
                    $.ajax({
                        url: '<?php echo admin_url("leads/move_to_archive/" . $lead->id); ?>',
                        type: 'POST',
                        data: {},
                        success: function (response) {
                            if (response.success) {
                                $('.full-page-loader').hide();
                                alert_float('success', 'The case has been successfully moved to the archive.');
                                destroyTinyMCE();
                                leads_kanban();
                                _lead_init_data(response, response.id);
                            } else {
                                $('.full-page-loader').hide();
                                alert_float('danger', 'There was an issue moving the case to the archive. Please try again.');
                            }
                        },
                        error: function (xhr, status, error) {
                            $('.full-page-loader').hide();
                            alert_float('danger', 'An error occurred. Please try again.');
                        }
                    });
                // } else {
                //     alert_float('danger', 'The case was not moved to the archive.');
                // }
            });
            $('#add_ledgers, #add_revised_ledgers').click(function () {
                $('#ledger_modal_title').text('Please Upload Ledgers');
                $('#review_ledgers_broker_email').hide();
                $('#ledger_userfile_title').text('Select Ledgers');
                removeInputField_ledger_for_broker();
                upload_doc_for_ledger();
            });
            // appened and remvoe the broker ledgers doc
            $('#send_ledger_number_ledgers_to_broker').click(function () {
                $.ajax({
                    url: '<?php echo admin_url('leads/get_the_last_approved_ledger_time/' . $lead->id); ?>',
                    method: "GET",
                    dataType: "json",
                    success: function (response) {
                        if (response.success) {
                            $('#show_text_to_broker').text('The last approved ledger was ' + response.ledger_approve_time + '.');
                        } else {
                            $('#show_text_to_broker').text('There are no approved ledgers at this time.');
                        }
                    },
                    error: function () {
                    }
                });
                $('#ledger_modal_title').text('Upload Additional Files');
                $('#review_ledgers_broker_email').show();
                $('#ledger_userfile_title').text('Select Additional Files(Optional)');
                upload_doc_for_ledger();
                removeInputField_ledger_for_broker();
                appendInputField_ledger_for_broker();
            });
            $('#ledger_modal_close_button').click(function () {
                $('#show_text_to_broker').text('');
                $('#ledger_modal_upload_doc').modal('hide');
            });
            // final BB to approve closing day ledgers
            $(document).off('submit', '#bb_to_approve_closing_day_ledger').on('submit', '#bb_to_approve_closing_day_ledger', function (e) {
                e.preventDefault();
                var formData = new FormData(this);
                var sameGroup = '<?php echo $samegroup; ?>';
                // Validate file input
                var files = $('#bb_to_approve_closing_day_ledger_userfile')[0].files;
                if (files.length === 0) {
                    $('#bb_to_approve_closing_day_ledger_userfile_error').text('Please select at least one file.');
                    return;
                } else {
                    $('#bb_to_approve_closing_day_ledger_userfile_error').text('');
                }
                $('#bb_to_approve_closing_day_ledger_btn').prop('disabled', true);
                $('#bb_to_approve_closing_day_ledger_loader').addClass('loader');
                $.ajax({
                    url: $(this).attr('action'),
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function (response) {
                        $('#bb_to_approve_closing_day_ledger_btn').prop('disabled', false);
                        $('#bb_to_approve_closing_day_ledger_loader').removeClass('loader');
                        $('#bb_to_approve_closing_day_ledger_loader').empty();
                        alert_float('success', 'BB to Approve Closing day ledgers');
                        $('#generic_modal').modal('hide');
                        _lead_init_data(response, response.id);
                        $('a[href="' + response.leads_status + '"]').tab('show');
                        if (sameGroup != 2) {
                            $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                        }
                    },
                    error: function (xhr, status, error) {
                        $('#bb_to_approve_closing_day_ledger_loader').empty();
                        console.error('An error occurred: ' + error);
                    }
                });
            });
            // BB response to closing day ledgers
            $(document).off('submit', '#bb_response_to_closing_day_ledger').on('submit', '#bb_response_to_closing_day_ledger', function (e) {
                e.preventDefault();
                var formData = new FormData(this);
                var sameGroup = '<?php echo $samegroup; ?>';
                // Validate file input
                var files = $('#bb_response_to_closing_day_ledger_userfile')[0].files;
                if (files.length === 0) {
                    $('#bb_response_to_closing_day_ledger_userfile_error').text('Please select at least one file.');
                    return;
                } else {
                    $('#bb_response_to_closing_day_ledger_userfile_error').text('');
                }
                $('#bb_response_to_closing_day_ledger_btn').prop('disabled', true);
                $('#bb_response_to_closing_day_ledger_loader').addClass('loader');
                $.ajax({
                    url: $(this).attr('action'),
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function (response) {
                        $('#bb_response_to_closing_day_ledger_btn').prop('disabled', false);
                        $('#bb_response_to_closing_day_ledger_loader').removeClass('loader');
                        $('#bb_response_to_closing_day_ledger_loader').empty();
                        alert_float('success', 'Successfully Response to the Team.');
                        $('#generic_modal').modal('hide');
                        _lead_init_data(response, response.id);
                        $('a[href="' + response.leads_status + '"]').tab('show');
                        if (sameGroup != 2) {
                            $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                        }
                    },
                    error: function (xhr, status, error) {
                        $('#bb_response_to_closing_day_ledger_loader').empty();
                        console.error('An error occurred: ' + error);
                    }
                });
            });
            // final closing legers doc send and submit for first button (Send final ledgers/attachments/wire confirmation to BB)
            $(document).off('submit', '#final_closing_ledger_send_to_bb').on('submit', '#final_closing_ledger_send_to_bb', function (e) {
                e.preventDefault();

                var formData = new FormData(this);
                var sameGroup = '<?php echo $samegroup; ?>';
                // Validate file input
                var files = $('#final_closing_ledger_userfile')[0].files;
                if (files.length === 0) {
                    $('#final_closing_ledger_userfile_error').text('Please select at least one file.');
                    return;
                } else {
                    $('#final_closing_ledger_userfile_error').text('');
                }
                $('#final_closing_ledger_send_to_bb_btn').prop('disabled', true);
                $('#final_closing_ledger_send_to_bb_loader').addClass('loader');
                $.ajax({
                    url: $(this).attr('action'),
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function (response) {
                        $('#final_closing_ledger_send_to_bb_btn').prop('disabled', false);
                        $('#final_closing_ledger_send_to_bb_loader').removeClass('loader');
                        $('#final_closing_ledger_send_to_bb_loader').empty();
                        alert_float('success', 'Final ledgers detials has been sent to the bob!');
                        $('#generic_modal').modal('hide');
                        _lead_init_data(response, response.id);
                        $('a[href="' + response.leads_status + '"]').tab('show');
                        if (sameGroup != 2) {
                            $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                        }
                    },
                    error: function (xhr, status, error) {
                        $('#final_closing_ledger_send_to_bb_loader').empty();
                        console.error('An error occurred: ' + error);
                    }
                });
            });
            // final ledgers bb response 
            $(document).off('submit', '#final_closing_bb_response_final_ledger').on('submit', '#final_closing_bb_response_final_ledger', function (e) {
                e.preventDefault();

                var formData = new FormData(this);
                var sameGroup = '<?php echo $samegroup; ?>';
                $('#final_closing_ledger_bb_response_btn').prop('disabled', true);
                $('#final_closing_ledger_bb_response_loader').addClass('loader');
                $.ajax({
                    url: $(this).attr('action'),
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function (response) {
                        // Handle successful response
                        $('#final_closing_ledger_bb_response_btn').prop('disabled', false);
                        $('#final_closing_ledger_bb_response_loader').removeClass('loader');
                        $('#final_closing_bb_response_final_ledger').empty();
                        alert_float('success', 'Final ledgers detials has been sent to the bob!');
                        $('#generic_modal').modal('hide');
                        _lead_init_data(response, response.id);
                        $('a[href="' + response.leads_status + '"]').tab('show');
                        if (sameGroup != 2) {
                            $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                        }
                    },
                    error: function (xhr, status, error) {
                        $('#final_closing_bb_response_final_ledger').empty();
                        console.error('An error occurred: ' + error);
                    }
                });
            });
            // Confirm final closing internally
            $(document).off('submit', '#confirm_final_closing_internally').on('submit', '#confirm_final_closing_internally', function (e) {
                e.preventDefault();
                // var confirmation = confirm('Are you sure you want to submit the form?');
                // if (confirmation) {
                    var formData = new FormData(this);
                    var sameGroup = '<?php echo $samegroup; ?>';
                    $.ajax({
                        url: $(this).attr('action'),
                        type: 'POST',
                        data: formData,
                        contentType: false,
                        processData: false,
                        success: function (response) {
                            alert_float('success', 'Email has been sent successfully!.');
                            $('#generic_modal').modal('hide');
                        },
                        error: function (xhr, status, error) {
                            console.error('An error occurred: ' + error);
                        }
                    });
                // }
            });

            // outstanding item form upload doc code
            $('#outstanding_item_modal_upload_doc_form').submit(function (event) {
                event.preventDefault();
                $('#outstanding_item_userfile_error').text('');
                var fileInput = document.getElementById('outstanding_item_userfile');
                if (fileInput.files.length === 0) {
                    var errorMessage = 'Please select at least one document.';
                    $('#outstanding_item_userfile_error').text(errorMessage);
                    return;
                }
                $('#outstanding_item_submit_button').prop('disabled', true);
                $('#outstanding_loader').addClass('loader');
                var formData = new FormData($(this)[0]);
                var sameGroup = '<?php echo $samegroup; ?>';
                $.ajax({
                    url: '<?php echo admin_url('leads/upload_doc_for_outstanding_item/' . $lead->id); ?>',
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function (response) {
                        var anchor = document.querySelector('#outstanding_item_modal_close_button');
                        anchor.click();
                        $('#outstanding_item_modal_close_button').trigger('click');
                        var anchor = document.querySelector('.close');
                        anchor.click();
                        // $('#outstanding_item_modal_upload_doc').modal('hide');
                        alert_float('success', 'Documents uploaded successfully.');
                        $('#outstanding_item_submit_button').prop('disabled', false);
                        $('#outstanding_loader').removeClass('loader');
                        setTimeout(function () {
                            destroyTinyMCE();
                            _lead_init_data(response, response.id);
                            $('a[href="' + response.leads_status + '"]').tab('show');
                            if (sameGroup != 2) {
                                $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                            }
                        }, 500);
                    },
                    error: function (response) {
                        var errorMessage = 'Error uploading file,please try again.';
                        $('#outstanding_item_submit_button').prop('disabled', false);
                        $('#outstanding_loader').removeClass('loader');
                        $('#userfile_error').text(errorMessage);
                        alert_float('warning', 'Documents not uploaded,please refresh page.');
                    }
                });
            });
            // LD oustanding item upload doc code
            $('#ld_outstanding_item_modal_upload_doc_form').submit(function (event) {
                event.preventDefault();
                var formData = new FormData($(this)[0]);
                var removeValidation = formData.get('ld_remove_validation');
                $('#ld_outstanding_item_userfile_error').text('');
                var fileInput = document.getElementById('ld_outstanding_item_userfile');
                if (removeValidation === '0') {
                    if (fileInput.files.length === 0) {
                        var errorMessage = 'Please select at least one document.';
                        $('#ld_outstanding_item_userfile_error').text(errorMessage);
                        return;
                    }
                }
                $('#ld_outstanding_item_submit_button').prop('disabled', true);
                $('#ld_outstanding_item_loader').addClass('loader');
                var sameGroup = '<?php echo $samegroup; ?>';
                $.ajax({
                    url: '<?php echo admin_url('leads/upload_doc_for_ld_outstanding_item/' . $lead->id); ?>',
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function (response) {
                        $('#ld_outstanding_item_modal_upload_doc_form')[0].reset();
                        var anchor = document.querySelector('#ld_outstanding_item_modal_close_button');
                        anchor.click();
                        alert_float('success', 'Documents uploaded successfully.');
                        $('#ld_outstanding_item_submit_button').prop('disabled', false);
                        $('#ld_outstanding_item_loader').removeClass('loader');
                        setTimeout(function () {
                            destroyTinyMCE();
                            if (anchor) {
                                _lead_init_data(response, response.id);
                            }
                            $('a[href="' + response.leads_status + '"]').tab('show');
                            if (sameGroup != 2) {
                                $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                            }
                        }, 500);
                        setTimeout(function () {
                            $('#ld_outstanding_item_tr_' + response.cases_checkbox_id).css('background', '#ddddddba');
                            $('#ld_outstanding_item_tr_' + response.cases_checkbox_id).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                        }, 8000);
                    },
                    error: function (response) {
                        var errorMessage = 'Error uploading file,please try again.';
                        $('#ld_outstanding_item_submit_button').prop('disabled', false);
                        $('#ld_outstanding_item_loader').removeClass('loader');
                        alert_float('warning', 'Documents not uploaded,please refresh page.');
                    }
                });
            });
            //LD  Request for funds upload doc code
            $('#request_for_funds_modal_upload_doc_form').submit(function (event) {
                event.preventDefault();
                $('#request_for_funds_userfile_error').text('');
                var type = document.querySelector('.type') ? document.querySelector('.type').value : '';
                var req_funds_asterisk = document.getElementById('req_funds_asterisk');
                var fileInput = document.getElementById('request_for_funds_userfile');
                var actionDate = document.querySelector('input[name="action_date"]');

                if (type === 'send-report') {
                    req_funds_asterisk.style.display = 'block';
                    if (fileInput.files.length === 0) {
                        var errorMessage = 'Please select at least one document.';
                        $('#request_for_funds_userfile_error').text(errorMessage);
                        return;
                    }
                } else {
                    req_funds_asterisk.style.display = 'none';
                    $('#request_for_funds_userfile_error').text('');
                    if (fileInput.files.length === 0 && (!actionDate || actionDate.value.trim() === '')) {
                        var errorMessage = 'Please select at least one document or provide an Action Date.';
                        $('#request_for_funds_userfile_error').text(errorMessage);
                        return;
                    }
                }

                $('#request_for_funds_submit_button').prop('disabled', true);
                $('#request_for_funds_loader').addClass('loader');
                var formData = new FormData(this);
                // Get the TinyMCE content and append it to formData
                var editor = tinymce.get('request_for_funds_review_email_tincymac');
                if (editor) {
                    var tinymceContent = editor.getContent();
                    formData.append('request_for_funds_review_email_tincymac', tinymceContent);
                }
                var sameGroup = '<?php echo $samegroup; ?>';
                $.ajax({
                    url: '<?php echo admin_url('leads/upload_doc_for_request_for_funds/' . $lead->id); ?>',
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function (response) {
                        if (response.success) {
                            destroyTinyMCE();
                            var anchor = document.querySelector('#request_for_funds_modal_close_button');
                            anchor.click();
                            alert_float('success', 'Documents uploaded successfully.');
                            $('#request_for_funds_submit_button').prop('disabled', false);
                            $('#request_for_funds_loader').removeClass('loader');
                            setTimeout(function () {
                                if (anchor) {
                                    _lead_init_data(response, response.id);
                                }
                                $('a[href="' + response.leads_status + '"]').tab('show');
                                if (sameGroup != 2) {
                                    $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                }
                            }, 500);
                            setTimeout(function () {
                                $('#request_for_funds_tr_' + response.cases_checkbox_id).css('background', '#ddddddba');
                                $('#request_for_funds_tr_' + response.cases_checkbox_id).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                            }, 8000);
                        } else {
                            console.log(response);
                            $('#request_for_funds_submit_button').prop('disabled', false);
                            $('#request_for_funds_loader').removeClass('loader');
                            alert_float('danger', 'Documents not uploaded,please refresh page.');
                        }
                    },
                    error: function (response) {
                        var errorMessage = 'Error uploading file,please try again.';
                        $('#request_for_funds_submit_button').prop('disabled', false);
                        $('#request_for_funds_loader').removeClass('loader');
                        $('#userfile_error').text(errorMessage);
                        alert_float('danger', 'Documents not uploaded,please refresh page.');
                    }
                });
            });
        });
    </script>
    <script>
        function destroyTinyMCE() {
            tinymce.remove();
            if (tinymce.editors.length > 0) {
                tinymce.editors.forEach(function (editor) {
                    editor.remove();
                });
            }
        }
        // Store comment using ajax
        $('#comment_form').submit(function (e) {
            var leadid = "<?php echo $lead->id ?>";
            e.preventDefault();
            $('#comment_loader').addClass('loader');
            $('#comments-form-submit').prop('disabled', true);
            $.ajax({
                url: "<?php echo admin_url('leads/commentsadd/' . $lead->id); ?>",
                type: 'POST',
                data: $(this).serialize(),
                dataType: 'json',
                success: function (response) {
                    // Assuming the server responds with JSON
                    if (response.success) {
                        destroyTinyMCE();
                        _lead_init_data(response, response.id);
                        $('#comment_form')[0].reset();
                        $('#comment_loader').removeClass('loader');
                        $('#comments-form-submit').prop('disabled', false);
                        $('a[href="#comments"]').tab('show');
                        // alert(response.comment_html);
                        // console.warn(response);
                        $('#down_comments_container').fadeOut('slow');
                        $('#no-comment-found').css('display', 'none');
                        $('.error-message').css('display', 'none');
                        $('textarea[name="comments"]').val('');
                        // just show one time
                        var commentsAppended = false;
                        if (!commentsAppended) {
                            // $('.comments-container').append(response.comment_html);
                            commentsAppended = true;
                        }
                        $('.comments-container').animate({ scrollTop: $('.comments-container')[0].scrollHeight }, 'slow');
                        // $('#checklist_form')[0].reset();

                    } else {
                        $('#comment_loader').removeClass('loader');
                        $('#comments-form-submit').prop('disabled', false);
                        // Display validation errors
                        if (response.errors) {
                            // Clear previous error messages
                            $('.error-message').remove();
                            $.each(response.errors, function (field, message) {
                                var errorDiv = $('<div class="error-message" style="color: red; margin-top: 5px;">' + message + '</div>');
                                $('textarea[name="comments"]').parent().append(errorDiv);
                            });
                        } else {
                        }
                    }
                }
            });
        }); 
        // admin ld comments
        $('#admin_ld_comments_form').submit(function (e) {
            var leadid = "<?php echo $lead->id ?>";
            e.preventDefault();
            $('#admin_ld_comments_loader').addClass('loader');
            $('#admin_ld_comments_form_submit').prop('disabled', true);
            $.ajax({
                url: "<?php echo admin_url('leads/admin_ld_comments_add/' . $lead->id); ?>",
                type: 'POST',
                data: $(this).serialize(),
                dataType: 'json',
                success: function (response) {
                    // Assuming the server responds with JSON
                    if (response.success) {
                        destroyTinyMCE();
                        _lead_init_data(response, response.id);
                        $('#comment_form')[0].reset();
                        $('#admin_ld_comments_loader').removeClass('loader');
                        $('#admin_ld_comments_form_submit').prop('disabled', false);
                        $('a[href="#admin_ld_comments"]').tab('show');
                        // alert(response.comment_html);
                        // console.warn(response);
                        $('#admin_ld_down_comments_container').fadeOut('slow');
                        $('#no-comment-found').css('display', 'none');
                        $('.error-message').css('display', 'none');
                        $('textarea[name="comments"]').val('');
                        // just show one time
                        var commentsAppended = false;
                        if (!commentsAppended) {
                            // $('.comments-container').append(response.comment_html);
                            commentsAppended = true;
                        }
                        $('.comments-container').animate({ scrollTop: $('.comments-container')[0].scrollHeight }, 'slow');
                        // $('#checklist_form')[0].reset();

                    } else {
                        $('#admin_ld_comments_loader').removeClass('loader');
                        $('#admin_ld_comments_form_submit').prop('disabled', false);
                        // Display validation errors
                        if (response.errors) {
                            // Clear previous error messages
                            $('.error-message').remove();
                            $.each(response.errors, function (field, message) {
                                var errorDiv = $('<div class="error-message" style="color: red; margin-top: 5px;">' + message + '</div>');
                                $('textarea[name="comments"]').parent().append(errorDiv);
                            });
                        } else {
                        }
                    }
                }
            });
        }); 
    </script>
    <!-- LD comments script -->
    <script>
        function destroyTinyMCE() {
            tinymce.remove();
            if (tinymce.editors.length > 0) {
                tinymce.editors.forEach(function (editor) {
                    editor.remove();
                });
            }
        }
        // Store comment using ajax
        // $('#ld_comment_form').submit(function (e) {
        $('#ld_comment_form').off('submit').on('submit', function (e) {
            var leadid = "<?php echo $lead->id ?>";
            e.preventDefault();
            $('#ld_comment_loader').addClass('loader');
            $('#ld-comments-form-submit').prop('disabled', true);
            $.ajax({
                url: "<?php echo admin_url('leads/ld_commentsadd/' . $lead->id); ?>",
                type: 'POST',
                data: $(this).serialize(),
                dataType: 'json',
                success: function (response) {
                    // Assuming the server responds with JSON
                    if (response.success) {
                        destroyTinyMCE();
                        _lead_init_data(response, response.id);
                        $('#ld_comment_form')[0].reset();
                        $('#ld_comment_loader').removeClass('loader');
                        $('#ld-comments-form-submit').prop('disabled', false);
                        $('a[href="#ld_comments"]').tab('show');
                        $('#ld_down_comments_container').fadeOut('slow');
                        $('#ld-no-comment-found').css('display', 'none');
                        $('.ld-error-message').css('display', 'none');
                        $('textarea[name="ld_comments"]').val('');
                        // just show one time
                        var commentsAppended = false;
                        if (!commentsAppended) {
                            commentsAppended = true;
                        }
                        $('.ld-comments-container').animate({ scrollTop: $('.ld-comments-container')[0].scrollHeight }, 'slow');

                    } else {
                        $('#ld_comment_loader').removeClass('loader');
                        $('#ld-comments-form-submit').prop('disabled', false);
                        // Display validation errors
                        if (response.errors) {
                            // Clear previous error messages
                            $('.ld-error-message').remove();
                            $.each(response.errors, function (field, message) {
                                var errorDiv = $('<div class="ld-error-message" style="color: red; margin-top: 5px;">' + message + '</div>');
                                $('textarea[name="ld_comments"]').parent().append(errorDiv);
                            });
                        } else {
                        }
                    }
                }
            });
        });
    </script>
    <script>
        function destroyTinyMCE() {
            tinymce.remove();
            if (tinymce.editors.length > 0) {
                tinymce.editors.forEach(function (editor) {
                    editor.remove();
                });
            }
        }
        var profileurl = '';
        // read the case count
        $(document).off('click', '#client_comment, #broker_comment', '#unified-comments').on('click', '#client_comment, #broker_comment', '#unified-comments', function (e) {
            e.preventDefault();
            var clickedId = $(this).attr('id');
            var action = '';
            if (clickedId === 'client_comment') {
                action = 'client_comment_action';
            } else if (clickedId === 'broker_comment') {
                action = 'broker_comment_action';
            }

            $.ajax({
                url: "<?php echo admin_url('leads/case_count_read/' . $lead->id); ?>",
                type: 'POST',
                data: {
                    action: action 
                },
                success: function (response) {
                    if (clickedId === 'client_comment') {
                        $("#client_badge").remove();
                    } else if (clickedId === 'broker_comment') {
                        $("#broker_badge").remove();
                    } 
                },
                error: function (xhr, status, error) {
                    console.error('Error:', error);
                }
            });
        });
        $.ajax({

            url: "<?php echo admin_url('leads/ld_comments_show/' . $lead->id); ?>",
            type: 'Post',
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    $('textarea[name="comments"]').val('');
                    $.each(response.comment_data, function (index, comment) {
                        var add_you_with_name = comment.current_user_login_id == comment.from_user_id ? ' (You)' : '';
                        var profileurl = comment.profile_url ? comment.profile_url : "<?php echo base_url('assets/images/user-placeholder.webp'); ?>";
                        if (comment.role == 'ld-broker-staff') {
                            var commentHtml = '<div class="comment">' +
                                '<div style="display:flex;justify-content: end;"><img loading="lazy" src="' + profileurl + '" style="width: 4%;height: 32px;border-radius: 90%; margin-left: 7px;">' +
                                '<p class="author" style="margin-top: 5px;margin-left: 7px;">' + comment.staff_name + add_you_with_name + ' </p></div>' +
                                '<p style="margin-top: 10px;display: flex;justify-content: end; direction: ltr;">' + comment.comment_text + '</p>' +
                                '<div style="display: flex;justify-content: end;"><span  class="date sytle="display: flex;justify-content: end;" text-has-action" data-toggle="tooltip" data-title="' + comment.full_time + '" data-original-title title>' + comment.created_at + '</span></div>' +
                                '</div>';
                        } else {
                            var commentHtml = '<div class="comment">' +
                                '<div style="display:flex;"><img loading="lazy" src="' + profileurl + '" style="width: 4%;height: 32px;border-radius: 90%;">' +
                                '<p class="author" style="margin-top: 5px;margin-left: 7px;">' + comment.user_name + '</p></div>' +
                                '<p style="margin-top: 10px;">' + comment.comment_text + '</p>' +
                                '<span  class="date text-has-action" data-toggle="tooltip" data-title="' + comment.full_time + '" data-original-title title> ' + comment.created_at + '</span>' +
                                '</div>';
                        }
                        $('.ld-comments-container').append(commentHtml);

                    });
                    $('.ld-comments-container').scrollTop($('.ld-comments-container')[0].scrollHeight);
                } else {
                    var commentHtml = '<div id="ld-no-comment-found" class="alert alert-info" style="text-align: center; ">' +
                        '<h4 class="author no-margin font-medium-xs bold">' + 'No comments found.' + '</h4>' +
                        '</div>';
                    var commentsAppended = false;
                    if (!commentsAppended) {
                        $('.ld-comments-container').append(commentHtml);
                        commentsAppended = true;
                    }
                    $('#ld_down_comments_container').hide();
                }
            },
            error: function () {

            }
        });
        // admin ld comments container show
        $.ajax({
            url: "<?php echo admin_url('leads/admin_ld_comments_show/' . $lead->id); ?>",
            type: 'Post',
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    $('textarea[name="comments"]').val('');
                    $.each(response.comment_data, function (index, comment) {
                        var add_you_with_name = comment.current_user_login_id == comment.from_user_id ? ' (You)' : '';
                        var profileurl = comment.profile_url ? comment.profile_url : "<?php echo base_url('assets/images/user-placeholder.webp'); ?>";
                        if (comment.role == 'ld-broker-staff') {
                            var commentHtml = '<div class="comment">' +
                                '<div style="display:flex;justify-content: end;"><img loading="lazy" src="' + profileurl + '" style="width: 4%;height: 32px;border-radius: 90%; margin-left: 7px;">' +
                                '<p class="author" style="margin-top: 5px;margin-left: 7px;">' + comment.staff_name + add_you_with_name + ' </p></div>' +
                                '<p style="margin-top: 10px;display: flex;justify-content: end; direction: ltr;">' + comment.comment_text + '</p>' +
                                '<div style="display: flex;justify-content: end;"><span  class="date sytle="display: flex;justify-content: end;" text-has-action" data-toggle="tooltip" data-title="' + comment.full_time + '" data-original-title title>' + comment.created_at + '</span></div>' +
                                '</div>';
                        } else {
                            var commentHtml = '<div class="comment">' +
                                '<div style="display:flex;"><img loading="lazy" src="' + profileurl + '" style="width: 4%;height: 32px;border-radius: 90%;">' +
                                '<p class="author" style="margin-top: 5px;margin-left: 7px;">' + comment.user_name + '</p></div>' +
                                '<p style="margin-top: 10px;">' + comment.comment_text + '</p>' +
                                '<span  class="date text-has-action" data-toggle="tooltip" data-title="' + comment.full_time + '" data-original-title title> ' + comment.created_at + '</span>' +
                                '</div>';
                        }
                        $('.admin_ld_comments_container').append(commentHtml);

                    });
                    $('.admin_ld_comments_container').scrollTop($('.admin_ld_comments_container')[0].scrollHeight);
                } else {
                    var commentHtml = '<div id="ld-no-comment-found" class="alert alert-info" style="text-align: center; ">' +
                        '<h4 class="author no-margin font-medium-xs bold">' + 'No comments found.' + '</h4>' +
                        '</div>';
                    var commentsAppended = false;
                    if (!commentsAppended) {
                        $('.admin_ld_comments_container').append(commentHtml);
                        commentsAppended = true;
                    }
                    $('#admin_ld_down_comments_container').hide();
                }
            },
            error: function () {
            }
        });
    </script>
    <!-- show all comments using ajax -->
    <script>
        function destroyTinyMCE() {
            tinymce.remove();
            if (tinymce.editors.length > 0) {
                tinymce.editors.forEach(function (editor) {
                    editor.remove();
                });
            }
        }
        var profileurl = '';
        $.ajax({

            url: "<?php echo admin_url('leads/comments_show/' . $lead->id); ?>",
            type: 'Post',
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    $('textarea[name="comments"]').val('');
                    $.each(response.comment_data, function (index, comment) {
                        var add_you_with_name = comment.current_user_login_id == comment.from_user_id ? ' (You)' : '';
                        var profileurl = comment.profile_url ? comment.profile_url : "<?php echo base_url('assets/images/user-placeholder.webp'); ?>";
                        if (comment.role == 'staff') {
                            var commentHtml = '<div class="comment">' +
                                '<div style="display:flex;justify-content: end;"><img loading="lazy" src="' + profileurl + '" style="width: 4%;height: 32px;border-radius: 90%; margin-left: 7px;">' +
                                '<p class="author" style="margin-top: 5px;margin-left: 7px;">' + comment.staff_name + add_you_with_name + ' </p></div>' +
                                '<p style="margin-top: 10px;display: flex;justify-content: end; direction: ltr;">' + comment.comment_text + '</p>' +
                                '<div style="display: flex;justify-content: end;"><span  class="date sytle="display: flex;justify-content: end;" text-has-action" data-toggle="tooltip" data-title="' + comment.full_time + '" data-original-title title>' + comment.created_at + '</span></div>' +
                                '</div>';
                        } else {
                            var commentHtml = '<div class="comment">' +
                                '<div style="display:flex;"><img loading="lazy" src="' + profileurl + '" style="width: 4%;height: 32px;border-radius: 90%;">' +
                                '<p class="author" style="margin-top: 5px;margin-left: 7px;">' + comment.user_name + '</p></div>' +
                                '<p style="margin-top: 10px;">' + comment.comment_text + '</p>' +
                                '<span  class="date text-has-action" data-toggle="tooltip" data-title="' + comment.full_time + '" data-original-title title> ' + comment.created_at + '</span>' +
                                '</div>';
                        }
                        $('.comments-container').append(commentHtml);

                    });
                    $('.comments-container').scrollTop($('.comments-container')[0].scrollHeight);
                } else {
                    var commentHtml = '<div id="no-comment-found" class="alert alert-info" style="text-align: center; ">' +
                        '<h4 class="author no-margin font-medium-xs bold">' + 'No comments found.' + '</h4>' +
                        '</div>';
                    var commentsAppended = false;
                    if (!commentsAppended) {
                        $('.comments-container').append(commentHtml);
                        commentsAppended = true;
                    }
                    $('#down_comments_container').hide();
                }
            },
            error: function () {

            }
        });
    </script>
    <!-- refresh comments -->
    <script>
        function destroyTinyMCE() {
            tinymce.remove();
            if (tinymce.editors.length > 0) {
                tinymce.editors.forEach(function (editor) {
                    editor.remove();
                });
            }
        }
        $(document).ready(function () {
            var leadId = "<?php echo $lead->id;?>";
            // refresh activity logs
            $('button#refresh_activity').click(function () {
                const icon = $(this).find('i');

                icon.addClass('rotate-animation');

                $.ajax({
                    url: "<?php echo admin_url('leads/activity_refresh_show/' . $lead->id); ?>",
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        scroll_down();
                        destroyTinyMCE();
                        _lead_init_data(response, response.id);
                        $('a[href="#lead_activity"]').tab('show');
                    },
                    error: function (xhr, status, error) {
                        console.error(error);
                    },
                    complete: function () {
                        icon.removeClass('rotate-animation');
                    }
                });
            });
            // outbox_refresh 
            $('button#outbox_refresh').click(function () {
                const icon = $(this).find('i');

                icon.addClass('rotate-animation');
                setTimeout(() => {
                    icon.removeClass('rotate-animation');
                }, 9000);

                fetchOutboxRecords(leadId);
                $('a[href="#outbox"]').tab('show');
            });

            // refresh comment 
            $('button#refresh_comments').click(function () {
                const icon = $(this).find('i');

                icon.addClass('rotate-animation');

                $.ajax({
                    url: "<?php echo admin_url('leads/comments_refresh_show/' . $lead->id); ?>",
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        scroll_down();
                        destroyTinyMCE();
                        _lead_init_data(response, response.id);
                        $('a[href="#comments"]').tab('show');
                    },
                    error: function (xhr, status, error) {
                        console.error(error);
                    },
                    complete: function () {
                        // stop spinning once the request is done
                        icon.removeClass('rotate-animation');
                    }
                });
            });

            // LD Refresh comment
            $('button#ld_refresh_comments').click(function () {
                const icon = $(this).find('i');
                icon.addClass('rotate-animation');

                $.ajax({
                    url: "<?php echo admin_url('leads/comments_refresh_show/' . $lead->id); ?>",
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        scroll_down();
                        destroyTinyMCE();
                        _lead_init_data(response, response.id);
                        $('a[href="#ld_comments"]').tab('show');
                    },
                    error: function (xhr, status, error) {
                        console.error(error);
                    },
                    complete: function () {
                        icon.removeClass('rotate-animation');
                    }
                });
            });

            $('button#admin_ld_refresh_comments').click(function () {
                const icon = $(this).find('i'); // rotate only the icon
                icon.addClass('rotate-animation');

                $.ajax({
                    url: "<?php echo admin_url('leads/comments_refresh_show/' . $lead->id); ?>",
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        scroll_down();
                        destroyTinyMCE();
                        _lead_init_data(response, response.id);
                        $('a[href="#admin_ld_comments"]').tab('show');
                    },
                    error: function (xhr, status, error) {
                        console.error(error);
                    },
                    complete: function () {
                        icon.removeClass('rotate-animation');
                    }
                });
            });

        });
    </script>
    <!-- remove Checklist -->
    <script>
        function destroyTinyMCE() {
            tinymce.remove();
            if (tinymce.editors.length > 0) {
                tinymce.editors.forEach(function (editor) {
                    editor.remove();
                });
            }
        }
        var sameGroup = '<?php echo $samegroup; ?>';
        $(document).off('click', '.delete-checklist-link').on('click', '.delete-checklist-link', function (e) {
            e.preventDefault();
            var sameGroup = '<?php echo $samegroup; ?>';
            var checklistId = $(this).data('id');
            var tdIdToRemove = 'delete_checklist' + checklistId;
            if ($(this).data('delete-in-progress')) {
                return;
            }
            $(this).data('delete-in-progress', true);
            var confirmationShown = false;
            // if (!confirmationShown) {
            //     if (confirm('Are you sure you want to delete this checklist?')) {
            //         confirmationShown = true;
            //     } else {
            //         $(this).data('delete-in-progress', false);
            //         return;
            //     }
            // }
            $('.full-page-loader').show();
            setTimeout(function () {
                $('#full_page_loader').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
            }, 200);
            $.ajax({
                url: "<?php echo admin_url('leads/delete_checklist_details/'); ?>" + checklistId,
                type: "POST",
                success: function (response) {
                    // Handle success response
                    $('.full-page-loader').hide();
                    $('#' + tdIdToRemove).remove();
                    destroyTinyMCE();
                    alert_float('success', 'Checklist deleted successfully.');
                    _lead_init_data(response, response.id);
                    $('a[href="' + response.leads_status + '"]').tab('show');
                    if (sameGroup != 2) {
                        $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                    }
                },
                error: function (error) {
                    alert_float('error', 'Checklist not deleted.');
                },
                complete: function () {
                    $(this).data('delete-in-progress', false);
                }
            });
        });
        // get the record of checklist item and show the modal 
        $(document).off('click', '#update_checklist').on('click', '#update_checklist', function () {
            // Run the AJAX request
            var checklistId = $(this).data('id');
            $.ajax({
                url: "<?php echo admin_url('leads/get_checklist_details_by_id/' . $lead->id); ?>",
                method: "GET",
                data: {
                    checklistId: checklistId,
                },
                success: function (response) {
                    if (response.success) {
                        if ((response.leads_status == 1 && response.type == 'client') && response.type != 'other') {
                            $('#client_notes_textarea_toggle').hide();
                        } else {
                            $('#client_notes_textarea_toggle').show();
                        }
                        $('#update_item_name').val(response.name);
                        var htmlContent = response.notes;
                        var plainTextContent = $('<div>').html(htmlContent).text();
                        $('#update_item_notes').val(plainTextContent);
                        $('#checklist_update_modal').modal('show');
                        setTimeout(function () {
                            $('#checklist_update_modal').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                        }, 200);
                        remove_input_of_checklist_id('#update_checklist_form', 'client_checklist_id', '');
                        appened_input_of_checklist_id('#update_checklist_form', 'client_checklist_id', checklistId);
                    }
                },
                error: function (xhr, status, error) {
                    // Handle the error response here
                    console.error('AJAX request error:', status, error);
                }
            });
        });
        function update_item_records(row, itemName, description, itemComments, id){
            row.find('.item-name').text(itemName || '');
            row.find('.item-notes').text(description || '');
            row.find('.item-comments').text(itemComments || '');
            if(id){
                $("[data-id='" + id + "']").each(function () {
                    const parentRow = $(this).closest('tr');

                    parentRow.find('.item-name').text(itemName || '');
                    parentRow.find('.item-notes').text(description || '');
                    parentRow.find('.item-comments').text(itemComments || '');
                });
            }
        }
        // update ajax of clients checklist ids
        $('#update_checklist_form').submit(function (e) {
            var leadid = "<?php echo $lead->id ?>";
            $('#update_checklist_form_loader').addClass('loader');
            $('#update_checklist_item_btn').prop('disabled', true);
            e.preventDefault();
            $.ajax({
                url: "<?php echo admin_url('leads/update_checklist_item_by_id/' . $lead->id); ?>",
                type: 'POST',
                data: $(this).serialize(),
                dataType: 'json',
                success: function (response) {
                    // Assuming the server responds with JSON
                    if (response.success) {
                        $('#update_checklist_form')[0].reset();
                        $('#update_checklist_form_loader').removeClass('loader');
                        $('#update_checklist_item_btn').prop('disabled', false);
                        var anchor = document.querySelector('.close');
                        anchor.click();
                        var anchor = document.querySelector('#checklist_update_modal_close_btn');
                        anchor.click();
                        $('#checklist_update_modal_close_btn').trigger('click');
                       
                        // Select the checklist row using the ID format
                        var id = response.client_checklist_id;
                        var row = $('#delete_checklist' + id);
                        var itemName = response.client_checklist_name;
                        var description = response.update_item_notes;

                        if (row.length > 0) {
                            update_item_records(row, itemName, description, '', id);
                            alert_float('success', 'Item details updated successfully.');
                        }
                        // setTimeout(function () {
                        //     destroyTinyMCE();
                        //     _lead_init_data(response, response.id);
                        //     alert_float('success', 'Item details updated successfully.');
                        //     if (sameGroup != 2) {
                        //         $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                        //     }
                        //     $('a[href="' + response.leads_status + '"]').tab('show');
                        // }, 500);
                        // $('#checklist_form')[0].reset();

                    } else {
                        alert_float('danger', 'Item details not updated,Please refresh page and update again!');
                        // Display validation errors
                        if (response.errors) {
                        } else {
                        }
                    }
                }
            });
        });
        // get the record of ld checklist items
        $(document).off('click', '#edit_ld_checklist_item').on('click', '#edit_ld_checklist_item', function () {
            // Run the AJAX request
            var checklistId = $(this).data('id');
            var checklist_type = $(this).data('type');
            $.ajax({
                url: "<?php echo admin_url('leads/get_ld_checklist_details_by_id/' . $lead->id); ?>",
                method: "GET",
                data: {
                    checklistId: checklistId,
                },
                success: function (response) {
                    if (response.success) {
                        if (response.leads_status == 4) {
                            $('#ld_notes_textarea_toggle').hide();
                        } else {
                            $('#ld_notes_textarea_toggle').show();
                        }
                        // change the title when modal update open
                        if(checklist_type == 'payout'){
                            $('#ld_outstanding_title_update_modal').text('Type of Security/Lender Name');
                            $('#update_ld_payouts_data').show();
                        }else{
                            $('#ld_outstanding_title_update_modal').text('Item Title & Description');
                            $('#update_ld_payouts_data').hide();
                        }
                        $('#update_ld_item_name').val(response.name);
                        // $('#update_ld_req_comments').val(response.req_comments);
                        var htmlContent = response.notes;
                        var plainTextContent = $('<div>').html(htmlContent).text();
                        $('#update_item_ld_notes').val(plainTextContent);
                        $('#ld_checklist_update_modal').modal('show');
                        setTimeout(function () {
                            $('#ld_checklist_update_modal').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                        }, 200);
                        remove_input_of_checklist_id('#ld_update_checklist_form', 'ld_checklist_id', '');
                        appened_input_of_checklist_id('#ld_update_checklist_form', 'ld_checklist_id', checklistId);
                        // Clear existing file elements of lenders and payouts
                        $('#edit_details_for_lender_expire_dates').empty();
                        // creating a fields for lender and expire dates
                        if (response.files_data) {
                            // Append new file data fields
                            response.files_data.forEach(function (file, index) {
                                if (response.leads_status == 7 || response.leads_status == 4) {
                                    var filetypeParts = file.filetype ? file.filetype.split('/') : [];
                                    var view_url = file.file_url ? file.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com") : '';
                                    var imgSrc;
                                    var payoutExpireDate = '';
                                    if (filetypeParts.length > 1) {
                                        var extension = filetypeParts[1];
                                        if (extension === 'jpeg' || extension === 'jpg' || extension === 'png' || extension === 'avif') {
                                            imgSrc = '<?php echo base_url("assets/images/allimage.webp"); ?>';
                                        } else if (extension === 'msword' || extension === 'vnd.openxmlformats-officedocument') {
                                            imgSrc = '<?php echo base_url("assets/images/msword_new.webp"); ?>';
                                        } else if (extension === 'pdf') {
                                            imgSrc = '<?php echo base_url("assets/images/pdf.webp"); ?>';
                                        } else {
                                            imgSrc = '<?php echo base_url("assets/images/general.webp"); ?>';
                                        }
                                    } else {
                                        imgSrc = '<?php echo base_url("assets/images/general.webp"); ?>';
                                    }
                                    var date = new Date(file.payout_expire_date);
                                    var payoutExpireTime = '';
                                    if (!isNaN(date.getTime())) {
                                        payoutExpireTime = date.toISOString().split('T')[0];
                                    }
                                    // Populate lender dropdown
                                    var lenderOptions = response.lender_data.map(function (lender) {
                                        var selected = lender.bank_name === file.lender_name ? 'selected' : '';
                                        return `<option value="${lender.bank_name}" ${selected}>${lender.bank_name}</option>`;
                                    }).join('');
                                    var fileElement = `
                                                <div class="col-md-12" style="margin-bottom: 10px;border-bottom:1px solid;">
                                                    <div style="display: flex; align-items: center;justify-content:space-between;margin-bottom:10px;">
                                                        <div style="display:flex;flex-direction:column;">
                                                            <div style="display: flex; justify-content: center; margin-top: 10px;">
                                                                <a href="${view_url}" target="_blank"><i class="fa fa-eye"></i></a>
                                                                <a href="${file.file_url}" target="_blank" style="margin-left: 5px;"><i class="fa fa-download"></i></a>
                                                            </div>
                                                            <a href="${view_url}" target="_blank">
                                                                <img loading="lazy" src="${imgSrc}" style="width: 50px; height: 50px; margin-right: 10px;">
                                                            </a>
                                                        </div>
                                                        <div style="display:none;">
                                                            <label for="lender_name_${file.id}">Lender Name:</label>
                                                            <select id="lender_name_${file.id}" name="lender_name_${file.id}" class="form-control" style="width:160px;">
                                                                ${lenderOptions}
                                                            </select>
                                                        </div>
                                                        <div>
                                                            <input type="hidden" id="file_ids" name="file_ids[]" value="${file.id}">
                                                            <label for="payout_expire_time_${file.id}">Expires Date:</label>
                                                            <input type="date" id="payout_expire_time_${file.id}" name="payout_expire_time_${file.id}" class="form-control" value="${payoutExpireTime}">
                                                        </div>
                                                    </div>
                                                </div>
                                            `;
                                    $('#edit_details_for_lender_expire_dates').append(fileElement);
                                }
                            });
                        }
                    }
                },
                error: function (xhr, status, error) {
                    console.error('AJAX request error:', status, error);
                }
            });
        });
    </script>
    <!-- Checklist template file open code -->

    <script>
        function destroyTinyMCE() {
            tinymce.remove();
            if (tinymce.editors.length > 0) {
                tinymce.editors.forEach(function (editor) {
                    editor.remove();
                });
            }
        }
        $(document).ready(function () {
            $('#outstanding_item_ld_team_form_show_button').click(function () {
                let $formContainer = $('#outstanding_ld_team_form');
                let $form = $('#add_custom_checkbox');
                if ($formContainer.is(':visible')) {
                    $formContainer.slideUp(700);
                    $form.slideUp(700);
                } else {
                    $formContainer.css('display', 'block').hide().slideDown(700);
                    $form.css('display', 'block').hide().slideDown(700);
                }
                // $('#add_custom_checkbox').slideToggle(700);
            });
            $('#btn_show_form_case_closed_doc_upload').on('click', function () {
                var target = $('#show_form_case_closed_doc_upload');
                if (target.is(':visible')) {
                    target.slideUp(700);
                } else {
                    target.slideDown(700);
                }
            });
        });
        $(document).ready(function () {
            <?php foreach ([$file_opened_checklist_id, $Instruction_checklist_id, $Outstanding_checklist_id, $Request_checklist_id] as $checklist_id): ?>
                // toggleChecklistFormVisibility(<?php echo $checklist_id; ?>);

                // $('#order_no<?php echo $checklist_id; ?>').on('change', function () {
                $('#order_no1').on('change', function () {
                    var data_id_checklist_template = $(this).data('id');
                    toggleChecklistFormVisibility(1, data_id_checklist_template);
                });
                // for broker 
                $('#order_no_broker1').on('change', function () {
                    var data_id_checklist_template = $(this).data('id');
                    broker_file_opened_template_form_append(1, data_id_checklist_template);
                });
                $('#order_no3').on('change', function () {
                    var data_id_checklist_template = $(this).data('id');
                    toggleChecklistFormVisibility(3, data_id_checklist_template);
                });
                $('#order_no_ld_team3').on('change', function () {
                    var data_id_checklist_template_ld_team_outstanding = $(this).data('id');
                    toggle_outstanding_ld_team(3, data_id_checklist_template_ld_team_outstanding);
                });
                $('#order_no4').on('change', function () {
                    var data_id_checklist_template = 4;
                    toggleChecklistFormVisibility(4, data_id_checklist_template);
                });
            <?php endforeach; ?>
            // outstanding item list for ld team toggle code 
            function toggle_outstanding_ld_team(checklist_id, data_id_checklist_template) {
                var selectedValue_order_no_ld_team3 = $('#order_no_ld_team' + checklist_id).val();
                var hideChecklistForm = selectedValue_order_no_ld_team3 === '';
                if (hideChecklistForm) {
                    $('#checklist_template_form_ld_team_outstanding' + checklist_id).fadeOut('slow', function () {
                        $('#add_custom_checkbox').fadeIn('slow');
                    });
                } else {
                    $('#add_custom_checkbox').fadeOut('slow', function () {
                        $('#checklist_template_form_ld_team_outstanding' + checklist_id).fadeIn('slow');
                    });
                }
                // <!-- checklist template for outstanding ld-team list -->
                var current_stage_status = '<?php echo $leads_status_current_id; ?>';
                $.ajax({
                    url: '<?php echo base_url('admin/leads/get_checklist_template_data_for_outstanding_ld_team'); ?>',
                    type: 'POST',
                    data: {
                        order_no: selectedValue_order_no_ld_team3,
                        current_stage_status: data_id_checklist_template,
                    },
                    // previous line of code end
                    success: function (response) {
                        var data = JSON.parse(response);

                        if (data.status === 'success' && data.data !== null && data.data.length > 0) {
                            var checklistTemplates = data.data;
                            var form = $('<form method="get" action="<?php echo base_url('admin/leads/checklist_template_add_in_task_table_for_ld_team_outstanding'); ?>"></form>');
                            var lead_id = $('#lead_id').val();

                            $.each(checklistTemplates, function (index, checklistTemplate) {
                                var checklistId = checklistTemplate.id;

                                // Create input elements for each checklist template
                                var inputHidden1 = $('<input type="hidden" class="form-control" name="id[]" value="' + checklistTemplate.id + '">');
                                var inputHidden2 = $('<input type="hidden" class="form-control" name="lead_id" value="' + lead_id + '">');
                                var inputHidden3 = $('<input type="hidden" class="form-control" name="current_stage_id" value="' + data_id_checklist_template + '">');
                                form.append(inputHidden1);
                                form.append(inputHidden2);
                                form.append(inputHidden3);

                                // Create other form elements based on checklist template data
                                var hr = $('<div class="clearfix"></div><hr class="-tw-mx-4 tw-border-neutral-200" />');
                                var div = $('<div class="form-group col-md-6"></div>');
                                div.append('<label class="control-label">Item Title</label>');
                                div.append('<input type="text" class="form-control" name="title" value="' + checklistTemplate.title + '" disabled>');
                                form.append(div);
                                if (current_stage_status == 1) {
                                    div = $('<div class="form-group col-md-6"></div>');
                                    div.append('<label class="control-label">Doc Type</label>');
                                    div.append('<input type="text" class="form-control" name="doc_type" value="' + checklistTemplate.doc_type + '" disabled>');
                                    form.append(div);
                                }
                                div = $('<div class="form-group col-md-6"></div>');
                                div.append('<label class="control-label">Item Description</label>');
                                div.append('<input type="text" class="form-control" name="description" value="' + checklistTemplate.description + '" disabled>');
                                form.append(div);
                                if (current_stage_status == 1) {
                                    div = $('<div class="form-group col-md-6"></div>');
                                    div.append('<label class="control-label">Item Instructions</label>');
                                    // You may need to handle line breaks in instructions here
                                    div.append('<input type="text" class="form-control" name="instruction" value="' + checklistTemplate.instruction + '" disabled>');
                                    form.append(div);
                                }
                                form.append(hr);
                            });

                            var sameGroup = <?php echo $samegroup ? 'true' : 'false'; ?>;
                            if (sameGroup) {
                                var submitButton = $('<div class="col-md-12"><button type="submit" class="btn btn-primary" style="float:right;margin:8px;" id="submitFormButton">Save</button></div>');
                                if (current_stage_status >= checklist_id) {
                                    form.append(submitButton);
                                }
                            }
                            // Append the form to the desired element
                            $('#checklist_template_form_ld_team_outstanding' + checklist_id).empty().append(form);

                        } else {
                        }
                    },
                    error: function (error) {
                    }
                });
            }
            // broker template data show
            function broker_file_opened_template_form_append(checklist_id, data_id_checklist_template) {
                var selectedValue_order_no_broker1 = $('#order_no_broker' + checklist_id).val();
                var hideChecklistForm = selectedValue_order_no_broker1 === '';
                if (hideChecklistForm) {

                    $('#checklist_template_form_broker' + checklist_id).fadeOut('slow', function () {
                        $('#hide_checklsit_form_broker' + checklist_id).fadeIn('slow');
                    });
                } else {
                    $('#hide_checklsit_form_broker' + checklist_id).fadeOut('slow', function () {
                        $('#checklist_template_form_broker' + checklist_id).fadeIn('slow');
                    });
                }
                var current_stage_status = '<?php echo $leads_status_current_id; ?>';
                $.ajax({
                    url: '<?php echo base_url('admin/leads/get_checklist_template_data_file_opened_for_broker'); ?>',
                    type: 'POST',
                    data: {

                        order_no: selectedValue_order_no_broker1,
                        current_stage_status: data_id_checklist_template,
                    },
                    success: function (response) {
                        var data = JSON.parse(response);

                        if (data.status === 'success' && data.data !== null && data.data.length > 0) {
                            var checklistTemplates = data.data;
                            var form = $('<form method="get" action="<?php echo base_url('admin/leads/checklist_template_add_in_task_table'); ?>"></form>');
                            var lead_id = $('#lead_id').val();

                            $.each(checklistTemplates, function (index, checklistTemplate) {
                                var checklistId = checklistTemplate.id;

                                // Create input elements for each checklist template
                                var inputHidden1 = $('<input type="hidden" class="form-control" name="id[]" value="' + checklistTemplate.id + '">');
                                var inputHidden2 = $('<input type="hidden" class="form-control" name="lead_id" value="' + lead_id + '">');
                                var inputHidden3 = $('<input type="hidden" class="form-control" name="current_stage_id" value="' + data_id_checklist_template + '">');
                                form.append(inputHidden1);
                                form.append(inputHidden2);
                                form.append(inputHidden3);

                                // Create other form elements based on checklist template data
                                var hr = $('<div class="clearfix"></div><hr class="-tw-mx-4 tw-border-neutral-200" />');
                                var div = $('<div class="form-group col-md-6"></div>');
                                div.append('<label class="control-label">Item Title</label>');
                                div.append('<input type="text" class="form-control" name="title" value="' + checklistTemplate.title + '" disabled>');
                                form.append(div);
                                if (current_stage_status == 1) {
                                    div = $('<div class="form-group col-md-6"></div>');
                                    div.append('<label class="control-label">Doc Type</label>');
                                    div.append('<input type="text" class="form-control" name="doc_type" value="' + checklistTemplate.doc_type + '" disabled>');
                                    form.append(div);
                                }
                                div = $('<div class="form-group col-md-6"></div>');
                                div.append('<label class="control-label">Item Description</label>');
                                div.append('<input type="text" class="form-control" name="description" value="' + checklistTemplate.description + '" disabled>');
                                form.append(div);
                                if (current_stage_status == 1) {
                                    div = $('<div class="form-group col-md-6"></div>');
                                    div.append('<label class="control-label">Item Instructions</label>');
                                    // You may need to handle line breaks in instructions here
                                    div.append('<input type="text" class="form-control" name="instruction" value="' + checklistTemplate.instruction + '" disabled>');
                                    form.append(div);
                                }
                                form.append(hr);
                            });

                            var sameGroup = <?php echo $samegroup ? 'true' : 'false'; ?>;
                            if (sameGroup) {
                                var submitButton = $('<div class="col-md-12"><button type="submit" class="btn btn-primary" style="float:right;margin:8px;" id="submitFormButton">Save</button></div>');
                                if (current_stage_status >= checklist_id) {
                                    form.append(submitButton);
                                }
                            }
                            $('#checklist_template_form_broker' + checklist_id).empty().append(form);

                        } else {
                        }
                    },
                    error: function (error) {
                    }
                });
            }
            function toggleChecklistFormVisibility(checklist_id, data_id_checklist_template) {
                $('#file_opened_form_show').slideToggle();
                var selectedValue = $('#order_no' + checklist_id).val();
                var hideChecklistForm = selectedValue === '';
                if (hideChecklistForm) {
                    $('#checklist_template_form' + checklist_id).fadeOut('slow', function () {
                        $('#hide_checklsit_form' + checklist_id).fadeIn('slow');
                    });
                } else {

                    $('#hide_checklsit_form' + checklist_id).fadeOut('slow', function () {
                        $('#checklist_template_form' + checklist_id).fadeIn('slow');
                    });
                }
                if (!hideChecklistForm) {
                    var current_stage_status = '<?php echo $leads_status_current_id; ?>';
                    $.ajax({
                        url: '<?php echo base_url('admin/leads/get_checklist_template_data'); ?>',
                        type: 'POST',
                        data: {
                            // order_no: selectedValue,
                            order_no: selectedValue,
                            current_stage_status: data_id_checklist_template,
                        },
                        // previous line of code end
                        success: function (response) {
                            var data = JSON.parse(response);
                            if (data.status === 'success' && data.data !== null && data.data.length > 0) {
                                var checklistTemplates = data.data;
                                var form = $('<form method="get" action="<?php echo base_url('admin/leads/checklist_template_add_in_task_table'); ?>"></form>');
                                var lead_id = $('#lead_id').val();

                                $.each(checklistTemplates, function (index, checklistTemplate) {
                                    var checklistId = checklistTemplate.id;

                                    // Create input elements for each checklist template
                                    var inputHidden1 = $('<input type="hidden" class="form-control" name="id[]" value="' + checklistTemplate.id + '">');
                                    var inputHidden2 = $('<input type="hidden" class="form-control" name="lead_id" value="' + lead_id + '">');
                                    var inputHidden3 = $('<input type="hidden" class="form-control" name="current_stage_id" value="' + data_id_checklist_template + '">');
                                    form.append(inputHidden1);
                                    form.append(inputHidden2);
                                    form.append(inputHidden3);

                                    // Create other form elements based on checklist template data
                                    var hr = $('<div class="clearfix"></div><hr class="-tw-mx-4 tw-border-neutral-200" />');
                                    var div = $('<div class="form-group col-md-6"></div>');
                                    div.append('<label class="control-label">Item Title</label>');
                                    div.append('<input type="text" class="form-control" name="title" value="' + checklistTemplate.title + '" disabled>');
                                    form.append(div);
                                    if (current_stage_status == 1) {
                                        div = $('<div class="form-group col-md-6"></div>');
                                        div.append('<label class="control-label">Doc Type</label>');
                                        div.append('<input type="text" class="form-control" name="doc_type" value="' + checklistTemplate.doc_type + '" disabled>');
                                        form.append(div);
                                    }
                                    div = $('<div class="form-group col-md-6"></div>');
                                    div.append('<label class="control-label">Item Description</label>');
                                    div.append('<input type="text" class="form-control" name="description" value="' + checklistTemplate.description + '" disabled>');
                                    form.append(div);
                                    if (current_stage_status == 1) {
                                        div = $('<div class="form-group col-md-6"></div>');
                                        div.append('<label class="control-label">Item Instructions</label>');
                                        // You may need to handle line breaks in instructions here
                                        div.append('<input type="text" class="form-control" name="instruction" value="' + checklistTemplate.instruction + '" disabled>');
                                        form.append(div);
                                    }
                                    form.append(hr);
                                });

                                var sameGroup = <?php echo $samegroup ? 'true' : 'false'; ?>;
                                if (sameGroup) {
                                    var submitButton = $('<div class="col-md-12"><button type="submit" class="btn btn-primary" style="float:right;margin:8px;" id="submitFormButton">Save</button></div>');
                                    if (current_stage_status >= checklist_id) {
                                        form.append(submitButton);
                                    }
                                }
                                // Append the form to the desired element
                                $('#checklist_template_form' + checklist_id).empty().append(form);

                            } else {
                            }
                        },
                        error: function (error) {
                        }
                    });
                }
            }
        });
    </script>
    <!-- // Code for complate stage -->
    <?php foreach ([$file_opened_checklist_id, $Instruction_checklist_id, $appointment_request, $Outstanding_checklist_id, $Request_checklist_id, $id_verification_checklist_id, $closed_checklist_id, $on_hold_checklist_id] as $checklist_id): ?>
        <script>
            $(document).ready(function () {
                function destroyTinyMCE() {
                    tinymce.remove();
                    if (tinymce.editors.length > 0) {
                        tinymce.editors.forEach(function (editor) {
                            editor.remove();
                        });
                    }
                }
                var checklistId = '<?php echo $checklist_id; ?>';
                var status;
                switch (checklistId) {
                    case '1':
                        status = 'File Opened';
                        break;
                    case '2':
                        status = 'Instructions Stage';
                        break;
                    case '3':
                        status = 'Outstanding Items';
                        break;
                    case '4':
                        status = 'Request for Funds';
                        break;
                    case '5':
                        status = 'Closing';
                        break;
                    case '6':
                        status = 'On Hold';
                        break;
                    case '7':
                        status = 'Appointment Stage';
                        break;
                    case '8':
                        status = 'ID Verification';
                        break;
                    default:
                }
                // checklist complete stage notify 
                function checklist_complete_stage_notify(lead_id,stage_name,stage_id,request_for_funds_stage,closed_stage){
                    $.ajax({
                        url: '<?php echo base_url('admin/leads/checklist_complete_stage_notify'); ?>',
                        type: 'POST',
                        data: {
                            'lead_id': lead_id,
                            'stage_name': stage_name,
                            'stage_id': stage_id,
                            'request_for_funds_stage': request_for_funds_stage,
                            'closed_stage': closed_stage,
                        },
                        success: function (response) {
                            if(response.success){
                                alert_float('success', 'Stage completed mails and Sms send successfully.');
                            }else{
                                alert_float('danger', 'Stage completed mails and Sms not send because of some issue.');
                            }
                        },
                        error: function (error) {
                            console.error('Checklist complete stage notify function caused an issue.');
                            console.error('Status:', status);
                            console.error('Error:', error);
                            console.error('Response:', xhr.responseText);
                        }
                    });
                }
                // seperate notification when
                // ID is in 
                // idv is not in
                // instruction is in 
                function id_in_and_idv_not_in_and_ins_in(lead_id, stage_id){
                    $.ajax({
                        url: '<?php echo base_url('admin/leads/id_in_and_idv_not_in_and_ins_in'); ?>',
                        type: 'POST',
                        data: {
                            'lead_id': lead_id,
                            'stage_id': stage_id,
                        },
                        success: function (response) {
                            alert_float('success', 'Stage completed mails and Sms send successfully.');
                        },
                        error: function (error) {
                        }
                    });
                }
                // checklist complete steage
                $('#complete_stage<?php echo $checklist_id; ?>').off('click').on('click', function () {

                    var lead_id = $('#lead_id').val();
                    var checklistId = '<?php echo $checklist_id; ?>';
                    var sameGroup = '<?php echo $samegroup; ?>';
                    // Display confirmation dialog
                    if (false) {
                        // if (checklistId == 4) {

                    } else {
                        // if (confirm("Are you sure you want to complete the (" + status + ") stage?")) {
                            $('.full-page-loader').show();
                            setTimeout(function () {
                                $('#full_page_loader').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                            }, 200);
                            // User clicked OK, perform AJAX request
                            $.ajax({
                                url: '<?php echo base_url('admin/leads/checklist_complete_stage'); ?>',
                                type: 'POST',
                                data: {
                                    stage_id: '<?php echo $checklist_id; ?>',
                                    lead_id: lead_id,
                                },
                                dataType: 'json',
                                success: function (response) {
                                    if(response.success){
                                        $('.full-page-loader').show();
                                        destroyTinyMCE();
                                        leads_kanban();
                                        // outbox emails records recall
                                        _lead_init_data(response, response.id);
                                        $('a[href="' + response.leads_status + '"]').tab('show');
                                        if (sameGroup != 2) {
                                            $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                        }
                                        if (response.complete_stage_button == 7) {
                                            var anchor = document.querySelector('a[href="#lead_reminders"]');
                                            if (response.leads_status === "#lead_reminders") {
                                                anchor.click();
                                            }
                                        } else if (response.leads_status === "#request_for_funds") {
                                            var anchor = document.querySelector('a[href="#ledger"]');
                                            anchor.click();
                                        }
                                        alert_float('success', 'Your case status updated successfully.');
                                        setTimeout(function () {
                                            fetchOutboxRecords(response.id);
                                        }, 300);
                                        // When ID is in,
                                        // IDV not in,
                                        // Instructions is in
                                        $('#idv_not_pass_msg').hide();
                                        $('#secure_payout_msg').hide();
                                        if((response.get_idv_pass_count > 0 || response.get_idv_pass_NA_count > 0) && response.get_instruction_count > 0 && response.stage_id == 7){
                                            id_in_and_idv_not_in_and_ins_in(response.id, response.stage_id);
                                        }else{
                                            checklist_complete_stage_notify(response.id, response.stage_name, response.stage_id, response.request_for_funds_stage, response.closed_stage);
                                        }
                                        // if outstanding stage complete then show the reminder
                                        if (response.leads_status === 3 || response.leads_status === '#ledger') {
                                            if(response.file_doc_key == 0){
                                                $("#oustanding_complete_stg_msg_in_ledger").show();
                                                $(".oustanding_complete_stg_msg").show();
                                            }else if(response.broker_fee_na_key == 'has_broker_fee_na'){
                                                $("#oustanding_complete_stg_msg_in_ledger").hide();
                                                $(".oustanding_complete_stg_msg").hide();
                                            }
                                        }
                                    }else{
                                        $('.full-page-loader').hide();
                                        if(response.payout_expire_date === false || response.payout_expire_date === 'false'){
                                            $('#secure_payout_msg').show();
                                        }
                                        if (response.idv_not_pass === false || response.idv_not_pass === 'false') {
                                            $('#idv_not_pass_msg').show();
                                        }   
                                        if (response.leads_status == 3 || response.leads_status == '3') {
                                            $(".oustanding_complete_stg_msg").show();
                                        }
                                    }
                                },
                                error: function (error) {
                                    $('.full-page-loader').hide();
                                    $('#idv_not_pass_msg').show();
                                    alert_float('danger', 'Issue in checklist Complete stage.');
                                }
                            });
                        // }
                    }
                });
                // closed stage complete process
                $(document).off('click', '.closed_complete_stage').on('click', '.closed_complete_stage', function () {
                    var lead_id = $('#lead_id').val();
                    // var stateId = $(this).attr('data-id');
                    // var statetitle = $(this).attr('data-title');

                    // var regex = /Send\s*Report\s*To\s*Client|Send\s*report\s*to\s*client|Send\s*Report\s*to\s*client|Send\s*Report\s*to\s*Client|Send\s*Final\s*Report\s*to\s*Client,\s*cc\s*broker/i;

                    // if (regex.test(statetitle.trim())) {
                    //     $('#send_report_content_toggle').show();
                    //     $('#closed_mail_review').show();
                    //     $('#send_report_cc_bcc').show();

                    //     upload_doc_for_request_for_funds(stateId, 'send-report');
                    // }
                    $('.full-page-loader').show();
                    setTimeout(function () {
                        $('#full_page_loader').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                    }, 200);

                    $.ajax({
                        url: '<?php echo base_url('admin/leads/closed_stage_complete'); ?>',
                        type: 'POST',
                        dataType: 'json',
                        data: { lead_id: lead_id },
                        success: function (response) {
                            if (response.success) {
                                $('#close_stage_msg').show();
                                $('.full-page-loader').hide();
                                destroyTinyMCE();
                                leads_kanban();
                                _lead_init_data(response, response.id);
                                alert_float('success', response.message);
                            } else {
                                $('.full-page-loader').hide();
                                alert_float('danger', response.message);
                            }
                        },
                        error: function () {
                            $('.full-page-loader').hide();
                            alert_float('danger','An error occurred while completing the closed stage.');
                        }
                    });

                });
            });
        </script>
    <?php endforeach; ?>
    <!-- // Code for undo stage -->
    <?php foreach ([$file_opened_checklist_id, $id_verification_checklist_id, $Instruction_checklist_id, $appointment_request, $Outstanding_checklist_id, $Request_checklist_id, $closed_checklist_id, $on_hold_checklist_id] as $checklist_id): ?>
        <script>
            $(document).ready(function () {
                function destroyTinyMCE() {
                    tinymce.remove();
                    if (tinymce.editors.length > 0) {
                        tinymce.editors.forEach(function (editor) {
                            editor.remove();
                        });
                    }
                }
                $('#undo_stage<?php echo $checklist_id; ?>').on('click', function () {
                    var lead_id = $('#lead_id').val();
                    var sameGroup = '<?php echo $samegroup; ?>';
                    // Display confirmation dialog
                    // if (confirm("Are you sure you want to undo this stage?")) {
                        // User clicked OK, perform AJAX request
                        $('.full-page-loader').show();
                        $.ajax({
                            url: '<?php echo base_url('admin/leads/checklist_undo_stage'); ?>',
                            type: 'POST',
                            data: {
                                stage_id: '<?php echo $checklist_id; ?>',
                                lead_id: lead_id,
                            },
                            success: function (response) {
                                $('.full-page-loader').hide();
                                destroyTinyMCE();
                                leads_kanban();
                                var anchor = document.querySelector('a[href="#lead_reminders"]');
                                _lead_init_data(response, response.id);
                                $('a[href="' + response.leads_status + '"]').tab('show');
                                if (sameGroup != 2) {
                                    $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                }
                                if (response.leads_status === "#lead_reminders") {
                                    anchor.click();
                                }
                                alert_float('success', 'Your case status updated successfully.');
                            },
                            error: function (error) {
                                $('.full-page-loader').hide();
                            }
                        });
                    // }
                });
            });
        </script>
    <?php endforeach; ?>
    <!-- Scroll button of comments  -->
    <script>
        function destroyTinyMCE() {
            tinymce.remove();
            if (tinymce.editors.length > 0) {
                tinymce.editors.forEach(function (editor) {
                    editor.remove();
                });
            }
        }
        function scroll_down() {
            var commentsContainer = $('.comments-container');
            commentsContainer.animate({ scrollTop: commentsContainer[0].scrollHeight }, 'slow', function () {
                $('#down_comments_container').fadeOut('slow');
            });
        }
        function ld_scroll_down() {
            var commentsContainer = $('.ld-comments-container');
            commentsContainer.animate({ scrollTop: commentsContainer[0].scrollHeight }, 'slow', function () {
                $('#ld_down_comments_container').fadeOut('slow');
            });
        }
        function admin_ld_scroll_down() {
            var commentsContainer = $('.admin_ld_comments_container');
            commentsContainer.animate({ scrollTop: commentsContainer[0].scrollHeight }, 'slow', function () {
                $('#admin_ld_down_comments_container').fadeOut('slow');
            });
        }
    </script>
    <!-- ID verification tab script -->
    <script>
        function destroyTinyMCE() {
            tinymce.remove();
            if (tinymce.editors.length > 0) {
                tinymce.editors.forEach(function (editor) {
                    editor.remove();
                });
            }
        }
        $(document).ready(function () {
            $('#idv_done_by').change(function () {
                var selectedValue = $(this).val();
                if (selectedValue === "") {
                    $('#cc_bcc_inputs_fields').hide();
                } else {
                    $('#cc_bcc_inputs_fields').show();
                }
                if (selectedValue === 'DOCUSIGN') {
                    $('#idv_done_through_select_docsign').show();
                } else {
                    $('#idv_done_through_select_docsign').hide();
                }
                if (selectedValue === 'FCT') {
                    $('#idv_done_through_select_fct').show();
                } else {
                    $('#idv_done_through_select_fct').hide();
                }
                if (selectedValue === 'Hosper') {
                    $('#idv_done_through_select_hosper').show();
                } else {
                    $('#idv_done_through_select_hosper').hide();
                }
                if (selectedValue === 'Other') {
                    $('#idv_done_through_select_other').show();
                } else {
                    $('#idv_done_through_select_other').hide();
                }
            });
            // get the user email 
            function updateClientName(newName, type) {
                if (!newName || !type) {
                    console.error("Both 'newName' and 'type' are required parameters.");
                    return;
                }
                let targetClass;
                if (type === 'select_user_idv_begin') {
                    targetClass = 'idv_client_name_begin';
                } else if (type === 'select_user_idv_receive') {
                    targetClass = 'idv_client_name_receive';
                } else {
                    console.error("Invalid 'type' parameter.");
                    return;
                }
                tinymce.editors.forEach(function (editor) {
                    var content = editor.getContent(); 
                    var regex = new RegExp(
                        `<span class="${targetClass}">.*?<\/span>`,
                        'g'
                    ); 
                    var updatedContent = content.replace(
                        regex,
                        `<span class="${targetClass}">${newName}</span>`
                    );
                    editor.setContent(updatedContent);
                });
            }
            $('#select_user_idv_begin, #select_user_idv_receive').change(function () {
                var selectedValue = $(this).val();
                var triggeredId = $(this).attr('id'); 
                var lead_id = '<?php echo $lead->id; ?>';
                if (selectedValue) {
                    $.ajax({
                        url: '<?php echo admin_url('leads/get_idv_user_email/'); ?>' + lead_id,
                        type: 'POST',
                        data: { user_id: selectedValue },
                        dataType: 'json',
                        success: function (response) {
                            if (response.success) {
                                if (triggeredId === 'select_user_idv_begin') {
                                    $('#to_idv_done_through').val(response.email);
                                    updateClientName(response.client_name,triggeredId);
                                } else if (triggeredId === 'select_user_idv_receive') {
                                    $('#to_idv_received').val(response.email);
                                    updateClientName(response.client_name,triggeredId);
                                }
                            }
                        },
                        error: function (xhr, status, error) {
                            console.error('AJAX Error:', error);
                            alert_float('danger', 'Something went wrong. Please try again.');
                        }
                    });
                } else {
                    alert_float('danger', 'Please select a valid user.');
                }
            });
            // $('#id_verification_attachment_begin, #id_verification_attachment_received').submit(function (e) {
            $('#id_verification_attachment_begin, #id_verification_attachment_received').off('submit').on('submit',function (e) {
                e.preventDefault();

                // Add loader class to the element
                var submit_action = $(this).attr('id');
                $('#loader_begin').addClass('loader');
                $('#loader_received').addClass('loader');
                $('#id_verification_submit_button_begin').prop('disabled', true);
                $('#id_verification_submit_button_received').prop('disabled', true);
                $('.error-message').text('');
                $('#idv_question_error').text('');

                // Client-side validation
                var isValid = true;
                // atleast one value is select
                var idv_done_by_validation = $('#idv_done_by').val();
                var idv_received_validation = $('#idv_received').val();
                // Check if neither dropdown has a selected value
                if (!idv_done_by_validation && !idv_received_validation) {
                    $('.idv_question_error').text('Please select the any question item.');
                    isValid = false;
                }
                // if(submit_action == 'id_verification_attachment_received'){
                //     var files = $('#id_verification_file')[0].files;
                //     if (files.length === 0) {
                //         var selectedValue = $('#idv_received').val();
                //         if (selectedValue === 'yes') {
                //             $('#id_verification_file_error').text('Please select at least one file.');
                //             isValid = false;
                //         }
                //     } else {
                //         // Validate file types
                //         for (var i = 0; i < files.length; i++) {
                //             var ext = files[i].name.split('.').pop().toLowerCase();
                //             if ($.inArray(ext, ['pdf', 'jpeg', 'jpg', 'png', 'doc', 'docx', 'xls', 'xlsx']) === -1) {
                //                 $('#id_verification_file_error').text('File must be PDF, JPEG, JPG, or PNG.');
                //                 isValid = false;
                //                 break;
                //             }
                //         }
                //     }
                // }
                if (!isValid) {
                    $('#loader_received').removeClass('loader');
                    $('#loader_begin').removeClass('loader');
                    $('#id_verification_submit_button_begin').prop('disabled', false);
                    $('#id_verification_submit_button_received').prop('disabled', false);
                    return false;
                }
                var sameGroup = '<?php echo $samegroup; ?>';
                var formData = new FormData(this);
                // docsign done through by 
                if(submit_action == 'id_verification_attachment_begin'){
                    var tinymceContent_docsign = tinymce.get('idv_done_through_ot_docsign_tincymac').getContent();
                    formData.append('idv_done_through_ot_docsign_tincymac', tinymceContent_docsign);
                    // fct done through by
                    var tinymceContent_fct = tinymce.get('idv_done_through_ot_fct_tincymac').getContent();
                    formData.append('idv_done_through_ot_fct_tincymac', tinymceContent_fct);
                    // add data for hosper
                    var tinymceContent_hosper = tinymce.get('idv_done_through_ot_hosper_tincymac').getContent();
                    formData.append('idv_done_through_ot_hosper_tincymac', tinymceContent_hosper);
                    // add data for other
                    var tinymceContent_other = tinymce.get('idv_done_through_other_tincymac').getContent();
                    formData.append('idv_done_through_other_tincymac', tinymceContent_other);
                }
                // question 2 mail set and check live
                // Idv received no
                if(submit_action == 'id_verification_attachment_received'){
                    var tinymceContent_idv_received_no = tinymce.get('idv_received_no_tinymce').getContent();
                    formData.append('idv_received_no_tinymce', tinymceContent_idv_received_no);
                    // Idv received no and pass yes
                    var tinymceContent_idv_received_yes_pass_yes = tinymce.get('idv_received_yes_pass_yes_tinymce').getContent();
                    formData.append('idv_received_yes_pass_yes_tinymce', tinymceContent_idv_received_yes_pass_yes);
                    // Idv received no and pass yes
                    var tinymceContent_idv_received_yes_pass_no = tinymce.get('idv_received_yes_pass_no_tinymce').getContent();
                    formData.append('idv_received_yes_pass_no_tinymce', tinymceContent_idv_received_yes_pass_no);
                }
                $.ajax({
                    type: 'POST',
                    url: $(this).attr('action'),
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function (response) {
                        destroyTinyMCE();
                        $('#loader_begin').removeClass('loader');
                        $('#loader_received').removeClass('loader');
                        $('#id_verification_submit_button_begin').prop('disabled', false);
                        $('#id_verification_submit_button_received').prop('disabled', false);
                        document.getElementById('id_verification_attachment_begin').reset();
                        document.getElementById('id_verification_attachment_received').reset();
                        fetchOutboxRecords(response.id);
                        _lead_init_data(response, response.id);
                        $('a[href="' + response.leads_status + '"]').tab('show');
                        if (sameGroup != 2) {
                            $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                        }
                        alert_float('success', response.message);
                    },
                    error: function (xhr, status, error) {
                        alert_float('danger', 'ID verification doc are not stored please refresh page.');
                    },
                    complete: function () {
                        // Remove loader class after AJAX request is complete
                        $('#loader_begin').removeClass('loader');
                        $('#loader_received').removeClass('loader');
                        $('#id_verification_submit_button_begin').prop('disabled', false);
                        $('#id_verification_submit_button_received').prop('disabled', false);
                    }
                });
            });
        });
        var lead_id = $('#lead_id').val();
        $.ajax({
            url: '<?php echo admin_url('leads/show_id_verification_data/'); ?>' + lead_id,
            type: 'GET',
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    var idverificationDetailsHtml = '';
                    var previousIDverificationids = null;
                    var instructionDetailsHtml = '';
                    var idverificationDetailsHtml = '<table class="table table-bordered">';
                    idverificationDetailsHtml += '<thead><tr>';
                    idverificationDetailsHtml += '<th>IDV WARNING/IDV EMAIL SENT</th>';
                    idverificationDetailsHtml += '<th>IDV Received</th>';
                    idverificationDetailsHtml += '<th>IDV Pass</th>';
                    idverificationDetailsHtml += '<th>Action By</th>';
                    idverificationDetailsHtml += '<th>Notes</th>';
                    // idverificationDetailsHtml += '<th>DL Check Completed</th>';
                    // idverificationDetailsHtml += '<th>DL Check Completed At</th>';
                    idverificationDetailsHtml += '<th>Date Completed</th>';
                    // idverificationDetailsHtml += '<th>File</th>';
                    idverificationDetailsHtml += '</tr></thead>';
                    idverificationDetailsHtml += '<tbody>';

                    $.each(response.data, function (index, id_verification) {
                        idverificationDetailsHtml += '<tr>';
                        idverificationDetailsHtml += '<td>' + (id_verification.idv_done_by ? id_verification.idv_done_by : '-') + '</td>';
                        idverificationDetailsHtml += '<td>' + (id_verification.idv_received ? id_verification.idv_received : '-') + '</td>';
                        idverificationDetailsHtml += '<td>' + (id_verification.idv_received_pass ? id_verification.idv_received_pass : '-') + '</td>';
                        idverificationDetailsHtml += '<td>' + (id_verification.action_by ? id_verification.action_by : '-') + '</td>';
                        idverificationDetailsHtml += '<td>' + (id_verification.description ? id_verification.description : '-') + '</td>';
                        // idverificationDetailsHtml += '<td>' + (id_verification.dl_check_completed ? id_verification.dl_check_completed : '-') + '</td>';
                        // idverificationDetailsHtml += '<td>' + (id_verification.dl_check_completed_at ? id_verification.dl_check_completed_at : '-') + '</td>';
                        idverificationDetailsHtml += '<td>' + (id_verification.instruction_created_at ? id_verification.instruction_created_at : '-') + '</td>';

                        // idverificationDetailsHtml += '<td>';
                        // var filetypeParts = id_verification.file_type ? id_verification.file_type.split('/') : [];
                        // var view_url = id_verification.file_url ? id_verification.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com") : '';

                        // if (filetypeParts.length > 1) {
                        //     var extension = filetypeParts[1];
                        //     if (extension === 'jpeg' || extension === 'jpg' || extension === 'png' || extension === 'avif') {
                        //         idverificationDetailsHtml += '<a href="' + view_url + '" target="_blank"><img loading="lazy" style="width:50px; height:50px;" src="<?php echo base_url('assets/images/allimage.webp'); ?>"></a>';
                        //     } else if (extension === 'msword' || extension === 'vnd.openxmlformats-officedocument') {
                        //         idverificationDetailsHtml += '<a href="' + view_url + '" target="_blank"><img loading="lazy" style="width:50px; height:50px;" src="<?php echo base_url('assets/images/msword_new.webp'); ?>"></a>';
                        //     } else if (extension === 'pdf') {
                        //         idverificationDetailsHtml += '<a href="' + view_url + '" target="_blank"><img loading="lazy" style="width:50px; height:50px;" src="<?php echo base_url('assets/images/pdf.webp'); ?>"></a>';
                        //     } else {
                        //         idverificationDetailsHtml += '<a href="' + view_url + '" target="_blank"><img loading="lazy" style="width:50px; height:50px;" src="<?php echo base_url('assets/images/general.webp'); ?>"></a>';
                        //     }
                        //     idverificationDetailsHtml += '<div style="display:flex;justify-content:center;">';
                        //     idverificationDetailsHtml += '<a href="' + view_url + '" target="_blank"><i class="fa fa-eye"></i></a>';
                        //     idverificationDetailsHtml += '<a href="' + id_verification.downnload_file_url + '" target="_blank"><i class="fa fa-download" style="margin-left:5px"></i></a>';
                        //     idverificationDetailsHtml += '<a href="#" id="id_verification_image_' + id_verification.instruction_file_id + '" data-id="' + id_verification.instruction_file_id + '"><i class="fa fa-trash" style="color:red;margin-left:5px"></i></a>';
                        //     idverificationDetailsHtml += '</div>';
                        // }
                        // idverificationDetailsHtml += '</td>';

                        idverificationDetailsHtml += '</tr>';
                    });

                    idverificationDetailsHtml += '</tbody></table>';

                    $('#id_verification_details_record').html(idverificationDetailsHtml);

                } 
            },
            error: function (xhr, status, error) {
            }
        });
        // show the idv others borrweors record 
        $.ajax({
            url: '<?php echo admin_url('leads/show_idv_borrower_record/'); ?>' + lead_id,
            method: "GET",
            dataType: "json",
            success: function (response) {
                console.warn(response);
                if (response.success) {
                    var data = response.data;
                    var groupedData = {};

                    // Group data by borrower full name
                    data.forEach(function (item) {
                        var borrowerFullName = item.borrow_firstname + " " + item.borrow_middlename + " " + item.borrow_lastname;
                        if (!groupedData[borrowerFullName]) {
                            groupedData[borrowerFullName] = [];
                        }
                        groupedData[borrowerFullName].push(item);
                    });

                    // Generate HTML for each borrower group
                    var html = '';
                    $.each(groupedData, function (borrowerFullName, idVerifications) {
                        html += '<div class="alert alert-info" style="margin-top:15px;"><span class="no-margin font-medium-xs bold" style="display: flex;justify-content: center;">' + borrowerFullName + ' ID Verification Documents' + '</span></div>';
                        html += '<table class="table table-bordered">';
                        html += '<thead><tr>';
                        html += '<th>IDV WARNING/IDV EMAIL SENT</th>';
                        html += '<th>IDV Received</th>';
                        html += '<th>IDV Pass</th>';
                        html += '<th>Action By</th>';
                        html += '<th>Notes</th>';
                        // html += '<th>DL Check Completed</th>';
                        // html += '<th>DL Check Completed At</th>';
                        html += '<th>Date Completed</th>';
                        // html += '<th>File</th>';
                        html += '</tr></thead>';
                        html += '<tbody>';

                        // Generate rows for each ID verification
                        idVerifications.forEach(function (id_verification) {
                            html += '<tr>';
                            html += '<td>' + (id_verification.idv_done_by ? id_verification.idv_done_by : '-') + '</td>';
                            html += '<td>' + (id_verification.idv_received ? id_verification.idv_received : '-') + '</td>';
                            html += '<td>' + (id_verification.idv_received_pass ? id_verification.idv_received_pass : '-') + '</td>';
                            html += '<td>' + (id_verification.action_by ? id_verification.action_by : '-') + '</td>';
                            html += '<td>' + (id_verification.description ? id_verification.description : '-') + '</td>';
                            // html += '<td>' + (id_verification.dl_check_completed ? id_verification.dl_check_completed : '-') + '</td>';
                            // html += '<td>' + (id_verification.dl_check_completed_at ? id_verification.dl_check_completed_at : '-') + '</td>';
                            html += '<td>' + (id_verification.instruction_created_at ? id_verification.instruction_created_at : '-') + '</td>';

                            // html += '<td>';
                            // var filetypeParts = id_verification.file_type ? id_verification.file_type.split('/') : [];
                            // var view_url = id_verification.file_url ? id_verification.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com") : '';

                            // if (filetypeParts.length > 1) {
                            //     var extension = filetypeParts[1];
                            //     if (extension === 'jpeg' || extension === 'jpg' || extension === 'png' || extension === 'avif') {
                            //         html += '<a href="' + view_url + '" target="_blank"><img loading="lazy" style="width:50px; height:50px;" src="<?php echo base_url('assets/images/allimage.webp'); ?>"></a>';
                            //     } else if (extension === 'msword' || extension === 'vnd.openxmlformats-officedocument') {
                            //         html += '<a href="' + view_url + '" target="_blank"><img loading="lazy" style="width:50px; height:50px;" src="<?php echo base_url('assets/images/msword_new.webp'); ?>"></a>';
                            //     } else if (extension === 'pdf') {
                            //         html += '<a href="' + view_url + '" target="_blank"><img loading="lazy" style="width:50px; height:50px;" src="<?php echo base_url('assets/images/pdf.webp'); ?>"></a>';
                            //     } else {
                            //         html += '<a href="' + view_url + '" target="_blank"><img loading="lazy" style="width:50px; height:50px;" src="<?php echo base_url('assets/images/general.webp'); ?>"></a>';
                            //     }
                            //     html += '<div style="display:flex;justify-content:center;">';
                            //     html += '<a href="' + view_url + '" target="_blank"><i class="fa fa-eye"></i></a>';
                            //     html += '<a href="' + id_verification.downnload_file_url + '" target="_blank"><i class="fa fa-download" style="margin-left:5px"></i></a>';
                            //     html += '<a href="#" id="id_verification_image_' + id_verification.instruction_file_id + '" data-id="' + id_verification.instruction_file_id + '"><i class="fa fa-trash" style="color:red;margin-left:5px"></i></a>';
                            //     html += '</div>';
                            // }
                            // html += '</td>';

                            html += '</tr>';
                        });

                        html += '</tbody></table>';
                    });

                    $('#instructions-container').html(html);
                } else {
                    $('#instructions-container').html('<p>No data found</p>');
                }
            },
            error: function () {
                $('#instructions-container').html('<p>An error occurred while fetching the data</p>');
            }
        });
        // delete id_verification images
        $(document).ready(function () {
            $(document).off('click', 'a[id^="id_verification_image_"]').on('click', 'a[id^="id_verification_image_"]', function (e) {
                e.preventDefault();
                var instructionId = $(this).data('id');
                var $clickedAnchor = $(this);
                var sameGroup = '<?php echo $samegroup; ?>';

                // if (confirm('Are you sure you want to delete this id verification image?')) {
                    $('.full-page-loader').show();
                    setTimeout(function () {
                        $('#full_page_loader').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                    }, 200);
                    $.ajax({
                        url: '<?php echo admin_url('leads/delete_id_verification_image/'); ?>',
                        type: 'POST',
                        data: {
                            id: instructionId,
                            lead_id: lead_id
                        },
                        success: function (response) {
                            // Handle the success response                       
                            $('.full-page-loader').hide();
                            destroyTinyMCE();
                            _lead_init_data(response, response.id);
                            $('a[href="' + response.leads_status + '"]').tab('show');
                            if (sameGroup != 2) {
                                $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                            }
                            alert_float('success', 'ID verification Doc deleted successfully.');
                            $clickedAnchor.parent().fadeOut(400, function () {
                                var $parentElement = $(this);
                                $parentElement.remove();
                            });

                        },
                        error: function (xhr, status, error) {
                        }
                    });
                // }
            });
        });
    </script>
    <!-- instruction tab script -->
    <script>
        $(document).ready(function () {
            function destroyTinyMCE() {
                tinymce.remove();
                if (tinymce.editors.length > 0) {
                    tinymce.editors.forEach(function (editor) {
                        editor.remove();
                    });
                }
            }
            // toggle the email content in instruction received emails
            

            $('#ins_received_initial_email_btn').on('click', function () {
                $('#ins_received_initial_email_content').fadeToggle('slow', function () {
                    if ($(this).is(':visible')) {
                        $('#ins_received_email_content, #preliminary_ins_received_email_content').hide('slow');
                    }
                });
            });
            $('#ins_received_email_btn').on('click', function () {
                $('#ins_received_email_content').fadeToggle('slow', function () {
                    if ($(this).is(':visible')) {
                        $('#ins_received_initial_email_content, #preliminary_ins_received_email_content').hide('slow');
                    }
                });
            });
            $('#preliminary_ins_received_btn').on('click', function () {
                $('#preliminary_ins_received_email_content').fadeToggle('slow', function () {
                    if ($(this).is(':visible')) {
                        $('#ins_received_initial_email_content, #ins_received_email_content').hide('slow');
                    }
                });
            });
            $('#ds_doc_approved').on('click', function () {
                // var confirmed = confirm("Are you sure you want to send the Slack Notification?");
                // if (confirmed) {
                    $('.full-page-loader').show();
                    setTimeout(function () {
                        $('#full_page_loader').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                    }, 200);
                    $('#ds_doc_approved').prop('disabled', true);
                    $.ajax({
                        url: "<?php echo admin_url('leads/ds_doc_approved_notification/' . $lead->id); ?>",
                        type: 'POST',
                        data: {},
                        success: function (response) {
                            $('.full-page-loader').hide();
                            $('#ds_doc_approved').prop('disabled', false);
                            if (response.success == 1 || response.success == true) {
                                alert_float('success', 'Slack notification sent successfully.');
                            } else {
                                alert_float('danger', 'Slack notification was not sent. Please try again.');
                            }
                        },
                        error: function (error) {
                            $('.full-page-loader').hide();
                            $('#ds_doc_approved').prop('disabled', false);
                            alert_float('danger', 'Error: Slack notification was not sent. Please try again.');
                        }
                    });
                // }
            });
            // Ins received initial email send
            $(document).off('submit', '#ins_received_initial_email_to_laywer_fromid').on('submit', '#ins_received_initial_email_to_laywer_fromid', function (event) {
                event.preventDefault();

                var ins_received_initial_email_to_laywer_editorid = tinymce.get('ins_received_initial_email_to_laywer_editorid').getContent();
                var cc_ins_received_initial_laywer_emails = $('#cc_ins_received_initial_laywer_emails').val();
                var bcc_ins_received_initial_laywer_emails = $('#bcc_ins_received_initial_laywer_emails').val();
                var to_ins_received_initial_laywer_emails = $('#to_ins_received_initial_laywer_emails').val();
                // Show confirmation dialog
                // var confirmed = confirm("Are you sure you want to send the email?");
                // if (confirmed) {
                    $('#ins_received_initial_email_loader').addClass('loader');
                    $('#ins_received_initial_email_submitbtn').prop('disabled', true);
                    $.ajax({
                        url: "<?php echo admin_url('leads/ins_received_initial_email_to_laywer/' . $lead->id); ?>",
                        type: 'POST',
                        data: {
                            ins_received_initial_email_to_laywer_editorid: ins_received_initial_email_to_laywer_editorid,
                            to_ins_received_initial_laywer_emails: to_ins_received_initial_laywer_emails,
                            cc_ins_received_initial_laywer_emails: cc_ins_received_initial_laywer_emails,
                            bcc_ins_received_initial_laywer_emails: bcc_ins_received_initial_laywer_emails
                        },
                        success: function (response) {
                            $('#ins_received_initial_email_loader').removeClass('loader');
                            $('#ins_received_initial_email_submitbtn').prop('disabled', false);
                            $('#ins_received_initial_email_content').hide();
                            if (response.success == 1) {
                                alert_float('success', 'Email sent successfully.');
                            } else {
                                alert_float('danger', 'Email was not sent. Please try again.');
                            }
                        },
                        error: function (error) {
                            $('#ins_received_initial_email_loader').removeClass('loader');
                            $('#ins_received_initial_email_submitbtn').prop('disabled', false);
                            alert_float('danger', 'Error: Email was not sent. Please try again.');
                        }
                    });
                // }
            });
            // INS Received laywer email send
            $(document).off('submit', '#ins_received_email_to_laywer_fromid').on('submit', '#ins_received_email_to_laywer_fromid', function (event) {
                event.preventDefault();

                var ins_received_email_to_laywer_editorid = tinymce.get('ins_received_email_to_laywer_editorid').getContent();
                var cc_ins_received_laywer_emails = $('#cc_ins_received_laywer_emails').val();
                var bcc_ins_received_laywer_emails = $('#bcc_ins_received_laywer_emails').val();
                var to_ins_received_laywer_emails = $('#to_ins_received_laywer_emails').val();
                // Show confirmation dialog
                // var confirmed = confirm("Are you sure you want to send the email?");
                // if (confirmed) {
                    $('#ins_received_email_loader').addClass('loader');
                    $('#ins_received_email_submitbtn').prop('disabled', true);
                    $.ajax({
                        url: "<?php echo admin_url('leads/ins_received_email_to_laywer/' . $lead->id); ?>",
                        type: 'POST',
                        data: {
                            ins_received_email_to_laywer_editorid: ins_received_email_to_laywer_editorid,
                            to_ins_received_laywer_emails: to_ins_received_laywer_emails,
                            cc_ins_received_laywer_emails: cc_ins_received_laywer_emails,
                            bcc_ins_received_laywer_emails: bcc_ins_received_laywer_emails
                        },
                        success: function (response) {
                            $('#ins_received_email_loader').removeClass('loader');
                            $('#ins_received_email_submitbtn').prop('disabled', false);
                            $('#ins_received_email_content').hide();
                            if (response.success == 1) {
                                alert_float('success', 'Email sent successfully.');
                                appendActivityLogToTop({
                                    id: '',
                                    activity_log_last_id: response.activity_log_last_id,
                                    staffid: '<?php echo get_staff_user_id();?>',
                                    full_name: '<?php echo get_staff_full_name();?>',
                                    staff_image: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    profile_url: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    date_formatted: '',
                                    description: preliminary_instruction_received_editorid,
                                    description_untranslated: preliminary_instruction_received_editorid,
                                    custom_activity: 0
                                });
                            } else {
                                alert_float('danger', 'Email was not sent. Please try again.');
                            }
                        },
                        error: function (error) {
                            $('#ins_received_email_loader').removeClass('loader');
                            $('#ins_received_email_submitbtn').prop('disabled', false);
                            alert_float('danger', 'Error: Email was not sent. Please try again.');
                        }
                    });
                // }
            });
            // Preliminary instruction received email send
            $(document).off('submit', '#preliminary_instruction_rece_formid').on('submit', '#preliminary_instruction_rece_formid', function (event) {
                event.preventDefault();

                var preliminary_instruction_received_editorid = tinymce.get('preliminary_instruction_received_editorid').getContent();
                var cc_preliminary_instruction_received = $('#cc_preliminary_instruction_received').val();
                var bcc_preliminary_instruction_received = $('#bcc_preliminary_instruction_received').val();
                var to_preliminary_instruction_received = $('#to_preliminary_instruction_received').val();
                // Show confirmation dialog
                // var confirmed = confirm("Are you sure you want to send the email?");
                // if (confirmed) {
                    $('#preliminary_instruction_received_loader').addClass('loader');
                    $('#preliminary_instruction_received_submitbtn').prop('disabled', true);
                    $.ajax({
                        url: "<?php echo admin_url('leads/preliminary_email_to_client/' . $lead->id); ?>",
                        type: 'POST',
                        data: {
                            preliminary_instruction_received_editorid: preliminary_instruction_received_editorid,
                            to_preliminary_instruction_received: to_preliminary_instruction_received,
                            cc_preliminary_instruction_received: cc_preliminary_instruction_received,
                            bcc_preliminary_instruction_received: bcc_preliminary_instruction_received
                        },
                        success: function (response) {
                            $('#preliminary_instruction_received_loader').removeClass('loader');
                            $('#preliminary_instruction_received_submitbtn').prop('disabled', false);
                            $('#preliminary_ins_received_email_content').hide();
                            if (response.success == 1) {
                                alert_float('success', 'Email sent successfully.');
                            } else {
                                alert_float('danger', 'Email was not sent. Please try again.');
                            }
                            appendActivityLogToTop({
                                id: '',
                                activity_log_last_id: response.activity_log_last_id,
                                staffid: '<?php echo get_staff_user_id();?>',
                                full_name: '<?php echo get_staff_full_name();?>',
                                staff_image: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                profile_url: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                date_formatted: '',
                                description: preliminary_instruction_received_editorid,
                                description_untranslated: preliminary_instruction_received_editorid,
                                custom_activity: 0
                            });

                        },
                        error: function (error) {
                            $('#preliminary_instruction_received_loader').removeClass('loader');
                            $('#preliminary_instruction_received_submitbtn').prop('disabled', false);
                            alert_float('danger', 'Error: Email was not sent. Please try again.');
                        }
                    });
                // }
            });
            $(document).off('submit', '.instruction_received_attachment').on('submit', '.instruction_received_attachment', function (e) {
                e.preventDefault();

                var form = $(this);
                var loader = form.find('.instruction_received_loader');
                var submitButton = form.find('.instruction_received_submit_button');
                var bankIdError = form.find('#bank_id_error');
                var bankFileError = form.find('#bank_file_error');

                loader.addClass('loader');
                submitButton.prop('disabled', true);
                $('.error-message').text('');

                // Client-side validation
                var isValid = true;
                if (form.find('#bank_id').val() == '') {
                    bankIdError.text('Please select a Lender.');
                    isValid = false;
                }

                var files = form.find('input[type="file"]')[0].files;
                if (files.length === 0) {
                    bankFileError.text('Please select at least one file.');
                    isValid = false;
                } else {
                    // Validate file types
                    for (var i = 0; i < files.length; i++) {
                        var ext = files[i].name.split('.').pop().toLowerCase();
                        if ($.inArray(ext, ['pdf', 'jpeg', 'jpg', 'png', 'doc', 'docx', 'xls', 'xlsx']) === -1) {
                            bankFileError.text('File must be PDF, JPEG, JPG, or PNG.');
                            isValid = false;
                            break;
                        }
                    }
                }

                if (!isValid) {
                    loader.removeClass('loader');
                    submitButton.prop('disabled', false);
                    return false;
                }

                var formData = new FormData(this);
                // Append lawyer firm ID
                var laywerFirmId = form.find('#laywer_firm_id').val();
                formData.append('laywer_firm_id', laywerFirmId || '');

                $.ajax({
                    type: 'POST',
                    url: form.attr('action'),
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function (response) {
                        loader.removeClass('loader');
                        destroyTinyMCE();
                        form[0].reset();
                        _lead_init_data(response, response.id);
                        $('a[href="' + response.leads_status + '"]').tab('show');
                        if (sameGroup != 2) {
                            $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                        }
                        alert_float('success', response.message);
                    },
                    error: function (xhr, status, error) {
                        alert_float('danger', 'Instruction doc are not stored please try again.');
                    },
                    complete: function () {
                        loader.removeClass('loader');
                        submitButton.prop('disabled', false);
                    }
                });
            });
            $('#laywer_firm_id').change(function () {
                var laywerFirmId = $(this).val();
                var lawyerDropdown = $('#lawyer_id_option');

                lawyerDropdown.empty();
                if (laywerFirmId) {
                    $.ajax({
                        url: '<?php echo admin_url("leads/get_lawyers_by_firm"); ?>',
                        type: 'POST',
                        data: { laywer_firm_id: laywerFirmId },
                        dataType: 'json',
                        success: function (response) {
                            if (response.success && response.data.length > 0) {
                                // Append each lawyer to the dropdown
                                response.data.forEach(function (lawyer) {
                                    lawyerDropdown.append(
                                        `<option value="${lawyer.id}">${lawyer.name}</option>`
                                    );
                                });
                            } else {
                                lawyerDropdown.append('<option disabled>No lawyers found</option>');
                            }

                            // Refresh the selectpicker to apply Bootstrap styling
                            lawyerDropdown.selectpicker('refresh');
                        },
                        error: function (xhr, status, error) {
                            console.error('Error fetching lawyers:', xhr.responseText);
                            alert_float('danger', 'Something went wrong. Please try again.');
                        }
                    });
                } else {
                    lawyerDropdown.append('<option disabled>Please select a firm first</option>');
                    lawyerDropdown.selectpicker('refresh');
                }
            });

        });
        $(document).ready(function () {
            $('#bank_id').change(function () {
                var selectedValue = $(this).val();
                var $form = $('#instruction_received_attachment');
                var $inputField = $form.find('#custom_bank_name');
                var $label = $form.find('#custom_input_label');
                if (selectedValue == '1000' && $inputField.length === 0) {
                    var inputHtml = '<div class="form-group"><label style="margin-top:5px;" for="custom_bank_name" id="custom_input_label">Lender’s name</label>' +
                        '<input type="text" class="form-control" id="custom_bank_name" name="custom_bank_name" placeholder="Please enter Lender’s name"></div>';
                    $(inputHtml).insertAfter('#bank_id_error');
                }
                else if (selectedValue != '1000' && $inputField.length > 0) {
                    $inputField.parent().remove();
                }
                // Perform AJAX call to fetch lender address
                $.ajax({
                    url: "<?php echo admin_url('leads/get_lender_address/'); ?>" + selectedValue,
                    type: "GET",
                    dataType: "json",
                    success: function (response) {
                        if (response.success && response.address) {
                            $('#lender_address').empty();
                            var lender_address = '<p class="alert alert-info"><b style="font-weight:800;">Address:</b> ' + response.address + '</p>';
                            $('#lender_address').append(lender_address);
                        } else {
                            $('#lender_address').empty();
                            var lender_address = '<p class="alert alert-info">No address found.</p>';
                            $('#lender_address').append(lender_address);
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error("Error fetching lender address:", error);
                    }
                });
            });
        });
        var lead_id = $('#lead_id').val();
        $.ajax({
            url: '<?php echo admin_url('leads/show_instruction_data/'); ?>' + lead_id,
            type: 'GET',
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    let instructionDetailsHtml = `
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Lender’s Name</th>
                                        <th>Lawyer Firm Name</th>
                                        <th>Lawyer Names</th>
                                        <th>Comments</th>
                                        <th>Created At</th>
                                        <th>Documents</th>
                                    </tr>
                                </thead>
                                <tbody>`;

                    $.each(response.data, function (index, instruction) {
                        let lawyerFirmName = instruction.laywer_firm_name ? instruction.laywer_firm_name : '-';
                        let lawyerNames = instruction.laywer_names ? instruction.laywer_names : '-';

                        let filetypeParts = instruction.file_type.split('/');
                        let view_url = instruction.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com");
                        let extension = filetypeParts[1];
                        let imgSrc = '';

                        if (['jpeg', 'jpg', 'png', 'avif'].includes(extension)) {
                            imgSrc = '<?php echo base_url("assets/images/allimage.webp"); ?>';
                        } else if (['msword', 'vnd.openxmlformats-officedocument'].includes(extension)) {
                            imgSrc = '<?php echo base_url("assets/images/msword_new.webp"); ?>';
                        } else if (extension === 'pdf') {
                            imgSrc = '<?php echo base_url("assets/images/pdf.webp"); ?>';
                        } else {
                            imgSrc = '<?php echo base_url("assets/images/general.webp"); ?>';
                        }

                        let instructionIcon = `
                                <div style="text-align: center; margin-bottom: 5px;">
                                    <a href="${view_url}" target="_blank"><i class="fa fa-eye"></i></a>
                                    <a href="${instruction.downnload_file_url}" target="_blank" style="margin-left:5px;"><i class="fa fa-download"></i></a>
                                    <a href="#" id="instruction_image_${instruction.instruction_file_id}" data-id="${instruction.instruction_file_id}" style="color:red;margin-left:5px;"><i class="fa fa-trash"></i></a>
                                </div>
                                <a href="${view_url}" target="_blank"><img loading="lazy" style="width:50px; height:50px;" src="${imgSrc}"></a>`;

                        instructionDetailsHtml += `
                                <tr>
                                    <td>${instruction.bank_name}</td>
                                    <td>${lawyerFirmName}</td>
                                    <td>${lawyerNames}</td>
                                    <td>${instruction.description}</td>
                                    <td>${instruction.created_at}</td>
                                    <td style="text-align: center;">${instructionIcon}</td>
                                </tr>`;
                    });

                    instructionDetailsHtml += '</tbody></table>';

                    $('#instructionDetailsContainer').html(instructionDetailsHtml);
                }
            },
            error: function (xhr, status, error) {
                console.error('Error fetching data:', error);
            }
        });
        // delete instruction images
        $(document).ready(function () {
            $(document).off('click', 'a[id^="instruction_image_"]').on('click', 'a[id^="instruction_image_"]', function (e) {
                e.preventDefault();
                var instructionId = $(this).data('id');
                var $clickedAnchor = $(this);
                var sameGroup = '<?php echo $samegroup; ?>';
                // if (confirm('Are you sure you want to delete this instruction image?')) {
                    $('.full-page-loader').show();
                    setTimeout(function () {
                        $('#full_page_loader').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                    }, 200);
                    $.ajax({
                        url: '<?php echo admin_url('leads/delete_instruction_image/'); ?>',
                        type: 'POST',
                        data: {
                            id: instructionId,
                            lead_id: lead_id
                        },
                        success: function (response) {
                            // Handle the success response
                            $('.full-page-loader').hide();
                            destroyTinyMCE();
                            _lead_init_data(response, response.id);
                            $('a[href="' + response.leads_status + '"]').tab('show');
                            if (sameGroup != 2) {
                                $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                            }
                            alert_float('success', 'Instruction image deleted successfully.');
                            $clickedAnchor.parent().fadeOut(400, function () {
                                var $parentElement = $(this);
                                $parentElement.remove();
                            });

                        },
                        error: function (xhr, status, error) {
                        }
                    });
                // }
            });
        });
    </script>
   
    <!-- Summery tab script work -->
    <script>
        function destroyTinyMCE() {
            tinymce.remove();
            if (tinymce.editors.length > 0) {
                tinymce.editors.forEach(function (editor) {
                    editor.remove();
                });
            }
        }
        // file opened summery work
        $(document).ready(function () {
            // get all task of the case for client
            $.ajax({
                url: '<?php echo admin_url('leads/get_summery_task_for_file_opened/' . $lead->id); ?>',
                type: 'GET',
                success: function (response) {
                    //  file_opened_summery_checklist_item
                    $.each(response, function (index, item) {
                        var item_status;
                        switch (item.status) {
                            case '1':
                                item_status = 'Pending Review';
                                break;
                            case '2':
                                // status = 'Pending';
                                item_status = 'Outstanding';
                                break;
                            case '3':
                                item_status = 'Rejected';
                                break;
                            case '4':
                                item_status = 'Approved';
                                break;
                            case '5':
                                item_status = 'Uploaded';
                                break;
                            // case '5':
                            //     status = 'Pending Review';
                            // break;
                        }
                        var isChecked = item.checkbox_status == 1;
                        var checkboxHtml = '<div class="col-md-6"><div class="form-group" style="background-color: #9ebeff80;border-radius: 7px;padding: 9px 20px;display:flex;justify-content: space-between;"';
                        checkboxHtml += isChecked ? ' checked' : '';
                        checkboxHtml += '> ';
                        if (isChecked) {
                            checkboxHtml += '<p for="' + item.id + '" style="margin-left: 10px;margin-top:5px;"><del><span style="font-weight: 800;">' + item.name + ':</span> ' + item.description + '</del></p><span class="btn btn-primary" style="height: 51px;display: inline-block;white-space: normal;text-align: center;align-items: center;display: flex;"> ' + item_status + '</span>';
                        } else {
                            checkboxHtml += '<p for="' + item.id + '" style="margin-left: 10px;margin-top:5px;"><span style="font-weight: 800;">' + item.name + ':</span> ' + item.description + '</p><span class="btn btn-primary" style="height: 51px;display: inline-block;white-space: normal;text-align: center;align-items: center;display: flex;"> ' + item_status + '</span></div></div>';
                        }
                        // checkboxHtml += '<br>';
                        $('#file_opened_summery_checklist_item').append(checkboxHtml);
                    });
                },
                error: function (response) {
                }
            });
            // get all task of the case for broker
            $.ajax({
                url: '<?php echo admin_url('leads/get_summery_task_for_file_opened_for_broker/' . $lead->id); ?>',
                type: 'GET',
                success: function (response) {
                    //  file_opened_summery_checklist_item
                    $.each(response, function (index, item) {
                        var item_status;
                        switch (item.status) {
                            case '1':
                                item_status = 'Pending Review';
                                break;
                            case '2':
                                // status = 'Pending';
                                item_status = 'Outstanding';
                                break;
                            case '3':
                                item_status = 'Rejected';
                                break;
                            case '4':
                                item_status = 'Approved';
                                break;
                            case '5':
                                item_status = 'Uploaded';
                                break;
                            // case '5':
                            //     status = 'Pending Review';
                            // break;
                        }
                        var isChecked = item.checkbox_status == 1;
                        var checkboxHtml = '<div class="col-md-6"><div class="form-group" style="background-color: #9ebeff80;border-radius: 7px;padding: 9px 20px;display:flex;justify-content: space-between;"';
                        checkboxHtml += isChecked ? ' checked' : '';
                        checkboxHtml += '> ';
                        if (isChecked) {
                            checkboxHtml += '<p for="' + item.id + '" style="margin-left: 10px;margin-top:5px;"><del><span style="font-weight: 800;">' + item.name + ':</span> ' + item.description + '</del></p><span class="btn btn-primary" style="height: 51px;display: inline-block;white-space: normal;text-align: center;align-items: center;display: flex;"> ' + item_status + '</span>';
                        } else {
                            checkboxHtml += '<p for="' + item.id + '" style="margin-left: 10px;margin-top:5px;"><span style="font-weight: 800;">' + item.name + ':</span> ' + item.description + '</p><span class="btn btn-primary" style="height: 51px;display: inline-block;white-space: normal;text-align: center;align-items: center;display: flex;"> ' + item_status + '</span></div></div>';
                        }
                        // checkboxHtml += '<br>';
                        $('#file_opened_summery_checklist_item_for_broker').append(checkboxHtml);
                    });
                },
                error: function (response) {
                }
            });
            // get the file opened task completed time and status
            $.ajax({
                url: '<?php echo admin_url('leads/get_summery_task_for_file_opened_status/' . $lead->id); ?>',
                type: 'GET',
                success: function (response) {
                    //  file_opened_summery_status
                    var file_opened_summery_status = '<div class="" style="float: right; margin-right: 20px; text-align: center;">';
                    if (response.status == '1' && response.file_opened_completed == 0) {
                        file_opened_summery_status += '<p class="alert alert-info" style="margin-left: 0px; margin-top: 5px;">In Progress</p>';
                    } else if (response.file_opened_completed == '1') {
                        file_opened_summery_status += '<p class="alert alert-info" style="margin-left: 0px; margin-top: 5px;">Completed</p>';
                    }
                    file_opened_summery_status += '</div>';
                    $('#file_opened_summery_status').append(file_opened_summery_status);

                    if (!empty(response.file_opened_completed_at) && response.file_opened_completed == '1') {
                        var file_opened_summery_time = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                        file_opened_summery_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.file_opened_completed_at + '" style="display:flex;width:180px;justify-content: space-around;">';
                        file_opened_summery_time += '<bold style="font-weight: 800;">Completed at: </bold>' + response.file_opened_time + '</span>';
                        file_opened_summery_time += '</div>';
                        $('#file_opened_summery_time').append(file_opened_summery_time);
                    }
                    if (!empty(response.file_opened_started_at)) {
                        var file_opened_started_at_time = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                        file_opened_started_at_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.file_opened_started_at + '" style="display:flex;width:180px;justify-content: space-around;">';
                        file_opened_started_at_time += '<bold style="font-weight: 800;">Started at: </bold>' + response.file_opened_started_at_get_day + '</span>';
                        file_opened_started_at_time += '</div>';
                        $('#file_opened_started_at_time').append(file_opened_started_at_time);
                    }
                },
                error: function (response) {
                }
            });
            // get the file opened document link with date for client
            $.ajax({
                url: '<?php echo admin_url('leads/get_summery_task_for_file_opened_doc/' . $lead->id); ?>',
                type: 'GET',
                success: function (response) {
                    $.each(response, function (index, item) {
                        // Replace raw=1 with dl=1 in the file_url string
                        var modifiedFileUrl = item.file_url ? item.file_url.replace(/raw=1$/, 'dl=1') : '';
                        var filetypeParts = item.filetype ? item.filetype.split('/') : '';
                        var extension = filetypeParts[1]; var imageUrl;
                        if (extension === 'jpeg' || extension === 'jpg' || extension === 'png' || extension === 'avif') {
                            // imageUrl = item.file_url;
                            imageUrl = '<?php echo base_url("assets/images/allimage.webp"); ?>';
                        } else if (extension === 'msword' || extension === 'vnd.openxmlformats-officedocument') {
                            imageUrl = '<?php echo base_url("assets/images/msword_news.webp"); ?>';
                        } else if (extension === 'pdf') {
                            imageUrl = '<?php echo base_url("assets/images/pdf.webp"); ?>';
                        } else {
                            imageUrl = '<?php echo base_url("assets/images/general.webp"); ?>';
                        }
                        var file_opened_summery_allfiles = '<div class="col-md-4">' +
                            '<a href="' + modifiedFileUrl + '" style="display: inline-block; width: 100%; height: 150px; overflow: hidden;" target="_blank">' +
                            '<img loading="lazy" src="' + imageUrl + '" style="width: 100%; height: 100%; object-fit: cover;">' +
                            '</a>' +
                            '<p style="font-weight: 800;font-size: smaller;overflow: hidden;">' + item.task_name + '</p>' +
                            '<p style="font-weight: 800;font-size: smaller;overflow: hidden;">Created at: ' + item.dateadded + '</p>' +
                            '</div>';

                        $('#file_opened_summery_allfiles').append(file_opened_summery_allfiles);
                    });
                },
                error: function (response) {
                }
            });
            // get the file opened document link with date for broker
            $.ajax({
                url: '<?php echo admin_url('leads/get_summery_task_for_file_opened_doc_for_broker/' . $lead->id); ?>',
                type: 'GET',
                success: function (response) {
                    $.each(response, function (index, item) {
                        // Replace raw=1 with dl=1 in the file_url string
                        // var modifiedFileUrl = item.file_url.replace(/raw=1$/, 'dl=1');
                        var modifiedFileUrl = item.file_url ? item.file_url.replace(/raw=1$/, 'dl=1') : '';
                        var imageUrl;
                        var filetypeParts = item.filetype ? item.filetype.split('/') : '';
                        var extension = filetypeParts[1];
                        if (extension === 'jpeg' || extension === 'jpg' || extension === 'png' || extension === 'avif') {
                            // imageUrl = item.file_url;
                            imageUrl = '<?php echo base_url("assets/images/allimage.webp"); ?>';
                        } else if (extension === 'msword' || extension === 'vnd.openxmlformats-officedocument') {
                            imageUrl = '<?php echo base_url("assets/images/msword_new.webp"); ?>';
                        } else if (extension === 'pdf') {
                            imageUrl = '<?php echo base_url("assets/images/pdf.webp"); ?>';
                        } else {
                            imageUrl = '<?php echo base_url("assets/images/general.webp"); ?>';
                        }
                        // var modifiedFileUrl = encodeURIComponent(imageUrl);
                        var file_opened_summery_broker_allfiles = '<div class="col-md-4">' +
                            '<a href="' + modifiedFileUrl + '" style="display: inline-block; width: 100%; height: 150px; overflow: hidden;" target="_blank">' +
                            '<img loading="lazy" src="' + imageUrl + '" style="width: 100%; height: 100%; object-fit: cover;">' +
                            '</a>' +
                            '<p style="font-weight: 800;font-size: smaller;overflow: hidden;">' + item.task_name + '</p>' +
                            '<p style="font-weight: 800;font-size: smaller;overflow: hidden;">Created at: ' + item.dateadded + '</p>' +
                            '</div>';
                        $('#file_opened_summery_allfiles_for_broker').append(file_opened_summery_broker_allfiles);
                    });
                },
                error: function (response) {
                }
            });
        });
        // ID verification script
        // get the id verification task completed time and status
        $.ajax({
            url: '<?php echo admin_url('leads/get_summery_task_for_id_verification_status/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                var id_verification_summery_status = '<div class="" style="float: right; margin-right: 20px; text-align: center;">';
                if (response.status == '8' && response.id_verification_completed == 0) {
                    id_verification_summery_status += '<p class="alert alert-info" style="margin-left: 0px; margin-top: 5px;">In Progress</p>';
                } else if (response.id_verification_completed == '1') {
                    id_verification_summery_status += '<p class="alert alert-info" style="margin-left: 0px; margin-top: 5px;">Completed</p>';
                }
                id_verification_summery_status += '</div>';

                $('#id_verification_summery_status').append(id_verification_summery_status);
                if (!empty(response.id_verification_completed_at)) {
                    var id_verification_summery_time = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                    id_verification_summery_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.id_verification_completed_at + '" style="display:flex;width:180px;justify-content: space-around;">';
                    id_verification_summery_time += '<bold style="font-weight: 800;">Completed at: </bold>' + response.id_verification_time + '</span>';
                    id_verification_summery_time += '</div>';
                    $('#id_verification_summery_time').append(id_verification_summery_time);
                }
                if (!empty(response.id_verification_started_at)) {
                    var id_verification_started_time = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                    id_verification_started_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.id_verification_started_at + '" style="display:flex;width:180px;justify-content: space-around;">';
                    id_verification_started_time += '<bold style="font-weight: 800;">Started at: </bold>' + response.id_verification_started_at_get_day + '</span>';
                    id_verification_started_time += '</div>';
                    $('#id_verification_started_time').append(id_verification_started_time);
                }

            },
            error: function (response) {
            }
        });
        // get the instruction received Doc Link
        $.ajax({
            url: '<?php echo admin_url('leads/get_summery_task_for_id_verification_doclink/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                $.each(response, function (index, item) {
                    var modifiedFileUrl = item.file_url ? item.file_url.replace(/raw=1$/, 'dl=1') : '';
                    var filetypeParts = item.file_type.split('/');
                    var extension = filetypeParts[1];
                    var imageUrl;
                    if (extension === 'jpeg' || extension === 'jpg' || extension === 'png' || extension === 'avif') {
                        // imageUrl = item.file_url;
                        imageUrl = '<?php echo base_url("assets/images/allimage.webp"); ?>';
                    } else if (extension === 'msword' || extension === 'vnd.openxmlformats-officedocument') {
                        imageUrl = '<?php echo base_url("assets/images/msword_new.webp"); ?>';
                    } else if (extension === 'pdf') {
                        imageUrl = '<?php echo base_url("assets/images/pdf.webp"); ?>';
                    } else {
                        imageUrl = '<?php echo base_url("assets/images/general.webp"); ?>';
                    }
                    var id_verification_all_files = '<div class="col-md-4">' +
                        '<a href="' + modifiedFileUrl + '" style="display: inline-block; width: 100%; height: 150px; overflow: hidden;" target="_blank">' +
                        '<img loading="lazy" src="' + imageUrl + '" style="width: 100%; height: 100%; object-fit: cover;">' +
                        '</a>' +
                        '<p style="font-weight: 800;font-size: smaller;overflow: hidden;">' + item.file_name + '</p>' +
                        '<p style="font-weight: 800;font-size: smaller;overflow: hidden;">Created at: ' + item.created_at + '</p>' +
                        '</div>';

                    $('#id_verification_all_files').append(id_verification_all_files);
                });
            },
            error: function (response) {
            }
        });
        // <!-- instruction received summer work -->
        // get the instruction received task completed time and status

        $.ajax({
            url: '<?php echo admin_url('leads/get_summery_task_for_instruction_received_status/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                var ins_received_summery_status = '<div class="" style="float: right; margin-right: 20px; text-align: center;">';
                if (response.status == '8' && response.ins_received_completed == 0) {
                    ins_received_summery_status += '<p class="alert alert-info" style="margin-left: 0px; margin-top: 5px;">In Progress</p>';
                } else if (response.ins_received_completed == '1') {
                    ins_received_summery_status += '<p class="alert alert-info" style="margin-left: 0px; margin-top: 5px;">Completed</p>';
                }
                ins_received_summery_status += '</div>';

                $('#ins_received_summery_status').append(ins_received_summery_status);
                if (!empty(response.ins_received_completed_at) && response.ins_received_completed == '1') {
                    var ins_received_summery_time = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                    ins_received_summery_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.ins_received_completed_at + '" style="display:flex;width:180px;justify-content: space-around;">';
                    ins_received_summery_time += '<bold style="font-weight: 800;">Completed at: </bold>' + response.ins_received_time + '</span>';
                    ins_received_summery_time += '</div>';
                    $('#ins_received_completed_summery_time').append(ins_received_summery_time);
                }
                if (!empty(response.ins_received_started_at)) {
                    var ins_received_started_time = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                    ins_received_started_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.ins_received_started_at + '" style="display:flex;width:180px;justify-content: space-around;">';
                    ins_received_started_time += '<bold style="font-weight: 800;">Started at: </bold>' + response.ins_received_started_at_get_day + '</span>';
                    ins_received_started_time += '</div>';
                    $('#ins_received_started_time').append(ins_received_started_time);
                }
            },
            error: function (response) {
            }
        });
        // get the instruction received Doc Link
        $.ajax({
            url: '<?php echo admin_url('leads/get_summery_task_for_ins_received_doclink/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                $.each(response, function (index, item) {
                    var modifiedFileUrl = item.file_url ? item.file_url.replace(/raw=1$/, 'dl=1') : '';
                    var filetypeParts = item.file_type.split('/');
                    var extension = filetypeParts[1];
                    var imageUrl;
                    if (extension === 'jpeg' || extension === 'jpg' || extension === 'png' || extension === 'avif') {
                        // imageUrl = item.file_url;
                        imageUrl = '<?php echo base_url("assets/images/allimage.webp"); ?>';
                    } else if (extension === 'msword' || extension === 'vnd.openxmlformats-officedocument') {
                        imageUrl = '<?php echo base_url("assets/images/msword_new.webp"); ?>';
                    } else if (extension === 'pdf') {
                        imageUrl = '<?php echo base_url("assets/images/pdf.webp"); ?>';
                    } else {
                        imageUrl = '<?php echo base_url("assets/images/general.webp"); ?>';
                    }
                    var ins_received_all_files = '<div class="col-md-4">' +
                        '<a href="' + modifiedFileUrl + '" style="display: inline-block; width: 100%; height: 150px; overflow: hidden;" target="_blank">' +
                        '<img loading="lazy" src="' + imageUrl + '" style="width: 100%; height: 100%; object-fit: cover;">' +
                        '</a>' +
                        '<p style="font-weight: 800;font-size: smaller;overflow: hidden;">' + item.file_name + '</p>' +
                        '<p style="font-weight: 800;font-size: smaller;overflow: hidden;">Created at:' + item.created_at + '</p>' +
                        '</div>';

                    $('#ins_received_all_files').append(ins_received_all_files);
                });
            },
            error: function (response) {
            }
        });
        // get the set appointment time for summary
        $.ajax({
            url: '<?php echo admin_url('leads/get_set_appointment_time_for_summary/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                var set_appointment_time = '<div class="" style="float: right; margin-right: 20px; text-align: center;">';
                if (response.date) {
                    set_appointment_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.date + '" style="display:flex;width:180px;justify-content: space-around;">' + response.format_date + '</span>';
                }
                set_appointment_time += '</div>';

                $('#set_appointment_time').append(set_appointment_time);
            },
            error: function (response) {
            }
        });
        // get all checkboxes for appointment
        $.ajax({
            url: '<?php echo admin_url('leads/get_summery_task_for_appointment/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                $.each(response, function (index, item) {
                    var isChecked = item.status == 1;
                    var checkboxHtml = '<div class="col-md-6"><div class="form-group" style="background-color: #9ebeff80;border-radius: 7px;padding: 9px 20px;display:flex;"';
                    checkboxHtml += isChecked ? ' checked' : '';
                    checkboxHtml += '> ';
                    if (isChecked) {
                        checkboxHtml += '<p for="' + item.id + '" style="margin-left: 10px;margin-top:5px;"><del><span style="font-weight: 800;">' + item.title + ':</span> ' + item.description + '</del></p>';
                    } else {
                        checkboxHtml += '<p for="' + item.id + '" style="margin-left: 10px;margin-top:5px;"><span style="font-weight: 800;">' + item.title + ':</span> ' + item.description + '</p></div></div>';
                    }
                    // checkboxHtml += '<br>';
                    $('#appointment_checkboxes').append(checkboxHtml);
                });
            },
            error: function (response) {
            }
        });
        // get the instruction received task completed time and status
        $.ajax({
            url: '<?php echo admin_url('leads/get_summery_task_for_appointment_status/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                var appointment_request_complted_status = '<div class="" style="float: right; margin-right: 20px; text-align: center;">';
                if (response.status == '7' && response.app_request_completed == 0) {
                    appointment_request_complted_status += '<p class="alert alert-info" style="margin-left: 0px; margin-top: 5px;">In Progress</p>';
                } else if (response.app_request_completed == '1') {
                    appointment_request_complted_status += '<p class="alert alert-info" style="margin-left: 0px; margin-top: 5px;">Completed</p>';
                }
                appointment_request_complted_status += '</div>';

                $('#app_request_summery_status').append(appointment_request_complted_status);
                if (!empty(response.app_request_completed_at) && response.app_request_completed == '1') {
                    var appointment_req_time = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                    appointment_req_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.app_request_completed_at + '" style="display:flex;width:180px;justify-content: space-around;">';
                    appointment_req_time += '<bold style="font-weight: 800;">Completed at: </bold>' + response.app_request_time + '</span>';
                    appointment_req_time += '</div>';
                    $('#app_request_completed_summery_time').append(appointment_req_time);
                }
                // if (!empty(response.app_request_started_at)) {
                //     var appointment_req_started_time = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                //     appointment_req_started_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.app_request_started_at + '" style="display:flex;width:180px;justify-content: space-around;">';
                //     appointment_req_started_time += '<bold style="font-weight: 800;">Started at: </bold>' + response.app_request_started_at_get_day + '</span>';
                //     appointment_req_started_time += '</div>';
                //     $('#appointment_req_started_time').append(appointment_req_started_time);
                // }
            },
            error: function (response) {
            }
        });
        // get the outstanding item completed time and status
        $.ajax({
            url: '<?php echo admin_url('leads/get_summery_task_for_outstanding_item_team_status/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                var outstanding_item_complted_status = '<div class="" style="float: right; margin-right: 20px; text-align: center;">';
                if (response.status == '3' && response.out_items_completed == 0) {
                    outstanding_item_complted_status += '<p class="alert alert-info" style="margin-left: 0px; margin-top: 5px;">In Progress</p>';
                } else if (response.out_items_completed == '1') {
                    outstanding_item_complted_status += '<p class="alert alert-info" style="margin-left: 0px; margin-top: 5px;">Completed</p>';
                }
                outstanding_item_complted_status += '</div>';

                $('#outstanding_item_summery_status').append(outstanding_item_complted_status);
                if (!empty(response.outstanding_item_completed_at) && response.out_items_completed == '1') {
                    var outstanding_item_team = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                    outstanding_item_team += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.outstanding_item_completed_at + '" style="display:flex;width:180px;justify-content: space-around;">';
                    outstanding_item_team += '<bold style="font-weight: 800;">Completed at: </bold>' + response.outstanding_item_time + '</span>';
                    outstanding_item_team += '</div>';
                    $('#outstanding_item_completed_summery_time').append(outstanding_item_team);
                }
                if (!empty(response.outstanding_item_started_at)) {
                    var outstanding_item_started_at = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                    outstanding_item_started_at += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.outstanding_item_started_at + '" style="display:flex;width:180px;justify-content: space-around;">';
                    outstanding_item_started_at += '<bold style="font-weight: 800;">Started at: </bold>' + response.outstanding_item_started_at_get_day + '</span>';
                    outstanding_item_started_at += '</div>';
                    $('#outstanding_item_started_at').append(outstanding_item_started_at);
                }

            },
            error: function (response) {
            }
        });
        // get the ledgers completed time and status
        $.ajax({
            url: '<?php echo admin_url('leads/get_summery_ledger_status/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                var ledger_complted_status = '<div class="" style="float: right; margin-right: 20px; text-align: center;">';
                if (response.ledger_completed == 0) {
                    ledger_complted_status += '<p class="alert alert-info" style="margin-left: 0px; margin-top: 5px;">In Progress</p>';
                } else if (response.ledger_completed == '1') {
                    ledger_complted_status += '<p class="alert alert-info" style="margin-left: 0px; margin-top: 5px;">Completed</p>';
                }
                ledger_complted_status += '</div>';

                $('#ledger_summery_status').append(ledger_complted_status);
                if (!empty(response.ledger_started_at)) {
                    var ledger_started_at_time = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                    ledger_started_at_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.ledger_started_at + '">';
                    ledger_started_at_time += '<bold style="font-weight: 800;">Started at: </bold>' + response.ledger_started_at_get_day + '</span>';
                    ledger_started_at_time += '</div>';
                    $('#ledger_started_at_time').append(ledger_started_at_time);
                }
            },
            error: function (response) {
            }
        });
        // get the all ledger doc details
        $.ajax({
            url: '<?php echo admin_url('leads/get_summery_task_for_ledger_doclink/' . $lead->id); ?>',
            method: 'GET',
            dataType: 'json',
            success: function (response) {
                var groupedLedgers = {};

                // Group ledgers by ledger_number
                $.each(response, function (index, item) {
                    if (!groupedLedgers[item.ledger_number]) {
                        groupedLedgers[item.ledger_number] = {
                            items: [],
                            broker_status: item.broker_status,
                            broker_comment: item.broker_comment,
                            created_at: new Date(item.created_at).toLocaleDateString(),
                            broker_change_status_time: (item.broker_change_status_time) ? new Date(item.broker_change_status_time).toLocaleDateString() : '',
                        };
                    }
                    groupedLedgers[item.ledger_number].items.push(item);
                });

                // Iterate over grouped ledgers and create table rows
                $.each(groupedLedgers, function (ledgerNumber, ledgerData) {
                    var imageHtml = '';

                    $.each(ledgerData.items, function (index, item) {
                        // var modifiedFileUrl = item.file_url.replace(/raw=1$/, 'dl=1');
                        var modifiedFileUrl = item.file_url ? item.file_url.replace(/raw=1$/, 'dl=1') : '';
                        var filetypeParts = item.filetype ? item.filetype.split('/') : '';
                        var extension = filetypeParts[1];

                        var imageUrl;
                        if (extension === 'jpeg' || extension === 'jpg' || extension === 'png' || extension === 'avif') {
                            imageUrl = '<?php echo base_url("assets/images/allimage.webp"); ?>';
                        } else if (extension === 'msword' || extension === 'vnd.openxmlformats-officedocument') {
                            imageUrl = '<?php echo base_url("assets/images/msword_new.webp"); ?>';
                        } else if (extension === 'pdf') {
                            imageUrl = '<?php echo base_url("assets/images/pdf.webp"); ?>';
                        } else {
                            imageUrl = '<?php echo base_url("assets/images/general.webp"); ?>';
                        }

                        imageHtml += '<div style="position: relative; display: inline-block; margin-right: 10px;">' +
                            '<a href="' + modifiedFileUrl + '" target="_blank">' +
                            '<img loading="lazy" src="' + imageUrl + '" style="height: 75px; width: 75px; max-height: 150px; margin-top:35px;">' +
                            '</a>' +
                            '<div style="position: absolute; top: 5px; margin-left: 35px;">' +
                            '<a href="' + item.file_url + '" target="_blank" style="margin-right: 5px;"><i class="fa fa-eye" aria-hidden="true"></i></a>' +
                            '<a href="' + modifiedFileUrl + '" download style=""><i class="fa fa-download"></i></a>' +
                            '</div>' +
                            '</div>';
                    });

                    var ledgerTableRow = '<tr>' +
                        '<td style="text-align: center;">' + imageHtml + '</td>' +
                        '<td style="text-align: center;">' + (ledgerData.broker_status || '-') + '<br>' + (ledgerData.broker_change_status_time || '') + '</td>' +
                        '<td style="text-align: center;">' + (ledgerData.broker_comment || '-') + '</td>' +
                        '<td style="text-align: center;">' + ledgerData.created_at + '</td>' +
                        '<td style="text-align: center;display:flex;">' +
                        '<a href="#" class="btn btn-primary ledger-status-change" data-id="' + ledgerNumber + '" data-status="Approved" style="margin-top:10px;">Approved</a>' +
                        '<a href="#" class="btn btn-danger ledger-status-change" data-id="' + ledgerNumber + '" data-status="Rejected" style="margin-top:10px; margin-left:10px;">Rejected</a>' +
                        '</td>' +
                        '</tr>';

                    $('#ledger_all_files_table tbody').append(ledgerTableRow);
                });
            },
            error: function (error) {
                console.error('Error fetching ledger documents:', error);
            }
        });
        // change the status of ledger doc 
        $(document).off('click', '.ledger-status-change').on('click', '.ledger-status-change', function (e) {
            e.preventDefault();
            var fileId = $(this).data('id');
            var sameGroup = '<?php echo $samegroup; ?>';
            var status = $(this).data('status');
            // Scroll the modal into view
            $('#ledger_modal_header').text('Please provide the reason for ' + status);
            setTimeout(function () {
                $('#ledger_statusChangeModal').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
            }, 200);
            $('#ledger_statusChangeModal').modal('show');
            $('#ledger_rejection_reason_close_button').click(function () {
                $('#ledger_statusChangeModal').modal('hide');
            });
            // submit the form
            $('#ledger_submitStatusChange').off('click').on('click', function () {
                var rejectionReason = $('#ledger_rejectionReason').val();
                if (rejectionReason.trim() === '' && status == 'Rejected') {
                    $('#ledger_rejectionReason').addClass('is-invalid').next('.invalid-feedback').show();
                } else {
                    $('#ledger_rejectionReason').removeClass('is-invalid').next('.invalid-feedback').hide();
                    $('#ledger_rejection_reason_loader').addClass('loader');
                    $('#ledger_submitStatusChange').prop('disabled', true);
                    $.ajax({
                        url: "<?php echo admin_url('leads/approve_ledger_item/' . $lead->id); ?>",
                        type: 'POST',
                        data: {
                            fileId: fileId,
                            status: status,
                            rejectionReason: rejectionReason
                        },
                        success: function (response) {
                            $('#ledger_rejection_reason_loader').removeClass('loader');
                            $('#ledger_submitStatusChange').prop('disabled', false);
                            $('#ledger_rejection_reason_close_button').trigger('click');
                            var anchor = document.querySelector('#ledger_rejection_reason_close_button');
                            anchor.click();
                            setTimeout(function () {
                                destroyTinyMCE();
                                _lead_init_data(response, response.id);
                                $('a[href="#summary"]').tab('show');
                                $('#rejection_reason_close_button').trigger('click');
                                if (sameGroup != 2) {
                                    $('a[href="#summary"]').closest('div').addClass('step-active');
                                }
                                var anchor = document.querySelector('.close');
                                anchor.click();
                                alert_float('success', 'Ledger status updated successfully.');
                            }, 500);
                        },
                        error: function (error) {
                            alert_float('danger', 'Ledger status cannot be updated.');
                        }
                    });
                }
            });
            // }
        });
        // get the request for funds checkobxes
        $.ajax({
            url: '<?php echo admin_url('leads/get_summery_task_for_req_for_funds/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                $.each(response, function (index, item) {
                    var isChecked = item.status == 1;
                    var req_for_funds_html = '<div class="col-md-6"><div class="form-group" style="background-color: #9ebeff80;border-radius: 7px;padding: 9px 20px;display:flex;"';
                    req_for_funds_html += isChecked ? ' checked' : '';
                    req_for_funds_html += '> ';
                    if (isChecked) {
                        req_for_funds_html += '<p for="' + item.id + '" style="margin-left: 10px;margin-top:5px;"><del><span style="font-weight: 800;">' + item.title + ':</span> ' + item.description + '</del></p>';
                    } else {
                        req_for_funds_html += '<p for="' + item.id + '" style="margin-left: 10px;margin-top:5px;"><span style="font-weight: 800;">' + item.title + ':</span> ' + item.description + '</p></div></div>';
                    }
                    // checkboxHtml += '<br>';
                    $('#req_for_funds_checkboxes').append(req_for_funds_html);
                });
            },
            error: function (response) {
            }
        });
        // get the request for funds completed time and status
        $.ajax({
            url: '<?php echo admin_url('leads/get_summery_task_for_req_for_funds_status/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                var request_for_funds_complted_status = '<div class="" style="float: right; margin-right: 20px; text-align: center;">';
                if (response.status == '4' && response.req_for_funds_completed == 0) {
                    request_for_funds_complted_status += '<p class="alert alert-info" style="margin-left: 0px; margin-top: 5px;">In Progress</p>';
                } else if (response.req_for_funds_completed == '1') {
                    request_for_funds_complted_status += '<p class="alert alert-info" style="margin-left: 0px; margin-top: 5px;">Completed</p>';
                }
                request_for_funds_complted_status += '</div>';

                $('#req_for_funds_summery_status').append(request_for_funds_complted_status);
                if (!empty(response.req_for_funds_completed_at)) {
                    var req_for_funds_time = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                    req_for_funds_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.req_for_funds_completed_at + '" style="display:flex;width:180px;justify-content: space-around;">';
                    req_for_funds_time += '<bold style="font-weight: 800;">Completed at: </bold>' + response.req_for_funds_time + '</span>';
                    req_for_funds_time += '</div>';
                    $('#req_for_funds_completed_summery_time').append(req_for_funds_time);
                }
            },
            error: function (response) {
            }
        });
        // get the ledgers record 
        $.ajax({
            url: '<?php echo admin_url('leads/get_summery_task_for_ledger_status/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                if (!empty(response.ledger_completed_at)) {
                    var ledger_time = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                    ledger_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.ledger_completed_at + '" style="display:flex;width:180px;justify-content: space-around;margin-bottom: 0px;">';
                    ledger_time += '<bold style="font-weight: 800;">Completed at: </bold>' + response.ledger_time + '</span>';
                    ledger_time += '</div>';
                    $('#ledger_completed_summery_time').append(ledger_time);
                }
                if (!empty(response.ledger_started_at)) {
                    var ledger_started_time = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                    ledger_started_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.ledger_started_at + '" style="display:flex;width:180px;justify-content: space-around;">';
                    ledger_started_time += '<bold style="font-weight: 800;">Started at: </bold>' + response.ledger_started_at_get_day + '</span>';
                    ledger_started_time += '</div>';
                    $('#ledger_started_time').append(ledger_started_time);
                }
            },
            error: function (response) {
            }
        });
        // get the last activity time
        $.ajax({
            url: '<?php echo admin_url('leads/get_last_activity_log_time/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                if (!empty(response.last_activity_logs)) {
                    var ledger_time = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                    ledger_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.last_activity_logs + '" style="display:flex;width:180px;justify-content: space-around;">';
                    ledger_time += response.last_activity_logs_date + '</span>';
                    ledger_time += '</div>';
                    $('#last_activity_logs').append(ledger_time);
                }
            },
            error: function (response) {
            }
        });
        // get the offer in date
        $.ajax({
            url: '<?php echo admin_url('leads/get_offer_in_date/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                if (!empty(response.offer_in)) {
                    var offer_in_time = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                    offer_in_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.offer_in + '" style="display:flex;width:180px;justify-content: space-around;">';
                    offer_in_time += response.offer_in_date + '</span>';
                    offer_in_time += '</div>';
                    $('#offer_in_date').append(offer_in_time);
                }
            },
            error: function (response) {
            }
        });
        // get the request for funds summery doc link
        $.ajax({
            url: '<?php echo admin_url('leads/get_summery_task_for_request_for_funds_doclink/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                $.each(response, function (index, item) {
                    var checkboxTitle = item.title;
                    var titleHtml = '<p style="font-weight:800;">' + checkboxTitle + '</p>';

                    if (item.file_data && item.file_data.length > 0) {
                        $.each(item.file_data, function (i, file) {
                            var modifiedFileUrl = file.file_url.replace(/raw=1$/, 'dl=1');
                            var filetypeParts = file.filetype.split('/');
                            var extension = filetypeParts[1];
                            var imageUrl;

                            if (extension === 'jpeg' || extension === 'jpg' || extension === 'png' || extension === 'avif') {
                                // imageUrl = file.file_url;
                                imageUrl = '<?php echo base_url("assets/images/allimage.webp"); ?>';
                            } else if (extension === 'msword' || extension === 'vnd.openxmlformats-officedocument') {
                                imageUrl = '<?php echo base_url("assets/images/msword_new.webp"); ?>';
                            } else if (extension === 'pdf') {
                                imageUrl = '<?php echo base_url("assets/images/pdf.webp"); ?>';
                            } else {
                                imageUrl = '<?php echo base_url("assets/images/general.webp"); ?>';
                            }

                            var request_for_funds_files_summery = '<div class="col-md-2">' +
                                '<div class="file-container">' +
                                '<a href="' + modifiedFileUrl + '" style="display: inline-block; width: 100%; height: 150px; overflow: hidden;" target="_blank">' +
                                '<img loading="lazy" src="' + imageUrl + '" style="width: 83%; height: 100%; object-fit: cover;margin-top:7px;">' +
                                '</a>' +
                                titleHtml +
                                '<p style="font-weight: 800;font-size: smaller;overflow: hidden;">Created at: ' + file.dateadded + '</p>' +
                                '</div>' +
                                '</div>';

                            $('#request_for_funds_files_summery').append(request_for_funds_files_summery);
                        });
                    }
                });
            },
            error: function (response) {
                console.error('Error fetching data:', response);
            }
        });
        // get the closed time
        $.ajax({
            url: '<?php echo admin_url('leads/get_summery_task_closed_status/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                var closed_time = '<div class="" style="float: right; margin-right: 20px; text-align: center;">';
                if (!empty(response.closed_completed_at)) {
                    var closed_time = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                    closed_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.closed_completed_at + '" style="display:flex;width:180px;justify-content: space-around;">';
                    closed_time += '<bold style="font-weight: 800;">Completed at: </bold>' + response.closed_time + '</span>';
                    closed_time += '</div>';
                    $('#closed_completed_summery_time').append(closed_time);
                    // show case completed time
                    var case_compeleted_time = '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.closed_completed_at + '" style="display:flex;width:180px;justify-content: space-around;">';
                    case_compeleted_time += '<bold style="font-weight: 800;">Completed at: </bold>' + response.closed_time + '</span>';
                    $('#case_completed_time').append(case_compeleted_time);
                }

            },
            error: function (response) {
            }
        });
        // get the on hold time
        $.ajax({
            url: '<?php echo admin_url('leads/get_summery_task_on_hold_status/' . $lead->id); ?>',
            type: 'GET',
            success: function (response) {
                var on_hold_time = '<div class="" style="float: right; margin-right: 20px; text-align: center;">';
                if (!empty(response.hold_completed_at)) {
                    var on_hold_time = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                    on_hold_time += '<span class="alert alert-info" data-toggle="tooltip" data-title="' + response.hold_completed_at + '" style="display:flex;width:180px;justify-content: space-around;">';
                    on_hold_time += ' < bold style=" font-weight: 800;">Completed at: </>' + response.hold_completed_at + '</span>';
                    on_hold_time += '</div>';
                    $('#on_hold_completed_summery_time').append(on_hold_time);
                }
                if (!empty(response.on_hold_reason)) {
                    var on_hold_reason = '<div class="col-md-12" style="float: right; margin-right: 5px; text-align: center;">';
                    on_hold_reason += '<bold style="font-weight: 800;">Reason: </bold>' + response.on_hold_reason + '</span>';
                    on_hold_reason += '</div>';
                    $('#on_hold_reason').append(on_hold_reason);
                }

            },
            error: function (response) {
            }
        });
    </script>
    <!-- refresh page line of code using ajax -->
    <script>
        $(document).ready(function () {
            function destroyTinyMCE() {
                tinymce.remove();
                if (tinymce.editors.length > 0) {
                    tinymce.editors.forEach(function (editor) {
                        editor.remove();
                    });
                }
            }
            // Attach click event handler to the button
            $('button#refresh_page').click(function () {
                const icon = $(this).find('i'); // rotate only the icon
                icon.addClass('rotate-animation');

                var leadId = '<?php echo $lead->id; ?>';
                var sameGroup = '<?php echo $samegroup; ?>';
                var leadsStatusCurrentId = '<?php echo $leads_status_current_id; ?>';

                $.ajax({
                    type: 'POST',
                    url: '<?php echo admin_url('leads/refresh_page_load'); ?>',
                    data: { lead_id: leadId, leads_status_current_id: leadsStatusCurrentId },
                    success: function (response) {
                        if (sameGroup != 2) {
                            destroyTinyMCE();
                            _lead_init_data(response, response.id);
                            if (response.leads_status === "#lead_reminders") {
                                var anchor = document.querySelector('a[href="#lead_reminders"]');
                                anchor.click();
                            } else {
                                $('a[href="' + response.leads_status + '"]').tab('show');
                            }
                            $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                        } else {
                            setTimeout(function () {
                                _lead_init_data(response, response.id);
                                var anchor = document.querySelector('a[href="#file_opened"]');
                                if (anchor) {
                                    anchor.click();
                                }
                            }, 500);
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error(error);
                    },
                    complete: function () {
                        icon.removeClass('rotate-animation');
                    }
                });
            });

            // summery refresh button 
            $('button#summery_refresh_page').click(function () {
                const icon = $(this).find('i'); // target the icon inside the button
                icon.addClass('rotate-animation');

                var leadId = '<?php echo $lead->id; ?>';
                var leadsStatusCurrentId = <?php echo $leads_status_current_id; ?>;
                var sameGroup = '<?php echo $samegroup; ?>';

                $.ajax({
                    type: 'POST',
                    url: '<?php echo admin_url('leads/summery_refresh_page_load'); ?>',
                    data: { lead_id: leadId, leads_status_current_id: leadsStatusCurrentId },
                    success: function (response) {
                        destroyTinyMCE();
                        _lead_init_data(response, response.id);
                        $('a[href="' + response.leads_status + '"]').tab('show');
                        if (sameGroup != 2) {
                            // $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error(error);
                    },
                    complete: function () {
                        icon.removeClass('rotate-animation');
                    }
                });
            });
        });
    </script>

    <script>
        $(document).ready(function () {
            function destroyTinyMCE() {
                tinymce.remove();
                if (tinymce.editors.length > 0) {
                    tinymce.editors.forEach(function (editor) {
                        editor.remove();
                    });
                }
            }
            $(document).off('click', "#client_contact_modal_close_btn").on('click', "#client_contact_modal_close_btn", function () {
                $("#editBorrowerModal").modal("hide");
            });
            // edit borrower details
            var borrow_phone = document.getElementById('borrow_phone');
            if (borrow_phone) {
                borrow_phone.addEventListener('input', function (e) {
                    var x = e.target.value.replace(/\D/g, '').match(/(\d{0,3})(\d{0,3})(\d{0,4})/);
                    e.target.value = !x[2] ? x[1] : '(' + x[1] + ') ' + x[2] + (x[3] ? '-' + x[3] : '');

                    if (e.target.value.length <= 13) {
                        $("#borrow_phone_error").show();
                        // $(".lead-save-btn").attr('disabled', true);
                    } else {
                        $("#borrow_phone_error").hide();
                    }
                });
            }
            $(document).off("click", ".co_borrow_edit_btn").on("click", ".co_borrow_edit_btn", function () {
                var borrowerId = $(this).data("id");
                var lead_id = "<?php echo $lead->id;?>";

                $.ajax({
                    url: "<?= admin_url('leads/get_specific_borrower_details'); ?>",
                    type: "POST",
                    data: { 
                        borrowerId: borrowerId,
                        lead_id: lead_id
                     },
                    dataType: "json",
                    success: function (response) {
                        if (response.success) {
                            $("#client_contact_borrower_id").val(response.data.borrower_id);
                            $("#borrow_firstname").val(response.data.borrow_firstname);
                            $("#borrow_middlename").val(response.data.borrow_middlename);
                            $("#borrow_lastname").val(response.data.borrow_lastname);
                            $("#borrow_email").val(response.data.borrow_email);
                            $("#borrow_phone").val(response.data.borrow_phone);
                            // $("#borrow_address").val(response.data.borrow_address);

                            $("#editBorrowerModal").modal("show");
                        }
                    },
                    error: function () {
                    }
                });
            });
            $("#editBorrowerForm").submit(function (e) {
                e.preventDefault();
                $('#client_contact_update_loader').addClass('loader');
                $('#client_contact_update_button').prop('disabled', true);
                $.ajax({
                    url: "<?= admin_url('leads/update_borrower_details_by_id/' . $lead->id); ?>",
                    type: "POST",
                    data: $(this).serialize(),
                    dataType: "json",
                    success: function (response) {
                        if (response.success) {
                            $('#client_contact_update_loader').removeClass('loader');
                            $('#client_contact_update_button').prop('disabled', false);
                            alert_float('success', 'Borrower details updated successfully!');
                            $('#client_contact_modal_close_btn').trigger('click');
                            $('#client_contact_modal_close_btn').click();
                            var anchor = document.querySelector('#client_contact_modal_close_btn');
                            if(anchor){
                                anchor.click();
                                // $("#editBorrowerModal").modal("hide");
                            }
                            var anchor = document.querySelector('.close');
                            anchor.click();
                            $('a[href="co_borrow"]').tab('show');
                            destroyTinyMCE();
                            
                            setTimeout(function () {
                                // $(this).closest('.modal').modal('hide');
                                _lead_init_data(response, response.lead_id);
                            }, 500);
                        } else {
                            alert_float('danger', 'Failed to update borrower details.');
                            $('#client_contact_update_loader').removeClass('loader');
                            $('#client_contact_update_button').prop('disabled', false);
                        }
                    },
                    error: function () {
                    }
                });
            });


            $('.co_borrow_delete_btn').off('click').on('click', function () {
                var id = $(this).data('id');
                var lead_id = '<?php echo $lead->id ?>';
                var sameGroup = '<?php echo $samegroup; ?>';
                // if (confirm("Are you sure you want to delete this record?")) {
                    $('.full-page-loader').show();
                    setTimeout(function () {
                        $('#full_page_loader').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                    }, 200);
                    // ajax call
                    $.ajax({
                        type: 'POST',
                        url: '<?php echo admin_url('leads/co_borrow_delete'); ?>',
                        data: {
                            id: id,
                            lead_id: lead_id
                        },
                        success: function (response) {
                            if (response.success) {
                                $('.full-page-loader').hide();
                                $('#borrow_' + id).remove();
                                alert_float('success', 'Record deleted successfully.');
                                if ($('#co_borrow_table tbody tr').length == 0) {
                                    $('#co_borrow_table tbody').html('<tr><td colspan="5">No records found.</td></tr>');
                                }
                                destroyTinyMCE();
                                $('a[href="' + response.leads_status + '"]').tab('show');
                                _lead_init_data(response, response.lead_id);
                            } else {
                                alert_float('danger', 'Failed to delete record.');
                            }
                        },
                        error: function (xhr, status, error) {
                            alert_float('danger', 'An error occurred while processing your request');
                        }
                    });
                // }
            });
        });
    </script>
    <!-- File opened review mail line of code -->
    <script>
        $(document).ready(function () {
            function destroyTinyMCE() {
                tinymce.remove();
                if (tinymce.editors.length > 0) {
                    tinymce.editors.forEach(function (editor) {
                        editor.remove();
                    });
                }
            }
            // this variable is import to use
            var checkboxIds = [];
            var leadId = '<?php echo $lead->id;?>';
            $('#btn_file_opened_email_review').on('click', function () {
                $('#file_opened_email_review').fadeToggle('slow', function () {
                    if ($(this).is(':visible')) {
                        $('#file_opened_client_email_review').hide('slow');
                        $('#file_opened_client_email_review_outstanding').hide('slow');
                    }
                });
            });

            $('#btn_file_opened_email_review_by_client').on('click', function () {
                $('#file_opened_client_email_review').fadeToggle('slow', function () {
                    if ($(this).is(':visible')) {
                        $('#file_opened_email_review').hide('slow');
                        $('#file_opened_client_email_review_outstanding').hide('slow');
                    }
                });
            });
            $('#btn_file_opened_outstanding_ids_client_email').on('click', function () {
                $('#file_opened_client_email_review_outstanding').fadeToggle('slow', function () {
                    if ($(this).is(':visible')) {
                        $('#file_opened_email_review').hide('slow');
                        $('#file_opened_client_email_review').hide('slow');
                    }
                });
            });
            $(document).off('change', 'input[name="email_review_file_opened_checkboxes[]"]').on('change', 'input[name="email_review_file_opened_checkboxes[]"]', function () {
                var checkbox = $(this);
                var labelText = checkbox.siblings('label').text();
                var dataId = checkbox.data('id');
                var ulElement = $('#file_opened_email_selectedLabels');

                if (checkbox.is(':checked')) {
                    ulElement.append('<li style="font-weight:600;" data-id="' + dataId + '">' + labelText + '</li>');
                    // Add the checkbox checked id to the array
                    checkboxIds.push(dataId);
                } else {
                    ulElement.find('li[data-id="' + dataId + '"]').remove();
                    // Remove the checkbox checked id from the array
                    var index = checkboxIds.indexOf(dataId);
                    if (index !== -1) {
                        checkboxIds.splice(index, 1);
                    }
                }
            });
            // Send Login email to the client
            $('#btn_send_login_email').off('click').on('click', function () {
                var confirmed = confirm("Would you like to send the client a login email? If you confirm, their password will be reset and sent to them.");
                if (confirmed) {
                    $('.full-page-loader').show();
                    $.ajax({
                        url: "<?php echo admin_url('leads/send_login_email_to_client/' . $lead->id); ?>",
                        type: 'POST',
                        data: {
                        },
                        success: function (response) {
                            $('.full-page-loader').hide();
                            if (response.success == 1) {
                                alert_float('success', 'Email sent successfully.');
                                // outbox emails records recall
                                fetchOutboxRecords(leadId);
                                appendActivityLogToTop({
                                    id: '',
                                    activity_log_last_id: response.activity_log_last_id,
                                    staffid: '<?php echo get_staff_user_id();?>',
                                    full_name: '<?php echo get_staff_full_name();?>',
                                    staff_image: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    profile_url: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    date_formatted: '',
                                    description: preliminary_instruction_received_editorid,
                                    description_untranslated: preliminary_instruction_received_editorid,
                                    custom_activity: 0
                                });
                            } else {
                                alert_float('danger', 'Email was not sent. Please try again.');
                            }
                        },
                        error: function (error) {
                            $('.full-page-loader').hide();
                            alert_float('danger', 'Error: Email was not sent. Please try again.');
                        }
                    });
                }
            });
            // file review email send
            $(document).off('submit', '#FileOpenReviewMail').on('submit', '#FileOpenReviewMail', function (event) {
                event.preventDefault();

                var file_opened_broker_email_review_tincymac = tinymce.get('file_opened_broker_email_review_tincymac').getContent();
                var cc_fileopenreviewmail = $('#cc_fileopenreviewmail').val();
                var bcc_fileopenreviewmail = $('#bcc_fileopenreviewmail').val();
                var to_fileopenreviewmail = $('#to_fileopenreviewmail').val();
                // Show confirmation dialog
                // var confirmed = confirm("Are you sure you want to send the email?");
                // if (confirmed) {
                    $('#fileopen_broker_loader').addClass('loader');
                    $('#fileopen_broker_submit_btn').prop('disabled', true);
                    $.ajax({
                        url: "<?php echo admin_url('leads/file_opened_review_email_send/' . $lead->id); ?>",
                        type: 'POST',
                        data: {
                            file_opened_client_emailContent: file_opened_broker_email_review_tincymac,
                            to_fileopenreviewmail: to_fileopenreviewmail,
                            cc_fileopenreviewmail: cc_fileopenreviewmail,
                            bcc_fileopenreviewmail: bcc_fileopenreviewmail
                        },
                        success: function (response) {
                            $('#fileopen_broker_loader').removeClass('loader');
                            $('#fileopen_broker_submit_btn').prop('disabled', false);
                            $('#file_opened_email_review').hide();
                            if (response.success == 1) {
                                alert_float('success', 'Email sent successfully.');
                                // outbox emails records recall
                                fetchOutboxRecords(leadId);
                                // appened the activity logs
                                appendActivityLogToTop({
                                    id: '',
                                    activity_log_last_id: response.activity_log_last_id,
                                    staffid: '<?php echo get_staff_user_id();?>',
                                    full_name: '<?php echo get_staff_full_name();?>',
                                    staff_image: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    profile_url: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    date_formatted: '',
                                    description: preliminary_instruction_received_editorid,
                                    description_untranslated: preliminary_instruction_received_editorid,
                                    custom_activity: 0
                                });
                            } else {
                                alert_float('danger', 'Email was not sent. Please try again.');
                            }
                        },
                        error: function (error) {
                            $('#fileopen_broker_loader').removeClass('loader');
                            $('#fileopen_broker_submit_btn').prop('disabled', false);
                            alert_float('danger', 'Error: Email was not sent. Please try again.');
                        }
                    });
                // }
            });
            // File opened client email review
            $(document).off('submit', '#FileOpenClientReviewMail').on('submit', '#FileOpenClientReviewMail', function (event) {
                event.preventDefault();

                var file_opened_client_email_review_tincymac = tinymce.get('file_opened_client_email_review_tincymac').getContent();
                var cc_fileopen_client_reviewmail = $('#cc_fileopen_client_reviewmail').val();
                var bcc_fileopen_client_reviewmail = $('#bcc_fileopen_client_reviewmail').val();
                var to_fileopen_client_reviewmail = $('#to_fileopen_client_reviewmail').val();
                // var account_activitation = $('#account_activitation').val();

                // Show confirmation dialog
                // var confirmed = confirm("Are you sure you want to send the email?");
                // if (confirmed) {
                    $('#fileopen_client_loader').addClass('loader');
                    $('#fileopen_client_submit_btn').prop('disabled', true);
                    // Proceed with AJAX request if user confirms
                    $.ajax({
                        url: "<?php echo admin_url('leads/file_opened_client_review_email_send/' . $lead->id); ?>",
                        type: 'POST',
                        data: {
                            file_opened_client_email_review_tincymac: file_opened_client_email_review_tincymac,
                            cc_fileopen_client_reviewmail: cc_fileopen_client_reviewmail,
                            bcc_fileopen_client_reviewmail: bcc_fileopen_client_reviewmail,
                            to_fileopen_client_reviewmail: to_fileopen_client_reviewmail,
                            // account_activitation: account_activitation
                        },
                        success: function (response) {
                            $('#fileopen_client_loader').removeClass('loader');
                            $('#fileopen_client_submit_btn').prop('disabled', false);
                            $('#file_opened_client_email_review').hide();
                            if (response.success == 1) {
                                alert_float('success', 'Email sent successfully.');
                                // outbox emails records recall
                                fetchOutboxRecords(leadId);
                                appendActivityLogToTop({
                                    id: '',
                                    activity_log_last_id: response.activity_log_last_id,
                                    staffid: '<?php echo get_staff_user_id();?>',
                                    full_name: '<?php echo get_staff_full_name();?>',
                                    staff_image: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    profile_url: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    date_formatted: '',
                                    description: preliminary_instruction_received_editorid,
                                    description_untranslated: preliminary_instruction_received_editorid,
                                    custom_activity: 0
                                });
                            } else {
                                alert_float('danger', 'Email was not sent. Please try again.');
                            }
                        },
                        error: function (error) {
                            $('#fileopen_client_loader').removeClass('loader');
                            $('#fileopen_client_submit_btn').prop('disabled', false);
                            alert_float('danger', 'Error: Email was not sent. Please try again.');
                        }
                    });
                // }
            });
            // file opened outstanding ids mail send
            $(document).off('submit', '#FileOpen_Outstanding_ClientReview_Mail').on('submit', '#FileOpen_Outstanding_ClientReview_Mail', function (event) {
                event.preventDefault();

                var file_opened_client_email_review_outstanding_tincymac = tinymce.get('file_opened_client_email_review_outstanding_tincymac').getContent();
                var cc_fileopen_outstanding_ids_client_reviewmail = $('#cc_fileopen_outstanding_ids_client_reviewmail').val();
                var bcc_fileopen_outstanding_ids_client_reviewmail = $('#bcc_fileopen_outstanding_ids_client_reviewmail').val();
                var to_fileopen_outstanding_ids_client_reviewmail = $('#to_fileopen_outstanding_ids_client_reviewmail').val();
                // var account_activitation = $('#account_activitation').val();

                // Show confirmation dialog
                // var confirmed = confirm("Are you sure you want to send the email?");
                // if (confirmed) {
                    $('#fileopen_client_outstanding_loader').addClass('loader');
                    $('#fileopen_client_outstanding_submit_btn').prop('disabled', true);
                    // Proceed with AJAX request if user confirms
                    $.ajax({
                        url: "<?php echo admin_url('leads/file_opened_outstanding_ids_client_review_email_send/' . $lead->id); ?>",
                        type: 'POST',
                        data: {
                            file_opened_client_email_review_outstanding_tincymac: file_opened_client_email_review_outstanding_tincymac,
                            cc_fileopen_outstanding_ids_client_reviewmail: cc_fileopen_outstanding_ids_client_reviewmail,
                            bcc_fileopen_outstanding_ids_client_reviewmail: bcc_fileopen_outstanding_ids_client_reviewmail,
                            to_fileopen_outstanding_ids_client_reviewmail: to_fileopen_outstanding_ids_client_reviewmail,
                            // account_activitation: account_activitation
                        },
                        success: function (response) {
                            $('#fileopen_client_outstanding_loader').removeClass('loader');
                            $('#fileopen_client_outstanding_submit_btn').prop('disabled', false);
                            $('#file_opened_client_email_review_outstanding').hide();
                            if (response.success == 1) {
                                alert_float('success', 'Email sent successfully.');
                                // outbox emails records recall
                                fetchOutboxRecords(leadId);
                                appendActivityLogToTop({
                                    id: '',
                                    activity_log_last_id: response.activity_log_last_id,
                                    staffid: '<?php echo get_staff_user_id();?>',
                                    full_name: '<?php echo get_staff_full_name();?>',
                                    staff_image: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    profile_url: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    date_formatted: '',
                                    description: preliminary_instruction_received_editorid,
                                    description_untranslated: preliminary_instruction_received_editorid,
                                    custom_activity: 0
                                });
                            } else {
                                alert_float('danger', 'Email was not sent. Please try again.');
                            }
                        },
                        error: function (error) {
                            $('#fileopen_client_outstanding_loader').removeClass('loader');
                            $('#fileopen_client_outstanding_submit_btn').prop('disabled', false);
                            alert_float('danger', 'Error: Email was not sent. Please try again.');
                        }
                    });
                // }
            });
            // file opened review client/borrower mail send code 
            $(document).off('click', '#file_opened_review_mail_to_client').on('click', '#file_opened_review_mail_to_client', function () {
                var checkboxIds = [];
                $('input[name="email_review_file_opened_client_checkboxes[]"]:checked').each(function () {
                    var dataId = $(this).data('id');
                    checkboxIds.push(dataId);
                });
                // Show the confirmation dialog only once, outside the loop
                // var confirmed = confirm("Are you sure you want to send email to the client?");
                // if (confirmed) {
                    $.ajax({
                        url: "<?php echo admin_url('leads/file_opened_review_email_send_to_client/' . $lead->id); ?>",
                        type: 'POST',
                        data: {
                            task_id: checkboxIds,
                        },
                        success: function (response) {
                            if (response.success == 1) {
                                // outbox emails records recall
                                fetchOutboxRecords(leadId);
                                alert_float('success', 'Email Send to the broker successfully.');
                            } else {
                                alert_float('danger', 'Email is not send to the broker,Please try agian.Please Select atleast one item.');
                            }
                        },
                        error: function (error) {
                            alert_float('danger', 'Try Again,Email is not send to the broker,Please Select atleast one item.');
                        }
                    });
                // }
            });
            // appointment request email broker review send 
            $(document).off('submit', '#AppointmentBrokereviewMail').on('submit', '#AppointmentBrokereviewMail', function (event) {
                event.preventDefault();
                var appointment_broker_email_review_tincymac = tinymce.get('appointment_broker_email_review_tincymac').getContent();
                var to_appointment_broker_reviewmail = $('#to_appointment_broker_reviewmail').val();
                var cc_appointment_broker_reviewmail = $('#cc_appointment_broker_reviewmail').val();
                var bcc_appointment_broker_reviewmail = $('#bcc_appointment_broker_reviewmail').val();
                // Show confirmation dialog
                // var confirmed = confirm("Are you sure you want to send the email?");
                // if (confirmed) {
                    // Proceed with AJAX request if user confirms
                    $('#post_appt_broker_loader').addClass('loader');
                    $('#post_appt_broker_submit_button').prop('disabled', true);
                    $.ajax({
                        url: "<?php echo admin_url('leads/appointment_review_broker_email/' . $lead->id); ?>",
                        type: 'POST',
                        data: {
                            appointment_broker_email_review_tincymac: appointment_broker_email_review_tincymac,
                            to_appointment_broker_reviewmail: to_appointment_broker_reviewmail,
                            cc_appointment_broker_reviewmail: cc_appointment_broker_reviewmail,
                            bcc_appointment_broker_reviewmail: bcc_appointment_broker_reviewmail,
                        },
                        success: function (response) {
                            $('#post_appt_broker_loader').removeClass('loader');
                            $('#post_appt_broker_submit_button').prop('disabled', false);
                            $('#appointment_email_review').hide();
                            if (response.success == 1) {
                                // outbox emails records recall
                                fetchOutboxRecords(leadId);
                                alert_float('success', 'Email sent successfully.');
                            } else {
                                alert_float('danger', 'Email was not sent. Please try again.');
                            }
                        },
                        error: function (error) {
                            $('#post_appt_broker_loader').removeClass('loader');
                            $('#post_appt_broker_submit_button').prop('disabled', false);
                            alert_float('danger', 'Error: Email was not sent. Please try again.');
                        }
                    });
                // }
            });
            // after appointment email send to the client 
            $(document).off('submit', '#after_appointment_email_send_to_client').on('submit', '#after_appointment_email_send_to_client', function (event) {
                event.preventDefault();
                var after_appointment_emailContent = tinymce.get('after_appointment_emailContent').getContent();
                var to_after_appointment_reviewmail = $('#to_after_appointment_reviewmail').val();
                var cc_after_appointment_reviewmail = $('#cc_after_appointment_reviewmail').val();
                var bcc_after_appointment_reviewmail = $('#bcc_after_appointment_reviewmail').val();
                // Show confirmation dialog
                // var confirmed = confirm("Are you sure you want to send the email?");
                // if (confirmed) {
                    // Proceed with AJAX request if user confirms
                    $('#after_appointment_email_loader').addClass('loader');
                    $('#after_appointment_email_submit_btn').prop('disabled', true);
                    $.ajax({
                        url: "<?php echo admin_url('leads/after_appointment_email_send_to_client/' . $lead->id); ?>",
                        type: 'POST',
                        data: {
                            after_appointment_emailContent: after_appointment_emailContent,
                            to_after_appointment_reviewmail: to_after_appointment_reviewmail,
                            cc_after_appointment_reviewmail: cc_after_appointment_reviewmail,
                            bcc_after_appointment_reviewmail: bcc_after_appointment_reviewmail,
                        },
                        success: function (response) {
                            $('#after_appointment_email_loader').removeClass('loader');
                            $('#after_appointment_email_submit_btn').prop('disabled', false);
                            $('#after_appointment_email_div').hide();
                            if (response.success == 1) {
                                // outbox emails records recall
                                fetchOutboxRecords(leadId);
                                alert_float('success', 'Email sent successfully.');
                            } else {
                                alert_float('danger', 'Email was not sent. Please try again.');
                            }
                        },
                        error: function (error) {
                            $('#after_appointment_email_loader').removeClass('loader');
                            $('#after_appointment_email_submit_btn').prop('disabled', false);
                            alert_float('danger', 'Error: Email was not sent. Please try again.');
                        }
                    });
                // }
            });
            // outstanding item broker email review
            $(document).off('submit', '#broker_outstanding_emaii_review').on('submit', '#broker_outstanding_emaii_review', function (event) {
                event.preventDefault();
                var broker_outstanding_review_email_tincymac = tinymce.get('broker_outstanding_review_email_tincymac').getContent();
                var to_outstanding_broker_reviewmail = $('#to_outstanding_broker_reviewmail').val();
                var cc_outstanding_broker_reviewmail = $('#cc_outstanding_broker_reviewmail').val();
                var bcc_outstanding_broker_reviewmail = $('#bcc_outstanding_broker_reviewmail').val();
                // Show confirmation dialog
                // var confirmed = confirm("Are you sure you want to send the email?");
                // if (confirmed) {
                    // Proceed with AJAX request if user confirms
                    $('#outstanding_broker_loader').addClass('loader');
                    $('#outstanding_broker_submit_button').prop('disabled', true);
                    $.ajax({
                        url: "<?php echo admin_url('leads/broker_outstanding_email_review/' . $lead->id); ?>",
                        type: 'POST',
                        data: {
                            broker_outstanding_review_email_tincymac: broker_outstanding_review_email_tincymac,
                            to_outstanding_broker_reviewmail: to_outstanding_broker_reviewmail,
                            cc_outstanding_broker_reviewmail: cc_outstanding_broker_reviewmail,
                            bcc_outstanding_broker_reviewmail: bcc_outstanding_broker_reviewmail,
                        },
                        success: function (response) {
                            $('#outstanding_broker_loader').removeClass('loader');
                            $('#outstanding_broker_submit_button').prop('disabled', false);
                            $('#outstanding_item_email_review').hide();
                            if (response.success == 1) {
                                alert_float('success', 'Email sent successfully.');
                                // outbox emails records recall
                                fetchOutboxRecords(leadId);
                                appendActivityLogToTop({
                                    id: '',
                                    activity_log_last_id: response.activity_log_last_id,
                                    staffid: '<?php echo get_staff_user_id();?>',
                                    full_name: '<?php echo get_staff_full_name();?>',
                                    staff_image: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    profile_url: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    date_formatted: '',
                                    description: preliminary_instruction_received_editorid,
                                    description_untranslated: preliminary_instruction_received_editorid,
                                    custom_activity: 0
                                });
                            } else {
                                alert_float('danger', 'Email was not sent. Please try again.');
                            }
                        },
                        error: function (error) {
                            $('#outstanding_broker_loader').removeClass('loader');
                            $('#outstanding_broker_submit_button').prop('disabled', false);
                            alert_float('danger', 'Error: Email was not sent. Please try again.');
                        }
                    });
                // }
            });
            // client oustanding item reivew mail content
            $(document).off('submit', '#client_outstanding_emaii_review').on('submit', '#client_outstanding_emaii_review', function (event) {
                event.preventDefault();
                var client_outstanding_review_email_tincymac = tinymce.get('client_outstanding_review_email_tincymac').getContent();
                var to_outstanding_client_reviewmail = $('#to_outstanding_client_reviewmail').val();
                var cc_outstanding_client_reviewmail = $('#cc_outstanding_client_reviewmail').val();
                var bcc_outstanding_client_reviewmail = $('#bcc_outstanding_client_reviewmail').val();
                // Show confirmation dialog
                // var confirmed = confirm("Are you sure you want to send the email?");
                // if (confirmed) {
                    // Proceed with AJAX request if user confirms
                    $('#outstanding_client_loader').addClass('loader');
                    $('#outstanding_client_submit_btn').prop('disabled', true);
                    $.ajax({
                        url: "<?php echo admin_url('leads/client_outstanding_email_review/' . $lead->id); ?>",
                        type: 'POST',
                        data: {
                            client_outstanding_review_email_tincymac: client_outstanding_review_email_tincymac,
                            to_outstanding_client_reviewmail: to_outstanding_client_reviewmail,
                            cc_outstanding_client_reviewmail: cc_outstanding_client_reviewmail,
                            bcc_outstanding_client_reviewmail: bcc_outstanding_client_reviewmail
                        },
                        success: function (response) {
                            $('#outstanding_client_loader').removeClass('loader');
                            $('#outstanding_client_submit_btn').prop('disabled', false);
                            $('#outstanding_item_client_email_review').hide();
                            if (response.success == 1) {
                                alert_float('success', 'Email sent successfully.');
                                // outbox emails records recall
                                fetchOutboxRecords(leadId);
                                appendActivityLogToTop({
                                    id: '',
                                    activity_log_last_id: response.activity_log_last_id,
                                    staffid: '<?php echo get_staff_user_id();?>',
                                    full_name: '<?php echo get_staff_full_name();?>',
                                    staff_image: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    profile_url: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    date_formatted: '',
                                    description: preliminary_instruction_received_editorid,
                                    description_untranslated: preliminary_instruction_received_editorid,
                                    custom_activity: 0
                                });
                            } else {
                                alert_float('danger', 'Email was not sent. Please try again.');
                            }
                        },
                        error: function (error) {
                            $('#outstanding_client_loader').removeClass('loader');
                            $('#outstanding_client_submit_btn').prop('disabled', false);
                            alert_float('danger', 'Error: Email was not sent. Please try again.');
                        }
                    });
                // }
            });
            // client outstanding item sms send
            $(document).off('submit', '#client_outstanding_sms_review').on('submit', '#client_outstanding_sms_review', function (event) {
                event.preventDefault();
                var outstanding_client_sms = $('#outstanding_client_sms').val();
                // Show confirmation dialog
                // var confirmed = confirm("Are you sure you want to send the SMS?");
                // if (confirmed) {
                    $.ajax({
                        url: "<?php echo admin_url('leads/client_outstanding_sms_review/' . $lead->id); ?>",
                        type: 'POST',
                        data: {
                            outstanding_client_sms: outstanding_client_sms,
                        },
                        success: function (response) {
                            if (response.success == 1) {
                                alert_float('success', 'SMS sent successfully.');
                                $('#outstanding_item_client_sms_review').hide();
                                // outbox emails records recall
                                fetchOutboxRecords(leadId);
                                appendActivityLogToTop({
                                    id: '',
                                    activity_log_last_id: response.activity_log_last_id,
                                    staffid: '<?php echo get_staff_user_id();?>',
                                    full_name: '<?php echo get_staff_full_name();?>',
                                    staff_image: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    profile_url: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    date_formatted: '',
                                    description: preliminary_instruction_received_editorid,
                                    description_untranslated: preliminary_instruction_received_editorid,
                                    custom_activity: 0
                                });
                            } else {
                                alert_float('danger', 'SMS was not sent. Please try again.');
                            }
                        },
                        error: function (error) {
                            alert_float('danger', 'Error: SMS was not sent. Please try again.');
                        }
                    });
                // }
            });
        }); 
    </script>
    <script>
        $(document).ready(function () {
            function destroyTinyMCE() {
                tinymce.remove();
                if (tinymce.editors.length > 0) {
                    tinymce.editors.forEach(function (editor) {
                        editor.remove();
                    });
                }
            }
            // this variable is import to use
            // outstanding item broker line of code
            var checkboxIds = [];
            $('#btn_outstanding_email_review').on('click', function () {
                $('#outstanding_item_email_review').fadeToggle('slow', function () {
                    if ($(this).is(':visible')) {
                        $('#outstanding_item_client_email_review').hide('slow');
                        $('#outstanding_item_client_sms_review').hide('slow');
                    }
                });
            });

            $('#btn_outstanding_client_email_review').on('click', function () {
                $('#outstanding_item_client_email_review').fadeToggle('slow', function () {
                    if ($(this).is(':visible')) {
                        $('#outstanding_item_email_review').hide('slow');
                        $('#outstanding_item_client_sms_review').hide('slow');
                    }
                });
            });
            $('#btn_outstanding_client_sms_review').on('click', function () {
                $('#outstanding_item_client_sms_review').fadeToggle('slow', function () {
                    if ($(this).is(':visible')) {
                        $('#outstanding_item_email_review').hide('slow');
                        $('#outstanding_item_client_email_review').hide('slow');
                    }
                });
            });
            $(document).off('change', 'input[name="email_review_outstanding_item_checkboxes[]"]').on('change', 'input[name="email_review_outstanding_item_checkboxes[]"]', function () {
                var checkbox = $(this);
                var labelText = checkbox.siblings('label').text();
                var dataId = checkbox.data('id');
                var ulElement = $('#outstanding_item_email_selectedLabels');

                if (checkbox.is(':checked')) {
                    ulElement.append('<li style="font-weight:600;" data-id="' + dataId + '">' + labelText + '</li>');
                    // Add the checkbox checked id to the array
                    checkboxIds.push(dataId);
                } else {
                    ulElement.find('li[data-id="' + dataId + '"]').remove();
                    // Remove the checkbox checked id from the array
                    var index = checkboxIds.indexOf(dataId);
                    if (index !== -1) {
                        checkboxIds.splice(index, 1);
                    }
                }
            });
            // outstanding item for client email review button  
            $(document).off('change', 'input[name="client_email_review_outstanding_item_checkboxes[]"]').on('change', 'input[name="client_email_review_outstanding_item_checkboxes[]"]', function () {
                var checkbox = $(this);
                var labelText = checkbox.siblings('label').text();
                var dataId = checkbox.data('id');
                var ulElement = $('#outstanding_item_client_email_selectedLabels');

                if (checkbox.is(':checked')) {
                    ulElement.append('<li style="font-weight:600;" data-id="' + dataId + '">' + labelText + '</li>');
                    // Add the checkbox checked id to the array
                    checkboxIds.push(dataId);
                } else {
                    ulElement.find('li[data-id="' + dataId + '"]').remove();
                    // Remove the checkbox checked id from the array
                    var index = checkboxIds.indexOf(dataId);
                    if (index !== -1) {
                        checkboxIds.splice(index, 1);
                    }
                }
            });
        });
    </script>
    <script>
        $(document).ready(function () {
            function destroyTinyMCE() {
                tinymce.remove();
                if (tinymce.editors.length > 0) {
                    tinymce.editors.forEach(function (editor) {
                        editor.remove();
                    });
                }
            }
            // this variable is import to use
            var checkboxIds = [];
            var leadId = '<?php echo $lead->id;?>';
            // $('#btn_appointment_email_review').on('click', function () {
            //     $('#appointment_email_review').fadeToggle('slow');
            //     $('#after_appointment_email_div').fadeOut('slow');
            // });

            // $('#btn_client_appointment_email_review').on('click', function () {
            //     $('#after_appointment_email_div').fadeToggle('slow');
            //     $('#appointment_email_review').fadeOut('slow');
                
            //         $('#client_appointment_email_review').fadeToggle('slow');
            //         $('#outstanding_item_client_email_review').fadeToggle('slow');
            //         $('a[href="#outstanding_items"]').tab('show');
            //         $('a[href="#outstanding_items"]').closest('div').addClass('step-active');
            //         $('a[href="#lead_reminders"]').closest('div').removeClass('step-active');
            //         // $('#outstanding_item_client_email_review').animate({ scrollTop: $('#outstanding_item_client_email_review')[0].scrollHeight }, 'slow');
            //         $('#btn_outstanding_client_sms_review').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
            // });
            // $('#confirmation_appointment_to_broker').on('click', function () {
            //     $('#broker_appointment_emailForm').fadeToggle('slow');
            //     $('#lender_appointment_emailForm').fadeOut('slow');
            // });

            // $('#confirmation_appointment_to_lender').on('click', function () {
            //     $('#lender_appointment_emailForm').fadeToggle('slow');
            //     $('#broker_appointment_emailForm').fadeOut('slow');
            // });
            function hideAllEmailSections(exceptSelector) {
                const sections = [
                    '#appointment_email_review',
                    '#after_appointment_email_div',
                    '#broker_appointment_emailForm',
                    '#lender_appointment_emailForm',
                    '#appt_draft_email_section'
                ];
                
                sections.forEach(selector => {
                    if (selector !== exceptSelector) {
                        $(selector).fadeOut('slow');
                    }
                });
            }

            $('#btn_appointment_email_review').on('click', function () {
                hideAllEmailSections('#appointment_email_review');
                $('#appointment_email_review').fadeToggle('slow');
            });

            $('#btn_client_appointment_email_review').on('click', function () {
                hideAllEmailSections('#after_appointment_email_div');
                $('#after_appointment_email_div').fadeToggle('slow');
            });

            $('#confirmation_appointment_to_broker').on('click', function () {
                hideAllEmailSections('#broker_appointment_emailForm');
                $('#broker_appointment_emailForm').fadeToggle('slow');
            });

            $('#confirmation_appointment_to_lender').on('click', function () {
                hideAllEmailSections('#lender_appointment_emailForm');
                $('#lender_appointment_emailForm').fadeToggle('slow');
            });
             $('#appt_draft_emails_btn').on('click', function () {
                hideAllEmailSections('#appt_draft_email_section');
                $('#appt_draft_email_section').fadeToggle('slow');
            });
            
            // $('.draft-email-card').on('click', function() {
            //     $('.email-form-section').hide();
            //     $($(this).data('target')).slideDown();
            // });
            // draft email section toggle
            $(document).off('click', '.draft-email-card').on('click', '.draft-email-card', function (e) {
                // Prevent toggle if click was on delete button
                if ($(e.target).closest('.delete-draft-btn').length) {
                    return;
                }
                const target = $(this).data('target');
                $(target).slideToggle();
            });



            $(document).off('change', '#email_review_appointment_checkboxes').on('change', '#email_review_appointment_checkboxes', function () {
                var checkbox = $(this);
                var labelText = checkbox.siblings('label').text();
                var dataId = checkbox.data('id');
                var ulElement = $('#appointment_email_selectedLabels');

                if (checkbox.is(':checked')) {
                    ulElement.append('<li style="font-weight:600;" data-id="' + dataId + '">' + labelText + '</li>');
                    // add the checkbox checked id in the array
                    checkboxIds.push(dataId);
                } else {
                    ulElement.find('li[data-id="' + dataId + '"]').remove();
                    // remove the checkbox checked id in the array
                    var index = checkboxIds.indexOf(dataId);
                    if (index !== -1) {
                        checkboxIds.splice(index, 1);
                    }
                }
            });

            // send the client appointment review mail
            $(document).off('submit', '#emailForm').on('submit', '#emailForm', function (event) {
                event.preventDefault();
                // Show confirmation alert
                // var userConfirmed = confirm('Are you sure you want to send this email?');
                // if (userConfirmed) {
                    // Serialize the form data
                    var formData = $(this).serialize();
                    $('#appt_client_loader').addClass('loader');
                    $('#appt_client_submit_button').prop('disabled', true);
                    $.ajax({
                        url: "<?php echo admin_url('leads/client_appointment_review_email_send/' . $lead->id); ?>",
                        type: 'POST',
                        data: formData,
                        success: function (response) {
                            $('#appt_client_loader').removeClass('loader');
                            $('#appt_client_submit_button').prop('disabled', false);
                            if (response.success) {
                                alert_float('success', 'Email sent successfully!');
                                $('#client_appointment_email_review').hide();
                                // outbox emails records recall
                                fetchOutboxRecords(leadId);

                                appendActivityLogToTop({
                                    id: '',
                                    activity_log_last_id: response.activity_log_last_id,
                                    staffid: '<?php echo get_staff_user_id();?>',
                                    full_name: '<?php echo get_staff_full_name();?>',
                                    staff_image: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    profile_url: ' <?php echo staff_profile_image(get_staff_user_id(), ['staff-profile-xs-image pull-left mright5']);?>',
                                    date_formatted: '',
                                    description: preliminary_instruction_received_editorid,
                                    description_untranslated: preliminary_instruction_received_editorid,
                                    custom_activity: 0
                                });
                            } else {
                                alert_float('danger', 'Email was not sent,Please try again!');
                            }
                        },
                        error: function (jqXHR, textStatus, errorThrown) {
                            $('#appt_client_submit_button').prop('disabled', false);
                            $('#appt_client_loader').removeClass('loader');
                            console.error('An error occurred: ' + textStatus + ' - ' + errorThrown);
                        }
                    });
                // }
            });
            // save the appt emails as a draft
            $(document).off('click', '#appt_client_draft_email_btn').on('click', '#appt_client_draft_email_btn', function (event) {
                var formData = {
                    to: $('#to_client_appointment_reviewmail').val(),
                    cc: $('#cc_client_appointment_reviewmail').val(),
                    bcc: $('#bcc_client_appointment_reviewmail').val(),
                    content: tinymce.get('appointment_client_emailContent').getContent(),
                    leads_status: '7',
                    type: 'appt-email-client'
                };
                $('.full-page-loader').show();
                $.ajax({
                    url: "<?php echo admin_url('leads/save_appt_client_email_draft/' . $lead->id); ?>",
                    type: 'POST',
                    data: formData,
                    success: function (response) {
                        if(response.success){
                            $('.full-page-loader').hide();
                        //     destroyTinyMCE();
                        //     _lead_init_data(response, response.lead_id);
                        //     $('a[href="#lead_reminders"]').closest('div').addClass('step-active');
                        //     var anchor = document.querySelector('a[href="#lead_reminders"]');
                        //     anchor.click();
                        }
                    },
                    error: function () {
                        $('.full-page-loader').hide();
                    }
                });
            });
            // send appointment confirm email send to the broker 
            $(document).off('submit', '#broker_appointment_emailForm').on('submit', '#broker_appointment_emailForm', function (event) {
                event.preventDefault();
                // var userConfirmed = confirm('Are you sure you want to send this email?');
                // if (userConfirmed) {
                    // Serialize the form data
                    var formData = $(this).serialize();
                    $('#appt_broker_loader').addClass('loader');
                    $('#appt_broker_submit_button').prop('disabled', true);
                    $.ajax({
                        url: "<?php echo admin_url('leads/broker_appointment_review_email_send/' . $lead->id); ?>",
                        type: 'POST',
                        data: formData,
                        success: function (response) {
                            $('#appt_broker_loader').removeClass('loader');
                            $('#appt_broker_submit_button').prop('disabled', false);
                            $('#broker_appointment_emailForm').hide();
                            if (response.success) {
                                alert_float('success', 'Email sent successfully!');
                            } else {
                                alert_float('danger', 'Email was not sent,Please try again!');
                            }
                        },
                        error: function (jqXHR, textStatus, errorThrown) {
                            $('#appt_broker_loader').removeClass('loader');
                            $('#appt_broker_submit_button').prop('disabled', false);
                            console.error('An error occurred: ' + textStatus + ' - ' + errorThrown);
                        }
                    });
                // }
            });
            // send lender appointmetn mail to the broker
            $(document).off('submit', '#lender_appointment_emailForm').on('submit', '#lender_appointment_emailForm', function (event) {
                event.preventDefault();
                // var userConfirmed = confirm('Are you sure you want to send this email?');
                // if (userConfirmed) {
                    // Serialize the form data
                    var formData = $(this).serialize();
                    $('#appt_lender_loader').addClass('loader');
                    $('#appt_lender_submit_button').prop('disabled', true);
                    $.ajax({
                        url: "<?php echo admin_url('leads/lender_appointment_review_email_send/' . $lead->id); ?>",
                        type: 'POST',
                        data: formData,
                        success: function (response) {
                            $('#appt_lender_loader').removeClass('loader');
                            $('#appt_lender_submit_button').prop('disabled', false);
                            $('#lender_appointment_emailForm').hide();
                            fetchOutboxRecords(leadId);
                            if (response.success) {
                                $("#confirm_lender_apt_email_reminder").hide();
                                alert_float('success', 'Email sent successfully!');
                            } else {
                                alert_float('danger', 'Email was not sent,Please try again!');
                            }
                        },
                        error: function (jqXHR, textStatus, errorThrown) {
                            $('#appt_lender_loader').removeClass('loader');
                            $('#appt_lender_submit_button').prop('disabled', false);
                            console.error('An error occurred: ' + textStatus + ' - ' + errorThrown);
                        }
                    });
                // }
            });
        });
    </script>
    <!-- id verification question hide and show -->
    <script>
        $(document).ready(function () {
            function destroyTinyMCE() {
                tinymce.remove();
                if (tinymce.editors.length > 0) {
                    tinymce.editors.forEach(function (editor) {
                        editor.remove();
                    });
                }
            }
            $('#idv_received').change(function () {
                var selectedValue = $(this).val();
                if (selectedValue === 'yes') {
                    $('#idv_pass_check').show();
                    $('#id_verification_file_div').show();
                    $('#idv_received_no_div_tinymce').hide();
                    // idv cc and bcc show
                    $('#idv_pass_cc_fields').hide();
                } else if (selectedValue === 'no') {
                    $('#idv_pass_check').hide();
                    $('#id_verification_file_div').hide();
                    $('#idv_received_no_div_tinymce').show();
                    // idv pass tinymce hide
                    $('#idv_received_yes_pass_no_div_tinymce').hide();
                    $('#idv_received_yes_pass_yes_div_tinymce').hide();
                    // idv cc and bcc show
                    $('#idv_pass_cc_fields').show();
                } else {
                    $('#idv_pass_check').hide();
                    $('#id_verification_file_div').hide();
                    $('#idv_received_no_div_tinymce').hide();
                    // idv pass tinymce hide
                    $('#idv_received_yes_pass_no_div_tinymce').hide();
                    $('#idv_received_yes_pass_yes_div_tinymce').hide();
                    // idv cc and bcc show
                    $('#idv_pass_cc_fields').hide();
                }
            });
            $('#idv_received_pass').change(function () {
                var selectedValue = $(this).val();
                if (selectedValue === 'yes') {
                    $('#idv_received_yes_pass_yes_div_tinymce').show();
                    $('#idv_received_yes_pass_no_div_tinymce').hide();
                    // idv cc and bcc show
                    $('#idv_pass_cc_fields').show();
                } else if (selectedValue === 'no') {
                    $('#idv_received_yes_pass_yes_div_tinymce').hide();
                    $('#idv_received_yes_pass_no_div_tinymce').show();
                    // idv cc and bcc show
                    $('#idv_pass_cc_fields').show();
                } else {
                    $('#idv_received_yes_pass_yes_div_tinymce').hide();
                    $('#idv_received_yes_pass_no_div_tinymce').hide();
                    // idv cc and bcc show
                    $('#idv_pass_cc_fields').hide();
                }
            });
            $('#dl_check_completed_begin_through').change(function () {
                var selectedValue = $(this).val();
                if (selectedValue === 'yes') {
                    $('#dl_check_completed_at_div_begin_through').show();
                } else {
                    $('#dl_check_completed_at_div_begin_through').hide();
                    $('#dl_check_completed_at').val('');
                }
            });
            $('#dl_check_completed_received').change(function () {
                var selectedValue = $(this).val();
                if (selectedValue === 'yes') {
                    $('#dl_check_completed_at_div_received').show();
                } else {
                    $('#dl_check_completed_at_div_received').hide();
                    $('#dl_check_completed_at').val('');
                }
            });
            $('#ledger_notes_check').on('change', function () {
                var selectedValue = $(this).val();
                if (selectedValue === 'Yes') {
                    $('#ld_note_div').show();
                } else {
                    $('#ld_note_div').hide();
                }
            });
            $('#show_appointment_details').click(function () {
                $('#appointment_form_show').show();
                setTimeout(function () {
                    $('#appointment_form_show').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                }, 200);
            });
            // call the appointment details add using ajax
            $('#add_appointment_details').submit(function (event) {
                event.preventDefault();
                // if (confirm('Are you sure you want to submit the form?')) {
                    $('#appointment_details_loader').addClass('loader');
                    // Disable the submit button
                    $('#appointment_detail_btn').attr('disabled', 'disabled');
                    // If the user clicks "OK", proceed with the AJAX call
                    $.ajax({
                        type: 'POST',
                        url: "<?php echo admin_url('leads/appointment_details_add/' . $lead->id); ?>",
                        data: $(this).serialize(),
                        success: function (response) {
                            if (response.success) {
                                $('#add_appointment_details')[0].reset();
                                $('#appointment_details_loader').removeClass('loader');
                                $('#appointment_detail_btn').removeAttr('disabled');
                                destroyTinyMCE();
                                leads_kanban();
                                _lead_init_data(response, response.id);
                                if (response.leads_status === "#lead_reminders") {
                                    $('a[href="#lead_reminders"]').closest('div').addClass('step-active');
                                    var anchor = document.querySelector('a[href="#lead_reminders"]');
                                    anchor.click();
                                } else {
                                    $('a[href="#outstanding_items"]').closest('div').addClass('step-active');
                                    var anchor = document.querySelector('a[href="#outstanding_items"]');
                                    anchor.click();
                                }
                                alert_float('success', 'Data added successfully.');
                            }
                        },
                        error: function (xhr, status, error) {
                            $('#add_appointment_details')[0].reset();
                            $('#appointment_details_loader').removeClass('loader');
                            $('#appointment_detail_btn').removeAttr('disabled');
                            alert_float('danger', 'Data not added Please try again!');
                        }
                    });
                // }
            });
            // Fetch details of appointment details 
            function fetchAppointmentDetails() {
                $.ajax({
                    type: 'GET',
                    url: "<?php echo admin_url('leads/get_appointment_details/' . $lead->id); ?>",
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            // Call the function to display the data in the table
                            displayAppointmentDetails(response.data);
                        } else {

                        }
                    },
                    error: function (xhr, status, error) {
                        console.error('An error occurred while fetching the details: ' + error);
                    }
                });
            }

            // Function to display the appointment details in a table
            function displayAppointmentDetails(data) {
                let tableBody = $('#appointmentDetailsTable tbody');
                tableBody.empty();
                data.forEach(function (item) {
                    var purposeFundsHtml = "<ul><li>" + (item.appointment_purpose_funds || '').replace(/\n/g, '</li><li>') + "</li></ul>";
                    var purposeFundsCell = $("<td>").html(purposeFundsHtml);
                    var idSeenHtml = "<ul><li>" + (item.appointment_id_seen || '').replace(/\n/g, '</li><li>') + "</li></ul>";
                    var idSeenCell = $("<td>").html(idSeenHtml);
                    var notesHtml = "<ul><li>" + (item.appointment_notes || '').replace(/\n/g, '</li><li>') + "</li></ul>";
                    var notesCell = $("<td>").html(notesHtml);
                    var VC_notesHtml = "<ul><li>" + (item.vc_confirmation || '').replace(/\n/g, '</li><li>') + "</li></ul>";
                    var VC_Cell = $("<td>").html(VC_notesHtml);
                    var actioncell = $("<td>").text(item.action_by);
                    var createdAtCell = $("<td>").text(item.appointment_details_created_at);
                    var newRow = $("<tr>");
                    newRow.append(purposeFundsCell);
                    newRow.append(idSeenCell);
                    newRow.append(notesCell);
                    newRow.append(VC_Cell);
                    newRow.append(actioncell);
                    newRow.append(createdAtCell);
                    $('#appointmentDetailsTable tbody').append(newRow);
                });
            }
            // Call the function to fetch and display appointment details
            fetchAppointmentDetails();
        });
    </script>
    <script>
        // Event delegation for dynamically created elements 
        $(document).ready(function () {
            function destroyTinyMCE() {
                tinymce.remove();
                if (tinymce.editors.length > 0) {
                    tinymce.editors.forEach(function (editor) {
                        editor.remove();
                    });
                }
            }

            var sameGroup = '<?php echo $samegroup; ?>';
            // open modal for file opened
            $(document).off('click', '[name="file_open_checkbox_upload_doc_button"]').on('click', '[name="file_open_checkbox_upload_doc_button"]', function (e) {
                e.preventDefault();
                var task_id = $(this).data('id');
                var leadid = '<?php echo $lead->id; ?>';
                $.ajax({
                    url: "<?php echo admin_url('leads/get_task_record_by_task_id'); ?>",
                    method: 'GET',
                    dataType: 'json',
                    data: {
                        task_id: task_id
                    },
                    success: function (response) {
                        if (response.success) {
                            // Set the value of the input/textarea
                            if (response.leads_status == 3 || response.type == 'other') {
                                var htmlContent = response.ld_notes;
                                var plainTextContent = $('<div>').html(htmlContent).text();
                                $('#ld_notes').val(plainTextContent);
                                $('#ld_notes_toggle').show();
                            } else {
                                $('#ld_notes').val('');
                                $('#ld_notes_toggle').hide();
                            }
                            // remove validation for item name (Void cheque) and (Post app VC check: bank name ABC, last 3 digits 486 for net funds - if cheque not available, call cl)
                            // var taskNamePattern = /Post\s+app\s+VC\s+check:\s+bank\s+name\s+ABC,\s+last\s+3\s+digits\s+486\s+for\s+net\s+funds\s+-\s+if\s+cheque\s+not\s+available,\s+call\s+cl/i;
                            var taskNamePattern = /(Void\s+cheque\(s\))|(Post\s+app\s+VC\s+check:\s+bank\s+name\s+ABC,\s+last\s+3\s+digits\s+486\s+for\s+net\s+funds\s+-\s+if\s+cheque\s+not\s+available,\s+call\s+cl)/i;
                            // Check if the response.name matches the pattern
                            if (taskNamePattern.test(response.name)) {
                                appendInputAndRemovePrevious_for_fileopened('remove_validation', 1);
                            } else {
                                appendInputAndRemovePrevious_for_fileopened('remove_validation', 0);
                            }
                        } else {
                            console.error('Failed to fetch task record:', response.message);
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error('AJAX error:', status, error);
                    }
                });
                // Set the title text and show the modal
                appendInputAndRemovePrevious_for_fileopened('task_id', task_id);
                $('#file_opened_modal_upload_doc').modal('show');
                // Scroll the modal into view
                setTimeout(function () {
                    $('#file_opened_modal_upload_doc').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                }, 200);
            });
            // open modal for outstanding item
            $(document).on('click', '[name="outstanding_item_checkbox_upload_doc_button"]', function (e) {
                e.preventDefault(); 

                var task_id = $(this).data('id');
                // Set the title text and show the modal
                appendInputAndRemovePrevious_for_oustanding_item('task_id', task_id);
                $('#outstanding_item_modal_upload_doc').modal('show');
                // Scroll the modal into view
                setTimeout(function () {
                    $('#outstanding_item_modal_upload_doc').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                }, 200);
            });
            // Event delegation for dynamically created elements
            $(document).off('click', '.delete_checklist_item_image').on('click', '.delete_checklist_item_image', function (e) {
                e.preventDefault();

                var itemId = $(this).data('id');
                // Show confirmation dialog
                // var confirmation = confirm("Are you sure you want to delete this item?");

                // if (confirmation) {
                    // Send AJAX request if confirmed
                    $('.full-page-loader').show();
                    setTimeout(function () {
                        $('#full_page_loader').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                    }, 200);
                    $.ajax({
                        url: "<?php echo admin_url('leads/checklist_image_delete/' . $lead->id); ?>",
                        type: 'POST',
                        data: { id: itemId },
                        success: function (response) {
                            if (response.status === 'success') {
                                $('.full-page-loader').hide();
                                alert_float('success', 'Image deleted successfully.');
                                destroyTinyMCE();
                                _lead_init_data(response, response.lead_id);
                                if (sameGroup == 2) {
                                    if (response.leads_status == '#file_opened') {
                                        $('a[href="#file_opened"]').tab('show');
                                    } else {
                                        $('a[href="#summary"]').tab('show');
                                    }
                                } else {
                                    $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                    $('a[href="' + response.leads_status + '"]').tab('show');
                                }
                            } else {
                                // alert(response.message);
                            }
                        },
                        error: function (xhr, status, error) {
                            $('.full-page-loader').hide();
                        }
                    });
                // }
            });
        });

    </script>
    <!-- send the funds requested mail -->
    <script>
        $(document).ready(function () {
            function destroyTinyMCE() {
                tinymce.remove();
                if (tinymce.editors.length > 0) {
                    tinymce.editors.forEach(function (editor) {
                        editor.remove();
                    });
                }
            }
            var leadId = '<?php echo $lead->id;?>';
            // fetch the request for funds emails
            function activity_details_show_according_to_the_stage(lead_status, activity_type, tableid) {
                $.ajax({
                    url: "<?php echo admin_url('leads/get_activity_emails'); ?>",
                    type: 'POST',
                    data: {
                        'lead_id': '<?php echo $lead->id; ?>',
                        'lead_status': lead_status,
                        'activity_type': activity_type
                    },
                    success: function(response) {
                        if (response.success) {
                            populateActivityTable(response.data, tableid);
                        } else {
                            $(tableid + ' tbody').html('<tr><td colspan="3" class="text-center">No activity found.</td></tr>');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error("Error fetching activity log:", error);
                    }
                });
            }

            function populateActivityTable(data, tableid) {
                let tableBody = $(tableid + ' tbody');
                tableBody.empty();

                data.forEach(function(row) {
                    let tableRow = `<tr>
                        <td>${row.full_name}</td>
                        <td>${row.description}</td>
                        <td>${row.date}</td>
                    </tr>`;
                    tableBody.append(tableRow);
                });
            }
            // request for funds activiy emails add
            activity_details_show_according_to_the_stage(4,'broker-notification-funds-requested', '#fundsActivityTable');
            // cloase activity emails
            activity_details_show_according_to_the_stage(5,'closed-emails', '#closedActivityTable');
            
            // Attach click event handler to a parent element using event delegation
            $(document).off('click', '#broker_mail_funds_requested').on('click', '#broker_mail_funds_requested', function (e) {
                e.preventDefault();
                // var confirmation = confirm("Are you sure you want to send the email to the broker for funds requested?");

                // if (confirmation) {
                    $('.full-page-loader').show();
                    $.ajax({
                        url: "<?php echo admin_url('leads/broker_mail_funds_requested/' . $lead->id); ?>", 
                        type: 'POST',
                        data: {},
                        success: function (response) {
                            $('.full-page-loader').hide();
                            // outbox details refresh when email sent
                            fetchOutboxRecords(leadId);
                            alert_float('success', 'Email send to broker successfully.');
                        },
                        error: function (xhr, status, error) {
                            $('.full-page-loader').hide();
                            alert_float('danger', 'Email could not send please try again.');
                        }
                    });
                // }
            });
            // send report mail to client in request for funds stage 
            $(document).off('click', '#send_report_to_client').on('click', '#send_report_to_client', function (e) {
                e.preventDefault(); 

                // Show confirmation dialog
                // var confirmation = confirm("Are you sure you want to send the report mail to the client?");

                // if (confirmation) {
                    $.ajax({
                        url: "<?php echo admin_url('leads/request_for_funds_report_mail/' . $lead->id); ?>", 
                        type: 'POST',
                        data: {},
                        success: function (response) {
                            alert_float('success', 'Email send to client successfully.');
                        },
                        error: function (xhr, status, error) {
                            alert_float('danger', 'Email could not send please try again.');
                        }
                    });
                // }
            });
        });
    </script>

    <script>
        $(document).ready(function () {
            function destroyTinyMCE() {
                tinymce.remove();
                if (tinymce.editors.length > 0) {
                    tinymce.editors.forEach(function (editor) {
                        editor.remove();
                    });
                }
            }
        });
    </script>
    <!-- ledger complete and undo stage -->
    <script>
        $(document).ready(function () {
            function destroyTinyMCE() {
                tinymce.remove();
                if (tinymce.editors.length > 0) {
                    tinymce.editors.forEach(function (editor) {
                        editor.remove();
                    });
                }
            }
            $('#complete_stage_ledger').off('click').on('click', function () {
                var lead_id = $('#lead_id').val();
                // if (confirm("Are you sure you want to complete the Ledger stage?")) {
                    $('.full-page-loader').show();
                    setTimeout(function () {
                        $('#full_page_loader').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                    }, 200);
                    $.ajax({
                        url: '<?php echo base_url('admin/leads/checklist_complete_stage_ledger'); ?>',
                        type: 'POST',
                        data: {
                            lead_id: lead_id,
                        },
                        success: function (response) {
                            $('.full-page-loader').hide();
                            destroyTinyMCE();
                            leads_kanban();
                            // outbox emails records recall
                            fetchOutboxRecords(response.id);
                            _lead_init_data(response, response.id);
                            $('a[href="#request_for_funds"]').closest('div').addClass('step-active');
                            if (response.leads_status === "#request_for_funds") {
                                var anchor = document.querySelector('a[href="#request_for_funds"]');
                                anchor.click();
                            }
                            alert_float('success', 'Your case status updated successfully.');
                        },
                        error: function (error) {
                        }
                    });
                // }
            });
            // move case on hold column
            $('#hold-case-form').on('submit', function (e) {
                e.preventDefault();
                var lead_id = $('#lead_id').val();
                $('#error-message').hide().text('');
                const holdReason = $('#holdReason').val().trim();
                if (holdReason === '') {
                    $('#error-message').text('Hold case reason is required.').show();
                    return;
                }
                $.ajax({
                    url: '<?php echo admin_url('leads/move_to_on_hold/'); ?>',
                    type: 'POST',
                    data: {
                        holdReason: holdReason,
                        lead_id: lead_id
                    },
                    success: function (response) {
                        if (response.success) {
                            alert_float('success', 'Hold case reason submitted successfully!');
                            $('#holdReason').val('');
                            destroyTinyMCE();
                            leads_kanban();
                            _lead_init_data(response, response.id);
                            $('a[href="#on_hold"]').closest('div').addClass('step-active');
                            var anchor = document.querySelector('a[href="#on_hold"]');
                            anchor.click();
                        }
                    },
                    error: function (xhr, status, error) {
                        $('#error-message').text('An error occurred. Please try again.').show();
                    }
                });
            });
            // Undo stage 
            $('#undo_stage_ledger').on('click', function () {
                var lead_id = $('#lead_id').val();
                // Display confirmation dialog
                // if (confirm("Are you sure you want to complete the Ledger stage?")) {
                    // User clicked OK, perform AJAX request
                    $('.full-page-loader').show();
                    $.ajax({
                        url: '<?php echo base_url('admin/leads/checklist_undo_stage_ledger'); ?>',
                        type: 'POST',
                        data: {
                            lead_id: lead_id,
                        },
                        success: function (response) {
                            $('.full-page-loader').hide();
                            destroyTinyMCE();
                            leads_kanban();
                            _lead_init_data(response, response.id);
                            $('a[href="#outstanding_items"]').closest('div').addClass('step-active');
                            if (response.leads_status === "#outstanding_items") {
                                var anchor = document.querySelector('a[href="#outstanding_items"]');
                                anchor.click();
                            }
                            alert_float('success', 'Your case status updated successfully.');
                        },
                        error: function (error) {
                            $('.full-page-loader').hide();
                        }
                    });
                // }
            });
        });
    </script>
    <script>
        // ledger document upload function
        $(document).ready(function () {
            var is_admin = '<?php echo is_admin();?>';
            var leadId = '<?php echo $lead->id;?>';
            function destroyTinyMCE() {
                tinymce.remove();
                if (tinymce.editors.length > 0) {
                    tinymce.editors.forEach(function (editor) {
                        editor.remove();
                    });
                }
            }
            $('#upload_doc_for_ledger').off('submit').on('submit', function (e) {
                e.preventDefault();
                var ledger_type = $('#ledger_type').val();
                var files = $('#ledger_userfile')[0].files;
                var valid = true;
                var errorMsg = '';
                if (ledger_type != 'broker') {
                    if (files.length === 0) {
                        valid = false;
                        errorMsg = 'Please select at least one file.';
                    } else {
                        for (var i = 0; i < files.length; i++) {
                            var file = files[i];
                            var fileType = file.type;
                            var validTypes = [
                                'application/pdf',
                                'image/jpeg',
                                'image/png',
                                'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
                                'application/msword',
                                'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
                                'application/vnd.ms-excel'
                            ];

                            if (!validTypes.includes(fileType)) {
                                valid = false;
                                errorMsg = 'Invalid file type. Only PDF, JPEG, JPG, PNG,Xlxs, and DOCX files are allowed.';
                                break;
                            }

                            if (file.size > 10 * 1024 * 1024) {
                                valid = false;
                                errorMsg = 'File size should not exceed 10MB.';
                                break;
                            }
                        }
                    }
                }
                if (!valid) {
                    $('#ledger_userfile_error').text(errorMsg);
                } else {
                    $('#ledger_userfile_error').text('');
                    // $('#file_opened_submit_button').prop('disabled', true);
                    $('#ledger_loader').addClass('loader');
                    // Disable the submit button
                    $('#ledger_doc_submit_button').attr('disabled', 'disabled');
                    // Prepare form data for AJAX submission
                    var formData = new FormData(this);
                    var tinymceContent = tinymce.get('send_approved_ledger_to_broker_tinymce').getContent();
                    formData.append('send_approved_ledger_to_broker_tinymce', tinymceContent);
                    $.ajax({
                        url: $(this).attr('action'),
                        type: 'POST',
                        data: formData,
                        contentType: false,
                        processData: false,
                        success: function (response) {
                            if (response.success) {
                                $('#upload_doc_for_ledger')[0].reset();
                                $('#ledger_loader').removeClass('loader');
                                var close = document.querySelector('.close');
                                close.click();
                                var anchor = document.querySelector('#ledger_modal_close_button');
                                anchor.click();
                                $('#ledger_doc_submit_button').removeAttr('disabled');
                                alert_float('success', 'Ledger document uploaded successfully and Email send to the broker.');
                                $('#show_text_to_broker').text('');
                                setTimeout(function () {
                                    destroyTinyMCE();
                                    if (anchor) {
                                        _lead_init_data(response, response.id);
                                    }
                                    $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                    $('a[href="' + response.leads_status + '"]').tab('show');
                                    if (response.leads_status === "#lead_reminders") {
                                        anchor.click();
                                    }
                                }, 500);
                            } else {
                                $('#upload_doc_for_ledger')[0].reset();
                                $('#show_text_to_broker').text('');
                                $('#ledger_loader').removeClass('loader');
                                var close = document.querySelector('.close');
                                close.click();
                                var anchor = document.querySelector('#ledger_modal_close_button');
                                anchor.click();
                                $('#ledger_doc_submit_button').removeAttr('disabled');
                                alert_float('danger', 'Please Approved one ledgers and then attachment send to the broker.');
                                setTimeout(function () {
                                    destroyTinyMCE();
                                    if (anchor) {
                                        _lead_init_data(response, response.id);
                                    }
                                    $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                    $('a[href="' + response.leads_status + '"]').tab('show');
                                    if (response.leads_status === "#lead_reminders") {
                                        anchor.click();
                                    }
                                }, 500);
                            }
                        },
                        error: function (xhr, status, error) {

                            // Handle any errors here
                            var anchor = document.querySelector('.close');
                            anchor.click();
                            var anchor = document.querySelector('#ledger_modal_close_button');
                            anchor.click();
                            $('#ledger_doc_submit_button').removeAttr('disabled');
                            $('#ledger_loader').removeClass('loader');
                            $('#upload_doc_for_ledger')[0].reset();
                            $('#ledger_doc_submit_button').removeAttr('disabled');
                            alert_float('danger', 'An error occurred while uploading the files.');
                        }
                    });
                }
            });
            // ledgers stage details
            $.ajax({
                url: "<?php echo admin_url('leads/get_leads_ledger_for_ldteam/' . $lead->id); ?>",
                method: 'GET',
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        var ledgerData = response.ledger_data;
                        var ledgerLogs = response.ledger_logs;
                        var tableBody = $('#ledger_table_body');
                        tableBody.empty(); 

                        // Group files by ledger_number
                        var groupedData = {};
                        ledgerData.forEach(function (item) {
                            if (!groupedData[item.ledger_number]) {
                                groupedData[item.ledger_number] = [];
                            }
                            groupedData[item.ledger_number].push(item);
                        });
                        // Generate rows for each ledger_number group
                        for (var ledgerNumber in groupedData) {
                            var additional_files_count = 0;
                            var files = groupedData[ledgerNumber];
                            // Add bb_status and bb_comment columns
                            var ledger_id = files[0].id;
                            var ledger_number = files[0].ledger_number;
                            var bbStatus = files[0].bb_status ? files[0].bb_status : '-';
                            // var bbStatusChangeTime = files[0].bb_change_status_time ? new Date(files[0].bb_change_status_time).toLocaleDateString() : '';
                            var bbStatusChangeTime = files[0].bb_change_status_time ? files[0].bb_change_status_time : '';
                            var bbComment = files[0].bb_comment ? files[0].bb_comment : '-';
                            var selectedStatus = 'Awaiting For Approval';
                            if (bbStatus === 'Approved') {
                                selectedStatus = 'Approved';
                            } else if (bbStatus === 'Rejected') {
                                selectedStatus = 'Rejected';
                            }
                            var row = `<tr>`;

                            // Generate file cells
                            row += `<td style="padding: 10px; border: 1px solid #ddd; max-height: 290px; overflow-y: auto; display: flex; flex-wrap: wrap;">`;
                            files.forEach(function (file) {
                                var viewUrl = file.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com");
                                var filetypeParts = file.filetype.split('/');
                                var extension = filetypeParts[1];
                                var imageUrl = '';

                                if (['jpeg', 'png', 'jpg', 'HEIC', 'heic'].includes(extension)) {
                                    imageUrl = '<?php echo base_url('assets/images/allimage.webp'); ?>';
                                } else if (extension === 'pdf') {
                                    imageUrl = '<?php echo base_url('assets/images/pdf.webp'); ?>';
                                } else if (extension === 'msword' || extension === 'vnd.openxmlformats-officedocument.wordprocessingml.document') {
                                    imageUrl = '<?php echo base_url('assets/images/msword_new.webp'); ?>';
                                } else {
                                    imageUrl = '<?php echo base_url('assets/images/general.webp'); ?>';
                                }

                                if (file.type == 'ld_team') {
                                    row += `<div class="col-md-3" style='margin: 8px; display: flex; flex-direction: column; align-items: center;'>
                                    <div style="margin-bottom: 5px;display:flex;">
                                        <a href='${file.file_url}' target='_blank'><i class='fa fa-download' aria-hidden='true'></i></a>
                                        <a href='${viewUrl}' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a>
                                    </div>
                                    <img loading="lazy" src="${imageUrl}" alt="Image" style="width: 50px; height: 50px;">
                                </div>`;
                                } else {

                                    if (additional_files_count == 0) {
                                        row += `<div class="col-md-12 " style="color: #1208ff;background-color: #044bff4d;padding: 12px;border-radius: 5px;font-weight: 800;display: flex;justify-content: center;align-items: center;">
                                                        <span>Additional files for broker</span>
                                                    </div>`;
                                        additional_files_count++;
                                    }
                                    row += `<div class="col-md-3">
                                            <div style="margin-bottom: 5px;display:flex;align-items:center;justify-content:center;">
                                        <a href='${file.file_url}' target='_blank'><i class='fa fa-download' aria-hidden='true'></i></a>
                                        <a href='${viewUrl}' target='_blank'><i style='margin-left:5px;' class='fa fa-eye' aria-hidden='true'></i></a>
                                    </div>`;
                                    row += `<img src="${imageUrl}" alt="Image" style="width: 50px; height: 50px;">
                                        </div>`;

                                }
                            });
                            row += `</td>`;

                            // Add logs
                            var ledger_status = ledgerLogs[ledger_id].map(function (log) {
                                return `<div style="border-bottom:1px solid;height:150px;">
                                <div>${log.status}</div>
                                <div>${log.created_at}</div>
                            </div>`;
                            }).join('');
                            var ledger_comment = ledgerLogs[ledger_id].map(function (log) {
                                if (log.comment) {
                                    return `<div style="border-bottom:1px solid;height:150px;">
                                                <p id="ledger_log_updated_value_show_${log.id}">${format_notes_and_description(log.comment)}</p>
                                                 ${is_admin ? `
                                                    <button class="LedgerUdateSectionToggle btn btn-primary btn-sm" data-id="${log.id}" style="float:right;"><i class='fas fa-edit'></i></button><br>
                                                    <div id="show_update_ledger_textarea_${log.id}" style="display:none;">
                                                        <hr class="-tw-mx-3.5" />
                                                        <div style="margin-top:15px;">
                                                            <textarea class="form-control ld_ledger_log_update" data-id="${log.id}">${log.comment}</textarea>
                                                        </div>
                                                    </div>
                                                    ` 
                                                : ''}
                                            </div>`;
                                } else {
                                    return `<div style="border-bottom:1px solid;height:100px;">
                                                <div>-</div>
                                            </div>`;
                                }
                            }).join('');
                            // ledger notes
                            var ledger_notes = ledgerLogs[ledger_id].map(function (log) {
                                if (log.notes) {
                                    return `<div style="border-bottom:1px solid;height:100px;">
                                        <div>${log.notes}</div>
                                        </div>`;
                                } else {
                                    return `<div style="border-bottom:1px solid;height:100px;">
                                        <div>-</div>
                                        </div>`;
                                }
                            }).join('');

                            row += `<td style="padding: 10px; border: 1px solid #ddd;">${ledger_status}</td>`;
                            row += `<td style="padding: 10px; border: 1px solid #ddd;">${ledger_comment}</td>`;
                            // row += `<td style="padding: 10px; border: 1px solid #ddd;">${ledger_notes}</td>`;

                            <?php if (is_admin()): ?>
                                row += `<td style="padding: 10px; border: 1px solid #ddd;">
                                            <select class="form-control" id="bb_change_ledgers_doc_status" style="width: 150px; padding: 5px; border: 1px solid #ddd;" data-id="${ledger_id}" data-ledger_number="${ledger_number}">
                                                <option ${selectedStatus === 'Awaiting For Approval' ? 'selected' : ''}>Awaiting For Approval</option>
                                                <option value="Approved" ${selectedStatus === 'Approved' ? 'selected' : ''}>Approved</option>
                                                <option value="Rejected" ${selectedStatus === 'Rejected' ? 'selected' : ''}>Rejected</option>
                                            </select>
                                        </td>`;
                            <?php endif; ?>

                            row += `</tr>`;

                            tableBody.append(row);
                        }
                    }
                },
                error: function (error) {
                    console.error('Error fetching checklist items:', error);
                }
            });
            // toggle the update section of ledger
            $(document).off('click', '.LedgerUdateSectionToggle').on('click', '.LedgerUdateSectionToggle', function () {
                var id = $(this).data('id');
                $('#show_update_ledger_textarea_' + id).toggle();
                $('#ledger_log_updated_value_show_' + id).toggle();
            });
            // ld leadger logs update code using textarea
            $(document).off('change', '.ld_ledger_log_update').on('change', '.ld_ledger_log_update', function() {
                var logId   = $(this).data('id');
                var comment = $(this).val();
                $('.full-page-loader').show();
                $.ajax({
                    url: "<?php echo admin_url('leads/update_leader_logs/' . $lead->id); ?>",
                    type: 'POST',
                    data: {
                        leadger_log_id: logId,
                        leadger_log_comment: comment
                    },
                    success: function(response) {
                         $('.full-page-loader').hide();
                        if(response.success){
                            $('#ledger_log_updated_value_show_' + logId).text(comment);
                            $('#show_update_ledger_textarea_' + logId).toggle();
                            $('#ledger_log_updated_value_show_' + logId).toggle();
                            alert_float('success', 'Lead leadger update porperly.');
                        }else{
                            alert_float('danger', 'Lead leadger not update porperly.');
                        }
                    },
                    error: function() {
                        $('.full-page-loader').hide();
                        console.error('Failed to update log', logId);
                    }
                });
            });
            // Final ledgers details
            $.ajax({
                url: "<?php echo admin_url('leads/get_leads_final_ledger_for_ldteam/' . $lead->id); ?>",
                method: 'GET',
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        var ledgerData = response.ledger_data;
                        var ledgerLogs = response.ledger_logs;
                        var tableBody = $('#final_ledger_table_body');
                        tableBody.empty();

                        // Group files by ledger_number
                        var groupedData = {};
                        ledgerData.forEach(function (item) {
                            if (!groupedData[item.ledger_number]) {
                                groupedData[item.ledger_number] = [];
                            }
                            groupedData[item.ledger_number].push(item);
                        });

                        // Generate rows for each ledger_number group
                        for (var ledgerNumber in groupedData) {
                            var files = groupedData[ledgerNumber];
                            var ledger_id = files[0].id;
                            var row = `<tr>`;
                            if (files.length > 0) {
                                row += `<td style="padding: 10px; border: 1px solid #ddd; max-height: 290px; overflow-y: auto; display: flex; flex-wrap: wrap;">`;
                                files.forEach(function (file) {
                                    if (file.file_url && file.filetype) {
                                        var viewUrl = file.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com");
                                        var filetypeParts = file.filetype.split('/');
                                        var extension = filetypeParts[1];
                                        var imageUrl = '<?php echo base_url("assets/images/general.png"); ?>';

                                        // Set specific images based on file extension
                                        if (['jpeg', 'png', 'jpg', 'HEIC', 'heic'].includes(extension)) {
                                            imageUrl = '<?php echo base_url("assets/images/allimage.webp"); ?>';
                                        } else if (extension === 'pdf') {
                                            imageUrl = '<?php echo base_url("assets/images/pdf.webp"); ?>';
                                        } else if (extension.includes('msword')) {
                                            imageUrl = '<?php echo base_url("assets/images/msword_new.webp"); ?>';
                                        } else {
                                            imageUrl = '<?php echo base_url('assets/images/general.webp'); ?>';
                                        }

                                        row += `<div class="col-md-3" style='margin: 8px; display: flex; flex-direction: column; align-items: center;'>
                                                        <div style="margin-bottom: 5px;display:flex;">
                                                            <a href='${file.file_url}' target='_blank'><i class='fa fa-download'></i></a>
                                                            <a href='${viewUrl}' target='_blank' style='margin-left: 5px;'><i class='fa fa-eye'></i></a>
                                                        </div>
                                                        <img loading="lazy" src="${imageUrl}" alt="Image" style="width: 50px; height: 50px;">
                                                    </div>`;
                                    } else {
                                        row += `<div class="col-md-3" style='margin: 8px; display: flex; flex-direction: column; align-items: center;'>
                                                        <p>No document found.</p>
                                                    </div>`;
                                    }
                                });
                            } else {
                                row += `<td style="padding: 10px; border: 1px solid #ddd;">`;
                                row += `<div class="col-md-3" style='margin: 8px; display: flex; flex-direction: column; align-items: center;'>
                                                <p>No document found.</p>
                                            </div>`;
                            }
                            row += `</td>`;

                            var ledger_status = ledgerLogs[ledger_id]?.map(function (log) {
                                return `<div style="border-bottom:1px solid;height:100px;">
                                                <div>${log.status}</div>
                                                <div>${log.created_at}</div>
                                            </div>`;
                            }).join('') || '<div>-</div>';

                            var ledger_comment = ledgerLogs[ledger_id]?.map(function (log) {
                                return log.comment ? `<div style="border-bottom:1px solid;height:100px;"><div>${log.comment}</div></div>`
                                    : `<div style="border-bottom:1px solid;height:100px;"><div>-</div></div>`;
                            }).join('') || '<div>-</div>';

                            row += `<td style="padding: 10px; border: 1px solid #ddd;">${ledger_status}</td>`;
                            row += `<td style="padding: 10px; border: 1px solid #ddd;">${ledger_comment}</td>`;
                            row += `</tr>`;
                            tableBody.append(row);
                        }
                    }
                },
                error: function (error) {
                    console.error('Error fetching ledger data:', error);
                }
            });
            $(document).off('change', '#bb_change_ledgers_doc_status').on('change', '#bb_change_ledgers_doc_status', function () {
                var selectedStatus = $(this).val();
                var ledger_id = $(this).data('id');
                var ledgerNumber = $(this).data('ledger_number');
                appendInputAndRemove_ledger_fields('status', selectedStatus, 'ledger_id', ledger_id, 'ledger_number', ledgerNumber);
                setTimeout(function () {
                    $('#ledgers_status_comment_modal').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                }, 200);
                $('#ledgers_status_comment_modal').modal('show');
            });
            // add the comment for ledgers
            $(document).off('submit', '#ledgers_comments_by_bb').on('submit', '#ledgers_comments_by_bb', function (event) {
                event.preventDefault();
                // var confirmed = confirm('Are you sure you want to update the ledger document status?');
                // if (confirmed) {
                    $('#ledgers_bb_comment_loader').addClass('loader');
                    // Disable the submit button
                    $('#ledger_status_change_btn').attr('disabled', 'disabled');
                    var form = $(this)[0]; 
                    var formData = new FormData(form);

                    // AJAX request
                    $.ajax({
                        url: '<?php echo admin_url('leads/ledger_status_change_by_bb/' . $lead->id); ?>',
                        method: 'POST',
                        dataType: 'json',
                        data: formData,
                        processData: false,
                        contentType: false,
                        success: function (response) {
                            if (response.success) {
                                destroyTinyMCE();
                                $('#ledgers_bb_comment_loader').removeClass('loader');
                                $('#ledger_status_change_btn').removeAttr('disabled');
                                alert_float('success', 'Ledger document status updated successfully!');
                                $('#ledger').trigger('click');
                                var anchor = document.querySelector('.close');
                                anchor.click();
                                $('a[href="#ledger"]').closest('div').addClass('step-active');
                                // Optionally update UI or perform additional actions
                                $('#ledgers_comments_by_bb')[0].reset();
                                // modal close button
                                $('#ledger_status_comment_close_btn').trigger('click');
                                var anchor = document.querySelector('#ledger_status_comment_close_btn');
                                anchor.click();
                                var closeButton = document.querySelector('.close');
                                closeButton.click();
                                $('#ledgers_status_comment_modal').modal('hide');
                                setTimeout(function () {
                                    _lead_init_data(response, response.id);
                                    $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                    $('a[href="' + response.leads_status + '"]').tab('show');
                                }, 500);
                            } else {
                                $('#ledgers_bb_comment_loader').removeClass('loader');
                                $('#ledger_status_change_btn').removeAttr('disabled');
                                $('#ledger').trigger('click');
                                var anchor = document.querySelector('.close');
                                anchor.click();
                                // show alert success
                                alert_float('danger', 'Failed to update ledger document status!');
                                $('#ledgers_comments_by_bb')[0].reset();
                                //  modal close button
                                $('#ledger_status_comment_close_btn').trigger('click');
                                var anchor = document.querySelector('#ledger_status_comment_close_btn');
                                anchor.click();
                                var closeButton = document.querySelector('.close');
                                closeButton.click();
                                $('#ledgers_status_comment_modal').modal('hide');
                                setTimeout(function () {
                                    _lead_init_data(response, response.id);
                                    // show ledgers tabs
                                    $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                                    $('a[href="' + response.leads_status + '"]').tab('show');
                                }, 500);
                            }
                        },
                        error: function (error) {
                            console.error('Error updating ledger document status:', error);
                            alert_float('danger', 'Error updating ledger document status. Please try again later.');
                            $('#ledgers_comments_by_bb')[0].reset();
                            //  modal close button
                            $('#ledger_status_comment_close_btn').trigger('click');
                            var anchor = document.querySelector('#ledger_status_comment_close_btn');
                            anchor.click();
                            var closeButton = document.querySelector('.close');
                            closeButton.click();
                            $('#ledgers_status_comment_modal').modal('hide');
                        }
                    });
                // } else {
                // }
            });
        });
        // upload doc for case closed
        $('#upload_doc_for_case_closed').on('submit', function (e) {
            e.preventDefault();
            var sameGroup = '<?php echo $samegroup; ?>';
            var files = $('#case_closed_userfile')[0].files;
            var valid = true;
            var errorMsg = '';

            if (files.length === 0) {
                valid = false;
                errorMsg = 'Please select at least one file.';
            } else {
                for (var i = 0; i < files.length; i++) {
                    var file = files[i];
                    var fileType = file.type;
                    var validTypes = [
                        'application/pdf',
                        'image/jpeg',
                        'image/jpg',
                        'image/png',
                        'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
                        'application/msword',
                        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
                        'application/vnd.ms-excel'
                    ];

                    if (!validTypes.includes(fileType)) {
                        valid = false;
                        errorMsg = 'Invalid file type. Only PDF, JPEG, JPG, PNG, DOC, DOCX, XLS, and XLSX files are allowed.';
                        break;
                    }

                    if (file.size > 10 * 1024 * 1024) {
                        valid = false;
                        errorMsg = 'File size should not exceed 10MB.';
                        break;
                    }
                }
            }

            if (!valid) {
                $('#case_closed_error').text(errorMsg);
            } else {
                $('#case_closed_error').text('');
                $('#case_closed_doc_loader').addClass('loader');
                $('#case_closed_doc_submit_button').attr('disabled', 'disabled');

                var formData = new FormData(this);

                $.ajax({
                    url: $(this).attr('action'),
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function (response) {
                        $('#case_closed_doc_loader').removeClass('loader');
                        $('#case_closed_doc_submit_button').removeAttr('disabled');
                        // Handle success response
                        if (sameGroup == 2) {
                            destroyTinyMCE();
                            _lead_init_data(response, response.id);
                            $('a[href="#summary"]').tab('show');
                        } else {
                            destroyTinyMCE();
                            _lead_init_data(response, response.id);
                            $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                            $('a[href="' + response.leads_status + '"]').tab('show');
                        }
                        $('#upload_doc_for_case_closed')[0].reset();
                    },
                    error: function (xhr, status, error) {
                        $('#case_closed_doc_loader').removeClass('loader');
                        $('#case_closed_doc_submit_button').removeAttr('disabled');
                    }
                });
            }
        });
        // fetch the all record of case closed
        $.ajax({
            url: '<?php echo base_url("admin/leads/get_all_details_for_case_closed/" . $lead->id); ?>',
            type: 'GET',
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    var data = response.case_closed_data;
                    var tableBody = $('#caseClosedDataTable tbody');
                    tableBody.empty();

                    $.each(data, function (index, item) {
                        var columnClass = (item.file_data.length === 1) ? 'col-md-12' : 'col-md-6';

                        // Build the file rows
                        var fileRows = '';
                        $.each(item.file_data, function (fileIndex, fileItem) {
                            // var modifiedFileUrl = fileItem.file_url.replace(/raw=1$/, 'dl=1');
                            var modifiedFileUrl = item.file_url ? item.file_url.replace(/raw=1$/, 'dl=1') : '';
                            var view_url = fileItem.file_url ? fileItem.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com") : '';
                            var imageUrl;

                            if (fileItem.filetype.startsWith('image/')) {
                                imageUrl = '<?php echo base_url("assets/images/allimage.webp"); ?>';
                            } else if (fileItem.filetype === 'application/pdf') {
                                imageUrl = '<?php echo base_url("assets/images/pdf.webp"); ?>';
                            } else if (fileItem.filetype === 'application/msword' || fileItem.filetype === 'application/vnd.openxmlformats-officedocument.wordprocessingml.document') {
                                imageUrl = '<?php echo base_url("assets/images/msword_new.webp"); ?>';
                            } else {
                                imageUrl = '<?php echo base_url("assets/images/general.webp"); ?>';
                            }

                            fileRows += `
                                    <div class="${columnClass}">
                                        <div style="display: flex; justify-content: center; align-items: center; margin-bottom: 5px;margin-right:75px;">
                                            <a href="${modifiedFileUrl}"><i class="fa fa-download" aria-hidden="true"></i></a>
                                            <a href="${view_url}" target="_blank" style="margin-left: 5px;"><i class="fa fa-eye" aria-hidden="true"></i></a>
                                            <a href="#" class="delete-file-btn" id="outstanding_ld_team_doc_delete" data-file-id="${fileItem.id}" style="margin-left: 5px;"><i class="fa fa-trash" style="color: red;"></i></a>
                                        </div>
                                        <a href="${view_url}" target="_blank">
                                            <img loading="lazy" src="${imageUrl}" style="width: 50px; height: 50px; object-fit: cover;">
                                        </a>
                                    </div>
                                `;
                        });

                        var descriptionHtml = `
                                <tr>
                                    <td style="width:410px;">
                                        <div style="overflow-y: scroll; max-height: 150px; width: 400px;">
                                            ${fileRows}
                                        </div>
                                    </td>
                                    <td>
                                        <ul style="list-style-type: disc; padding-left: 20px;">
                                            ${item.description.split("\n").map(line => line.trim() !== "" ? `<li>${line}</li>` : "").join('')}
                                        </ul>
                                    </td>
                                    <td>${item.created_at}</td>
                                </tr>
                            `;
                        tableBody.append(descriptionHtml);
                    });
                } else {
                }
            },
            error: function (xhr, status, error) {
                console.error(xhr.responseText);
            }
        });
        get_holdback_details();
        function get_holdback_details() {
            $.ajax({
                url: '<?php echo base_url("admin/leads/get_holdback_data/" . $lead->id); ?>',
                type: 'GET',
                dataType: 'json',
                success: function (response) {
                    var tableContent = '';

                    if (response && response.length > 0) {
                        $('#holdback_details_form_show').show();
                        $.each(response, function (index, item) {
                            tableContent += '<tr>';
                            tableContent += '<td>' + item.name + '</td>';
                            tableContent += '<td>' + item.comment + '</td>';
                            tableContent += '<td>';
                            if (item.files && item.files.length > 0) {
                                tableContent += '<div style="overflow-y: scroll; max-height: 150px; width: 400px; overflow-x: hidden;">';

                                $.each(item.files, function (i, fileItem) {
                                    var columnClass = (fileItem.length === 1) ? 'col-md-12' : 'col-md-6';
                                    var modifiedFileUrl = fileItem.file_url ? fileItem.file_url.replace(/raw=1$/, 'dl=1') : '';
                                    var viewUrl = fileItem.file_url ? fileItem.file_url.replace("dl.dropboxusercontent.com", "www.dropbox.com") : '';
                                    var imageUrl;

                                    if (fileItem.filetype.startsWith('image/')) {
                                        imageUrl = '<?php echo base_url("assets/images/allimage.webp"); ?>';
                                    } else if (fileItem.filetype === 'application/pdf') {
                                        imageUrl = '<?php echo base_url("assets/images/pdf.webp"); ?>';
                                    } else if (fileItem.filetype === 'application/msword' || fileItem.filetype === 'application/vnd.openxmlformats-officedocument.wordprocessingml.document') {
                                        imageUrl = '<?php echo base_url("assets/images/msword_new.webp"); ?>';
                                    } else {
                                        imageUrl = '<?php echo base_url("assets/images/general.webp"); ?>';
                                    }

                                    tableContent += `
                                            <div style="display: flex; justify-content: center; align-items: center; flex-direction: column;" class="col-md-6">
                                                <div class="display:flex;">
                                                    <a href="${modifiedFileUrl}" title="Download"><i class="fa fa-download" aria-hidden="true"></i></a>
                                                    <a href="${viewUrl}" target="_blank" style="margin-left: 5px;" title="View"><i class="fa fa-eye" aria-hidden="true"></i></a>
                                                    <a href="#" class="delete-file-btn" data-file-id="${fileItem.id}" style="margin-left: 5px;" title="Delete"><i class="fa fa-trash" style="color: red;"></i></a>
                                                </div>
                                                <a href="${viewUrl}" target="_blank">
                                                    <img loading="lazy" src="${imageUrl}" style="width: 50px; height: 50px; object-fit: cover;">
                                                </a>
                                            </div>
                                        `;
                                });

                                tableContent += '</div>';
                            } else {
                                tableContent += '<div>No files available</div>';
                            }
                            tableContent += '</td>';
                            tableContent += '<td>' + item.created_at + '</td>';
                            tableContent += '</tr>';
                        });
                    } else {
                        $('#holdback_details_form_show').hide();
                        tableContent = '<tr><td colspan="4">No data found.</td></tr>';
                    }
                    $('#holdback_table_details tbody').html(tableContent);
                },
                error: function () {
                    console.log('Error fetching data. Please try again.');
                }
            });
        }
        // // Call the function with the appropriate parameters
        // get_shootinfo_details('shootInfoTable', 4, 'ld_team', 'holdback');
        function upload_doc_for_outstanding_ld_team(stateId, type, statetitle) {
            $.ajax({
                url: "<?php echo admin_url('leads/get_outstanding_ld_task_notes/' . $lead->id); ?>",
                method: 'GET',
                dataType: 'json',
                data: {
                    stateId: stateId
                },
                success: function (response) {
                    if (response.success) {
                        var htmlContent = response.description;
                        var plainTextContent = $('<div>').html(htmlContent).text();
                        if(type == 'other'){
                            $('#ld_outstanding_secure_lender_name').hide();
                        }
                        $('#ld_payout_other_notes').val(plainTextContent);
                    } else {
                        $('#ld_payout_other_notes').val('');
                    }
                    // remove the validation line of code for purpose of funds upload doc
                    var regex = /^(PURPOSE\s*OF\s*FUNDS|purpose\s*of\s*funds|Purpose\s*of\s*funds|Purpose\s*Of\s*Funds|Purpose\s*of\s*fund|Purpose\s*Of\s*Fund)$/i;
                    if (regex.test(response.title)) {
                        appendInputAndRemovePrevious_for_ld_outstanding_item('ld_remove_validation', 1);
                    } else {
                        appendInputAndRemovePrevious_for_ld_outstanding_item('ld_remove_validation', 0);
                    }
                },
                error: function (xhr, status, error) {
                    console.error('AJAX error:', status, error);
                }
            });
            var regex = /payout\s*stat[e|a]ment[s]?\(?s?\)?|info\s*stat[e|a]ment[s]?\(?s?\)?|info\s*statement[s]?\(?s?\)?|infostatement[s]?|Info\s*Stat[e|a]ment[s]?|InfoStatement[s]?|INFO\s*STATMENT|PAYOUT\s*STATMENT/i;
            var payout_regex = /\b(Secured\s+Payout\s+1|Secured\s+Payout\s+2|Postponement\s+1|Postponement\s+2)\b/i;
            //   if (type == 'payout' || regex.test(statetitle.trim())) {
            if (type == 'secure_charge' || payout_regex.test(statetitle.trim())) {
                $('#ld_payouts_data').show();
                $('#payout_expire_date').attr('required', 'required');
                $('#label_star_payout_expire_date').show();
            }else if(type == 'secure_private_charge_1' || type == 'postponements'){
                $('#ld_payouts_data').show();
                $('#payout_expire_date').removeAttr('required');
                $('#label_star_payout_expire_date').hide();
            } else {
                $('#ld_payouts_data').hide();
                $('#payout_expire_date').removeAttr('required');
                $('#label_star_payout_expire_date').hide();
            }

            appendInputAndRemovePrevious_for_ld_outstanding_item('cases_checkbox_id', stateId);
            // Scroll the modal into view
            $('#ld_outstanding_item_modal_upload_doc').modal('show');
            setTimeout(function () {
                $('#ld_outstanding_item_modal_upload_doc').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
            }, 200);
        }
        function checkEditorAndEnableButton() {
            const $btn = $('#request_for_funds_submit_button');
            const maxChecks = 5;
            const checkInterval = 3000;
            const originalText = "Submit";

            let checkCount = 0;
            let countdownTimer;
            let intervalId;

            const setButtonCountdown = (seconds) => {
                $btn.val(`Please wait (${seconds}s)`);
            };

            const enableButton = () => {
                clearInterval(countdownTimer);
                clearInterval(intervalId);
                $btn.prop('disabled', false).val(originalText);
            };

            const startCountdown = (seconds) => {
                let remaining = seconds;
                setButtonCountdown(remaining);

                countdownTimer = setInterval(() => {
                    remaining--;
                    if (remaining > 0) {
                        setButtonCountdown(remaining);
                    } else {
                        enableButton();
                    }
                }, 1000);
            };

            const editorInstance = tinymce.get('closed_mail_review');

            if (editorInstance && editorInstance.initialized) {
                const content = editorInstance.getContent({ format: 'text' }).trim();
                if (content.length > 0) {
                    // Editor content loaded, enable button immediately
                    enableButton();
                    return;
                }
            }

            // Editor not loaded or content empty → disable button and start timer
            $btn.prop('disabled', true);
            const totalCountdown = maxChecks * (checkInterval / 1000);
            startCountdown(totalCountdown);

            intervalId = setInterval(() => {
                checkCount++;
                const editorNow = tinymce.get('closed_mail_review');
                if (editorNow && editorNow.initialized) {
                    const contentNow = editorNow.getContent({ format: 'text' }).trim();
                    if (contentNow.length > 0) {
                        enableButton();
                    }
                }
                if (checkCount >= maxChecks) {
                    clearInterval(intervalId);
                }
            }, checkInterval);
        }

        function upload_doc_for_request_for_funds(stateId, type) {
            appendInputAndRemovePrevious_for_request_for_funds('cases_checkbox_id', stateId);
            $('.appened_req_action_date').find('.action-date-group').remove(); 
            $('.appened_req_comments').find('.comments_req_for_funds_stage').remove(); 
            // add the ntoes textarea
            $('.appened_req_comments').append(`
                <div class="comments_req_for_funds_stage">
                    <label class="form-label">Comments</label>
                    <textarea id="req_comments" name="req_comments" class="form-control" placeholder="Enter your comments here..."></textarea>
                </div>
            `);
            if (type == 'send-report') {
                
                // Start the check
                checkEditorAndEnableButton();
                $('#request_for_funds_modal_upload_doc_form').append('<input type="hidden" name="type" value="' + type + '">');
            } else {
                $('#request_for_funds_modal_upload_doc_form').find('input[name="type"]').remove();
                $('.appened_req_action_date').append(`
                    <div class="action-date-group">
                        <label class="form-label">Action Date</label>
                        <input type="date" id="action_date" name="action_date" class="form-control">
                    </div>
                `);
            }

            $('#request_for_funds_modal_upload_doc').modal('show');
            // Scroll the modal into view
            setTimeout(function () {
                $('#request_for_funds_modal_upload_doc').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
            }, 200);
        }

        // ledger modal show
        function upload_doc_for_ledger() {
            $('#ledger_modal_upload_doc').modal('show');
            $('#ledger_userfile_error').text('');
            // $('#upload_doc_for_ledger')[0].reset();
            $('#ledger_comment').val('');
            $('#ledger_userfile').val('');
            // Scroll the modal into view
            setTimeout(function () {
                $('#ledger_modal_upload_doc').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
            }, 200);
        }
        // request for funds doc delete jquery
        $(document).off('click', '#outstanding_ld_team_doc_delete, #request_for_funds_doc_delete').on('click', '#outstanding_ld_team_doc_delete, #request_for_funds_doc_delete', function (e) {
            e.preventDefault();
            var sameGroup = '<?php echo $samegroup; ?>';
            var fileId = $(this).data('file-id');
            // var confirmation = confirm("Are you sure you want to delete this file?");

            // if (confirmation) {
                var lead_id = '<?php echo $lead->id; ?>';
                $('.full-page-loader').show();
                setTimeout(function () {
                    $('#full_page_loader').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                }, 200);
                // Send AJAX request if confirmed
                $.ajax({
                    url: '<?php echo base_url("admin/leads/delete_cases_checkbox_file/"); ?>' + lead_id,
                    type: 'POST',
                    data: {
                        file_id: fileId,
                        leads_status: 4,
                        // leads_status: '<?php echo $checklist_id; ?>'
                    },
                    success: function (response) {
                        alert_float('success', 'File deleted successfully.');
                        _lead_init_data(response, response.id);
                        $('.full-page-loader').hide();
                        if (sameGroup == 2) {
                            $('a[href="#summary"]').tab('show');
                        } else {
                            $('a[href="' + response.leads_status + '"]').closest('div').addClass('step-active');
                            $('a[href="' + response.leads_status + '"]').tab('show');
                        }
                        $('.delete-file-btn[data-file-id="' + fileId + '"]').closest('.file-container').remove();
                    },
                    error: function (xhr, status, error) {
                        alert_float('danger', 'File could not be deleted. Please try again.');
                    }
                });
            // }
        });
        $(document).ready(function () {
            // hide and show the holdback deatisl form
            $('#holdback_details_form_show').off('click').on('click', function () {
                $('#add_holdback_details_form').toggle('fade');
            });
            // submit holdback form details
            $('#add_holdback_details').on('submit', function (e) {
                e.preventDefault();
                var fileInput = $('#hold_back_details_file');
                var fileErrorDiv = $('#hold_back_details_file_error');
                var files = fileInput[0].files;
                fileErrorDiv.text('');
                if (files.length === 0) {
                    fileErrorDiv.text('Please select at least one file before submitting.');
                    return;
                }
                var formData = new FormData(this);
                $('.hold_back_details_loader').addClass('loader');
                $('#hold_back_details_submit_btn').prop('disabled', true);
                var sameGroup = '<?php echo $samegroup; ?>';
                $.ajax({
                    url: '<?php echo base_url("admin/leads/add_holdback_details"); ?>',
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function (response) {
                        if (response.success) {
                            alert_float('success', 'Holdback details added successfully!');
                            $('#add_holdback_details')[0].reset();
                            $('#add_holdback_details_form').hide();
                            $('.hold_back_details_loader').removeClass('loader');
                            $('#hold_back_details_submit_btn').prop('disabled', false);
                            _lead_init_data(response, response.id);
                            if (sameGroup == 2) {
                                $('a[href="#summary"]').tab('show');
                            } else {
                                $('a[href="#Closed"]').closest('div').addClass('step-active');
                                $('a[href="#Closed"]').tab('show');
                            }
                        }
                    },
                    error: function () {
                        fileErrorDiv.text('An error occurred while submitting the form.');
                    },
                    complete: function () {
                        $('.hold_back_details_loader').removeClass('loader');
                        $('#hold_back_details_submit_btn').prop('disabled', false);
                    }
                });
            });
            function fetchNotifications(page = 0) {
                $.ajax({
                    url: '<?php echo admin_url('leads/case_notifications/' . $lead->id); ?>',
                    type: 'POST',
                    data: {},
                    dataType: 'json',
                    success: function (response) {
                        if (response.length > 0) {
                            $.each(response, function (index, notification) {
                                var notificationHtml = '<li class="notification-item" style="align-items: flex-start;display: flex;">' +
                                    notification.profile_image +
                                    '<div>' +
                                    '<p>' + notification.from_fullname + ' - ' + notification.description + '</p>' +
                                    '<p><small>' + notification.date + '</small></p>' +
                                    '</div>' +
                                    '</li>';
                                $('#notificationsList').append(notificationHtml);
                            });
                        }
                    },
                    error: function (xhr, status, error) {
                    }
                });
            }

            // Initial fetch
            fetchNotifications();

            // activity logs content show in modal
            $(document).off('click', '#activity_log_show').on('click', '#activity_log_show', function () {
                var logId = $(this).data('id');
                var leadId = <?php echo json_encode($lead->id); ?>;

                $.ajax({
                    url: '<?php echo admin_url('leads/get_logs_by_id'); ?>',
                    method: 'GET',
                    data: {
                        log_id: logId,
                        lead_id: leadId
                    },
                    dataType: 'json',
                    success: function (response) {
                        console.warn(response);
                        if (response.success) {
                            $('#show_logs_modal').modal('show');
                            $('#activity_log_content').html(response.log_description);
                            setTimeout(function () {
                                $('#show_logs_modal').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
                            }, 200);
                        } else {
                            $('#show_logs_modal').modal('hide');
                            $('#activity_log_content').html('');
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error('AJAX error:', status, error);
                    }
                });
            });


            // outbox js code

            // hover outbox item show delete btn
            $(document).off('click', '.outbox-delete-btn').on('click', '.outbox-delete-btn', function (e) {
                e.stopPropagation();
                var button = $(this);
                var item = button.closest('.outbox-mail-item');
                var outboxId = button.data('id');

                if (confirm('Are you sure you want to delete this mail?')) {
                    $.ajax({
                        url: '<?= admin_url('Outbox/delete_outbox/' . $lead->id) ?>',
                        type: 'POST',
                        data: { id: outboxId },
                        dataType: 'json',
                        success: function (response) {
                            if (response.success) {
                                item.remove();
                                alert_float('success','Outbox email deleted successfully.');
                            } else {
                                alert_float('danger','Failed to delete outbox email.');
                            }
                        },
                        error: function () {
                            alert_float('danger','An error occurred while deleting the email.');
                        }
                    });
                }
            });

            //  page counter show for outbox 

            let outboxCurrentPage = 1;
            let outboxPerPage = 10;
            let outboxTotalItems = <?= $outbox_count ?>;
            let outboxTotalPages = Math.ceil(outboxTotalItems / outboxPerPage);

            function outboxUpdatePagination() {
                $('#outbox-page-info').text('Page ' + outboxCurrentPage + ' of ' + outboxTotalPages);
            }

            function loadOutboxPage(page = 1) {
                let offset = (page - 1) * outboxPerPage;

                $.ajax({
                    url: '<?= admin_url("Outbox/get_outbox_page/" . $lead->id) ?>',
                    type: 'POST',
                    data: {
                        offset: offset,
                        limit: outboxPerPage
                    },
                    success: function (html) {
                        $('#outbox-list-container').html(html);
                        outboxCurrentPage = page;
                        outboxUpdatePagination();
                    },
                    error: function () {
                        alert('Failed to load outbox data.');
                    }
                });
            }

            $('#outbox-prev-page').on('click', function () {
                if (outboxCurrentPage > 1) {
                    loadOutboxPage(outboxCurrentPage - 1);
                }
            });

            $('#outbox-next-page').on('click', function () {
                if (outboxCurrentPage < outboxTotalPages) {
                    loadOutboxPage(outboxCurrentPage + 1);
                }
            });
            
            $('.outbox-search-box').on('input', function(){
                let outboxSearchText = $(this).val().toLowerCase();
                $('.outbox-mail-item').each(function(){
                    let outboxItemText = $(this).text().toLowerCase();
                    $(this).toggle(outboxItemText.includes(outboxSearchText));
                });
            });

            outboxUpdatePagination();

            // outbox filter record fetc
            function fetchFilteredOutbox() {
                let selectedStages = $('#outbox_stages_filter').val();
                let deliveryStatus = $('#outbox_delivery_filter').val();
                let searchKeyword = $('#outbox_search_input').val();

                $.ajax({
                    url: '<?= admin_url("Outbox/get_filtered_outbox/" . $lead->id) ?>',
                    type: 'POST',
                    data: {
                        stages: selectedStages,
                        delivery_status: deliveryStatus,
                        search: searchKeyword
                    },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            $('#outbox-list-container').html(response.html);
                            outboxTotalPages = response.total_pages;
                            outboxCurrentPage = 1;
                            outboxUpdatePagination();
                        } else {
                            alert_float('danger','No data found or error occurred.');
                        }
                    },
                    error: function () {
                        alert_float('danger','Server error.');
                    }
                });
            }

            // Bind change event
            $('#outbox_stages_filter, #outbox_delivery_filter').on('change', fetchFilteredOutbox);
            $('#outbox_search_input').on('keyup', function () {
                clearTimeout($.data(this, 'timer'));
                var wait = setTimeout(fetchFilteredOutbox, 500);
                $(this).data('timer', wait);
            });

            // click on outbox item show load the email
            $(document).off('click', '.outbox-mail-content').on('click', '.outbox-mail-content', function () {
                var mailId = $(this).data('id');

                $('.outbox-container').hide();
                $('.outbox-detail-view').show();
                $('.full-page-loader').show();

                $.ajax({
                    url: '<?= admin_url("Outbox/get_email_detail/" . $lead->id) ?>',
                    type: 'POST',
                    dataType: 'json',
                    data: { id: mailId },
                    success: function (response) {
                        if (response.success && response.data.email_page) {
                            $('.outbox-detail-body').html('<iframe id="email-preview-frame" style="width:100%; height:600px; border:none;"></iframe>');

                            setTimeout(function () {
                                var iframe = document.getElementById('email-preview-frame');
                                if (iframe) {
                                    var doc = iframe.contentDocument || iframe.contentWindow.document;
                                    doc.open();

                                    // 1. Create a DOM parser to insert the style directly into the head
                                    var parser = new DOMParser();
                                    var parsedDoc = parser.parseFromString(response.data.email_page, 'text/html');

                                    // 2. Create and insert style element to disable interactivity
                                    var style = parsedDoc.createElement('style');
                                    style.innerHTML = `
                                        a, button, input, textarea, select {
                                            pointer-events: none !important;
                                            cursor: default !important;
                                        }
                                    `;
                                    parsedDoc.head.appendChild(style);

                                    // 3. Write the modified content to the iframe
                                    doc.write(parsedDoc.documentElement.outerHTML);
                                    doc.close();

                                    // Update metadata
                                    $("#outbox_load_email_subject").text(response.data.subject);
                                    if (response.data.lead_status) {
                                        $('#outbox-load-email-status-tag')
                                            .text(response.data.lead_status.name)
                                            .css('background-color', response.data.lead_status.color);
                             