<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
$current_staff_role = get_current_staff_role($this, get_staff_user_id());
?>
<div id="header" style="
    display: flex;
    align-items: center;
    justify-content: space-between;
    ">
    <div class="hide-menu tw-ml-1"><i class="fa fa-align-left"></i></div>

    <nav style="display: flex;align-items: center;">
        <div class="tw-flex tw-justify-between">
            <div class="tw-flex tw-flex-1 sm:tw-flex-initial">
                <?php if($current_staff_role != 2 && $current_staff_role != 6):?>
                <div id="top_search"
                    class="tw-inline-flex tw-relative dropdown sm:tw-ml-1.5 sm:tw-mr-3 tw-max-w-xl tw-flex-auto"
                    data-toggle="tooltip" data-placement="bottom" data-title="<?php echo _l('search_by_tags'); ?>">
                    <input type="search" id="search_input"
                        class="tw-px-4 tw-ml-1 tw-mt-2.5 focus:!tw-ring-0 tw-w-full !tw-placeholder-neutral-400 !tw-shadow-none tw-text-neutral-800 focus:!tw-placeholder-neutral-600 hover:!tw-placeholder-neutral-600 sm:tw-w-[400px] tw-h-[40px] tw-bg-neutral-300/30 hover:tw-bg-neutral-300/50 !tw-border-0"
                        placeholder="<?php echo _l('top_search_placeholder'); ?>" autocomplete="off">
                    <div id="top_search_button" class="tw-absolute rtl:tw-left-0 -tw-mt-2 tw-top-1.5 ltr:tw-right-1" style="top: 50%; left: 85%;">
                        <button class="tw-outline-none tw-border-0 tw-text-neutral-600">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                    <div id="search_results">
                    </div>
                    <ul class="dropdown-menu search-results animated fadeIn search-history" id="search-history">
                    </ul>

                </div>
                <?php endif;?>
                <div id="hover-card" style="display:none; position:absolute; z-index:9999;"
                    class="tw-bg-white tw-shadow-lg tw-rounded-lg tw-p-3 tw-text-sm tw-w-64">
                    <div><strong>ID:</strong> <span id="card-id"></span></div>
                    <div><strong>Name:</strong> <span id="card-name"></span></div>
                    <div><strong>Created:</strong> <span id="card-date"></span></div>
                </div>

            </div>

            <div class="mobile-menu tw-shrink-0 ltr:tw-ml-4 rtl:tw-mr-4">
                <button type="button"
                    class="navbar-toggle visible-md visible-sm visible-xs mobile-menu-toggle collapsed tw-ml-1.5"
                    data-toggle="collapse" data-target="#mobile-collapse" aria-expanded="false">
                    <i class="fa fa-chevron-down fa-lg"></i>
                </button>
                <ul class="mobile-icon-menu tw-inline-flex tw-mt-5">
                    <?php
                    // To prevent not loading the timers twice
                    if (is_mobile()) { ?>
                        <li
                            class="dropdown notifications-wrapper header-notifications tw-block ltr:tw-mr-1.5 rtl:tw-ml-1.5">
                            <?php $this->load->view('admin/includes/notifications'); ?>
                        </li>
                        <li class="header-timers ltr:tw-mr-1.5 rtl:tw-ml-1.5">
                            <a href="#" id="top-timers" class="dropdown-toggle top-timers tw-block tw-h-5 tw-w-5"
                                data-toggle="dropdown">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                                    stroke="currentColor" class="tw-w-5 tw-h-5 tw-shrink-0">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M12 6v6h4.5m4.5 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                <span
                                    class="tw-leading-none tw-px-1 tw-py-0.5 tw-text-xs bg-success tw-z-10 tw-absolute tw-rounded-full -tw-right-3 -tw-top-2 tw-min-w-[18px] tw-min-h-[18px] tw-inline-flex tw-items-center tw-justify-center icon-started-timers<?php echo $totalTimers = count($startedTimers) == 0 ? ' hide' : ''; ?>"><?php echo count($startedTimers); ?></span>
                            </a>
                            <ul class="dropdown-menu animated fadeIn started-timers-top width300" id="started-timers-top">
                                <?php $this->load->view('admin/tasks/started_timers', ['startedTimers' => $startedTimers]); ?>
                            </ul>
                        </li>
                    <?php } ?>
                </ul>
                <div class="mobile-navbar collapse" id="mobile-collapse" aria-expanded="false" style="height: 0px;"
                    role="navigation">
                    <ul class="nav navbar-nav">
                        <li class="header-my-profile"><a href="<?php echo admin_url('profile'); ?>">
                                <?php echo _l('nav_my_profile'); ?>
                            </a>
                        </li>
                        <li class="header-my-timesheets"><a href="<?php echo admin_url('staff/timesheets'); ?>">
                                <?php echo _l('my_timesheets'); ?>
                            </a>
                        </li>
                        <li class="header-edit-profile"><a href="<?php echo admin_url('staff/edit_profile'); ?>">
                                <?php echo _l('nav_edit_profile'); ?>
                            </a>
                        </li>
                        <?php if (is_staff_member()) { ?>
                            <li class="header-newsfeed">
                                <a href="#" class="open_newsfeed mobile">
                                    <?php echo _l('whats_on_your_mind'); ?>
                                </a>
                            </li>
                        <?php } ?>
                        <li class="header-logout">
                            <a href="#" onclick="logout(); return false;">
                                <?php echo _l('nav_logout'); ?>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <ul class="nav navbar-nav navbar-right">
                <?php do_action_deprecated('after_render_top_search', [], '3.0.0', 'admin_navbar_start'); ?>
                <?php hooks()->do_action('admin_navbar_start'); ?>
                <li class="icon header-todo"><a href="#">
                        <p><?php echo ($staff_group_name) ? $staff_role . ' - ' . $staff_group_name : $staff_role; ?>
                        </p>
                    </a></li>
                <li class="icon header-user-profile" data-toggle="tooltip" title="<?php echo get_staff_full_name(); ?>"
                    data-placement="bottom">
                    <a href="#" class="dropdown-toggle profile tw-block rtl:!tw-px-0.5 !tw-py-1" data-toggle="dropdown"
                        aria-expanded="false">
                        <?php echo staff_profile_image($current_user->staffid, ['img', 'img-responsive', 'staff-profile-image-small', 'tw-ring-1 tw-ring-offset-2 tw-ring-primary-500']); ?>
                    </a>
                    <ul class="dropdown-menu animated fadeIn">
                        <li class="header-my-profile"><a
                                href="<?php echo admin_url('profile'); ?>"><?php echo _l('nav_my_profile'); ?></a></li>
                        <!-- <li class="header-my-timesheets"><a
                                href="<?php echo admin_url('staff/timesheets'); ?>"><?php echo _l('my_timesheets'); ?></a>
                        </li> -->
                        <li class="header-edit-profile"><a
                                href="<?php echo admin_url('staff/edit_profile'); ?>"><?php echo _l('nav_edit_profile'); ?></a>
                        </li>
                        <?php if (!is_language_disabled()) { ?>
                            <li class="dropdown-submenu pull-left header-languages">
                                <a href="#" tabindex="-1"><?php echo _l('language'); ?></a>
                                <ul class="dropdown-menu dropdown-menu">
                                    <li class="<?php echo $current_user->default_language == '' ? 'active' : ''; ?>">
                                        <a href="<?php echo admin_url('staff/change_language'); ?>">
                                            <?php echo _l('system_default_string'); ?>
                                        </a>
                                    </li>
                                    <?php foreach ($this->app->get_available_languages() as $user_lang) { ?>
                                        <li
                                            class="<?php echo $current_user->default_language == $user_lang ? 'active' : ''; ?>">
                                            <a href="<?php echo admin_url('staff/change_language/' . $user_lang); ?>">
                                                <?php echo ucfirst($user_lang); ?>
                                            </a>
                                        <?php } ?>
                                </ul>
                            </li>
                        <?php } ?>
                        <li class="header-logout">
                            <a href="#" onclick="logout(); return false;"><?php echo _l('nav_logout'); ?></a>
                        </li>
                    </ul>
                </li>

                <li class="icon header-timers timer-button tw-relative ltr:tw-mr-1.5 rtl:tw-ml-1.5"
                    data-placement="bottom" data-toggle="tooltip" data-title="<?php echo _l('my_timesheets'); ?>">
                    <ul class="dropdown-menu animated fadeIn started-timers-top width300" id="started-timers-top">
                        <?php $this->load->view('admin/tasks/started_timers', ['startedTimers' => $startedTimers]); ?>
                    </ul>
                </li>

                <li class="icon dropdown tw-relative tw-block notifications-wrapper header-notifications rtl:tw-ml-3"
                    data-toggle="tooltip" title="<?php echo _l('nav_notifications'); ?>" data-placement="bottom">
                    <?php $this->load->view('admin/includes/notifications'); ?>
                </li>

                <?php hooks()->do_action('admin_navbar_end'); ?>
            </ul>
        </div>
    </nav>
</div>