<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content email-templates">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-semibold tw-text-lg tw-text-neutral-700">
                    <?php echo _l('email_templates'); ?>
                </h4>
                <div class="panel_s">

                    <div class="panel-body">
                        <div class="row">
                            <?php hooks()->do_action('before_staff_email_templates'); ?>
                            <div class="col-md-12">
                                <h4 class="bold email-template-heading">
                                    <?php echo _l('staff_members'); ?>
                                    <?php if ($hasPermissionEdit) { ?>
                                    <a href="<?php echo admin_url('emails/disable_by_type/staff'); ?>"
                                        class="pull-right mleft5 mright25"><small><?php echo _l('disable_all'); ?></small></a>
                                    <a href="<?php echo admin_url('emails/enable_by_type/staff'); ?>"
                                        class="pull-right"><small><?php echo _l('enable_all'); ?></small></a>
                                    <?php } ?>

                                </h4>
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <span class="tw-font-semibold">
                                                        <?php echo _l('email_templates_table_heading_name'); ?>
                                                    </span>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($staff as $staff_template) { ?>
                                            <tr>
                                                <td class="<?php if ($staff_template['active'] == 0) {
        echo 'text-throught';
    } ?>">
                                                    <a
                                                        href="<?php echo admin_url('emails/email_template/' . $staff_template['emailtemplateid']); ?>"><?php echo $staff_template['name']; ?></a>
                                                    <?php if (ENVIRONMENT !== 'production') { ?>
                                                    <br /><small><?php echo $staff_template['slug']; ?></small>
                                                    <?php } ?>
                                                    <?php if ($hasPermissionEdit && $staff_template['slug'] != 'two-factor-authentication') { ?>
                                                    <a href="<?php echo admin_url('emails/' . ($staff_template['active'] == '1' ? 'disable/' : 'enable/') . $staff_template['emailtemplateid']); ?>"
                                                        class="pull-right"><small><?php echo _l($staff_template['active'] == 1 ? 'disable' : 'enable'); ?></small></a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <?php hooks()->do_action('before_leads_email_templates'); ?>
                            <div class="col-md-12">
                                <h4 class="bold email-template-heading">
                                    <?php echo 'Cases'; ?>
                                    <?php if ($hasPermissionEdit) { ?>
                                    <a href="<?php echo admin_url('emails/disable_by_type/leads'); ?>"
                                        class="pull-right mleft5 mright25"><small><?php echo _l('disable_all'); ?></small></a>
                                    <a href="<?php echo admin_url('emails/enable_by_type/leads'); ?>"
                                        class="pull-right"><small><?php echo _l('enable_all'); ?></small></a>
                                    <?php } ?>

                                </h4>
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <span class="tw-font-semibold">
                                                        <?php echo _l('email_templates_table_heading_name'); ?>
                                                    </span>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($leads as $lead_template) { ?>
                                            <tr>
                                                <td class="<?php if ($lead_template['active'] == 0) {
        echo 'text-throught';
    } ?>">
                                                    <a
                                                        href="<?php echo admin_url('emails/email_template/' . $lead_template['emailtemplateid']); ?>"><?php echo $lead_template['name']; ?></a>
                                                    <?php if (ENVIRONMENT !== 'production') { ?>
                                                    <br /><small><?php echo $lead_template['slug']; ?></small>
                                                    <?php } ?>
                                                    <?php if ($hasPermissionEdit) { ?>
                                                    <a href="<?php echo admin_url('emails/' . ($lead_template['active'] == '1' ? 'disable/' : 'enable/') . $lead_template['emailtemplateid']); ?>"
                                                        class="pull-right"><small><?php echo _l($lead_template['active'] == 1 ? 'disable' : 'enable'); ?></small></a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                          
                            <?php hooks()->do_action('before_gdpr_email_templates'); ?>
                            <div class="col-md-12<?php if (!is_gdpr()) {
        echo ' hide';
    } ?>">
                                <h4 class="bold email-template-heading">
                                    <?php echo _l('gdpr'); ?>
                                    <?php if ($hasPermissionEdit) { ?>
                                    <a href="<?php echo admin_url('emails/disable_by_type/gdpr'); ?>"
                                        class="pull-right mleft5 mright25"><small><?php echo _l('disable_all'); ?></small></a>
                                    <a href="<?php echo admin_url('emails/enable_by_type/gdpr'); ?>"
                                        class="pull-right"><small><?php echo _l('enable_all'); ?></small></a>
                                    <?php } ?>

                                </h4>
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <span class="tw-font-semibold">
                                                        <?php echo _l('email_templates_table_heading_name'); ?>
                                                    </span>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($gdpr as $gdpr_template) { ?>
                                            <tr>
                                                <td class="<?php if ($gdpr_template['active'] == 0) {
        echo 'text-throught';
    } ?>">
                                                    <a
                                                        href="<?php echo admin_url('emails/email_template/' . $gdpr_template['emailtemplateid']); ?>"><?php echo $gdpr_template['name']; ?></a>
                                                    <?php if (ENVIRONMENT !== 'production') { ?>
                                                    <br /><small><?php echo $gdpr_template['slug']; ?></small>
                                                    <?php } ?>
                                                    <?php if ($hasPermissionEdit) { ?>
                                                    <a href="<?php echo admin_url('emails/' . ($gdpr_template['active'] == '1' ? 'disable/' : 'enable/') . $gdpr_template['emailtemplateid']); ?>"
                                                        class="pull-right"><small><?php echo _l($gdpr_template['active'] == 1 ? 'disable' : 'enable'); ?></small></a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <?php hooks()->do_action('after_email_templates'); ?>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
</body>

</html>
