<?php defined('BASEPATH') or exit ('No direct script access allowed'); ?>
<div class="widget" id="widget-<?php echo create_widget_id(); ?>" data-name="<?php echo _l('user_widget'); ?>">
    <div class="panel_s user-data">
        <div class="panel-body home-activity">
            <div class="widget-dragger"></div>
            <div class="horizontal-scrollable-tabs panel-full-width-tabs">
                <div class="scroller scroller-left arrow-left"><i class="fa fa-angle-left"></i></div>
                <div class="scroller scroller-right arrow-right"><i class="fa fa-angle-right"></i></div>
                <div class="horizontal-tabs">
                    <ul class="nav nav-tabs nav-tabs-horizontal" role="tablist">
                        <li role="presentation" class="active">
                            <a href="#home_tab_tasks" aria-controls="home_tab_tasks" role="tab" data-toggle="tab">
                                <i class="fa fa-tasks menu-icon"></i>
                                <?php if (get_current_staff_role($this, get_staff_user_id()) == 2 || get_current_staff_role($this,get_staff_user_id()) == 6): ?>
                                    <?php echo 'My Cases'; ?>
                                <?php else: ?>
                                    <?php echo (!is_admin()) ? 'My Active Cases' : 'Active Cases'; ?>
                                <?php endif; ?>

                            </a>
                        </li>
                        <?php if (is_admin()) { ?>
                            <li role="presentation">
                                <a href="#home_tab_activity" aria-controls="home_tab_activity" role="tab" data-toggle="tab">
                                    <i class="fa fa-window-maximize menu-icon"></i>
                                    <?php echo _l('home_latest_activity'); ?>
                                </a>
                            </li>
                        <?php } ?>
                        <?php hooks()->do_action('after_user_data_widget_tabs'); ?>
                    </ul>
                </div>
            </div>
            <?php
            if (get_current_staff_role($this, get_staff_user_id()) == 2 || get_current_staff_role($this,get_staff_user_id()) == 6) {
                $switch_kanban = 0;
                if ($this->session->userdata('leads_kanban_view') == 'true') {
                    $switch_kanban = 0;
                }
                $switch_kanban_value = 0;

            } else {
                $switch_kanban = 1;
                if ($this->session->userdata('leads_kanban_view') == 'true') {
                    $switch_kanban = 1;
                }
                //  $switch_kanban_value =  $this->session->has_userdata('leads_kanban_view') &&
                //  $this->session->userdata('leads_kanban_view') == 'true';
                $switch_kanban_value = 1;
            }
            //  check when its staff
            if (empty (is_admin())) {
                if (get_current_staff_role($this, get_staff_user_id()) == 2 || get_current_staff_role($this,get_staff_user_id()) == 6) {
                    $samegroup = 2;
                } else {
                    if ($staff_group_name == $lead_data->assign_group) {
                        $samegroup = true;
                    } else {
                        $samegroup = false;
                    }
                }
            } else {
                $samegroup = true;
            }
            ?>
            <div class="tab-content tw-mt-5">
                <div role="tabpanel" class="tab-pane active" id="home_tab_tasks">
                    <div class="row">
                        <div class="col-md-12" style="padding-bottom:20px;">
                            <a href="#" onclick="init_lead(); return false;"
                                class="btn btn-primary mright5 pull-left display-block">
                                <i class="fa-regular fa-plus tw-mr-1"></i>
                                <?php echo 'New Case'; ?>
                            </a>
                            <a class="btn btn-primary"
                                href="<?php echo admin_url('leads/switch_kanban_for_dashboard/' . $switch_kanban_value); ?>"
                                class="mbot20 inline-block full-width">
                                <?php echo 'View All'; ?>
                            </a>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <?php $this->load->view('admin/leads/_leadstable'); ?>
                </div>

                <?php if (is_admin()) { ?>
                    <div role="tabpanel" class="tab-pane" id="home_tab_activity">
                        <a href="<?php echo admin_url('utilities/activity_log'); ?>" class="mbot20 inline-block full-width">
                            <?php echo _l('home_widget_view_all'); ?>
                        </a>
                        <div class="clearfix"></div>
                        <div class="activity-feed">
                            <?php foreach ($activity_log as $log) { ?>
                                <div class="feed-item">
                                    <div class="date">
                                        <span class="text-has-action" data-toggle="tooltip"
                                            data-title="<?php echo _dt($log['date']); ?>">
                                            <?php echo time_ago($log['date']); ?>
                                        </span>
                                    </div>
                                    <div class="text">
                                        <?php echo $log['staffid']; ?><br />
                                        <?php echo $log['description']; ?>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                <?php } ?>
                <?php hooks()->do_action('after_user_data_widge_tabs_content'); ?>
            </div>
        </div>
    </div>
</div>
<!-- <script>
$(document).ready(function() {
    $('.dt-table').DataTable({
        columnDefs: [
            { type: 'date', targets: 3 } // Assuming "Case Created" is the fourth column (index 3)
        ]
    });
});

</script> -->
