<?php

defined('BASEPATH') or exit('No direct script access allowed');

class MergingDoc_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper('leads_helper');
        // $this->load->library('sms/Sms_twilio');
    }
    /**
     * Get Merging Doc Data
     *
     * @param int $lead_id
     * @return array
     */
    public function get_merging_doc_data($lead_id)
    {
        // Load database prefix and select necessary fields
        $this->db->select('id, name, address, phonenumber, email, zip, city, state, martial_status, assign_group, brokerage_id');
        $this->db->from(db_prefix() . 'leads');
        $this->db->where('id', $lead_id);

        // Execute the query and fetch the result
        $query = $this->db->get();
        $lead_data = $query->row_array(); 

        if (!$lead_data) {
            return [];
        }

        // Safely get brokerage name
        $brokerage_name = '';
        if (!empty($lead_data['brokerage_id'])) {
            $brokerage_name = get_brokerage_name_using_brokerage_id($this, $lead_data['brokerage_id']);
        }

        // Prepare merged data
        $mergeDocData = [
            'name'           => $lead_data['name'] ?? '',
            'address'        => $lead_data['address'] ?? '',
            'phone'          => $lead_data['phone'] ?? '',
            'email'          => $lead_data['email'] ?? '',
            'zip'            => $lead_data['zip'] ?? '',
            'city'           => $lead_data['city'] ?? '',
            'state'          => $lead_data['state'] ?? '',
            'martial_status' => $lead_data['martial_status'] ?? '',
            'assign_group'   => $lead_data['assign_group'] ?? '',
            'brokerage_name' => $brokerage_name
        ];

        return $mergeDocData;
    }


}