<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Leads_merge_fields extends App_merge_fields
{
    public function build()
    {
        return [
                [
                    'name'      => 'Case Name',
                    'key'       => '{case_name}',
                    'available' => [
                        'leads',
                    ],
                    'templates' => [
                        'gdpr-removal-request-lead',
                    ],
                ],
                [
                    'name'      => 'Case Email',
                    'key'       => '{case_email}',
                    'available' => [
                        'leads',
                    ],
                     'templates' => [
                        'gdpr-removal-request-lead',
                    ],
                ],
                [
                    'name'      => 'Case Password',
                    'key'       => '{case_password}',
                    'available' => [
                        'leads',
                    ],
                     'templates' => [
                        'gdpr-removal-request-lead',
                    ],
                ],
                [
                    'name'      => 'Case Position',
                    'key'       => '{case_position}',
                    'available' => [
                        'leads',
                    ],
                     'templates' => [
                        'gdpr-removal-request-lead',
                    ],
                ],
                [
                    'name'      => 'Case Website',
                    'key'       => '{case_website}',
                    'available' => [
                        'leads',
                    ],
                     'templates' => [
                        'gdpr-removal-request-lead',
                    ],
                ],
                [
                    'name'      => 'Case Description',
                    'key'       => '{case_description}',
                    'available' => [
                        'leads',
                    ],
                ],
                [
                    'name'      => 'Case Phone Number',
                    'key'       => '{case_phonenumber}',
                    'available' => [
                        'leads',
                    ],
                     'templates' => [
                        'gdpr-removal-request-lead',
                    ],
                ],
                [
                    'name'      => 'Case Company',
                    'key'       => '{case_company}',
                    'available' => [
                        'leads',
                    ],
                     'templates' => [
                        'gdpr-removal-request-lead',
                    ],
                ],
                [
                    'name'      => 'Case Country',
                    'key'       => '{case_country}',
                    'available' => [
                        'leads',
                    ],
                     'templates' => [
                        'gdpr-removal-request-lead',
                    ],
                ],
                [
                    'name'      => 'Case Zip',
                    'key'       => '{case_zip}',
                    'available' => [
                        'leads',
                    ],
                ],
                [
                    'name'      => 'Case City',
                    'key'       => '{case_city}',
                    'available' => [
                        'leads',
                    ],
                ],
                [
                    'name'      => 'Case State',
                    'key'       => '{case_state}',
                    'available' => [
                        'leads',
                    ],
                ],
                [
                    'name'      => 'Case Address',
                    'key'       => '{case_address}',
                    'available' => [
                        'leads',
                    ],
                     'templates' => [
                        'gdpr-removal-request-lead',
                    ],
                ],
                [
                    'name'      => 'Case Assigned',
                    'key'       => '{case_assigned}',
                    'available' => [
                        'leads',
                    ],
                ],
                [
                    'name'      => 'Case Status',
                    'key'       => '{case_status}',
                    'available' => [
                        'leads',
                    ],
                ],
                [
                    'name'      => 'Case Souce',
                    'key'       => '{case_source}',
                    'available' => [
                        'leads',
                    ],
                ],
                [
                    'name'      => 'Case Link',
                    'key'       => '{case_link}',
                    'available' => [
                        'leads',
                    ],
                     'templates' => [
                        'gdpr-removal-request-lead',
                    ],
                ],
                [
                    'name'      => is_gdpr() && get_option('gdpr_enable_case_public_form') == '1' ? 'Case Public Form URL' : '',
                    'key'       => is_gdpr() && get_option('gdpr_enable_case_public_form') == '1' ? '{case_public_form_url}' : '',
                    'available' => [

                    ],
                    'templates' => [
                        'new-web-to-lead-form-submitted',
                    ],
                ],
                [
                    'name'      => is_gdpr() && get_option('gdpr_enable_consent_for_leads') == '1' ? 'Case Consent Link' : '',
                    'key'       => is_gdpr() && get_option('gdpr_enable_consent_for_leads') == '1' ? '{case_public_consent_url}' : '',
                    'available' => [

                    ],
                    'templates' => [
                        'new-web-to-lead-form-submitted',
                    ],
                ],
            ];
    }

    /**
     * Case merge fields
     * @param  mixed $id lead id
     * @return array
     */
    public function format($id)
    {
        $fields = [];

        $fields['{case_name}']               = '';
        $fields['{case_email}']              = '';
        $fields['{case_password}']           = '';
        $fields['{case_position}']           = '';
        $fields['{case_company}']            = '';
        $fields['{case_country}']            = '';
        $fields['{case_zip}']                = '';
        $fields['{case_city}']               = '';
        $fields['{case_state}']              = '';
        $fields['{case_address}']            = '';
        $fields['{case_assigned}']           = '';
        $fields['{case_status}']             = '';
        $fields['{case_source}']             = '';
        $fields['{case_phonenumber}']        = '';
        $fields['{case_link}']               = '';
        $fields['{case_website}']            = '';
        $fields['{case_description}']        = '';
        $fields['{case_public_form_url}']    = '';
        $fields['{case_public_consent_url}'] = '';

        if (is_numeric($id)) {
            $this->ci->db->where('id', $id);
            $lead = $this->ci->db->get(db_prefix().'leads')->row();
        } else {
            $lead = $id;
        }

        if (!$lead) {
            return $fields;
        }

        $fields['{case_public_form_url}']    = leads_public_url($lead->id);
        $fields['{case_public_consent_url}'] = lead_consent_url($lead->id);
        $fields['{case_link}']               = admin_url('leads/index/' . $lead->id);
        $fields['{case_name}']               = $lead->name;
        $fields['{case_email}']              = $lead->email;
        $fields['{case_password}']           = '123456A@';
        $fields['{case_position}']           = $lead->title;
        $fields['{case_phonenumber}']        = $lead->phonenumber;
        $fields['{case_company}']            = $lead->company;
        $fields['{case_zip}']                = $lead->zip;
        $fields['{case_city}']               = $lead->city;
        $fields['{case_state}']              = $lead->state;
        $fields['{case_address}']            = $lead->address;
        $fields['{case_website}']            = $lead->website;
        $fields['{case_description}']        = $lead->description;

        if ($lead->assigned != 0) {
            $fields['{case_assigned}'] = get_staff_full_name($lead->assigned);
        }

        if ($lead->country != 0) {
            $country                  = get_country($lead->country);
            $fields['{case_country}'] = $country->short_name;
        }

        if ($lead->junk == 1) {
            $fields['{case_status}'] = _l('case_junk');
        } elseif ($lead->lost == 1) {
            $fields['{case_status}'] = _l('case_lost');
        } else {
            $this->ci->db->select('name');
            $this->ci->db->from(db_prefix().'leads_status');
            $this->ci->db->where('id', $lead->status);
            $status = $this->ci->db->get()->row();
            if ($status) {
                $fields['{case_status}'] = $status->name;
            }
        }

        $this->ci->db->select('name');
        $this->ci->db->from(db_prefix().'leads_sources');
        $this->ci->db->where('id', $lead->source);
        $source = $this->ci->db->get()->row();
        if ($source) {
            $fields['{case_source}'] = $source->name;
        }

        $custom_fields = get_custom_fields('leads');
        foreach ($custom_fields as $field) {
            $fields['{' . $field['slug'] . '}'] = get_custom_field_value($lead->id, $field['id'], 'leads');
        }

        return hooks()->apply_filters('case_merge_fields', $fields, ['id' => $lead->id, 'lead' => $lead]);
    }
}
