<?php

defined('BASEPATH') or exit('No direct script access allowed');

if (!function_exists('getresponse')) {
    function getresponse($ci, $response) {
        return $ci->output
            ->set_content_type('application/json')
            ->set_status_header($response['status'])
            ->set_output(json_encode($response));
    }
}
if (!function_exists('responseData')) {
    function responseData($query) {
        $CI =& get_instance();  // Access the CodeIgniter instance
        $CI->load->helper('leads_helper');
        $get_pwd = array_column($query, 'password');
        $get_id = array_column($query, 'id');
        $get_userid = array_column($query, 'userid');
        $get_firstname = array_column($query, 'firstname');
        $get_email = array_column($query, 'email');
        $get_lastname = array_column($query, 'lastname');
        $get_phonenumber = array_column($query, 'phonenumber');
        $get_datecreated = array_column($query, 'datecreated');
        $get_role = array_column($query, 'role');
        $get_addition_email = array_column($query, 'additional_email');
        $get_is_password_changed = array_column($query, 'is_password_changed');
        // Convert column value into string
        $password_string = implode(',', $get_pwd);
        $firstname_string = implode(',', $get_firstname);
        $lastname_string = implode(',', $get_lastname);
        $phonenumber_string = implode(',', $get_phonenumber);
        $role_string = implode(',', $get_role);
        $id_string = implode(',', $get_id);
        $userid_string = implode(',', $get_userid);
        $password_string = implode(',', $get_pwd);
        $email_string = implode(',', $get_email);
        $DateCreated = implode('strtotime', $get_datecreated);
        $additional_email_string = implode(',', $get_addition_email);
        $is_password_changed_string = implode(',', $get_is_password_changed);
        // convert datetime to unix timestemp
        if ($is_password_changed_string == 'false') {
            $password_changed = false;
        } else {
            $password_changed = true;
        }
        $timestemp=strtotime($DateCreated);
        $data = array(
            'user_id'=> $id_string,
            'first_name' => $firstname_string,
            'last_name' => $lastname_string,
            'email' => $email_string,
            'additional_email' => $additional_email_string,
            'date_created'=> $timestemp,
            'phone_number' =>  formatted_number($phonenumber_string),
            'role' => strtolower($role_string),
            'is_password_changed' => $password_changed,
        );
        return $data;
    }
}
if (!function_exists('responseData_staff')) {
    function responseData_staff($query) {
        $CI =& get_instance();  // Access the CodeIgniter instance
        $CI->load->helper('leads_helper');
        $get_pwd = array_column($query, 'password');
        $get_id = array_column($query, 'staffid');
        $get_firstname = array_column($query, 'firstname');
        $get_email = array_column($query, 'email');
        $get_lastname = array_column($query, 'lastname');
        $get_phonenumber = array_column($query, 'phonenumber');
        $get_datecreated = array_column($query, 'datecreated');
        $get_role = array_column($query, 'role');
        $get_is_password_changed = array_column($query, 'is_password_changed');
        // Convert column value into string
        $password_string = implode(',', $get_pwd);
        $firstname_string = implode(',', $get_firstname);
        $lastname_string = implode(',', $get_lastname);
        $phonenumber_string = implode(',', $get_phonenumber);
        $role_string = implode(',', $get_role);
        $id_string = implode(',', $get_id);
        $password_string = implode(',', $get_pwd);
        $email_string = implode(',', $get_email);
        $DateCreated = implode('strtotime', $get_datecreated);
        $is_password_changed_string = implode(',', $get_is_password_changed);
        // convert datetime to unix timestemp
        if ($is_password_changed_string == 'false') {
            $password_changed = false;
        } else {
            $password_changed = true;
        }
        $timestemp=strtotime($DateCreated);
        $data = array(
            'user_id'=> $id_string,
            'first_name' => $firstname_string,
            'last_name' => $lastname_string,
            'email' => $email_string,
            'date_created'=> $timestemp,
            'phone_number' =>  formatted_number($phonenumber_string, $CI),
            'role' => $role_string,
            'is_password_changed' => $password_changed,
        );
        return $data;
    }
    if (!function_exists('if_role_is_id_then_get_staff_role_name')) {
        function if_role_is_id_then_get_staff_role_name($ci,$role) {
            if (is_numeric($role) && $role > 0) {
                $ci->db->select('*'); // Select all columns
                $ci->db->from(db_prefix() . 'roles'); // Specify the table name
                // Define your WHERE conditions
                $ci->db->where('roleid', $role);
                // Get the results
                $result = $ci->db->get();
                $query = $result->result();
                $role_name = array_column($query, 'name');
                $role_name_string = implode(',', $role_name);
                $role_name = strtolower($role_name_string);
                return $role_name;
            }
        }
    }
}
