<?php

defined('BASEPATH') or exit('No direct script access allowed');
class Comment extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Comment_model'); // Loads custom model
        $this->load->model('Leads_model');
        $this->load->helper('email_config_helper');
        $this->load->helper('staff_helper');
        $this->load->helper('leads_helper');
        $this->load->library('form_validation');
        $this->load->library('Slack');
        $this->load->library('sms/Sms_twilio');
        $this->load->model('Token_model');
    }

    /*
    public function add_comment($lead_id)
    {
        $this->form_validation->set_rules('comments', 'comment', 'required');
        $this->form_validation->set_rules('recipient_selected_role[]', 'role', 'required');

        $response = array();
        if ($this->form_validation->run() == false) {
            $response = array(
                'success' => false,
                'errors' => 'validation error'
            );
        } else {
            $comment_text = $this->input->post('comments'); // Get comment content
            $recipients = $this->input->post('recipient_selected_role'); // Get recipient role
            $contact_id = get_contact_id_by_lead_id($this, $lead_id); // Get contact ID based on lead
            $contact_user_name = get_contact_full_name($contact_id); // Get contact name

            if ($contact_id && $recipients) {
                $comments_data = array( // Prepare comment data for database
                    'to_user_id' => $contact_id,
                    'from_user_id' => get_staff_user_id(),
                    'lead_id' => $lead_id,
                    'comment_text' => $comment_text,
                    'send_to' => implode(',', $recipients),
                    'role' => 'ld-broker-staff',
                    'type' => 'broker-to-ld',
                    'created_at' => date('Y-m-d H:i:s'),
                );
                $insert_result = $this->Comment_model->add_comment($comments_data);

                if ($insert_result) {
                    $comment_id = $this->db->insert_id();
                    // Insert read status record
                    $read_comment_data = array(
                        'comment_id' => $comment_id,
                        'to_user_id' => $contact_id,
                        'from_user_id' => get_staff_user_id(),
                        'lead_id' => $lead_id,
                        'is_read' => '0',
                        'type' => 'broker-to-ld',
                    );
                    // Insert read comment in DB
                    $this->Comment_model->add_read_comment($read_comment_data);

                    // Add lead activity
                    $lead_activity_data = array(
                        'leadid' => $lead_id,
                        'description' => get_staff_full_name() . ' sent a message to ' . $contact_user_name,
                        'date' => date('Y-m-d H:i:s'),
                        'staffid' => get_staff_user_id(),
                        'full_name' => get_staff_full_name()
                    );

                    // Insert lead activity in DB
                    $this->db->insert(db_prefix() . 'lead_activity_log', $lead_activity_data);

                    // Send Slack notification for broker only
                    $current_staff_role = get_current_staff_role($this, get_staff_user_id());
                    if ($current_staff_role == 2 || $current_staff_role == 6) { // Check if current user is broker
                        // Get lead data for Slack notification
                        $this->db->select('name, assign_group');
                        $this->db->where('id', $lead_id);
                        $lead_data = $this->db->get(db_prefix() . 'leads')->row();

                        if ($lead_data) {
                            $lead_split_name = leads_splitFullName($lead_data->name);
                            $slack_message = " \n - Message from Broker \n - Review the message";
                            $send_notification = $this->slack->sendnotification(
                                $slack_message,
                                $lead_id,
                                $lead_data->assign_group,
                                $lead_split_name['lastname'] . ', ' . $lead_split_name['firstname']
                            );
                        }
                    }

                    $response = array(
                        'success' => true,
                        'message' => 'Comment added successfully',
                        'comment_id' => $comment_id,
                        'lead_id' => $lead_id
                    );
                } else {
                    $response = array(
                        'success' => false,
                        'message' => 'Failed to save comment'
                    );
                }
            } else {
                $response = array(
                    'success' => false,
                    'message' => 'Invalid lead ID or contact not found'
                );
            }
        }

        header('Content-Type: application/json');
        echo json_encode($response);
    }
    */
    public function add_comment($lead_id)
    {
        $this->form_validation->set_rules('comments', 'comment', 'required');
        $this->form_validation->set_rules('recipient_selected_role[]', 'role', 'required');

        $response = array();
        if ($this->form_validation->run() == false) {
            $response = array(
                'success' => false,
                'errors' => 'validation error'
            );
        } else {
            $_POST['get_afternoon_and_morning'] = get_afternoon_and_morning();
            $comment_text = $this->input->post('comments'); // Get comment content
            $recipients = $this->input->post('recipient_selected_role'); // Get recipient role
            $contact_id = get_contact_id_by_lead_id($this, $lead_id); // Get contact ID based on lead
            $contact_user_name = get_contact_full_name($contact_id); // Get contact name

            if ($contact_id && $recipients) {
                $comments_data = array( // Prepare comment data for database
                    'to_user_id' => $contact_id,
                    'from_user_id' => get_staff_user_id(),
                    'lead_id' => $lead_id,
                    'comment_text' => $comment_text,
                    'send_to' => implode(',', $recipients),
                    'role' => 'ld-broker-staff',
                    'type' => 'broker-to-ld',
                    'created_at' => date('Y-m-d H:i:s'),
                );
                $insert_result = $this->Comment_model->add_comment($comments_data);

                if ($insert_result) {
                    $comment_id = $this->db->insert_id();
                    // Insert read status record
                    $read_comment_data = array(
                        'comment_id' => $comment_id,
                        'to_user_id' => $contact_id,
                        'from_user_id' => get_staff_user_id(),
                        'lead_id' => $lead_id,
                        'is_read' => '0',
                        'type' => 'broker-to-ld',
                    );
                    // Insert read comment in DB
                    $this->Comment_model->add_read_comment($read_comment_data);

                    // Add lead activity
                    $lead_activity_data = array(
                        'leadid' => $lead_id,
                        'description' => get_staff_full_name() . ' sent a message to case (#' . $lead_id . ' Name:' . $contact_user_name . ').',
                        'date' => date('Y-m-d H:i:s'),
                        'staffid' => get_staff_user_id(),
                        'full_name' => get_staff_full_name()
                    );

                    // Insert lead activity in DB
                    $this->db->insert(db_prefix() . 'lead_activity_log', $lead_activity_data);

                    // ============ NOTIFICATION SYSTEM ============
                    $this->db->select('id,multiple_cases,client_id,name,assign_group,assigned');
                    $this->db->where('id', $lead_id);
                    $lead_data_check = $this->db->get(db_prefix() . 'leads');

                    if ($lead_data_check->num_rows() > 0) {
                        $lead_data = $lead_data_check->row();
                        $client_id = get_client_id_using_contact_id($this, $lead_data->client_id, $lead_data->multiple_cases);
                        $contact_id_notification = get_contact_id_using_client_id($this, $client_id);
                        $notification_type = get_notification_type(3); // Notification type comment
                        $comment_title = 'New Message Notification';

                        // Get assign group data
                        $this->db->select('assign_group,assigned');
                        $this->db->where('id', $lead_id);
                        $lead_data_for_get_assign_group = $this->db->get(db_prefix() . 'leads')->row();
                        $current_staff_data = get_staff_ids_by_group($this, $lead_data_for_get_assign_group->assign_group);

                        $_POST['case_url'] = admin_url('cases/index/') . $lead_id;
                        $_POST['lead_id'] = $lead_id;

                        $current_staff_role = get_current_staff_role($this, get_staff_user_id());

                        // If current user is broker (role 2 or 6)
                        if ($current_staff_role == 2 || $current_staff_role == 6) {
                            $lead_split_name = leads_splitFullName($lead_data->name);
                            $staff_name = get_staff_full_name();

                            $_POST['name'] = $staff_name;
                            $_POST['case_url'] = admin_url('cases/index/') . $lead_id;
                            $_POST['generic_email_title'] = '';
                            $_POST['generic_email_content'] = 'Good ' . get_afternoon_and_morning() . '<br> Please note the broker has sent a message on this file #' . $lead_id;
                            $_POST['generic_email_back_to_case_url'] = 'Please <a href="' . htmlspecialchars($_POST['case_url'], ENT_QUOTES, 'UTF-8') . '">Click here</a> to access the file.';

                            // Send notification to LD team members
                            foreach ($current_staff_data as $staff_notifiy_data) {
                                if ($staff_notifiy_data['role'] == 1) {
                                    $staff_name_notify = $staff_notifiy_data['firstname'] . ' ' . $staff_notifiy_data['lastname'];
                                    $comment_message = get_staff_full_name() . ' sent a message to ' . $staff_name_notify;

                                    if (get_staff_user_id() != $staff_notifiy_data['staffid']) {
                                        $read_comment_data_notify = array(
                                            'comment_id' => $comment_id,
                                            'to_user_id' => $staff_notifiy_data['staffid'],
                                            'from_user_id' => get_staff_user_id(),
                                            'lead_id' => $lead_id,
                                            'is_read' => '0',
                                            'type' => 'broker-to-ld'
                                        );
                                        $this->Comment_model->add_read_comment($read_comment_data_notify);

                                        $ldteam_notify_type = $notification_type;
                                        $ld_team_notify_title = $comment_title;
                                        $ld_team_notify_message = $comment_message;
                                        $comment_type = 'broker';

                                        // Send mobile notification
                                        send_notification_in_mobile('staff', $staff_notifiy_data['staffid'], $contact_id_notification, $client_id, $lead_id, $ld_team_notify_title, $ld_team_notify_message, $ldteam_notify_type, '', $comment_type);

                                        // Send CRM notification
                                        $this->Leads_model->custom_lead_assigned_member_notification('staff', $lead_id, $staff_notifiy_data['staffid'], get_staff_user_id(), '', $comment_message);
                                    }
                                }
                            }

                            // Send notification to admin
                            $admin_ids = get_all_admin_role_staff_ids($this);
                            foreach ($admin_ids as $admin_email) {
                                $get_staff_record = get_staff_name_by_id($this, $admin_email['staffid']);
                                $comment_message = get_staff_full_name() . ' sent a message to ' . $get_staff_record;

                                $read_comment_data_admin = array(
                                    'comment_id' => $comment_id,
                                    'to_user_id' => $admin_email['staffid'],
                                    'from_user_id' => get_staff_user_id(),
                                    'lead_id' => $lead_id,
                                    'is_read' => '0',
                                    'type' => 'broker-to-ld'
                                );
                                $this->Comment_model->add_read_comment($read_comment_data_admin);

                                $admin_notify_type = $notification_type;
                                $admin_notify_title = $comment_title;
                                $admin_notify_message = $comment_message;
                                $comment_type = 'broker';

                                // Send mobile notification
                                send_notification_in_mobile('staff', $admin_email['staffid'], $contact_id_notification, $client_id, $lead_id, $admin_notify_title, $admin_notify_message, $admin_notify_type, '', $comment_type);

                                // Send CRM notification
                                $this->Leads_model->custom_lead_assigned_member_notification('staff', $lead_id, $admin_email['staffid'], get_staff_user_id(), '', $comment_message);
                            }


                            // Send Slack notification
                            $slack_message = " \n - Message from Broker \n - Review the message";
                            $send_notification = $this->slack->sendnotification($slack_message, $lead_id, $lead_data->assign_group, $lead_split_name['lastname'] . ', ' . $lead_split_name['firstname']);
                        } else {
                            // If current user is not broker - send notification to broker
                            $this->db->select('addedfrom');
                            $this->db->where('id', $lead_id);
                            $get_broker_data = $this->db->get(db_prefix() . 'leads')->row();

                            if ($get_broker_data && !empty($get_broker_data->addedfrom)) {
                                $addedfrom_ids = explode(',', $get_broker_data->addedfrom);

                                foreach ($addedfrom_ids as $addedfrom_id) {
                                    $get_staff_name = get_staff_name_by_id($this, $addedfrom_id);
                                    $comment_message = get_staff_full_name() . ' sent a message to ' . $get_staff_name;

                                    // Send CRM notification
                                    $this->Leads_model->custom_lead_assigned_member_notification('staff', $lead_id, $addedfrom_id, get_staff_user_id(), '', $comment_message);
                                }

                                // Send notification to admin broker
                                $brokerage_id = get_brokerage_id_using_leadid($this, $lead_id);
                                $admin_broker_ids = get_all_admin_broker_role_staff_ids($this, $brokerage_id);

                                foreach ($admin_broker_ids as $admin_broker_email) {
                                    if (get_staff_user_id() != $admin_broker_email['staffid'] && !in_array($admin_broker_email['staffid'], explode(',', $get_broker_data->addedfrom))) {
                                        $comment_message = get_staff_full_name() . ' sent a message to ' . $admin_broker_email['firstname'] . ' ' . $admin_broker_email['lastname'];

                                        // Send CRM notification
                                        $this->Leads_model->custom_lead_assigned_member_notification('staff', $lead_id, $admin_broker_email['staffid'], get_staff_user_id(), '', $comment_message);
                                    }
                                }
                            }
                        }
                    }
                    // ============ END NOTIFICATION SYSTEM ============

                    $response = array(
                        'success' => true,
                        'message' => 'Comment added successfully',
                        'comment_id' => $comment_id,
                        'lead_id' => $lead_id
                    );
                } else {
                    $response = array(
                        'success' => false,
                        'message' => 'Failed to save comment'
                    );
                }
            } else {
                $response = array(
                    'success' => false,
                    'message' => 'Invalid lead ID or contact not found'
                );
            }
        }

        header('Content-Type: application/json');
        echo json_encode($response);
    }

    public function get_comments($lead_id)
    {
        // Validate lead_id
        if (empty($lead_id) || !is_numeric($lead_id)) {
            $response = array(
                'success' => false,
                'message' => 'Invalid lead ID'
            );
            header('Content-Type: application/json');
            echo json_encode($response);
            return;
        }

        // Get current user's role
        $staff_id = get_staff_user_id();
        $current_role_id = get_current_staff_role($this, $staff_id);
        $current_role = strtolower(get_staff_role($this, $current_role_id));

        // Get user ID and comments
        $user_id = get_contact_id_by_lead_id($this, $lead_id);

        // Fetch comments
        $comments = $this->Comment_model->getCommentsWithUserInfo($user_id, $lead_id);

        // Role-based filtering e.g. $current_role === 'ld-team' and same for $author_role === 'ld-team'
        if ($current_role === 'broker') {
            $comments = array_filter($comments, function ($comment) use ($current_role) {

                // Fetch comment author's role
                $author_role_id = get_current_staff_role($this, $comment->from_user_id);
                $author_role = strtolower(get_staff_role($this, $author_role_id));

                // If author is broker or ld-team
                if ($author_role === 'broker') {
                    return true;
                }


                if (!isset($comment->send_to) || empty($comment->send_to)) {
                    return false;
                }

                $send_to_roles = array_map('trim', explode(',', $comment->send_to));
                $send_to_roles = array_map('strtolower', $send_to_roles);

                return in_array($current_role, $send_to_roles);
            });
            $comments = array_values($comments);
        }

        // Add sender_name for each comment
        if (!empty($comments)) {
            foreach ($comments as &$comment) {
                if (isset($comment->from_user_id) && !empty($comment->from_user_id)) {
                    $comment->sender_name = get_staff_name_by_id($this, $comment->from_user_id);
                    $comment->sender_role = get_staff_role($this, get_current_staff_role($this, $comment->from_user_id));
                    $comment->sender_profile_path = staff_profile_image_url($comment->from_user_id);
                    $comment->created_at = time_ago($comment->created_at);
                } else {
                    $comment->sender_name = null;
                    $comment->sender_role = null;
                    $comment->sender_profile_path = null;
                }
            }
            unset($comment); // Break reference

            $response = array(
                'success' => true,
                'comments' => $comments,
                'total_comments' => count($comments)
            );
        } else {
            $response = array(
                'success' => false,
                'message' => 'Failed to retrieve comments'
            );
        }

        header('Content-Type: application/json');
        echo json_encode($response);
        return;
    }
}
