<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Reset_password extends CI_Controller  { 
    public function __construct()
    {
        parent::__construct(); 

        $this->load->library('form_validation');
        $this->load->database();
        $this->load->model('Contacts_model');
        $this->load->library('email');
        $this->load->library('input');
    }
    public function index($email){
        if ($email !== null) {
            $decoded_email = urldecode($email);
            $email_decode = base64_decode($decoded_email);
            $data = array(
                'email' => $email_decode,
            );
            $this->load->view('password_reset', $data);
        } 
    }
    public function passwordReset(){
       
        $email = $this->input->post('email');
        $password = $this->input->post('password');
        if ($this->input->server('REQUEST_METHOD') === 'POST') {
            // Set password validation
            $this->form_validation->set_rules('password', 'Password', 'required|min_length[8]');
            $this->form_validation->set_rules('confirm_password', 'Password Confirmation', 'required|matches[password]');
            //Get message
            $this->form_validation->set_message('required', _l('form_validation_required'));
            $this->form_validation->set_message('valid_email', _l('form_validation_valid_email'));
            $this->form_validation->set_message('matches', _l('form_validation_matches'));
                if ($this->form_validation->run() === true) {
                    $data = $this->Contacts_model->getEmail($email);
                    if(!empty($data)){
                        $hashed_password = password_hash($password, PASSWORD_BCRYPT);
                        // Perform the update
                        $this->db->where('email', $email); // Set the WHERE condition
                        $data = array(
                            'password' => $hashed_password,
                            // Add more fields and their new values as needed
                        );
                      $check=  $this->db->update(db_prefix() . 'contacts', $data);
                        if ($check === true) {
                            $this->session->set_flashdata('success', 'Your Password Updated Successfully.');
                            $data = array(
                                'email' => $email,
                            );
                           $this->load->view('password_reset',$data);

                        }else{
                            $this->session->set_flashdata('errors', 'Email is not Exist in our record.');
                            $this->load->view('password_reset',$data);
                        }
                        
                    }else{
                        $this->session->set_flashdata('errors', 'Email is not Exist in our record.');
                        $this->load->view('password_reset',$data);
                    }
                }else{
                    $data = array(
                        'email' => $email,
                    );
                    $this->load->view('password_reset',$data);
                }
        } 
        else {
            $this->session->set_flashdata('errors', 'Your Request Method is Unknow.');
                redirect($_SERVER['HTTP_REFERER']);
        }

    }
}
