<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<!DOCTYPE html>
<html lang="en" dir="<?php echo is_rtl() ? 'rtl' : 'ltr'; ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="user-scalable=no, width=device-width, initial-scale=1, maximum-scale=1">
    <title>
        <?php echo get_option('companyname'); ?> - <?php echo _l('admin_auth_login_heading'); ?>
    </title>
    <link rel="stylesheet" type="text/css" id="inter-font" href="<?php echo base_url('/assets/plugins/inter/inter.css?v=3.0.6');?>">
<link rel="stylesheet" type="text/css" id="reset-css" href="<?php echo base_url('/assets/css/reset.min.css?v=3.0.6');?>">
<link rel="stylesheet" type="text/css" id="bootstrap-css" href="<?php echo base_url('/assets/plugins/bootstrap/css/bootstrap.min.css?v=3.0.6');?>">
<link rel="stylesheet" type="text/css" id="tailwind-css" href="<?php echo base_url('/assets/builds/tailwind.css?v=3.0.6');?>">
    <style>
    body,
    html {
        font-size: 16px;
    }

    body>* {
        font-size: 14px;
    }

    body {
        font-family: "Inter", sans-serif;
        color: #475569;
        margin: 0;
        padding: 0;
    }

    .company-logo {
        padding: 25px 10px;
        display: block;
    }

    .company-logo img {
        margin: 0 auto;
        display: block;
    }

    @media screen and (max-height: 575px),
    screen and (min-width: 992px) and (max-width:1199px) {

        #rc-imageselect,
        .g-recaptcha {
            transform: scale(0.83);
            -webkit-transform: scale(0.83);
            transform-origin: 0 0;
            -webkit-transform-origin: 0 0;
        }
    }
    </style>
    <?php if (show_recaptcha()) { ?>
    <script src='https://www.google.com/recaptcha/api.js'></script>
    <?php } ?>
    <?php if (file_exists(FCPATH . 'assets/css/custom.css')) { ?>
    <link href="<?php echo base_url('assets/css/custom.css'); ?>" rel="stylesheet" id="custom-css">
    <?php } ?>
    <?php hooks()->do_action('app_admin_authentication_head'); ?>
</head>

<body class="tw-bg-neutral-100 login_admin">

    <div class="tw-max-w-md tw-mx-auto tw-pt-24 authentication-form-wrapper tw-relative tw-z-20">
        <div class="company-logo text-center">
            <?php get_dark_company_logo(); ?>
        </div>

        <h1 class="tw-text-2xl tw-text-neutral-800 text-center tw-font-semibold tw-mb-5">
            <?php echo _l('Reset Password'); ?>
        </h1>

        <div class="tw-bg-white tw-mx-2 sm:tw-mx-6 tw-py-6 tw-px-6 sm:tw-px-8 tw-shadow tw-rounded-lg">

            <?php $this->load->view('authentication/includes/alerts'); ?>

            <?php 
            $action_url = base_url('/reset_password/passwordReset').'';
            // Form method (POST in this case)
            $form_attributes = array(
                'method' => 'post'
            );
            echo form_open($action_url, $form_attributes);
             ?>

            <?php echo validation_errors('<div class="alert alert-danger text-center">', '</div>'); ?>
            <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
                <?= $this->session->flashdata('success') ?>
            </div>
                 <?php endif; ?>
                 <?php if ($this->session->flashdata('errors')): ?>
            <div class="alert alert-danger">
                <?= $this->session->flashdata('errors') ?>
            </div>
                 <?php endif; ?>

            <?php hooks()->do_action('after_admin_login_form_start'); ?>

            <div class="form-group">
                <label for="email" class="control-label">
                    <?php echo _l('Enter New Password'); ?>
                </label>
                <input type="password" id="email" name="password" class="form-control" autofocus="1">
            </div>
            <input type="hidden" id="email" name="email" class="form-control" value="<?php print_r($email);?>" autofocus="1">
            <div class="form-group">
                <label for="password" class="control-label">
                    <?php echo _l('Enter Confirm Password'); ?>
                </label>
                <input type="password" id="password" name="confirm_password" class="form-control">
            </div>
            <!-- <div class="form-group">
                <div class="checkbox checkbox-inline">
                    <input type="checkbox" value="estimate" id="remember" name="remember">
                    <label for="remember"> <?php echo _l('admin_auth_login_remember_me'); ?></label>
                </div>
            </div> -->

            <div class="form-group">
                <button type="submit" class="btn btn-primary btn-block">
                    <?php echo _l('Update'); ?>
                </button>
            </div>

            <!-- <div class="form-group">
                <a href="<?php echo admin_url('authentication/forgot_password'); ?>">
                    <?php echo _l('admin_auth_login_fp'); ?>
                </a>
            </div> -->

            <?php hooks()->do_action('before_admin_login_form_close'); ?>

            <?php echo form_close(); ?>
        </div>
    </div>

</body>

</html>