
<?php if (!empty($outbox_records['data'])): ?>
<?php foreach ($outbox_records['data'] as $record): ?>
    <?php
        // Set dynamic wrapper classes
        $classes = ['outbox-mail-item'];
        if ($record['delivery_status'] === 'fail') {
            $classes[] = 'outbox-error';
        }
        if (!empty($record['viewed'])) {
            $classes[] = 'outbox-highlighted';
        }
        $item_class = implode(' ', $classes);
    ?>
    <div class="<?= $item_class ?>" data-id="<?= $record['id'] ?>">
        <div class="outbox-checkbox-wrapper">
            <input type="checkbox" class="outbox-checkbox" value="<?= $record['id'] ?>" />
        </div>
        <div class="outbox-mail-content" data-id="<?= $record['id'] ?>">
            
            <!-- To -->
         <div class="outbox-mail-to">
            <strong>To:
                <?php
                    $recipients = $record['to_emails']['recipients'] ?? [];
                    $names = array_map(function ($e) {
                        if (is_array($e)) {
                            $name = trim(($e['firstname'] ?? '') . ' ' . ($e['middlename'] ?? '') . ' ' . ($e['lastname'] ?? ''));
                            return $name ?: ($e['email'] ?? '');
                        }
                        return $e;
                    }, $recipients);

                    $names = array_filter($names); // remove empty values

                    $to_string = count($names) === 1 ? $names[0] : implode(', ', $names);

                    // Limit to 30 words
                    $words = explode(' ', $to_string);
                    if (count($words) > 20) {
                        $to_string = implode(' ', array_slice($words, 0, 20)) . '...';
                    }

                    echo htmlspecialchars($to_string);
                ?>
            </strong>
        </div>



            <!-- Subject & Tags -->
            <div class="outbox-mail-subject">
                <div class="outbox-subject-section">

                    <!-- Lead Status Tag -->
                   <?php if (!empty($record['lead_status']['name'])): ?>
                        <span class="outbox-tag" style="
                            background-color: <?= htmlspecialchars($record['lead_status']['color']) ?>;
                            display: inline-block;
                            padding: 2px 8px;
                            font-size: 13px;
                            line-height: 1.4;
                            border-radius: 4px;
                            vertical-align: middle;
                        ">
                            <?= htmlspecialchars($record['lead_status']['name']) ?>
                        </span>
                    <?php endif; ?>


                    <!-- Subject -->
                    <span class="outbox-email-subject">
                        <?php
                            $content = '';
                            if (!empty($record['context']) && !empty($record['context'][0]['email_content'])) {
                                $content = $record['context'][0]['email_content'];
                            } else {
                                $content = 'No Subject';
                            }
                            $plainText = strip_tags($content);
                            $words = explode(' ', $plainText);
                            $trimmed = implode(' ', array_slice($words, 0, 30));
                            echo htmlspecialchars($trimmed . (count($words) > 30 ? '...' : ''));
                        ?>
                    </span>
                </div>

                <!-- Attachments -->
                <?php if (!empty($record['attachments'])): ?>
                    <?php foreach ($record['attachments'] as $file): ?>
                        <?php
                            $ext = strtolower($file['file_type']);
                            $previewSrc = base_url('assets/images/general.webp');
                            $label = 'File';

                            if (in_array($ext, ['jpeg', 'jpg', 'png', 'heic'])) {
                                    $previewSrc = base_url('assets/images/allimage.webp');
                                    $label = 'Image';
                            } elseif ($ext === 'pdf') {
                                    $previewSrc = base_url('assets/images/pdf.webp');
                                    $label = 'PDF';
                            } elseif (in_array($ext, ['doc', 'docx'])) {
                                    $previewSrc = base_url('assets/images/msword_new.webp');
                                    $label = 'Word';
                            }
                        ?>
                        <a href="<?= $file['file_url'] ?>" target="_blank" class="outbox-doc-image-badge">
                            <img src="<?= $previewSrc ?>" alt="<?= htmlspecialchars($file['file_name']) ?>" />
                            <span><?= $label ?> File</span>
                        </a>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>

            <!-- Actions -->
            <div class="outbox-mail-actions">
                <div class="outbox-mail-time">
                    <?= !empty($record['created_at']) ? date('h:i A', strtotime($record['created_at'])) : '' ?>
                </div>
                <?php if ($record['delivery_status'] === 'fail'): ?>
                    <span class="outbox-doc-item-hover"><i class="fa fa-exclamation-circle"></i></span>
                <?php endif;?>
                <button class="outbox-delete-btn" data-id="<?= $record['id'] ?>">
                    <i class="fa fa-trash"></i>
                </button>
            </div>
        </div>
    </div>
<?php endforeach; ?>
<?php else: ?>
<div class="no-outbox-message">
    <p>No outbox emails found.</p>
</div>
<?php endif; ?>