<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s panel-table-full">
                    <div class="panel-body">
                        <div class="clearfix"></div>
                        <div class="col-md-6">
                            <?php if (empty($state_data)) { ?>
                                <?php echo form_open((admin_url('cases/add_states')), ['id' => 'myForm']); ?>
                               <div class="form-group" app-field-wrapper="doc_type">
                                    <label for="state" class="control-label">Enter State</label>
                                    <input type="text" class="form-control" id="state" name="state" placeholder="State">
                                    <div class="invalid-feedback" style="color:red; margin-top:4px;"></div>

                                    <label for="address" class="control-label" style="margin-top:10px;">Enter Address</label>
                                    <input type="text" class="form-control" id="address" name="address" placeholder="Address">
                                    <div class="invalid-feedback" style="color:red; margin-top:4px;"></div>

                                    <input type="submit" class="btn btn-primary" id="submitButton" style="margin-top: 10px; float:right;" value="Submit">
                                </div>
                                <?php echo form_close(); ?>
                            <?php
                            } else { ?>
                                <?php echo form_open((admin_url('cases/add_states')), ['id' => 'edit_myForm']); ?>
                               <div class="form-group" app-field-wrapper="doc_type">
                                    <label for="state" class="control-label">Enter State</label>
                                    <input type="text" class="form-control" id="state" name="state"
                                        value="<?php echo $state_data->state_name; ?>" placeholder="State">
                                    <div class="invalid-feedback" style="color:red; margin-top:4px;"></div>

                                    <label for="address" class="control-label" style="margin-top: 10px;">Enter Address</label>
                                    <input type="text" class="form-control" id="address" name="address"
                                        value="<?php echo $state_data->address; ?>" placeholder="Address">
                                    <div class="invalid-feedback" style="color:red; margin-top:4px;"></div>

                                    <input type="hidden" id="state_id" name="state_id"
                                        value="<?php echo $state_data->id; ?>">

                                    <button type="submit" class="btn btn-primary" style="margin-top: 10px; float:right;">Update</button>
                                </div>
                                <?php echo form_close(); ?>
                            <?php } ?>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-leads customizable-table number-index-2 dataTable no-footer">
                                <thead>
                                    <th>State name</th>
                                    <th>State Address</th>
                                    <th style="display:flex;justify-content:center;">Action</th>
                                </thead>
                                <tbody id="stateList">
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
    $(document).ready(function () {
        // Load states when the page loads
        loadStates();

        // Handle form submission
        $('#myForm').submit(function (event) {
            event.preventDefault();
            $('.invalid-feedback').empty();
            var formData = $(this).serialize();
            $.ajax({
                type: 'POST',
                url: '<?php echo base_url('admin/cases/add_states'); ?>',
                data: formData,
                dataType: 'json',
                success: function (response) {
                    if (response.status === 'error') {
                        $('.invalid-feedback').text(response.message);
                    } else {
                        $('#myForm')[0].reset();
                        loadStates();
                        alert_float('success', 'State added successfully.');
                    }
                },
                error: function (xhr, status, error) {
                    console.log('Error fetching data');
                }
            });
        });
        // edit form valitdtion
        $('#edit_myForm').submit(function (event) {
            event.preventDefault();
            $('.invalid-feedback').empty();
            var formData = $(this).serialize();
            $.ajax({
                type: 'POST',
                url: '<?php echo base_url('admin/cases/add_states'); ?>',
                data: formData,
                dataType: 'json',
                success: function (response) {
                    if (response.status === 'error') {
                        $('.invalid-feedback').text(response.message);
                    } else {
                        loadStates();
                        alert_float('success', 'State updated successfully.');
                    }
                },
                error: function (xhr, status, error) {
                    console.log('Error fetching data');
                }
            });
        });

        // Function to load states using AJAX
        function loadStates() {
            $.ajax({
                type: 'GET',
                url: '<?php echo base_url('admin/cases/show_all_states'); ?>',
                dataType: 'json',
                success: function (response) {
                    $('#stateList').empty();
                    $.each(response, function (index, state) {
                        var newRow = $('<tr>');
                        newRow.append('<td>' + state.state_name + '</td>');
                        newRow.append('<td>' + (state.state_address ? state.state_address : '-') + '</td>');
                        var actionColumn = $('<td>');
                        actionColumn.append('<a href="<?php echo base_url('/admin/cases/states/') ?>' + state.id + '" class="btn btn-primary edit-record">Edit</a>');
                        actionColumn.append('<button data-id="' + state.id + '" class="btn btn-danger delete-btn" style="margin-left:5px;">Delete</button>');
                        newRow.append(actionColumn);
                        $('#stateList').append(newRow);
                    });
                },
                error: function (xhr, status, error) {
                    console.log('Error fetching data');
                }
            });

        }
    });
    // delete the state data
    $(document).on('click', '.delete-btn', function () {
        var stateId = $(this).data('id');
        var row = $(this).closest('tr');
        // if (confirm("Are you sure you want to delete this record?")) {
            $.ajax({
                type: 'POST',
                url: '<?php echo base_url('admin/cases/delete_state'); ?>',
                data: { id: stateId },
                dataType: 'json',
                success: function (response) {
                    if (response.status == 'success') {
                        row.fadeOut(400, function () {
                            $(this).remove();
                        });
                        alert_float('success', 'Record deleted successfully.');
                    } else {
                        alert_float('error', 'Failed to delete record!');
                    }
                },
                error: function (xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        // }
    });


</script>
</body>

</html>