<?php
defined('BASEPATH') or exit('No direct script access allowed');
?>
<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta name="x-apple-disable-message-reformatting">
    <title></title>
    <!--[if mso]>
  <style>
    table {border-collapse:collapse;border-spacing:0;border:none;margin:0;}
    div, td {padding:0;}
    div {margin:0 !important;}
  </style>
  <noscript>
    <xml>
      <o:OfficeDocumentSettings>
        <o:PixelsPerInch>96</o:PixelsPerInch>
      </o:OfficeDocumentSettings>
    </xml>
  </noscript>
  <![endif]-->
    <style>
        table,
        td,
        div,
        h1,
        p {
            color: var(--Body, #333);
            font-family: Inter;
            font-size: 16px;
            font-style: normal;
            font-weight: 400;
            line-height: 30px;
        }

        .wrapper {
            background-color: #fff;
            max-width: 40em;
            margin: 0 auto;
            padding: 3em;

            /* General horizontal line styles */
            hr {
                margin-bottom: 2em;
            }
        }

        /* Basic horizontal line */
        .plain {
            background-color: rgba(0, 0, 0, 0.24);
            border: none;
            height: 3px;
            /* padding-top: 0px; */
            margin-top: 66px;
            width: 135px;
        }

        @media screen and (max-width: 530px) {
            .unsub {
                display: block;
                padding: 8px;
                margin-top: 14px;
                border-radius: 6px;
                background-color: #555555;
                text-decoration: none !important;
                font-weight: bold;
            }

            .col-lge {
                max-width: 100% !important;
            }
        }

        @media screen and (min-width: 531px) {
            .col-sml {
                max-width: 27% !important;
            }

            .col-lge {
                max-width: 73% !important;
            }
        }
    </style>
</head>

<body style="margin:0;padding:0;word-spacing:normal;background-color:#FAFCFD;">
    <div role="article" aria-roledescription="email" lang="en"
        style="text-size-adjust:100%;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#FAFCFD;">
        <table role="presentation" style="width:100%;border:none;border-spacing:0;">
            <tr>
                <td align="center" style="padding:0;">
                    <!--[if mso]>
          <table role="presentation" align="center" style="width:600px;">
          <tr>
          <td>
          <![endif]-->
                    <table role="presentation"
                        style="width:94%;max-width:600px;border:none;border-spacing:0;text-align:left;font-family:Arial,sans-serif;font-size:16px;line-height:22px;color:#363636;">
                        <tr>
                            <td style="padding: 85px 30px 30px 30px;text-align:center;font-size:24px;font-weight:bold;">
                                <a href="https://www.legaldirect.ca/" style="text-decoration:none;"><img
                                        src='<?php echo base_url('assets/Email_images/Ld_logo.png'); ?>' width="90"
                                        alt="Legal Direct"
                                        style="width:90px;max-width:80%;height:auto;border:none;text-decoration:none;color:#ffffff;"></a>
                                <h3 style="padding-bottom:20px;line-height:35.2px;">
                                </h3>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding:30px 30px 0px 30px;background-color:#FFF;">
                                <!-- <p style="margin:0px;">Dear <?= $_POST['broker_name'] ?>,</p> -->
                                <p style="margin:0px;">Dear Colleague,</p>
                                <p>We are delighted to inform you that the file has successfully moved through another
                                    milestone, we have all items required by the lender instructions and we have
                                    requested funds.
                                </p>
                                <p>We await a review of any mortgage conditions that remain outstanding and
                                    thereafter the confirmation of funding.</p>
                                <p>Please progress the file by <a href="<?= $_POST['case_url'];?>">Click here</a>.</p>
                                <p>Kind Regards,</p>
                                <p style="margin: 0;font-size: 15px;font-weight: 800;color: #2c89f1;">
                                    <!-- get the current staff signature -->
                                    <?php echo get_current_staff_signature($this, get_staff_user_id()); ?>
                                <h3 style="margin: 0;font-size: 22px;font-weight: bold;color: #2c89f1;">Legal Direct
                                </h3>
                                </p>
                                <p>30 Via Renzo Drive, Suite 200,<br>Richmond Hill, ON, L4S 0B8</p>
                                <p style="margin: 0;">(T) <a href="tel:905%20787%202296" style="color:#2c89f1;">905 787
                                        2296</a></p>
                                <p style="margin: 0;">(F) <a href="tel:905%20237%206325" style="color:#2c89f1;">905 237
                                        6325</a></p>
                                <?php
                                $ci = get_instance();
                                $staff_id = get_staff_user_id();
                                $data = get_staff_email_by_staffid($ci, $staff_id);
                                ?>
                                <p style="margin: 0;">
                                    (E)
                                    <?php if ($data && isset($data->email)): ?>
                                        <a href="mailto:<?php echo $data->email; ?>" style="color:#2c89f1;">
                                            <?php echo $data->email; ?>
                                        </a>
                                    <?php endif; ?>
                                </p>
                                <p><a href="http://www.legaldirect.ca/"
                                        style="color:#2c89f1;font-weight:800;font-size:20px;">www.legaldirect.ca</a></p>
                                <a href="http://www.legaldirect.ca/"><img
                                        src="<?php echo base_url('assets/Email_images/Legal_direct_logo.png'); ?>"
                                        style="height: 30px;margin-bottom: 20px;"></a>
                            </td>
                        </tr>
                        <tr>
                            <td
                                style="padding:30px;text-align:center;font-size:12px;background-color:transparent;color:#999999;">
                                <p style="margin:0 0 8px 0;">
                                    <a href="https://twitter.com/" style="text-decoration:none;">
                                        <img src="<?php echo base_url('assets/Email_images/twitter.png'); ?>" alt=""
                                            style="margin:8px;">
                                    </a>
                                    <a href="https://www.facebook.com/" style="text-decoration:none;">
                                        <img src="<?php echo base_url('assets/Email_images/facebook.png'); ?>" alt=""
                                            style="margin:8px;">
                                    </a>
                                    <a href="https://www.linkedin.com/home" style="text-decoration:none;">
                                        <img src="<?php echo base_url('assets/Email_images/linkdin.png'); ?>" alt=""
                                            style="margin:8px;">
                                    </a>
                                </p>
                                <a href="https://www.legaldirect.ca/" style="text-decoration:none;">
                                    <img src='<?php echo base_url('assets/Email_images/legaldirect.png'); ?>' width="90"
                                        alt="Logo"
                                        style="width:90px;max-width:80%;height:auto;border:none;text-decoration:none;color:#ffffff;">
                                </a>
                                <p style="margin:0;font-size:14px;line-height:20px;">Copyright © 2024</p>
                                <!-- <p
                                    style="color: var(--Text-Light, #999);text-align: center;font-family: Inter;font-size: 12px;font-style: normal;font-weight: 400;line-height: 16px;">
                                    Legal Direct Association</p>
                                <p
                                    style="color: var(--Text-Light, #999);text-align: center;font-family: Inter;font-size: 12px;font-style: normal;font-weight: 400;line-height: 16px;">
                                    Satisfied clients are our goal and measurement for success.</p> -->
                            </td>
                        </tr>
                    </table>
                    <!--[if mso]>
          </td>
          </tr>
          </table>
          <![endif]-->
                </td>
            </tr>
        </table>
    </div>
</body>

</html>