<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s panel-table-full">
                    <div class="panel-body">
                        <div class="clearfix"></div>
                        <?php if (!empty($checklist_templates_formdata->id)) {
                            $id = $checklist_templates_formdata->id;
                        } else {
                            $id = '';
                        } ?>
                        <?php echo form_open((admin_url('Cases/add_checklist_template/' . $id)), ['id' => 'checklist_form']); ?>
                        <div class="col-md-6">
                            <div style="margin-bottom: 15px;">
                                <?php
                                $selected = !empty($checklist_templates_formdata->addedfrom) ? $checklist_templates_formdata->addedfrom : '';
                                ?>
                                <?php echo render_select('addedfrom', $broker_data, ['staffid', ['firstname', 'lastname']], 'Select broker', $selected, ['data-width' => '100%', 'required'], [], 'no-mbot'); ?>
                                <?php echo form_error('addedfrom', '<div class="text-danger">', '</div>'); ?>
                            </div>
                            <div class="form-group" app-field-wrapper="checklist_order">
                                <label for="checklist_order" class="control-label">ID order</label>
                                <input type="number" id="checklist_order" name="checklist_order" class="form-control"
                                    placeholder="Please enter checklist order." value='<?php if (!empty($checklist_templates_formdata->order_no)) {
                                        echo $checklist_templates_formdata->order_no;
                                    } ?>' min="1">
                                <?php echo form_error('checklist_order', '<div class="text-danger">', '</div>'); ?>
                            </div>
                            <!--start render input comment -->
                            <!-- End render input comment -->
                            <?php if (!empty($checklist_templates_formdata->title)) {
                                $title = $checklist_templates_formdata->title;
                            } else {
                                $title = '';
                            } ?>
                            <div class="form-group" app-field-wrapper="name">
                                <label for="name" class="control-label">ID title</label>
                                <input type="text" id="name" name="name" class="form-control"
                                    placeholder="Please enter title ( ID back, Driving License )"
                                    value='<?php echo $title; ?>'>
                            </div>
                            <?php if (!empty($checklist_templates_formdata->description)) {
                                $checklist_templates_description = $checklist_templates_formdata->description;
                            } else {
                                $checklist_templates_description = '';
                            } ?>
                            <?php echo render_textarea('checklist_description', 'ID description', $checklist_templates_description, array('placeholder' => 'Please enter the checklist description')); ?>
                            <?php echo form_error('checklist_description', '<div class="text-danger">', '</div>'); ?>
                        </div>
                        <div class="col-md-6">
                            <?php
                            $imp_html = "<div class='form-group' app-field-wrapper='lead_status'><label for='lead_status' class='control-label'>File status</label>";
                            $imp_html .= "<select name='lead_status' id='lead_status' class='form-control selectpicker' data-width='100%' data-none-selected-text='Nothing selected' data-live-search='true' tabindex='-98'>";
                            // $imp_html .= "<option value=''>Nothing selected</option>";
                            if (!empty($checklist_templates_formdata->case_status)) {
                                $selectedOptions = [$checklist_templates_formdata->case_status - 1];
                            } else {
                                $selectedOptions = [0];
                            }
                            foreach ($lead_status_data as $key => $value) {
                                $selected = in_array($key, $selectedOptions) ? 'selected' : '';
                                $imp_html .= "<option value='{$value['id']}' $selected>$value[name]</option>";
                            }

                            $imp_html .= "</select></div>";
                            echo $imp_html;
                            ?>
                            <?php echo form_error('lead_status', '<div class="text-danger">', '</div>'); ?>
                        </div>

                        <div class="col-md-6">
                            <?php
                            $imp_html = "<div class='form-group' app-field-wrapper='doc_type'><label for='doc_type' class='control-label'>Doc Type</label>";
                            $imp_html .= "<select name='doc_type[]' id='doc_type' class='form-control selectpicker' data-width='100%' data-none-selected-text='Nothing selected' data-live-search='true' tabindex='-98' multiple>";
                            $imp_html .= "<option value=''>Nothing selected</option>";
                            $doc_array = [1 => 'Png', 2 => 'Pdf', 3 => 'Jpeg', 4 => 'Zip', 5 => 'HEIC'];
                            if (!empty($doc_id)) {
                                $selectedOptions = $doc_id;
                            } else {
                                $selectedOptions = [1, 2, 3, 4, 5];
                            }

                            foreach ($doc_array as $key => $value) {
                                $selected = in_array($key, $selectedOptions) ? 'selected' : '';
                                $imp_html .= "<option value='$value' $selected>$value</option>";
                            }
                            $imp_html .= "</select></div>";
                            echo $imp_html;
                            ?>
                            <!-- checklist item type -->
                            <?php
                            $imp_html = "<div class='form-group' id='div_Item_name' app-field-wrapper='Item_name'><label for='Item_name' class='control-label'>ID Type</label>";
                            $imp_html .= "<select name='Item_name[]' id='Item_name' class='form-control selectpicker' data-width='100%' data-none-selected-text='Nothing selected' data-live-search='true' tabindex='-98' multiple>";
                            $imp_html .= "<option value=''>Nothing selected</option>";
                            if (!empty($get_item_name_id)) {
                                $selectedOptions = $get_item_name_id;
                            } else {
                                $selectedOptions = [];
                            }
                            foreach ($checklist_item_type_data as $value) {
                                $selected = in_array($value['id'], $selectedOptions) ? 'selected' : '';
                                $imp_html .= "<option value='" . $value['id'] . "' $selected>" . $value['Item_name'] . "</option>";
                            }

                            $imp_html .= "</select></div>";
                            echo $imp_html;
                            echo form_error('Item_name[]', '<div class="text-danger">', '</div>');
                            ?>
                            <?php echo form_error('Item_name', '<div class="text-danger">', '</div>'); ?>
                            <!-- outstanding user type -->
                            <?php
                            if ($checklist_type === 'Client' || $checklist_type === 'client') {
                                $client_select = 'selected';
                                $ld_team_select = '';
                            }
                            else if ($checklist_type === 'Broker' || $checklist_type === 'broker') {
                                $client_select = '';
                                $ld_team_select = '';
                                $broker_select = 'selected';
                                $secure_charge_select = '';
                                $secure_private_charge_1_select = '';
                                $postponements_select = '';
                                $app_general_select = '';
                                $other_items_select = '';
                            } else if ($checklist_type === 'Other' || $checklist_type === 'other') {
                                $client_select = '';
                                $ld_team_select = '';
                                $broker_select = '';
                                $other_select = 'selected';
                                $secure_charge_select = '';
                                $secure_private_charge_1_select = '';
                                $postponements_select = '';
                                $app_general_select = '';
                                $other_items_select = '';
                            } else if ($checklist_type === 'secure_charge') {
                                $client_select = '';
                                $ld_team_select = '';
                                $broker_select = '';
                                $other_select = '';
                                $secure_charge_select = 'selected';
                                $secure_private_charge_1_select = '';
                                $postponements_select = '';
                                $app_general_select = '';
                                $other_items_select = '';
                            } else if ($checklist_type === 'secure_private_charge_1') {
                                $client_select = '';
                                $ld_team_select = '';
                                $broker_select = '';
                                $other_select = '';
                                $secure_charge_select = '';
                                $secure_private_charge_1_select = 'selected';
                                $postponements_select = '';
                                $app_general_select = '';
                                $other_items_select = '';
                            } else if ($checklist_type === 'postponements') {
                                $client_select = '';
                                $ld_team_select = '';
                                $broker_select = '';
                                $other_select = '';
                                $secure_charge_select = '';
                                $secure_private_charge_1_select = '';
                                $postponements_select = 'selected';
                                $app_general_select = '';
                                $other_items_select = '';
                            } else if ($checklist_type === 'app_general') {
                                $client_select = '';
                                $ld_team_select = '';
                                $broker_select = '';
                                $other_select = '';
                                $secure_charge_select = '';
                                $secure_private_charge_1_select = '';
                                $postponements_select = '';
                                $app_general_select = 'selected';
                                $other_items_select = '';
                            } else if ($checklist_type === 'other_items') {
                                $client_select = '';
                                $ld_team_select = '';
                                $broker_select = '';
                                $other_select = '';
                                $secure_charge_select = '';
                                $secure_private_charge_1_select = '';
                                $postponements_select = '';
                                $app_general_select = '';
                                $other_items_select = 'selected';
                            } else {
                                $client_select = '';
                                $ld_team_select = 'selected';
                                $secure_charge_select = '';
                                $secure_private_charge_1_select = '';
                                $postponements_select = '';
                                $other_items_select = '';
                                $app_general_select = '';
                                $broker_select = '';
                            }
                            $imp_html = "<div class='form-group' id='div_outstanding_type' app-field-wrapper='outstanding_type' style='display:block;'>";
                            $imp_html .= "<label for='outstanding_type' class='control-label'>Select User Type</label>";
                            $imp_html .= "<select name='outstanding_type' id='outstanding_type' class='form-control selectpicker' data-width='100%' data-none-selected-text='Nothing selected' data-live-search='true' tabindex='-98'>";
                            $imp_html .= "<option value='client' " . $client_select . ">Client</option>";
                            $imp_html .= "<option value='ld_team' " . $ld_team_select . ">LD-Team</option>";
                            $imp_html .= "<option value='broker' " . $broker_select . ">Broker</option>";
                            $imp_html .= "<option value='other' " . $other_select . ">Other</option>";
                            $imp_html .= "<option value='secure_charge' " . $secure_charge_select . ">Secure Charge</option>";
                            $imp_html .= "<option value='secure_private_charge_1' " . $secure_private_charge_1_select . ">Secure payout Private Charge</option>";
                            $imp_html .= "<option value='postponements' " . $postponements_select . ">Secure payout Postponements</option>";
                            $imp_html .= "<option value='app_general' " . $app_general_select . ">Secure payout General</option>";
                            $imp_html .= "<option value='other_items' " . $other_items_select . ">Secure payout Other items</option>";
                            $imp_html .= "</select></div>";

                            echo $imp_html;
                            ?>
                            <!-- instruaction line of code  -->
                            <?php if (!empty($instruction)) {
                                $checklist_templates_instruction = $instruction;
                            } else {
                                $checklist_templates_instruction = '';
                            } ?>

                            <?php if (!empty($instruction)) {
                                $checklist_templates_instruction = $instruction;
                            } else {
                                $checklist_templates_instruction = '';
                            } ?>
                            <?php echo form_error('doc_type', '<div class="text-danger">', '</div>'); ?>
                            <?php echo render_textarea('checklist_instruction', 'ID instruction', $checklist_templates_instruction, array('placeholder' => 'Please enter the checklist instruction')); ?>
                            <?php echo form_error('checklist_instruction', '<div class="text-danger">', '</div>'); ?>
                        </div>

                        <div class="clearfix"></div>
                        <div class="lead-edit">
                            <hr class="-tw-mx-4 tw-border-neutral-200" />
                            <button type="submit" class="btn btn-primary pull-right lead-save-btn"
                                id="lead-form-submit">
                                <?php if (!empty($id)) {
                                    echo 'Update';
                                } else {
                                    echo _l('save');
                                } ?>
                            </button>
                            <button type=" button" class="btn btn-default pull-right mright5" id="reset_from_checklist"
                                data-dismiss="modal">
                                <?php echo _l('Reset'); ?>
                            </button>
                        </div>
                        <?php echo form_close(); ?>
                        <div class="clearfix"></div>
                        <hr class="-tw-mx-4 tw-border-neutral-200" />
                        <div style="padding: 25px;">
                            <table class='table dt-table table-ticket-reports dt-inline dataTable no-footer'>
                                <thead>
                                    <tr>
                                        <th>ID Order</th>
                                        <th>File status</th>
                                        <th>Broker name</th>
                                        <th>ID Title</th>
                                        <th>ID Doc Type</th>
                                        <th>ID description</th>
                                        <th>ID Instruction</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody id='checklist_table'>
                                    <?php
                                    foreach ($checklist_templates as $value) {
                                        ?>
                                        <tr>
                                            <td>
                                                <?php echo $value['order_no']; ?>
                                            </td>
                                            <td>
                                                <?php echo get_status_name_by_using_status_id($this, $value['case_status']); ?>
                                            </td>
                                            <td>
                                                <?php echo get_staff_name_by_id($this, $value['addedfrom']) ?>
                                            </td>
                                            <td>
                                                <?php echo $value['title']; ?>
                                            </td>
                                            <td>
                                                <?php echo $value['doc_type']; ?>
                                            </td>
                                            <td>
                                                <?php echo $value['description']; ?>
                                            </td>
                                            <td>
                                                <?php
                                                $instructions = explode("\n", $value['instruction']);
                                                ?>
                                                <ul style="list-style-type: disc; padding-left: 20px;">
                                                    <?php foreach ($instructions as $instruction): ?>
                                                        <?php $trimmedInstruction = trim($instruction); ?>
                                                        <?php if (!empty($trimmedInstruction)): ?>
                                                            <li>
                                                                <?php echo htmlspecialchars($trimmedInstruction); ?>
                                                            </li>
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                </ul>
                                            </td>
                                            <td style="padding-left:18px;"><a href='#' class='delete-checklist-template'
                                                    data-id='<?php echo $value['id']; ?>'><i class='fa fa-trash'
                                                        style='color:red;'></i></a>
                                                <a href='<?php echo base_url('admin/cases/checklist_template/' . $value['id']); ?>'
                                                    class='' data-id=''><i class='fas fa-edit'
                                                        style='color:blue;margin-left:8px;'></i></a>
                                            </td>
                                        </tr>
                                    <?php } ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<style>
    .text-danger {
        color: red;
        font-weight: bold;
    }

    /* .is-invalid {
        border-color: red !important; 
    }
    label.error {
        color: red;
    } */
</style>
<script>
    $(document).ready(function () {
        var dataTable = $('.dataTable').DataTable();
        dataTable.order([[1, 'asc']]).draw();
        // reset the form for checklist
        var checklistForm = $('#checklist_form');
        // Event handler for the Reset button
        $('#reset_from_checklist').click(function () {
            checklistForm[0].reset();
        });
        // Initialize form validation
        $('#checklist_form').validate({
            rules: {
                checklist_order: {
                    required: true,
                },
                name: {
                    required: true,
                },
                lead_status: {
                    required: true,
                },
                doc_type: {
                    required: true,
                },
                // checklist_instruction: {
                //     required: true,
                // },
                // checklist_description: {
                //     required: true,
                // },
                // addedfrom: {
                //     required: true,
                // },
                // Item_name: {
                //     required: true,
                // }
            },
            messages: {
                checklist_order: {
                    required: 'This field is required.',
                },
                name: {
                    required: 'This field is required.',
                },
                lead_status: {
                    required: 'This field is required.',
                },
                doc_type: {
                    required: 'This field is required.',
                },
                // checklist_instruction: {
                //     required: 'This field is required.',
                // },
                // checklist_description: {
                //     required: 'This field is required.',
                // },
                // addedfrom: {
                //     required: 'This field is required.',
                // },
                // Item_name:{
                //     required: 'This field is required.',
                // }
            },
            errorClass: 'text-danger',
            errorElement: 'div',
            errorPlacement: function (error, element) {
                if (element.is('select')) {
                    error.insertAfter(element.closest('.form-group').find('.bootstrap-select'));
                } else {
                    error.insertAfter(element);
                }
                // if (element.is('select') && element.attr('name') === 'Item_name[]') {
                //     error.insertAfter($('#error_Item_name')); // Insert error after the error placeholder
                // } else {
                //     error.insertAfter(element);
                // }
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            },
            submitHandler: function (form) {
                // If form is valid, submit it
                form.submit();
            }
        });
    });

    // Delete the record from table and database
    $(document).on('click', '.delete-checklist-template', function (e) {
        e.preventDefault();

        var checklistId = $(this).data('id');
        // Store the reference to 'this' in a variable
        var $this = $(this);

        if (confirm('Are you sure you want to delete this record?')) {
            $.ajax({
                url: '<?php echo base_url('admin/leads/delete_checklist_template'); ?>',
                type: 'POST',
                data: { checklistId: checklistId },
                success: function (response) {
                    // Handle success response
                    alert_float('success', 'Checklist deleted successfully.');
                    // Use the stored reference to remove the table row
                    $this.closest('tr').fadeOut('slow', function () {
                        $(this).remove();
                    });
                },
                error: function (error) {
                    // Handle error response
                    alert_float('danger', 'Checklist not deleted, please try again.');
                }
            });
        }
    });
    // hide and show the item type and outstand user type
    // $(document).ready(function() {
    //     $('#lead_status').change(function() {
    //         var leadStatusId = $(this).val();
    //         if (leadStatusId == 1) {
    //             $('#div_Item_name').show();
    //             $('#div_outstanding_type').hide();
    //             $('#Item_name').prop('disabled', false);
    //             $('#outstanding_type').prop('disabled', true);
    //         } else if (leadStatusId == 3) {
    //             $('#div_outstanding_type').show();
    //             $('#div_Item_name').hide();
    //             $('#Item_name').prop('disabled', true);
    //             $('#outstanding_type').prop('disabled', false);
    //         } else {
    //             $('#div_Item_name').hide();
    //             $('#div_outstanding_type').hide();
    //             $('#Item_name').prop('disabled', false);
    //             $('#outstanding_type').prop('disabled', false);
    //         }
    //     });
    // });
</script>
</body>

</html>