<?php
// application/libraries/Slack.php

class Slack
{
    protected $accessToken;

    public function __construct()
    {
        // Initialize your Slack access token here
        // $this->accessToken = 'YOUR_SLACK_ACCESS_TOKEN';
    }
    public function sendnotification($message, $lead_id, $case_group = '', $case_name = '', $UserPerformAction = '') {
        $CI =& get_instance();
        $CI->load->helper('leads_helper');

        $url = "https://slack.com/api/chat.postMessage";
        if (base_url() == 'https://dev.platform.legaldirect.ca/') {
            $token = 'xoxb-7068539196497-7053017237733-aLT0HbSdB6k8x6dl3COfwFD2';
            $channelId = 'C071F7FQE4E';
            // live channel id
            // $channelId = 'C087HP01P8E';
            if($case_group == 'Ninja') {
                $channelId = 'C08FUJDML75';
            } if($case_group == 'Power'){
                $channelId = 'C08FL4E8V70';
            } if($case_group == 'Rocket'){
                $channelId = 'C08G4JEEGPK';
            }
        }else{
            $APP_ID = unlayer_extract(getenv('SLACK_APP_ID'), $_ENV['Slack_Lock_signature']);
            $Client_ID = unlayer_extract(getenv('SLACK_CLIENT_ID'), $_ENV['Slack_Lock_signature']);
            $Client_Secrect_ID   = unlayer_extract(getenv('SLACK_CLIENT_SECRECT_ID'), $_ENV['Slack_Lock_signature']);
            $Verification_Token = unlayer_extract(getenv('SLACK_VERIFICATION_TOKEN'), $_ENV['Slack_Lock_signature']);
            $token = unlayer_extract(getenv('SLACK_TOKEN'), $_ENV['Slack_Lock_signature']);

            if($case_group == 'Ninja') {
                $channelId = 'C03CT21RJAC';
            } if($case_group == 'Power'){
                $channelId = 'C0409EUTWKW';
            } if($case_group == 'Rocket'){
                $channelId = 'C0673S6RB5E';
            } if(empty($case_group)){ 
                $channelId = 'C08LDET1739';
            }
        }
            $case_url = admin_url('cases/index/') . $lead_id;
            $data = [
                "channel" => $channelId,
                "text" => 'File #' . $lead_id . '- <' . $case_url . '|' . $case_name . '>' . $message ,
            ];
    
            $headers = [
                "Content-Type: application/json",
                "Authorization: Bearer $token",
            ];
    
            $ch = curl_init($url);
    
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    
            $response = curl_exec($ch);
    
            if (curl_errno($ch)) {
                echo "cURL error: " . curl_error($ch) . "\n";
            } else {
                $responseDecoded = json_decode($response, true);
                if ($responseDecoded["ok"]) {
                    $USERNAME = (!empty($UserPerformAction) && $UserPerformAction == true) ? $case_name : get_staff_full_name();
                    $lead_activity_data = array(
                        'leadid' => $lead_id,
                        'description' => $USERNAME . ' performed an action and sent a Slack update: - ' . $data['text'],
                        'date' => date('Y-m-d H:i:s'),
                        'staffid' => (!empty($UserPerformAction) && $UserPerformAction == false) ? get_staff_user_id() : '',
                        'full_name' => $USERNAME
                    );
                    $CI->db->insert(db_prefix() . 'lead_activity_log', $lead_activity_data);

                    return true;
                } else {
                    echo "Error sending message to channel ID $channelId: " . $responseDecoded["error"] . "\n";
                }
            }
    
            curl_close($ch);
    }
    public function sendDirectnotification($message, $lead_id)
    {
        $bot_oauth_token = 'xoxb-7068539196497-7053017237733-aLT0HbSdB6k8x6dl3COfwFD2';
        $web_hooks_url = 'https://hooks.slack.com/services/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';
        $webhookUrl = 'https://hooks.slack.com/services/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';

        // Message to send

        // Channel or user ID to send the message to
        $channel = 'D071QBS24GL';
        // back case url 
        $case_url = admin_url('cases/index/') . $lead_id;
        // Slack payload data
        $payload = [
            'text' => $message . ' Please <' . $case_url . '|Clicking here> to see his response.',
            'channel' => $channel,
        ];

        // cURL initialization
        $curl = curl_init();

        // Set cURL options
        curl_setopt_array($curl, [
            CURLOPT_URL => $webhookUrl,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode($payload),
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
            ],
        ]);

        // Execute cURL request
        $response = curl_exec($curl);

        // Check for errors
        if ($response === false) {
            $error = curl_error($curl);
            echo "Error sending notification: " . $error;
        } else {
        }

        // Close cURL session
        curl_close($curl);
    }
    // send notification the single user
    public function send_notification($email,$message) {
        // Bot OAuth token obtained from Slack App
        $bot_oauth_token = 'xoxb-7068539196497-7053017237733-aLT0HbSdB6k8x6dl3COfwFD2';

        // Verify that the bot token has the necessary scopes
        // $required_scopes = 'users:read chat:write';
        // $token_scopes = $this->verify_token_scopes($bot_oauth_token, $required_scopes);
        // print_r($token_scopes);
        // // Check if all required scopes are present
        // if ($token_scopes === false) {
        //     echo "Error: The bot token is missing required scopes.";
        //     return;
        // }

        // Slack API endpoint for retrieving user list
        $api_url = 'https://slack.com/api/users.list';

        // Set cURL options to fetch user list
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => $api_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $bot_oauth_token
            ]
        ]);

        // Execute cURL request to fetch user list
        $response = curl_exec($curl);
        // Check for errors
        if ($response === false) {
            $error = curl_error($curl);
            echo "Error retrieving user list: " . $error;
        } else {
            // Parse the JSON response
            $data = json_decode($response, true);
            // Check if the response was successful
            if ($data['ok']) {
                // Iterate through the list of users
                foreach ($data['members'] as $user) {
                    // Check if this is the user you're looking for
                    // For example, checking if the user's email matches
                    if (isset($user['profile']['email']) && $user['profile']['email'] ===  $email) {
                        $recipient_user_id = $user['id'];
                        // Message to send
                        // Slack API endpoint for sending messages
                        $api_url = 'https://slack.com/api/chat.postMessage';

                        // Slack payload data
                        $payload = [
                            'token' => $bot_oauth_token,
                            'channel' => $recipient_user_id,
                            'text' => $message
                        ];

                        // Set cURL options to send the notification
                        curl_setopt_array($curl, [
                            CURLOPT_URL => $api_url,
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_POST => true,
                            CURLOPT_POSTFIELDS => http_build_query($payload),
                            CURLOPT_HTTPHEADER => [
                                'Content-Type: application/x-www-form-urlencoded'
                            ]
                        ]);

                        // Execute cURL request to send the notification
                        $response = curl_exec($curl);
                        // Check for errors
                        if ($response === false) {
                            $error = curl_error($curl);
                            print_r($error);
                        } else {
                        }
                    }
                }
            } 
        }

        // Close cURL session
        curl_close($curl);
    }
    // public function send_notification($emails, $message)
    // {
    //     // Convert $emails to an array if it's a string
    //     if (!is_array($emails)) {
    //         $emails = [$emails];
    //     }

    //     // Bot OAuth token obtained from Slack App
    //     $bot_oauth_token = 'xoxb-7068539196497-7053017237733-aLT0HbSdB6k8x6dl3COfwFD2';

    //     // Slack API endpoint for sending messages
    //     $api_url_send_message = 'https://slack.com/api/chat.postMessage';

    //     // Array to store recipient user IDs
    //     $recipient_user_ids = [];

    //     // Iterate through each email to find corresponding user IDs
    //     foreach ($emails as $email) {
    //         $user_id = $this->get_user_id_by_email($email, $bot_oauth_token);
    //         if ($user_id) {
    //             $recipient_user_ids[] = $user_id;
    //         }
    //     }

    //     // If there are recipient user IDs, send notifications
    //     if (!empty ($recipient_user_ids)) {
    //         // Slack payload data for batch message
    //         $payload = [
    //             'token' => $bot_oauth_token,
    //             'text' => $message,
    //             'channel' => implode(',', $recipient_user_ids) // Concatenate user IDs with commas
    //         ];

    //         // Set up cURL for sending messages
    //         $curl_send_message = curl_init();
    //         curl_setopt_array($curl_send_message, [
    //             CURLOPT_URL => $api_url_send_message,
    //             CURLOPT_RETURNTRANSFER => true,
    //             CURLOPT_POST => true,
    //             CURLOPT_POSTFIELDS => http_build_query($payload),
    //             CURLOPT_HTTPHEADER => [
    //                 'Content-Type: application/x-www-form-urlencoded'
    //             ]
    //         ]);

    //         // Execute cURL request to send the batch notification
    //         $response = curl_exec($curl_send_message);

    //         // Check for errors
    //         if ($response === false) {
    //             $error = curl_error($curl_send_message);
    //             echo "Error sending message: " . $error;
    //             return;
    //         }

    //         // Close cURL session for sending messages
    //         curl_close($curl_send_message);
    //     } else {
    //         echo "No recipients found.";
    //     }
    // }

    // // Function to get user ID by email
    // private function get_user_id_by_email($email, $bot_oauth_token)
    // {
    //     // Slack API endpoint for retrieving user list
    //     $api_url_users_list = 'https://slack.com/api/users.list';

    //     // Set up cURL for fetching user list
    //     $curl_users_list = curl_init();
    //     curl_setopt_array($curl_users_list, [
    //         CURLOPT_URL => $api_url_users_list,
    //         CURLOPT_RETURNTRANSFER => true,
    //         CURLOPT_HTTPHEADER => [
    //             'Authorization: Bearer ' . $bot_oauth_token
    //         ]
    //     ]);

    //     // Execute cURL request to fetch user list
    //     $response = curl_exec($curl_users_list);

    //     // Check for errors
    //     if ($response === false) {
    //         $error = curl_error($curl_users_list);
    //         echo "Error retrieving user list: " . $error;
    //         return false;
    //     }

    //     // Parse the JSON response
    //     $data = json_decode($response, true);

    //     // Check if the response was successful
    //     if (!$data['ok']) {
    //         echo "Error: " . $data['error'];
    //         return false;
    //     }

    //     // Iterate through the list of users
    //     foreach ($data['members'] as $user) {
    //         // Check if this user's email matches the specified email
    //         if (isset ($user['profile']['email']) && $user['profile']['email'] === $email) {
    //             // Return the user's ID
    //             return $user['id'];
    //         }
    //     }

    //     // If user not found, return false
    //     return false;
    // }


    private function verify_token_scopes($token, $required_scopes)
    {
        // Slack API endpoint for checking token scopes
        $api_url = 'https://slack.com/api/auth.test';

        // Set cURL options to check token scopes
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => $api_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token
            ]
        ]);

        // Execute cURL request to check token scopes
        $response = curl_exec($curl);

        // Check for errors
        if ($response === false) {
            $error = curl_error($curl);
            echo "Error checking token scopes: " . $error;
            return false;
        } else {
            // Parse the JSON response
            $data = json_decode($response, true);

            // Check if the response was successful and if the token contains all required scopes
            if ($data['ok']) {
                $provided_scopes = explode(' ', $data['scope']);
                $required_scopes = explode(' ', $required_scopes);
                $missing_scopes = array_diff($required_scopes, $provided_scopes);
                if (empty ($missing_scopes)) {
                    return true; // Token has all required scopes
                } else {
                    echo "Error: The bot token is missing required scopes: " . implode(', ', $missing_scopes);
                    return false;
                }
            } else {
                echo "Error: " . $data['error'];
                return false;
            }
        }

        // Close cURL session
        curl_close($curl);
    }


}
